/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.core.utilities;

import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import java.math.BigInteger;

public class Variants {
    private Variants() {
    }

    public static Variant makeInt16(short value) {
        return Variants.makeVariant(5, value);
    }

    public static Variant makeInt32(int value) {
        return Variants.makeVariant(6, value);
    }

    public static Variant makeInt64(long value) {
        return Variants.makeVariant(7, value);
    }

    public static Variant makeUInt16(char value) {
        return Variants.makeVariant(2, Character.valueOf(value));
    }

    public static Variant makeUInt32(long value) throws NumericOverflowException {
        return Variants.makeVariantCheckOverflow(3, value);
    }

    public static Variant makeUInt64(long value) throws NumericOverflowException {
        return Variants.makeVariantCheckOverflow(4, value);
    }

    public static Variant makeUInt64(BigInteger value) throws NumericOverflowException {
        return Variants.makeVariantCheckOverflow(4, value);
    }

    public static Variant makeNull() {
        return Variants.makeVariant(8, null);
    }

    public static Variant makeWString(String value) {
        return Variants.makeVariant(0, value);
    }

    private static Variant makeVariantCheckOverflow(int type, Object value) throws NumericOverflowException {
        try {
            return new Variant(type, value);
        }
        catch (IncorrectTypeException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Variant makeVariant(int type, Object value) {
        try {
            return new Variant(type, value);
        }
        catch (IncorrectTypeException e) {
            throw new AssertionError((Object)e);
        }
        catch (NumericOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }
}

