/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

public class DSITimeSpan
implements Cloneable {
    private int m_intervalType;
    private int m_day = 0;
    private int m_hour = 0;
    private int m_minute = 0;
    private int m_second = 0;
    private int m_fraction = 0;
    private boolean m_isNegative = false;

    public DSITimeSpan(int intervalType, int day, int hour, int minute, int second, int fraction, boolean isNegative) {
        this.validate(day, hour, minute, second);
        this.m_intervalType = intervalType;
        this.m_day = day;
        this.m_hour = hour;
        this.m_minute = minute;
        this.m_second = second;
        this.m_fraction = fraction;
        this.m_isNegative = isNegative;
    }

    public int getDay() {
        return this.m_day;
    }

    public int getFraction() {
        return this.m_fraction;
    }

    public int getHour() {
        return this.m_hour;
    }

    public int getIntervalType() {
        return this.m_intervalType;
    }

    public int getMinute() {
        return this.m_minute;
    }

    public int getSecond() {
        return this.m_second;
    }

    public boolean isNegative() {
        return this.m_isNegative;
    }

    public void setDay(int day) {
        this.validate(day, this.m_hour, this.m_minute, this.m_second);
        this.m_day = day;
    }

    public void setFraction(int fraction) {
        this.m_fraction = fraction;
    }

    public void setHour(int hour) {
        this.validate(this.m_day, hour, this.m_minute, this.m_second);
        this.m_hour = hour;
    }

    public void setIsNegative(boolean isNegative) {
        this.m_isNegative = isNegative;
    }

    public void setMinute(int minute) {
        this.validate(this.m_day, this.m_hour, minute, this.m_second);
        this.m_minute = minute;
    }

    public void setSecond(int second) {
        this.validate(this.m_day, this.m_hour, this.m_minute, second);
        this.m_second = second;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("");
        if (this.m_isNegative) {
            builder.append("-");
        }
        builder.append(String.valueOf(this.m_day)).append(" ");
        builder.append(String.valueOf(this.m_hour)).append(":");
        builder.append(String.valueOf(this.m_minute)).append(":");
        builder.append(String.valueOf(this.m_second)).append(".");
        String fraction = String.valueOf(this.m_fraction);
        for (int i = 9 - fraction.length(); i > 0; --i) {
            builder.append("0");
        }
        builder.append(fraction);
        return builder.toString();
    }

    private void validate(int day, int hour, int minute, int second) {
        boolean checkSecond;
        boolean checkHour = day != 0;
        boolean checkMinute = checkHour || hour != 0;
        boolean bl = checkSecond = checkMinute || minute != 0;
        if (checkHour && (0 > hour || 23 < hour)) {
            throw new IllegalArgumentException("Invalid hour value.");
        }
        if (checkMinute && (0 > minute || 59 < minute)) {
            throw new IllegalArgumentException("Invalid minute value.");
        }
        if (checkSecond && (0 > second || 59 < second)) {
            throw new IllegalArgumentException("Invalid second value.");
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_day;
        result = 31 * result + this.m_fraction;
        result = 31 * result + this.m_hour;
        result = 31 * result + this.m_intervalType;
        result = 31 * result + (this.m_isNegative ? 1231 : 1237);
        result = 31 * result + this.m_minute;
        result = 31 * result + this.m_second;
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DSITimeSpan)) {
            return false;
        }
        DSITimeSpan otherSpan = (DSITimeSpan)other;
        return this.m_isNegative == otherSpan.m_isNegative && this.m_day == otherSpan.m_day && this.m_hour == otherSpan.m_hour && this.m_minute == otherSpan.m_minute && this.m_second == otherSpan.m_second && this.m_fraction == otherSpan.m_fraction && this.m_intervalType == otherSpan.m_intervalType;
    }
}

