/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.dataengine.interfaces.IArray;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SArray;
import com.vertica.jdbc.common.SResultSetMetaData;
import com.vertica.jdbc.common.SStatement;
import com.vertica.jdbc.common.SWarningListener;
import com.vertica.jdbc.common.utilities.WrapperUtilities;
import com.vertica.streams.IStream;
import com.vertica.streams.resultset.AsciiStream;
import com.vertica.streams.resultset.BinaryStream;
import com.vertica.streams.resultset.CharacterStream;
import com.vertica.streams.resultset.UnicodeStream;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.CursorPosition;
import com.vertica.utilities.FunctionID;
import com.vertica.utilities.JDBCVersion;
import com.vertica.utilities.TypeNames;
import com.vertica.utilities.conversion.TypeConverter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class SForwardResultSet
implements ResultSet {
    protected ILogger m_logger = null;
    protected SResultSetMetaData m_resultMetaData = null;
    protected long m_currentRow = 0L;
    protected IStream m_currentStream = null;
    protected boolean m_isOpen = true;
    protected IResultSet m_resultSet = null;
    protected List<? extends IColumn> m_resultSetColumns = null;
    protected SWarningListener m_warningListener = null;
    protected boolean m_wasLastValueNull = false;
    protected List<DataWrapper> m_cachedDataWrappers = null;
    private CursorPosition m_cursorPosition = CursorPosition.BEFORE_FIRST;
    private List<String> m_columnNameIndexes = null;
    private int m_numColumns;
    private final boolean m_canCallHasMoreRows;
    protected SStatement m_parentStatement = null;
    protected JDBCVersion m_jdbcVersion;
    protected int m_streamBufferSize;
    protected final int m_maxRows;

    protected SForwardResultSet(SStatement statement, IResultSet resultSet, ILogger logger) throws SQLException {
        try {
            this.m_logger = logger;
            LogUtilities.logFunctionEntrance(this.m_logger, statement, resultSet, logger);
            this.m_isOpen = true;
            this.m_parentStatement = statement;
            this.m_resultSet = resultSet;
            this.m_warningListener = new SWarningListener(DSIDriverSingleton.getInstance().getMessageSource(), null);
            if (null != statement) {
                this.m_streamBufferSize = this.getStreamBufferSize();
                this.m_warningListener.setLocale(statement.getParentConnection().getDSIConnection().getLocale());
                this.m_maxRows = statement.getMaxRows();
            } else {
                this.m_maxRows = 0;
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            if (null != this.m_resultSet) {
                this.m_resultSet.registerWarningListener(this.m_warningListener);
                this.m_canCallHasMoreRows = resultSet.supportsHasMoreRows();
            } else {
                this.m_canCallHasMoreRows = false;
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, row);
            this.checkIfOpen();
            if (row > 0 && (long)row >= this.m_currentRow) {
                while (this.m_currentRow < (long)row) {
                    if (this.next()) continue;
                    return false;
                }
                return !this.isAfterLast();
            }
            if (1003 == this.getType()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (1003 == this.getType()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (1003 == this.getType()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_warningListener.clear();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_isOpen = false;
        if (null != this.m_resultSet) {
            this.m_resultSet.close();
            this.m_resultSet = null;
        }
        if (null != this.m_parentStatement) {
            this.m_parentStatement.markResultSetClosed(this);
            this.m_parentStatement = null;
        }
        if (null != this.m_resultMetaData) {
            this.m_resultMetaData = null;
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnName);
            this.checkIfOpen();
            int columnIndex = this.m_columnNameIndexes.indexOf(columnName.toUpperCase(Locale.ENGLISH));
            if (-1 == columnIndex) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_NAME, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, columnName);
            }
            return columnIndex + 1;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean first() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (1003 == this.getType()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                IArray dsiArray = data.getArray();
                this.m_wasLastValueNull = data.isNull();
                if (data.isNull()) {
                    return null;
                }
                return this.createArrayResult(dsiArray);
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(2003));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Array getArray(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getArray(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, 0L);
            if (TypeConverter.canConvertStreamFrom(data.getType(), -1)) {
                this.m_wasLastValueNull = data.isNull();
                if (data.isNull()) {
                    return null;
                }
                AsciiStream stream = new AsciiStream(this.m_resultSet, columnIndex - 1, this.m_streamBufferSize);
                this.m_currentStream = stream;
                return stream;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), "AsciiStream");
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                this.m_wasLastValueNull = data.isNull();
                return TypeConverter.toBigDecimal(data, this.m_warningListener);
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(2));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, scale);
        BigDecimal bigDec = this.getBigDecimal(columnIndex);
        if (null != bigDec) {
            return bigDec.setScale(scale, RoundingMode.HALF_UP);
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, scale);
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, 0L);
            if (TypeConverter.canConvertStreamFrom(data.getType(), -4)) {
                this.m_wasLastValueNull = data.isNull();
                if (data.isNull()) {
                    return null;
                }
                BinaryStream stream = new BinaryStream(this.m_resultSet, columnIndex - 1, this.m_streamBufferSize);
                this.m_currentStream = stream;
                return stream;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), "BinaryStream");
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Blob getBlob(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getBlob(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                this.m_wasLastValueNull = data.isNull();
                return TypeConverter.toBoolean(data, this.m_warningListener);
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(16));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                this.m_wasLastValueNull = data.isNull();
                return TypeConverter.toByte(data, this.m_warningListener);
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(-6));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                this.m_wasLastValueNull = data.isNull();
                return TypeConverter.toBytes(data);
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(-2));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, 0L);
            if (TypeConverter.canConvertStreamFrom(data.getType(), -1)) {
                this.m_wasLastValueNull = data.isNull();
                if (data.isNull()) {
                    return null;
                }
                CharacterStream stream = new CharacterStream(this.m_resultSet, columnIndex - 1, this.m_streamBufferSize);
                this.m_currentStream = stream;
                return stream;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), "CharacterStream");
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Clob getClob(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getClob(this.findColumn(columnName));
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1007;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_parentStatement.getStatement().getCursorName();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                Date value = TypeConverter.toDate(data, this.m_warningListener);
                this.m_wasLastValueNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(91));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, cal);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                Date value = TypeConverter.toDate(data, cal, this.m_warningListener);
                this.m_wasLastValueNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(91));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, cal);
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                this.m_wasLastValueNull = data.isNull();
                return TypeConverter.toDouble(data, this.m_warningListener);
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(8));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1000;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_resultSet.getFetchSize();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                this.m_wasLastValueNull = data.isNull();
                return TypeConverter.toFloat(data, this.m_warningListener);
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(7));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                this.m_wasLastValueNull = data.isNull();
                return TypeConverter.toInt(data, this.m_warningListener);
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(4));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getInt(this.findColumn(columnName));
    }

    public ILogger getLogger() {
        return this.m_logger;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                this.m_wasLastValueNull = data.isNull();
                return TypeConverter.toLong(data, this.m_warningListener);
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(-5));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                IColumn col = this.m_resultSetColumns.get(columnIndex - 1);
                if (2003 == col.getTypeMetadata().getType()) {
                    return this.getArray(columnIndex);
                }
                Object value = TypeConverter.toObject(data, col.getTypeMetadata(), this.m_warningListener);
                this.m_wasLastValueNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(2000));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, map);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public Object getObject(String columnName, Map<String, Class<?>> map) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, map);
        return this.getObject(this.findColumn(columnName), map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Ref getRef(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getRef(this.findColumn(columnName));
    }

    protected List<? extends IColumn> getResultSetColumns() {
        return this.m_resultSetColumns;
    }

    protected SResultSetMetaData getResultSetMetaData() {
        return this.m_resultMetaData;
    }

    @Override
    public int getRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (CursorPosition.AFTER_LAST == this.m_cursorPosition || CursorPosition.BEFORE_FIRST == this.m_cursorPosition) {
                return 0;
            }
            return (int)this.m_currentRow;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    public long getRowCount() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_resultSet.getRowCount();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                this.m_wasLastValueNull = data.isNull();
                return TypeConverter.toShort(data, this.m_warningListener);
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(5));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public Statement getStatement() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_parentStatement;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                this.m_wasLastValueNull = data.isNull();
                IColumn col = this.m_resultSetColumns.get(columnIndex - 1);
                return TypeConverter.toString(data, col.getTypeMetadata());
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(12));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getString(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                IColumn col = this.m_resultSetColumns.get(columnIndex - 1);
                Time value = TypeConverter.toTime(data, col.getTypeMetadata(), this.m_warningListener);
                this.m_wasLastValueNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(92));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                IColumn col = this.m_resultSetColumns.get(columnIndex - 1);
                Time value = TypeConverter.toTime(data, cal, col.getTypeMetadata(), this.m_warningListener);
                this.m_wasLastValueNull = data.isNull();
                return value;
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(92));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, cal);
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                this.m_wasLastValueNull = data.isNull();
                IColumn col = this.m_resultSetColumns.get(columnIndex - 1);
                return TypeConverter.toTimestamp(data, col.getTypeMetadata(), this.m_warningListener);
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(93));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, cal);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, -1L);
            try {
                this.m_wasLastValueNull = data.isNull();
                IColumn col = this.m_resultSetColumns.get(columnIndex - 1);
                return TypeConverter.toTimestamp(data, cal, col.getTypeMetadata(), this.m_warningListener);
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), TypeNames.getTypeName(93));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, cal);
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    @Override
    public int getType() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1003;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.closeCurrentStream();
            DataWrapper data = this.getData(columnIndex, 0L);
            if (TypeConverter.canConvertStreamFrom(data.getType(), -1)) {
                this.m_wasLastValueNull = data.isNull();
                if (data.isNull()) {
                    return null;
                }
                UnicodeStream stream = new UnicodeStream(this.m_resultSet, columnIndex - 1, this.m_streamBufferSize);
                this.m_currentStream = stream;
                return stream;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(columnIndex), "UnicodeStream");
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        return this.getURL(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_warningListener.getSQLWarnings();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    public SWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return CursorPosition.AFTER_LAST == this.m_cursorPosition;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return CursorPosition.BEFORE_FIRST == this.m_cursorPosition;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return CursorPosition.AT_FIRST == this.m_cursorPosition || CursorPosition.AT_FIRST_AT_LAST == this.m_cursorPosition;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        if (!this.m_canCallHasMoreRows) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        return CursorPosition.AT_LAST == this.m_cursorPosition || CursorPosition.AT_FIRST_AT_LAST == this.m_cursorPosition;
    }

    @Override
    public boolean last() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (1003 == this.getType()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean next() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (null == this.m_resultSet) {
                return false;
            }
            boolean moveSuccess = this.isBelowRowLimit() && this.m_resultSet.moveToNextRow();
            this.updateCursorPosition(moveSuccess);
            ++this.m_currentRow;
            this.m_warningListener.clear();
            return moveSuccess;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (1003 == this.getType()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.getType() == 1003) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (CursorPosition.BEFORE_FIRST == this.m_cursorPosition || CursorPosition.AFTER_LAST == this.m_cursorPosition) {
                return false;
            }
            return this.m_resultSet.rowDeleted();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (CursorPosition.BEFORE_FIRST == this.m_cursorPosition || CursorPosition.AFTER_LAST == this.m_cursorPosition) {
                return false;
            }
            return this.m_resultSet.rowInserted();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (CursorPosition.BEFORE_FIRST == this.m_cursorPosition || CursorPosition.AFTER_LAST == this.m_cursorPosition) {
                return false;
            }
            return this.m_resultSet.rowUpdated();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, direction);
            this.checkIfOpen();
            switch (direction) {
                case 1000: 
                case 1001: 
                case 1002: {
                    break;
                }
                default: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_FETCH_DIRECTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(direction));
                }
            }
            if (1003 == this.getType() && 1000 != direction) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, rows);
            this.checkIfOpen();
            if (rows < 0) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FETCH_SIZE, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(rows), String.valueOf(0), String.valueOf(Integer.MAX_VALUE));
            }
            this.m_resultSet.setFetchSize(rows);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateArray(int columnIndex, Array columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateArray(String columnName, Array columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
            this.updateArray(this.findColumn(columnName), columnValue);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream columnValue, int length) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue, length);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream columnValue, int length) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue, length);
        this.updateAsciiStream(this.findColumn(columnName), columnValue, length);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
        this.updateBigDecimal(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream columnValue, int length) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, length);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream columnValue, int length) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue, length);
        this.updateBinaryStream(this.findColumn(columnName), columnValue, length);
    }

    @Override
    public void updateBlob(int columnIndex, Blob columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBlob(String columnName, Blob columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
        this.updateBlob(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBoolean(String columnName, boolean columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
        this.updateBoolean(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateByte(int columnIndex, byte columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateByte(String columnName, byte columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
        this.updateByte(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBytes(String columnName, byte[] columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
        this.updateBytes(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader columnValue, int length) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue, length);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateCharacterStream(String columnName, Reader columnValue, int length) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue, length);
        this.updateCharacterStream(this.findColumn(columnName), columnValue, length);
    }

    @Override
    public void updateClob(int columnIndex, Clob columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateClob(String columnName, Clob columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
        this.updateClob(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateDate(int columnIndex, Date columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateDate(String columnName, Date columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
        this.updateDate(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateDouble(int columnIndex, double columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateDouble(String columnName, double columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
        this.updateDouble(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateFloat(int columnIndex, float columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, Float.valueOf(columnValue));
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateFloat(String columnName, float columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, Float.valueOf(columnValue));
        this.updateFloat(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateInt(int columnIndex, int columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateInt(String columnName, int columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
        this.updateInt(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateLong(int columnIndex, long columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateLong(String columnName, long columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
        this.updateLong(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName);
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateObject(int columnIndex, Object columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateObject(int columnIndex, Object columnValue, int scale) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue, scale);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateObject(String columnName, Object columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
        this.updateObject(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateObject(String columnName, Object columnValue, int scale) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue, scale);
        this.updateObject(this.findColumn(columnName), columnValue, scale);
    }

    @Override
    public void updateRef(int columnIndex, Ref columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateRef(String columnName, Ref columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
        this.updateRef(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateShort(int columnIndex, short columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateShort(String columnName, short columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
        this.updateShort(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateString(int columnIndex, String columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateString(String columnName, String columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
        this.updateString(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateTime(int columnIndex, Time columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateTime(String columnName, Time columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
        this.updateTime(this.findColumn(columnName), columnValue);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp columnValue) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, columnValue);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp columnValue) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnName, columnValue);
        this.updateTimestamp(this.findColumn(columnName), columnValue);
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_wasLastValueNull;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_parentStatement.getResultSetHoldability();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex);
        this.checkIfOpen();
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel);
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex);
        this.checkIfOpen();
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel);
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex);
        this.checkIfOpen();
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel);
        return this.getNString(this.findColumn(columnLabel));
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex);
        this.checkIfOpen();
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel);
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex);
        this.checkIfOpen();
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel);
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public boolean isClosed() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return !this.m_isOpen;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return WrapperUtilities.isWrapperFor(iface, this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return WrapperUtilities.unwrap(iface, this);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException, SQLFeatureNotSupportedException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, x);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException, SQLFeatureNotSupportedException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, x, length);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnLabel, x);
        this.updateAsciiStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnLabel, x, length);
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException, SQLFeatureNotSupportedException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, x);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException, SQLFeatureNotSupportedException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, x, length);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnLabel, x);
        this.updateBinaryStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnLabel, x, length);
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, inputStream);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, inputStream, length);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, inputStream);
        this.updateBlob(this.findColumn(columnLabel), inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, inputStream, length);
        this.updateBlob(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException, SQLFeatureNotSupportedException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, x);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException, SQLFeatureNotSupportedException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, columnIndex, x, length);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(columnIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnLabel, reader);
        this.updateCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.m_logger, columnLabel, reader, length);
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, reader);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, reader, length);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, reader);
        this.updateClob(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, reader, length);
        this.updateClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, x);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, x, length);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, reader);
        this.updateNCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, reader, length);
        this.updateNCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, nClob);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, reader);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, reader, length);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, nClob);
        this.updateNClob(this.findColumn(columnLabel), nClob);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, reader);
        this.updateNClob(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, reader, length);
        this.updateNClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, nString);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, nString);
        this.updateNString(this.findColumn(columnLabel), nString);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, x);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, x);
        this.updateRowId(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnIndex, xmlObject);
        this.checkIfOpen();
        this.checkIfValidColumnNumber(columnIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), columnLabel, xmlObject);
        this.updateSQLXML(this.findColumn(columnLabel), xmlObject);
    }

    protected void initializeResultSetColumns() throws ErrorException {
        this.m_resultSetColumns = this.m_resultSet.getSelectColumns();
    }

    protected void setResultSetMetadata(SResultSetMetaData resultMetaData) {
        this.m_resultMetaData = resultMetaData;
    }

    protected void initializeColumnNameMap() throws SQLException {
        if (null == this.m_columnNameIndexes) {
            this.m_columnNameIndexes = new ArrayList<String>();
            this.m_cachedDataWrappers = new ArrayList<DataWrapper>();
            this.m_numColumns = this.getMetaData().getColumnCount();
            for (int i = 0; i < this.m_numColumns; ++i) {
                this.m_columnNameIndexes.add(this.m_resultSetColumns.get(i).getName().toUpperCase(Locale.ENGLISH));
                this.m_cachedDataWrappers.add(new DataWrapper());
                if (null == this.m_resultSet) continue;
                this.m_resultSet.setDataNeeded(i, true);
            }
        }
    }

    protected synchronized void checkIfOpen() throws SQLException {
        if (!this.m_isOpen) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.RESULTSET_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        if (null == this.m_parentStatement) {
            this.close();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARENT_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
    }

    protected void checkIfValidColumnNumber(int columnIndex) throws SQLException {
        if (1 > columnIndex || this.m_numColumns < columnIndex) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_INDEX, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(columnIndex));
        }
    }

    protected void checkIfValidRowNumber() throws SQLException {
        if (0L == this.m_currentRow) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CURSOR_BEFORE_FIRST_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        if (CursorPosition.AFTER_LAST == this.m_cursorPosition) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CURSOR_AFTER_LAST_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
    }

    protected void closeCurrentStream() throws SQLException {
        if (null == this.m_currentStream) {
            return;
        }
        try {
            this.m_currentStream.close();
            this.m_currentStream = null;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
    }

    protected SArray createArrayResult(IArray array) throws SQLException {
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.FEATURE_NOT_SUPPORTED, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, "getArray");
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    protected DataWrapper getData(int columnIndex, long fetchSize) throws SQLException {
        this.checkIfValidColumnNumber(columnIndex);
        this.checkIfValidRowNumber();
        --columnIndex;
        try {
            DataWrapper data = this.m_cachedDataWrappers.get(columnIndex);
            this.m_resultSet.getData(columnIndex, 0L, fetchSize, data);
            return data;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
    }

    private void updateCursorPosition(boolean moveSuccess) throws SQLException, ErrorException {
        HAS_MORE_ROWS hasMoreRows = null;
        if (!moveSuccess) {
            this.m_cursorPosition = CursorPosition.AFTER_LAST;
            return;
        }
        hasMoreRows = this.m_canCallHasMoreRows ? (this.m_resultSet.hasMoreRows() ? HAS_MORE_ROWS.TRUE : HAS_MORE_ROWS.FALSE) : HAS_MORE_ROWS.UNKNOWN;
        switch (this.m_cursorPosition) {
            case BEFORE_FIRST: {
                if (HAS_MORE_ROWS.FALSE != hasMoreRows) {
                    this.m_cursorPosition = CursorPosition.AT_FIRST;
                    break;
                }
                this.m_cursorPosition = CursorPosition.AT_FIRST_AT_LAST;
                break;
            }
            case AT_FIRST: {
                if (HAS_MORE_ROWS.TRUE == hasMoreRows) {
                    this.m_cursorPosition = CursorPosition.DURING;
                    break;
                }
                if (HAS_MORE_ROWS.FALSE == hasMoreRows) {
                    this.m_cursorPosition = CursorPosition.AT_LAST;
                    break;
                }
                this.m_cursorPosition = CursorPosition.UNKNOWN;
                break;
            }
            case UNKNOWN: 
            case DURING: {
                if (HAS_MORE_ROWS.FALSE != hasMoreRows) break;
                this.m_cursorPosition = CursorPosition.AT_LAST;
                break;
            }
            case AT_LAST: 
            case AT_FIRST_AT_LAST: {
                if (HAS_MORE_ROWS.TRUE == hasMoreRows) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_CURSOR_TRANSITION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                this.m_cursorPosition = CursorPosition.AFTER_LAST;
                break;
            }
            case AFTER_LAST: {
                break;
            }
            default: {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_CURSOR_TRANSITION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, this.m_cursorPosition.toString());
            }
        }
    }

    protected IConnection getParentConnection() throws SQLException {
        return this.m_parentStatement.getParentConnection().getConnection();
    }

    protected int getStreamBufferSize() throws SQLException {
        try {
            IConnection parentConn = this.getParentConnection();
            int value = parentConn.getProperty(1007).getInt();
            return value > 0 ? value : 32000;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    private boolean isBelowRowLimit() {
        return this.m_maxRows == 0 || this.m_currentRow < (long)this.m_maxRows;
    }

    private static enum HAS_MORE_ROWS {
        TRUE,
        FALSE,
        UNKNOWN;

    }
}

