/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import com.vertica.dataengine.ColumnDescription;
import com.vertica.dsi.dataengine.impl.DSIArray;
import com.vertica.dsi.dataengine.interfaces.IArray;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.shaded.google.gson.JsonArray;
import com.vertica.shaded.google.gson.JsonElement;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.util.TypeUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class VerticaArray
extends DSIArray {
    private static final String NULL_ARRAY_ELEMENT = "null";
    private final JsonArray m_jsonArray;
    protected final Object[] m_dataArray;
    protected final int m_length;
    private final ColumnDescription m_arrayColumn;
    private final Class<?> m_arrayClass;
    private final ColumnDescription m_baseArrayColumn;
    private final int m_baseColumnType;
    private final ColumnDescription m_enclosedArrayType;

    public VerticaArray(JsonArray jsonArray, ColumnDescription columnDescription) throws ClassCastException, ErrorException, UnsupportedEncodingException {
        this(TypeUtils.parseArray(columnDescription, jsonArray), jsonArray, columnDescription);
    }

    public VerticaArray(Object[] objectArray, JsonArray jsonArray, ColumnDescription columnDescription) throws ClassCastException, ErrorException {
        int n = columnDescription.getColumnType();
        if (n != 2003) {
            throw new ClassCastException("ArrayMetadata mismatch. Expected: java.sql.Types.ARRAY (2003). Received: " + n);
        }
        this.m_jsonArray = jsonArray;
        this.m_arrayClass = TypeUtils.getClassForColumn(columnDescription);
        this.m_length = this.m_jsonArray != null ? this.m_jsonArray.size() : 0;
        this.m_arrayColumn = columnDescription;
        this.m_baseArrayColumn = this.m_arrayColumn.getBaseArrayColumn();
        this.m_enclosedArrayType = this.m_arrayColumn.findEnclosedArrayType();
        this.m_baseColumnType = this.m_baseArrayColumn.getColumnType();
        this.m_dataArray = objectArray;
    }

    private boolean isMultidimensional() {
        return this.m_baseColumnType == 2003;
    }

    @Override
    public Object createArray(long l, int n) throws ErrorException {
        if ((long)n < -1L) {
            throw new IndexOutOfBoundsException("Array length " + n + " may not be negative.");
        }
        if (l < 0L || l > (long)this.m_length) {
            throw new IndexOutOfBoundsException("starting index, " + l + " must not be outside of array bounds.");
        }
        int n2 = (int)l;
        if (n2 == this.m_length && this.m_jsonArray == null) {
            if (this.isMultidimensional()) {
                return new VerticaArray[0];
            }
            return Array.newInstance(this.m_arrayClass.getComponentType(), 0);
        }
        int n3 = this.m_length - n2;
        if ((long)n != -1L && n < n3) {
            n3 = n;
        }
        if (this.isMultidimensional()) {
            VerticaArray[] verticaArrayArray = new VerticaArray[n3];
            for (int i = n2; i < n2 + n3; ++i) {
                JsonElement jsonElement = this.m_jsonArray.get(i);
                if (jsonElement.isJsonNull()) {
                    verticaArrayArray[i] = new VerticaArray(null, null, this.m_baseArrayColumn);
                    continue;
                }
                Object[] objectArray = this.getMulitdimensionalArrayElement(i);
                if (!jsonElement.isJsonArray()) {
                    throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, 101, "Array Expected.");
                }
                verticaArrayArray[i] = new VerticaArray(objectArray, jsonElement.getAsJsonArray(), this.m_baseArrayColumn);
            }
            return verticaArrayArray;
        }
        if (n2 > 0 || n3 != this.m_length) {
            Class<?> clazz = this.m_arrayClass.getComponentType();
            Object object = Array.newInstance(clazz, n3);
            System.arraycopy(this.m_dataArray, n2, object, 0, n3);
            return object;
        }
        return this.m_dataArray;
    }

    private Object[] getMulitdimensionalArrayElement(int n) throws ErrorException {
        if (!(this.m_dataArray[n] instanceof Object[])) {
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, 101, "Data array Expected.");
        }
        return (Object[])this.m_dataArray[n];
    }

    @Override
    protected Iterator<?> createIterator(long l, int n) {
        if ((long)n < -1L) {
            throw new IndexOutOfBoundsException("Iterator length " + n + " may not be negative.");
        }
        if (l < 0L || l > (long)this.m_length) {
            throw new IndexOutOfBoundsException("starting iterator index, " + l + " must not be outside of array bounds.");
        }
        int n2 = (int)l;
        int n3 = this.m_length - n2;
        if ((long)n != -1L && n < n3) {
            n3 = n;
        }
        int n4 = n2 + n3;
        if (this.isMultidimensional()) {
            return new MultidimensionalArrayIterator(n2, n4);
        }
        return new SingleDimensionalArrayIterator(this.m_dataArray, n2, n4);
    }

    @Override
    public IColumn getBaseColumn() {
        return this.m_baseArrayColumn;
    }

    @Override
    public String getStringRepresentation() {
        return this.m_jsonArray != null ? this.m_jsonArray.toString() : NULL_ARRAY_ELEMENT;
    }

    public String toString() {
        return this.getStringRepresentation();
    }

    protected final class SingleDimensionalArrayIterator
    implements Iterator<Object> {
        private int m_currentIndex;
        private int m_lastIndex;
        private Object[] m_data;

        public SingleDimensionalArrayIterator(Object[] objectArray, int n, int n2) {
            this.m_data = objectArray;
            this.m_currentIndex = n;
            this.m_lastIndex = n2;
        }

        @Override
        public boolean hasNext() {
            return this.m_currentIndex < this.m_lastIndex;
        }

        @Override
        public Object next() {
            if (this.m_currentIndex >= this.m_lastIndex) {
                throw new NoSuchElementException();
            }
            Object object = Array.get(this.m_data, this.m_currentIndex);
            ++this.m_currentIndex;
            if (object instanceof IArray) {
                throw new RuntimeException("IArray provided. Cannot iterate through an instance of IArray.");
            }
            if (object instanceof java.sql.Array) {
                throw new RuntimeException("java.sql.Array provided. Cannot iterate through an instance of java.sql.Array.");
            }
            return object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove()");
        }
    }

    protected final class MultidimensionalArrayIterator
    implements Iterator<Object> {
        private int m_currentIndex;
        private int m_lastIndex;

        public MultidimensionalArrayIterator(int n, int n2) {
            this.m_currentIndex = n;
            this.m_lastIndex = n2;
        }

        @Override
        public boolean hasNext() {
            return this.m_currentIndex < this.m_lastIndex;
        }

        @Override
        public Object next() {
            if (this.m_currentIndex >= this.m_lastIndex) {
                throw new NoSuchElementException();
            }
            if (VerticaArray.this.m_jsonArray == null) {
                throw new RuntimeException("Unexpected Failure. Attempting to access next element of a null array.");
            }
            JsonElement jsonElement = VerticaArray.this.m_jsonArray.get(this.m_currentIndex);
            try {
                if (jsonElement.isJsonNull()) {
                    ++this.m_currentIndex;
                    return new VerticaArray(null, null, VerticaArray.this.m_baseArrayColumn);
                }
                Object[] objectArray = VerticaArray.this.getMulitdimensionalArrayElement(this.m_currentIndex);
                ++this.m_currentIndex;
                return new VerticaArray(objectArray, jsonElement.getAsJsonArray(), VerticaArray.this.m_baseArrayColumn);
            }
            catch (ErrorException errorException) {
                throw new RuntimeException("Internal Vertica JDBC Driver error.  Error constructing VerticaArray.");
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove()");
        }
    }
}

