/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.utilities;

import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.support.exceptions.GeneralException;

public class TypeNames {
    public static String getTypeClassName(int type) throws GeneralException {
        String className = "";
        switch (type) {
            case 2003: {
                className = "java.sql.Array";
                break;
            }
            case 2002: {
                className = "java.sql.Struct";
                break;
            }
            case 2000: {
                className = "java.lang.Object";
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                className = "java.lang.String";
                break;
            }
            case 2: 
            case 3: {
                className = "java.math.BigDecimal";
                break;
            }
            case 0: {
                className = "null";
                break;
            }
            case -5: {
                className = "java.lang.Long";
                break;
            }
            case 5: {
                className = "java.lang.Integer";
                break;
            }
            case -6: {
                className = "java.lang.Integer";
                break;
            }
            case -7: 
            case 16: {
                className = "java.lang.Boolean";
                break;
            }
            case 4: {
                className = "java.lang.Integer";
                break;
            }
            case 7: {
                className = "java.lang.Float";
                break;
            }
            case 6: 
            case 8: {
                className = "java.lang.Double";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                className = "[B";
                break;
            }
            case 91: {
                className = "java.sql.Date";
                break;
            }
            case 92: {
                className = "java.sql.Time";
                break;
            }
            case 93: {
                className = "java.sql.Timestamp";
                break;
            }
            case -11: {
                className = "java.util.UUID";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                className = "com.vertica.dsi.dataengine.utilities.DSITimeSpan";
                break;
            }
            case 101: 
            case 102: 
            case 107: {
                className = "com.vertica.dsi.dataengine.utilities.DSIMonthSpan";
                break;
            }
            default: {
                throw new GeneralException(1, JDBCMessageKey.UNKNOWN_DATA_TYPE.name(), new String[]{String.valueOf(type)});
            }
        }
        return className;
    }

    public static String getTypeName(int type) {
        String typeName = "";
        switch (type) {
            case 2003: {
                typeName = "Array";
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                typeName = "String";
                break;
            }
            case 2: 
            case 3: {
                typeName = "BigDecimal";
                break;
            }
            case 0: {
                typeName = "null";
                break;
            }
            case -5: {
                typeName = "long";
                break;
            }
            case 5: {
                typeName = "short";
                break;
            }
            case -6: {
                typeName = "byte";
                break;
            }
            case -7: 
            case 16: {
                typeName = "boolean";
                break;
            }
            case 4: {
                typeName = "int";
                break;
            }
            case 7: {
                typeName = "float";
                break;
            }
            case 6: 
            case 8: {
                typeName = "double";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                typeName = "byte[]";
                break;
            }
            case 91: {
                typeName = "Date";
                break;
            }
            case 92: {
                typeName = "Time";
                break;
            }
            case 93: {
                typeName = "Timestamp";
                break;
            }
            case 2000: {
                typeName = "Object";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                typeName = "DSITimeSpan";
                break;
            }
            case 101: 
            case 102: 
            case 107: {
                typeName = "DSIMonthSpan";
                break;
            }
            case -11: {
                typeName = "UUID";
                break;
            }
            default: {
                typeName = "Unknown";
            }
        }
        return typeName;
    }
}

