/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.core;

import com.vertica.core.VConnection;
import com.vertica.core.VConnectionPropertyValue;
import com.vertica.core.VDriver;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.exceptions.UtilsException;
import com.vertica.security.TLSMode;
import com.vertica.support.exceptions.GeneralException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class VConnectionPropertyKey {
    public static final String DATABASE = "database";
    public static final String HOST = "host";
    public static final String PASSWORD = "password";
    public static final String PORT = "port";
    public static final String USER = "user";
    public static final String ADD_TZ_TO_TIMESTAMP_PARAMETERS = "addtztotimestampparameters";
    public static final String AUTOCOMMIT = "autocommit";
    public static final String BACKUP_SERVER_NODE = "backupservernode";
    public static final String BINARY_TRANSFER = "binarytransfer";
    public static final String BI_DIRECT = "directbatchinsert";
    public static final String BI_STRING = "stringbatchinsert";
    public static final String CONNECTON_LOAD_BALANCE = "connectionloadbalance";
    public static final String CONN_SETTINGS = "connsettings";
    public static final String DISABLE_COPY_LOCAL = "disablecopylocal";
    public static final String HOST_NAME_VERIFIER = "hostnameverifier";
    public static final String JAAS_CONFIG_NAME = "jaasconfigname";
    public static final String KEYSTORE_PASSWORD = "keystorepassword";
    public static final String KEYSTORE_PATH = "keystorepath";
    public static final String KRB_HOST_NAME = "kerberoshostname";
    public static final String KRB_SERVICE_NAME = "kerberosservicename";
    public static final String LOCALE = "locale";
    public static final String LOG_LEVEL = "loglevel";
    public static final String LOG_NAMESPACE = "lognamespace";
    public static final String LOG_PATH = "logpath";
    public static final String LOGIN_NETWORK_TIMEOUT = "loginnetworktimeout";
    public static final String LOGIN_NODE_TIMEOUT = "loginnodetimeout";
    public static final String LOGIN_TIMEOUT = "logintimeout";
    public static final String MULTIPLE_ACTIVE_RESULT_SETS = "mars";
    public static final String NETWORK_BUFFER_SIZE = "networkbuffersize";
    public static final String NETWORK_TIMEOUT = "networktimeout";
    public static final String OAUTH_ACCESS_TOKEN = "oauthaccesstoken";
    public static final String OAUTH_BACKWARD_COMPATIBILITY = "oauthbackwardcompatibility";
    public static final String OAUTH_CLIENT_ID = "oauthclientid";
    public static final String OAUTH_CLIENT_SECRET = "oauthclientsecret";
    public static final String OAUTH_DISCOVERY_URL = "oauthdiscoveryurl";
    public static final String OAUTH_JSON_CONFIG = "oauthjsonconfig";
    public static final String OAUTH_REFRESH_TOKEN = "oauthrefreshtoken";
    public static final String OAUTH_SCOPE = "oauthscope";
    public static final String OAUTH_TOKEN_URL = "oauthtokenurl";
    public static final String OAUTH_TRUSTSTORE_PASSWORD = "oauthtruststorepassword";
    public static final String OAUTH_TRUSTSTORE_PATH = "oauthtruststorepath";
    public static final String AUTH_METHOD = "authmethod";
    public static final String PREFERRED_ADDRESS_FAMILY = "preferredaddressfamily";
    public static final String READ_ONLY = "readonly";
    public static final String REQUEST_COMPLEX_TYPES = "requestcomplextypes";
    public static final String RESULT_BUFFER_SIZE = "resultbuffersize";
    public static final String SEARCH_PATH = "searchpath";
    public static final String SESSION_LABEL = "sessionlabel";
    public static final String SESSION_TIMEZONE = "sessiontimezone";
    public static final String SESSION_TRANSFER_SUPPORT = "sessiontransfersupport";
    public static final String SOCKET_FACTORY_NAME = "socketfactoryname";
    public static final String SSL = "ssl";
    public static final String SSL_SOCKET_FACTORY_NAME = "sslsocketfactoryname";
    public static final String STRICT_CATALOG_FILTERING = "strictcatalogfiltering";
    public static final String STREAMING_BATCH_INSERT = "streamingbatchinsert";
    public static final String THREE_PART_NAMING = "threepartnaming";
    public static final String TLSMODE = "tlsmode";
    public static final String TRANSACTION_ISOLATION = "transactionisolation";
    public static final String TRUSTSTORE_PASSWORD = "truststorepassword";
    public static final String TRUSTSTORE_PATH = "truststorepath";
    public static final String WORKLOAD = "workload";
    public static final String ENABLE_ROUTABLE_QUERIES = "enableroutablequeries";
    public static final String FAIL_ON_MULTINODE_PLANS = "failonmultinodeplans";
    public static final String MAX_POOLED_CONNECTIONS = "maxpooledconnections";
    public static final String MAX_POOLED_CONNECTIONS_PER_NODE = "maxpooledconnectionspernode";
    public static final String MAX_POOLED_CONNECTION_USES = "maxpooledconnectionuses";
    public static final String METADATA_CACHE_LIFETIME = "metadatacachelifetime";
    public static final String NODE_DOWN_WAIT_TIME = "nodedownwaittime";
    public static final String SIMPLE_QUERIES_ONLY = "simplequeriesonly";
    private static final HashSet<String> legalKeys = new HashSet();
    private static final HashMap<String, String> keyAliases = new HashMap();
    private static final HashMap<String, HashMap<String, String>> valueAliases;
    private static final HashMap<String, Object> defaultValues;
    private static final HashMap<String, String> propertyDescriptions;
    private static final HashMap<String, HashSet<String>> legalValues;

    private static void addBooleanParameter(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>(){
            {
                this.put("no", "false");
                this.put("0", "false");
                this.put("off", "false");
                this.put("yes", "true");
                this.put("on", "true");
                this.put("1", "true");
            }
        };
        valueAliases.put(string, hashMap);
        legalKeys.add(string);
        legalValues.put(string, new HashSet<String>(Arrays.asList("true", "false")));
    }

    public static void assignLegalValues(HashMap<String, HashSet<String>> hashMap) {
        hashMap.put(TLSMODE, new HashSet<String>(TLSMode.stringValues()));
        hashMap.put(LOG_LEVEL, new HashSet<String>(Arrays.asList("off", "error", "warning", "info", "debug", "trace")));
        hashMap.put(TRANSACTION_ISOLATION, new HashSet<String>(VConnectionPropertyValue.TransactionIsolationLevel.stringValues()));
        hashMap.put(PREFERRED_ADDRESS_FAMILY, new HashSet<String>(VConnectionPropertyValue.AddressFamilyPreference.stringValues()));
    }

    public static void assignValueAliases(HashMap<String, HashMap<String, String>> hashMap) {
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("0", "off");
        hashMap2.put("1", "error");
        hashMap2.put("2", "warning");
        hashMap2.put("3", "info");
        hashMap2.put("4", "debug");
        hashMap2.put("5", "trace");
        hashMap.put(LOG_LEVEL, hashMap2);
        hashMap2 = new HashMap();
        hashMap2.put("protocol", "com.vertica.io");
        hashMap2.put("io", "com.vertica.io");
        hashMap2.put("connection", "com.vertica.core");
        hashMap2.put("jdbc", "com.vertica.jdbc");
        hashMap2.put("kv", "com.vertica.jdbc.kv");
        hashMap2.put("all", "com.vertica");
        hashMap.put(LOG_NAMESPACE, hashMap2);
        hashMap2 = new HashMap();
        hashMap2.put("read_commited", VConnectionPropertyValue.TransactionIsolationLevel.TXN_READ_COMMITTED.toString());
        hashMap2.put("serverdefault", VConnectionPropertyValue.TransactionIsolationLevel.TXN_SERVER_DEFAULT.toString());
        hashMap2.put("server_default", VConnectionPropertyValue.TransactionIsolationLevel.TXN_SERVER_DEFAULT.toString());
        hashMap2.put("serializable", VConnectionPropertyValue.TransactionIsolationLevel.TXN_SERIALIZABLE.toString());
        hashMap.put(TRANSACTION_ISOLATION, hashMap2);
    }

    public static void assignKeyAliases(HashMap<String, String> hashMap) {
        hashMap.put("hostname", HOST);
        hashMap.put("server", HOST);
        hashMap.put("pwd", PASSWORD);
        hashMap.put("username", USER);
        hashMap.put("batchinsertdirect", BI_DIRECT);
        hashMap.put("batchinsertstring", BI_STRING);
        hashMap.put("conn_settings", CONN_SETTINGS);
        hashMap.put("connectsql", CONN_SETTINGS);
        hashMap.put("defaultautocommit", AUTOCOMMIT);
        hashMap.put("isolationlevel", TRANSACTION_ISOLATION);
        hashMap.put("label", SESSION_LABEL);
        hashMap.put("logpackage", LOG_NAMESPACE);
        hashMap.put("logcomponent", LOG_NAMESPACE);
        hashMap.put("maxlrsmemory", RESULT_BUFFER_SIZE);
        hashMap.put("maxmemorycache", RESULT_BUFFER_SIZE);
        hashMap.put("multipleactiveresultsets", MULTIPLE_ACTIVE_RESULT_SETS);
        hashMap.put("search_path", SEARCH_PATH);
        hashMap.put("sslmode", TLSMODE);
        hashMap.put("uid", USER);
    }

    public static void assignDefaultValues(HashMap<String, Object> hashMap) {
        hashMap.put(PORT, 5433);
        hashMap.put(ADD_TZ_TO_TIMESTAMP_PARAMETERS, false);
        hashMap.put(AUTOCOMMIT, true);
        hashMap.put(BACKUP_SERVER_NODE, "");
        hashMap.put(BI_DIRECT, false);
        hashMap.put(BI_STRING, true);
        hashMap.put(BINARY_TRANSFER, true);
        hashMap.put(CONNECTON_LOAD_BALANCE, false);
        hashMap.put(CONN_SETTINGS, "");
        hashMap.put(DISABLE_COPY_LOCAL, false);
        hashMap.put(HOST_NAME_VERIFIER, VConnectionPropertyValue.DEFAULT_HOST_NAME_VERIFIER);
        hashMap.put(JAAS_CONFIG_NAME, "verticajdbc");
        hashMap.put(KEYSTORE_PATH, "");
        hashMap.put(KEYSTORE_PASSWORD, "");
        hashMap.put(KRB_HOST_NAME, "");
        hashMap.put(KRB_SERVICE_NAME, "vertica");
        hashMap.put(LOCALE, "en_US@collation=binary");
        hashMap.put(LOG_LEVEL, (Object)VConnectionPropertyValue.DEFAULT_LOG_LEVEL);
        hashMap.put(LOG_NAMESPACE, "com.vertica");
        hashMap.put(LOG_PATH, "");
        hashMap.put(LOGIN_NETWORK_TIMEOUT, 0);
        hashMap.put(LOGIN_NODE_TIMEOUT, 0);
        hashMap.put(LOGIN_TIMEOUT, 0);
        hashMap.put(MULTIPLE_ACTIVE_RESULT_SETS, false);
        hashMap.put(NETWORK_BUFFER_SIZE, 8192);
        hashMap.put(NETWORK_TIMEOUT, 0);
        hashMap.put(OAUTH_ACCESS_TOKEN, "");
        hashMap.put(OAUTH_BACKWARD_COMPATIBILITY, false);
        hashMap.put(OAUTH_CLIENT_ID, "");
        hashMap.put(OAUTH_CLIENT_SECRET, "");
        hashMap.put(OAUTH_DISCOVERY_URL, "");
        hashMap.put(OAUTH_JSON_CONFIG, "");
        hashMap.put(OAUTH_REFRESH_TOKEN, "");
        hashMap.put(OAUTH_SCOPE, "");
        hashMap.put(OAUTH_TOKEN_URL, "");
        hashMap.put(OAUTH_TRUSTSTORE_PASSWORD, "");
        hashMap.put(OAUTH_TRUSTSTORE_PATH, "");
        hashMap.put(AUTH_METHOD, "");
        hashMap.put(PREFERRED_ADDRESS_FAMILY, (Object)VConnectionPropertyValue.DEFAULT_PREFERRED_ADDRESS_FAMILY);
        hashMap.put(READ_ONLY, false);
        hashMap.put(REQUEST_COMPLEX_TYPES, true);
        hashMap.put(RESULT_BUFFER_SIZE, 8192);
        hashMap.put(SEARCH_PATH, "");
        hashMap.put(SESSION_TRANSFER_SUPPORT, true);
        hashMap.put(SESSION_TIMEZONE, "");
        hashMap.put(SIMPLE_QUERIES_ONLY, false);
        hashMap.put(SOCKET_FACTORY_NAME, "");
        hashMap.put(SSL_SOCKET_FACTORY_NAME, "");
        hashMap.put(STREAMING_BATCH_INSERT, false);
        hashMap.put(STRICT_CATALOG_FILTERING, false);
        hashMap.put(THREE_PART_NAMING, true);
        hashMap.put(TLSMODE, (Object)VConnectionPropertyValue.DEFAULT_TLSMODE);
        hashMap.put(TRANSACTION_ISOLATION, 2);
        hashMap.put(TRUSTSTORE_PASSWORD, "");
        hashMap.put(TRUSTSTORE_PATH, "");
        hashMap.put(WORKLOAD, "");
        hashMap.put(ENABLE_ROUTABLE_QUERIES, false);
        hashMap.put(FAIL_ON_MULTINODE_PLANS, true);
        hashMap.put(MAX_POOLED_CONNECTIONS, 20);
        hashMap.put(MAX_POOLED_CONNECTIONS_PER_NODE, 5);
        hashMap.put(MAX_POOLED_CONNECTION_USES, 1000);
        hashMap.put(METADATA_CACHE_LIFETIME, 300);
        hashMap.put(NODE_DOWN_WAIT_TIME, 60);
    }

    public static void assignLegalKeys(HashSet<String> hashSet) {
        hashSet.add(DATABASE);
        hashSet.add(HOST);
        hashSet.add(PASSWORD);
        hashSet.add(PORT);
        hashSet.add(USER);
        hashSet.add(BACKUP_SERVER_NODE);
        hashSet.add(CONN_SETTINGS);
        hashSet.add(HOST_NAME_VERIFIER);
        hashSet.add(JAAS_CONFIG_NAME);
        hashSet.add(KEYSTORE_PASSWORD);
        hashSet.add(KEYSTORE_PATH);
        hashSet.add(KRB_HOST_NAME);
        hashSet.add(KRB_SERVICE_NAME);
        hashSet.add(LOCALE);
        hashSet.add(LOG_LEVEL);
        hashSet.add(LOG_NAMESPACE);
        hashSet.add(LOG_PATH);
        hashSet.add(LOGIN_NETWORK_TIMEOUT);
        hashSet.add(LOGIN_NODE_TIMEOUT);
        hashSet.add(LOGIN_TIMEOUT);
        hashSet.add(NETWORK_BUFFER_SIZE);
        hashSet.add(NETWORK_TIMEOUT);
        hashSet.add(OAUTH_ACCESS_TOKEN);
        hashSet.add(OAUTH_BACKWARD_COMPATIBILITY);
        hashSet.add(OAUTH_CLIENT_ID);
        hashSet.add(OAUTH_CLIENT_SECRET);
        hashSet.add(OAUTH_DISCOVERY_URL);
        hashSet.add(OAUTH_JSON_CONFIG);
        hashSet.add(AUTH_METHOD);
        hashSet.add(OAUTH_REFRESH_TOKEN);
        hashSet.add(OAUTH_SCOPE);
        hashSet.add(OAUTH_TOKEN_URL);
        hashSet.add(OAUTH_TRUSTSTORE_PASSWORD);
        hashSet.add(OAUTH_TRUSTSTORE_PATH);
        hashSet.add(PREFERRED_ADDRESS_FAMILY);
        hashSet.add(RESULT_BUFFER_SIZE);
        hashSet.add(SEARCH_PATH);
        hashSet.add(SESSION_LABEL);
        hashSet.add(SESSION_TIMEZONE);
        hashSet.add(SOCKET_FACTORY_NAME);
        hashSet.add(SSL_SOCKET_FACTORY_NAME);
        hashSet.add(TLSMODE);
        hashSet.add(TRANSACTION_ISOLATION);
        hashSet.add(TRUSTSTORE_PASSWORD);
        hashSet.add(TRUSTSTORE_PATH);
        hashSet.add(WORKLOAD);
        hashSet.add(MAX_POOLED_CONNECTION_USES);
        hashSet.add(MAX_POOLED_CONNECTIONS_PER_NODE);
        hashSet.add(MAX_POOLED_CONNECTIONS);
        hashSet.add(METADATA_CACHE_LIFETIME);
        hashSet.add(NODE_DOWN_WAIT_TIME);
    }

    public static void assignPropertyDescriptions(HashMap<String, String> hashMap) {
        hashMap.put(DATABASE, "The name of the database to connect to");
        hashMap.put(HOST, "The IP address or host name of the " + VDriver.SERVER_PRODUCT_NAME + " server");
        hashMap.put(PASSWORD, "The user's password");
        hashMap.put(PORT, "The port to connect to on the host");
        hashMap.put(USER, "The user to connect as");
        hashMap.put(ADD_TZ_TO_TIMESTAMP_PARAMETERS, "If true, Timestamp parameters bound with PreparedStatement.setTimestamp(int, Timestamp, Calendar) will include the Calendar's time zone in the value sent to the server, so that they may map more accurately to TimestampTz columns");
        hashMap.put(AUTOCOMMIT, "If false, the connection will start with autocommit disabled");
        hashMap.put(BACKUP_SERVER_NODE, "A comma separated list of host:port pairs to use if primary server is unavailable");
        hashMap.put(BI_DIRECT, "If true, batch insert data is written directly to the ROS. Deprecated; all data is loaded directly into ROS as of 10.0");
        hashMap.put(BINARY_TRANSFER, "If true, connection uses binary transfer instead of text transfer");
        hashMap.put(CONN_SETTINGS, "SQL to run after a connection is established to change session properties on the server");
        hashMap.put(CONNECTON_LOAD_BALANCE, "If true, use native load balancing");
        hashMap.put(DISABLE_COPY_LOCAL, "If true, file-based COPY LOCAL will be disabled");
        hashMap.put(HOST_NAME_VERIFIER, "user define hostname verifer to replace default one");
        hashMap.put(JAAS_CONFIG_NAME, "The name of a JAAS configuration that the driver should use when performing GSS authentication");
        hashMap.put(KEYSTORE_PASSWORD, "The password for the keystore file; only used if keystorepath is set");
        hashMap.put(KEYSTORE_PATH, "A path to a JKS file containing client certificates and keys to be used when performing SSL/TLS");
        hashMap.put(KRB_HOST_NAME, "The host name portion of the kerberos service principal that identifies the Vertica server");
        hashMap.put(KRB_SERVICE_NAME, "The service name portion of the kerberos service principal that identifies the Vertica server");
        hashMap.put(LOCALE, "The ICU locale to use for this session");
        hashMap.put(LOG_LEVEL, "The amount of detail to include in log messages");
        hashMap.put(LOG_NAMESPACE, "A package name to restrict logging to");
        hashMap.put(LOG_PATH, "The directory to store the log file in");
        hashMap.put(LOGIN_NETWORK_TIMEOUT, "The amount of time to spend establishing a network level socket before giving up");
        hashMap.put(LOGIN_NODE_TIMEOUT, "The amount of time to spend establishing a connection to an specific node before giving up");
        hashMap.put(LOGIN_TIMEOUT, "The amount of time to spend establishing a connection before giving up");
        hashMap.put(MULTIPLE_ACTIVE_RESULT_SETS, "If true, server may cache query result sets, so client can have multiple open result sets on the same connection");
        hashMap.put(NETWORK_BUFFER_SIZE, "Size of data to buffer before sending network messages to the server");
        hashMap.put(NETWORK_TIMEOUT, "number of milliseconds a connection can be idle before it is terminated");
        hashMap.put(OAUTH_ACCESS_TOKEN, "The access token used for OAuth authentication");
        hashMap.put(OAUTH_BACKWARD_COMPATIBILITY, "Supports authenticating with an oauth access token against an 11.1 and 12.0 server");
        hashMap.put(OAUTH_CLIENT_ID, "The ID used to connect to an OAuth endpoint; Deprecated. Oauth Client ID flow is deprecated as of 24.2.");
        hashMap.put(OAUTH_CLIENT_SECRET, "The secret used to connect to an OAuth endpoint; Deprecated. Oauth Client secret flow is deprecated as of 24.2.");
        hashMap.put(OAUTH_DISCOVERY_URL, "The url used to discover an OAuth token endpoint; Deprecated. Oauth Discovery url flow is deprecated as of 24.2.");
        hashMap.put(OAUTH_JSON_CONFIG, "Static OAuth configuration set through JSON. Supports parameters oauthtokenurl, oauthdiscoveryurl, oauthclientid, oauthclientsecret, oauthscope.; Deprecated. Oauth Json config flow is deprecated as of 24.2.");
        hashMap.put(OAUTH_REFRESH_TOKEN, "The refresh token used to refresh the OAuth access token if needed; Deprecated. Oauth token refresh flow is deprecated as of 24.2.");
        hashMap.put(OAUTH_SCOPE, "The scope of the access request used for OAuth token refresh; Deprecated. Oauth Scope flow is deprecated as of 24.2.");
        hashMap.put(OAUTH_TOKEN_URL, "The OAuth token url, used to refresh oauth tokens; Deprecated. Oauth token URL flow is deprecated as of 24.2.");
        hashMap.put(OAUTH_TRUSTSTORE_PASSWORD, "The password for the truststore JKS file; only used if oauthtruststorepath is set; Deprecated. Oauth Truststore flow is deprecated as of 24.2.");
        hashMap.put(OAUTH_TRUSTSTORE_PATH, "A path to a JKS file containing trusted certificate authorities to be used when performing SSL/TLS connection to oauth identity provider; Deprecated. Oauth Truststore Path flow is deprecated as of 24.2.");
        hashMap.put(AUTH_METHOD, "The type of authentication to attempt if more than one is requested in the connection string. Options are oauth, browser, kerberos, password");
        hashMap.put(PREFERRED_ADDRESS_FAMILY, "The address family type to prefer when resolving hostnames");
        hashMap.put(READ_ONLY, "If true, commands that modify the database in any way will result in an error");
        hashMap.put(REQUEST_COMPLEX_TYPES, "If true, complex types are returned with full complex type metadata");
        hashMap.put(RESULT_BUFFER_SIZE, "The size in bytes of the client side result cache (one per ResultSet)");
        hashMap.put(SEARCH_PATH, "A comma separated list of schema names to search when looking up unqualified object references");
        hashMap.put(SESSION_LABEL, "A string to identify the JDBC connection's session on the server");
        hashMap.put(SESSION_TIMEZONE, "The timezone to use for this session. See the documentation for the SQL statement SET TIMEZONE.");
        hashMap.put(SESSION_TRANSFER_SUPPORT, "If true, driver will allow sessions to be redirected to a new subcluster when admin initiates session transfer request");
        hashMap.put(SOCKET_FACTORY_NAME, "The name of a javax.net.SocketFactory class to use when creating sockets");
        hashMap.put(SSL_SOCKET_FACTORY_NAME, "The name of a javax.net.ssl.SSLSocketFactory class to use when performing SSL/TLS");
        hashMap.put(SSL, "If true, connect using SSL/TLS. Deprecated; use tlsmode=verify-ca to have the same effect as ssl=true");
        hashMap.put(STREAMING_BATCH_INSERT, "If true, send PreparedStatement batch insert data to the server as it arrives via addBatch() instead of holding in memory until executeBatch(). Streaming is faster and uses less memory, but while a streaming batch insert is in progress PreparedStatement.clearBatch() is disabled and other connection operations are not allowed");
        hashMap.put(STRICT_CATALOG_FILTERING, "If false, DatabaseMetaData methods that take a catalog argument will treat the empty string as if it were null");
        hashMap.put(THREE_PART_NAMING, "If true, use the database name as the catalog name when reporting metadata");
        hashMap.put(TLSMODE, "Controls how the driver performs TLS and certificate verification when establishing a connection. Supported values are disable, require, verify-ca and verify-full");
        hashMap.put(TRANSACTION_ISOLATION, "The default transaction isolation level to use");
        hashMap.put(TRUSTSTORE_PASSWORD, "The password for the truststore JKS file; only used if truststorepath is set");
        hashMap.put(TRUSTSTORE_PATH, "A path to a JKS file containing trusted certificate authorities to be used when performing SSL/TLS");
        hashMap.put(WORKLOAD, "The name of the workload used to compare against workload routing rules");
        hashMap.put(ENABLE_ROUTABLE_QUERIES, "If true, connections returned will implement VerticaRoutableConnection and provide access to the VGet API");
        hashMap.put(FAIL_ON_MULTINODE_PLANS, "If true, VGet operations that require more than a single node's resources are disallowed");
        hashMap.put(MAX_POOLED_CONNECTIONS, "The maximum number of connections allowed in the VerticaRoutableConnection's connection pool");
        hashMap.put(MAX_POOLED_CONNECTIONS_PER_NODE, "The maximum number of connections allowed to a single node in the VerticaRoutableConnection's connection pool");
        hashMap.put(MAX_POOLED_CONNECTION_USES, "The maximum number of times to use a pooled connection before closing it");
        hashMap.put(METADATA_CACHE_LIFETIME, "Time in seconds to cache table and projection metadata used during VGet operations");
        hashMap.put(NODE_DOWN_WAIT_TIME, "Time in seconds to wait before attemptng a new connection to a node after a connection failure occurs");
    }

    public static boolean addProperty(Properties properties, String string, Object object) {
        if (string == null || object == null) {
            return false;
        }
        String[] stringArray = VConnectionPropertyKey.translateSetting(string, object);
        if (stringArray[0] != null && stringArray[1] != null) {
            properties.put(stringArray[0], stringArray[1]);
            return true;
        }
        return false;
    }

    public static String[] translateSetting(String string, Object object) {
        String string2 = string.toLowerCase();
        String string3 = null;
        if (keyAliases.containsKey(string2)) {
            string2 = keyAliases.get(string2);
        }
        if (legalKeys.contains(string2)) {
            if (legalValues.containsKey(string2)) {
                HashSet<String> hashSet;
                String string4 = object == null ? null : object.toString().toLowerCase();
                HashMap<String, String> hashMap = valueAliases.get(string2);
                if (hashMap != null && hashMap.containsKey(string4)) {
                    string4 = hashMap.get(string4);
                }
                string3 = (hashSet = legalValues.get(string2)).contains(string4) ? string4 : null;
            } else {
                string3 = object == null ? null : object.toString();
            }
        } else {
            string2 = null;
        }
        return new String[]{string2, string3};
    }

    public static String translatePropertyKey(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase();
        if (legalKeys.contains(string2)) {
            return string2;
        }
        return keyAliases.get(string2);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean parseSubName(String string, Properties properties) {
        boolean bl = true;
        try {
            Properties properties2;
            block16: {
                String[] stringArray;
                properties2 = new Properties();
                for (Map.Entry<Object, Object> object : properties.entrySet()) {
                    stringArray = object.getKey().toString();
                    String[] stringArray2 = object.getValue();
                    String string2 = stringArray2 == null ? null : stringArray2.toString();
                    VConnectionPropertyKey.addProperty(properties2, (String)stringArray, string2);
                }
                try {
                    String string3;
                    int n;
                    Iterator<Object> iterator = new URL("http:" + string);
                    if (!properties2.containsKey(DATABASE)) {
                        void var5_10;
                        String n2 = ((URL)((Object)iterator)).getPath();
                        if (n2.length() > 0 && n2.charAt(0) == '/') {
                            String string4 = n2.substring(1);
                        }
                        if (var5_10.indexOf("/") >= 0) {
                            bl = false;
                        }
                        properties2.put(DATABASE, (Object)var5_10);
                    }
                    if (!properties2.containsKey(HOST)) {
                        String string5 = ((URL)((Object)iterator)).getHost();
                        properties2.put(HOST, string5);
                    }
                    if (!properties2.containsKey(PORT) && (n = ((URL)((Object)iterator)).getPort()) != -1) {
                        properties2.put(PORT, String.valueOf(n));
                    }
                    if ((string3 = ((URL)((Object)iterator)).getQuery()) == null) break block16;
                    try {
                        for (String string6 : stringArray = string3.split("&")) {
                            String[] stringArray3 = string6.split("=");
                            if (stringArray3.length != 2) continue;
                            String string7 = URLDecoder.decode(stringArray3[0], VConnection.VERTICA_CHARSET);
                            String string8 = URLDecoder.decode(stringArray3[1], VConnection.VERTICA_CHARSET);
                            VConnectionPropertyKey.addProperty(properties2, string7, string8);
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!properties2.containsKey(PASSWORD)) {
                properties2.put(PASSWORD, "");
            }
            if (bl) {
                properties.clear();
                for (Object object : properties2.keySet()) {
                    properties.put(object, properties2.get(object));
                }
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static ArrayList<Variant> getLegalValueVariants(String string) throws GeneralException {
        ArrayList<Variant> arrayList = new ArrayList<Variant>();
        HashSet<String> hashSet = legalValues.get(string = VConnectionPropertyKey.translatePropertyKey(string));
        if (hashSet == null) {
            return null;
        }
        for (String string2 : hashSet) {
            try {
                arrayList.add(new Variant(0, string2));
            }
            catch (UtilsException utilsException) {
                throw new GeneralException(101, utilsException.getMessage());
            }
        }
        return arrayList;
    }

    public static HashSet<String> getLegalValueSet(String string) {
        string = VConnectionPropertyKey.translatePropertyKey(string);
        HashSet<String> hashSet = legalValues.get(string);
        return hashSet;
    }

    public static String getProperyDescription(String string) {
        if ((string = VConnectionPropertyKey.translatePropertyKey(string)) == null) {
            return "";
        }
        return propertyDescriptions.get(string);
    }

    private VConnectionPropertyKey() {
    }

    static {
        legalValues = new HashMap();
        valueAliases = new HashMap();
        propertyDescriptions = new HashMap();
        defaultValues = new HashMap();
        VConnectionPropertyKey.assignLegalKeys(legalKeys);
        VConnectionPropertyKey.assignKeyAliases(keyAliases);
        VConnectionPropertyKey.assignValueAliases(valueAliases);
        VConnectionPropertyKey.assignLegalValues(legalValues);
        VConnectionPropertyKey.assignPropertyDescriptions(propertyDescriptions);
        VConnectionPropertyKey.assignDefaultValues(defaultValues);
        VConnectionPropertyKey.addBooleanParameter(ADD_TZ_TO_TIMESTAMP_PARAMETERS);
        VConnectionPropertyKey.addBooleanParameter(AUTOCOMMIT);
        VConnectionPropertyKey.addBooleanParameter(BI_DIRECT);
        VConnectionPropertyKey.addBooleanParameter(BI_STRING);
        VConnectionPropertyKey.addBooleanParameter(BINARY_TRANSFER);
        VConnectionPropertyKey.addBooleanParameter(CONNECTON_LOAD_BALANCE);
        VConnectionPropertyKey.addBooleanParameter(DISABLE_COPY_LOCAL);
        VConnectionPropertyKey.addBooleanParameter(ENABLE_ROUTABLE_QUERIES);
        VConnectionPropertyKey.addBooleanParameter(FAIL_ON_MULTINODE_PLANS);
        VConnectionPropertyKey.addBooleanParameter(MULTIPLE_ACTIVE_RESULT_SETS);
        VConnectionPropertyKey.addBooleanParameter(OAUTH_BACKWARD_COMPATIBILITY);
        VConnectionPropertyKey.addBooleanParameter(READ_ONLY);
        VConnectionPropertyKey.addBooleanParameter(REQUEST_COMPLEX_TYPES);
        VConnectionPropertyKey.addBooleanParameter(SESSION_TRANSFER_SUPPORT);
        VConnectionPropertyKey.addBooleanParameter(SIMPLE_QUERIES_ONLY);
        VConnectionPropertyKey.addBooleanParameter(SSL);
        VConnectionPropertyKey.addBooleanParameter(STREAMING_BATCH_INSERT);
        VConnectionPropertyKey.addBooleanParameter(STRICT_CATALOG_FILTERING);
        VConnectionPropertyKey.addBooleanParameter(THREE_PART_NAMING);
    }
}

