/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.security;

import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public abstract class CertStoreResolver {
    public final String password;
    public final String path;
    public final String type;
    private final boolean simulateDefault;
    public final ILogger logger;

    protected CertStoreResolver(String string, String string2, boolean bl, ILogger iLogger) {
        this.password = string2 == null ? "changeit" : string2;
        this.path = string == null ? "" : string;
        this.simulateDefault = bl;
        this.type = this.resolveType();
        this.logger = iLogger;
    }

    private String resolveType() {
        String string;
        block7: {
            string = KeyStore.getDefaultType();
            String string2 = this.path.toLowerCase();
            if (string2.endsWith("jks")) {
                string = "JKS";
            } else if (string2.endsWith("p12") || string2.endsWith("pkcs12")) {
                string = "PKCS12";
            } else {
                try {
                    File file = new File(this.path);
                    String string3 = file.getCanonicalPath();
                    int n = string3.lastIndexOf(".");
                    int n2 = string3.lastIndexOf(File.separator);
                    if (n2 < n) {
                        string = string3.substring(n + 1);
                    }
                }
                catch (IOException iOException) {
                    if (this.logger == null) break block7;
                    LogUtilities.logWarning(String.format("Could not open store located at: %s", "".equals(this.path) ? "\"\"" : this.path), this.logger);
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getKeyStore() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        try (FileInputStream fileInputStream = null;){
            KeyStore keyStore;
            try {
                keyStore = KeyStore.getInstance(this.type);
            }
            catch (KeyStoreException keyStoreException) {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            }
            File file = new File(this.path);
            if (file.exists()) {
                fileInputStream = new FileInputStream(this.path);
                keyStore.load(fileInputStream, this.password.toCharArray());
            } else if (this.simulateDefault) {
                if (this.logger != null) {
                    LogUtilities.logWarning("empty store is used", this.logger);
                }
                keyStore.load(null, this.password.toCharArray());
            } else {
                throw new FileNotFoundException("Could not open store located at: " + ("".equals(this.path) ? "\"\"" : this.path));
            }
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }
}

