/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.core;

import cats.Applicative;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.DistributedFilesystemReadConfig;
import com.vertica.spark.config.FileStoreConfig;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.config.TableQuery;
import com.vertica.spark.config.TableSource;
import com.vertica.spark.config.ValidFilePermissions;
import com.vertica.spark.config.VerticaMetadata;
import com.vertica.spark.config.VerticaReadMetadata;
import com.vertica.spark.datasource.core.DataBlock;
import com.vertica.spark.datasource.core.ParquetFileRange;
import com.vertica.spark.datasource.core.PartitionInfo;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemPartition;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemPartition$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe$;
import com.vertica.spark.datasource.core.VerticaPartition;
import com.vertica.spark.datasource.core.VerticaPipeInterface;
import com.vertica.spark.datasource.core.VerticaPipeReadInterface;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.fs.ParquetFileMetadata;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.v2.PushdownFilter;
import com.vertica.spark.util.cleanup.CleanupUtilsInterface;
import com.vertica.spark.util.cleanup.FileCleanupInfo;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.CreateDirectoryAlreadyExistsError;
import com.vertica.spark.util.error.DoneReading;
import com.vertica.spark.util.error.ExportFromVerticaError;
import com.vertica.spark.util.error.InvalidPartition;
import com.vertica.spark.util.error.UninitializedReadError;
import com.vertica.spark.util.schema.ColumnDef;
import com.vertica.spark.util.schema.SchemaToolsInterface;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.Tuple6;
import scala.Tuple7;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t}d\u0001\u0002\u0016,\u0001YB\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t!\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\r\"AA\n\u0001BC\u0002\u0013\u0005Q\n\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003O\u0011!)\u0006A!b\u0001\n\u00031\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tS\u0002\u0011)\u0019!C\u0001U\"A\u0011\u000f\u0001B\u0001B\u0003%1\u000e\u0003\u0005s\u0001\t\u0015\r\u0011\"\u0001t\u0011!9\bA!A!\u0002\u0013!\b\"\u0002=\u0001\t\u0003I\b\"CA\u0002\u0001\t\u0007I\u0011BA\u0003\u0011!\t9\u0002\u0001Q\u0001\n\u0005\u001d\u0001\u0002CA\r\u0001\t\u0007I\u0011B:\t\u000f\u0005m\u0001\u0001)A\u0005i\"A\u0011Q\u0004\u0001C\u0002\u0013%1\u000fC\u0004\u0002 \u0001\u0001\u000b\u0011\u0002;\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$!9\u0011q\u000b\u0001\u0005\n\u0005e\u0003bBAG\u0001\u0011\u0005\u0013q\u0012\u0005\b\u0003#\u0003A\u0011IAJ\u0011\u001d\ti\n\u0001C\u0005\u0003?Cq!!/\u0001\t\u0013\tY\fC\u0004\u0002X\u0002!I!!7\t\u000f\u0005m\b\u0001\"\u0011\u0002~\"I!\u0011\u0001\u0001A\u0002\u0013\u0005!1\u0001\u0005\n\u0005#\u0001\u0001\u0019!C\u0001\u0005'A\u0001Ba\b\u0001A\u0003&!Q\u0001\u0005\t\u0005C\u0001\u0001\u0019!C\u0001g\"I!1\u0005\u0001A\u0002\u0013\u0005!Q\u0005\u0005\b\u0005S\u0001\u0001\u0015)\u0003u\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0005[AqAa\u000f\u0001\t\u0013\u0011i\u0004C\u0004\u0003P\u0001!\tA!\u0015\t\u000f\tm\u0003\u0001\"\u0001\u0003^\u001dI!qL\u0016\u0002\u0002#\u0005!\u0011\r\u0004\tU-\n\t\u0011#\u0001\u0003d!1\u0001p\nC\u0001\u0005KB\u0011Ba\u001a(#\u0003%\tA!\u001b\u0003IY+'\u000f^5dC\u0012K7\u000f\u001e:jEV$X\r\u001a$jY\u0016\u001c\u0018p\u001d;f[J+\u0017\r\u001a)ja\u0016T!\u0001L\u0017\u0002\t\r|'/\u001a\u0006\u0003]=\n!\u0002Z1uCN|WO]2f\u0015\t\u0001\u0014'A\u0003ta\u0006\u00148N\u0003\u00023g\u00059a/\u001a:uS\u000e\f'\"\u0001\u001b\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u00019T(\u0011\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005yzT\"A\u0016\n\u0005\u0001[#\u0001\u0006,feRL7-\u0019)ja\u0016Le\u000e^3sM\u0006\u001cW\r\u0005\u0002?\u0005&\u00111i\u000b\u0002\u0019-\u0016\u0014H/[2b!&\u0004XMU3bI&sG/\u001a:gC\u000e,\u0017AB2p]\u001aLw-F\u0001G!\t9\u0015*D\u0001I\u0015\t!u&\u0003\u0002K\u0011\nyB)[:ue&\u0014W\u000f^3e\r&dWm]=ti\u0016l'+Z1e\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005qa-\u001b7f'R|'/\u001a'bs\u0016\u0014X#\u0001(\u0011\u0005=\u0013V\"\u0001)\u000b\u0005Ek\u0013A\u00014t\u0013\t\u0019\u0006KA\fGS2,7\u000b^8sK2\u000b\u00170\u001a:J]R,'OZ1dK\u0006ya-\u001b7f'R|'/\u001a'bs\u0016\u0014\b%A\u0005kI\n\u001cG*Y=feV\tq\u000b\u0005\u0002Y76\t\u0011L\u0003\u0002[[\u0005!!\u000e\u001a2d\u0013\ta\u0016L\u0001\nKI\n\u001cG*Y=fe&sG/\u001a:gC\u000e,\u0017A\u00036eE\u000ed\u0015-_3sA\u0005Y1o\u00195f[\u0006$vn\u001c7t+\u0005\u0001\u0007CA1g\u001b\u0005\u0011'BA2e\u0003\u0019\u00198\r[3nC*\u0011QmL\u0001\u0005kRLG.\u0003\u0002hE\n!2k\u00195f[\u0006$vn\u001c7t\u0013:$XM\u001d4bG\u0016\fAb]2iK6\fGk\\8mg\u0002\nAb\u00197fC:,\b/\u0016;jYN,\u0012a\u001b\t\u0003Y>l\u0011!\u001c\u0006\u0003]\u0012\fqa\u00197fC:,\b/\u0003\u0002q[\n)2\t\\3b]V\u0004X\u000b^5mg&sG/\u001a:gC\u000e,\u0017!D2mK\u0006tW\u000f]+uS2\u001c\b%\u0001\u0005eCR\f7+\u001b>f+\u0005!\bC\u0001\u001dv\u0013\t1\u0018HA\u0002J]R\f\u0011\u0002Z1uCNK'0\u001a\u0011\u0002\rqJg.\u001b;?)!Q8\u0010`?\u007f\u007f\u0006\u0005\u0001C\u0001 \u0001\u0011\u0015!U\u00021\u0001G\u0011\u0015aU\u00021\u0001O\u0011\u0015)V\u00021\u0001X\u0011\u0015qV\u00021\u0001a\u0011\u0015IW\u00021\u0001l\u0011\u001d\u0011X\u0002%AA\u0002Q\fa\u0001\\8hO\u0016\u0014XCAA\u0004!\u0011\tI!a\u0005\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\tAb]2bY\u0006dwnZ4j]\u001eT1!!\u00054\u0003!!\u0018\u0010]3tC\u001a,\u0017\u0002BA\u000b\u0003\u0017\u0011a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\f[\u0006Dh)\u001b7f'&TX-\u0001\u0007nCb4\u0015\u000e\\3TSj,\u0007%A\bnCb\u0014vn^$s_V\u00048+\u001b>f\u0003Ai\u0017\r\u001f*po\u001e\u0013x.\u001e9TSj,\u0007%\u0001\tsKR\u0014\u0018.\u001a<f\u001b\u0016$\u0018\rZ1uCR\u0011\u0011Q\u0005\t\u0007\u0003O\tY%!\u0015\u000f\t\u0005%\u0012Q\t\b\u0005\u0003W\t\tE\u0004\u0003\u0002.\u0005}b\u0002BA\u0018\u0003{qA!!\r\u0002<9!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028U\na\u0001\u0010:p_Rt\u0014\"\u0001\u001b\n\u0005I\u001a\u0014B\u0001\u00192\u0013\t)w&C\u0002\u0002D\u0011\fQ!\u001a:s_JLA!a\u0012\u0002J\u0005iQI\u001d:pe\"\u000bg\u000e\u001a7j]\u001eT1!a\u0011e\u0013\u0011\ti%a\u0014\u0003\u001f\r{gN\\3di>\u0014(+Z:vYRTA!a\u0012\u0002JA\u0019q)a\u0015\n\u0007\u0005U\u0003JA\bWKJ$\u0018nY1NKR\fG-\u0019;b\u0003I\tG\r\u001a)vg\"$wn\u001e8GS2$XM]:\u0015\t\u0005m\u00131\u000e\t\u0005\u0003;\n)G\u0004\u0003\u0002`\u0005\u0005\u0004cAA\u001as%\u0019\u00111M\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\t9'!\u001b\u0003\rM#(/\u001b8h\u0015\r\t\u0019'\u000f\u0005\b\u0003[*\u0002\u0019AA8\u0003=\u0001Xo\u001d5e_^tg)\u001b7uKJ\u001c\bCBA9\u0003w\n\tI\u0004\u0003\u0002t\u0005]d\u0002BA\u001a\u0003kJ\u0011AO\u0005\u0004\u0003sJ\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003{\nyH\u0001\u0003MSN$(bAA=sA!\u00111QAE\u001b\t\t)IC\u0002\u0002\b6\n!A\u001e\u001a\n\t\u0005-\u0015Q\u0011\u0002\u000f!V\u001c\b\u000eZ8x]\u001aKG\u000e^3s\u0003-9W\r^'fi\u0006$\u0017\r^1\u0016\u0005\u0005\u0015\u0012\u0001E4fi\u0012\u000bG/\u0019\"m_\u000e\\7+\u001b>f+\t\t)\n\u0005\u0004\u0002(\u0005-\u0013q\u0013\t\u0004q\u0005e\u0015bAANs\t!Aj\u001c8h\u0003eIgn\u0019:f[\u0016tGOU1oO\u0016l\u0015\r]$fi&sG-\u001a=\u0015\u000bQ\f\t+!.\t\u000f\u0005\r\u0006\u00041\u0001\u0002&\u0006\u0019Q.\u00199\u0011\u000f\u0005\u001d\u0016\u0011WA.i6\u0011\u0011\u0011\u0016\u0006\u0005\u0003W\u000bi+A\u0004nkR\f'\r\\3\u000b\u0007\u0005=\u0016(\u0001\u0006d_2dWm\u0019;j_:LA!a-\u0002*\n\u0019Q*\u00199\t\u000f\u0005]\u0006\u00041\u0001\u0002\\\u0005Aa-\u001b7f]\u0006lW-\u0001\thKR\u0004\u0016M\u001d;ji&|g.\u00138g_R1\u0011QXAb\u0003'\u00042APA`\u0013\r\t\tm\u000b\u0002\u000e!\u0006\u0014H/\u001b;j_:LeNZ8\t\u000f\u0005\u0015\u0017\u00041\u0001\u0002H\u0006aa-\u001b7f\u001b\u0016$\u0018\rZ1uCB1\u0011\u0011OAe\u0003\u001bLA!a3\u0002\u0000\t\u00191+Z9\u0011\u0007=\u000by-C\u0002\u0002RB\u00131\u0003U1scV,GOR5mK6+G/\u00193bi\u0006Da!!6\u001a\u0001\u0004!\u0018A\u00049beRLG/[8o\u0007>,h\u000e^\u0001\u000fO\u0016$8i\u001c7v[:t\u0015-\\3t)\u0011\tY.!8\u0011\r\u0005\u001d\u00121JA.\u0011\u001d\tyN\u0007a\u0001\u0003C\faB]3rk&\u0014X\rZ*dQ\u0016l\u0017\r\u0005\u0003\u0002d\u0006]XBAAs\u0015\u0011\t9/!;\u0002\u000bQL\b/Z:\u000b\t\u0005-\u0018Q^\u0001\u0004gFd'b\u0001\u0019\u0002p*!\u0011\u0011_Az\u0003\u0019\t\u0007/Y2iK*\u0011\u0011Q_\u0001\u0004_J<\u0017\u0002BA}\u0003K\u0014!b\u0015;sk\u000e$H+\u001f9f\u00039!w\u000e\u0015:f%\u0016\fGm\u0015;faN$\"!a@\u0011\r\u0005\u001d\u00121JA_\u0003%\u0001\u0018M\u001d;ji&|g.\u0006\u0002\u0003\u0006A)\u0001Ha\u0002\u0003\f%\u0019!\u0011B\u001d\u0003\r=\u0003H/[8o!\rq$QB\u0005\u0004\u0005\u001fY#!\n,feRL7-\u0019#jgR\u0014\u0018NY;uK\u00124\u0015\u000e\\3tsN$X-\u001c)beRLG/[8o\u00035\u0001\u0018M\u001d;ji&|gn\u0018\u0013fcR!!Q\u0003B\u000e!\rA$qC\u0005\u0004\u00053I$\u0001B+oSRD\u0011B!\b\u001e\u0003\u0003\u0005\rA!\u0002\u0002\u0007a$\u0013'\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\nqAZ5mK&#\u00070A\u0006gS2,\u0017\n\u001a=`I\u0015\fH\u0003\u0002B\u000b\u0005OA\u0001B!\b!\u0003\u0003\u0005\r\u0001^\u0001\tM&dW-\u00133yA\u0005\u00112\u000f^1siB\u000b'\u000f^5uS>t'+Z1e)\u0011\u0011yC!\r\u0011\r\u0005\u001d\u00121\nB\u000b\u0011\u001d\u0011\u0019D\ta\u0001\u0005k\t\u0001C^3si&\u001c\u0017\rU1si&$\u0018n\u001c8\u0011\u0007y\u00129$C\u0002\u0003:-\u0012\u0001CV3si&\u001c\u0017\rU1si&$\u0018n\u001c8\u0002\u001d\u001d,Go\u00117fC:,\b/\u00138g_R1!q\bB$\u0005\u0017\u0002R\u0001\u000fB\u0004\u0005\u0003\u00022\u0001\u001cB\"\u0013\r\u0011)%\u001c\u0002\u0010\r&dWm\u00117fC:,\b/\u00138g_\"9!\u0011J\u0012A\u0002\t-\u0011\u0001\u00029beRDaA!\u0014$\u0001\u0004!\u0018AB2ve&#\u00070\u0001\u0005sK\u0006$G)\u0019;b+\t\u0011\u0019\u0006\u0005\u0004\u0002(\u0005-#Q\u000b\t\u0004}\t]\u0013b\u0001B-W\tIA)\u0019;b\u00052|7m[\u0001\u0011K:$\u0007+\u0019:uSRLwN\u001c*fC\u0012$\"Aa\f\u0002IY+'\u000f^5dC\u0012K7\u000f\u001e:jEV$X\r\u001a$jY\u0016\u001c\u0018p\u001d;f[J+\u0017\r\u001a)ja\u0016\u0004\"AP\u0014\u0014\u0005\u001d:DC\u0001B1\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!1\u000e\u0016\u0004i\n54F\u0001B8!\u0011\u0011\tHa\u001f\u000e\u0005\tM$\u0002\u0002B;\u0005o\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\te\u0014(\u0001\u0006b]:|G/\u0019;j_:LAA! \u0003t\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class VerticaDistributedFilesystemReadPipe
implements VerticaPipeInterface,
VerticaPipeReadInterface {
    private final DistributedFilesystemReadConfig config;
    private final FileStoreLayerInterface fileStoreLayer;
    private final JdbcLayerInterface jdbcLayer;
    private final SchemaToolsInterface schemaTools;
    private final CleanupUtilsInterface cleanupUtils;
    private final int dataSize;
    private final Logger logger;
    private final int maxFileSize;
    private final int maxRowGroupSize;
    private Option<VerticaDistributedFilesystemPartition> partition;
    private int fileIdx;

    public static int $lessinit$greater$default$6() {
        return VerticaDistributedFilesystemReadPipe$.MODULE$.$lessinit$greater$default$6();
    }

    public DistributedFilesystemReadConfig config() {
        return this.config;
    }

    public FileStoreLayerInterface fileStoreLayer() {
        return this.fileStoreLayer;
    }

    public JdbcLayerInterface jdbcLayer() {
        return this.jdbcLayer;
    }

    public SchemaToolsInterface schemaTools() {
        return this.schemaTools;
    }

    public CleanupUtilsInterface cleanupUtils() {
        return this.cleanupUtils;
    }

    public int dataSize() {
        return this.dataSize;
    }

    private Logger logger() {
        return this.logger;
    }

    private int maxFileSize() {
        return this.maxFileSize;
    }

    private int maxRowGroupSize() {
        return this.maxRowGroupSize;
    }

    private Either<ConnectorError, VerticaMetadata> retrieveMetadata() {
        Right right;
        Either<ConnectorError, StructType> either = this.schemaTools().readSchema(this.jdbcLayer(), this.config().tableSource());
        if (either instanceof Right) {
            Right right2 = (Right)either;
            StructType schema = (StructType)right2.value();
            right = package$.MODULE$.Right().apply((Object)new VerticaReadMetadata(schema));
        } else if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            right = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError(either);
        }
        return right;
    }

    private String addPushdownFilters(List<PushdownFilter> pushdownFilters) {
        List<PushdownFilter> list = pushdownFilters;
        String string = Nil$.MODULE$.equals(list) ? "" : new StringBuilder(7).append(" WHERE ").append(((TraversableOnce)pushdownFilters.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getFilterString(), List$.MODULE$.canBuildFrom())).mkString(" AND ")).toString();
        return string;
    }

    @Override
    public Either<ConnectorError, VerticaMetadata> getMetadata() {
        Right right;
        Option<VerticaReadMetadata> option = this.config().metadata();
        if (option instanceof Some) {
            Some some = (Some)option;
            VerticaReadMetadata data = (VerticaReadMetadata)some.value();
            right = package$.MODULE$.Right().apply((Object)data);
        } else if (None$.MODULE$.equals(option)) {
            right = this.retrieveMetadata();
        } else {
            throw new MatchError(option);
        }
        return right;
    }

    @Override
    public Either<ConnectorError, Object> getDataBlockSize() {
        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)this.dataSize()));
    }

    private int incrementRangeMapGetIndex(Map<String, Object> map, String filename) {
        if (!map.contains((Object)filename)) {
            map.update((Object)filename, (Object)BoxesRunTime.boxToInteger((int)1));
        } else {
            map.update((Object)filename, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)map.apply((Object)filename)) + 1)));
        }
        return BoxesRunTime.unboxToInt((Object)map.apply((Object)filename)) - 1;
    }

    private PartitionInfo getPartitionInfo(Seq<ParquetFileMetadata> fileMetadata, int partitionCount) {
        PartitionInfo partitionInfo;
        int totalRowGroups = BoxesRunTime.unboxToInt((Object)((TraversableOnce)fileMetadata.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.rowGroupCount()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        if (totalRowGroups == 0) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("No data. Returning empty partition list.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            partitionInfo = new PartitionInfo((InputPartition[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(InputPartition.class)));
        } else {
            BoxedUnit boxedUnit;
            int extraSpace = totalRowGroups % partitionCount == 0 ? 0 : 1;
            int rowGroupRoom = totalRowGroups / partitionCount + extraSpace;
            IntRef i = IntRef.create((int)0);
            ObjectRef partitions = ObjectRef.create((Object)Nil$.MODULE$);
            ObjectRef curFileRanges = ObjectRef.create((Object)Nil$.MODULE$);
            Map rangeCountMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Creating partitions.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            fileMetadata.foreach((Function1 & Serializable & scala.Serializable)m -> {
                VerticaDistributedFilesystemReadPipe.$anonfun$getPartitionInfo$2(this, i, rowGroupRoom, rangeCountMap, curFileRanges, partitions, m);
                return BoxedUnit.UNIT;
            });
            if (((List)curFileRanges.elem).nonEmpty()) {
                VerticaDistributedFilesystemPartition partition = new VerticaDistributedFilesystemPartition((Seq<ParquetFileRange>)((List)curFileRanges.elem), VerticaDistributedFilesystemPartition$.MODULE$.apply$default$2());
                partitions.elem = (List)((List)partitions.elem).$colon$plus((Object)partition, List$.MODULE$.canBuildFrom());
            }
            partitions.elem = (List)((List)partitions.elem).map((Function1 & Serializable & scala.Serializable)part -> {
                Some x$1 = new Some((Object)rangeCountMap.toMap(Predef$.MODULE$.$conforms()));
                Seq<ParquetFileRange> x$2 = part.copy$default$1();
                return part.copy(x$2, (Option<scala.collection.immutable.Map<String, Object>>)x$1);
            }, List$.MODULE$.canBuildFrom());
            partitionInfo = new PartitionInfo((InputPartition[])((List)partitions.elem).toArray(ClassTag$.MODULE$.apply(InputPartition.class)));
        }
        return partitionInfo;
    }

    private Either<ConnectorError, String> getColumnNames(StructType requiredSchema) {
        Left left;
        Either<ConnectorError, Seq<ColumnDef>> either = this.schemaTools().getColumnInfo(this.jdbcLayer(), this.config().tableSource());
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err.context("Failed to get table schema when checking for fields that need casts."));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq columnDefs = (Seq)right.value();
            left = package$.MODULE$.Right().apply((Object)this.schemaTools().makeColumnsString((Seq<ColumnDef>)columnDefs, requiredSchema));
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Either<ConnectorError, PartitionInfo> doPreReadSteps() {
        fileStoreConfig = this.config().fileStoreConfig();
        v0 = new StringOps(Predef$.MODULE$.augmentString(fileStoreConfig.address())).takeRight(1);
        var4_2 = "/";
        if (!(v0 == null ? var4_2 != null : v0.equals(var4_2) == false)) ** GOTO lbl-1000
        v1 = new StringOps(Predef$.MODULE$.augmentString(fileStoreConfig.address())).takeRight(1);
        var5_3 = "\\";
        if (!(v1 != null ? v1.equals(var5_3) == false : var5_3 != null)) lbl-1000:
        // 2 sources

        {
            v2 = "";
        } else {
            v2 = "/";
        }
        delimiter = v2;
        hdfsPath = new StringBuilder(0).append(fileStoreConfig.address()).append(delimiter).append(this.config().tableSource().identifier()).toString();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(13).append("Export path: ").append(hdfsPath).toString());
            v3 = BoxedUnit.UNIT;
        } else {
            v3 = BoxedUnit.UNIT;
        }
        var8_7 = ret = this.getMetadata().flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$doPreReadSteps$1(com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe com.vertica.spark.config.FileStoreConfig java.lang.String com.vertica.spark.config.VerticaMetadata ), (Lcom/vertica/spark/config/VerticaMetadata;)Lscala/util/Either;)((VerticaDistributedFilesystemReadPipe)this, (FileStoreConfig)fileStoreConfig, (String)hdfsPath));
        if (var8_7 instanceof Left) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder(31).append("Cleaning up all files in path: ").append(hdfsPath).toString());
                v4 = BoxedUnit.UNIT;
            } else {
                v4 = BoxedUnit.UNIT;
            }
            this.cleanupUtils().cleanupAll(this.fileStoreLayer(), hdfsPath);
            var1_8 = this.jdbcLayer().close();
        } else {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Reading data from Parquet file.");
                v5 = BoxedUnit.UNIT;
            } else {
                v5 = BoxedUnit.UNIT;
            }
            var1_8 = v5;
        }
        return ret;
    }

    public Option<VerticaDistributedFilesystemPartition> partition() {
        return this.partition;
    }

    public void partition_$eq(Option<VerticaDistributedFilesystemPartition> x$1) {
        this.partition = x$1;
    }

    public int fileIdx() {
        return this.fileIdx;
    }

    public void fileIdx_$eq(int x$1) {
        this.fileIdx = x$1;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> startPartitionRead(VerticaPartition verticaPartition) {
        Right right;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting partition read.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        VerticaPartition verticaPartition2 = verticaPartition;
        if (verticaPartition2 instanceof VerticaDistributedFilesystemPartition) {
            VerticaDistributedFilesystemPartition verticaDistributedFilesystemPartition = (VerticaDistributedFilesystemPartition)verticaPartition2;
            right = package$.MODULE$.Right().apply((Object)verticaDistributedFilesystemPartition);
        } else {
            right = package$.MODULE$.Left().apply((Object)new InvalidPartition());
        }
        return right.map((Function1 & Serializable & scala.Serializable)part -> {
            this.partition_$eq((Option<VerticaDistributedFilesystemPartition>)new Some(part));
            BoxedUnit x$18 = BoxedUnit.UNIT;
            this.fileIdx_$eq(0);
            BoxedUnit x$19 = BoxedUnit.UNIT;
            return new Tuple3(part, (Object)x$18, (Object)x$19);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$20 -> {
            Either<ConnectorError, BoxedUnit> either;
            Tuple3 tuple3 = x$20;
            if (tuple3 == null) throw new MatchError((Object)tuple3);
            VerticaDistributedFilesystemPartition part = (VerticaDistributedFilesystemPartition)tuple3._1();
            Option option = part.fileRanges().headOption();
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("No files to read set on partition.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                either = package$.MODULE$.Left().apply((Object)new DoneReading());
                return either.map((Function1 & Serializable & scala.Serializable)ret -> {
                    VerticaDistributedFilesystemReadPipe.$anonfun$startPartitionRead$3(ret);
                    return BoxedUnit.UNIT;
                });
            } else {
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                Some some = (Some)option;
                ParquetFileRange head = (ParquetFileRange)some.value();
                either = this.fileStoreLayer().openReadParquetFile(head);
            }
            return either.map((Function1 & Serializable & scala.Serializable)ret -> {
                VerticaDistributedFilesystemReadPipe.$anonfun$startPartitionRead$3(ret);
                return BoxedUnit.UNIT;
            });
        });
    }

    private Option<FileCleanupInfo> getCleanupInfo(VerticaDistributedFilesystemPartition part, int curIdx) {
        Some some;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(44).append("Getting cleanup info for partition with idx ").append(curIdx).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (curIdx >= part.fileRanges().size()) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(40).append("Invalid fileIdx ").append(this.fileIdx()).append(", can't perform cleanup.").toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            some = None$.MODULE$;
        } else {
            some = new Some((Object)BoxedUnit.UNIT);
        }
        return some.map((Function1 & Serializable & scala.Serializable)x$21 -> {
            ParquetFileRange curRange = (ParquetFileRange)part.fileRanges().apply(curIdx);
            return new Tuple2(x$21, (Object)curRange);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$22 -> {
            None$ none$;
            Tuple2 tuple2 = x$22;
            if (tuple2 != null) {
                Some some;
                scala.collection.immutable.Map rangeCountMap;
                ParquetFileRange curRange = (ParquetFileRange)tuple2._2();
                Option<scala.collection.immutable.Map<String, Object>> option = part.rangeCountMap();
                if (option instanceof Some && (rangeCountMap = (scala.collection.immutable.Map)(some = (Some)option).value()).contains((Object)curRange.filename())) {
                    None$ none$2;
                    Option<Object> option2 = curRange.rangeIdx();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        int rangeIdx = BoxesRunTime.unboxToInt((Object)some2.value());
                        none$2 = new Some((Object)new FileCleanupInfo(curRange.filename(), rangeIdx, BoxesRunTime.unboxToInt((Object)rangeCountMap.apply((Object)curRange.filename()))));
                    } else if (None$.MODULE$.equals(option2)) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn(new StringBuilder(63).append("Missing range count index. Not performing any cleanup for file ").append(curRange.filename()).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        none$2 = None$.MODULE$;
                    } else {
                        throw new MatchError(option2);
                    }
                    none$ = none$2;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder(61).append("Missing range count map. Not performing any cleanup for file ").append(curRange.filename()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    none$ = None$.MODULE$;
                } else {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder(70).append("Missing value in range count map. Not performing any cleanup for file ").append(curRange.filename()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    none$ = None$.MODULE$;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Option option = none$.map((Function1 & Serializable & scala.Serializable)ret -> ret);
            return option;
        });
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Either<ConnectorError, DataBlock> readData() {
        block40: {
            block42: {
                block44: {
                    block43: {
                        block41: {
                            block39: {
                                var9_1 = this.partition();
                                if (None$.MODULE$.equals(var9_1)) {
                                    return package$.MODULE$.Left().apply((Object)new UninitializedReadError());
                                }
                                if (!(var9_1 instanceof Some)) {
                                    throw new MatchError(var9_1);
                                }
                                var10_2 = (Some)var9_1;
                                var7_4 = p = (VerticaDistributedFilesystemPartition)var10_2.value();
                                part = var7_4;
                                var13_6 = this.fileStoreLayer().readDataFromParquetFile(this.dataSize());
                                if (var13_6 instanceof Left) {
                                    var14_7 = (Left)var13_6;
                                    err = (ConnectorError)var14_7.value();
                                    var4_9 = package$.MODULE$.Left().apply((Object)err);
                                } else if (var13_6 instanceof Right) {
                                    var16_10 = (Right)var13_6;
                                    data = (DataBlock)var16_10.value();
                                    if (data.data().nonEmpty()) {
                                        v0 = package$.MODULE$.Right().apply((Object)data);
                                    } else {
                                        if (this.logger().underlying().isInfoEnabled()) {
                                            this.logger().underlying().info("Hit done reading for file segment.");
                                            v1 = BoxedUnit.UNIT;
                                        } else {
                                            v1 = BoxedUnit.UNIT;
                                        }
                                        var18_12 = this.getCleanupInfo(part, this.fileIdx());
                                        if (var18_12 instanceof Some) {
                                            var19_13 = (Some)var18_12;
                                            cleanupInfo = (FileCleanupInfo)var19_13.value();
                                            var21_15 = this.cleanupUtils().checkAndCleanup(this.fileStoreLayer(), cleanupInfo);
                                            if (var21_15 instanceof Left) {
                                                var22_16 = (Left)var21_15;
                                                err = (ConnectorError)var22_16.value();
                                                if (this.logger().underlying().isWarnEnabled()) {
                                                    this.logger().underlying().warn(new StringBuilder(69).append("Ran into error when calling cleaning up. Treating as non-fatal. Err: ").append(err.getFullContext()).toString());
                                                    v2 = BoxedUnit.UNIT;
                                                } else {
                                                    v2 = BoxedUnit.UNIT;
                                                }
                                                var6_18 = v2;
                                            } else if (var21_15 instanceof Right) {
                                                var6_19 = BoxedUnit.UNIT;
                                            } else {
                                                throw new MatchError(var21_15);
                                            }
                                            var5_20 = BoxedUnit.UNIT;
                                        } else if (None$.MODULE$.equals(var18_12)) {
                                            if (this.logger().underlying().isWarnEnabled()) {
                                                this.logger().underlying().warn("No cleanup info found.");
                                                v3 = BoxedUnit.UNIT;
                                            } else {
                                                v3 = BoxedUnit.UNIT;
                                            }
                                            var5_21 = v3;
                                        } else {
                                            throw new MatchError(var18_12);
                                        }
                                        this.fileIdx_$eq(this.fileIdx() + 1);
                                        if (this.fileIdx() >= part.fileRanges().size()) {
                                            return package$.MODULE$.Right().apply((Object)data);
                                        }
                                        v0 = this.fileStoreLayer().closeReadParquetFile().flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$readData$1(com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe com.vertica.spark.datasource.core.VerticaDistributedFilesystemPartition scala.runtime.BoxedUnit ), (Lscala/runtime/BoxedUnit;)Lscala/util/Either;)((VerticaDistributedFilesystemReadPipe)this, (VerticaDistributedFilesystemPartition)part));
                                    }
                                    var4_9 = v0;
                                } else {
                                    throw new MatchError(var13_6);
                                }
                                ret = var4_9;
                                var24_23 = new Tuple2((Object)ret, this.getCleanupInfo(part, this.fileIdx()));
                                if (var24_23 == null) break block39;
                                var25_24 = (Either)var24_23._1();
                                var26_25 = (Option)var24_23._2();
                                if (!(var25_24 instanceof Left) || !(var26_25 instanceof Some)) break block39;
                                var27_26 = (Some)var26_25;
                                cleanupInfo = (FileCleanupInfo)var27_26.value();
                                var29_28 = this.cleanupUtils().checkAndCleanup(this.fileStoreLayer(), cleanupInfo);
                                if (!(var29_28 instanceof Right)) ** GOTO lbl-1000
                                var30_29 = (Right)var29_28;
                                var31_30 = (BoxedUnit)var30_29.value();
                                v4 = BoxedUnit.UNIT;
                                var32_31 = var31_30;
                                if (!(v4 != null ? v4.equals(var32_31) == false : var32_31 != null)) {
                                    var3_32 = BoxedUnit.UNIT;
                                } else if (var29_28 instanceof Left) {
                                    var33_34 = (Left)var29_28;
                                    err = (ConnectorError)var33_34.value();
                                    if (this.logger().underlying().isWarnEnabled()) {
                                        this.logger().underlying().warn(new StringBuilder(33).append("Ran into error when cleaning up: ").append(err.getFullContext()).toString());
                                        v5 = BoxedUnit.UNIT;
                                    } else {
                                        v5 = BoxedUnit.UNIT;
                                    }
                                    var3_33 = v5;
                                } else {
                                    throw new MatchError(var29_28);
                                }
                                var1_36 = BoxedUnit.UNIT;
                                break block40;
                            }
                            if (var24_23 == null) break block41;
                            var35_40 = (Either)var24_23._1();
                            var36_41 = (Option)var24_23._2();
                            if (!(var35_40 instanceof Left) || !None$.MODULE$.equals(var36_41)) break block41;
                            if (this.logger().underlying().isWarnEnabled()) {
                                this.logger().underlying().warn("No cleanup info found");
                                v6 = BoxedUnit.UNIT;
                            } else {
                                v6 = BoxedUnit.UNIT;
                            }
                            var1_37 = v6;
                            break block40;
                        }
                        if (var24_23 == null) break block42;
                        var37_42 = (Either)var24_23._1();
                        var38_43 = (Option)var24_23._2();
                        if (!(var37_42 instanceof Right)) break block42;
                        var39_44 = (Right)var37_42;
                        dataBlock = (DataBlock)var39_44.value();
                        if (!(var38_43 instanceof Some)) break block42;
                        var41_46 = (Some)var38_43;
                        cleanupInfo = (FileCleanupInfo)var41_46.value();
                        if (!dataBlock.data().isEmpty()) break block43;
                        var43_48 = this.cleanupUtils().checkAndCleanup(this.fileStoreLayer(), cleanupInfo);
                        if (!(var43_48 instanceof Right)) ** GOTO lbl-1000
                        var44_49 = (Right)var43_48;
                        var45_50 = (BoxedUnit)var44_49.value();
                        v7 = BoxedUnit.UNIT;
                        var46_51 = var45_50;
                        if (!(v7 != null ? v7.equals(var46_51) == false : var46_51 != null)) {
                            var2_52 = BoxedUnit.UNIT;
                        } else if (var43_48 instanceof Left) {
                            var47_54 = (Left)var43_48;
                            err = (ConnectorError)var47_54.value();
                            if (this.logger().underlying().isWarnEnabled()) {
                                this.logger().underlying().warn(new StringBuilder(33).append("Ran into error when cleaning up: ").append(err.getFullContext()).toString());
                                v8 = BoxedUnit.UNIT;
                            } else {
                                v8 = BoxedUnit.UNIT;
                            }
                            var2_53 = v8;
                        } else {
                            throw new MatchError(var43_48);
                        }
                        v9 = BoxedUnit.UNIT;
                        break block44;
                    }
                    v9 = BoxedUnit.UNIT;
                }
                var1_38 = v9;
                break block40;
            }
            if (var24_23 == null) ** GOTO lbl-1000
            var49_56 = (Either)var24_23._1();
            var50_57 = (Option)var24_23._2();
            if (var49_56 instanceof Right && None$.MODULE$.equals(var50_57)) {
                var1_39 = BoxedUnit.UNIT;
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var24_23);
            }
        }
        return ret;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> endPartitionRead() {
        return this.fileStoreLayer().closeReadParquetFile();
    }

    public static final /* synthetic */ void $anonfun$getPartitionInfo$2(VerticaDistributedFilesystemReadPipe $this, IntRef i$1, int rowGroupRoom$1, Map rangeCountMap$1, ObjectRef curFileRanges$1, ObjectRef partitions$1, ParquetFileMetadata m) {
        BoxedUnit boxedUnit;
        int size = m.rowGroupCount();
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(37).append("Splitting file ").append(m.filename()).append(" with row group count ").append(size).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        int low = 0;
        for (int j = 0; j < size; ++j) {
            if (i$1.elem == rowGroupRoom$1 - 1) {
                BoxedUnit boxedUnit2;
                int rangeIdx = $this.incrementRangeMapGetIndex((Map<String, Object>)rangeCountMap$1, m.filename());
                ParquetFileRange frange = new ParquetFileRange(m.filename(), low, j, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)rangeIdx)));
                curFileRanges$1.elem = (List)((List)curFileRanges$1.elem).$colon$plus((Object)frange, List$.MODULE$.canBuildFrom());
                VerticaDistributedFilesystemPartition partition = new VerticaDistributedFilesystemPartition((Seq<ParquetFileRange>)((List)curFileRanges$1.elem), VerticaDistributedFilesystemPartition$.MODULE$.apply$default$2());
                partitions$1.elem = (List)((List)partitions$1.elem).$colon$plus((Object)partition, List$.MODULE$.canBuildFrom());
                curFileRanges$1.elem = Nil$.MODULE$;
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug(new StringBuilder(65).append("Reached partition with file ").append(m.filename()).append(" , range low: ").append(low).append(" , range high: ").append(j).append(" , idx: ").append(rangeIdx).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                i$1.elem = 0;
                low = j + 1;
                continue;
            }
            if (j == size - 1) {
                BoxedUnit boxedUnit3;
                int rangeIdx = $this.incrementRangeMapGetIndex((Map<String, Object>)rangeCountMap$1, m.filename());
                ParquetFileRange frange = new ParquetFileRange(m.filename(), low, j, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)rangeIdx)));
                curFileRanges$1.elem = (List)((List)curFileRanges$1.elem).$colon$plus((Object)frange, List$.MODULE$.canBuildFrom());
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug(new StringBuilder(57).append("Reached end of file ").append(m.filename()).append(" , range low: ").append(low).append(" , range high: ").append(j).append(" , idx: ").append(rangeIdx).toString());
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                ++i$1.elem;
                continue;
            }
            ++i$1.elem;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$doPreReadSteps$5(VerticaDistributedFilesystemReadPipe $this, boolean exportDone) {
        ValidFilePermissions filePermissions = $this.config().filePermissions();
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exportDone), (Object)filePermissions);
    }

    public static final /* synthetic */ Either $anonfun$doPreReadSteps$11(VerticaDistributedFilesystemReadPipe $this, String hdfsPath$1, boolean dirExists) {
        return (!dirExists ? package$.MODULE$.Right().apply((Object)Nil$.MODULE$) : $this.fileStoreLayer().getFileList(hdfsPath$1)).map((Function1 & Serializable & scala.Serializable)fullFileList -> {
            BoxedUnit boxedUnit;
            BoxedUnit x$9;
            BoxedUnit boxedUnit2;
            int n;
            Seq parquetFileList = (Seq)fullFileList.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)x.endsWith(".parquet")));
            Option<Object> option = $this.config().partitionCount();
            if (option instanceof Some) {
                int count;
                Some some = (Some)option;
                n = count = BoxesRunTime.unboxToInt((Object)some.value());
            } else if (None$.MODULE$.equals(option)) {
                n = parquetFileList.size();
            } else {
                throw new MatchError(option);
            }
            int requestedPartitionCount = n;
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringBuilder(27).append("Requested partition count: ").append(requestedPartitionCount).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = x$9 = BoxedUnit.UNIT;
            }
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringBuilder(24).append("Parquet file list size: ").append(parquetFileList.size()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$10 = boxedUnit;
            return new Tuple5(fullFileList, (Object)parquetFileList, (Object)BoxesRunTime.boxToInteger((int)requestedPartitionCount), (Object)x$9, (Object)x$10);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$14 -> {
            Tuple5 tuple5 = x$14;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            Seq parquetFileList = (Seq)tuple5._2();
            int requestedPartitionCount = BoxesRunTime.unboxToInt((Object)tuple5._3());
            Either either = ((Either)implicits$.MODULE$.toTraverseOps((Object)parquetFileList.toList(), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)filename -> $this.fileStoreLayer().getParquetFileMetadata((String)filename), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable & scala.Serializable)fileMetadata -> {
                int n;
                Either<ConnectorError, BoxedUnit> x$12;
                Either<ConnectorError, BoxedUnit> either;
                BoxedUnit x$11;
                BoxedUnit boxedUnit;
                int totalRowGroups = BoxesRunTime.unboxToInt((Object)((TraversableOnce)fileMetadata.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.rowGroupCount()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info(new StringBuilder(18).append("Total row groups: ").append(totalRowGroups).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = x$11 = BoxedUnit.UNIT;
                }
                if (totalRowGroups == 0) {
                    BoxedUnit boxedUnit2;
                    if ($this.logger().underlying().isDebugEnabled()) {
                        $this.logger().underlying().debug(new StringBuilder(37).append("Cleaning up empty directory in path: ").append(hdfsPath$1).toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    either = $this.cleanupUtils().cleanupAll($this.fileStoreLayer(), hdfsPath$1);
                } else {
                    either = x$12 = BoxedUnit.UNIT;
                }
                if (totalRowGroups < requestedPartitionCount) {
                    BoxedUnit boxedUnit3;
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(43).append("Less than ").append(requestedPartitionCount).append(" partitions required, only using ").append(totalRowGroups).toString());
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    n = totalRowGroups;
                } else {
                    n = requestedPartitionCount;
                }
                int partitionCount = n;
                PartitionInfo partitionInfo = $this.getPartitionInfo((Seq<ParquetFileMetadata>)fileMetadata, partitionCount);
                return new Tuple6(fileMetadata, (Object)BoxesRunTime.boxToInteger((int)totalRowGroups), (Object)x$11, x$12, (Object)BoxesRunTime.boxToInteger((int)partitionCount), (Object)partitionInfo);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$13 -> {
                Tuple6 tuple6 = x$13;
                if (tuple6 == null) {
                    throw new MatchError((Object)tuple6);
                }
                PartitionInfo partitionInfo = (PartitionInfo)tuple6._6();
                Either either = $this.jdbcLayer().close().map((Function1 & Serializable & scala.Serializable)_ -> partitionInfo);
                return either;
            });
            return either;
        });
    }

    public static final /* synthetic */ Either $anonfun$doPreReadSteps$1(VerticaDistributedFilesystemReadPipe $this, FileStoreConfig fileStoreConfig$1, String hdfsPath$1, VerticaMetadata _) {
        return $this.jdbcLayer().configureSession($this.fileStoreLayer()).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            BoxedUnit boxedUnit;
            ValidFilePermissions perm = $this.config().filePermissions();
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringBuilder(46).append("Creating unique directory: ").append(fileStoreConfig$1.address()).append(" with permissions: ").append(perm).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$5 = boxedUnit;
            return new Tuple3(x$4, (Object)perm, (Object)x$5);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$17 -> {
            Right right;
            Tuple3 tuple3 = x$17;
            if (tuple3 == null) throw new MatchError((Object)tuple3);
            ValidFilePermissions perm = (ValidFilePermissions)tuple3._2();
            Either<ConnectorError, BoxedUnit> either = $this.fileStoreLayer().createDir(fileStoreConfig$1.address(), perm.toString());
            if (either instanceof Left) {
                Right right2;
                Left left = (Left)either;
                ConnectorError err = (ConnectorError)left.value();
                ConnectorError connectorError = err.getUnderlyingError();
                if (connectorError instanceof CreateDirectoryAlreadyExistsError) {
                    BoxedUnit boxedUnit;
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(27).append("Directory already existed: ").append(fileStoreConfig$1.address()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    right2 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                } else {
                    right2 = package$.MODULE$.Left().apply((Object)err.context(new StringBuilder(28).append("Failed to create directory: ").append(fileStoreConfig$1.address()).toString()));
                }
                right = right2;
                return right.flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.fileStoreLayer().fileExists(hdfsPath$1).map((Function1 & Serializable & scala.Serializable)exportDone -> VerticaDistributedFilesystemReadPipe.$anonfun$doPreReadSteps$5($this, BoxesRunTime.unboxToBoolean((Object)exportDone))).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> {
                    Tuple2 tuple2 = x$16;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    boolean exportDone = tuple2._1$mcZ$sp();
                    ValidFilePermissions filePermissions = (ValidFilePermissions)tuple2._2();
                    Either either = $this.getColumnNames($this.config().getRequiredSchema()).map((Function1 & Serializable & scala.Serializable)cols -> {
                        BoxedUnit boxedUnit;
                        String string;
                        BoxedUnit boxedUnit2;
                        BoxedUnit boxedUnit3;
                        if ($this.logger().underlying().isInfoEnabled()) {
                            $this.logger().underlying().info(new StringBuilder(19).append("Columns requested: ").append((String)cols).toString());
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        BoxedUnit x$6 = boxedUnit3;
                        String pushdownSql = $this.addPushdownFilters($this.config().getPushdownFilters());
                        if ($this.logger().underlying().isInfoEnabled()) {
                            $this.logger().underlying().info(new StringBuilder(18).append("Pushdown filters: ").append(pushdownSql).toString());
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        BoxedUnit x$7 = boxedUnit2;
                        TableSource tableSource = $this.config().tableSource();
                        if (tableSource instanceof TableName) {
                            TableName tableName = (TableName)tableSource;
                            string = tableName.getFullTableName();
                        } else if (tableSource instanceof TableQuery) {
                            TableQuery tableQuery = (TableQuery)tableSource;
                            String query = tableQuery.query();
                            string = new StringBuilder(7).append("(").append(query).append(") AS x").toString();
                        } else {
                            throw new MatchError((Object)tableSource);
                        }
                        String exportSource = string;
                        if ($this.logger().underlying().isInfoEnabled()) {
                            $this.logger().underlying().info(new StringBuilder(15).append("Export Source: ").append(exportSource).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit x$8 = boxedUnit;
                        String exportStatement = new StringBuilder(114).append("EXPORT TO PARQUET(directory = '").append(hdfsPath$1).append("', fileSizeMB = ").append($this.maxFileSize()).append(", rowGroupSizeMB = ").append($this.maxRowGroupSize()).append(", fileMode = '").append(filePermissions).append("', dirMode = '").append(filePermissions).append("') AS ").append("SELECT ").append((String)cols).append(" FROM ").append(exportSource).append(pushdownSql).append(";").toString();
                        return new Tuple7(cols, (Object)x$6, (Object)pushdownSql, (Object)x$7, (Object)exportSource, (Object)x$8, (Object)exportStatement);
                    }).flatMap((Function1 & Serializable & scala.Serializable)x$15 -> {
                        Right right;
                        Tuple7 tuple7 = x$15;
                        if (tuple7 != null) {
                            String exportStatement = (String)tuple7._7();
                            if (exportDone) {
                                BoxedUnit boxedUnit;
                                if ($this.logger().underlying().isInfoEnabled()) {
                                    $this.logger().underlying().info("Export already done, skipping export step.");
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                            } else {
                                BoxedUnit boxedUnit;
                                if ($this.logger().underlying().isInfoEnabled()) {
                                    $this.logger().underlying().info(new StringBuilder(28).append("Exporting using statement: \n").append(exportStatement).toString());
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                right = EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither($this.jdbcLayer().execute(exportStatement, $this.jdbcLayer().execute$default$2())), (Function1 & Serializable & scala.Serializable)err -> new ExportFromVerticaError((ConnectorError)err));
                            }
                        } else {
                            throw new MatchError((Object)tuple7);
                        }
                        Either either = right.flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.fileStoreLayer().fileExists(hdfsPath$1).flatMap((Function1 & Serializable & scala.Serializable)dirExists -> VerticaDistributedFilesystemReadPipe.$anonfun$doPreReadSteps$11($this, hdfsPath$1, BoxesRunTime.unboxToBoolean((Object)dirExists))));
                        return either;
                    });
                    return either;
                }));
            } else {
                if (!(either instanceof Right)) throw new MatchError(either);
                right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            return right.flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.fileStoreLayer().fileExists(hdfsPath$1).map((Function1 & Serializable & scala.Serializable)exportDone -> VerticaDistributedFilesystemReadPipe.$anonfun$doPreReadSteps$5($this, BoxesRunTime.unboxToBoolean((Object)exportDone))).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> {
                Tuple2 tuple2 = x$16;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                boolean exportDone = tuple2._1$mcZ$sp();
                ValidFilePermissions filePermissions = (ValidFilePermissions)tuple2._2();
                Either either = $this.getColumnNames($this.config().getRequiredSchema()).map((Function1 & Serializable & scala.Serializable)cols -> {
                    BoxedUnit boxedUnit;
                    String string;
                    BoxedUnit boxedUnit2;
                    BoxedUnit boxedUnit3;
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(19).append("Columns requested: ").append((String)cols).toString());
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    BoxedUnit x$6 = boxedUnit3;
                    String pushdownSql = $this.addPushdownFilters($this.config().getPushdownFilters());
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(18).append("Pushdown filters: ").append(pushdownSql).toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    BoxedUnit x$7 = boxedUnit2;
                    TableSource tableSource = $this.config().tableSource();
                    if (tableSource instanceof TableName) {
                        TableName tableName = (TableName)tableSource;
                        string = tableName.getFullTableName();
                    } else if (tableSource instanceof TableQuery) {
                        TableQuery tableQuery = (TableQuery)tableSource;
                        String query = tableQuery.query();
                        string = new StringBuilder(7).append("(").append(query).append(") AS x").toString();
                    } else {
                        throw new MatchError((Object)tableSource);
                    }
                    String exportSource = string;
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(15).append("Export Source: ").append(exportSource).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit x$8 = boxedUnit;
                    String exportStatement = new StringBuilder(114).append("EXPORT TO PARQUET(directory = '").append(hdfsPath$1).append("', fileSizeMB = ").append($this.maxFileSize()).append(", rowGroupSizeMB = ").append($this.maxRowGroupSize()).append(", fileMode = '").append(filePermissions).append("', dirMode = '").append(filePermissions).append("') AS ").append("SELECT ").append((String)cols).append(" FROM ").append(exportSource).append(pushdownSql).append(";").toString();
                    return new Tuple7(cols, (Object)x$6, (Object)pushdownSql, (Object)x$7, (Object)exportSource, (Object)x$8, (Object)exportStatement);
                }).flatMap((Function1 & Serializable & scala.Serializable)x$15 -> {
                    Right right;
                    Tuple7 tuple7 = x$15;
                    if (tuple7 != null) {
                        String exportStatement = (String)tuple7._7();
                        if (exportDone) {
                            BoxedUnit boxedUnit;
                            if ($this.logger().underlying().isInfoEnabled()) {
                                $this.logger().underlying().info("Export already done, skipping export step.");
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                        } else {
                            BoxedUnit boxedUnit;
                            if ($this.logger().underlying().isInfoEnabled()) {
                                $this.logger().underlying().info(new StringBuilder(28).append("Exporting using statement: \n").append(exportStatement).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            right = EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither($this.jdbcLayer().execute(exportStatement, $this.jdbcLayer().execute$default$2())), (Function1 & Serializable & scala.Serializable)err -> new ExportFromVerticaError((ConnectorError)err));
                        }
                    } else {
                        throw new MatchError((Object)tuple7);
                    }
                    Either either = right.flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.fileStoreLayer().fileExists(hdfsPath$1).flatMap((Function1 & Serializable & scala.Serializable)dirExists -> VerticaDistributedFilesystemReadPipe.$anonfun$doPreReadSteps$11($this, hdfsPath$1, BoxesRunTime.unboxToBoolean((Object)dirExists))));
                    return either;
                });
                return either;
            }));
        });
    }

    public static final /* synthetic */ void $anonfun$startPartitionRead$3(BoxedUnit ret) {
    }

    public static final /* synthetic */ Either $anonfun$readData$1(VerticaDistributedFilesystemReadPipe $this, VerticaDistributedFilesystemPartition part$2, BoxedUnit _2) {
        return $this.fileStoreLayer().openReadParquetFile((ParquetFileRange)part$2.fileRanges().apply($this.fileIdx())).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.fileStoreLayer().readDataFromParquetFile($this.dataSize()).map((Function1 & Serializable & scala.Serializable)data -> data));
    }

    public VerticaDistributedFilesystemReadPipe(DistributedFilesystemReadConfig config, FileStoreLayerInterface fileStoreLayer, JdbcLayerInterface jdbcLayer, SchemaToolsInterface schemaTools, CleanupUtilsInterface cleanupUtils, int dataSize) {
        this.config = config;
        this.fileStoreLayer = fileStoreLayer;
        this.jdbcLayer = jdbcLayer;
        this.schemaTools = schemaTools;
        this.cleanupUtils = cleanupUtils;
        this.dataSize = dataSize;
        this.logger = LogProvider$.MODULE$.getLogger(VerticaDistributedFilesystemReadPipe.class);
        this.maxFileSize = config.maxFileSize();
        this.maxRowGroupSize = config.maxRowGroupSize();
        this.partition = None$.MODULE$;
        this.fileIdx = 0;
    }
}

