/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.core;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.DistributedFilesystemWriteConfig;
import com.vertica.spark.config.EscapeUtils$;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.config.ValidColumnList;
import com.vertica.spark.config.ValidFilePermissions;
import com.vertica.spark.config.VerticaMetadata;
import com.vertica.spark.config.VerticaWriteMetadata;
import com.vertica.spark.datasource.core.CreateExternalTableOption;
import com.vertica.spark.datasource.core.DataBlock;
import com.vertica.spark.datasource.core.ExistingData$;
import com.vertica.spark.datasource.core.NewData$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipe$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$;
import com.vertica.spark.datasource.core.VerticaPipeInterface;
import com.vertica.spark.datasource.core.VerticaPipeWriteInterface;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcUtils$;
import com.vertica.spark.util.error.CommitError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.CreateExternalTableAlreadyExistsError;
import com.vertica.spark.util.error.CreateExternalTableMergeKey;
import com.vertica.spark.util.error.CreateTableError;
import com.vertica.spark.util.error.DatabaseReadError;
import com.vertica.spark.util.error.DropTableError;
import com.vertica.spark.util.error.DuplicateColumnsError;
import com.vertica.spark.util.error.FaultToleranceTestFail;
import com.vertica.spark.util.error.InferExternalTableSchemaError;
import com.vertica.spark.util.error.MergeColumnListError;
import com.vertica.spark.util.error.NonEmptyDataFrameError;
import com.vertica.spark.util.error.SchemaColumnListError;
import com.vertica.spark.util.error.TempTableExistsError;
import com.vertica.spark.util.error.ViewExistsError;
import com.vertica.spark.util.schema.SchemaToolsInterface;
import com.vertica.spark.util.table.TableUtilsInterface;
import java.io.Serializable;
import java.sql.ResultSet;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r\u001db\u0001B A\u0001-C\u0001\"\u0017\u0001\u0003\u0006\u0004%\tA\u0017\u0005\tA\u0002\u0011\t\u0011)A\u00057\"A\u0011\r\u0001BC\u0002\u0013\u0005!\r\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003d\u0011!Q\u0007A!b\u0001\n\u0003Y\u0007\u0002\u0003:\u0001\u0005\u0003\u0005\u000b\u0011\u00027\t\u0011M\u0004!Q1A\u0005\u0002QD\u0001\" \u0001\u0003\u0002\u0003\u0006I!\u001e\u0005\t}\u0002\u0011)\u0019!C\u0001\u007f\"Q\u0011Q\u0002\u0001\u0003\u0002\u0003\u0006I!!\u0001\t\u0015\u0005=\u0001A!b\u0001\n\u0003\t\t\u0002\u0003\u0006\u0002\u001a\u0001\u0011\t\u0011)A\u0005\u0003'Aq!a\u0007\u0001\t\u0003\ti\u0002C\u0005\u0002.\u0001\u0011\r\u0011\"\u0003\u00020!A\u0011\u0011\t\u0001!\u0002\u0013\t\t\u0004C\u0005\u0002D\u0001\u0011\r\u0011\"\u0003\u0002F!A\u0011Q\n\u0001!\u0002\u0013\t9\u0005C\u0004\u0002P\u0001!\t!!\u0015\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\"9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBA]\u0001\u0011%\u00111\u0018\u0005\b\u0003{\u0003A\u0011AA`\u0011\u001d\t\t\r\u0001C\u0001\u0003\u0007Dq!!7\u0001\t\u0003\tY\u000eC\u0004\u0002h\u0002!\t!a0\t\u000f\u0005%\b\u0001\"\u0001\u0002l\"9!\u0011\u0001\u0001\u0005\u0002\t\r\u0001b\u0002B\b\u0001\u0011\u0005!\u0011\u0003\u0005\b\u0005/\u0001A\u0011\u0001B\r\u0011\u001d\u0011i\u0002\u0001C\u0005\u0005?1aA!\t\u0001\t\n\r\u0002B\u0003B\u0019?\tU\r\u0011\"\u0001\u00034!Q!1H\u0010\u0003\u0012\u0003\u0006IA!\u000e\t\u0015\turD!f\u0001\n\u0003\u0011y\u0004\u0003\u0006\u0003H}\u0011\t\u0012)A\u0005\u0005\u0003Bq!a\u0007 \t\u0003\u0011I\u0005C\u0005\u0003T}\t\t\u0011\"\u0001\u0003V!I!1L\u0010\u0012\u0002\u0013\u0005!Q\f\u0005\n\u0005gz\u0012\u0013!C\u0001\u0005kB\u0011B!\u001f \u0003\u0003%\tEa\u001f\t\u0013\t-u$!A\u0005\u0002\u0005E\u0001\"\u0003BG?\u0005\u0005I\u0011\u0001BH\u0011%\u0011YjHA\u0001\n\u0003\u0012i\nC\u0005\u0003,~\t\t\u0011\"\u0001\u0003.\"I!\u0011W\u0010\u0002\u0002\u0013\u0005#1\u0017\u0005\n\u0005k{\u0012\u0011!C!\u0005oC\u0011B!/ \u0003\u0003%\tEa/\b\u0013\t}\u0006!!A\t\n\t\u0005g!\u0003B\u0011\u0001\u0005\u0005\t\u0012\u0002Bb\u0011\u001d\tY\"\rC\u0001\u0005#D\u0011B!.2\u0003\u0003%)Ea.\t\u0013\tM\u0017'!A\u0005\u0002\nU\u0007\"\u0003Bnc\u0005\u0005I\u0011\u0011Bo\u0011\u001d\u0011y\u000f\u0001C\u0005\u0005cDqA!@\u0001\t\u0003\u0011y\u0010C\u0004\u0004\f\u0001!\ta!\u0004\t\u000f\rE\u0001\u0001\"\u0001\u0004\u0014!91q\u0003\u0001\u0005\u0002\u0005}v!CB\r\u0001\u0006\u0005\t\u0012AB\u000e\r!y\u0004)!A\t\u0002\ru\u0001bBA\u000ey\u0011\u00051q\u0004\u0005\n\u0007Ca\u0014\u0013!C\u0001\u0007G\u0011QEV3si&\u001c\u0017\rR5tiJL'-\u001e;fI\u001aKG.Z:zgR,Wn\u0016:ji\u0016\u0004\u0016\u000e]3\u000b\u0005\u0005\u0013\u0015\u0001B2pe\u0016T!a\u0011#\u0002\u0015\u0011\fG/Y:pkJ\u001cWM\u0003\u0002F\r\u0006)1\u000f]1sW*\u0011q\tS\u0001\bm\u0016\u0014H/[2b\u0015\u0005I\u0015aA2p[\u000e\u00011\u0003\u0002\u0001M%Z\u0003\"!\u0014)\u000e\u00039S\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u0013a!\u00118z%\u00164\u0007CA*U\u001b\u0005\u0001\u0015BA+A\u0005Q1VM\u001d;jG\u0006\u0004\u0016\u000e]3J]R,'OZ1dKB\u00111kV\u0005\u00031\u0002\u0013\u0011DV3si&\u001c\u0017\rU5qK^\u0013\u0018\u000e^3J]R,'OZ1dK\u000611m\u001c8gS\u001e,\u0012a\u0017\t\u00039zk\u0011!\u0018\u0006\u00033\u0012K!aX/\u0003A\u0011K7\u000f\u001e:jEV$X\r\u001a$jY\u0016\u001c\u0018p\u001d;f[^\u0013\u0018\u000e^3D_:4\u0017nZ\u0001\bG>tg-[4!\u000391\u0017\u000e\\3Ti>\u0014X\rT1zKJ,\u0012a\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003M\n\u000b!AZ:\n\u0005!,'a\u0006$jY\u0016\u001cFo\u001c:f\u0019\u0006LXM]%oi\u0016\u0014h-Y2f\u0003=1\u0017\u000e\\3Ti>\u0014X\rT1zKJ\u0004\u0013!\u00036eE\u000ed\u0015-_3s+\u0005a\u0007CA7q\u001b\u0005q'BA8C\u0003\u0011QGMY2\n\u0005Et'A\u0005&eE\u000ed\u0015-_3s\u0013:$XM\u001d4bG\u0016\f!B\u001b3cG2\u000b\u00170\u001a:!\u0003-\u00198\r[3nCR{w\u000e\\:\u0016\u0003U\u0004\"A^>\u000e\u0003]T!\u0001_=\u0002\rM\u001c\u0007.Z7b\u0015\tQH)\u0001\u0003vi&d\u0017B\u0001?x\u0005Q\u00196\r[3nCR{w\u000e\\:J]R,'OZ1dK\u0006a1o\u00195f[\u0006$vn\u001c7tA\u0005QA/\u00192mKV#\u0018\u000e\\:\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d\u00110A\u0003uC\ndW-\u0003\u0003\u0002\f\u0005\u0015!a\u0005+bE2,W\u000b^5mg&sG/\u001a:gC\u000e,\u0017a\u0003;bE2,W\u000b^5mg\u0002\n\u0001\u0002Z1uCNK'0Z\u000b\u0003\u0003'\u00012!TA\u000b\u0013\r\t9B\u0014\u0002\u0004\u0013:$\u0018!\u00033bi\u0006\u001c\u0016N_3!\u0003\u0019a\u0014N\\5u}Qq\u0011qDA\u0011\u0003G\t)#a\n\u0002*\u0005-\u0002CA*\u0001\u0011\u0015IV\u00021\u0001\\\u0011\u0015\tW\u00021\u0001d\u0011\u0015QW\u00021\u0001m\u0011\u0015\u0019X\u00021\u0001v\u0011\u0019qX\u00021\u0001\u0002\u0002!I\u0011qB\u0007\u0011\u0002\u0003\u0007\u00111C\u0001\u0007Y><w-\u001a:\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003{i!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0004\u0003wA\u0015\u0001\u0003;za\u0016\u001c\u0018MZ3\n\t\u0005}\u0012Q\u0007\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005iA/Z7q)\u0006\u0014G.\u001a(b[\u0016,\"!a\u0012\u0011\u0007q\u000bI%C\u0002\u0002Lu\u0013\u0011\u0002V1cY\u0016t\u0015-\\3\u0002\u001dQ,W\u000e\u001d+bE2,g*Y7fA\u0005Yq-\u001a;NKR\fG-\u0019;b+\t\t\u0019\u0006\u0005\u0004\u0002V\u0005e\u0014q\u0010\b\u0005\u0003/\n\u0019H\u0004\u0003\u0002Z\u0005=d\u0002BA.\u0003[rA!!\u0018\u0002l9!\u0011qLA5\u001d\u0011\t\t'a\u001a\u000e\u0005\u0005\r$bAA3\u0015\u00061AH]8pizJ\u0011!S\u0005\u0003\u000f\"K!!\u0012$\n\u0005i$\u0015bAA9s\u0006)QM\u001d:pe&!\u0011QOA<\u00035)%O]8s\u0011\u0006tG\r\\5oO*\u0019\u0011\u0011O=\n\t\u0005m\u0014Q\u0010\u0002\u0010\u0007>tg.Z2u_J\u0014Vm];mi*!\u0011QOA<!\ra\u0016\u0011Q\u0005\u0004\u0003\u0007k&a\u0004,feRL7-Y'fi\u0006$\u0017\r^1\u0002!\u001d,G\u000fR1uC\ncwnY6TSj,WCAAE!\u0019\t)&!\u001f\u0002\fB\u0019Q*!$\n\u0007\u0005=eJ\u0001\u0003M_:<\u0017\u0001G2iK\u000e\\7k\u00195f[\u00064uN\u001d#va2L7-\u0019;fgR!\u0011QSAO!\u0019\t)&!\u001f\u0002\u0018B\u0019Q*!'\n\u0007\u0005meJ\u0001\u0003V]&$\bB\u0002=\u0015\u0001\u0004\ty\n\u0005\u0003\u0002\"\u0006UVBAAR\u0015\u0011\t)+a*\u0002\u000bQL\b/Z:\u000b\t\u0005%\u00161V\u0001\u0004gFd'bA#\u0002.*!\u0011qVAY\u0003\u0019\t\u0007/Y2iK*\u0011\u00111W\u0001\u0004_J<\u0017\u0002BA\\\u0003G\u0013!b\u0015;sk\u000e$H+\u001f9f\u0003Q\u0019X\r^*qCJ\\7)\u00197f]\u0012\f'oQ8oMR\u0011\u0011qS\u0001\u0010I>\u0004&/Z,sSR,7\u000b^3qgR\u0011\u0011QS\u0001\u0014gR\f'\u000f\u001e)beRLG/[8o/JLG/\u001a\u000b\u0005\u0003+\u000b)\rC\u0004\u0002H^\u0001\r!!3\u0002\u0011Ut\u0017.];f\u0013\u0012\u0004B!a3\u0002T:!\u0011QZAh!\r\t\tGT\u0005\u0004\u0003#t\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002V\u0006]'AB*ue&twMC\u0002\u0002R:\u000b\u0011b\u001e:ji\u0016$\u0015\r^1\u0015\t\u0005U\u0015Q\u001c\u0005\b\u0003?D\u0002\u0019AAq\u0003\u0011!\u0017\r^1\u0011\u0007M\u000b\u0019/C\u0002\u0002f\u0002\u0013\u0011\u0002R1uC\ncwnY6\u0002#\u0015tG\rU1si&$\u0018n\u001c8Xe&$X-\u0001\nck&dGmQ8qsN#\u0018\r^3nK:$H\u0003DAe\u0003[\f\t0!>\u0002z\u0006u\bbBAx5\u0001\u0007\u0011\u0011Z\u0001\fi\u0006\u0014x-\u001a;UC\ndW\rC\u0004\u0002tj\u0001\r!!3\u0002\u0015\r|G.^7o\u0019&\u001cH\u000fC\u0004\u0002xj\u0001\r!!3\u0002\u0007U\u0014H\u000eC\u0004\u0002|j\u0001\r!!3\u0002!I,'.Z2ugR\u000b'\r\\3OC6,\u0007bBA\u00005\u0001\u0007\u0011\u0011Z\u0001\u000bM&dWMR8s[\u0006$\u0018a\u00052vS2$W*\u001a:hKN#\u0018\r^3nK:$H\u0003CAe\u0005\u000b\u0011IAa\u0003\t\u000f\t\u001d1\u00041\u0001\u0002H\u0005yA/\u0019:hKR$\u0016M\u00197f\u001d\u0006lW\rC\u0004\u0002tn\u0001\r!!3\t\u000f\t51\u00041\u0001\u0002J\u0006IA/Z7q)\u0006\u0014G.Z\u0001\ra\u0016\u0014hm\u001c:n\u001b\u0016\u0014x-\u001a\u000b\u0005\u0003+\u0013\u0019\u0002C\u0004\u0003\u0016q\u0001\r!!3\u0002\u001d5,'oZ3Ti\u0006$X-\\3oi\u0006A\u0012N\u001c4fe\u0016CH/\u001a:oC2$\u0016M\u00197f'\u000eDW-\\1\u0015\u0005\tm\u0001CBA+\u0003s\nI-A\u0007hKR\u001cu\u000e\\;n]2K7\u000f^\u000b\u0003\u00057\u0011\u0001DR1vYR$v\u000e\\3sC:\u001cW\rV3tiJ+7/\u001e7u'\u0019yBJ!\n\u0003,A\u0019QJa\n\n\u0007\t%bJA\u0004Qe>$Wo\u0019;\u0011\u00075\u0013i#C\u0002\u000309\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fqa];dG\u0016\u001c8/\u0006\u0002\u00036A\u0019QJa\u000e\n\u0007\tebJA\u0004C_>dW-\u00198\u0002\u0011M,8mY3tg\u0002\n\u0011CZ1jY\u0016$'k\\<t!\u0016\u00148-\u001a8u+\t\u0011\t\u0005E\u0002N\u0005\u0007J1A!\u0012O\u0005\u0019!u.\u001e2mK\u0006\u0011b-Y5mK\u0012\u0014vn^:QKJ\u001cWM\u001c;!)\u0019\u0011YEa\u0014\u0003RA\u0019!QJ\u0010\u000e\u0003\u0001AqA!\r%\u0001\u0004\u0011)\u0004C\u0004\u0003>\u0011\u0002\rA!\u0011\u0002\t\r|\u0007/\u001f\u000b\u0007\u0005\u0017\u00129F!\u0017\t\u0013\tER\u0005%AA\u0002\tU\u0002\"\u0003B\u001fKA\u0005\t\u0019\u0001B!\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u0018+\t\tU\"\u0011M\u0016\u0003\u0005G\u0002BA!\u001a\u0003p5\u0011!q\r\u0006\u0005\u0005S\u0012Y'A\u0005v]\u000eDWmY6fI*\u0019!Q\u000e(\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003r\t\u001d$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B<U\u0011\u0011\tE!\u0019\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011i\b\u0005\u0003\u0003\u0000\t%UB\u0001BA\u0015\u0011\u0011\u0019I!\"\u0002\t1\fgn\u001a\u0006\u0003\u0005\u000f\u000bAA[1wC&!\u0011Q\u001bBA\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!%\u0003\u0018B\u0019QJa%\n\u0007\tUeJA\u0002B]fD\u0011B!'+\u0003\u0003\u0005\r!a\u0005\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011y\n\u0005\u0004\u0003\"\n\u001d&\u0011S\u0007\u0003\u0005GS1A!*O\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005S\u0013\u0019K\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u001b\u0005_C\u0011B!'-\u0003\u0003\u0005\rA!%\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0005\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A! \u0002\r\u0015\fX/\u00197t)\u0011\u0011)D!0\t\u0013\teu&!AA\u0002\tE\u0015\u0001\u0007$bk2$Hk\u001c7fe\u0006t7-\u001a+fgR\u0014Vm];miB\u0019!QJ\u0019\u0014\u000bE\u0012)Ma\u000b\u0011\u0015\t\u001d'Q\u001aB\u001b\u0005\u0003\u0012Y%\u0004\u0002\u0003J*\u0019!1\u001a(\u0002\u000fI,h\u000e^5nK&!!q\u001aBe\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0005\u0003\fQ!\u00199qYf$bAa\u0013\u0003X\ne\u0007b\u0002B\u0019i\u0001\u0007!Q\u0007\u0005\b\u0005{!\u0004\u0019\u0001B!\u0003\u001d)h.\u00199qYf$BAa8\u0003lB)QJ!9\u0003f&\u0019!1\u001d(\u0003\r=\u0003H/[8o!\u001di%q\u001dB\u001b\u0005\u0003J1A!;O\u0005\u0019!V\u000f\u001d7fe!I!Q^\u001b\u0002\u0002\u0003\u0007!1J\u0001\u0004q\u0012\u0002\u0014A\u0005;fgR4\u0015-\u001e7u)>dWM]1oG\u0016$bAa=\u0003v\ne\bCBA+\u0003s\u0012Y\u0005C\u0004\u0003xZ\u0002\r!a\u0005\u0002\u0015I|wo]\"pa&,G\rC\u0004\u0003|Z\u0002\r!!3\u0002\u0019I,'.Z2ugR\u000b'\r\\3\u0002\u0017A,'OZ8s[\u000e{\u0007/\u001f\u000b\u0007\u0007\u0003\u0019\u0019aa\u0002\u0011\r\u0005U\u0013\u0011PA\n\u0011\u001d\u0019)a\u000ea\u0001\u0003\u0013\fQbY8qsN#\u0018\r^3nK:$\bbBB\u0005o\u0001\u0007\u0011qI\u0001\ni\u0006\u0014G.\u001a8b[\u0016\fQcY8n[&$H)\u0019;b\u0013:$xNV3si&\u001c\u0017\r\u0006\u0003\u0002\u0016\u000e=\u0001bBA|q\u0001\u0007\u0011\u0011Z\u0001\u001aG>lW.\u001b;ECR\f\u0017i]#yi\u0016\u0014h.\u00197UC\ndW\r\u0006\u0003\u0002\u0016\u000eU\u0001bBA|s\u0001\u0007\u0011\u0011Z\u0001\u0007G>lW.\u001b;\u0002KY+'\u000f^5dC\u0012K7\u000f\u001e:jEV$X\r\u001a$jY\u0016\u001c\u0018p\u001d;f[^\u0013\u0018\u000e^3QSB,\u0007CA*='\taD\n\u0006\u0002\u0004\u001c\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\"a!\n+\t\u0005M!\u0011\r")
public class VerticaDistributedFilesystemWritePipe
implements VerticaPipeInterface,
VerticaPipeWriteInterface {
    private volatile VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$ FaultToleranceTestResult$module;
    private final DistributedFilesystemWriteConfig config;
    private final FileStoreLayerInterface fileStoreLayer;
    private final JdbcLayerInterface jdbcLayer;
    private final SchemaToolsInterface schemaTools;
    private final TableUtilsInterface tableUtils;
    private final int dataSize;
    private final Logger logger;
    private final TableName tempTableName;

    public static int $lessinit$greater$default$6() {
        return VerticaDistributedFilesystemWritePipe$.MODULE$.$lessinit$greater$default$6();
    }

    private VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$ FaultToleranceTestResult() {
        if (this.FaultToleranceTestResult$module == null) {
            this.FaultToleranceTestResult$lzycompute$1();
        }
        return this.FaultToleranceTestResult$module;
    }

    public DistributedFilesystemWriteConfig config() {
        return this.config;
    }

    public FileStoreLayerInterface fileStoreLayer() {
        return this.fileStoreLayer;
    }

    public JdbcLayerInterface jdbcLayer() {
        return this.jdbcLayer;
    }

    public SchemaToolsInterface schemaTools() {
        return this.schemaTools;
    }

    public TableUtilsInterface tableUtils() {
        return this.tableUtils;
    }

    public int dataSize() {
        return this.dataSize;
    }

    private Logger logger() {
        return this.logger;
    }

    private TableName tempTableName() {
        return this.tempTableName;
    }

    @Override
    public Either<ConnectorError, VerticaMetadata> getMetadata() {
        return package$.MODULE$.Right().apply((Object)new VerticaWriteMetadata());
    }

    @Override
    public Either<ConnectorError, Object> getDataBlockSize() {
        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)this.dataSize()));
    }

    public Either<ConnectorError, BoxedUnit> checkSchemaForDuplicates(StructType schema) {
        String[] names = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)f -> f.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])names)).distinct()).length != names.length ? package$.MODULE$.Left().apply((Object)new DuplicateColumnsError()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private void setSparkCalendarConf() {
        Option option = SparkSession$.MODULE$.getActiveSession();
        if (option instanceof Some) {
            Some some = (Some)option;
            SparkSession session = (SparkSession)some.value();
            session.sparkContext().setLocalProperty(SQLConf$.MODULE$.LEGACY_PARQUET_REBASE_MODE_IN_WRITE().key(), "CORRECTED");
            session.sparkContext().setLocalProperty("spark.sql.legacy.parquet.int96RebaseModeInWrite", "CORRECTED");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("No spark session found to set config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError((Object)option);
        }
    }

    @Override
    public Either<ConnectorError, BoxedUnit> doPreWriteSteps() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.config().mergeKey().isDefined() && this.config().isOverwrite()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Save mode is specified as Overwrite during a merge.");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Writing data to Parquet file.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.checkSchemaForDuplicates(this.config().schema()).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.setSparkCalendarConf();
            BoxedUnit x$2 = BoxedUnit.UNIT;
            return new Tuple2(x$1, (Object)x$2);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Either either = (this.config().isOverwrite() && this.config().mergeKey().isEmpty() ? this.tableUtils().dropTable(this.config().tablename()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> (this.config().createExternalTable().isDefined() && this.config().mergeKey().isDefined() ? package$.MODULE$.Left().apply((Object)new CreateExternalTableMergeKey()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.tableUtils().tableExists(this.config().tablename()).flatMap((Function1 & Serializable & scala.Serializable)tableExistsPre -> VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$5(this, BoxesRunTime.unboxToBoolean((Object)tableExistsPre)))));
            return either;
        });
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Either<ConnectorError, BoxedUnit> startPartitionWrite(String uniqueId) {
        address = this.config().fileStoreConfig().address();
        v0 = new StringOps(Predef$.MODULE$.augmentString(address)).takeRight(1);
        var4_3 = "/";
        if (!(v0 == null ? var4_3 != null : v0.equals(var4_3) == false)) ** GOTO lbl-1000
        v1 = new StringOps(Predef$.MODULE$.augmentString(address)).takeRight(1);
        var5_4 = "\\";
        if (!(v1 != null ? v1.equals(var5_4) == false : var5_4 != null)) lbl-1000:
        // 2 sources

        {
            v2 = "";
        } else {
            v2 = "/";
        }
        delimiter = v2;
        filename = new StringBuilder(8).append(address).append(delimiter).append(uniqueId).append(".parquet").toString();
        return this.fileStoreLayer().openWriteParquetFile(filename);
    }

    @Override
    public Either<ConnectorError, BoxedUnit> writeData(DataBlock data) {
        Either<ConnectorError, BoxedUnit> either;
        Option<CreateExternalTableOption> option = this.config().createExternalTable();
        if (option instanceof Some) {
            Either<ConnectorError, BoxedUnit> either2;
            Some some = (Some)option;
            CreateExternalTableOption value = (CreateExternalTableOption)some.value();
            CreateExternalTableOption createExternalTableOption = value;
            if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                either2 = package$.MODULE$.Left().apply((Object)new NonEmptyDataFrameError());
            } else if (NewData$.MODULE$.equals(createExternalTableOption)) {
                either2 = this.fileStoreLayer().writeDataToParquetFile(data);
            } else {
                throw new MatchError((Object)createExternalTableOption);
            }
            either = either2;
        } else if (None$.MODULE$.equals(option)) {
            either = this.fileStoreLayer().writeDataToParquetFile(data);
        } else {
            throw new MatchError(option);
        }
        return either;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> endPartitionWrite() {
        Either<ConnectorError, BoxedUnit> either;
        Option<CreateExternalTableOption> option = this.config().createExternalTable();
        if (option instanceof Some) {
            Either<ConnectorError, BoxedUnit> either2;
            Some some = (Some)option;
            CreateExternalTableOption value = (CreateExternalTableOption)some.value();
            CreateExternalTableOption createExternalTableOption = value;
            if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                either2 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else if (NewData$.MODULE$.equals(createExternalTableOption)) {
                either2 = this.fileStoreLayer().closeWriteParquetFile();
            } else {
                throw new MatchError((Object)createExternalTableOption);
            }
            either = either2;
        } else if (None$.MODULE$.equals(option)) {
            either = this.fileStoreLayer().closeWriteParquetFile();
        } else {
            throw new MatchError(option);
        }
        return either;
    }

    public String buildCopyStatement(String targetTable, String columnList, String url, String rejectsTableName, String fileFormat) {
        return this.config().mergeKey().isDefined() ? new StringBuilder(60).append("COPY ").append(targetTable).append(" FROM '").append(url).append("' ON ANY NODE ").append(fileFormat).append(" REJECTED DATA AS TABLE ").append(rejectsTableName).append(" NO COMMIT").toString() : new StringBuilder(61).append("COPY ").append(targetTable).append(" ").append(columnList).append(" FROM '").append(url).append("' ON ANY NODE ").append(fileFormat).append(" REJECTED DATA AS TABLE ").append(rejectsTableName).append(" NO COMMIT").toString();
    }

    public String buildMergeStatement(TableName targetTableName, String columnList, String tempTable) {
        Object object;
        String string;
        String string2;
        String targetTable = targetTableName.getFullTableName();
        Either<ConnectorError, String> either = this.schemaTools().getMergeUpdateValues(this.jdbcLayer(), targetTableName, this.tempTableName(), this.config().copyColumnList());
        if (either instanceof Right) {
            String values;
            Right right = (Right)either;
            string2 = values = (String)right.value();
        } else if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            string2 = package$.MODULE$.Left().apply((Object)new MergeColumnListError(err));
        } else {
            throw new MatchError(either);
        }
        String updateColValues = string2;
        Either<ConnectorError, String> either2 = this.schemaTools().getMergeInsertValues(this.jdbcLayer(), this.tempTableName(), this.config().copyColumnList());
        if (either2 instanceof Right) {
            String values;
            Right right = (Right)either2;
            string = values = (String)right.value();
        } else if (either2 instanceof Left) {
            Left left = (Left)either2;
            ConnectorError err = (ConnectorError)left.value();
            string = package$.MODULE$.Left().apply((Object)new MergeColumnListError(err));
        } else {
            throw new MatchError(either2);
        }
        String insertColValues = string;
        Option<ValidColumnList> option = this.config().mergeKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            ValidColumnList key = (ValidColumnList)some.value();
            List trimmedCols = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])key.toString().split(","))).toList().map((Function1 & Serializable & scala.Serializable)col -> col.trim(), List$.MODULE$.canBuildFrom());
            object = ((TraversableOnce)trimmedCols.map((Function1 & Serializable & scala.Serializable)trimmedCol -> new StringBuilder(13).append("target.").append((String)trimmedCol).append("=temp.").append((String)trimmedCol).toString(), List$.MODULE$.canBuildFrom())).mkString(" AND ");
        } else if (None$.MODULE$.equals(option)) {
            object = Nil$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        Nil$ mergeList = object;
        return new StringBuilder(112).append("MERGE INTO ").append(targetTable).append(" as target using ").append(tempTable).append(" as temp ON (").append(mergeList).append(") WHEN MATCHED THEN UPDATE SET ").append((Object)updateColValues).append(" WHEN NOT MATCHED THEN INSERT ").append(columnList).append(" VALUES (").append((Object)insertColValues).append(")").toString();
    }

    public Either<ConnectorError, BoxedUnit> performMerge(String mergeStatement) {
        BoxedUnit boxedUnit;
        Either ret = this.jdbcLayer().query(new StringBuilder(8).append("EXPLAIN ").append(mergeStatement).toString(), this.jdbcLayer().query$default$2()).map((Function1 & Serializable & scala.Serializable)rs -> {
            rs.close();
            BoxedUnit x$6 = BoxedUnit.UNIT;
            return new Tuple2(rs, (Object)x$6);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Either either = this.jdbcLayer().execute(mergeStatement, this.jdbcLayer().execute$default$2()).map((Function1 & Serializable & scala.Serializable)_ -> {
                VerticaDistributedFilesystemWritePipe.$anonfun$performMerge$3(_);
                return BoxedUnit.UNIT;
            });
            return either;
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Executing merge");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ret.left().map((Function1 & Serializable & scala.Serializable)err -> new CommitError((ConnectorError)err).context("performMerge: JDBC error when trying to merge"));
    }

    public Either<ConnectorError, String> inferExternalTableSchema() {
        Left left;
        BoxedUnit boxedUnit;
        String string;
        String tableName = this.config().tablename().getFullTableName().replaceAll("\"", "");
        Either<ConnectorError, Seq<String>> either = this.fileStoreLayer().getGlobStatus(EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(10).append(new StringOps(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress())).stripSuffix("/")).append("/*.parquet").toString(), EscapeUtils$.MODULE$.sqlEscape$default$2()));
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq list = (Seq)right.value();
            String url = list.nonEmpty() ? EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(10).append(new StringOps(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress())).stripSuffix("/")).append("/*.parquet").toString(), EscapeUtils$.MODULE$.sqlEscape$default$2()) : EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(13).append(new StringOps(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress())).stripSuffix("/")).append("/**/*.parquet").toString(), EscapeUtils$.MODULE$.sqlEscape$default$2());
            string = new StringBuilder(38).append("SELECT INFER_EXTERNAL_TABLE_DDL('").append(url).append("','").append(tableName).append("')").toString();
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            string = err.getFullContext();
        } else {
            throw new MatchError(either);
        }
        String inferStatement = string;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(24).append("The infer statement is: ").append(inferStatement).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Either<ConnectorError, ResultSet> either2 = this.jdbcLayer().query(inferStatement, this.jdbcLayer().query$default$2());
        if (either2 instanceof Left) {
            Left left3 = (Left)either2;
            ConnectorError err = (ConnectorError)left3.value();
            left = package$.MODULE$.Left().apply((Object)new InferExternalTableSchemaError(err));
        } else if (either2 instanceof Right) {
            Right right;
            block22: {
                Right right2 = (Right)either2;
                try (ResultSet resultSet = (ResultSet)right2.value();){
                    try {
                        BoxedUnit boxedUnit2;
                        BoxedUnit boxedUnit3;
                        boolean bl = resultSet.next();
                        String createExternalTableStatement = resultSet.getString("INFER_EXTERNAL_TABLE_DDL");
                        if (inferStatement.contains(EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(13).append(new StringOps(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress())).stripSuffix("/")).append("/**/*.parquet").toString(), EscapeUtils$.MODULE$.sqlEscape$default$2()))) {
                            BoxedUnit boxedUnit4;
                            if (this.logger().underlying().isInfoEnabled()) {
                                this.logger().underlying().info("Inferring partial schema from dataframe");
                                boxedUnit4 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit4 = BoxedUnit.UNIT;
                            }
                            right = this.schemaTools().inferExternalTableSchema(createExternalTableStatement, this.config().schema());
                            break block22;
                        }
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Inferring schema from parquet data");
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info(new StringBuilder(40).append("The create external table statement is: ").append(createExternalTableStatement).toString());
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        right = package$.MODULE$.Right().apply((Object)createExternalTableStatement);
                    }
                    catch (Throwable e) {
                        right = package$.MODULE$.Left().apply((Object)new DatabaseReadError(e).context("Could not infer external table schema"));
                    }
                }
            }
            left = right;
        } else {
            throw new MatchError(either2);
        }
        return left;
    }

    private Either<ConnectorError, String> getColumnList() {
        Either either;
        Option<ValidColumnList> option = this.config().copyColumnList();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            ValidColumnList list = (ValidColumnList)some.value();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder(66).append("Using custom COPY column list. ").append("Target table: ").append(this.config().tablename().getFullTableName()).append(", ").append("copy_column_list: ").append(list).append(".").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            either = package$.MODULE$.Right().apply((Object)new StringBuilder(2).append("(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])list.toString().split(","))).map((Function1 & Serializable & scala.Serializable)col -> col.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",")).append(")").toString());
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Building default copy column list");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            either = this.schemaTools().getCopyColumnList(this.jdbcLayer(), this.config().tablename(), this.config().schema()).left().map((Function1 & Serializable & scala.Serializable)err -> new SchemaColumnListError((ConnectorError)err).context("getColumnList: Error building default copy column list"));
        } else {
            throw new MatchError(option);
        }
        return either;
    }

    private Either<ConnectorError, FaultToleranceTestResult> testFaultTolerance(int rowsCopied, String rejectsTable) {
        BoxedUnit boxedUnit;
        String rejectsQuery = new StringBuilder(30).append("SELECT COUNT(*) as count FROM ").append(rejectsTable).toString();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(48).append("Checking number of rejected rows via statement: ").append(rejectsQuery).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.jdbcLayer().query(rejectsQuery, this.jdbcLayer().query$default$2()).map((Function1 & Serializable & scala.Serializable)rs -> {
            Try res = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                int n;
                if (rs.next()) {
                    n = rs.getInt("count");
                } else {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Could not retrieve rejected row count.");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    n = 0;
                }
                return n;
            });
            rs.close();
            BoxedUnit x$8 = BoxedUnit.UNIT;
            return new Tuple3(rs, (Object)res, (Object)x$8);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$14 -> {
            Tuple3 tuple3 = x$14;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Try res = (Try)tuple3._2();
            Either either = JdbcUtils$.MODULE$.tryJdbcToResult(this.jdbcLayer(), res).map((Function1 & Serializable & scala.Serializable)rejectedCount -> VerticaDistributedFilesystemWritePipe.$anonfun$testFaultTolerance$4(this, rowsCopied, BoxesRunTime.unboxToInt((Object)rejectedCount))).flatMap((Function1 & Serializable & scala.Serializable)x$13 -> {
                Either<ConnectorError, BoxedUnit> either;
                boolean passedFaultToleranceTest;
                double failedRowsPercent;
                Tuple6 tuple6 = x$13;
                if (tuple6 != null) {
                    int rejectedCount = BoxesRunTime.unboxToInt((Object)tuple6._1());
                    failedRowsPercent = BoxesRunTime.unboxToDouble((Object)tuple6._2());
                    passedFaultToleranceTest = BoxesRunTime.unboxToBoolean((Object)tuple6._3());
                    if (rejectedCount == 0) {
                        BoxedUnit boxedUnit;
                        String dropRejectsTableStatement = new StringBuilder(29).append("DROP TABLE IF EXISTS ").append(rejectsTable).append(" CASCADE").toString();
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info(new StringBuilder(36).append("Dropping Vertica rejects table now: ").append(dropRejectsTableStatement).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        either = this.jdbcLayer().execute(dropRejectsTableStatement, this.jdbcLayer().execute$default$2());
                    } else {
                        either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    }
                } else {
                    throw new MatchError((Object)tuple6);
                }
                Either either2 = either.map((Function1 & Serializable & scala.Serializable)x$11 -> {
                    FaultToleranceTestResult testResult = new FaultToleranceTestResult(this, passedFaultToleranceTest, failedRowsPercent);
                    return new Tuple2(x$11, (Object)testResult);
                }).map((Function1 & Serializable & scala.Serializable)x$12 -> {
                    FaultToleranceTestResult testResult;
                    Tuple2 tuple2 = x$12;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    FaultToleranceTestResult faultToleranceTestResult = testResult = (FaultToleranceTestResult)tuple2._2();
                    return faultToleranceTestResult;
                });
                return either2;
            });
            return either;
        });
    }

    public Either<ConnectorError, Object> performCopy(String copyStatement, TableName tablename) {
        BoxedUnit boxedUnit;
        String emptyCopy = new StringBuilder(14).append("COPY ").append(tablename.getFullTableName()).append(" FROM '';").toString();
        this.jdbcLayer().executeUpdate(emptyCopy, this.jdbcLayer().executeUpdate$default$2());
        Either ret = this.jdbcLayer().query(new StringBuilder(8).append("EXPLAIN ").append(copyStatement).toString(), this.jdbcLayer().query$default$2()).map((Function1 & Serializable & scala.Serializable)rs -> {
            rs.close();
            BoxedUnit x$15 = BoxedUnit.UNIT;
            return new Tuple2(rs, (Object)x$15);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> {
            Tuple2 tuple2 = x$16;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Either either = this.jdbcLayer().executeUpdate(copyStatement, this.jdbcLayer().executeUpdate$default$2()).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)rowsCopied -> rowsCopied);
            return either;
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Performing copy from file store to Vertica");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ret.left().map((Function1 & Serializable & scala.Serializable)err -> new CommitError((ConnectorError)err).context("performCopy: JDBC error when trying to copy"));
    }

    /*
     * WARNING - void declaration
     */
    public Either<ConnectorError, BoxedUnit> commitDataIntoVertica(String url) {
        void var3_3;
        BoxedUnit boxedUnit;
        int tableNameMaxLength = 30;
        Either ret = this.jdbcLayer().configureSession(this.fileStoreLayer()).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.getColumnList().left().map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.context("commit: Failed to get column list")).map((Function1 & Serializable & scala.Serializable)columnList -> {
            String tableName = this.config().tablename().name();
            String sessionId = this.config().sessionId();
            return new Tuple3(columnList, (Object)tableName, (Object)sessionId);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$26 -> {
            Tuple3 tuple3 = x$26;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String columnList = (String)tuple3._1();
            String tableName = (String)tuple3._2();
            String sessionId = (String)tuple3._3();
            Either either = (this.config().mergeKey().isDefined() ? this.tableUtils().createTempTable(this.tempTableName(), this.config().schema(), this.config().strlen()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.tableUtils().tempTableExists(this.tempTableName()).flatMap((Function1 & Serializable & scala.Serializable)tempTableExists -> VerticaDistributedFilesystemWritePipe.$anonfun$commitDataIntoVertica$6(this, tableName, tableNameMaxLength, sessionId, columnList, url, BoxesRunTime.unboxToBoolean((Object)tempTableExists))));
            return either;
        }));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Committing data into Vertica.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.fileStoreLayer().removeDir(this.config().fileStoreConfig().address());
        return var3_3;
    }

    public Either<ConnectorError, BoxedUnit> commitDataAsExternalTable(String url) {
        Right right;
        Either ret;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Committing data as external table.");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.config().copyColumnList().isDefined()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Custom copy column list was specified, but will be ignored when creating new external table.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Either either = ret = this.jdbcLayer().configureSession(this.fileStoreLayer()).map((Function1 & Serializable & scala.Serializable)x$27 -> {
            boolean bl;
            Option<CreateExternalTableOption> option = this.config().createExternalTable();
            if (option instanceof Some) {
                boolean bl2;
                Some some = (Some)option;
                CreateExternalTableOption value = (CreateExternalTableOption)some.value();
                CreateExternalTableOption createExternalTableOption = value;
                if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                    bl2 = true;
                } else if (NewData$.MODULE$.equals(createExternalTableOption)) {
                    bl2 = false;
                } else {
                    throw new MatchError((Object)createExternalTableOption);
                }
                bl = bl2;
            } else if (None$.MODULE$.equals(option)) {
                bl = false;
            } else {
                throw new MatchError(option);
            }
            boolean existingData = bl;
            return new Tuple2(x$27, (Object)BoxesRunTime.boxToBoolean((boolean)existingData));
        }).flatMap((Function1 & Serializable & scala.Serializable)x$28 -> {
            Tuple2 tuple2 = x$28;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            boolean existingData = tuple2._2$mcZ$sp();
            Either either = (existingData ? this.inferExternalTableSchema() : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)createExternalTableStmt -> this.tableUtils().createExternalTable(this.config().tablename(), (Option<String>)(existingData ? new Some((Object)createExternalTableStmt.toString()) : this.config().targetTableSql()), this.config().schema(), this.config().strlen(), url).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.tableUtils().validateExternalTable(this.config().tablename()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.tableUtils().updateJobStatusTable(this.config().tablename(), this.config().jdbcConfig().auth().user(), 0.0, this.config().sessionId(), true).map((Function1 & Serializable & scala.Serializable)_ -> {
                VerticaDistributedFilesystemWritePipe.$anonfun$commitDataAsExternalTable$6(_);
                return BoxedUnit.UNIT;
            }))));
            return either;
        });
        if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            this.tableUtils().dropTable(this.config().tablename());
            right = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError((Object)either);
        }
        return right;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> commit() {
        Either either;
        Either<ConnectorError, BoxedUnit> ret;
        String string;
        String globPattern = "*.parquet";
        Option<CreateExternalTableOption> option = this.config().createExternalTable();
        if (option instanceof Some) {
            String string2;
            Some some = (Some)option;
            CreateExternalTableOption value = (CreateExternalTableOption)some.value();
            CreateExternalTableOption createExternalTableOption = value;
            if (NewData$.MODULE$.equals(createExternalTableOption)) {
                string2 = EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().address())).stripSuffix("/")).append("/").append(globPattern).toString(), EscapeUtils$.MODULE$.sqlEscape$default$2());
            } else if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                string2 = EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress())).stripSuffix("/")).append("/").append(globPattern).toString(), EscapeUtils$.MODULE$.sqlEscape$default$2());
            } else {
                throw new MatchError((Object)createExternalTableOption);
            }
            string = string2;
        } else if (None$.MODULE$.equals(option)) {
            string = EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().address())).stripSuffix("/")).append("/").append(globPattern).toString(), EscapeUtils$.MODULE$.sqlEscape$default$2());
        } else {
            throw new MatchError(option);
        }
        String url = string;
        Either<ConnectorError, BoxedUnit> either2 = ret = this.config().createExternalTable().isDefined() ? this.commitDataAsExternalTable(url) : this.commitDataIntoVertica(url);
        if (either2 instanceof Right) {
            either = this.jdbcLayer().commit().left().map((Function1 & Serializable & scala.Serializable)err -> new CommitError((ConnectorError)err).context("JDBC Error when trying to commit"));
        } else if (either2 instanceof Left) {
            Left left;
            Left left2 = (Left)either2;
            ConnectorError retError = (ConnectorError)left2.value();
            Either<ConnectorError, BoxedUnit> either3 = this.jdbcLayer().rollback();
            if (either3 instanceof Right) {
                left = package$.MODULE$.Left().apply((Object)retError);
            } else if (either3 instanceof Left) {
                Left left3 = (Left)either3;
                ConnectorError err2 = (ConnectorError)left3.value();
                left = package$.MODULE$.Left().apply((Object)retError.context(new StringBuilder(36).append("JDBC Error when trying to rollback: ").append(err2.getFullContext()).toString()));
            } else {
                throw new MatchError(either3);
            }
            either = left;
        } else {
            throw new MatchError(either2);
        }
        Either result = either;
        this.jdbcLayer().close();
        return result;
    }

    private final void FaultToleranceTestResult$lzycompute$1() {
        VerticaDistributedFilesystemWritePipe verticaDistributedFilesystemWritePipe = this;
        synchronized (verticaDistributedFilesystemWritePipe) {
            if (this.FaultToleranceTestResult$module == null) {
                this.FaultToleranceTestResult$module = new VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$doPreWriteSteps$17(BoxedUnit _) {
    }

    public static final /* synthetic */ Either $anonfun$doPreWriteSteps$13(VerticaDistributedFilesystemWritePipe $this, boolean tableExistsPost) {
        return (tableExistsPost || $this.config().createExternalTable().isDefined() ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)new CreateTableError((Option<ConnectorError>)None$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            boolean bl;
            ValidFilePermissions perm = $this.config().filePermissions();
            Option<CreateExternalTableOption> option = $this.config().createExternalTable();
            if (option instanceof Some) {
                boolean bl2;
                Some some = (Some)option;
                CreateExternalTableOption value = (CreateExternalTableOption)some.value();
                CreateExternalTableOption createExternalTableOption = value;
                if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                    bl2 = true;
                } else if (NewData$.MODULE$.equals(createExternalTableOption)) {
                    bl2 = false;
                } else {
                    throw new MatchError((Object)createExternalTableOption);
                }
                bl = bl2;
            } else if (None$.MODULE$.equals(option)) {
                bl = false;
            } else {
                throw new MatchError(option);
            }
            boolean existingData = bl;
            return new Tuple3(x$3, (Object)perm, (Object)BoxesRunTime.boxToBoolean((boolean)existingData));
        }).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple3 tuple3 = x$4;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            ValidFilePermissions perm = (ValidFilePermissions)tuple3._2();
            boolean existingData = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            Either either = (existingData ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : $this.fileStoreLayer().createDir($this.config().fileStoreConfig().address(), perm.toString())).flatMap((Function1 & Serializable & scala.Serializable)_2 -> $this.tableUtils().createAndInitJobStatusTable($this.config().tablename(), $this.config().jdbcConfig().auth().user(), $this.config().sessionId(), $this.config().isOverwrite() ? "OVERWRITE" : "APPEND").map((Function1 & Serializable & scala.Serializable)_ -> {
                VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$17(_);
                return BoxedUnit.UNIT;
            }));
            return either;
        });
    }

    public static final /* synthetic */ Either $anonfun$doPreWriteSteps$10(VerticaDistributedFilesystemWritePipe $this, boolean tableExistsPre$1, boolean tempTableExists) {
        return (tempTableExists ? package$.MODULE$.Left().apply((Object)new TempTableExistsError()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> (!tableExistsPre$1 && $this.config().createExternalTable().isEmpty() ? $this.tableUtils().createTable($this.config().tablename(), $this.config().targetTableSql(), $this.config().schema(), $this.config().strlen()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.tableUtils().tableExists($this.config().tablename()).flatMap((Function1 & Serializable & scala.Serializable)tableExistsPost -> VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$13($this, BoxesRunTime.unboxToBoolean((Object)tableExistsPost)))));
    }

    public static final /* synthetic */ Either $anonfun$doPreWriteSteps$8(VerticaDistributedFilesystemWritePipe $this, boolean tableExistsPre$1, boolean viewExists) {
        return (viewExists ? package$.MODULE$.Left().apply((Object)new ViewExistsError()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.tableUtils().tempTableExists($this.config().tablename()).flatMap((Function1 & Serializable & scala.Serializable)tempTableExists -> VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$10($this, tableExistsPre$1, BoxesRunTime.unboxToBoolean((Object)tempTableExists))));
    }

    public static final /* synthetic */ Either $anonfun$doPreWriteSteps$5(VerticaDistributedFilesystemWritePipe $this, boolean tableExistsPre) {
        return ($this.config().isOverwrite() && $this.config().mergeKey().isEmpty() && tableExistsPre ? package$.MODULE$.Left().apply((Object)new DropTableError()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> ($this.config().createExternalTable().isDefined() && tableExistsPre ? package$.MODULE$.Left().apply((Object)new CreateExternalTableAlreadyExistsError()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.tableUtils().viewExists($this.config().tablename()).flatMap((Function1 & Serializable & scala.Serializable)viewExists -> VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$8($this, tableExistsPre, BoxesRunTime.unboxToBoolean((Object)viewExists)))));
    }

    public static final /* synthetic */ void $anonfun$performMerge$3(BoxedUnit _) {
    }

    public static final /* synthetic */ Tuple6 $anonfun$testFaultTolerance$4(VerticaDistributedFilesystemWritePipe $this, int rowsCopied$1, int rejectedCount) {
        BoxedUnit boxedUnit;
        BoxedUnit x$9;
        BoxedUnit boxedUnit2;
        double failedRowsPercent = rowsCopied$1 > 0 ? (double)rejectedCount / ((double)rowsCopied$1 + (double)rejectedCount) : 1.0;
        boolean passedFaultToleranceTest = failedRowsPercent <= (double)$this.config().failedRowPercentTolerance();
        String tolerance_message = new StringBuilder(124).append("Number of rows_rejected=").append(rejectedCount).append(". rows_copied=").append(rowsCopied$1).append(". failedRowsPercent=").append(failedRowsPercent).append(". user's failed_rows_percent_tolerance=").append($this.config().failedRowPercentTolerance()).append(". passedFaultToleranceTest=").append(((Object)BoxesRunTime.boxToBoolean((boolean)passedFaultToleranceTest)).toString()).toString();
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Verifying rows saved to Vertica is within user tolerance...");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = x$9 = BoxedUnit.UNIT;
        }
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info(new StringBuilder(0).append(tolerance_message).append((Object)(passedFaultToleranceTest ? "...PASSED.  OK to commit to database." : "...FAILED.  NOT OK to commit to database")).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit x$10 = boxedUnit;
        return new Tuple6((Object)BoxesRunTime.boxToInteger((int)rejectedCount), (Object)BoxesRunTime.boxToDouble((double)failedRowsPercent), (Object)BoxesRunTime.boxToBoolean((boolean)passedFaultToleranceTest), (Object)tolerance_message, (Object)x$9, (Object)x$10);
    }

    public static final /* synthetic */ void $anonfun$commitDataIntoVertica$21(BoxedUnit _) {
    }

    public static final /* synthetic */ Either $anonfun$commitDataIntoVertica$6(VerticaDistributedFilesystemWritePipe $this, String tableName$1, int tableNameMaxLength$1, String sessionId$1, String columnList$1, String url$1, boolean tempTableExists) {
        return ($this.config().mergeKey().isDefined() && !tempTableExists ? package$.MODULE$.Left().apply((Object)new CreateTableError((Option<ConnectorError>)None$.MODULE$)) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).map((Function1 & Serializable & scala.Serializable)x$20 -> {
            String rejectsTableName = new StringBuilder(11).append("\"").append(EscapeUtils$.MODULE$.sqlEscape(tableName$1.substring(0, Math.min(tableNameMaxLength$1, tableName$1.length())), EscapeUtils$.MODULE$.sqlEscape$default$2())).append("_").append(sessionId$1).append("_COMMITS").append("\"").toString();
            return new Tuple2(x$20, (Object)rejectsTableName);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$25 -> {
            Tuple2 tuple2 = x$25;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String rejectsTableName = (String)tuple2._2();
            Either either = ($this.config().mergeKey().isDefined() ? package$.MODULE$.Right().apply((Object)$this.tempTableName().getFullTableName()) : package$.MODULE$.Right().apply((Object)$this.config().tablename().getFullTableName())).map((Function1 & Serializable & scala.Serializable)fullTableName -> {
                BoxedUnit boxedUnit;
                String copyStatement = $this.buildCopyStatement((String)fullTableName, columnList$1, url$1, rejectsTableName, "parquet");
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info(new StringBuilder(24).append("The copy statement is: \n").append(copyStatement).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit x$21 = boxedUnit;
                return new Tuple3(fullTableName, (Object)copyStatement, (Object)x$21);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$24 -> {
                Tuple3 tuple3 = x$24;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                String copyStatement = (String)tuple3._2();
                Either either = ($this.config().mergeKey().isDefined() ? package$.MODULE$.Right().apply((Object)$this.performCopy(copyStatement, $this.tempTableName()).left().map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.context("commit: Failed to copy rows into temp table"))) : package$.MODULE$.Right().apply((Object)$this.performCopy(copyStatement, $this.config().tablename()).left().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.context("commit: Failed to copy rows into target table")))).flatMap((Function1 & Serializable & scala.Serializable)rowsCopied -> $this.testFaultTolerance(BoxesRunTime.unboxToInt((Object)rowsCopied.right().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)), rejectsTableName).left().map((Function1 & Serializable & scala.Serializable)err -> new CommitError((ConnectorError)err).context("commit: JDBC Error when trying to determine fault tolerance")).flatMap((Function1 & Serializable & scala.Serializable)faultToleranceResults -> $this.tableUtils().updateJobStatusTable($this.config().tablename(), $this.config().jdbcConfig().auth().user(), faultToleranceResults.failedRowsPercent(), $this.config().sessionId(), faultToleranceResults.success()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> (faultToleranceResults.success() ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)new FaultToleranceTestFail())).flatMap((Function1 & Serializable & scala.Serializable)_ -> ($this.config().mergeKey().isDefined() ? package$.MODULE$.Right().apply((Object)$this.buildMergeStatement($this.config().tablename(), columnList$1, $this.tempTableName().getFullTableName())) : package$.MODULE$.Right().apply((Object)"")).map((Function1 & Serializable & scala.Serializable)mergeStatement -> {
                    BoxedUnit boxedUnit;
                    if ($this.config().mergeKey().isDefined()) {
                        if ($this.logger().underlying().isInfoEnabled()) {
                            $this.logger().underlying().info(new StringBuilder(25).append("The merge statement is: \n").append((String)mergeStatement).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit x$22 = boxedUnit;
                    return new Tuple2(mergeStatement, (Object)x$22);
                }).flatMap((Function1 & Serializable & scala.Serializable)x$23 -> {
                    Tuple2 tuple2 = x$23;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String mergeStatement = (String)tuple2._1();
                    Either either = ($this.config().mergeKey().isDefined() ? $this.performMerge(mergeStatement) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).map((Function1 & Serializable & scala.Serializable)_ -> {
                        VerticaDistributedFilesystemWritePipe.$anonfun$commitDataIntoVertica$21(_);
                        return BoxedUnit.UNIT;
                    });
                    return either;
                })))));
                return either;
            });
            return either;
        });
    }

    public static final /* synthetic */ void $anonfun$commitDataAsExternalTable$6(BoxedUnit _) {
    }

    public VerticaDistributedFilesystemWritePipe(DistributedFilesystemWriteConfig config, FileStoreLayerInterface fileStoreLayer, JdbcLayerInterface jdbcLayer, SchemaToolsInterface schemaTools, TableUtilsInterface tableUtils, int dataSize) {
        this.config = config;
        this.fileStoreLayer = fileStoreLayer;
        this.jdbcLayer = jdbcLayer;
        this.schemaTools = schemaTools;
        this.tableUtils = tableUtils;
        this.dataSize = dataSize;
        this.logger = LogProvider$.MODULE$.getLogger(VerticaDistributedFilesystemWritePipe.class);
        this.tempTableName = new TableName(new StringBuilder(1).append(config.tablename().name()).append("_").append(config.sessionId()).toString(), (Option<String>)None$.MODULE$);
    }

    public class FaultToleranceTestResult
    implements Product,
    scala.Serializable {
        private final boolean success;
        private final double failedRowsPercent;
        public final /* synthetic */ VerticaDistributedFilesystemWritePipe $outer;

        public boolean success() {
            return this.success;
        }

        public double failedRowsPercent() {
            return this.failedRowsPercent;
        }

        public FaultToleranceTestResult copy(boolean success, double failedRowsPercent) {
            return new FaultToleranceTestResult(this.com$vertica$spark$datasource$core$VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$$$outer(), success, failedRowsPercent);
        }

        public boolean copy$default$1() {
            return this.success();
        }

        public double copy$default$2() {
            return this.failedRowsPercent();
        }

        public String productPrefix() {
            return "FaultToleranceTestResult";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Comparable<Boolean> comparable;
            int n = x$1;
            switch (n) {
                case 0: {
                    comparable = BoxesRunTime.boxToBoolean((boolean)this.success());
                    break;
                }
                case 1: {
                    comparable = BoxesRunTime.boxToDouble((double)this.failedRowsPercent());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return comparable;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FaultToleranceTestResult;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)(this.success() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.failedRowsPercent()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FaultToleranceTestResult)) return false;
            if (((FaultToleranceTestResult)object).com$vertica$spark$datasource$core$VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$$$outer() != this.com$vertica$spark$datasource$core$VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FaultToleranceTestResult faultToleranceTestResult = (FaultToleranceTestResult)x$1;
            if (this.success() != faultToleranceTestResult.success()) return false;
            if (this.failedRowsPercent() != faultToleranceTestResult.failedRowsPercent()) return false;
            if (!faultToleranceTestResult.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ VerticaDistributedFilesystemWritePipe com$vertica$spark$datasource$core$VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$$$outer() {
            return this.$outer;
        }

        public FaultToleranceTestResult(VerticaDistributedFilesystemWritePipe $outer, boolean success, double failedRowsPercent) {
            this.success = success;
            this.failedRowsPercent = failedRowsPercent;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

