/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.jdbc;

import buildinfo.BuildInfo$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.AWSArg;
import com.vertica.spark.config.AWSAuth;
import com.vertica.spark.config.AWSOptions;
import com.vertica.spark.config.BasicJdbcAuth;
import com.vertica.spark.config.JDBCConfig;
import com.vertica.spark.config.JDBCTLSConfig;
import com.vertica.spark.config.JdbcAuth;
import com.vertica.spark.config.KerberosAuth;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcLayerIntParam;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcLayerParam;
import com.vertica.spark.datasource.jdbc.JdbcLayerStringParam;
import com.vertica.spark.util.error.ConnectionDownError;
import com.vertica.spark.util.error.ConnectionError;
import com.vertica.spark.util.error.ConnectionSqlError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.DataError;
import com.vertica.spark.util.error.GenericError;
import com.vertica.spark.util.error.MissingNameNodeAddressError;
import com.vertica.spark.util.error.NoSparkSessionFound;
import com.vertica.spark.util.error.ParamsNotSupported;
import com.vertica.spark.util.error.SyntaxError;
import com.vertica.spark.util.general.Utils$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tEa\u0001\u0002\u0010 \u0001)B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006y\u0001!\t!\u0010\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u0011\u0019Q\u0005\u0001)A\u0005\u0005\"91\n\u0001b\u0001\n\u0013a\u0005BB+\u0001A\u0003%Q\nC\u0004W\u0001\t\u0007I\u0011B,\t\ry\u0003\u0001\u0015!\u0003Y\u0011!y\u0006\u0001#b\u0001\n\u0013\u0001\u0007\"\u0002@\u0001\t\u0013y\bbBA\b\u0001\u0011%\u0011\u0011\u0003\u0005\b\u0003c\u0001A\u0011BA\u001a\u0011\u001d\tY\u0004\u0001C\u0005\u0003{Aq!a\u0012\u0001\t\u0013\tI\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0004\"CAB\u0001E\u0005I\u0011AAC\u0011\u001d\tY\n\u0001C\u0001\u0003;C\u0011\"!*\u0001#\u0003%\t!!\"\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\"I\u0011q\u0017\u0001\u0012\u0002\u0013\u0005\u0011Q\u0011\u0005\b\u0003s\u0003A\u0011AA^\u0011\u001d\ti\f\u0001C\u0001\u0003wCq!a0\u0001\t\u0003\tY\fC\u0004\u0002B\u0002!\t!a1\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\"9\u00111\u001c\u0001\u0005\n\u0005u\u0007bBAq\u0001\u0011%\u00111\u001d\u0002\u0011-\u0016\u0014H/[2b\u0015\u0012\u00147\rT1zKJT!\u0001I\u0011\u0002\t)$'m\u0019\u0006\u0003E\r\n!\u0002Z1uCN|WO]2f\u0015\t!S%A\u0003ta\u0006\u00148N\u0003\u0002'O\u00059a/\u001a:uS\u000e\f'\"\u0001\u0015\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Y\u0013\u0007\u0005\u0002-_5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TF\u0001\u0004B]f\u0014VM\u001a\t\u0003eMj\u0011aH\u0005\u0003i}\u0011!C\u00133cG2\u000b\u00170\u001a:J]R,'OZ1dK\u0006\u00191MZ4\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e\u001a\u0013AB2p]\u001aLw-\u0003\u0002<q\tQ!\n\u0012\"D\u0007>tg-[4\u0002\rqJg.\u001b;?)\tqt\b\u0005\u00023\u0001!)QG\u0001a\u0001m\u00051An\\4hKJ,\u0012A\u0011\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bAb]2bY\u0006dwnZ4j]\u001eT!aR\u0014\u0002\u0011QL\b/Z:bM\u0016L!!\u0013#\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nA\u0001\u001d:paV\tQ\n\u0005\u0002O'6\tqJ\u0003\u0002Q#\u0006!Q\u000f^5m\u0015\u0005\u0011\u0016\u0001\u00026bm\u0006L!\u0001V(\u0003\u0015A\u0013x\u000e]3si&,7/A\u0003qe>\u0004\b%A\u0004kI\n\u001cWKU%\u0016\u0003a\u0003\"!\u0017/\u000e\u0003iS!aW)\u0002\t1\fgnZ\u0005\u0003;j\u0013aa\u0015;sS:<\u0017\u0001\u00036eE\u000e,&+\u0013\u0011\u0002\u0015\r|gN\\3di&|g.F\u0001b!\r\u0011W\u000f\u001f\b\u0003GJt!\u0001Z8\u000f\u0005\u0015tgB\u00014n\u001d\t9GN\u0004\u0002iW6\t\u0011N\u0003\u0002kS\u00051AH]8pizJ\u0011\u0001K\u0005\u0003M\u001dJ!\u0001J\u0013\n\u0005A\u001b\u0013B\u00019r\u0003\u0015)'O]8s\u0015\t\u00016%\u0003\u0002ti\u0006iQI\u001d:pe\"\u000bg\u000e\u001a7j]\u001eT!\u0001]9\n\u0005Y<(aD\"p]:,7\r^8s%\u0016\u001cX\u000f\u001c;\u000b\u0005M$\bCA=}\u001b\u0005Q(BA>R\u0003\r\u0019\u0018\u000f\\\u0005\u0003{j\u0014!bQ8o]\u0016\u001cG/[8o\u0003E\u0019'/Z1uK\u000ec\u0017.\u001a8u\u0019\u0006\u0014W\r\\\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\f9!\u0011QAA\u0004!\tAW&C\u0002\u0002\n5\na\u0001\u0015:fI\u00164\u0017bA/\u0002\u000e)\u0019\u0011\u0011B\u0017\u00023!\fg\u000e\u001a7f\u0007>tg.Z2uS>tW\t_2faRLwN\u001c\u000b\u0005\u0003'\tY\u0002\u0005\u0003\u0002\u0016\u0005]Q\"\u0001;\n\u0007\u0005eAO\u0001\bD_:tWm\u0019;pe\u0016\u0013(o\u001c:\t\u000f\u0005u1\u00021\u0001\u0002 \u0005\tQ\r\u0005\u0003\u0002\"\u0005-b\u0002BA\u0012\u0003Oq1\u0001[A\u0013\u0013\u0005q\u0013bAA\u0015[\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0017\u0003_\u0011\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005%R&\u0001\tbI\u0012$Fj\u0015)s_B,'\u000f^5fgR\u0011\u0011Q\u0007\t\u0004Y\u0005]\u0012bAA\u001d[\t!QK\\5u\u000319W\r^*uCR,W.\u001a8u+\t\ty\u0004\u0005\u0003ck\u0006\u0005\u0003cA=\u0002D%\u0019\u0011Q\t>\u0003\u0013M#\u0018\r^3nK:$\u0018\u0001F4fiB\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG\u000f\u0006\u0003\u0002L\u0005M\u0003\u0003\u00022v\u0003\u001b\u00022!_A(\u0013\r\t\tF\u001f\u0002\u0012!J,\u0007/\u0019:fIN#\u0018\r^3nK:$\bBB>\u000f\u0001\u0004\t\t!A\niC:$G.\u001a&E\u0005\u000e+\u0005pY3qi&|g\u000e\u0006\u0003\u0002\u0014\u0005e\u0003bBA\u000f\u001f\u0001\u0007\u0011qD\u0001\u0015C\u0012$\u0007+\u0019:b[N$vn\u0015;bi\u0016lWM\u001c;\u0015\r\u0005U\u0012qLA2\u0011\u001d\t\t\u0007\u0005a\u0001\u0003\u001b\n\u0011b\u001d;bi\u0016lWM\u001c;\t\u000f\u0005\u0015\u0004\u00031\u0001\u0002h\u00051\u0001/\u0019:b[N\u0004b!!\t\u0002j\u00055\u0014\u0002BA6\u0003_\u00111aU3r!\r\u0011\u0014qN\u0005\u0004\u0003cz\"A\u0004&eE\u000ed\u0015-_3s!\u0006\u0014\u0018-\\\u0001\u0006cV,'/\u001f\u000b\u0007\u0003o\ny(!!\u0011\t\t,\u0018\u0011\u0010\t\u0004s\u0006m\u0014bAA?u\nI!+Z:vYR\u001cV\r\u001e\u0005\b\u0003g\n\u0002\u0019AA\u0001\u0011%\t)'\u0005I\u0001\u0002\u0004\t9'A\brk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t9I\u000b\u0003\u0002h\u0005%5FAAF!\u0011\ti)a&\u000e\u0005\u0005=%\u0002BAI\u0003'\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005UU&\u0001\u0006b]:|G/\u0019;j_:LA!!'\u0002\u0010\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u000f\u0015DXmY;uKR1\u0011qTAQ\u0003G\u0003BAY;\u00026!9\u0011\u0011M\nA\u0002\u0005\u0005\u0001\"CA3'A\u0005\t\u0019AA4\u0003E)\u00070Z2vi\u0016$C-\u001a4bk2$HEM\u0001\u000eKb,7-\u001e;f+B$\u0017\r^3\u0015\r\u0005-\u00161WA[!\u0011\u0011W/!,\u0011\u00071\ny+C\u0002\u000226\u00121!\u00138u\u0011\u001d\t\t'\u0006a\u0001\u0003\u0003A\u0011\"!\u001a\u0016!\u0003\u0005\r!a\u001a\u0002/\u0015DXmY;uKV\u0003H-\u0019;fI\u0011,g-Y;mi\u0012\u0012\u0014!B2m_N,GCAAP\u0003\u0019\u0019w.\\7ji\u0006A!o\u001c7mE\u0006\u001c7.\u0001\td_:4\u0017nZ;sKN+7o]5p]R!\u0011qTAc\u0011\u001d\t9M\u0007a\u0001\u0003\u0013\faBZ5mKN#xN]3MCf,'\u000f\u0005\u0003\u0002L\u0006EWBAAg\u0015\r\ty-I\u0001\u0003MNLA!a5\u0002N\n9b)\u001b7f'R|'/\u001a'bs\u0016\u0014\u0018J\u001c;fe\u001a\f7-Z\u0001\u0017G>tg-[4ve\u0016\fuk\u0015)be\u0006lW\r^3sgR!\u0011qTAm\u0011\u001d\t9m\u0007a\u0001\u0003\u0013\fAdY8oM&<WO]3LKJ\u0014WM]8t)>4\u0015\u000e\\3ti>\u0014X\r\u0006\u0003\u0002 \u0006}\u0007bBAd9\u0001\u0007\u0011\u0011Z\u0001\u000ekN,7i\u001c8oK\u000e$\u0018n\u001c8\u0016\t\u0005\u0015\u0018Q\u001e\u000b\t\u0003O\fyP!\u0001\u0003\fA!!-^Au!\u0011\tY/!<\r\u0001\u00119\u0011q^\u000fC\u0002\u0005E(!\u0001+\u0012\t\u0005M\u0018\u0011 \t\u0004Y\u0005U\u0018bAA|[\t9aj\u001c;iS:<\u0007c\u0001\u0017\u0002|&\u0019\u0011Q`\u0017\u0003\u0007\u0005s\u0017\u0010C\u0003`;\u0001\u0007\u0001\u0010C\u0004\u0003\u0004u\u0001\rA!\u0002\u0002\r\u0005\u001cG/[8o!\u0019a#q\u0001=\u0002j&\u0019!\u0011B\u0017\u0003\u0013\u0019+hn\u0019;j_:\f\u0004b\u0002B\u0007;\u0001\u0007!qB\u0001\u0011Kb\u001cW\r\u001d;j_:\u001c\u0015\r^2iKJ\u0004r\u0001\fB\u0004\u0003?\t\u0019\u0002")
public class VerticaJdbcLayer
implements JdbcLayerInterface {
    private Either<ConnectorError, Connection> connection;
    private final JDBCConfig cfg;
    private final Logger logger;
    private final Properties prop;
    private final String jdbcURI;
    private volatile boolean bitmap$0;

    private Logger logger() {
        return this.logger;
    }

    private Properties prop() {
        return this.prop;
    }

    private String jdbcURI() {
        return this.jdbcURI;
    }

    private Either<ConnectorError, Connection> connection$lzycompute() {
        VerticaJdbcLayer verticaJdbcLayer = this;
        synchronized (verticaJdbcLayer) {
            if (!this.bitmap$0) {
                this.connection = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> DriverManager.getConnection(this.jdbcURI(), this.prop())).toEither().left().map((Function1 & Serializable & scala.Serializable)e -> this.handleConnectionException((Throwable)e)).flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> {
                    BoxedUnit boxedUnit;
                    c.setClientInfo("APPLICATIONNAME", this.createClientLabel());
                    c.setAutoCommit(false);
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Successfully connected to Vertica.");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return c;
                }, (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleConnectionException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.context("Initial connection was not valid.")));
                this.bitmap$0 = true;
            }
        }
        return this.connection;
    }

    private Either<ConnectorError, Connection> connection() {
        return !this.bitmap$0 ? this.connection$lzycompute() : this.connection;
    }

    private String createClientLabel() {
        String string;
        JdbcAuth jdbcAuth = this.cfg.auth();
        if (jdbcAuth instanceof BasicJdbcAuth) {
            string = "-p";
        } else if (jdbcAuth instanceof KerberosAuth) {
            string = "-k";
        } else {
            throw new MatchError((Object)jdbcAuth);
        }
        String authMethod = string;
        String sparkVersion = SparkSession$.MODULE$.active().sparkContext().version();
        return new StringBuilder(12).append("vspark-vs").append(BuildInfo$.MODULE$.version()).append(authMethod).append("-sp").append(sparkVersion).toString();
    }

    private ConnectorError handleConnectionException(Throwable e) {
        Product product;
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            product = new ConnectionSqlError(sQLException);
        } else if (throwable != null) {
            Throwable throwable2 = throwable;
            product = new ConnectionError(throwable2);
        } else {
            throw new MatchError((Object)throwable);
        }
        return product;
    }

    private void addTLSProperties() {
        JDBCTLSConfig tlsConfig = this.cfg.tlsConfig();
        Utils$.MODULE$.ignore(this.prop().put("TLSmode", tlsConfig.tlsMode().toString()));
        Option<String> option = tlsConfig.keyStorePath();
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            Utils$.MODULE$.ignore(this.prop().put("KeyStorePath", path));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        Option<String> option2 = tlsConfig.keyStorePassword();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String password = (String)some.value();
            Utils$.MODULE$.ignore(this.prop().put("KeyStorePassword", password));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option2);
        }
        Option<String> option3 = tlsConfig.trustStorePath();
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            String path = (String)some.value();
            Utils$.MODULE$.ignore(this.prop().put("TrustStorePath", path));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option3)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option3);
        }
        Option<String> option4 = tlsConfig.trustStorePassword();
        if (option4 instanceof Some) {
            Some some = (Some)option4;
            String password = (String)some.value();
            Utils$.MODULE$.ignore(this.prop().put("TrustStorePassword", password));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option4)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option4);
        }
    }

    private Either<ConnectorError, Statement> getStatement() {
        return this.connection().flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> c.createStatement(), (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.context("getStatement: Error while trying to create statement.")));
    }

    private Either<ConnectorError, PreparedStatement> getPreparedStatement(String sql) {
        return this.connection().flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> c.prepareStatement(sql), (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.context("getPreparedStatement: Error while getting prepared statement.")));
    }

    @Override
    public ConnectorError handleJDBCException(Throwable e) {
        ConnectorError connectorError;
        Throwable throwable = e;
        if (throwable instanceof SQLSyntaxErrorException) {
            SQLSyntaxErrorException sQLSyntaxErrorException = (SQLSyntaxErrorException)throwable;
            connectorError = new SyntaxError(sQLSyntaxErrorException);
        } else if (throwable instanceof SQLDataException) {
            SQLDataException sQLDataException = (SQLDataException)throwable;
            connectorError = new DataError(sQLDataException);
        } else if (throwable != null) {
            connectorError = new GenericError(e).context("Unexpected SQL Error.");
        } else {
            throw new MatchError((Object)throwable);
        }
        return connectorError;
    }

    private void addParamsToStatement(PreparedStatement statement, Seq<JdbcLayerParam> params) {
        ((IterableLike)params.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            VerticaJdbcLayer.$anonfun$addParamsToStatement$1(statement, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Either<ConnectorError, ResultSet> query(String query, Seq<JdbcLayerParam> params) {
        Either either;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(26).append("Attempting to send query: ").append(query).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Left left;
            Either<ConnectorError, PreparedStatement> either = this.getPreparedStatement(query);
            if (either instanceof Right) {
                Right right = (Right)either;
                PreparedStatement stmt = (PreparedStatement)right.value();
                this.addParamsToStatement(stmt, params);
                left = package$.MODULE$.Right().apply((Object)stmt.executeQuery());
            } else if (either instanceof Left) {
                Left left2 = (Left)either;
                ConnectorError err = (ConnectorError)left2.value();
                left = package$.MODULE$.Left().apply((Object)err);
            } else {
                throw new MatchError(either);
            }
            return left;
        });
        if (try_ instanceof Success) {
            Either v;
            Success success = (Success)try_;
            either = v = (Either)success.value();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            either = package$.MODULE$.Left().apply((Object)this.handleJDBCException(e).context("Error when sending query"));
        } else {
            throw new MatchError((Object)try_);
        }
        return either;
    }

    @Override
    public Seq<JdbcLayerParam> query$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> execute(String statement, Seq<JdbcLayerParam> params) {
        Either either;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(33).append("Attempting to execute statement: ").append(statement).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Right right;
            if (params.nonEmpty()) {
                Left left;
                Either<ConnectorError, PreparedStatement> either = this.getPreparedStatement(statement);
                if (either instanceof Right) {
                    Right right2 = (Right)either;
                    PreparedStatement stmt = (PreparedStatement)right2.value();
                    this.addParamsToStatement(stmt, params);
                    stmt.execute();
                    left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                } else if (either instanceof Left) {
                    Left left2 = (Left)either;
                    ConnectorError err = (ConnectorError)left2.value();
                    left = package$.MODULE$.Left().apply((Object)err);
                } else {
                    throw new MatchError(either);
                }
                right = left;
            } else {
                Right right3;
                Either<ConnectorError, Statement> either = this.getStatement();
                if (either instanceof Right) {
                    Right right4 = (Right)either;
                    Statement stmt = (Statement)right4.value();
                    stmt.execute(statement);
                    right3 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                } else if (either instanceof Left) {
                    Left left = (Left)either;
                    ConnectorError err = (ConnectorError)left.value();
                    right3 = package$.MODULE$.Left().apply((Object)err);
                } else {
                    throw new MatchError(either);
                }
                right = right3;
            }
            return right;
        });
        if (try_ instanceof Success) {
            Either v;
            Success success = (Success)try_;
            either = v = (Either)success.value();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            either = package$.MODULE$.Left().apply((Object)this.handleJDBCException(e));
        } else {
            throw new MatchError((Object)try_);
        }
        return either;
    }

    @Override
    public Seq<JdbcLayerParam> execute$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public Either<ConnectorError, Object> executeUpdate(String statement, Seq<JdbcLayerParam> params) {
        Left left;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(33).append("Attempting to execute statement: ").append(statement).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (params.nonEmpty()) {
            left = package$.MODULE$.Left().apply((Object)new ParamsNotSupported("executeUpdate"));
        } else {
            Either either;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.getStatement().map((Function1 & Serializable & scala.Serializable)stmt -> BoxesRunTime.boxToInteger((int)stmt.executeUpdate(statement))));
            if (try_ instanceof Success) {
                Either v;
                Success success = (Success)try_;
                either = v = (Either)success.value();
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                either = package$.MODULE$.Left().apply((Object)this.handleJDBCException(e));
            } else {
                throw new MatchError((Object)try_);
            }
            left = either;
        }
        return left;
    }

    @Override
    public Seq<JdbcLayerParam> executeUpdate$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> close() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Closing connection.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.connection().flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> {
            c.close();
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.context("close: JDBC Error closing the connection.")));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> commit() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Commiting.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.connection().flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> {
            c.commit();
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.context("commit: JDBC Error while commiting.")));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> rollback() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Rolling back.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.connection().flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> {
            c.rollback();
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.context("rollback: JDBC Error while rolling back.")));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> configureSession(FileStoreLayerInterface fileStoreLayer) {
        return this.configureKerberosToFilestore(fileStoreLayer).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.configureAWSParameters(fileStoreLayer).map((Function1 & Serializable & scala.Serializable)_ -> {
            VerticaJdbcLayer.$anonfun$configureSession$2(_);
            return BoxedUnit.UNIT;
        }));
    }

    private Either<ConnectorError, BoxedUnit> configureAWSParameters(FileStoreLayerInterface fileStoreLayer) {
        Either<ConnectorError, BoxedUnit> either;
        AWSOptions awsOptions = fileStoreLayer.getAWSOptions();
        Option<AWSAuth> option = awsOptions.awsAuth();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Some some = (Some)option;
            AWSAuth awsAuth = (AWSAuth)some.value();
            String sql = new StringBuilder(29).append("ALTER SESSION SET AWSAuth='").append((Object)awsAuth.accessKeyId().arg()).append(":").append((Object)awsAuth.secretAccessKey().arg()).append("'").toString();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded AWS access key ID from {}", new Object[]{awsAuth.accessKeyId().origin()});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded AWS secret access key from {}", new Object[]{awsAuth.secretAccessKey().origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            either = this.execute(sql, this.execute$default$2());
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWSAuth");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError(option);
        }
        return either.flatMap((Function1 & Serializable & scala.Serializable)_2 -> {
            Either<ConnectorError, BoxedUnit> either;
            Option<AWSArg<String>> option = awsOptions.awsRegion();
            if (option instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option;
                AWSArg awsRegion = (AWSArg)some.value();
                String sql = new StringBuilder(30).append("ALTER SESSION SET AWSRegion='").append(awsRegion.arg()).append("'").toString();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Setting AWSRegion for session: {}", new Object[]{awsRegion});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                either = this.execute(sql, this.execute$default$2());
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Did not set AWSRegion");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError(option);
            }
            return either.flatMap((Function1 & Serializable & scala.Serializable)_ -> {
                Either<ConnectorError, BoxedUnit> either;
                Option<AWSArg<String>> option = awsOptions.awsSessionToken();
                if (option instanceof Some) {
                    BoxedUnit boxedUnit;
                    Some some = (Some)option;
                    AWSArg token = (AWSArg)some.value();
                    String sql = new StringBuilder(36).append("ALTER SESSION SET AWSSessionToken='").append(token.arg()).append("'").toString();
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Loaded AWSSessionToken from {}", new Object[]{token.origin()});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    either = this.execute(sql, this.execute$default$2());
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Did not set AWSSessionToken");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                } else {
                    throw new MatchError(option);
                }
                return either.flatMap((Function1 & Serializable & scala.Serializable)_2 -> {
                    Either<ConnectorError, BoxedUnit> either;
                    Option<AWSArg<String>> option = awsOptions.awsEndpoint();
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        AWSArg endpoint = (AWSArg)some.value();
                        String sql = new StringBuilder(32).append("ALTER SESSION SET AWSEndpoint='").append(endpoint.arg()).append("'").toString();
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Loaded AWSEndpoint from {}", new Object[]{endpoint.origin()});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        either = this.execute(sql, this.execute$default$2());
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Did not set AWSEndpoint");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    } else {
                        throw new MatchError(option);
                    }
                    return either.map((Function1 & Serializable & scala.Serializable)_ -> {
                        VerticaJdbcLayer.$anonfun$configureAWSParameters$4(_);
                        return BoxedUnit.UNIT;
                    });
                });
            });
        });
    }

    /*
     * Unable to fully structure code
     */
    private Either<ConnectorError, BoxedUnit> configureKerberosToFilestore(FileStoreLayerInterface fileStoreLayer) {
        block11: {
            block10: {
                var4_2 = SparkSession$.MODULE$.getActiveSession();
                if (!(var4_2 instanceof Some)) break block10;
                var5_3 = (Some)var4_2;
                session = (SparkSession)var5_3.value();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Hadoop impersonation: found session");
                    v0 = BoxedUnit.UNIT;
                } else {
                    v0 = BoxedUnit.UNIT;
                }
                hadoopConf = session.sparkContext().hadoopConfiguration();
                authMethod = Option$.MODULE$.apply((Object)hadoopConf.get("hadoop.security.authentication"));
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(35).append("Hadoop impersonation: auth method: ").append(authMethod).toString());
                    v1 = BoxedUnit.UNIT;
                } else {
                    v1 = BoxedUnit.UNIT;
                }
                var9_7 = authMethod;
                if (!(var9_7 instanceof Some)) ** GOTO lbl-1000
                var10_8 = (Some)var9_7;
                v2 = authMethod = (String)var10_8.value();
                var12_10 = "kerberos";
                if (!(v2 != null ? v2.equals(var12_10) == false : var12_10 != null)) {
                    var3_11 = Option$.MODULE$.apply((Object)hadoopConf.get("dfs.namenode.https-address")).orElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$configureKerberosToFilestore$1(org.apache.hadoop.conf.Configuration ), ()Lscala/Option;)((Configuration)hadoopConf)).toRight((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$configureKerberosToFilestore$2(), ()Lcom/vertica/spark/util/error/MissingNameNodeAddressError;)()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$configureKerberosToFilestore$3(com.vertica.spark.datasource.jdbc.VerticaJdbcLayer java.lang.String ), (Ljava/lang/String;)Lscala/Tuple2;)((VerticaJdbcLayer)this)).flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$configureKerberosToFilestore$4(com.vertica.spark.datasource.jdbc.VerticaJdbcLayer com.vertica.spark.datasource.fs.FileStoreLayerInterface scala.Tuple2 ), (Lscala/Tuple2;)Lscala/util/Either;)((VerticaJdbcLayer)this, (FileStoreLayerInterface)fileStoreLayer));
                } else lbl-1000:
                // 2 sources

                {
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Kerberos is not enabled in the hadoop config.");
                        v3 = BoxedUnit.UNIT;
                    } else {
                        v3 = BoxedUnit.UNIT;
                    }
                    var3_11 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                }
                var2_12 = var3_11;
                break block11;
            }
            if (None$.MODULE$.equals(var4_2)) {
                var2_12 = package$.MODULE$.Left().apply((Object)new NoSparkSessionFound());
            } else {
                throw new MatchError((Object)var4_2);
            }
        }
        return var2_12;
    }

    private <T> Either<ConnectorError, T> useConnection(Connection connection, Function1<Connection, T> action, Function1<Throwable, ConnectorError> exceptionCatcher) {
        Left left;
        block3: {
            try {
                if (connection.isValid(0)) {
                    left = package$.MODULE$.Right().apply(action.apply((Object)connection));
                    break block3;
                }
                left = package$.MODULE$.Left().apply((Object)new ConnectionDownError());
            }
            catch (Throwable e) {
                left = package$.MODULE$.Left().apply(exceptionCatcher.apply((Object)e));
            }
        }
        return left;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$addParamsToStatement$1(PreparedStatement statement$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        JdbcLayerParam param = (JdbcLayerParam)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        int i = idx + 1;
        JdbcLayerParam jdbcLayerParam = param;
        if (jdbcLayerParam instanceof JdbcLayerStringParam) {
            JdbcLayerStringParam jdbcLayerStringParam = (JdbcLayerStringParam)jdbcLayerParam;
            statement$1.setString(i, jdbcLayerStringParam.value());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!(jdbcLayerParam instanceof JdbcLayerIntParam)) throw new MatchError((Object)jdbcLayerParam);
            JdbcLayerIntParam jdbcLayerIntParam = (JdbcLayerIntParam)jdbcLayerParam;
            statement$1.setInt(i, jdbcLayerIntParam.value());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$configureSession$2(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$configureAWSParameters$4(BoxedUnit _) {
    }

    public static final /* synthetic */ Option $anonfun$configureKerberosToFilestore$1(Configuration hadoopConf$1) {
        return Option$.MODULE$.apply((Object)hadoopConf$1.get("dfs.namenode.http-address"));
    }

    public static final /* synthetic */ MissingNameNodeAddressError $anonfun$configureKerberosToFilestore$2() {
        return new MissingNameNodeAddressError();
    }

    public static final /* synthetic */ Tuple2 $anonfun$configureKerberosToFilestore$3(VerticaJdbcLayer $this, String nameNodeAddress) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(41).append("Hadoop impersonation: name node address: ").append(nameNodeAddress).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit x$7 = boxedUnit;
        return new Tuple2((Object)nameNodeAddress, (Object)x$7);
    }

    public static final /* synthetic */ void $anonfun$configureKerberosToFilestore$7(BoxedUnit _) {
    }

    public static final /* synthetic */ Either $anonfun$configureKerberosToFilestore$4(VerticaJdbcLayer $this, FileStoreLayerInterface fileStoreLayer$2, Tuple2 x$9) {
        Tuple2 tuple2 = x$9;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String nameNodeAddress = (String)tuple2._1();
        Either either = fileStoreLayer$2.getImpersonationToken($this.cfg.auth().user()).map((Function1 & Serializable & scala.Serializable)encodedDelegationToken -> {
            String jsonString = new StringBuilder(103).append("\n                {\n                   \"authority\": \"").append(nameNodeAddress).append("\",\n                   \"token\": \"").append((String)encodedDelegationToken).append("\"\n                }").toString();
            String sql = new StringBuilder(48).append("ALTER SESSION SET HadoopImpersonationConfig='[").append(jsonString).append("]'").toString();
            return new Tuple3(encodedDelegationToken, (Object)jsonString, (Object)sql);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> {
            Tuple3 tuple3 = x$8;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String sql = (String)tuple3._3();
            Either either = $this.execute(sql, $this.execute$default$2()).map((Function1 & Serializable & scala.Serializable)_ -> {
                VerticaJdbcLayer.$anonfun$configureKerberosToFilestore$7(_);
                return BoxedUnit.UNIT;
            });
            return either;
        });
        return either;
    }

    public VerticaJdbcLayer(JDBCConfig cfg) {
        BoxedUnit boxedUnit;
        this.cfg = cfg;
        this.logger = LogProvider$.MODULE$.getLogger(VerticaJdbcLayer.class);
        this.prop = new Properties();
        JdbcAuth jdbcAuth = cfg.auth();
        if (jdbcAuth instanceof BasicJdbcAuth) {
            BasicJdbcAuth basicJdbcAuth = (BasicJdbcAuth)jdbcAuth;
            String username = basicJdbcAuth.username();
            String password = basicJdbcAuth.password();
            Utils$.MODULE$.ignore(this.prop().put("user", username));
            Utils$.MODULE$.ignore(this.prop().put("password", password));
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (jdbcAuth instanceof KerberosAuth) {
            KerberosAuth kerberosAuth = (KerberosAuth)jdbcAuth;
            String username = kerberosAuth.username();
            String kerberosServiceName = kerberosAuth.kerberosServiceName();
            String kerberosHostname = kerberosAuth.kerberosHostname();
            String jaasConfigName = kerberosAuth.jaasConfigName();
            Utils$.MODULE$.ignore(this.prop().put("user", username));
            Utils$.MODULE$.ignore(this.prop().put("KerberosServiceName", kerberosServiceName));
            Utils$.MODULE$.ignore(this.prop().put("KerberosHostname", kerberosHostname));
            Utils$.MODULE$.ignore(this.prop().put("JAASConfigName", jaasConfigName));
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)jdbcAuth);
        }
        this.addTLSProperties();
        Class.forName("com.vertica.jdbc.Driver");
        this.jdbcURI = new StringBuilder(17).append("jdbc:vertica://").append(cfg.host()).append(":").append(cfg.port()).append("/").append(cfg.db()).toString();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(32).append("Connecting to Vertica with URI: ").append(this.jdbcURI()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

