/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet.vertica;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.execution.datasources.parquet.vertica.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.vertica.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\t\u0013\u0001\rB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005W!)q\u0006\u0001C\u0001a!)q\u0006\u0001C\u0001k!)q\u0006\u0001C\u0001}!)q\t\u0001C\u0001\u0011\")q\t\u0001C\u00051\")Q\f\u0001C\u0001=\")q\r\u0001C\u0005Q\")a\u000e\u0001C\u0005_\")\u0011\u000f\u0001C\u0005e\u001eI\u0011Q\u0001\n\u0002\u0002#\u0005\u0011q\u0001\u0004\t#I\t\t\u0011#\u0001\u0002\n!1q&\u0004C\u0001\u0003\u0017A\u0011\"!\u0004\u000e#\u0003%\t!a\u0004\t\u0013\u0005\u0015R\"%A\u0005\u0002\u0005=!!\b)beF,X\r\u001e+p'B\f'o[*dQ\u0016l\u0017mQ8om\u0016\u0014H/\u001a:\u000b\u0005M!\u0012a\u0002<feRL7-\u0019\u0006\u0003+Y\tq\u0001]1scV,GO\u0003\u0002\u00181\u0005YA-\u0019;bg>,(oY3t\u0015\tI\"$A\u0005fq\u0016\u001cW\u000f^5p]*\u00111\u0004H\u0001\u0004gFd'BA\u000f\u001f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0002%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\n\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0002)\u0005\u001c8/^7f\u0005&t\u0017M]=JgN#(/\u001b8h!\t)C&\u0003\u0002.M\t9!i\\8mK\u0006t\u0017AF1tgVlW-\u00138usYJ5\u000fV5nKN$\u0018-\u001c9\u0002\rqJg.\u001b;?)\r\t4\u0007\u000e\t\u0003e\u0001i\u0011A\u0005\u0005\bU\r\u0001\n\u00111\u0001,\u0011\u001dq3\u0001%AA\u0002-\"\"!\r\u001c\t\u000b]\"\u0001\u0019\u0001\u001d\u0002\t\r|gN\u001a\t\u0003sqj\u0011A\u000f\u0006\u0003wi\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003{i\u0012qaU)M\u0007>tg\r\u0006\u00022\u007f!)q'\u0002a\u0001\u0001B\u0011\u0011)R\u0007\u0002\u0005*\u0011qg\u0011\u0006\u0003\tz\ta\u0001[1e_>\u0004\u0018B\u0001$C\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u000691m\u001c8wKJ$HCA%P!\tQU*D\u0001L\u0015\ta%$A\u0003usB,7/\u0003\u0002O\u0017\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000bA3\u0001\u0019A)\u0002\u001bA\f'/];fiN\u001b\u0007.Z7b!\t\u0011f+D\u0001T\u0015\t!V+\u0001\u0004tG\",W.\u0019\u0006\u0003+yI!aV*\u0003\u00175+7o]1hKRK\b/\u001a\u000b\u0003\u0013fCQ\u0001U\u0004A\u0002i\u0003\"AU.\n\u0005q\u001b&!C$s_V\u0004H+\u001f9f\u00031\u0019wN\u001c<feR4\u0015.\u001a7e)\ty&\r\u0005\u0002KA&\u0011\u0011m\u0013\u0002\t\t\u0006$\u0018\rV=qK\")1\r\u0003a\u0001I\u0006Y\u0001/\u0019:rk\u0016$H+\u001f9f!\t\u0011V-\u0003\u0002g'\n!A+\u001f9f\u0003U\u0019wN\u001c<feR\u0004&/[7ji&4XMR5fY\u0012$\"aX5\t\u000b)L\u0001\u0019A6\u0002\u000b\u0019LW\r\u001c3\u0011\u0005Ic\u0017BA7T\u00055\u0001&/[7ji&4X\rV=qK\u0006\t2m\u001c8wKJ$xI]8va\u001aKW\r\u001c3\u0015\u0005}\u0003\b\"\u00026\u000b\u0001\u0004Q\u0016!D5t\u000b2,W.\u001a8u)f\u0004X\rF\u0002,gVDQ\u0001^\u0006A\u0002\u0011\fAB]3qK\u0006$X\r\u001a+za\u0016DQA^\u0006A\u0002]\f!\u0002]1sK:$h*Y7f!\tAxP\u0004\u0002z{B\u0011!PJ\u0007\u0002w*\u0011API\u0001\u0007yI|w\u000e\u001e \n\u0005y4\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0002\u0005\r!AB*ue&twM\u0003\u0002\u007fM\u0005i\u0002+\u0019:rk\u0016$Hk\\*qCJ\\7k\u00195f[\u0006\u001cuN\u001c<feR,'\u000f\u0005\u00023\u001bM\u0011Q\u0002\n\u000b\u0003\u0003\u000f\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nTCAA\tU\rY\u00131C\u0016\u0003\u0003+\u0001B!a\u0006\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0004\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002$\u0005e!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\u0002")
public class ParquetToSparkSchemaConverter {
    private final boolean assumeBinaryIsString;
    private final boolean assumeInt96IsTimestamp;

    public static boolean $lessinit$greater$default$2() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public StructType convert(MessageType parquetSchema) {
        return this.convert(parquetSchema.asGroupType());
    }

    private StructType convert(GroupType parquetSchema) {
        Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetSchema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> {
            StructField structField;
            Type.Repetition repetition = field.getRepetition();
            if (Type.Repetition.OPTIONAL.equals(repetition)) {
                structField = new StructField(field.getName(), this.convertField((Type)field), true, StructField$.MODULE$.apply$default$4());
            } else if (Type.Repetition.REQUIRED.equals(repetition)) {
                structField = new StructField(field.getName(), this.convertField((Type)field), false, StructField$.MODULE$.apply$default$4());
            } else if (Type.Repetition.REPEATED.equals(repetition)) {
                ArrayType arrayType = new ArrayType(this.convertField((Type)field), false);
                structField = new StructField(field.getName(), (DataType)arrayType, false, StructField$.MODULE$.apply$default$4());
            } else {
                throw new MatchError((Object)repetition);
            }
            return structField;
        }, Buffer$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply(fields.toSeq());
    }

    public DataType convertField(Type parquetType) {
        DataType dataType;
        Type type = parquetType;
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            dataType = this.convertPrimitiveField(primitiveType);
        } else if (type instanceof GroupType) {
            GroupType groupType = (GroupType)type;
            dataType = this.convertGroupField(groupType.asGroupType());
        } else {
            throw new MatchError((Object)type);
        }
        return dataType;
    }

    /*
     * Unable to fully structure code
     */
    private DataType convertPrimitiveField(PrimitiveType field) {
        block36: {
            block42: {
                block44: {
                    block43: {
                        block41: {
                            block40: {
                                block39: {
                                    block38: {
                                        block37: {
                                            block35: {
                                                typeName = field.getPrimitiveTypeName();
                                                originalType = field.getOriginalType();
                                                var12_4 = typeName;
                                                if (!PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(var12_4)) break block35;
                                                var2_5 = BooleanType$.MODULE$;
                                                break block36;
                                            }
                                            if (!PrimitiveType.PrimitiveTypeName.FLOAT.equals(var12_4)) break block37;
                                            var2_5 = FloatType$.MODULE$;
                                            break block36;
                                        }
                                        if (!PrimitiveType.PrimitiveTypeName.DOUBLE.equals(var12_4)) break block38;
                                        var2_5 = DoubleType$.MODULE$;
                                        break block36;
                                    }
                                    if (!PrimitiveType.PrimitiveTypeName.INT32.equals(var12_4)) break block39;
                                    var13_6 = originalType;
                                    if (OriginalType.INT_8.equals(var13_6)) {
                                        var8_7 = ByteType$.MODULE$;
                                    } else if (OriginalType.INT_16.equals(var13_6)) {
                                        var8_7 = ShortType$.MODULE$;
                                    } else {
                                        var9_8 = OriginalType.INT_32.equals(var13_6) != false ? true : var13_6 == null;
                                        if (var9_8) {
                                            var8_7 = IntegerType$.MODULE$;
                                        } else if (OriginalType.DATE.equals(var13_6)) {
                                            var8_7 = DateType$.MODULE$;
                                        } else if (OriginalType.DECIMAL.equals(var13_6)) {
                                            var8_7 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_INT_DIGITS(), field, typeName);
                                        } else {
                                            if (OriginalType.UINT_8.equals(var13_6)) {
                                                throw ParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                            }
                                            if (OriginalType.UINT_16.equals(var13_6)) {
                                                throw ParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                            }
                                            if (OriginalType.UINT_32.equals(var13_6)) {
                                                throw ParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                            }
                                            if (OriginalType.TIME_MILLIS.equals(var13_6)) {
                                                throw ParquetToSparkSchemaConverter.typeNotImplemented$1(originalType, typeName);
                                            }
                                            throw ParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                                        }
                                    }
                                    var2_5 = var8_7;
                                    break block36;
                                }
                                if (!PrimitiveType.PrimitiveTypeName.INT64.equals(var12_4)) break block40;
                                var14_9 = originalType;
                                var7_10 = OriginalType.INT_64.equals(var14_9) != false ? true : var14_9 == null;
                                if (var7_10) {
                                    var6_11 = LongType$.MODULE$;
                                } else if (OriginalType.DECIMAL.equals(var14_9)) {
                                    var6_11 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_LONG_DIGITS(), field, typeName);
                                } else {
                                    if (OriginalType.UINT_64.equals(var14_9)) {
                                        throw ParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                    }
                                    if (OriginalType.TIMESTAMP_MICROS.equals(var14_9)) {
                                        var6_11 = TimestampType$.MODULE$;
                                    } else if (OriginalType.TIMESTAMP_MILLIS.equals(var14_9)) {
                                        var6_11 = TimestampType$.MODULE$;
                                    } else {
                                        throw ParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                                    }
                                }
                                var2_5 = var6_11;
                                break block36;
                            }
                            if (!PrimitiveType.PrimitiveTypeName.INT96.equals(var12_4)) break block41;
                            ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$convertPrimitiveField$2(org.apache.spark.sql.execution.datasources.parquet.vertica.ParquetToSparkSchemaConverter ), ()Z)((ParquetToSparkSchemaConverter)this), new StringBuilder(88).append("INT96 is not supported unless it's interpreted as timestamp. ").append("Please try to set ").append(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()).append(" to true.").toString());
                            var2_5 = TimestampType$.MODULE$;
                            break block36;
                        }
                        if (!PrimitiveType.PrimitiveTypeName.BINARY.equals(var12_4)) break block42;
                        var15_12 = false;
                        var16_13 = null;
                        var17_14 = originalType;
                        var5_15 = OriginalType.UTF8.equals(var17_14) != false ? true : (OriginalType.ENUM.equals(var17_14) != false ? true : OriginalType.JSON.equals(var17_14) != false);
                        if (!var5_15) break block43;
                        var4_16 = StringType$.MODULE$;
                        break block44;
                    }
                    if (var17_14 != null) ** GOTO lbl-1000
                    var15_12 = true;
                    var16_13 = var17_14;
                    if (this.assumeBinaryIsString) {
                        var4_16 = StringType$.MODULE$;
                    } else if (var15_12) {
                        var4_16 = BinaryType$.MODULE$;
                    } else if (OriginalType.BSON.equals(var17_14)) {
                        var4_16 = BinaryType$.MODULE$;
                    } else if (OriginalType.DECIMAL.equals(var17_14)) {
                        var4_16 = ParquetToSparkSchemaConverter.makeDecimalType$1(ParquetToSparkSchemaConverter.makeDecimalType$default$1$1(), field, typeName);
                    } else {
                        throw ParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                    }
                }
                var2_5 = var4_16;
                break block36;
            }
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(var12_4)) {
                var18_17 = originalType;
                if (!OriginalType.DECIMAL.equals(var18_17)) {
                    if (OriginalType.INTERVAL.equals(var18_17)) {
                        throw ParquetToSparkSchemaConverter.typeNotImplemented$1(originalType, typeName);
                    }
                    throw ParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                }
                var3_18 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.maxPrecisionForBytes(field.getTypeLength()), field, typeName);
                var2_5 = var3_18;
            } else {
                throw ParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
            }
        }
        return var2_5;
    }

    private DataType convertGroupField(GroupType field) {
        return (DataType)Option$.MODULE$.apply((Object)field.getOriginalType()).fold((Function0 & Serializable & scala.Serializable)() -> this.convert(field), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArrayType arrayType;
            OriginalType originalType = x0$1;
            if (OriginalType.LIST.equals(originalType)) {
                ArrayType arrayType2;
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1, new StringBuilder(18).append("Invalid list type ").append(field).toString());
                Type repeatedType = field.getType(0);
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> repeatedType.isRepetition(Type.Repetition.REPEATED), new StringBuilder(18).append("Invalid list type ").append(field).toString());
                if (this.isElementType(repeatedType, field.getName())) {
                    arrayType2 = new ArrayType(this.convertField(repeatedType), false);
                } else {
                    Type elementType = repeatedType.asGroupType().getType(0);
                    boolean optional = elementType.isRepetition(Type.Repetition.OPTIONAL);
                    arrayType2 = new ArrayType(this.convertField(elementType), optional);
                }
                arrayType = arrayType2;
            } else {
                boolean bl = OriginalType.MAP.equals(originalType) ? true : OriginalType.MAP_KEY_VALUE.equals(originalType);
                if (bl) {
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1 && !field.getType(0).isPrimitive(), new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    GroupType keyValueType = field.getType(0).asGroupType();
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> keyValueType.isRepetition(Type.Repetition.REPEATED) && keyValueType.getFieldCount() == 2, new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    Type keyType = keyValueType.getType(0);
                    Type valueType = keyValueType.getType(1);
                    boolean valueOptional = valueType.isRepetition(Type.Repetition.OPTIONAL);
                    arrayType = new MapType(this.convertField(keyType), this.convertField(valueType), valueOptional);
                } else {
                    throw new AnalysisException(new StringBuilder(27).append("Unrecognized Parquet type: ").append(field).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
            return arrayType;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isElementType(Type repeatedType, String parentName) {
        if (repeatedType.isPrimitive()) return true;
        if (repeatedType.asGroupType().getFieldCount() > 1) return true;
        String string = repeatedType.getName();
        String string2 = "array";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = repeatedType.getName();
        String string4 = new StringBuilder(6).append(parentName).append("_tuple").toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private static final String typeString$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        return originalType$1 == null ? String.valueOf(typeName$1) : new StringBuilder(3).append(typeName$1).append(" (").append(originalType$1).append(")").toString();
    }

    private static final Nothing$ typeNotSupported$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new AnalysisException(new StringBuilder(28).append("Parquet type not supported: ").append(ParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private static final Nothing$ typeNotImplemented$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new AnalysisException(new StringBuilder(32).append("Parquet type not yet supported: ").append(ParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private static final Nothing$ illegalType$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new AnalysisException(new StringBuilder(22).append("Illegal Parquet type: ").append(ParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private static final DecimalType makeDecimalType$1(int maxPrecision, PrimitiveType field$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        int precision = field$1.getDecimalMetadata().getPrecision();
        int scale = field$1.getDecimalMetadata().getScale();
        ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> maxPrecision == -1 || 1 <= precision && precision <= maxPrecision, new StringBuilder(55).append("Invalid decimal precision: ").append(typeName$1).append(" cannot store ").append(precision).append(" digits (max ").append(maxPrecision).append(")").toString());
        return new DecimalType(precision, scale);
    }

    private static final int makeDecimalType$default$1$1() {
        return -1;
    }

    public static final /* synthetic */ boolean $anonfun$convertPrimitiveField$2(ParquetToSparkSchemaConverter $this) {
        return $this.assumeInt96IsTimestamp;
    }

    public ParquetToSparkSchemaConverter(boolean assumeBinaryIsString, boolean assumeInt96IsTimestamp) {
        this.assumeBinaryIsString = assumeBinaryIsString;
        this.assumeInt96IsTimestamp = assumeInt96IsTimestamp;
    }

    public ParquetToSparkSchemaConverter(SQLConf conf) {
        this(conf.isParquetBinaryAsString(), conf.isParquetINT96AsTimestamp());
    }

    public ParquetToSparkSchemaConverter(Configuration conf) {
        this(new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()))).toBoolean());
    }
}

