/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet.vertica;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.ConversionPatterns;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.execution.datasources.parquet.vertica.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.vertica.SparkToParquetSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001\u0002\b\u0010\u0001\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)1\b\u0001C\u0001y!)1\b\u0001C\u0001\u0003\")1\b\u0001C\u0001\u000f\")\u0001\u000b\u0001C\u0001#\")\u0011\r\u0001C\u0001E\")\u0011\r\u0001C\u0005W\u001e9aoDA\u0001\u0012\u00039ha\u0002\b\u0010\u0003\u0003E\t\u0001\u001f\u0005\u0006w)!\t!\u001f\u0005\bu*\t\n\u0011\"\u0001|\u0011%\tiACI\u0001\n\u0003\tyAA\u000fTa\u0006\u00148\u000eV8QCJ\fX/\u001a;TG\",W.Y\"p]Z,'\u000f^3s\u0015\t\u0001\u0012#A\u0004wKJ$\u0018nY1\u000b\u0005I\u0019\u0012a\u00029beF,X\r\u001e\u0006\u0003)U\t1\u0002Z1uCN|WO]2fg*\u0011acF\u0001\nKb,7-\u001e;j_:T!\u0001G\r\u0002\u0007M\fHN\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g\u0003a9(/\u001b;f\u0019\u0016<\u0017mY=QCJ\fX/\u001a;G_Jl\u0017\r\u001e\t\u0003E%J!AK\u0012\u0003\u000f\t{w\u000e\\3b]\u0006\u0019r.\u001e;qkR$\u0016.\\3ti\u0006l\u0007\u000fV=qKB\u0011Qf\u000e\b\u0003]Qr!a\f\u001a\u000e\u0003AR!!M\f\u0002\u0011%tG/\u001a:oC2L!a\r\u0019\u0002\u000fM\u000bFjQ8oM&\u0011QGN\u0001\u001b!\u0006\u0014\u0018/^3u\u001fV$\b/\u001e;US6,7\u000f^1naRK\b/\u001a\u0006\u0003gAJ!\u0001O\u001d\u0003\u000bY\u000bG.^3\n\u0005i\u001a#aC#ok6,'/\u0019;j_:\fa\u0001P5oSRtDcA\u001f@\u0001B\u0011a\bA\u0007\u0002\u001f!9qe\u0001I\u0001\u0002\u0004A\u0003bB\u0016\u0004!\u0003\u0005\r\u0001\f\u000b\u0003{\tCQa\u0011\u0003A\u0002\u0011\u000bAaY8oMB\u0011q&R\u0005\u0003\rB\u0012qaU)M\u0007>tg\r\u0006\u0002>\u0011\")1)\u0002a\u0001\u0013B\u0011!JT\u0007\u0002\u0017*\u00111\t\u0014\u0006\u0003\u001bn\ta\u0001[1e_>\u0004\u0018BA(L\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u000691m\u001c8wKJ$HC\u0001*Z!\t\u0019v+D\u0001U\u0015\t)f+\u0001\u0004tG\",W.\u0019\u0006\u0003%mI!\u0001\u0017+\u0003\u00175+7o]1hKRK\b/\u001a\u0005\u00065\u001a\u0001\raW\u0001\u000fG\u0006$\u0018\r\\=tiN\u001b\u0007.Z7b!\tav,D\u0001^\u0015\tqv#A\u0003usB,7/\u0003\u0002a;\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0019\r|gN^3si\u001aKW\r\u001c3\u0015\u0005\r4\u0007CA*e\u0013\t)GK\u0001\u0003UsB,\u0007\"B4\b\u0001\u0004A\u0017!\u00024jK2$\u0007C\u0001/j\u0013\tQWLA\u0006TiJ,8\r\u001e$jK2$GcA2m[\")q\r\u0003a\u0001Q\")a\u000e\u0003a\u0001_\u0006Q!/\u001a9fi&$\u0018n\u001c8\u0011\u0005A\u001chBA*r\u0013\t\u0011H+\u0001\u0003UsB,\u0017B\u0001;v\u0005)\u0011V\r]3uSRLwN\u001c\u0006\u0003eR\u000bQd\u00159be.$v\u000eU1scV,GoU2iK6\f7i\u001c8wKJ$XM\u001d\t\u0003})\u0019\"AC\u0011\u0015\u0003]\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nT#\u0001?+\u0005!j8&\u0001@\u0011\u0007}\fI!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003%)hn\u00195fG.,GMC\u0002\u0002\b\r\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY!!\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003#Q#\u0001L?")
public class SparkToParquetSchemaConverter {
    private final boolean writeLegacyParquetFormat;
    private final Enumeration.Value outputTimestampType;

    public static Enumeration.Value $lessinit$greater$default$2() {
        return SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public MessageType convert(StructType catalystSchema) {
        return (MessageType)Types.buildMessage().addFields((Type[])((TraversableOnce)catalystSchema.map((Function1 & Serializable & scala.Serializable)field -> this.convertField((StructField)field), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Type.class))).named(ParquetSchemaConverter$.MODULE$.SPARK_PARQUET_SCHEMA_NAME());
    }

    public Type convertField(StructField field) {
        return this.convertField(field, field.nullable() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Type convertField(StructField field2, Type.Repetition repetition) {
        Option option;
        Option option2;
        Option option3;
        ParquetSchemaConverter$.MODULE$.checkFieldName(field2.name());
        boolean bl = false;
        DecimalType decimalType = null;
        boolean bl2 = false;
        ArrayType arrayType = null;
        boolean bl3 = false;
        MapType mapType = null;
        DataType dataType = field2.dataType();
        if (BooleanType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(field2.name());
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_8).named(field2.name());
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_16).named(field2.name());
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).named(field2.name());
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).named(field2.name());
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(field2.name());
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(field2.name());
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as(OriginalType.UTF8).named(field2.name());
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.DATE).named(field2.name());
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            Type type;
            Enumeration.Value value = this.outputTimestampType;
            Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96, (Type.Repetition)repetition).named(field2.name());
                return type;
            }
            Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(OriginalType.TIMESTAMP_MICROS).named(field2.name());
                return type;
            }
            Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
            Enumeration.Value value7 = value;
            if (value6 == null) {
                if (value7 != null) {
                    throw new MatchError((Object)value);
                }
            } else if (!value6.equals(value7)) throw new MatchError((Object)value);
            type = (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(OriginalType.TIMESTAMP_MILLIS).named(field2.name());
            return type;
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return (Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).named(field2.name());
        }
        if (dataType instanceof DecimalType) {
            bl = true;
            decimalType = (DecimalType)dataType;
            Option option4 = DecimalType.Fixed$.MODULE$.unapply(decimalType);
            if (!option4.isEmpty()) {
                int precision = ((Tuple2)option4.get())._1$mcI$sp();
                int scale = ((Tuple2)option4.get())._2$mcI$sp();
                if (this.writeLegacyParquetFormat) {
                    return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as(OriginalType.DECIMAL)).precision(precision).scale(scale).length(Decimal$.MODULE$.minBytesForPrecision()[precision]).named(field2.name());
                }
            }
        }
        if (bl && !(option3 = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option3.get())._1$mcI$sp();
            int scale = ((Tuple2)option3.get())._2$mcI$sp();
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS() && !this.writeLegacyParquetFormat) {
                return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.DECIMAL)).precision(precision).scale(scale).named(field2.name());
            }
        }
        if (bl && !(option2 = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option2.get())._1$mcI$sp();
            int scale = ((Tuple2)option2.get())._2$mcI$sp();
            if (precision <= Decimal$.MODULE$.MAX_LONG_DIGITS() && !this.writeLegacyParquetFormat) {
                return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(OriginalType.DECIMAL)).precision(precision).scale(scale).named(field2.name());
            }
        }
        if (bl && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            if (!this.writeLegacyParquetFormat) {
                return (Type)((Types.BasePrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, (Type.Repetition)repetition).as(OriginalType.DECIMAL)).precision(precision).scale(scale).length(Decimal$.MODULE$.minBytesForPrecision()[precision]).named(field2.name());
            }
        }
        if (dataType instanceof ArrayType) {
            bl2 = true;
            arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean bl4 = arrayType.containsNull();
            if (bl4 && this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as(OriginalType.LIST)).addField((Type)Types.buildGroup((Type.Repetition)Type.Repetition.REPEATED).addField(this.convertField(new StructField("array", elementType, true, StructField$.MODULE$.apply$default$4()))).named("bag")).named(field2.name());
            }
        }
        if (bl2) {
            DataType elementType = arrayType.elementType();
            boolean bl5 = arrayType.containsNull();
            if (!bl5 && this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as(OriginalType.LIST)).addField(this.convertField(new StructField("array", elementType, false, StructField$.MODULE$.apply$default$4()), Type.Repetition.REPEATED)).named(field2.name());
            }
        }
        if (dataType instanceof MapType) {
            bl3 = true;
            mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            if (this.writeLegacyParquetFormat) {
                return ConversionPatterns.mapType((Type.Repetition)repetition, (String)field2.name(), (Type)this.convertField(new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4())), (Type)this.convertField(new StructField("value", valueType, valueContainsNull, StructField$.MODULE$.apply$default$4())));
            }
        }
        if (bl2) {
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            if (!this.writeLegacyParquetFormat) {
                return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as(OriginalType.LIST)).addField((Type)Types.repeatedGroup().addField(this.convertField(new StructField("element", elementType, containsNull, StructField$.MODULE$.apply$default$4()))).named("list")).named(field2.name());
            }
        }
        if (bl3) {
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            return (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)repetition).as(OriginalType.MAP)).addField((Type)Types.repeatedGroup().addField(this.convertField(new StructField("key", keyType, false, StructField$.MODULE$.apply$default$4()))).addField(this.convertField(new StructField("value", valueType, valueContainsNull, StructField$.MODULE$.apply$default$4()))).named("key_value")).named(field2.name());
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            return (Type)((Types.Builder)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).foldLeft((Object)Types.buildGroup((Type.Repetition)repetition), (Function2 & Serializable & scala.Serializable)(builder, field) -> (Types.GroupBuilder)builder.addField(this.convertField((StructField)field)))).named(field2.name());
        }
        if (!(dataType instanceof UserDefinedType)) throw new AnalysisException(new StringBuilder(22).append("Unsupported data type ").append(field2.dataType().catalogString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        UserDefinedType userDefinedType = (UserDefinedType)dataType;
        DataType x$1 = userDefinedType.sqlType();
        String x$2 = field2.copy$default$1();
        boolean x$3 = field2.copy$default$3();
        Metadata x$4 = field2.copy$default$4();
        return this.convertField(field2.copy(x$2, x$1, x$3, x$4));
    }

    public SparkToParquetSchemaConverter(boolean writeLegacyParquetFormat, Enumeration.Value outputTimestampType) {
        this.writeLegacyParquetFormat = writeLegacyParquetFormat;
        this.outputTimestampType = outputTimestampType;
    }

    public SparkToParquetSchemaConverter(SQLConf conf) {
        this(conf.writeLegacyParquetFormat(), conf.parquetOutputTimestampType());
    }

    public SparkToParquetSchemaConverter(Configuration conf) {
        this(new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))).toBoolean(), SQLConf.ParquetOutputTimestampType$.MODULE$.withName(conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key())));
    }
}

