/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.fs;

import cats.Applicative;
import cats.implicits$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.AWSArg;
import com.vertica.spark.config.AWSAuth;
import com.vertica.spark.config.AWSOptions;
import com.vertica.spark.config.FileStoreConfig;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.datasource.core.DataBlock;
import com.vertica.spark.datasource.core.ParquetFileRange;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.fs.HadoopFileStoreReader;
import com.vertica.spark.datasource.fs.ParquetFileMetadata;
import com.vertica.spark.util.error.CloseWriteError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.CreateDirectoryAlreadyExistsError;
import com.vertica.spark.util.error.CreateDirectoryError;
import com.vertica.spark.util.error.CreateFileAlreadyExistsError;
import com.vertica.spark.util.error.CreateFileError;
import com.vertica.spark.util.error.FileListError;
import com.vertica.spark.util.error.FileStoreThrownError;
import com.vertica.spark.util.error.IntermediaryStoreReaderNotInitializedError;
import com.vertica.spark.util.error.IntermediaryStoreWriteError;
import com.vertica.spark.util.error.IntermediaryStoreWriterNotInitializedError;
import com.vertica.spark.util.error.MissingHDFSImpersonationTokenError;
import com.vertica.spark.util.error.OpenReadError;
import com.vertica.spark.util.error.OpenWriteError;
import com.vertica.spark.util.error.RemoveDirectoryError;
import com.vertica.spark.util.error.RemoveFileError;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.vertica.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.vertica.ParquetReadSupport$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r}a\u0001B\u001e=\u0001\u001dC\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t3\u0002\u0011\t\u0011)A\u00055\")!\u000e\u0001C\u0001W\"9q\u000e\u0001b\u0001\n\u0013\u0001\bB\u0002?\u0001A\u0003%\u0011\u000fC\u0004~\u0001\t\u0007I\u0011\u00029\t\ry\u0004\u0001\u0015!\u0003r\u0011\u001dy\bA1A\u0005\nADq!!\u0001\u0001A\u0003%\u0011\u000f\u0003\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0003q\u0011\u001d\t)\u0001\u0001Q\u0001\nED\u0001\"a\u0002\u0001\u0005\u0004%I\u0001\u001d\u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003r\u0011!\tY\u0001\u0001b\u0001\n\u0013\u0001\bbBA\u0007\u0001\u0001\u0006I!\u001d\u0005\n\u0003\u001f\u0001!\u0019!C\u0001\u0003#A\u0001\"a\t\u0001A\u0003%\u00111\u0003\u0005\n\u0003K\u0001!\u0019!C\u0005\u0003OA\u0001\"!\u000f\u0001A\u0003%\u0011\u0011\u0006\u0005\n\u0003w\u0001!\u0019!C\u0005\u0003OA\u0001\"!\u0010\u0001A\u0003%\u0011\u0011\u0006\u0005\n\u0003\u007f\u0001!\u0019!C\u0005\u0003OA\u0001\"!\u0011\u0001A\u0003%\u0011\u0011\u0006\u0005\n\u0003\u0007\u0002\u0001\u0019!C\u0005\u0003\u000bB\u0011\"a\u0019\u0001\u0001\u0004%I!!\u001a\t\u0011\u0005E\u0004\u0001)Q\u0005\u0003\u000fB\u0011\"a\u001d\u0001\u0001\u0004%I!!\u001e\t\u0013\u0005}\u0004\u00011A\u0005\n\u0005\u0005\u0005\u0002CAC\u0001\u0001\u0006K!a\u001e\t\u0013\u0005\u001d\u0005A1A\u0005\u0002\u0005%\u0005\u0002CAL\u0001\u0001\u0006I!a#\t\u0013\u0005e\u0005A1A\u0005\n\u0005m\u0005\u0002CAR\u0001\u0001\u0006I!!(\t\u0013\u0005\u0015\u0006A1A\u0005\n\u0005\u001d\u0006\u0002CAY\u0001\u0001\u0006I!!+\u0007\r\u0005M\u0006\u0001BA[\u0011)\tI\r\nB\u0001B\u0003%\u00111\u001a\u0005\u0007U\u0012\"\t!!6\t\u000f\u0005eG\u0005\"\u0015\u0002\\\"9\u0011Q\u001c\u0013\u0005\u0012\u0005}\u0007bBA{\u0001\u0011\u0005\u0011q\u001f\u0005\b\u0005O\u0001A\u0011\tB\u0015\u0011\u001d\u0011Y\u0004\u0001C!\u0005{AqAa\u0010\u0001\t\u0013\u0011\t\u0005C\u0004\u0003|\u0001!\tE! \t\u000f\t%\u0005\u0001\"\u0011\u0003\f\"9!Q\u0013\u0001\u0005B\t]\u0005b\u0002BS\u0001\u0011\u0005#Q\b\u0005\b\u0005O\u0003A\u0011\tBU\u0011\u001d\u0011\t\r\u0001C!\u0005\u0007DqAa2\u0001\t\u0003\u0012I\rC\u0004\u0003N\u0002!\tEa4\t\u000f\tM\u0007\u0001\"\u0011\u0003V\"9!Q\u001c\u0001\u0005\u0002\t}\u0007b\u0002Bv\u0001\u0011\u0005#Q\u001e\u0005\b\u0005k\u0004A\u0011\tB|\u0011\u001d\u0011i\u0010\u0001C!\u00037CqAa@\u0001\t\u0013\u0019\tA\u0001\u000bIC\u0012|w\u000e\u001d$jY\u0016\u001cFo\u001c:f\u0019\u0006LXM\u001d\u0006\u0003{y\n!AZ:\u000b\u0005}\u0002\u0015A\u00033bi\u0006\u001cx.\u001e:dK*\u0011\u0011IQ\u0001\u0006gB\f'o\u001b\u0006\u0003\u0007\u0012\u000bqA^3si&\u001c\u0017MC\u0001F\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0001J\u0014\t\u0003\u00132k\u0011A\u0013\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJ\u0013\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0003V\"\u0001\u001f\n\u0005Ec$a\u0006$jY\u0016\u001cFo\u001c:f\u0019\u0006LXM]%oi\u0016\u0014h-Y2f\u0003=1\u0017\u000e\\3Ti>\u0014XmQ8oM&<\u0007C\u0001+X\u001b\u0005)&B\u0001,A\u0003\u0019\u0019wN\u001c4jO&\u0011\u0001,\u0016\u0002\u0010\r&dWm\u0015;pe\u0016\u001cuN\u001c4jO\u000611o\u00195f[\u0006\u00042!S.^\u0013\ta&J\u0001\u0004PaRLwN\u001c\t\u0003=\"l\u0011a\u0018\u0006\u0003A\u0006\fQ\u0001^=qKNT!AY2\u0002\u0007M\fHN\u0003\u0002BI*\u0011QMZ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\f1a\u001c:h\u0013\tIwL\u0001\u0006TiJ,8\r\u001e+za\u0016\fa\u0001P5oSRtDc\u00017n]B\u0011q\n\u0001\u0005\u0006%\u000e\u0001\ra\u0015\u0005\u00063\u000e\u0001\rAW\u0001\u000e'Nz\u0016iQ\"F'N{6*R-\u0016\u0003E\u0004\"A]=\u000f\u0005M<\bC\u0001;K\u001b\u0005)(B\u0001<G\u0003\u0019a$o\\8u}%\u0011\u0001PS\u0001\u0007!J,G-\u001a4\n\u0005i\\(AB*ue&twM\u0003\u0002y\u0015\u0006q1kM0B\u0007\u000e+5kU0L\u000bf\u0003\u0013!D*4?N+5IU#U?.+\u0015,\u0001\bTg}\u001bVi\u0011*F)~[U)\u0017\u0011\u0002!M\u001btlU#T'&{ej\u0018+P\u0017\u0016s\u0015!E*4?N+5kU%P\u001d~#vjS#OA\u0005A\u0012iV*`\u0007J+E)\u0012(U\u0013\u0006c5k\u0018)S\u001fZKE)\u0012*\u00023\u0005;6kX\"S\u000b\u0012+e\nV%B\u0019N{\u0006KU(W\u0013\u0012+%\u000bI\u0001\f'NzVI\u0014#Q\u001f&sE+\u0001\u0007Tg}+e\n\u0012)P\u0013:#\u0006%A\u0007Tg}+e*\u0011\"M\u000b~\u001b6\u000bT\u0001\u000f'NzVIT!C\u0019\u0016{6k\u0015'!\u0003\u0019awnZ4feV\u0011\u00111\u0003\t\u0005\u0003+\ty\"\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u00031\u00198-\u00197bY><w-\u001b8h\u0015\r\ti\u0002R\u0001\tif\u0004Xm]1gK&!\u0011\u0011EA\f\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013!H,F\u0005\"#eiU0E\u000b2+u)\u0011+J\u001f:{FkT&F\u001d~#V\t\u0017+\u0016\u0005\u0005%\u0002\u0003BA\u0016\u0003ki!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\u0003S>T1!a\re\u0003\u0019A\u0017\rZ8pa&!\u0011qGA\u0017\u0005\u0011!V\r\u001f;\u0002=]+%\t\u0013#G'~#U\tT#H\u0003RKuJT0U\u001f.+ej\u0018+F1R\u0003\u0013AH*X\u000b\nCEIR*`\t\u0016cUiR!U\u0013>su\fV(L\u000b:{F+\u0012-U\u0003}\u0019v+\u0012\"I\t\u001a\u001bv\fR#M\u000b\u001e\u000bE+S(O?R{5*\u0012(`)\u0016CF\u000bI\u0001\u001b\u0011\u001235k\u0018#F\u0019\u0016;\u0015\tV%P\u001d~#vjS#O?R+\u0005\fV\u0001\u001c\u0011\u001235k\u0018#F\u0019\u0016;\u0015\tV%P\u001d~#vjS#O?R+\u0005\f\u0016\u0011\u0002\r]\u0014\u0018\u000e^3s+\t\t9\u0005\u0005\u0003J7\u0006%\u0003CBA&\u0003'\n9&\u0004\u0002\u0002N)!\u00111GA(\u0015\r\t\t\u0006Z\u0001\ba\u0006\u0014\u0018/^3u\u0013\u0011\t)&!\u0014\u0003\u001bA\u000b'/];fi^\u0013\u0018\u000e^3s!\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/C\u0006A1-\u0019;bYf\u001cH/\u0003\u0003\u0002b\u0005m#aC%oi\u0016\u0014h.\u00197S_^\f!b\u001e:ji\u0016\u0014x\fJ3r)\u0011\t9'!\u001c\u0011\u0007%\u000bI'C\u0002\u0002l)\u0013A!\u00168ji\"I\u0011qN\r\u0002\u0002\u0003\u0007\u0011qI\u0001\u0004q\u0012\n\u0014aB<sSR,'\u000fI\u0001\u0007e\u0016\fG-\u001a:\u0016\u0005\u0005]\u0004\u0003B%\\\u0003s\u00022aTA>\u0013\r\ti\b\u0010\u0002\u0016\u0011\u0006$wn\u001c9GS2,7\u000b^8sKJ+\u0017\rZ3s\u0003)\u0011X-\u00193fe~#S-\u001d\u000b\u0005\u0003O\n\u0019\tC\u0005\u0002pq\t\t\u00111\u0001\u0002x\u00059!/Z1eKJ\u0004\u0013A\u00035eMN\u001cuN\u001c4jOV\u0011\u00111\u0012\t\u0005\u0003\u001b\u000b\u0019*\u0004\u0002\u0002\u0010*!\u0011\u0011SA\u0019\u0003\u0011\u0019wN\u001c4\n\t\u0005U\u0015q\u0012\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0017!$gm]\"p]\u001aLw\rI\u0001\u000bC^\u001cx\n\u001d;j_:\u001cXCAAO!\r!\u0016qT\u0005\u0004\u0003C+&AC!X'>\u0003H/[8og\u0006Y\u0011m^:PaRLwN\\:!\u0003\u001d\two]!vi\",\"!!+\u0011\t%[\u00161\u0016\t\u0004)\u00065\u0016bAAX+\n9\u0011iV*BkRD\u0017\u0001C1xg\u0006+H\u000f\u001b\u0011\u0003+Y+'\u000f^5dCB\u000b'/];fi\n+\u0018\u000e\u001c3feN\u0019A%a.\u0011\u0011\u0005e\u0016qXA,\u0003\u000btA!a\u0013\u0002<&!\u0011QXA'\u00035\u0001\u0016M]9vKR<&/\u001b;fe&!\u0011\u0011YAb\u0005\u001d\u0011U/\u001b7eKJTA!!0\u0002NA\u0019\u0011q\u0019\u0013\u000e\u0003\u0001\tAAZ5mKB!\u0011QZAi\u001b\t\tyMC\u0002>\u0003cIA!a5\u0002P\n!\u0001+\u0019;i)\u0011\t)-a6\t\u000f\u0005%g\u00051\u0001\u0002L\u0006!1/\u001a7g)\t\t)-A\bhKR<&/\u001b;f'V\u0004\bo\u001c:u)\u0011\t\t/a=\u0011\t\u0005\r\u0018q^\u0007\u0003\u0003KTA!!\u0015\u0002h*!\u0011\u0011^Av\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0007\u00055\u0018-A\u0005fq\u0016\u001cW\u000f^5p]&!\u0011\u0011_As\u0005M\u0001\u0016M]9vKR<&/\u001b;f'V\u0004\bo\u001c:u\u0011\u001d\t\t\n\u000ba\u0001\u0003\u0017\u000bAc\u001c9f]^\u0013\u0018\u000e^3QCJ\fX/\u001a;GS2,G\u0003BA}\u0005G\u0001b!a?\u0003\u001e\u0005\u001dd\u0002BA\u007f\u0005/qA!a@\u0003\u00129!!\u0011\u0001B\u0007\u001d\u0011\u0011\u0019Aa\u0003\u000f\t\t\u0015!\u0011\u0002\b\u0004i\n\u001d\u0011\"A#\n\u0005\r#\u0015BA!C\u0013\r\u0011y\u0001Q\u0001\u0005kRLG.\u0003\u0003\u0003\u0014\tU\u0011!B3se>\u0014(b\u0001B\b\u0001&!!\u0011\u0004B\u000e\u00035)%O]8s\u0011\u0006tG\r\\5oO*!!1\u0003B\u000b\u0013\u0011\u0011yB!\t\u0003\u001f\r{gN\\3di>\u0014(+Z:vYRTAA!\u0007\u0003\u001c!1!QE\u0015A\u0002E\f\u0001BZ5mK:\fW.Z\u0001\u0017oJLG/\u001a#bi\u0006$v\u000eU1scV,GOR5mKR!\u0011\u0011 B\u0016\u0011\u001d\u0011iC\u000ba\u0001\u0005_\t\u0011\u0002Z1uC\ncwnY6\u0011\t\tE\"qG\u0007\u0003\u0005gQ1A!\u000e?\u0003\u0011\u0019wN]3\n\t\te\"1\u0007\u0002\n\t\u0006$\u0018M\u00117pG.\fQc\u00197pg\u0016<&/\u001b;f!\u0006\u0014\u0018/^3u\r&dW\r\u0006\u0002\u0002z\u0006iAo\\*fi6+H\u000e^5NCB,bAa\u0011\u0003X\tED\u0003\u0002B#\u0005k\u0002\u0002Ba\u0012\u0003P\tM#\u0011N\u0007\u0003\u0005\u0013RAAa\u0004\u0003L)\u0011!QJ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003R\t%#aA'baB!!Q\u000bB,\u0019\u0001!qA!\u0017-\u0005\u0004\u0011YFA\u0001L#\u0011\u0011iFa\u0019\u0011\u0007%\u0013y&C\u0002\u0003b)\u0013qAT8uQ&tw\rE\u0002J\u0005KJ1Aa\u001aK\u0005\r\te.\u001f\t\u0007\u0005\u000f\u0012YGa\u001c\n\t\t5$\u0011\n\u0002\u0004'\u0016$\b\u0003\u0002B+\u0005c\"qAa\u001d-\u0005\u0004\u0011YFA\u0001W\u0011\u001d\u00119\b\fa\u0001\u0005s\n1!\\1q!!\u00119Ea\u0014\u0003T\t=\u0014AF4fiB\u000b'/];fi\u001aKG.Z'fi\u0006$\u0017\r^1\u0015\t\t}$q\u0011\t\u0007\u0003w\u0014iB!!\u0011\u0007=\u0013\u0019)C\u0002\u0003\u0006r\u00121\u0003U1scV,GOR5mK6+G/\u00193bi\u0006DaA!\n.\u0001\u0004\t\u0018aE8qK:\u0014V-\u00193QCJ\fX/\u001a;GS2,G\u0003BA}\u0005\u001bCq!!3/\u0001\u0004\u0011y\t\u0005\u0003\u00032\tE\u0015\u0002\u0002BJ\u0005g\u0011\u0001\u0003U1scV,GOR5mKJ\u000bgnZ3\u0002/I,\u0017\r\u001a#bi\u00064%o\\7QCJ\fX/\u001a;GS2,G\u0003\u0002BM\u00057\u0003b!a?\u0003\u001e\t=\u0002b\u0002BO_\u0001\u0007!qT\u0001\nE2|7m[*ju\u0016\u00042!\u0013BQ\u0013\r\u0011\u0019K\u0013\u0002\u0004\u0013:$\u0018\u0001F2m_N,'+Z1e!\u0006\u0014\u0018/^3u\r&dW-A\u0006hKR4\u0015\u000e\\3MSN$H\u0003\u0002BV\u0005\u007f\u0003b!a?\u0003\u001e\t5\u0006#\u0002BX\u0005s\u000bh\u0002\u0002BY\u0005ks1\u0001\u001eBZ\u0013\u0005Y\u0015b\u0001B\\\u0015\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B^\u0005{\u00131aU3r\u0015\r\u00119L\u0013\u0005\u0007\u0005K\t\u0004\u0019A9\u0002\u0015I,Wn\u001c<f\r&dW\r\u0006\u0003\u0002z\n\u0015\u0007B\u0002B\u0013e\u0001\u0007\u0011/A\u0005sK6|g/\u001a#jeR!\u0011\u0011 Bf\u0011\u0019\u0011)c\ra\u0001c\u0006Q1M]3bi\u00164\u0015\u000e\\3\u0015\t\u0005e(\u0011\u001b\u0005\u0007\u0005K!\u0004\u0019A9\u0002\u0013\r\u0014X-\u0019;f\t&\u0014HCBA}\u0005/\u0014I\u000e\u0003\u0004\u0003&U\u0002\r!\u001d\u0005\u0007\u00057,\u0004\u0019A9\u0002\u0015A,'/\\5tg&|g.\u0001\u0006gS2,W\t_5tiN$BA!9\u0003jB1\u00111 B\u000f\u0005G\u00042!\u0013Bs\u0013\r\u00119O\u0013\u0002\b\u0005>|G.Z1o\u0011\u0019\u0011)C\u000ea\u0001c\u0006)r-\u001a;J[B,'o]8oCRLwN\u001c+pW\u0016tG\u0003\u0002Bx\u0005c\u0004R!a?\u0003\u001eEDaAa=8\u0001\u0004\t\u0018\u0001B;tKJ\fQbZ3u\u000f2|'m\u0015;biV\u001cH\u0003\u0002BV\u0005sDaAa?9\u0001\u0004\t\u0018a\u00029biR,'O\\\u0001\u000eO\u0016$\u0018iV*PaRLwN\\:\u0002\u001bU\u001cXMR5mKNK8\u000f^3n+\u0011\u0019\u0019a!\u0003\u0015\r\r\u00151QBB\b!\u0019\tYP!\b\u0004\bA!!QKB\u0005\t\u001d\u0019YA\u000fb\u0001\u00057\u0012\u0011\u0001\u0016\u0005\u0007\u0005KQ\u0004\u0019A9\t\u000f\rE!\b1\u0001\u0004\u0014\u0005Aam]!di&|g\u000eE\u0005J\u0007+\u0019I\"a3\u0004\u0006%\u00191q\u0003&\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003BAg\u00077IAa!\b\u0002P\nQa)\u001b7f'f\u001cH/Z7")
public class HadoopFileStoreLayer
implements FileStoreLayerInterface {
    private final FileStoreConfig fileStoreConfig;
    private final String S3_ACCESS_KEY;
    private final String S3_SECRET_KEY;
    private final String S3_SESSION_TOKEN;
    private final String AWS_CREDENTIALS_PROVIDER;
    private final String S3_ENDPOINT;
    private final String S3_ENABLE_SSL;
    private final Logger logger;
    private final Text WEBHDFS_DELEGATION_TOKEN_TEXT;
    private final Text SWEBHDFS_DELEGATION_TOKEN_TEXT;
    private final Text HDFS_DELEGATION_TOKEN_TEXT;
    private Option<ParquetWriter<InternalRow>> writer;
    private Option<HadoopFileStoreReader> reader;
    private final Configuration hdfsConfig;
    private final AWSOptions awsOptions;
    private final Option<AWSAuth> awsAuth;

    private String S3_ACCESS_KEY() {
        return this.S3_ACCESS_KEY;
    }

    private String S3_SECRET_KEY() {
        return this.S3_SECRET_KEY;
    }

    private String S3_SESSION_TOKEN() {
        return this.S3_SESSION_TOKEN;
    }

    private String AWS_CREDENTIALS_PROVIDER() {
        return this.AWS_CREDENTIALS_PROVIDER;
    }

    private String S3_ENDPOINT() {
        return this.S3_ENDPOINT;
    }

    private String S3_ENABLE_SSL() {
        return this.S3_ENABLE_SSL;
    }

    public Logger logger() {
        return this.logger;
    }

    private Text WEBHDFS_DELEGATION_TOKEN_TEXT() {
        return this.WEBHDFS_DELEGATION_TOKEN_TEXT;
    }

    private Text SWEBHDFS_DELEGATION_TOKEN_TEXT() {
        return this.SWEBHDFS_DELEGATION_TOKEN_TEXT;
    }

    private Text HDFS_DELEGATION_TOKEN_TEXT() {
        return this.HDFS_DELEGATION_TOKEN_TEXT;
    }

    private Option<ParquetWriter<InternalRow>> writer() {
        return this.writer;
    }

    private void writer_$eq(Option<ParquetWriter<InternalRow>> x$1) {
        this.writer = x$1;
    }

    private Option<HadoopFileStoreReader> reader() {
        return this.reader;
    }

    private void reader_$eq(Option<HadoopFileStoreReader> x$1) {
        this.reader = x$1;
    }

    public Configuration hdfsConfig() {
        return this.hdfsConfig;
    }

    private AWSOptions awsOptions() {
        return this.awsOptions;
    }

    private Option<AWSAuth> awsAuth() {
        return this.awsAuth;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> openWriteParquetFile(String filename) {
        Left left;
        Either writerOrError;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(23).append("Opening write to file: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        VerticaParquetBuilder builder = new VerticaParquetBuilder(new Path(String.valueOf(filename)));
        Either either = writerOrError = this.removeFile(filename).flatMap((Function1 & Serializable & scala.Serializable)_ -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> builder.withConf(this.hdfsConfig()).withWriteMode(ParquetFileWriter.Mode.OVERWRITE).withCompressionCodec(CompressionCodecName.SNAPPY).build()).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new OpenWriteError((Throwable)exception).context("Error opening write to HDFS.")).map((Function1 & Serializable & scala.Serializable)writer -> writer));
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            ParquetWriter writer = (ParquetWriter)right.value();
            this.writer_$eq((Option<ParquetWriter<InternalRow>>)new Some((Object)writer));
            left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> writeDataToParquetFile(DataBlock dataBlock) {
        Right right;
        Option<ParquetWriter<InternalRow>> option = this.writer();
        if (option instanceof Some) {
            Some some = (Some)option;
            ParquetWriter reader = (ParquetWriter)some.value();
            right = package$.MODULE$.Right().apply((Object)reader);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreWriterNotInitializedError().context("Error writing parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return right.flatMap((Function1 & Serializable & scala.Serializable)writer -> ((Either)implicits$.MODULE$.toTraverseOps(dataBlock.data(), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)record -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writer.write(record)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new IntermediaryStoreWriteError((Throwable)exception).context("Error writing parquet file to HDFS.")), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable & scala.Serializable)_ -> {
            HadoopFileStoreLayer.$anonfun$writeDataToParquetFile$5(_);
            return BoxedUnit.UNIT;
        }));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> closeWriteParquetFile() {
        Right right;
        Option<ParquetWriter<InternalRow>> option = this.writer();
        if (option instanceof Some) {
            Some some = (Some)option;
            ParquetWriter reader = (ParquetWriter)some.value();
            right = package$.MODULE$.Right().apply((Object)reader);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreWriterNotInitializedError().context("Error closing write of parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return right.flatMap((Function1 & Serializable & scala.Serializable)writer -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writer.close()).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new CloseWriteError((Throwable)exception).context("Error closing write of parquet file to HDFS.")).map((Function1 & Serializable & scala.Serializable)_ -> {
            HadoopFileStoreLayer.$anonfun$closeWriteParquetFile$4(_);
            return BoxedUnit.UNIT;
        }));
    }

    private <K, V> Map<K, Set<V>> toSetMultiMap(Map<K, V> map) {
        HashMap setMultiMap = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(map.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> setMultiMap.put(entry.getKey(), Collections.singleton(entry.getValue())));
        return Collections.unmodifiableMap(setMultiMap);
    }

    @Override
    public Either<ConnectorError, ParquetFileMetadata> getParquetFileMetadata(String filename) {
        Path path = new Path(String.valueOf(filename));
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)path, (Configuration)this.hdfsConfig());
            ParquetFileReader reader = ParquetFileReader.open((InputFile)inputFile);
            int rowGroupCount = reader.getRowGroups().size();
            reader.close();
            return new ParquetFileMetadata(filename, rowGroupCount);
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new FileListError((Throwable)exception).context(new StringBuilder(33).append("Error getting metadata for file ").append(filename).append(".").toString()));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> openReadParquetFile(ParquetFileRange file) {
        Left left;
        Either readerOrError;
        BoxedUnit boxedUnit;
        String filename = file.filename();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(24).append("Opening read from file: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ParquetReadSupport readSupport = new ParquetReadSupport((Option<ZoneId>)None$.MODULE$, false, SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED(), SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED());
        Either either = readerOrError = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Path path = new Path(String.valueOf(filename));
            HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)path, (Configuration)this.hdfsConfig());
            ParquetFileReader fileReader = ParquetFileReader.open((InputFile)inputFile);
            FileMetaData parquetFileMetadata = fileReader.getFooter().getFileMetaData();
            MessageType fileSchema = parquetFileMetadata.getSchema();
            Map fileMetadata = parquetFileMetadata.getKeyValueMetaData();
            ReadSupport.ReadContext readContext = readSupport.init(new InitContext(this.hdfsConfig(), this.toSetMultiMap(fileMetadata), fileSchema));
            RecordMaterializer<InternalRow> recordConverter = readSupport.prepareForRead(this.hdfsConfig(), fileMetadata, fileSchema, readContext);
            MessageType requestedSchema = readContext.getRequestedSchema();
            fileReader.setRequestedSchema(requestedSchema);
            ColumnIOFactory columnIOFactory = new ColumnIOFactory(parquetFileMetadata.getCreatedBy());
            boolean strictTypeChecking = false;
            MessageColumnIO columnIO = columnIOFactory.getColumnIO(requestedSchema, fileSchema, strictTypeChecking);
            return new HadoopFileStoreReader(fileReader, columnIO, recordConverter, file);
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new OpenReadError((Throwable)exception).context("Error creating Parquet Reader"));
        if (either instanceof Right) {
            Right right = (Right)either;
            HadoopFileStoreReader reader = (HadoopFileStoreReader)right.value();
            this.reader_$eq((Option<HadoopFileStoreReader>)new Some((Object)reader));
            left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, DataBlock> readDataFromParquetFile(int blockSize) {
        Right right;
        Option<HadoopFileStoreReader> option = this.reader();
        if (option instanceof Some) {
            Some some = (Some)option;
            HadoopFileStoreReader reader2 = (HadoopFileStoreReader)some.value();
            right = package$.MODULE$.Right().apply((Object)reader2);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreReaderNotInitializedError().context("Error reading parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return right.flatMap((Function1 & Serializable & scala.Serializable)reader -> reader.read(blockSize).map((Function1 & Serializable & scala.Serializable)dataBlock -> dataBlock)).map((Function1 & Serializable & scala.Serializable)dataBlock -> dataBlock);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Either<ConnectorError, BoxedUnit> closeReadParquetFile() {
        void var2_5;
        Right right;
        Option<HadoopFileStoreReader> option = this.reader();
        if (option instanceof Some) {
            Some some = (Some)option;
            HadoopFileStoreReader reader2 = (HadoopFileStoreReader)some.value();
            right = package$.MODULE$.Right().apply((Object)reader2);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreReaderNotInitializedError().context("Error closing read of parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        Either r = right.flatMap((Function1 & Serializable & scala.Serializable)reader -> reader.close().map((Function1 & Serializable & scala.Serializable)_ -> {
            HadoopFileStoreLayer.$anonfun$closeReadParquetFile$2(_);
            return BoxedUnit.UNIT;
        }));
        this.reader_$eq((Option<HadoopFileStoreReader>)None$.MODULE$);
        return var2_5;
    }

    @Override
    public Either<ConnectorError, Seq<String>> getFileList(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> {
            Left left;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> fs.listStatus(path));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                FileStatus[] fileStatuses = (FileStatus[])success.value();
                left = package$.MODULE$.Right().apply((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatuses)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                left = package$.MODULE$.Left().apply((Object)new FileListError(exception).context("Error getting file list from HDFS."));
            } else {
                throw new MatchError((Object)try_);
            }
            return left;
        });
    }

    @Override
    public Either<ConnectorError, BoxedUnit> removeFile(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> fs.exists(path) ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.delete(path, true)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new RemoveFileError((Path)path, (Throwable)exception).context("Error removing HDFS file.")) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> removeDir(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> fs.exists(path) ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.delete(path, true)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new RemoveDirectoryError((Path)path, (Throwable)exception).context("Error removing HDFS directory.")) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createFile(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> !fs.exists(path) ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FSDataOutputStream stream = fs.create(path);
            stream.write(0);
            stream.close();
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new CreateFileError((Path)path, (Throwable)exception).context("Error creating HDFS file.")) : package$.MODULE$.Left().apply((Object)new CreateFileAlreadyExistsError(filename)));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createDir(String filename, String permission) {
        FsPermission perms = new FsPermission(permission);
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> {
            Left left;
            if (!fs.exists(path)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(31).append("Making path ").append(path).append(" with permissions: ").append(perms.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                left = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.mkdirs(path, perms)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new CreateDirectoryError((Path)path, (Throwable)exception).context("Error creating HDFS directory."));
            } else {
                left = package$.MODULE$.Left().apply((Object)new CreateDirectoryAlreadyExistsError(filename));
            }
            return left;
        });
    }

    @Override
    public Either<ConnectorError, Object> fileExists(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)fs.exists(path))));
    }

    @Override
    public Either<ConnectorError, String> getImpersonationToken(String user) {
        Right right;
        ObjectRef hdfsToken = ObjectRef.create((Object)None$.MODULE$);
        Option ugiUser = Option$.MODULE$.apply((Object)UserGroupInformation.getLoginUser());
        Option option = ugiUser;
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            UserGroupInformation user2 = (UserGroupInformation)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Got UGI user.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Collection existingTokens = user2.getCredentials().getAllTokens();
            for (Token token : existingTokens) {
                BoxedUnit boxedUnit2;
                Text tokenKind = token.getKind();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(21).append("Existing token kind: ").append(tokenKind.toString()).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (!this.WEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.SWEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.HDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind)) continue;
                hdfsToken.elem = new Some((Object)token.encodeToUrlString());
            }
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        this.useFileSystem(this.fileStoreConfig.address(), (Function2 & Serializable & scala.Serializable)(fs, x$3) -> {
            Token[] tokens = fs.addDelegationTokens(user, null);
            for (Token token : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens))) {
                BoxedUnit boxedUnit;
                Text tokenKind = token.getKind();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(31).append("Hadoop impersonation: IT kind: ").append(tokenKind.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (!this.WEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.SWEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.HDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind)) continue;
                hdfsToken$1.elem = new Some((Object)token.encodeToUrlString());
            }
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        });
        Option option2 = (Option)hdfsToken.elem;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String token = (String)some.value();
            right = package$.MODULE$.Right().apply((Object)token);
        } else if (None$.MODULE$.equals(option2)) {
            right = package$.MODULE$.Left().apply((Object)new MissingHDFSImpersonationTokenError(user, this.fileStoreConfig.address()));
        } else {
            throw new MatchError((Object)option2);
        }
        return right;
    }

    @Override
    public Either<ConnectorError, Seq<String>> getGlobStatus(String pattern) {
        return this.useFileSystem(pattern, (Function2 & Serializable & scala.Serializable)(fs, path) -> {
            Left left;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> fs.globStatus(path));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                FileStatus[] fileStatuses = (FileStatus[])success.value();
                left = package$.MODULE$.Right().apply((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatuses)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                left = package$.MODULE$.Left().apply((Object)new FileListError(exception).context("Error getting file list from HDFS."));
            } else {
                throw new MatchError((Object)try_);
            }
            return left;
        });
    }

    @Override
    public AWSOptions getAWSOptions() {
        return this.fileStoreConfig.awsOptions();
    }

    private <T> Either<ConnectorError, T> useFileSystem(String filename, Function2<FileSystem, Path, Either<ConnectorError, T>> fsAction) {
        Either either;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(16).append("Filestore path: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Path path = new Path(String.valueOf(filename));
            FileSystem fs = path.getFileSystem(this.hdfsConfig());
            return (Either)fsAction.apply((Object)fs, (Object)path);
        });
        if (try_ instanceof Success) {
            Either value;
            Success success = (Success)try_;
            either = value = (Either)success.value();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            either = package$.MODULE$.Left().apply((Object)new FileStoreThrownError(exception));
        } else {
            throw new MatchError((Object)try_);
        }
        return either;
    }

    public static final /* synthetic */ void $anonfun$writeDataToParquetFile$5(List _) {
    }

    public static final /* synthetic */ void $anonfun$closeWriteParquetFile$4(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$closeReadParquetFile$2(BoxedUnit _) {
    }

    public HadoopFileStoreLayer(FileStoreConfig fileStoreConfig, Option<StructType> schema) {
        this.fileStoreConfig = fileStoreConfig;
        this.S3_ACCESS_KEY = "fs.s3a.access.key";
        this.S3_SECRET_KEY = "fs.s3a.secret.key";
        this.S3_SESSION_TOKEN = "fs.s3a.session.token";
        this.AWS_CREDENTIALS_PROVIDER = "fs.s3a.aws.credentials.provider";
        this.S3_ENDPOINT = "fs.s3a.endpoint";
        this.S3_ENABLE_SSL = "fs.s3a.connection.ssl.enabled";
        this.logger = LogProvider$.MODULE$.getLogger(HadoopFileStoreLayer.class);
        this.WEBHDFS_DELEGATION_TOKEN_TEXT = new Text("WEBHDFS delegation");
        this.SWEBHDFS_DELEGATION_TOKEN_TEXT = new Text("SWEBHDFS delegation");
        this.HDFS_DELEGATION_TOKEN_TEXT = new Text("HDFS_DELEGATION_TOKEN");
        this.writer = None$.MODULE$;
        this.reader = None$.MODULE$;
        this.hdfsConfig = new Configuration();
        Option<StructType> option = schema;
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            StructType schema2 = (StructType)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(31).append("Read and write support schema: ").append(schema2).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.hdfsConfig().set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), schema2.json());
            this.hdfsConfig().set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), schema2.json());
            ParquetWriteSupport$.MODULE$.setSchema(schema2, this.hdfsConfig());
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        this.awsOptions = fileStoreConfig.awsOptions();
        this.awsAuth = this.awsOptions().awsAuth();
        Option<AWSArg<String>> option2 = this.awsOptions().awsCredentialsProvider();
        if (option2 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option2;
            AWSArg provider = (AWSArg)some.value();
            this.hdfsConfig().set(this.AWS_CREDENTIALS_PROVIDER(), (String)provider.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Setting {}: {}", new Object[]{this.AWS_CREDENTIALS_PROVIDER(), provider});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (None$.MODULE$.equals(option2)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS credentials provider for Hadoop config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else {
            throw new MatchError(option2);
        }
        Option<AWSAuth> option3 = this.awsAuth();
        if (option3 instanceof Some) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit5;
            Some some = (Some)option3;
            AWSAuth auth = (AWSAuth)some.value();
            this.hdfsConfig().set(this.S3_ACCESS_KEY(), auth.accessKeyId().arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ACCESS_KEY(), auth.accessKeyId().origin()});
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            this.hdfsConfig().set(this.S3_SECRET_KEY(), auth.secretAccessKey().arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_SECRET_KEY(), auth.secretAccessKey().origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit;
        } else if (None$.MODULE$.equals(option3)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS auth for Hadoop config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit7 = boxedUnit;
        } else {
            throw new MatchError(option3);
        }
        Option<AWSArg<String>> option4 = this.awsOptions().awsSessionToken();
        if (option4 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option4;
            AWSArg token = (AWSArg)some.value();
            this.hdfsConfig().set(this.S3_SESSION_TOKEN(), (String)token.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_SESSION_TOKEN(), token.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit8 = boxedUnit;
        } else if (None$.MODULE$.equals(option4)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS session token for Hadoop config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit9 = boxedUnit;
        } else {
            throw new MatchError(option4);
        }
        Option<AWSArg<String>> option5 = this.awsOptions().awsEndpoint();
        if (option5 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option5;
            AWSArg endpoint = (AWSArg)some.value();
            this.hdfsConfig().set(this.S3_ENDPOINT(), (String)endpoint.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ENDPOINT(), endpoint.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit10 = boxedUnit;
        } else if (None$.MODULE$.equals(option5)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not set AWS endpoint, using default.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit11 = boxedUnit;
        } else {
            throw new MatchError(option5);
        }
        Option<AWSArg<String>> option6 = this.awsOptions().enableSSL();
        if (option6 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option6;
            AWSArg enable = (AWSArg)some.value();
            this.hdfsConfig().set(this.S3_ENABLE_SSL(), (String)enable.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ENABLE_SSL(), enable.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit12 = boxedUnit;
        } else if (None$.MODULE$.equals(option6)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not set AWS SSL enabled flag, using default of true.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit13 = boxedUnit;
        } else {
            throw new MatchError(option6);
        }
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), "false");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), "true");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), "false");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), "INT96");
        this.hdfsConfig().set(SQLConf$.MODULE$.LEGACY_PARQUET_REBASE_MODE_IN_WRITE().key(), "CORRECTED");
        this.hdfsConfig().set(SQLConf$.MODULE$.LEGACY_PARQUET_REBASE_MODE_IN_READ().key(), "CORRECTED");
        this.hdfsConfig().set("spark.sql.legacy.parquet.int96RebaseModeInWrite", "CORRECTED");
        this.hdfsConfig().setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        this.hdfsConfig().set("fs.permissions.umask-mode", "000");
    }

    public class VerticaParquetBuilder
    extends ParquetWriter.Builder<InternalRow, VerticaParquetBuilder> {
        public VerticaParquetBuilder self() {
            return this;
        }

        public ParquetWriteSupport getWriteSupport(Configuration conf) {
            return new ParquetWriteSupport();
        }

        public /* synthetic */ HadoopFileStoreLayer com$vertica$spark$datasource$fs$HadoopFileStoreLayer$VerticaParquetBuilder$$$outer() {
            return HadoopFileStoreLayer.this;
        }

        public VerticaParquetBuilder(Path file) {
            if (HadoopFileStoreLayer.this == null) {
                throw null;
            }
            super(file);
        }
    }
}

