/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.v2;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.DistributedFilesystemWriteConfig;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.WriteConfig;
import com.vertica.spark.datasource.core.CreateExternalTableOption;
import com.vertica.spark.datasource.core.DSWriterInterface;
import com.vertica.spark.datasource.core.ExistingData$;
import com.vertica.spark.datasource.core.NewData$;
import com.vertica.spark.datasource.v2.VerticaBatchReader;
import com.vertica.spark.datasource.v2.WriteSucceeded$;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.ErrorHandling$;
import com.vertica.spark.util.general.Utils$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r4AAC\u0006\u0001-!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u001d9\u0005A1A\u0005\n!Ca!\u0015\u0001!\u0002\u0013I\u0005\"\u0002\u0012\u0001\t\u0003\u0012\u0006\"B.\u0001\t\u0003b\u0006\"\u00021\u0001\t\u0003\n\u0007\"\u00022\u0001\t\u0003\n'A\u0005,feRL7-\u0019\"bi\u000eDwK]5uKJT!\u0001D\u0007\u0002\u0005Y\u0014$B\u0001\b\u0010\u0003)!\u0017\r^1t_V\u00148-\u001a\u0006\u0003!E\tQa\u001d9be.T!AE\n\u0002\u000fY,'\u000f^5dC*\tA#A\u0002d_6\u001c\u0001aE\u0002\u0001/}\u0001\"\u0001G\u000f\u000e\u0003eQ!AG\u000e\u0002\t1\fgn\u001a\u0006\u00029\u0005!!.\u0019<b\u0013\tq\u0012D\u0001\u0004PE*,7\r\u001e\t\u0004A1rS\"A\u0011\u000b\u0005\t\u001a\u0013!B<sSR,'B\u0001\u0013&\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002'O\u0005\u00191/\u001d7\u000b\u0005AA#BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001eL!!L\u0011\u0003\u0015\u0011\u000bG/Y,sSR,'\u000f\u0005\u00020e5\t\u0001G\u0003\u00022K\u0005A1-\u0019;bYf\u001cH/\u0003\u00024a\tY\u0011J\u001c;fe:\fGNU8x\u0003\u0019\u0019wN\u001c4jOB\u0011a\u0007O\u0007\u0002o)\u0011AgD\u0005\u0003s]\u00121b\u0016:ji\u0016\u001cuN\u001c4jO\u00061qO]5uKJ\u0004\"\u0001P \u000e\u0003uR!AP\u0007\u0002\t\r|'/Z\u0005\u0003\u0001v\u0012\u0011\u0003R*Xe&$XM]%oi\u0016\u0014h-Y2f\u0003\u0019a\u0014N\\5u}Q\u00191)\u0012$\u0011\u0005\u0011\u0003Q\"A\u0006\t\u000bQ\u001a\u0001\u0019A\u001b\t\u000bi\u001a\u0001\u0019A\u001e\u0002\r1|wmZ3s+\u0005I\u0005C\u0001&P\u001b\u0005Y%B\u0001'N\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tq5#\u0001\u0005usB,7/\u00194f\u0013\t\u00016J\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!)\t\u0019\u0016\f\u0005\u0002U/6\tQKC\u0001W\u0003\u0015\u00198-\u00197b\u0013\tAVK\u0001\u0003V]&$\b\"\u0002.\u0007\u0001\u0004q\u0013A\u0002:fG>\u0014H-\u0001\u0004d_6l\u0017\u000e\u001e\u000b\u0002;B\u0011\u0001EX\u0005\u0003?\u0006\u00121c\u0016:ji\u0016\u00148i\\7nSRlUm]:bO\u0016\fQ!\u00192peR$\u0012aU\u0001\u0006G2|7/\u001a")
public class VerticaBatchWriter
implements DataWriter<InternalRow> {
    private final DSWriterInterface writer;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    public void write(InternalRow record) {
        Either<ConnectorError, BoxedUnit> either = this.writer.writeRow(record);
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                Left left = (Left)either;
                ConnectorError err = (ConnectorError)left.value();
                throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), err);
            }
            throw new MatchError(either);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public WriterCommitMessage commit() {
        Either<ConnectorError, BoxedUnit> either = this.writer.closeWrite();
        if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), err);
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        WriteSucceeded$ writeSucceeded$ = WriteSucceeded$.MODULE$;
        return writeSucceeded$;
    }

    public void abort() {
        Utils$.MODULE$.ignore(this.writer.closeWrite());
    }

    public void close() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VerticaBatchWriter(WriteConfig config, DSWriterInterface writer) {
        this.writer = writer;
        this.logger = LogProvider$.MODULE$.getLogger(VerticaBatchReader.class);
        WriteConfig writeConfig = config;
        if (!(writeConfig instanceof DistributedFilesystemWriteConfig)) throw new MatchError((Object)writeConfig);
        DistributedFilesystemWriteConfig distributedFilesystemWriteConfig = (DistributedFilesystemWriteConfig)writeConfig;
        Option<CreateExternalTableOption> option = distributedFilesystemWriteConfig.createExternalTable();
        if (option instanceof Some) {
            Some some = (Some)option;
            CreateExternalTableOption value = (CreateExternalTableOption)some.value();
            CreateExternalTableOption createExternalTableOption = value;
            if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (!NewData$.MODULE$.equals(createExternalTableOption)) throw new MatchError((Object)createExternalTableOption);
                Either<ConnectorError, BoxedUnit> either = writer.openWrite();
                if (!(either instanceof Right)) {
                    if (!(either instanceof Left)) throw new MatchError(either);
                    Left left = (Left)either;
                    ConnectorError err = (ConnectorError)left.value();
                    throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), err);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            Either<ConnectorError, BoxedUnit> either = writer.openWrite();
            if (!(either instanceof Right)) {
                if (!(either instanceof Left)) throw new MatchError(either);
                Left left = (Left)either;
                ConnectorError err = (ConnectorError)left.value();
                throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), err);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }
}

