/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.schema;

import cats.Applicative;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.config.TableQuery;
import com.vertica.spark.config.TableSource;
import com.vertica.spark.config.ValidColumnList;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.DatabaseReadError;
import com.vertica.spark.util.error.ErrorList;
import com.vertica.spark.util.error.JdbcSchemaError;
import com.vertica.spark.util.error.MissingSparkConversionError;
import com.vertica.spark.util.error.MissingSqlConversionError;
import com.vertica.spark.util.error.SchemaConversionError;
import com.vertica.spark.util.error.SchemaError;
import com.vertica.spark.util.error.TableNotEnoughRowsError;
import com.vertica.spark.util.error.UnknownColumnTypesError;
import com.vertica.spark.util.schema.ColumnDef;
import com.vertica.spark.util.schema.SchemaToolsInterface;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Breaks$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001\u0002\n\u0014\u0001yAQ!\u000b\u0001\u0005\u0002)Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00047\u0001\u0001\u0006IA\f\u0005\bo\u0001\u0011\r\u0011\"\u00039\u0011\u0019\t\u0005\u0001)A\u0005s!)!\t\u0001C\u0005\u0007\")\u0001\u000b\u0001C\u0005#\")!\u0010\u0001C\u0001w\"9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0003bBA4\u0001\u0011\u0005\u0013\u0011\u000e\u0005\b\u0003\u007f\u0002A\u0011AAA\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+Cq!!(\u0001\t\u0003\ty\nC\u0004\u0002*\u0002!\t!a+\t\u000f\u0005E\u0006\u0001\"\u0001\u00024\"9\u0011\u0011\u001a\u0001\u0005\u0002\u0005-\u0007bBAl\u0001\u0011\u0005\u0011\u0011\u001c\u0002\f'\u000eDW-\\1U_>d7O\u0003\u0002\u0015+\u000511o\u00195f[\u0006T!AF\f\u0002\tU$\u0018\u000e\u001c\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\u000fY,'\u000f^5dC*\tA$A\u0002d_6\u001c\u0001aE\u0002\u0001?\u0015\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014(\u001b\u0005\u0019\u0012B\u0001\u0015\u0014\u0005Q\u00196\r[3nCR{w\u000e\\:J]R,'OZ1dK\u00061A(\u001b8jiz\"\u0012a\u000b\t\u0003M\u0001\ta\u0001\\8hO\u0016\u0014X#\u0001\u0018\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001D:dC2\fGn\\4hS:<'BA\u001a\u001c\u0003!!\u0018\u0010]3tC\u001a,\u0017BA\u001b1\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013aB;oW:|wO\\\u000b\u0002sA\u0011!hP\u0007\u0002w)\u0011A(P\u0001\u0005Y\u0006twMC\u0001?\u0003\u0011Q\u0017M^1\n\u0005\u0001[$AB*ue&tw-\u0001\u0005v].twn\u001e8!\u0003=\tG\r\u001a#pk\ndW-U;pi\u0016\u001cHC\u0001#O!\t)EJ\u0004\u0002G\u0015B\u0011q)I\u0007\u0002\u0011*\u0011\u0011*H\u0001\u0007yI|w\u000e\u001e \n\u0005-\u000b\u0013A\u0002)sK\u0012,g-\u0003\u0002A\u001b*\u00111*\t\u0005\u0006\u001f\u001a\u0001\r\u0001R\u0001\u0004gR\u0014\u0018aD4fi\u000e\u000bG/\u00197zgR$\u0016\u0010]3\u0015\rISw.]:y!\u0011\u0019VkV/\u000e\u0003QS!AF\u0011\n\u0005Y#&AB#ji\",'\u000f\u0005\u0002Y76\t\u0011L\u0003\u0002[+\u0005)QM\u001d:pe&\u0011A,\u0017\u0002\f'\u000eDW-\\1FeJ|'\u000f\u0005\u0002_Q6\tqL\u0003\u0002aC\u0006)A/\u001f9fg*\u0011!mY\u0001\u0004gFd'B\u0001\re\u0015\t)g-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0006\u0019qN]4\n\u0005%|&\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000b-<\u0001\u0019\u00017\u0002\u000fM\fH\u000eV=qKB\u0011\u0001%\\\u0005\u0003]\u0006\u00121!\u00138u\u0011\u0015\u0001x\u00011\u0001m\u0003%\u0001(/Z2jg&|g\u000eC\u0003s\u000f\u0001\u0007A.A\u0003tG\u0006dW\rC\u0003u\u000f\u0001\u0007Q/\u0001\u0004tS\u001etW\r\u001a\t\u0003AYL!a^\u0011\u0003\u000f\t{w\u000e\\3b]\")\u0011p\u0002a\u0001\t\u0006AA/\u001f9f]\u0006lW-\u0001\u0006sK\u0006$7k\u00195f[\u0006$R\u0001`A\u0011\u0003k\u0001R!`A\u000b\u00037q1A`A\t\u001d\ry\u0018q\u0002\b\u0005\u0003\u0003\tiA\u0004\u0003\u0002\u0004\u0005-a\u0002BA\u0003\u0003\u0013q1aRA\u0004\u0013\u0005a\u0012B\u0001\u000e\u001c\u0013\tA\u0012$\u0003\u0002\u0017/%\u0011!,F\u0005\u0004\u0003'I\u0016!D#se>\u0014\b*\u00198eY&tw-\u0003\u0003\u0002\u0018\u0005e!aD\"p]:,7\r^8s%\u0016\u001cX\u000f\u001c;\u000b\u0007\u0005M\u0011\fE\u0002_\u0003;I1!a\b`\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003GA\u0001\u0019AA\u0013\u0003%QGMY2MCf,'\u000f\u0005\u0003\u0002(\u0005ERBAA\u0015\u0015\u0011\tY#!\f\u0002\t)$'m\u0019\u0006\u0004\u0003_9\u0012A\u00033bi\u0006\u001cx.\u001e:dK&!\u00111GA\u0015\u0005IQEMY2MCf,'/\u00138uKJ4\u0017mY3\t\u000f\u0005]\u0002\u00021\u0001\u0002:\u0005YA/\u00192mKN{WO]2f!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA /\u000511m\u001c8gS\u001eLA!a\u0011\u0002>\tYA+\u00192mKN{WO]2f\u000359W\r^\"pYVlg.\u00138g_R1\u0011\u0011JA2\u0003K\u0002R!`A\u000b\u0003\u0017\u0002b!!\u0014\u0002X\u0005uc\u0002BA(\u0003'r1aRA)\u0013\u0005\u0011\u0013bAA+C\u00059\u0001/Y2lC\u001e,\u0017\u0002BA-\u00037\u00121aU3r\u0015\r\t)&\t\t\u0004M\u0005}\u0013bAA1'\tI1i\u001c7v[:$UM\u001a\u0005\b\u0003GI\u0001\u0019AA\u0013\u0011\u001d\t9$\u0003a\u0001\u0003s\t1dZ3u-\u0016\u0014H/[2b)f\u0004XM\u0012:p[N\u0003\u0018M]6UsB,GCBA6\u0003c\n)\b\u0005\u0003~\u0003[\"\u0015\u0002BA8\u00033\u0011AbU2iK6\f'+Z:vYRDa!a\u001d\u000b\u0001\u0004i\u0016!C:qCJ\\G+\u001f9f\u0011\u001d\t9H\u0003a\u0001\u0003s\naa\u001d;sY\u0016t\u0007c\u0001\u0011\u0002|%\u0019\u0011QP\u0011\u0003\t1{gnZ\u0001\u0012O\u0016$8i\u001c9z\u0007>dW/\u001c8MSN$H\u0003CAB\u0003\u000b\u000b9)!%\u0011\tu\f)\u0002\u0012\u0005\b\u0003GY\u0001\u0019AA\u0013\u0011\u001d\tIi\u0003a\u0001\u0003\u0017\u000b\u0011\u0002^1cY\u0016t\u0015-\\3\u0011\t\u0005m\u0012QR\u0005\u0005\u0003\u001f\u000biDA\u0005UC\ndWMT1nK\"1Ac\u0003a\u0001\u00037\tQbY1tiR{g+\u0019:dQ\u0006\u0014XCAAL!\u0015\u0001\u0013\u0011\u0014#E\u0013\r\tY*\t\u0002\n\rVt7\r^5p]F\n\u0011#\\1lK\u000e{G.^7ogN#(/\u001b8h)\u0015!\u0015\u0011UAS\u0011\u001d\t\u0019+\u0004a\u0001\u0003\u0017\n!bY8mk6tG)\u001a4t\u0011\u001d\t9+\u0004a\u0001\u00037\taB]3rk&\u0014X\rZ*dQ\u0016l\u0017-A\nnC.,G+\u00192mK\u000e{G.^7o\t\u001647\u000f\u0006\u0004\u0002\u0004\u00065\u0016q\u0016\u0005\u0007)9\u0001\r!a\u0007\t\u000f\u0005]d\u00021\u0001\u0002z\u0005!r-\u001a;NKJ<W-\u00138tKJ$h+\u00197vKN$\u0002\"a!\u00026\u0006]\u0016\u0011\u0018\u0005\b\u0003Gy\u0001\u0019AA\u0013\u0011\u001d\tIi\u0004a\u0001\u0003\u0017Cq!a/\u0010\u0001\u0004\ti,\u0001\bd_BL8i\u001c7v[:d\u0015n\u001d;\u0011\u000b\u0001\ny,a1\n\u0007\u0005\u0005\u0017E\u0001\u0004PaRLwN\u001c\t\u0005\u0003w\t)-\u0003\u0003\u0002H\u0006u\"a\u0004,bY&$7i\u001c7v[:d\u0015n\u001d;\u0002)\u001d,G/T3sO\u0016,\u0006\u000fZ1uKZ\u000bG.^3t))\t\u0019)!4\u0002P\u0006E\u0017Q\u001b\u0005\b\u0003G\u0001\u0002\u0019AA\u0013\u0011\u001d\tI\t\u0005a\u0001\u0003\u0017Cq!a5\u0011\u0001\u0004\tY)A\u0007uK6\u0004H+\u00192mK:\u000bW.\u001a\u0005\b\u0003w\u0003\u0002\u0019AA_\u0003aIgNZ3s\u000bb$XM\u001d8bYR\u000b'\r\\3TG\",W.\u0019\u000b\t\u0003\u0007\u000bY.a8\u0002b\"1\u0011Q\\\tA\u0002\u0011\u000bqc\u0019:fCR,W\t\u001f;fe:\fG\u000eV1cY\u0016\u001cF/\u001c;\t\rQ\t\u0002\u0019AA\u000e\u0011\u0019\tI)\u0005a\u0001\t\u0002")
public class SchemaTools
implements SchemaToolsInterface {
    private final Logger logger = LogProvider$.MODULE$.getLogger(SchemaTools.class);
    private final String unknown;

    private Logger logger() {
        return this.logger;
    }

    private String unknown() {
        return this.unknown;
    }

    public String com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(String str) {
        return new java.lang.StringBuilder(2).append("\"").append(str).append("\"").toString();
    }

    private Either<SchemaError, DataType> getCatalystType(int sqlType, int precision, int scale, boolean signed, String typename) {
        BinaryType$ binaryType$;
        int n = sqlType;
        switch (n) {
            case 2003: {
                binaryType$ = null;
                break;
            }
            case -5: {
                if (signed) {
                    binaryType$ = LongType$.MODULE$;
                    break;
                }
                binaryType$ = new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 0);
                break;
            }
            case -2: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case -7: {
                binaryType$ = BooleanType$.MODULE$;
                break;
            }
            case 2004: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case 16: {
                binaryType$ = BooleanType$.MODULE$;
                break;
            }
            case 1: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2005: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 70: {
                binaryType$ = null;
                break;
            }
            case 91: {
                binaryType$ = DateType$.MODULE$;
                break;
            }
            case 3: {
                binaryType$ = new DecimalType(precision, scale);
                break;
            }
            case 2001: {
                binaryType$ = null;
                break;
            }
            case 8: {
                binaryType$ = DoubleType$.MODULE$;
                break;
            }
            case 6: {
                binaryType$ = FloatType$.MODULE$;
                break;
            }
            case 4: {
                if (signed) {
                    binaryType$ = IntegerType$.MODULE$;
                    break;
                }
                binaryType$ = LongType$.MODULE$;
                break;
            }
            case 2000: {
                binaryType$ = null;
                break;
            }
            case -16: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -4: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case -1: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2011: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 0: {
                binaryType$ = null;
                break;
            }
            case 2: {
                if (precision != 0 || scale != 0) {
                    binaryType$ = new DecimalType(precision, scale);
                    break;
                }
                binaryType$ = new DecimalType(DecimalType$.MODULE$.USER_DEFAULT().precision(), DecimalType$.MODULE$.USER_DEFAULT().scale());
                break;
            }
            case -9: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 1111: {
                String typenameNormalized = typename.toLowerCase();
                if (typenameNormalized.startsWith("interval") || typenameNormalized.startsWith("uuid")) {
                    binaryType$ = StringType$.MODULE$;
                    break;
                }
                binaryType$ = null;
                break;
            }
            case 7: {
                binaryType$ = DoubleType$.MODULE$;
                break;
            }
            case 2006: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -8: {
                binaryType$ = LongType$.MODULE$;
                break;
            }
            case 5: {
                binaryType$ = IntegerType$.MODULE$;
                break;
            }
            case 2009: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2002: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 92: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 93: {
                binaryType$ = TimestampType$.MODULE$;
                break;
            }
            case -6: {
                binaryType$ = IntegerType$.MODULE$;
                break;
            }
            case -3: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case 12: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            default: {
                binaryType$ = null;
                break;
            }
        }
        BinaryType$ answer = binaryType$;
        return answer == null ? package$.MODULE$.Left().apply((Object)new MissingSqlConversionError(((Object)BoxesRunTime.boxToInteger((int)sqlType)).toString(), typename)) : package$.MODULE$.Right().apply((Object)answer);
    }

    @Override
    public Either<ConnectorError, StructType> readSchema(JdbcLayerInterface jdbcLayer, TableSource tableSource) {
        Left left;
        Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tableSource);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq colInfo = (Seq)right.value();
            List errorsOrFields = ((TraversableOnce)colInfo.map((Function1 & Serializable & scala.Serializable)info -> this.getCatalystType(info.colType(), info.size(), info.scale(), info.signed(), info.colTypeName()).map((Function1 & Serializable & scala.Serializable)columnType -> new StructField(info.label(), columnType, info.nullable(), info.metadata())), Seq$.MODULE$.canBuildFrom())).toList();
            left = ((Validated)implicits$.MODULE$.toTraverseOps((Object)errorsOrFields, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$1 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$1), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)field -> StructType$.MODULE$.apply((Seq)field)).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, Seq<ColumnDef>> getColumnInfo(JdbcLayerInterface jdbcLayer, TableSource tableSource) {
        Left left;
        String string;
        TableSource tableSource2 = tableSource;
        if (tableSource2 instanceof TableName) {
            TableName tableName = (TableName)tableSource2;
            string = new java.lang.StringBuilder(24).append("SELECT * FROM ").append(tableName.getFullTableName()).append(" WHERE 1=0").toString();
        } else if (tableSource2 instanceof TableQuery) {
            TableQuery tableQuery = (TableQuery)tableSource2;
            String query = tableQuery.query();
            string = new java.lang.StringBuilder(31).append("SELECT * FROM (").append(query).append(") AS x WHERE 1=0").toString();
        } else {
            throw new MatchError((Object)tableSource2);
        }
        String query = string;
        Either<ConnectorError, ResultSet> either = jdbcLayer.query(query, jdbcLayer.query$default$2());
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
        } else if (either instanceof Right) {
            Left left3;
            Right right = (Right)either;
            try (ResultSet rs = (ResultSet)right.value();){
                try {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    left3 = package$.MODULE$.Right().apply(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), rsmd.getColumnCount()).map((Function1 & Serializable & scala.Serializable)idx -> SchemaTools.$anonfun$getColumnInfo$1(rsmd, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom()));
                }
                catch (Throwable e) {
                    left3 = package$.MODULE$.Left().apply((Object)new DatabaseReadError(e).context("Could not get column info"));
                }
            }
            left = left3;
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    @Override
    public Either<SchemaError, String> getVerticaTypeFromSparkType(DataType sparkType, long strlen) {
        Object object;
        DataType dataType = sparkType;
        if (BinaryType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"VARBINARY(65000)");
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"BOOLEAN");
        } else if (ByteType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"TINYINT");
        } else if (DateType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"DATE");
        } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"INTERVAL");
        } else if (DecimalType$.MODULE$.unapply(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"DECIMAL");
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"DOUBLE PRECISION");
        } else if (FloatType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"FLOAT");
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"INTEGER");
        } else if (LongType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"BIGINT");
        } else if (NullType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"null");
        } else if (ShortType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"SMALLINT");
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"TIMESTAMP");
        } else if (StringType$.MODULE$.equals(dataType)) {
            String vtype = strlen > 65000L ? "LONG VARCHAR" : "VARCHAR";
            object = package$.MODULE$.Right().apply((Object)new java.lang.StringBuilder(2).append(vtype).append("(").append(((Object)BoxesRunTime.boxToLong((long)strlen)).toString()).append(")").toString());
        } else {
            boolean bl = dataType instanceof ArrayType ? true : (dataType instanceof MapType ? true : dataType instanceof StructType);
            object = bl ? package$.MODULE$.Right().apply((Object)"VARBINARY(65000)") : package$.MODULE$.Left().apply((Object)new MissingSparkConversionError(sparkType));
        }
        return object;
    }

    @Override
    public Either<ConnectorError, String> getCopyColumnList(JdbcLayerInterface jdbcLayer, TableName tableName, StructType schema) {
        return this.getColumnInfo(jdbcLayer, tableName).flatMap((Function1 & Serializable & scala.Serializable)columns -> {
            Right right;
            int colCount = columns.length();
            IntRef colsFound = IntRef.create((int)0);
            columns.foreach((Function1 & Serializable & scala.Serializable)column -> {
                SchemaTools.$anonfun$getCopyColumnList$2(this, schema, colsFound, tableName, column);
                return BoxedUnit.UNIT;
            });
            if (schema.length() > colCount) {
                right = package$.MODULE$.Left().apply((Object)new TableNotEnoughRowsError().context(new java.lang.StringBuilder(187).append("Error: Number of columns in the target table should be greater or equal to number of columns in the DataFrame.  Number of columns in DataFrame: ").append(schema.length()).append(". Number of columns in the target table: ").append(tableName.getFullTableName()).append(": ").append(colCount).toString()));
            } else if (colsFound.elem == schema.length()) {
                BoxedUnit boxedUnit;
                ObjectRef columnList2 = ObjectRef.create((Object)"");
                BooleanRef first = BooleanRef.create((boolean)true);
                schema.foreach((Function1 & Serializable & scala.Serializable)s -> {
                    SchemaTools.$anonfun$getCopyColumnList$5(first, columnList2, s);
                    return BoxedUnit.UNIT;
                });
                columnList2.elem = new java.lang.StringBuilder(3).append("(").append((String)columnList2.elem).append("\")").toString();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new java.lang.StringBuilder(27).append("Load by name. Column list: ").append((String)columnList2.elem).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                right = package$.MODULE$.Right().apply((Object)((String)columnList2.elem));
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Load by Position");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                right = package$.MODULE$.Right().apply((Object)"");
            }
            return right.map((Function1 & Serializable & scala.Serializable)columnList -> columnList);
        });
    }

    private Function1<String, String> castToVarchar() {
        return (Function1 & Serializable & scala.Serializable)colName -> new java.lang.StringBuilder(13).append((String)colName).append("::varchar AS ").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes((String)colName)).toString();
    }

    @Override
    public String makeColumnsString(Seq<ColumnDef> columnDefs, StructType requiredSchema) {
        Seq requiredColumnDefs = requiredSchema.nonEmpty() ? (Seq)columnDefs.filter((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)SchemaTools.$anonfun$makeColumnsString$1(requiredSchema, cd))) : columnDefs;
        return ((TraversableOnce)requiredColumnDefs.map((Function1 & Serializable & scala.Serializable)info -> {
            String string;
            int n = info.colType();
            switch (n) {
                case 1111: {
                    String typenameNormalized = info.colTypeName().toLowerCase();
                    if (typenameNormalized.startsWith("interval") || typenameNormalized.startsWith("uuid")) {
                        string = (String)this.castToVarchar().apply((Object)info.label());
                        break;
                    }
                    string = this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(info.label());
                    break;
                }
                case 92: {
                    string = (String)this.castToVarchar().apply((Object)info.label());
                    break;
                }
                default: {
                    string = this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(info.label());
                    break;
                }
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    @Override
    public Either<ConnectorError, String> makeTableColumnDefs(StructType schema, long strlen) {
        Either either;
        Object object = new Object();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(" (");
            BooleanRef first = BooleanRef.create((boolean)true);
            schema.foreach((Function1 & Serializable & scala.Serializable)s -> {
                Either<SchemaError, String> either;
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new java.lang.StringBuilder(28).append("colname=\"").append(s.name()).append("\"").append("; type=").append(s.dataType()).append("; nullable=").append(s.nullable()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Object object = !first$2.elem ? sb.append(",\n") : BoxedUnit.UNIT;
                first$2.elem = false;
                sb.append(new java.lang.StringBuilder(3).append("\"").append(s.name()).append("\" ").toString());
                String decimal_qualifier = "";
                if (s.dataType().toString().contains("DecimalType")) {
                    Regex p = new StringOps(Predef$.MODULE$.augmentString("DecimalType\\((\\d+)\\)")).r();
                    if (s.dataType().toString().matches(p.toString())) {
                        String prec;
                        String string = s.dataType().toString();
                        Option option = p.unapplySeq((CharSequence)string);
                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                            throw new MatchError((Object)string);
                        }
                        String string2 = prec = (String)((LinearSeqOptimized)option.get()).apply(0);
                        String prec2 = string2;
                        decimal_qualifier = new java.lang.StringBuilder(2).append("(").append(prec2).append(")").toString();
                    }
                    Regex ps = new StringOps(Predef$.MODULE$.augmentString("DecimalType\\((\\d+),(\\d+)\\)")).r();
                    if (s.dataType().toString().matches(ps.toString())) {
                        String string = s.dataType().toString();
                        Option option = ps.unapplySeq((CharSequence)string);
                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) {
                            throw new MatchError((Object)string);
                        }
                        String prec = (String)((LinearSeqOptimized)option.get()).apply(0);
                        String scale = (String)((LinearSeqOptimized)option.get()).apply(1);
                        Tuple2 tuple2 = new Tuple2((Object)prec, (Object)scale);
                        Tuple2 tuple22 = tuple2;
                        String prec3 = (String)tuple22._1();
                        String scale2 = (String)tuple22._2();
                        decimal_qualifier = new java.lang.StringBuilder(3).append("(").append(prec3).append(",").append(scale2).append(")").toString();
                    }
                }
                if ((either = this.getVerticaTypeFromSparkType(s.dataType(), strlen)) instanceof Left) {
                    Left left = (Left)either;
                    SchemaError err = (SchemaError)left.value();
                    throw new NonLocalReturnControl(object, (Object)package$.MODULE$.Left().apply((Object)new SchemaConversionError(err).context("Schema error when trying to create table")));
                }
                if (!(either instanceof Right)) {
                    throw new MatchError(either);
                }
                Right right = (Right)either;
                String datatype = (String)right.value();
                Right right2 = package$.MODULE$.Right().apply((Object)new java.lang.StringBuilder(0).append(datatype).append(decimal_qualifier).toString());
                return right2.map((Function1 & Serializable & scala.Serializable)col -> {
                    StringBuilder x$3 = sb.append(col);
                    BoxedUnit x$4 = !s.nullable() ? sb.append(" NOT NULL") : BoxedUnit.UNIT;
                    return new Tuple3(col, (Object)x$3, (Object)x$4);
                }).map((Function1 & Serializable & scala.Serializable)x$5 -> {
                    SchemaTools.$anonfun$makeTableColumnDefs$3(x$5);
                    return BoxedUnit.UNIT;
                });
            });
            sb.append(")");
            either = package$.MODULE$.Right().apply((Object)sb.toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                either = (Either)ex.value();
            }
            throw ex;
        }
        return either;
    }

    @Override
    public Either<ConnectorError, String> getMergeInsertValues(JdbcLayerInterface jdbcLayer, TableName tableName, Option<ValidColumnList> copyColumnList) {
        Left left;
        Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tableName);
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq info = (Seq)right.value();
            left = package$.MODULE$.Right().apply((Object)((TraversableOnce)info.map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(5).append("temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).toString(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
        } else {
            throw new MatchError(either);
        }
        Left valueList = left;
        return valueList;
    }

    @Override
    public Either<ConnectorError, String> getMergeUpdateValues(JdbcLayerInterface jdbcLayer, TableName tableName, TableName tempTableName, Option<ValidColumnList> copyColumnList) {
        Left left;
        Option<ValidColumnList> option = copyColumnList;
        if (option instanceof Some) {
            Left colList;
            Left left2;
            Some some = (Some)option;
            ValidColumnList list = (ValidColumnList)some.value();
            List customColList = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])list.toString().split(","))).toList().map((Function1 & Serializable & scala.Serializable)col -> col.trim(), List$.MODULE$.canBuildFrom());
            Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tempTableName);
            if (either instanceof Right) {
                Right right = (Right)either;
                Seq info = (Seq)right.value();
                List tupleList = (List)customColList.zip((GenIterable)info, List$.MODULE$.canBuildFrom());
                left2 = package$.MODULE$.Right().apply((Object)((TraversableOnce)tupleList.map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(6).append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes((String)x._1())).append("=temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(((ColumnDef)x._2()).label())).toString(), List$.MODULE$.canBuildFrom())).mkString(", "));
            } else if (either instanceof Left) {
                Left left3 = (Left)either;
                ConnectorError err = (ConnectorError)left3.value();
                left2 = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
            } else {
                throw new MatchError(either);
            }
            left = colList = left2;
        } else if (None$.MODULE$.equals(option)) {
            Left updateList;
            Left left4;
            Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tempTableName);
            if (either instanceof Right) {
                Right right = (Right)either;
                Seq info = (Seq)right.value();
                left4 = package$.MODULE$.Right().apply((Object)((TraversableOnce)info.map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(6).append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).append("=temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).toString(), Seq$.MODULE$.canBuildFrom())).mkString(", "));
            } else if (either instanceof Left) {
                Left left5 = (Left)either;
                ConnectorError err = (ConnectorError)left5.value();
                left4 = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
            } else {
                throw new MatchError(either);
            }
            left = updateList = left4;
        } else {
            throw new MatchError(option);
        }
        Left columnList = left;
        return columnList;
    }

    @Override
    public Either<ConnectorError, String> inferExternalTableSchema(String createExternalTableStmt, StructType schema, String tableName) {
        Right right;
        int indexOfClosingParantheses;
        int indexOfOpeningParantheses;
        String stmt = createExternalTableStmt.replace(new java.lang.StringBuilder(2).append("\"").append(tableName).append("\"").toString(), tableName);
        String schemaString = stmt.substring((indexOfOpeningParantheses = stmt.indexOf("(")) + 1, indexOfClosingParantheses = stmt.indexOf(")"));
        List schemaList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schemaString.split(","))).toList();
        String updatedSchema = ((TraversableOnce)schemaList.map((Function1 & Serializable & scala.Serializable)col -> {
            int indexOfSpace;
            int indexOfFirstDoubleQuote = col.indexOf("\"");
            String colName = col.substring(indexOfFirstDoubleQuote, indexOfSpace = col.indexOf(" ", indexOfFirstDoubleQuote));
            Seq fieldType = (Seq)schema.collect((PartialFunction)new scala.Serializable(this, colName){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SchemaTools $outer;
                private final String colName$1;

                public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    String string = this.$outer.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(A1.name());
                    String string2 = this.colName$1;
                    Object object = !(string != null ? !string.equals(string2) : string2 != null) ? A1.dataType().simpleString() : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(StructField x1) {
                    StructField structField = x1;
                    String string = this.$outer.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(structField.name());
                    String string2 = this.colName$1;
                    boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.colName$1 = colName$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            return fieldType.nonEmpty() ? new java.lang.StringBuilder(1).append(colName).append(" ").append(fieldType.head()).toString() : col;
        }, List$.MODULE$.canBuildFrom())).mkString(",");
        if (updatedSchema.contains(this.unknown())) {
            right = package$.MODULE$.Left().apply((Object)new UnknownColumnTypesError().context(new java.lang.StringBuilder(30).append(this.unknown()).append(" partitioned column data type.").toString()));
        } else {
            BoxedUnit boxedUnit;
            String updatedCreateTableStmt = stmt.replace(schemaString, updatedSchema);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new java.lang.StringBuilder(31).append("Edited create table statement: ").append(updatedCreateTableStmt).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            right = package$.MODULE$.Right().apply((Object)updatedCreateTableStmt);
        }
        return right;
    }

    public static final /* synthetic */ ColumnDef $anonfun$getColumnInfo$1(ResultSetMetaData rsmd$1, int idx) {
        String columnLabel = rsmd$1.getColumnLabel(idx);
        int dataType = rsmd$1.getColumnType(idx);
        String typeName = rsmd$1.getColumnTypeName(idx);
        int fieldSize = DecimalType$.MODULE$.MAX_PRECISION();
        int fieldScale = rsmd$1.getScale(idx);
        boolean isSigned = rsmd$1.isSigned(idx);
        boolean nullable = rsmd$1.isNullable(idx) != 0;
        Metadata metadata = new MetadataBuilder().putString("name", columnLabel).build();
        return new ColumnDef(columnLabel, dataType, typeName, fieldSize, fieldScale, isSigned, nullable, metadata);
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$4(SchemaTools $this, ColumnDef column$1, IntRef colsFound$1, TableName tableName$1, StructField s) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new java.lang.StringBuilder(48).append("Comparing target table column: ").append(column$1.label()).append(" with DF column: ").append(s.name()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (s.name().equalsIgnoreCase(column$1.label())) {
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            ++colsFound$1.elem;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug(new java.lang.StringBuilder(37).append("Column: ").append(s.name()).append(" found in target table and DF").toString());
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            if (!column$1.nullable()) {
                if (s.nullable()) {
                    if ($this.logger().underlying().isWarnEnabled()) {
                        $this.logger().underlying().warn(new java.lang.StringBuilder(128).append("S2V: Column ").append(s.name()).append(" is NOT NULL in target table ").append(tableName$1.getFullTableName()).append(" but it's nullable in the DataFrame. Rows with NULL values in column ").append(s.name()).append(" will be rejected.").toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw Breaks$.MODULE$.break();
        }
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$2(SchemaTools $this, StructType schema$1, IntRef colsFound$1, TableName tableName$1, ColumnDef column) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new java.lang.StringBuilder(43).append("Will check that target column: ").append(column.label()).append(" exist in DF").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> schema$1.foreach((Function1 & Serializable & scala.Serializable)s -> {
            SchemaTools.$anonfun$getCopyColumnList$4($this, column, colsFound$1, tableName$1, s);
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$5(BooleanRef first$1, ObjectRef columnList$1, StructField s) {
        if (first$1.elem) {
            columnList$1.elem = new java.lang.StringBuilder(1).append("\"").append(s.name()).toString();
            first$1.elem = false;
        } else {
            columnList$1.elem = new java.lang.StringBuilder(3).append((String)columnList$1.elem).append("\",\"").append(s.name()).toString();
        }
    }

    public static final /* synthetic */ boolean $anonfun$makeColumnsString$2(ColumnDef cd$1, StructField field) {
        String string = field.name();
        String string2 = cd$1.label();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$makeColumnsString$1(StructType requiredSchema$1, ColumnDef cd) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema$1.fields())).exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SchemaTools.$anonfun$makeColumnsString$2(cd, field)));
    }

    public static final /* synthetic */ void $anonfun$makeTableColumnDefs$3(Tuple3 x$5) {
        Tuple3 tuple3 = x$5;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public SchemaTools() {
        this.unknown = "UNKNOWN";
    }
}

