/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.core;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.DistributedFilesystemWriteConfig;
import com.vertica.spark.config.EscapeUtils$;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.config.ValidColumnList;
import com.vertica.spark.config.ValidFilePermissions;
import com.vertica.spark.config.VerticaMetadata;
import com.vertica.spark.config.VerticaWriteMetadata;
import com.vertica.spark.datasource.core.CreateExternalTableOption;
import com.vertica.spark.datasource.core.DataBlock;
import com.vertica.spark.datasource.core.ExistingData$;
import com.vertica.spark.datasource.core.NewData$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipe$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$;
import com.vertica.spark.datasource.core.VerticaPipeInterface;
import com.vertica.spark.datasource.core.VerticaPipeWriteInterface;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcUtils$;
import com.vertica.spark.util.error.CommitError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.CreateExternalTableAlreadyExistsError;
import com.vertica.spark.util.error.CreateExternalTableMergeKey;
import com.vertica.spark.util.error.CreateTableError;
import com.vertica.spark.util.error.DropTableError;
import com.vertica.spark.util.error.DuplicateColumnsError;
import com.vertica.spark.util.error.FaultToleranceTestFail;
import com.vertica.spark.util.error.InferExternalSchemaError;
import com.vertica.spark.util.error.InferExternalTableSchemaError;
import com.vertica.spark.util.error.MergeColumnListError;
import com.vertica.spark.util.error.NonEmptyDataFrameError;
import com.vertica.spark.util.error.SchemaColumnListError;
import com.vertica.spark.util.error.TempTableExistsError;
import com.vertica.spark.util.error.ViewExistsError;
import com.vertica.spark.util.schema.SchemaToolsInterface;
import com.vertica.spark.util.table.TableUtilsInterface;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\rub\u0001\u0002#F\u0001AC\u0001B\u0018\u0001\u0003\u0006\u0004%\ta\u0018\u0005\tK\u0002\u0011\t\u0011)A\u0005A\"Aa\r\u0001BC\u0002\u0013\u0005q\r\u0003\u0005o\u0001\t\u0005\t\u0015!\u0003i\u0011!y\u0007A!b\u0001\n\u0003\u0001\b\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011B9\t\u0011a\u0004!Q1A\u0005\u0002eD\u0011\"!\u0002\u0001\u0005\u0003\u0005\u000b\u0011\u0002>\t\u0015\u0005\u001d\u0001A!b\u0001\n\u0003\tI\u0001\u0003\u0006\u0002\u0018\u0001\u0011\t\u0011)A\u0005\u0003\u0017A!\"!\u0007\u0001\u0005\u000b\u0007I\u0011AA\u000e\u0011)\t\u0019\u0003\u0001B\u0001B\u0003%\u0011Q\u0004\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011%\t9\u0004\u0001b\u0001\n\u0013\tI\u0004\u0003\u0005\u0002L\u0001\u0001\u000b\u0011BA\u001e\u0011%\ti\u0005\u0001b\u0001\n\u0013\ty\u0005\u0003\u0005\u0002X\u0001\u0001\u000b\u0011BA)\u0011%\tI\u0006\u0001b\u0001\n\u0013\tY\u0006\u0003\u0005\u0002n\u0001\u0001\u000b\u0011BA/\u0011%\ty\u0007\u0001b\u0001\n\u0013\tY\u0006\u0003\u0005\u0002r\u0001\u0001\u000b\u0011BA/\u0011\u001d\t\u0019\b\u0001C\u0001\u0003kBq!!+\u0001\t\u0003\tY\u000bC\u0004\u00026\u0002!\t!a.\t\u000f\u0005u\u0007\u0001\"\u0003\u0002`\"9\u0011\u0011\u001d\u0001\u0005\n\u0005\r\bbBAz\u0001\u0011\u0005\u0011Q\u001f\u0005\b\u0003o\u0004A\u0011AA}\u0011\u001d\ty\u0010\u0001C\u0001\u0005\u0003AqA!\u0004\u0001\t\u0003\t)\u0010C\u0004\u0003\u0010\u0001!\tA!\u0005\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003*!9!Q\u0007\u0001\u0005\u0002\t]\u0002b\u0002B\u001f\u0001\u0011\u0005!q\b\u0005\b\u0005\u0007\u0002A\u0011\u0002B#\r\u0019\u00119\u0005\u0001#\u0003J!Q!q\u000b\u0013\u0003\u0016\u0004%\tA!\u0017\t\u0015\t\u0005DE!E!\u0002\u0013\u0011Y\u0006\u0003\u0006\u0003d\u0011\u0012)\u001a!C\u0001\u0005KB!B!\u001c%\u0005#\u0005\u000b\u0011\u0002B4\u0011\u001d\t)\u0003\nC\u0001\u0005_B\u0011B!\u001f%\u0003\u0003%\tAa\u001f\t\u0013\t\u0005E%%A\u0005\u0002\t\r\u0005\"\u0003BMIE\u0005I\u0011\u0001BN\u0011%\u0011y\nJA\u0001\n\u0003\nY\u0006C\u0005\u0003\"\u0012\n\t\u0011\"\u0001\u0002\u001c!I!1\u0015\u0013\u0002\u0002\u0013\u0005!Q\u0015\u0005\n\u0005c#\u0013\u0011!C!\u0005gC\u0011B!1%\u0003\u0003%\tAa1\t\u0013\t\u001dG%!A\u0005B\t%\u0007\"\u0003BfI\u0005\u0005I\u0011\tBg\u0011%\u0011y\rJA\u0001\n\u0003\u0012\tnB\u0005\u0003V\u0002\t\t\u0011#\u0003\u0003X\u001aI!q\t\u0001\u0002\u0002#%!\u0011\u001c\u0005\b\u0003K1D\u0011\u0001Bt\u0011%\u0011YMNA\u0001\n\u000b\u0012i\rC\u0005\u0003jZ\n\t\u0011\"!\u0003l\"I!\u0011\u001f\u001c\u0002\u0002\u0013\u0005%1\u001f\u0005\b\u0007\u000b\u0001A\u0011BB\u0004\u0011\u001d\u0019\u0019\u0002\u0001C\u0001\u0007+Aqa!\t\u0001\t\u0003\u0019\u0019\u0003C\u0004\u0004(\u0001!\ta!\u000b\t\u000f\r5\u0002\u0001\"\u0001\u0002v\u001eI1qF#\u0002\u0002#\u00051\u0011\u0007\u0004\t\t\u0016\u000b\t\u0011#\u0001\u00044!9\u0011QE!\u0005\u0002\rU\u0002\"CB\u001c\u0003F\u0005I\u0011AB\u001d\u0005\u00152VM\u001d;jG\u0006$\u0015n\u001d;sS\n,H/\u001a3GS2,7/_:uK6<&/\u001b;f!&\u0004XM\u0003\u0002G\u000f\u0006!1m\u001c:f\u0015\tA\u0015*\u0001\u0006eCR\f7o\\;sG\u0016T!AS&\u0002\u000bM\u0004\u0018M]6\u000b\u00051k\u0015a\u0002<feRL7-\u0019\u0006\u0002\u001d\u0006\u00191m\\7\u0004\u0001M!\u0001!U,\\!\t\u0011V+D\u0001T\u0015\u0005!\u0016!B:dC2\f\u0017B\u0001,T\u0005\u0019\te.\u001f*fMB\u0011\u0001,W\u0007\u0002\u000b&\u0011!,\u0012\u0002\u0015-\u0016\u0014H/[2b!&\u0004X-\u00138uKJ4\u0017mY3\u0011\u0005ac\u0016BA/F\u0005e1VM\u001d;jG\u0006\u0004\u0016\u000e]3Xe&$X-\u00138uKJ4\u0017mY3\u0002\r\r|gNZ5h+\u0005\u0001\u0007CA1d\u001b\u0005\u0011'B\u00010J\u0013\t!'M\u0001\u0011ESN$(/\u001b2vi\u0016$g)\u001b7fgf\u001cH/Z7Xe&$XmQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u000fM&dWm\u0015;pe\u0016d\u0015-_3s+\u0005A\u0007CA5m\u001b\u0005Q'BA6H\u0003\t17/\u0003\u0002nU\n9b)\u001b7f'R|'/\u001a'bs\u0016\u0014\u0018J\u001c;fe\u001a\f7-Z\u0001\u0010M&dWm\u0015;pe\u0016d\u0015-_3sA\u0005I!\u000e\u001a2d\u0019\u0006LXM]\u000b\u0002cB\u0011!/^\u0007\u0002g*\u0011AoR\u0001\u0005U\u0012\u00147-\u0003\u0002wg\n\u0011\"\n\u001a2d\u0019\u0006LXM]%oi\u0016\u0014h-Y2f\u0003)QGMY2MCf,'\u000fI\u0001\fg\u000eDW-\\1U_>d7/F\u0001{!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\u0007g\u000eDW-\\1\u000b\u0005}L\u0015\u0001B;uS2L1!a\u0001}\u0005Q\u00196\r[3nCR{w\u000e\\:J]R,'OZ1dK\u0006a1o\u00195f[\u0006$vn\u001c7tA\u0005QA/\u00192mKV#\u0018\u000e\\:\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005Ea0A\u0003uC\ndW-\u0003\u0003\u0002\u0016\u0005=!a\u0005+bE2,W\u000b^5mg&sG/\u001a:gC\u000e,\u0017a\u0003;bE2,W\u000b^5mg\u0002\n\u0001\u0002Z1uCNK'0Z\u000b\u0003\u0003;\u00012AUA\u0010\u0013\r\t\tc\u0015\u0002\u0004\u0013:$\u0018!\u00033bi\u0006\u001c\u0016N_3!\u0003\u0019a\u0014N\\5u}Qq\u0011\u0011FA\u0016\u0003[\ty#!\r\u00024\u0005U\u0002C\u0001-\u0001\u0011\u0015qV\u00021\u0001a\u0011\u00151W\u00021\u0001i\u0011\u0015yW\u00021\u0001r\u0011\u0015AX\u00021\u0001{\u0011\u001d\t9!\u0004a\u0001\u0003\u0017A\u0011\"!\u0007\u000e!\u0003\u0005\r!!\b\u0002\r1|wmZ3s+\t\tY\u0004\u0005\u0003\u0002>\u0005\u001dSBAA \u0015\u0011\t\t%a\u0011\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0007\u0005\u0015S*\u0001\u0005usB,7/\u00194f\u0013\u0011\tI%a\u0010\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nQ\u0002^3naR\u000b'\r\\3OC6,WCAA)!\r\t\u00171K\u0005\u0004\u0003+\u0012'!\u0003+bE2,g*Y7f\u00039!X-\u001c9UC\ndWMT1nK\u0002\n1\u0005T#H\u0003\u000eKv\fU!S#V+Ek\u0018*F\u0005\u0006\u001bViX'P\t\u0016{\u0016JT0X%&#V)\u0006\u0002\u0002^A!\u0011qLA5\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014\u0001\u00027b]\u001eT!!a\u001a\u0002\t)\fg/Y\u0005\u0005\u0003W\n\tG\u0001\u0004TiJLgnZ\u0001%\u0019\u0016;\u0015iQ-`!\u0006\u0013\u0016+V#U?J+%)Q*F?6{E)R0J\u001d~;&+\u0013+FA\u0005IC*R$B\u0007f{\u0006+\u0011*R+\u0016#v,\u0013(UsYz&+\u0012\"B'\u0016{Vj\u0014#F?&sul\u0016*J)\u0016\u000b!\u0006T#H\u0003\u000eKv\fU!S#V+EkX%O)f2tLU#C\u0003N+u,T(E\u000b~KejX,S\u0013R+\u0005%A\u0006hKRlU\r^1eCR\fWCAA<!\u0019\tI(!(\u0002$:!\u00111PAL\u001d\u0011\ti(a%\u000f\t\u0005}\u0014\u0011\u0013\b\u0005\u0003\u0003\u000byI\u0004\u0003\u0002\u0004\u00065e\u0002BAC\u0003\u0017k!!a\"\u000b\u0007\u0005%u*\u0001\u0004=e>|GOP\u0005\u0002\u001d&\u0011A*T\u0005\u0003\u0015.K!a`%\n\u0007\u0005Ue0A\u0003feJ|'/\u0003\u0003\u0002\u001a\u0006m\u0015!D#se>\u0014\b*\u00198eY&twMC\u0002\u0002\u0016zLA!a(\u0002\"\ny1i\u001c8oK\u000e$xN\u001d*fgVdGO\u0003\u0003\u0002\u001a\u0006m\u0005cA1\u0002&&\u0019\u0011q\u00152\u0003\u001fY+'\u000f^5dC6+G/\u00193bi\u0006\f\u0001cZ3u\t\u0006$\u0018M\u00117pG.\u001c\u0016N_3\u0016\u0005\u00055\u0006CBA=\u0003;\u000by\u000bE\u0002S\u0003cK1!a-T\u0005\u0011auN\\4\u00021\rDWmY6TG\",W.\u0019$pe\u0012+\b\u000f\\5dCR,7\u000f\u0006\u0003\u0002:\u0006\u0005\u0007CBA=\u0003;\u000bY\fE\u0002S\u0003{K1!a0T\u0005\u0011)f.\u001b;\t\ruD\u0002\u0019AAb!\u0011\t)-!7\u000e\u0005\u0005\u001d'\u0002BAe\u0003\u0017\fQ\u0001^=qKNTA!!4\u0002P\u0006\u00191/\u001d7\u000b\u0007)\u000b\tN\u0003\u0003\u0002T\u0006U\u0017AB1qC\u000eDWM\u0003\u0002\u0002X\u0006\u0019qN]4\n\t\u0005m\u0017q\u0019\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017\u0001F:fiN\u0003\u0018M]6DC2,g\u000eZ1s\u0007>tg\r\u0006\u0002\u0002<\u0006Qq-\u001a;BI\u0012\u0014Xm]:\u0015\u0005\u0005\u0015\b\u0003BAt\u0003_tA!!;\u0002lB\u0019\u0011QQ*\n\u0007\u000558+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\n\tPC\u0002\u0002nN\u000bq\u0002Z8Qe\u0016<&/\u001b;f'R,\u0007o\u001d\u000b\u0003\u0003s\u000b1c\u001d;beR\u0004\u0016M\u001d;ji&|gn\u0016:ji\u0016$B!!/\u0002|\"9\u0011Q \u000fA\u0002\u0005\u0015\u0018\u0001C;oSF,X-\u00133\u0002\u0013]\u0014\u0018\u000e^3ECR\fG\u0003BA]\u0005\u0007AqA!\u0002\u001e\u0001\u0004\u00119!\u0001\u0003eCR\f\u0007c\u0001-\u0003\n%\u0019!1B#\u0003\u0013\u0011\u000bG/\u0019\"m_\u000e\\\u0017!E3oIB\u000b'\u000f^5uS>twK]5uK\u0006\u0011\"-^5mI\u000e{\u0007/_*uCR,W.\u001a8u)1\t)Oa\u0005\u0003\u0018\tm!q\u0004B\u0012\u0011\u001d\u0011)b\ba\u0001\u0003K\f1\u0002^1sO\u0016$H+\u00192mK\"9!\u0011D\u0010A\u0002\u0005\u0015\u0018AC2pYVlg\u000eT5ti\"9!QD\u0010A\u0002\u0005\u0015\u0018aA;sY\"9!\u0011E\u0010A\u0002\u0005\u0015\u0018\u0001\u0005:fU\u0016\u001cGo\u001d+bE2,g*Y7f\u0011\u001d\u0011)c\ba\u0001\u0003K\f!BZ5mK\u001a{'/\\1u\u0003M\u0011W/\u001b7e\u001b\u0016\u0014x-Z*uCR,W.\u001a8u)!\t)Oa\u000b\u00030\tE\u0002b\u0002B\u0017A\u0001\u0007\u0011\u0011K\u0001\u0010i\u0006\u0014x-\u001a;UC\ndWMT1nK\"9!\u0011\u0004\u0011A\u0002\u0005\u0015\bb\u0002B\u001aA\u0001\u0007\u0011Q]\u0001\ni\u0016l\u0007\u000fV1cY\u0016\fA\u0002]3sM>\u0014X.T3sO\u0016$B!!/\u0003:!9!1H\u0011A\u0002\u0005\u0015\u0018AD7fe\u001e,7\u000b^1uK6,g\u000e^\u0001\u0019S:4WM]#yi\u0016\u0014h.\u00197UC\ndWmU2iK6\fGC\u0001B!!\u0019\tI(!(\u0002f\u0006iq-\u001a;D_2,XN\u001c'jgR,\"A!\u0011\u00031\u0019\u000bW\u000f\u001c;U_2,'/\u00198dKR+7\u000f\u001e*fgVdGo\u0005\u0004%#\n-#\u0011\u000b\t\u0004%\n5\u0013b\u0001B('\n9\u0001K]8ek\u000e$\bc\u0001*\u0003T%\u0019!QK*\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000fM,8mY3tgV\u0011!1\f\t\u0004%\nu\u0013b\u0001B0'\n9!i\\8mK\u0006t\u0017\u0001C:vG\u000e,7o\u001d\u0011\u0002#\u0019\f\u0017\u000e\\3e%><8\u000fU3sG\u0016tG/\u0006\u0002\u0003hA\u0019!K!\u001b\n\u0007\t-4K\u0001\u0004E_V\u0014G.Z\u0001\u0013M\u0006LG.\u001a3S_^\u001c\b+\u001a:dK:$\b\u0005\u0006\u0004\u0003r\tU$q\u000f\t\u0004\u0005g\"S\"\u0001\u0001\t\u000f\t]\u0013\u00061\u0001\u0003\\!9!1M\u0015A\u0002\t\u001d\u0014\u0001B2paf$bA!\u001d\u0003~\t}\u0004\"\u0003B,UA\u0005\t\u0019\u0001B.\u0011%\u0011\u0019G\u000bI\u0001\u0002\u0004\u00119'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u0015%\u0006\u0002B.\u0005\u000f[#A!#\u0011\t\t-%QS\u0007\u0003\u0005\u001bSAAa$\u0003\u0012\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005'\u001b\u0016AC1o]>$\u0018\r^5p]&!!q\u0013BG\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iJ\u000b\u0003\u0003h\t\u001d\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t\u001d&Q\u0016\t\u0004%\n%\u0016b\u0001BV'\n\u0019\u0011I\\=\t\u0013\t=v&!AA\u0002\u0005u\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00036B1!q\u0017B_\u0005Ok!A!/\u000b\u0007\tm6+\u0001\u0006d_2dWm\u0019;j_:LAAa0\u0003:\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011YF!2\t\u0013\t=\u0016'!AA\u0002\t\u001d\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005u\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0003\\\tM\u0007\"\u0003BXi\u0005\u0005\t\u0019\u0001BT\u0003a1\u0015-\u001e7u)>dWM]1oG\u0016$Vm\u001d;SKN,H\u000e\u001e\t\u0004\u0005g24#\u0002\u001c\u0003\\\nE\u0003C\u0003Bo\u0005G\u0014YFa\u001a\u0003r5\u0011!q\u001c\u0006\u0004\u0005C\u001c\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005K\u0014yNA\tBEN$(/Y2u\rVt7\r^5p]J\"\"Aa6\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\tE$Q\u001eBx\u0011\u001d\u00119&\u000fa\u0001\u00057BqAa\u0019:\u0001\u0004\u00119'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tU8\u0011\u0001\t\u0006%\n](1`\u0005\u0004\u0005s\u001c&AB(qi&|g\u000eE\u0004S\u0005{\u0014YFa\u001a\n\u0007\t}8K\u0001\u0004UkBdWM\r\u0005\n\u0007\u0007Q\u0014\u0011!a\u0001\u0005c\n1\u0001\u001f\u00131\u0003I!Xm\u001d;GCVdG\u000fV8mKJ\fgnY3\u0015\r\r%11BB\b!\u0019\tI(!(\u0003r!91QB\u001eA\u0002\u0005u\u0011A\u0003:poN\u001cu\u000e]5fI\"91\u0011C\u001eA\u0002\u0005\u0015\u0018\u0001\u0004:fU\u0016\u001cGo\u001d+bE2,\u0017a\u00039fe\u001a|'/\\\"paf$baa\u0006\u0004\u001a\ru\u0001CBA=\u0003;\u000bi\u0002C\u0004\u0004\u001cq\u0002\r!!:\u0002\u001b\r|\u0007/_*uCR,W.\u001a8u\u0011\u001d\u0019y\u0002\u0010a\u0001\u0003#\n\u0011\u0002^1cY\u0016t\u0017-\\3\u0002+\r|W.\\5u\t\u0006$\u0018-\u00138u_Z+'\u000f^5dCR!\u0011\u0011XB\u0013\u0011\u001d\u0011i\"\u0010a\u0001\u0003K\f\u0011dY8n[&$H)\u0019;b\u0003N,\u0005\u0010^3s]\u0006dG+\u00192mKR!\u0011\u0011XB\u0016\u0011\u001d\u0011iB\u0010a\u0001\u0003K\faaY8n[&$\u0018!\n,feRL7-\u0019#jgR\u0014\u0018NY;uK\u00124\u0015\u000e\\3tsN$X-\\,sSR,\u0007+\u001b9f!\tA\u0016i\u0005\u0002B#R\u00111\u0011G\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\rm\"\u0006BA\u000f\u0005\u000f\u0003")
public class VerticaDistributedFilesystemWritePipe
implements VerticaPipeInterface,
VerticaPipeWriteInterface {
    private volatile VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$ FaultToleranceTestResult$module;
    private final DistributedFilesystemWriteConfig config;
    private final FileStoreLayerInterface fileStoreLayer;
    private final JdbcLayerInterface jdbcLayer;
    private final SchemaToolsInterface schemaTools;
    private final TableUtilsInterface tableUtils;
    private final int dataSize;
    private final Logger logger;
    private final TableName tempTableName;
    private final String LEGACY_PARQUET_REBASE_MODE_IN_WRITE;
    private final String LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE;

    public static int $lessinit$greater$default$6() {
        return VerticaDistributedFilesystemWritePipe$.MODULE$.$lessinit$greater$default$6();
    }

    private VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$ FaultToleranceTestResult() {
        if (this.FaultToleranceTestResult$module == null) {
            this.FaultToleranceTestResult$lzycompute$1();
        }
        return this.FaultToleranceTestResult$module;
    }

    public DistributedFilesystemWriteConfig config() {
        return this.config;
    }

    public FileStoreLayerInterface fileStoreLayer() {
        return this.fileStoreLayer;
    }

    public JdbcLayerInterface jdbcLayer() {
        return this.jdbcLayer;
    }

    public SchemaToolsInterface schemaTools() {
        return this.schemaTools;
    }

    public TableUtilsInterface tableUtils() {
        return this.tableUtils;
    }

    public int dataSize() {
        return this.dataSize;
    }

    private Logger logger() {
        return this.logger;
    }

    private TableName tempTableName() {
        return this.tempTableName;
    }

    private String LEGACY_PARQUET_REBASE_MODE_IN_WRITE() {
        return this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE;
    }

    private String LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE() {
        return this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE;
    }

    @Override
    public Either<ConnectorError, VerticaMetadata> getMetadata() {
        return package$.MODULE$.Right().apply((Object)new VerticaWriteMetadata());
    }

    @Override
    public Either<ConnectorError, Object> getDataBlockSize() {
        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)this.dataSize()));
    }

    public Either<ConnectorError, BoxedUnit> checkSchemaForDuplicates(StructType schema) {
        String[] names = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)f -> f.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])names)).distinct()).length != names.length ? package$.MODULE$.Left().apply((Object)new DuplicateColumnsError()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private void setSparkCalendarConf() {
        Option option = SparkSession$.MODULE$.getActiveSession();
        if (option instanceof Some) {
            Some some = (Some)option;
            SparkSession session = (SparkSession)some.value();
            session.sparkContext().setLocalProperty(this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE(), "CORRECTED");
            session.sparkContext().setLocalProperty(this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE(), "CORRECTED");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("No spark session found to set config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private String getAddress() {
        return this.config().createExternalTable().isDefined() ? this.config().fileStoreConfig().externalTableAddress() : this.config().fileStoreConfig().address();
    }

    @Override
    public Either<ConnectorError, BoxedUnit> doPreWriteSteps() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.config().mergeKey().isDefined() && this.config().isOverwrite()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Save mode is specified as Overwrite during a merge.");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Writing data to Parquet file.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.checkSchemaForDuplicates(this.config().schema()).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.setSparkCalendarConf();
            BoxedUnit x$2 = BoxedUnit.UNIT;
            return new Tuple2(x$1, (Object)x$2);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Either either = (this.config().isOverwrite() && this.config().mergeKey().isEmpty() ? this.tableUtils().dropTable(this.config().tablename()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> (this.config().createExternalTable().isDefined() && this.config().mergeKey().isDefined() ? package$.MODULE$.Left().apply((Object)new CreateExternalTableMergeKey()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.tableUtils().tableExists(this.config().tablename()).flatMap((Function1 & Serializable & scala.Serializable)tableExistsPre -> VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$5(this, BoxesRunTime.unboxToBoolean((Object)tableExistsPre)))));
            return either;
        });
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Either<ConnectorError, BoxedUnit> startPartitionWrite(String uniqueId) {
        block9: {
            block8: {
                address = this.getAddress();
                v0 = new StringOps(Predef$.MODULE$.augmentString(address)).takeRight(1);
                var5_3 = "/";
                if (!(v0 == null ? var5_3 != null : v0.equals(var5_3) == false)) ** GOTO lbl-1000
                v1 = new StringOps(Predef$.MODULE$.augmentString(address)).takeRight(1);
                var6_4 = "\\";
                if (!(v1 != null ? v1.equals(var6_4) == false : var6_4 != null)) lbl-1000:
                // 2 sources

                {
                    v2 = "";
                } else {
                    v2 = "/";
                }
                delimiter = v2;
                filename = new StringBuilder(15).append(address).append(delimiter).append(uniqueId).append(".snappy.parquet").toString();
                var8_7 = this.fileStoreLayer().openWriteParquetFile(filename);
                if (!(var8_7 instanceof Left)) break block8;
                var9_8 = (Left)var8_7;
                err = (ConnectorError)var9_8.value();
                if (!this.config().fileStoreConfig().preventCleanup()) {
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info(new StringBuilder(31).append("Cleaning up all files in path: ").append(address).toString());
                        v3 = BoxedUnit.UNIT;
                    } else {
                        v3 = BoxedUnit.UNIT;
                    }
                    v4 = this.fileStoreLayer().removeDir(address);
                } else {
                    v4 = BoxedUnit.UNIT;
                }
                var2_10 = package$.MODULE$.Left().apply((Object)err);
                break block9;
            }
            if (!(var8_7 instanceof Right)) ** GOTO lbl-1000
            var11_11 = (Right)var8_7;
            var12_12 = (BoxedUnit)var11_11.value();
            v5 = BoxedUnit.UNIT;
            var13_13 = var12_12;
            if (!(v5 != null ? v5.equals(var13_13) == false : var13_13 != null)) {
                var2_10 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError(var8_7);
            }
        }
        return var2_10;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> writeData(DataBlock data) {
        Either<ConnectorError, BoxedUnit> either;
        Option<CreateExternalTableOption> option = this.config().createExternalTable();
        if (option instanceof Some) {
            Either<ConnectorError, BoxedUnit> either2;
            Some some = (Some)option;
            CreateExternalTableOption value = (CreateExternalTableOption)some.value();
            CreateExternalTableOption createExternalTableOption = value;
            if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                either2 = package$.MODULE$.Left().apply((Object)new NonEmptyDataFrameError());
            } else if (NewData$.MODULE$.equals(createExternalTableOption)) {
                either2 = this.fileStoreLayer().writeDataToParquetFile(data);
            } else {
                throw new MatchError((Object)createExternalTableOption);
            }
            either = either2;
        } else if (None$.MODULE$.equals(option)) {
            either = this.fileStoreLayer().writeDataToParquetFile(data);
        } else {
            throw new MatchError(option);
        }
        return either;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> endPartitionWrite() {
        Either<ConnectorError, BoxedUnit> either;
        Option<CreateExternalTableOption> option = this.config().createExternalTable();
        if (option instanceof Some) {
            Either<ConnectorError, BoxedUnit> either2;
            Some some = (Some)option;
            CreateExternalTableOption value = (CreateExternalTableOption)some.value();
            CreateExternalTableOption createExternalTableOption = value;
            if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                either2 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else if (NewData$.MODULE$.equals(createExternalTableOption)) {
                either2 = this.fileStoreLayer().closeWriteParquetFile();
            } else {
                throw new MatchError((Object)createExternalTableOption);
            }
            either = either2;
        } else if (None$.MODULE$.equals(option)) {
            either = this.fileStoreLayer().closeWriteParquetFile();
        } else {
            throw new MatchError(option);
        }
        return either;
    }

    public String buildCopyStatement(String targetTable, String columnList, String url, String rejectsTableName, String fileFormat) {
        return this.config().mergeKey().isDefined() ? new StringBuilder(60).append("COPY ").append(targetTable).append(" FROM '").append(url).append("' ON ANY NODE ").append(fileFormat).append(" REJECTED DATA AS TABLE ").append(rejectsTableName).append(" NO COMMIT").toString() : new StringBuilder(61).append("COPY ").append(targetTable).append(" ").append(columnList).append(" FROM '").append(url).append("' ON ANY NODE ").append(fileFormat).append(" REJECTED DATA AS TABLE ").append(rejectsTableName).append(" NO COMMIT").toString();
    }

    public String buildMergeStatement(TableName targetTableName, String columnList, String tempTable) {
        Object object;
        String string;
        String string2;
        String targetTable = targetTableName.getFullTableName();
        Either<ConnectorError, String> either = this.schemaTools().getMergeUpdateValues(this.jdbcLayer(), targetTableName, this.tempTableName(), this.config().copyColumnList());
        if (either instanceof Right) {
            String values;
            Right right = (Right)either;
            string2 = values = (String)right.value();
        } else if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            string2 = package$.MODULE$.Left().apply((Object)new MergeColumnListError(err));
        } else {
            throw new MatchError(either);
        }
        String updateColValues = string2;
        Either<ConnectorError, String> either2 = this.schemaTools().getMergeInsertValues(this.jdbcLayer(), this.tempTableName(), this.config().copyColumnList());
        if (either2 instanceof Right) {
            String values;
            Right right = (Right)either2;
            string = values = (String)right.value();
        } else if (either2 instanceof Left) {
            Left left = (Left)either2;
            ConnectorError err = (ConnectorError)left.value();
            string = package$.MODULE$.Left().apply((Object)new MergeColumnListError(err));
        } else {
            throw new MatchError(either2);
        }
        String insertColValues = string;
        Option<ValidColumnList> option = this.config().mergeKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            ValidColumnList key = (ValidColumnList)some.value();
            List trimmedCols = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])key.toString().split(","))).toList().map((Function1 & Serializable & scala.Serializable)col -> col.trim(), List$.MODULE$.canBuildFrom());
            object = ((TraversableOnce)trimmedCols.map((Function1 & Serializable & scala.Serializable)trimmedCol -> new StringBuilder(13).append("target.").append((String)trimmedCol).append("=temp.").append((String)trimmedCol).toString(), List$.MODULE$.canBuildFrom())).mkString(" AND ");
        } else if (None$.MODULE$.equals(option)) {
            object = Nil$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        Nil$ mergeList = object;
        return new StringBuilder(112).append("MERGE INTO ").append(targetTable).append(" as target using ").append(tempTable).append(" as temp ON (").append(mergeList).append(") WHEN MATCHED THEN UPDATE SET ").append((Object)updateColValues).append(" WHEN NOT MATCHED THEN INSERT ").append(columnList).append(" VALUES (").append((Object)insertColValues).append(")").toString();
    }

    public Either<ConnectorError, BoxedUnit> performMerge(String mergeStatement) {
        BoxedUnit boxedUnit;
        Either ret = this.jdbcLayer().query(new StringBuilder(8).append("EXPLAIN ").append(mergeStatement).toString(), this.jdbcLayer().query$default$2()).map((Function1 & Serializable & scala.Serializable)rs -> {
            rs.close();
            BoxedUnit x$6 = BoxedUnit.UNIT;
            return new Tuple2(rs, (Object)x$6);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Either either = this.jdbcLayer().execute(mergeStatement, this.jdbcLayer().execute$default$2()).map((Function1 & Serializable & scala.Serializable)_ -> {
                VerticaDistributedFilesystemWritePipe.$anonfun$performMerge$3(_);
                return BoxedUnit.UNIT;
            });
            return either;
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Executing merge");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ret.left().map((Function1 & Serializable & scala.Serializable)err -> new CommitError((ConnectorError)err).context("performMerge: JDBC error when trying to merge"));
    }

    public Either<ConnectorError, String> inferExternalTableSchema() {
        Left left;
        BoxedUnit boxedUnit;
        String string;
        String tableName = this.config().tablename().getFullTableName().replaceAll("\"", "");
        Either<ConnectorError, Seq<String>> either = this.fileStoreLayer().getGlobStatus(EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(10).append(new StringOps(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress())).stripSuffix("/")).append("/*.parquet").toString(), EscapeUtils$.MODULE$.sqlEscape$default$2()));
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq list = (Seq)right.value();
            String url = list.nonEmpty() ? EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(10).append(new StringOps(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress())).stripSuffix("/")).append("/*.parquet").toString(), EscapeUtils$.MODULE$.sqlEscape$default$2()) : EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(13).append(new StringOps(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress())).stripSuffix("/")).append("/**/*.parquet").toString(), EscapeUtils$.MODULE$.sqlEscape$default$2());
            string = new StringBuilder(38).append("SELECT INFER_EXTERNAL_TABLE_DDL('").append(url).append("','").append(tableName).append("')").toString();
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            string = err.getFullContext();
        } else {
            throw new MatchError(either);
        }
        String inferStatement = string;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(24).append("The infer statement is: ").append(inferStatement).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Either<ConnectorError, ResultSet> either2 = this.jdbcLayer().query(inferStatement, this.jdbcLayer().query$default$2());
        if (either2 instanceof Left) {
            Left left3 = (Left)either2;
            ConnectorError err = (ConnectorError)left3.value();
            left = package$.MODULE$.Left().apply((Object)new InferExternalTableSchemaError(err));
        } else if (either2 instanceof Right) {
            Right right;
            block22: {
                Right right2 = (Right)either2;
                try (ResultSet resultSet = (ResultSet)right2.value();){
                    try {
                        BoxedUnit boxedUnit2;
                        boolean bl = resultSet.next();
                        String createExternalTableStatement = resultSet.getString("INFER_EXTERNAL_TABLE_DDL");
                        boolean isPartitioned = inferStatement.contains(EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(13).append(new StringOps(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress())).stripSuffix("/")).append("/**/*.parquet").toString(), EscapeUtils$.MODULE$.sqlEscape$default$2()));
                        if (!(isPartitioned || createExternalTableStatement.contains("varchar") || createExternalTableStatement.contains("varbinary"))) {
                            BoxedUnit boxedUnit3;
                            BoxedUnit boxedUnit4;
                            if (this.logger().underlying().isInfoEnabled()) {
                                this.logger().underlying().info("Inferring schema from parquet data");
                                boxedUnit4 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit4 = BoxedUnit.UNIT;
                            }
                            String updatedStatement = createExternalTableStatement.replace(new StringBuilder(2).append("\"").append(tableName).append("\"").toString(), tableName);
                            if (this.logger().underlying().isDebugEnabled()) {
                                this.logger().underlying().debug(new StringBuilder(40).append("The create external table statement is: ").append(updatedStatement).toString());
                                boxedUnit3 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit3 = BoxedUnit.UNIT;
                            }
                            right = package$.MODULE$.Right().apply((Object)updatedStatement);
                            break block22;
                        }
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Inferring partial schema from dataframe");
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        right = this.schemaTools().inferExternalTableSchema(createExternalTableStatement, this.config().schema(), tableName, this.config().strlen());
                    }
                    catch (Throwable e) {
                        right = package$.MODULE$.Left().apply((Object)new InferExternalSchemaError(e));
                    }
                }
            }
            left = right;
        } else {
            throw new MatchError(either2);
        }
        return left;
    }

    private Either<ConnectorError, String> getColumnList() {
        Either either;
        Option<ValidColumnList> option = this.config().copyColumnList();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            ValidColumnList list = (ValidColumnList)some.value();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder(66).append("Using custom COPY column list. ").append("Target table: ").append(this.config().tablename().getFullTableName()).append(", ").append("copy_column_list: ").append(list).append(".").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            either = package$.MODULE$.Right().apply((Object)new StringBuilder(2).append("(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])list.toString().split(","))).map((Function1 & Serializable & scala.Serializable)col -> col.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",")).append(")").toString());
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Building default copy column list");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            either = this.schemaTools().getCopyColumnList(this.jdbcLayer(), this.config().tablename(), this.config().schema()).left().map((Function1 & Serializable & scala.Serializable)err -> new SchemaColumnListError((ConnectorError)err).context("getColumnList: Error building default copy column list"));
        } else {
            throw new MatchError(option);
        }
        return either;
    }

    private Either<ConnectorError, FaultToleranceTestResult> testFaultTolerance(int rowsCopied, String rejectsTable) {
        BoxedUnit boxedUnit;
        String rejectsQuery = new StringBuilder(30).append("SELECT COUNT(*) as count FROM ").append(rejectsTable).toString();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(48).append("Checking number of rejected rows via statement: ").append(rejectsQuery).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.jdbcLayer().query(rejectsQuery, this.jdbcLayer().query$default$2()).map((Function1 & Serializable & scala.Serializable)rs -> {
            Try res = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                int n;
                if (rs.next()) {
                    n = rs.getInt("count");
                } else {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Could not retrieve rejected row count.");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    n = 0;
                }
                return n;
            });
            rs.close();
            BoxedUnit x$11 = BoxedUnit.UNIT;
            return new Tuple3(rs, (Object)res, (Object)x$11);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$17 -> {
            Tuple3 tuple3 = x$17;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Try res = (Try)tuple3._2();
            Either either = JdbcUtils$.MODULE$.tryJdbcToResult(this.jdbcLayer(), res).map((Function1 & Serializable & scala.Serializable)rejectedCount -> VerticaDistributedFilesystemWritePipe.$anonfun$testFaultTolerance$4(this, rowsCopied, BoxesRunTime.unboxToInt((Object)rejectedCount))).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> {
                Right right;
                boolean passedFaultToleranceTest;
                double failedRowsPercent;
                Tuple6 tuple6 = x$16;
                if (tuple6 != null) {
                    int rejectedCount = BoxesRunTime.unboxToInt((Object)tuple6._1());
                    failedRowsPercent = BoxesRunTime.unboxToDouble((Object)tuple6._2());
                    passedFaultToleranceTest = BoxesRunTime.unboxToBoolean((Object)tuple6._3());
                    if (rejectedCount == 0) {
                        BoxedUnit boxedUnit;
                        String dropRejectsTableStatement = new StringBuilder(29).append("DROP TABLE IF EXISTS ").append(rejectsTable).append(" CASCADE").toString();
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info(new StringBuilder(36).append("Dropping Vertica rejects table now: ").append(dropRejectsTableStatement).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        right = this.jdbcLayer().execute(dropRejectsTableStatement, this.jdbcLayer().execute$default$2());
                    } else {
                        BoxedUnit boxedUnit;
                        String rejectsDataQuery = new StringBuilder(131).append("SELECT COUNT(*) count, MIN(rejected_data) example_data, rejected_reason FROM ").append(rejectsTable).append(" GROUP BY rejected_reason ORDER BY count DESC LIMIT 10").toString();
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info(new StringBuilder(48).append("Getting summary of rejected rows via statement: ").append(rejectsDataQuery).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.jdbcLayer().query(rejectsDataQuery, this.jdbcLayer().query$default$2()).map((Function1 & Serializable & scala.Serializable)rs -> {
                            Try x$8 = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                                BoxedUnit boxedUnit;
                                BoxedUnit boxedUnit2;
                                ResultSetMetaData rsmd = rs.getMetaData();
                                if (this.logger().underlying().isErrorEnabled()) {
                                    this.logger().underlying().error("Found {} rejected rows, displaying up to 10 of the most common reasons:", new Object[]{BoxesRunTime.boxToInteger((int)rejectedCount)});
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isErrorEnabled()) {
                                    this.logger().underlying().error(((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), rsmd.getColumnCount()).map((Function1 & Serializable & scala.Serializable)idx -> rsmd.getColumnName(BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).toList().mkString(" | "));
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                while (rs.next()) {
                                    BoxedUnit boxedUnit3;
                                    if (this.logger().underlying().isErrorEnabled()) {
                                        this.logger().underlying().error(((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), rsmd.getColumnCount()).map((Function1 & Serializable & scala.Serializable)idx -> rs.getString(BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).toList().mkString(" | "));
                                        boxedUnit3 = BoxedUnit.UNIT;
                                        continue;
                                    }
                                    boxedUnit3 = BoxedUnit.UNIT;
                                }
                            });
                            rs.close();
                            BoxedUnit x$9 = BoxedUnit.UNIT;
                            return new Tuple3(rs, (Object)x$8, (Object)x$9);
                        }).map((Function1 & Serializable & scala.Serializable)x$10 -> {
                            VerticaDistributedFilesystemWritePipe.$anonfun$testFaultTolerance$10(x$10);
                            return BoxedUnit.UNIT;
                        });
                        right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    }
                } else {
                    throw new MatchError((Object)tuple6);
                }
                Either either = right.map((Function1 & Serializable & scala.Serializable)x$14 -> {
                    FaultToleranceTestResult testResult = new FaultToleranceTestResult(this, passedFaultToleranceTest, failedRowsPercent);
                    return new Tuple2(x$14, (Object)testResult);
                }).map((Function1 & Serializable & scala.Serializable)x$15 -> {
                    FaultToleranceTestResult testResult;
                    Tuple2 tuple2 = x$15;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    FaultToleranceTestResult faultToleranceTestResult = testResult = (FaultToleranceTestResult)tuple2._2();
                    return faultToleranceTestResult;
                });
                return either;
            });
            return either;
        });
    }

    public Either<ConnectorError, Object> performCopy(String copyStatement, TableName tablename) {
        BoxedUnit boxedUnit;
        String emptyCopy = new StringBuilder(14).append("COPY ").append(tablename.getFullTableName()).append(" FROM '';").toString();
        this.jdbcLayer().executeUpdate(emptyCopy, this.jdbcLayer().executeUpdate$default$2());
        Either ret = this.jdbcLayer().query(new StringBuilder(8).append("EXPLAIN ").append(copyStatement).toString(), this.jdbcLayer().query$default$2()).map((Function1 & Serializable & scala.Serializable)rs -> {
            rs.close();
            BoxedUnit x$18 = BoxedUnit.UNIT;
            return new Tuple2(rs, (Object)x$18);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$19 -> {
            Tuple2 tuple2 = x$19;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Either either = this.jdbcLayer().executeUpdate(copyStatement, this.jdbcLayer().executeUpdate$default$2()).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)rowsCopied -> rowsCopied);
            return either;
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Performing copy from file store to Vertica");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ret.left().map((Function1 & Serializable & scala.Serializable)err -> new CommitError((ConnectorError)err).context("performCopy: JDBC error when trying to copy"));
    }

    /*
     * WARNING - void declaration
     */
    public Either<ConnectorError, BoxedUnit> commitDataIntoVertica(String url) {
        void var3_3;
        BoxedUnit boxedUnit;
        int tableNameMaxLength = 30;
        Either ret = this.jdbcLayer().configureSession(this.fileStoreLayer()).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.getColumnList().left().map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.context("commit: Failed to get column list")).map((Function1 & Serializable & scala.Serializable)columnList -> {
            String tableName = this.config().tablename().name();
            String sessionId = this.config().sessionId();
            return new Tuple3(columnList, (Object)tableName, (Object)sessionId);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$29 -> {
            Tuple3 tuple3 = x$29;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String columnList = (String)tuple3._1();
            String tableName = (String)tuple3._2();
            String sessionId = (String)tuple3._3();
            Either either = (this.config().mergeKey().isDefined() ? this.tableUtils().createTempTable(this.tempTableName(), this.config().schema(), this.config().strlen()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.tableUtils().tempTableExists(this.tempTableName()).flatMap((Function1 & Serializable & scala.Serializable)tempTableExists -> VerticaDistributedFilesystemWritePipe.$anonfun$commitDataIntoVertica$6(this, tableName, tableNameMaxLength, sessionId, columnList, url, BoxesRunTime.unboxToBoolean((Object)tempTableExists))));
            return either;
        }));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Committing data into Vertica.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Either<ConnectorError, BoxedUnit> either = !this.config().fileStoreConfig().preventCleanup() ? this.fileStoreLayer().removeDir(this.config().fileStoreConfig().address()) : BoxedUnit.UNIT;
        return var3_3;
    }

    public Either<ConnectorError, BoxedUnit> commitDataAsExternalTable(String url) {
        Right right;
        Either ret;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Committing data as external table.");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.config().copyColumnList().isDefined()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Custom copy column list was specified, but will be ignored when creating new external table.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Either either = ret = this.jdbcLayer().configureSession(this.fileStoreLayer()).map((Function1 & Serializable & scala.Serializable)x$30 -> {
            boolean bl;
            Option<CreateExternalTableOption> option = this.config().createExternalTable();
            if (option instanceof Some) {
                boolean bl2;
                Some some = (Some)option;
                CreateExternalTableOption value = (CreateExternalTableOption)some.value();
                CreateExternalTableOption createExternalTableOption = value;
                if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                    bl2 = true;
                } else if (NewData$.MODULE$.equals(createExternalTableOption)) {
                    bl2 = false;
                } else {
                    throw new MatchError((Object)createExternalTableOption);
                }
                bl = bl2;
            } else if (None$.MODULE$.equals(option)) {
                bl = false;
            } else {
                throw new MatchError(option);
            }
            boolean existingData = bl;
            return new Tuple2(x$30, (Object)BoxesRunTime.boxToBoolean((boolean)existingData));
        }).flatMap((Function1 & Serializable & scala.Serializable)x$31 -> {
            Tuple2 tuple2 = x$31;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            boolean existingData = tuple2._2$mcZ$sp();
            Either either = (existingData ? this.inferExternalTableSchema() : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)createExternalTableStmt -> this.tableUtils().createExternalTable(this.config().tablename(), (Option<String>)(existingData ? new Some((Object)createExternalTableStmt.toString()) : this.config().targetTableSql()), this.config().schema(), this.config().strlen(), url).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.tableUtils().validateExternalTable(this.config().tablename()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.tableUtils().updateJobStatusTable(this.config().tablename(), this.config().jdbcConfig().auth().user(), 0.0, this.config().sessionId(), true).map((Function1 & Serializable & scala.Serializable)_ -> {
                VerticaDistributedFilesystemWritePipe.$anonfun$commitDataAsExternalTable$6(_);
                return BoxedUnit.UNIT;
            }))));
            return either;
        });
        if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            this.tableUtils().dropTable(this.config().tablename());
            right = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError((Object)either);
        }
        return right;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> commit() {
        Either either;
        String globPattern = "*.parquet";
        String url = EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(this.getAddress())).stripSuffix("/")).append("/").append(globPattern).toString(), EscapeUtils$.MODULE$.sqlEscape$default$2());
        Either<ConnectorError, BoxedUnit> ret = this.config().createExternalTable().isDefined() ? this.commitDataAsExternalTable(url) : this.commitDataIntoVertica(url);
        Either<ConnectorError, BoxedUnit> either2 = ret;
        if (either2 instanceof Right) {
            either = this.jdbcLayer().commit().left().map((Function1 & Serializable & scala.Serializable)err -> new CommitError((ConnectorError)err).context("JDBC Error when trying to commit"));
        } else if (either2 instanceof Left) {
            Left left;
            Left left2 = (Left)either2;
            ConnectorError retError = (ConnectorError)left2.value();
            Either<ConnectorError, BoxedUnit> either3 = this.jdbcLayer().rollback();
            if (either3 instanceof Right) {
                left = package$.MODULE$.Left().apply((Object)retError);
            } else if (either3 instanceof Left) {
                Left left3 = (Left)either3;
                ConnectorError err2 = (ConnectorError)left3.value();
                left = package$.MODULE$.Left().apply((Object)retError.context(new StringBuilder(36).append("JDBC Error when trying to rollback: ").append(err2.getFullContext()).toString()));
            } else {
                throw new MatchError(either3);
            }
            either = left;
        } else {
            throw new MatchError(either2);
        }
        Either result = either;
        this.jdbcLayer().close();
        return result;
    }

    private final void FaultToleranceTestResult$lzycompute$1() {
        VerticaDistributedFilesystemWritePipe verticaDistributedFilesystemWritePipe = this;
        synchronized (verticaDistributedFilesystemWritePipe) {
            if (this.FaultToleranceTestResult$module == null) {
                this.FaultToleranceTestResult$module = new VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$doPreWriteSteps$17(BoxedUnit _) {
    }

    public static final /* synthetic */ Either $anonfun$doPreWriteSteps$13(VerticaDistributedFilesystemWritePipe $this, boolean tableExistsPost) {
        return (tableExistsPost || $this.config().createExternalTable().isDefined() ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)new CreateTableError((Option<ConnectorError>)None$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            boolean bl;
            ValidFilePermissions perm = $this.config().filePermissions();
            Option<CreateExternalTableOption> option = $this.config().createExternalTable();
            if (option instanceof Some) {
                boolean bl2;
                Some some = (Some)option;
                CreateExternalTableOption value = (CreateExternalTableOption)some.value();
                CreateExternalTableOption createExternalTableOption = value;
                if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                    bl2 = true;
                } else if (NewData$.MODULE$.equals(createExternalTableOption)) {
                    bl2 = false;
                } else {
                    throw new MatchError((Object)createExternalTableOption);
                }
                bl = bl2;
            } else if (None$.MODULE$.equals(option)) {
                bl = false;
            } else {
                throw new MatchError(option);
            }
            boolean existingData = bl;
            return new Tuple3(x$3, (Object)perm, (Object)BoxesRunTime.boxToBoolean((boolean)existingData));
        }).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple3 tuple3 = x$4;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            ValidFilePermissions perm = (ValidFilePermissions)tuple3._2();
            boolean existingData = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            Either either = (existingData ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : $this.fileStoreLayer().createDir($this.getAddress(), perm.toString())).flatMap((Function1 & Serializable & scala.Serializable)_2 -> $this.tableUtils().createAndInitJobStatusTable($this.config().tablename(), $this.config().jdbcConfig().auth().user(), $this.config().sessionId(), $this.config().isOverwrite() ? "OVERWRITE" : "APPEND").map((Function1 & Serializable & scala.Serializable)_ -> {
                VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$17(_);
                return BoxedUnit.UNIT;
            }));
            return either;
        });
    }

    public static final /* synthetic */ Either $anonfun$doPreWriteSteps$10(VerticaDistributedFilesystemWritePipe $this, boolean tableExistsPre$1, boolean tempTableExists) {
        return (tempTableExists ? package$.MODULE$.Left().apply((Object)new TempTableExistsError()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> (!tableExistsPre$1 && $this.config().createExternalTable().isEmpty() ? $this.tableUtils().createTable($this.config().tablename(), $this.config().targetTableSql(), $this.config().schema(), $this.config().strlen()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.tableUtils().tableExists($this.config().tablename()).flatMap((Function1 & Serializable & scala.Serializable)tableExistsPost -> VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$13($this, BoxesRunTime.unboxToBoolean((Object)tableExistsPost)))));
    }

    public static final /* synthetic */ Either $anonfun$doPreWriteSteps$8(VerticaDistributedFilesystemWritePipe $this, boolean tableExistsPre$1, boolean viewExists) {
        return (viewExists ? package$.MODULE$.Left().apply((Object)new ViewExistsError()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.tableUtils().tempTableExists($this.config().tablename()).flatMap((Function1 & Serializable & scala.Serializable)tempTableExists -> VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$10($this, tableExistsPre$1, BoxesRunTime.unboxToBoolean((Object)tempTableExists))));
    }

    public static final /* synthetic */ Either $anonfun$doPreWriteSteps$5(VerticaDistributedFilesystemWritePipe $this, boolean tableExistsPre) {
        return ($this.config().isOverwrite() && $this.config().mergeKey().isEmpty() && tableExistsPre ? package$.MODULE$.Left().apply((Object)new DropTableError()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> ($this.config().createExternalTable().isDefined() && tableExistsPre ? package$.MODULE$.Left().apply((Object)new CreateExternalTableAlreadyExistsError()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.tableUtils().viewExists($this.config().tablename()).flatMap((Function1 & Serializable & scala.Serializable)viewExists -> VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$8($this, tableExistsPre, BoxesRunTime.unboxToBoolean((Object)viewExists)))));
    }

    public static final /* synthetic */ void $anonfun$performMerge$3(BoxedUnit _) {
    }

    public static final /* synthetic */ Tuple6 $anonfun$testFaultTolerance$4(VerticaDistributedFilesystemWritePipe $this, int rowsCopied$1, int rejectedCount) {
        BoxedUnit boxedUnit;
        BoxedUnit x$12;
        BoxedUnit boxedUnit2;
        double failedRowsPercent = rowsCopied$1 > 0 ? (double)rejectedCount / ((double)rowsCopied$1 + (double)rejectedCount) : 1.0;
        boolean passedFaultToleranceTest = failedRowsPercent <= (double)$this.config().failedRowPercentTolerance();
        String tolerance_message = new StringBuilder(124).append("Number of rows_rejected=").append(rejectedCount).append(". rows_copied=").append(rowsCopied$1).append(". failedRowsPercent=").append(failedRowsPercent).append(". user's failed_rows_percent_tolerance=").append($this.config().failedRowPercentTolerance()).append(". passedFaultToleranceTest=").append(((Object)BoxesRunTime.boxToBoolean((boolean)passedFaultToleranceTest)).toString()).toString();
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Verifying rows saved to Vertica is within user tolerance...");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = x$12 = BoxedUnit.UNIT;
        }
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info(new StringBuilder(0).append(tolerance_message).append((Object)(passedFaultToleranceTest ? "...PASSED.  OK to commit to database." : "...FAILED.  NOT OK to commit to database")).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit x$13 = boxedUnit;
        return new Tuple6((Object)BoxesRunTime.boxToInteger((int)rejectedCount), (Object)BoxesRunTime.boxToDouble((double)failedRowsPercent), (Object)BoxesRunTime.boxToBoolean((boolean)passedFaultToleranceTest), (Object)tolerance_message, (Object)x$12, (Object)x$13);
    }

    public static final /* synthetic */ void $anonfun$testFaultTolerance$10(Tuple3 x$10) {
        Tuple3 tuple3 = x$10;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$commitDataIntoVertica$20(BoxedUnit _) {
    }

    public static final /* synthetic */ Either $anonfun$commitDataIntoVertica$13(VerticaDistributedFilesystemWritePipe $this, String rejectsTableName$1, String columnList$1, int rowsCopied) {
        return $this.testFaultTolerance(rowsCopied, rejectsTableName$1).left().map((Function1 & Serializable & scala.Serializable)err -> new CommitError((ConnectorError)err).context("commit: JDBC Error when trying to determine fault tolerance")).flatMap((Function1 & Serializable & scala.Serializable)faultToleranceResults -> $this.tableUtils().updateJobStatusTable($this.config().tablename(), $this.config().jdbcConfig().auth().user(), faultToleranceResults.failedRowsPercent(), $this.config().sessionId(), faultToleranceResults.success()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> (faultToleranceResults.success() ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)new FaultToleranceTestFail())).flatMap((Function1 & Serializable & scala.Serializable)_ -> ($this.config().mergeKey().isDefined() ? package$.MODULE$.Right().apply((Object)$this.buildMergeStatement($this.config().tablename(), columnList$1, $this.tempTableName().getFullTableName())) : package$.MODULE$.Right().apply((Object)"")).map((Function1 & Serializable & scala.Serializable)mergeStatement -> {
            BoxedUnit boxedUnit;
            if ($this.config().mergeKey().isDefined()) {
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info(new StringBuilder(25).append("The merge statement is: \n").append((String)mergeStatement).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$25 = boxedUnit;
            return new Tuple2(mergeStatement, (Object)x$25);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$26 -> {
            Tuple2 tuple2 = x$26;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String mergeStatement = (String)tuple2._1();
            Either either = ($this.config().mergeKey().isDefined() ? $this.performMerge(mergeStatement) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).map((Function1 & Serializable & scala.Serializable)_ -> {
                VerticaDistributedFilesystemWritePipe.$anonfun$commitDataIntoVertica$20(_);
                return BoxedUnit.UNIT;
            });
            return either;
        }))));
    }

    public static final /* synthetic */ Either $anonfun$commitDataIntoVertica$6(VerticaDistributedFilesystemWritePipe $this, String tableName$1, int tableNameMaxLength$1, String sessionId$1, String columnList$1, String url$1, boolean tempTableExists) {
        return ($this.config().mergeKey().isDefined() && !tempTableExists ? package$.MODULE$.Left().apply((Object)new CreateTableError((Option<ConnectorError>)None$.MODULE$)) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).map((Function1 & Serializable & scala.Serializable)x$23 -> {
            String rejectsTableName = new StringBuilder(11).append("\"").append(EscapeUtils$.MODULE$.sqlEscape(tableName$1.substring(0, Math.min(tableNameMaxLength$1, tableName$1.length())), EscapeUtils$.MODULE$.sqlEscape$default$2())).append("_").append(sessionId$1).append("_COMMITS").append("\"").toString();
            return new Tuple2(x$23, (Object)rejectsTableName);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$28 -> {
            Tuple2 tuple2 = x$28;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String rejectsTableName = (String)tuple2._2();
            Either either = ($this.config().mergeKey().isDefined() ? package$.MODULE$.Right().apply((Object)$this.tempTableName().getFullTableName()) : package$.MODULE$.Right().apply((Object)$this.config().tablename().getFullTableName())).map((Function1 & Serializable & scala.Serializable)fullTableName -> {
                BoxedUnit boxedUnit;
                String copyStatement = $this.buildCopyStatement((String)fullTableName, columnList$1, url$1, rejectsTableName, "parquet");
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info(new StringBuilder(24).append("The copy statement is: \n").append(copyStatement).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit x$24 = boxedUnit;
                return new Tuple3(fullTableName, (Object)copyStatement, (Object)x$24);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$27 -> {
                Tuple3 tuple3 = x$27;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                String copyStatement = (String)tuple3._2();
                Either either = ($this.config().mergeKey().isDefined() ? $this.performCopy(copyStatement, $this.tempTableName()).left().map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.context("commit: Failed to copy rows into temp table")) : $this.performCopy(copyStatement, $this.config().tablename()).left().map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.context("commit: Failed to copy rows into target table"))).flatMap((Function1 & Serializable & scala.Serializable)rowsCopied -> VerticaDistributedFilesystemWritePipe.$anonfun$commitDataIntoVertica$13($this, rejectsTableName, columnList$1, BoxesRunTime.unboxToInt((Object)rowsCopied)));
                return either;
            });
            return either;
        });
    }

    public static final /* synthetic */ void $anonfun$commitDataAsExternalTable$6(BoxedUnit _) {
    }

    public VerticaDistributedFilesystemWritePipe(DistributedFilesystemWriteConfig config, FileStoreLayerInterface fileStoreLayer, JdbcLayerInterface jdbcLayer, SchemaToolsInterface schemaTools, TableUtilsInterface tableUtils, int dataSize) {
        this.config = config;
        this.fileStoreLayer = fileStoreLayer;
        this.jdbcLayer = jdbcLayer;
        this.schemaTools = schemaTools;
        this.tableUtils = tableUtils;
        this.dataSize = dataSize;
        this.logger = LogProvider$.MODULE$.getLogger(VerticaDistributedFilesystemWritePipe.class);
        this.tempTableName = new TableName(new StringBuilder(1).append(config.tablename().name()).append("_").append(config.sessionId()).toString(), (Option<String>)None$.MODULE$);
        this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE = "spark.sql.legacy.parquet.datetimeRebaseModeInWrite";
        this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE = "spark.sql.legacy.parquet.int96RebaseModeInWrite";
    }

    public class FaultToleranceTestResult
    implements Product,
    scala.Serializable {
        private final boolean success;
        private final double failedRowsPercent;
        public final /* synthetic */ VerticaDistributedFilesystemWritePipe $outer;

        public boolean success() {
            return this.success;
        }

        public double failedRowsPercent() {
            return this.failedRowsPercent;
        }

        public FaultToleranceTestResult copy(boolean success, double failedRowsPercent) {
            return new FaultToleranceTestResult(this.com$vertica$spark$datasource$core$VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$$$outer(), success, failedRowsPercent);
        }

        public boolean copy$default$1() {
            return this.success();
        }

        public double copy$default$2() {
            return this.failedRowsPercent();
        }

        public String productPrefix() {
            return "FaultToleranceTestResult";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Comparable<Boolean> comparable;
            int n = x$1;
            switch (n) {
                case 0: {
                    comparable = BoxesRunTime.boxToBoolean((boolean)this.success());
                    break;
                }
                case 1: {
                    comparable = BoxesRunTime.boxToDouble((double)this.failedRowsPercent());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return comparable;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FaultToleranceTestResult;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)(this.success() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.failedRowsPercent()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FaultToleranceTestResult)) return false;
            if (((FaultToleranceTestResult)object).com$vertica$spark$datasource$core$VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$$$outer() != this.com$vertica$spark$datasource$core$VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FaultToleranceTestResult faultToleranceTestResult = (FaultToleranceTestResult)x$1;
            if (this.success() != faultToleranceTestResult.success()) return false;
            if (this.failedRowsPercent() != faultToleranceTestResult.failedRowsPercent()) return false;
            if (!faultToleranceTestResult.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ VerticaDistributedFilesystemWritePipe com$vertica$spark$datasource$core$VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$$$outer() {
            return this.$outer;
        }

        public FaultToleranceTestResult(VerticaDistributedFilesystemWritePipe $outer, boolean success, double failedRowsPercent) {
            this.success = success;
            this.failedRowsPercent = failedRowsPercent;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

