/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.fs;

import cats.Applicative;
import cats.implicits$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.AWSArg;
import com.vertica.spark.config.AWSAuth;
import com.vertica.spark.config.AWSOptions;
import com.vertica.spark.config.FileStoreConfig;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.datasource.core.DataBlock;
import com.vertica.spark.datasource.core.ParquetFileRange;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.fs.HadoopFileStoreReader;
import com.vertica.spark.datasource.fs.ParquetFileMetadata;
import com.vertica.spark.util.error.CloseWriteError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.CreateDirectoryAlreadyExistsError;
import com.vertica.spark.util.error.CreateDirectoryError;
import com.vertica.spark.util.error.CreateFileAlreadyExistsError;
import com.vertica.spark.util.error.CreateFileError;
import com.vertica.spark.util.error.FileListError;
import com.vertica.spark.util.error.FileStoreThrownError;
import com.vertica.spark.util.error.IntermediaryStoreReaderNotInitializedError;
import com.vertica.spark.util.error.IntermediaryStoreWriteError;
import com.vertica.spark.util.error.IntermediaryStoreWriterNotInitializedError;
import com.vertica.spark.util.error.MissingHDFSImpersonationTokenError;
import com.vertica.spark.util.error.OpenReadError;
import com.vertica.spark.util.error.OpenWriteError;
import com.vertica.spark.util.error.RemoveDirectoryError;
import com.vertica.spark.util.error.RemoveFileError;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.vertica.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.vertica.ParquetReadSupport$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r\rc\u0001B!C\u00015C\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t?\u0002\u0011\t\u0011)A\u0005A\")\u0001\u000f\u0001C\u0001c\"9Q\u000f\u0001b\u0001\n\u00131\bbBA\u0003\u0001\u0001\u0006Ia\u001e\u0005\t\u0003\u000f\u0001!\u0019!C\u0005m\"9\u0011\u0011\u0002\u0001!\u0002\u00139\b\u0002CA\u0006\u0001\t\u0007I\u0011\u0002<\t\u000f\u00055\u0001\u0001)A\u0005o\"A\u0011q\u0002\u0001C\u0002\u0013%a\u000fC\u0004\u0002\u0012\u0001\u0001\u000b\u0011B<\t\u0011\u0005M\u0001A1A\u0005\nYDq!!\u0006\u0001A\u0003%q\u000f\u0003\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0003w\u0011\u001d\tI\u0002\u0001Q\u0001\n]D\u0011\"a\u0007\u0001\u0005\u0004%\t!!\b\t\u0011\u0005=\u0002\u0001)A\u0005\u0003?A\u0011\"!\r\u0001\u0005\u0004%I!a\r\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003kA\u0011\"a\u0012\u0001\u0005\u0004%I!a\r\t\u0011\u0005%\u0003\u0001)A\u0005\u0003kA\u0011\"a\u0013\u0001\u0005\u0004%I!a\r\t\u0011\u00055\u0003\u0001)A\u0005\u0003kA\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005\u0005\u0004\u0001)A\u0005\u0003'B\u0011\"a\u0019\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005\u0015\u0004\u0001)A\u0005\u0003'B\u0011\"a\u001a\u0001\u0005\u0004%I!!\u0015\t\u0011\u0005%\u0004\u0001)A\u0005\u0003'B\u0011\"a\u001b\u0001\u0001\u0004%I!!\u001c\t\u0013\u0005-\u0005\u00011A\u0005\n\u00055\u0005\u0002CAM\u0001\u0001\u0006K!a\u001c\t\u0013\u0005m\u0005\u00011A\u0005\n\u0005u\u0005\"CAT\u0001\u0001\u0007I\u0011BAU\u0011!\ti\u000b\u0001Q!\n\u0005}\u0005\"CAX\u0001\t\u0007I\u0011AAY\u0011!\ty\f\u0001Q\u0001\n\u0005M\u0006\"CAa\u0001\t\u0007I\u0011BAb\u0011!\tY\r\u0001Q\u0001\n\u0005\u0015\u0007\"CAg\u0001\t\u0007I\u0011BAh\u0011!\tI\u000e\u0001Q\u0001\n\u0005EgABAn\u0001\u0011\ti\u000e\u0003\u0006\u0002r*\u0012\t\u0011)A\u0005\u0003gDa\u0001\u001d\u0016\u0005\u0002\u0005u\bb\u0002B\u0001U\u0011E#1\u0001\u0005\b\u0005\u000bQC\u0011\u0003B\u0004\u0011\u001d\u0011i\u0002\u0001C\u0001\u0005?AqAa\u0014\u0001\t\u0003\u0012\t\u0006C\u0004\u0003d\u0001!\tE!\u001a\t\u000f\t\u001d\u0004\u0001\"\u0003\u0003j!9!q\u0014\u0001\u0005B\t\u0005\u0006b\u0002BW\u0001\u0011\u0005#q\u0016\u0005\b\u0005s\u0003A\u0011\tB^\u0011\u001d\u0011I\r\u0001C!\u0005KBqAa3\u0001\t\u0003\u0012i\rC\u0004\u0003f\u0002!\tEa:\t\u000f\t-\b\u0001\"\u0011\u0003n\"9!\u0011\u001f\u0001\u0005B\tM\bb\u0002B|\u0001\u0011\u0005#\u0011 \u0005\b\u0007\u0003\u0001A\u0011AB\u0002\u0011\u001d\u0019y\u0001\u0001C!\u0007#Aqa!\u0007\u0001\t\u0003\u001aY\u0002C\u0004\u0004\"\u0001!\t%a1\t\u000f\r\r\u0002\u0001\"\u0003\u0004&\t!\u0002*\u00193p_B4\u0015\u000e\\3Ti>\u0014X\rT1zKJT!a\u0011#\u0002\u0005\u0019\u001c(BA#G\u0003)!\u0017\r^1t_V\u00148-\u001a\u0006\u0003\u000f\"\u000bQa\u001d9be.T!!\u0013&\u0002\u000fY,'\u000f^5dC*\t1*A\u0002d_6\u001c\u0001aE\u0002\u0001\u001dR\u0003\"a\u0014*\u000e\u0003AS\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u0013a!\u00118z%\u00164\u0007CA+W\u001b\u0005\u0011\u0015BA,C\u0005]1\u0015\u000e\\3Ti>\u0014X\rT1zKJLe\u000e^3sM\u0006\u001cW-A\bgS2,7\u000b^8sK\u000e{gNZ5h!\tQV,D\u0001\\\u0015\taf)\u0001\u0004d_:4\u0017nZ\u0005\u0003=n\u0013qBR5mKN#xN]3D_:4\u0017nZ\u0001\u0007g\u000eDW-\\1\u0011\u0007=\u000b7-\u0003\u0002c!\n1q\n\u001d;j_:\u0004\"\u0001\u001a8\u000e\u0003\u0015T!AZ4\u0002\u000bQL\b/Z:\u000b\u0005!L\u0017aA:rY*\u0011qI\u001b\u0006\u0003W2\fa!\u00199bG\",'\"A7\u0002\u0007=\u0014x-\u0003\u0002pK\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\rqJg.\u001b;?)\r\u00118\u000f\u001e\t\u0003+\u0002AQ\u0001W\u0002A\u0002eCQaX\u0002A\u0002\u0001\fQbU\u001a`\u0003\u000e\u001bUiU*`\u0017\u0016KV#A<\u0011\u0005a|hBA=~!\tQ\b+D\u0001|\u0015\taH*\u0001\u0004=e>|GOP\u0005\u0003}B\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0001\u0003\u0007\u0011aa\u0015;sS:<'B\u0001@Q\u00039\u00196gX!D\u0007\u0016\u001b6kX&F3\u0002\nQbU\u001a`'\u0016\u001b%+\u0012+`\u0017\u0016K\u0016AD*4?N+5IU#U?.+\u0015\fI\u0001\u0011'Nz6+R*T\u0013>su\fV(L\u000b:\u000b\u0011cU\u001a`'\u0016\u001b6+S(O?R{5*\u0012(!\u0003a\tukU0D%\u0016#UI\u0014+J\u00032\u001bv\f\u0015*P-&#UIU\u0001\u001a\u0003^\u001bvl\u0011*F\t\u0016sE+S!M'~\u0003&k\u0014,J\t\u0016\u0013\u0006%A\u0006Tg}+e\n\u0012)P\u0013:#\u0016\u0001D*4?\u0016sE\tU(J\u001dR\u0003\u0013!D*4?\u0016s\u0015I\u0011'F?N\u001bF*\u0001\bTg}+e*\u0011\"M\u000b~\u001b6\u000b\u0014\u0011\u0002\r1|wmZ3s+\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0007\u0005%\"*\u0001\u0005usB,7/\u00194f\u0013\u0011\ti#a\t\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nQdV#C\u0011\u001235k\u0018#F\u0019\u0016;\u0015\tV%P\u001d~#vjS#O?R+\u0005\fV\u000b\u0003\u0003k\u0001B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0002j_*\u0019\u0011q\b6\u0002\r!\fGm\\8q\u0013\u0011\t\u0019%!\u000f\u0003\tQ+\u0007\u0010^\u0001\u001f/\u0016\u0013\u0005\n\u0012$T?\u0012+E*R$B)&{ej\u0018+P\u0017\u0016su\fV#Y)\u0002\nadU,F\u0005\"#eiU0E\u000b2+u)\u0011+J\u001f:{FkT&F\u001d~#V\t\u0017+\u0002?M;VI\u0011%E\rN{F)\u0012'F\u000f\u0006#\u0016j\u0014(`)>[UIT0U\u000bb#\u0006%\u0001\u000eI\t\u001a\u001bv\fR#M\u000b\u001e\u000bE+S(O?R{5*\u0012(`)\u0016CF+A\u000eI\t\u001a\u001bv\fR#M\u000b\u001e\u000bE+S(O?R{5*\u0012(`)\u0016CF\u000bI\u0001$\u0019\u0016;\u0015iQ-`!\u0006\u0013\u0016+V#U?J+%)Q*F?6{E)R0J\u001d~;&+\u0013+F+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\t1\fgn\u001a\u0006\u0003\u0003;\nAA[1wC&!\u0011\u0011AA,\u0003\u0011bUiR!D3~\u0003\u0016IU)V\u000bR{&+\u0012\"B'\u0016{Vj\u0014#F?&sul\u0016*J)\u0016\u0003\u0013A\t'F\u000f\u0006\u001b\u0015l\u0018)B%F+V\tV0S\u000b\n\u000b5+R0N\u001f\u0012+u,\u0013(`%\u0016\u000bE)A\u0012M\u000b\u001e\u000b5)W0Q\u0003J\u000bV+\u0012+`%\u0016\u0013\u0015iU#`\u001b>#UiX%O?J+\u0015\t\u0012\u0011\u0002S1+u)Q\"Z?B\u000b%+U+F)~Ke\nV\u001d7?J+%)Q*F?6{E)R0J\u001d~;&+\u0013+F\u0003)bUiR!D3~\u0003\u0016IU)V\u000bR{\u0016J\u0014+:m}\u0013VIQ!T\u000b~ku\nR#`\u0013:{vKU%U\u000b\u0002\naa\u001e:ji\u0016\u0014XCAA8!\u0011y\u0015-!\u001d\u0011\r\u0005M\u00141PA@\u001b\t\t)H\u0003\u0003\u0002@\u0005]$bAA=U\u00069\u0001/\u0019:rk\u0016$\u0018\u0002BA?\u0003k\u0012Q\u0002U1scV,Go\u0016:ji\u0016\u0014\b\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015u-\u0001\u0005dCR\fG._:u\u0013\u0011\tI)a!\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u000boJLG/\u001a:`I\u0015\fH\u0003BAH\u0003+\u00032aTAI\u0013\r\t\u0019\n\u0015\u0002\u0005+:LG\u000fC\u0005\u0002\u0018~\t\t\u00111\u0001\u0002p\u0005\u0019\u0001\u0010J\u0019\u0002\u000f]\u0014\u0018\u000e^3sA\u00051!/Z1eKJ,\"!a(\u0011\t=\u000b\u0017\u0011\u0015\t\u0004+\u0006\r\u0016bAAS\u0005\n)\u0002*\u00193p_B4\u0015\u000e\\3Ti>\u0014XMU3bI\u0016\u0014\u0018A\u0003:fC\u0012,'o\u0018\u0013fcR!\u0011qRAV\u0011%\t9JIA\u0001\u0002\u0004\ty*A\u0004sK\u0006$WM\u001d\u0011\u0002\u0015!$gm]\"p]\u001aLw-\u0006\u0002\u00024B!\u0011QWA^\u001b\t\t9L\u0003\u0003\u0002:\u0006u\u0012\u0001B2p]\u001aLA!!0\u00028\ni1i\u001c8gS\u001e,(/\u0019;j_:\f1\u0002\u001b3gg\u000e{gNZ5hA\u0005Q\u0011m^:PaRLwN\\:\u0016\u0005\u0005\u0015\u0007c\u0001.\u0002H&\u0019\u0011\u0011Z.\u0003\u0015\u0005;6k\u00149uS>t7/A\u0006boN|\u0005\u000f^5p]N\u0004\u0013aB1xg\u0006+H\u000f[\u000b\u0003\u0003#\u0004BaT1\u0002TB\u0019!,!6\n\u0007\u0005]7LA\u0004B/N\u000bU\u000f\u001e5\u0002\u0011\u0005<8/Q;uQ\u0002\u0012QCV3si&\u001c\u0017\rU1scV,GOQ;jY\u0012,'oE\u0002+\u0003?\u0004\u0002\"!9\u0002h\u0006}\u0014Q\u001e\b\u0005\u0003g\n\u0019/\u0003\u0003\u0002f\u0006U\u0014!\u0004)beF,X\r^,sSR,'/\u0003\u0003\u0002j\u0006-(a\u0002\"vS2$WM\u001d\u0006\u0005\u0003K\f)\bE\u0002\u0002p*j\u0011\u0001A\u0001\u0005M&dW\r\u0005\u0003\u0002v\u0006eXBAA|\u0015\r\u0019\u0015QH\u0005\u0005\u0003w\f9P\u0001\u0003QCRDG\u0003BAw\u0003\u007fDq!!=-\u0001\u0004\t\u00190\u0001\u0003tK24GCAAw\u0003=9W\r^,sSR,7+\u001e9q_J$H\u0003\u0002B\u0005\u00057\u0001BAa\u0003\u0003\u00185\u0011!Q\u0002\u0006\u0005\u0003s\u0012yA\u0003\u0003\u0003\u0012\tM\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT1A!\u0006h\u0003%)\u00070Z2vi&|g.\u0003\u0003\u0003\u001a\t5!a\u0005)beF,X\r^,sSR,7+\u001e9q_J$\bbBA]]\u0001\u0007\u00111W\u0001\u0015_B,gn\u0016:ji\u0016\u0004\u0016M]9vKR4\u0015\u000e\\3\u0015\t\t\u0005\"1\n\t\u0007\u0005G\u0011)%a$\u000f\t\t\u0015\"q\b\b\u0005\u0005O\u0011ID\u0004\u0003\u0003*\tUb\u0002\u0002B\u0016\u0005gqAA!\f\u000329\u0019!Pa\f\n\u0003-K!!\u0013&\n\u0005\u001dC\u0015b\u0001B\u001c\r\u0006!Q\u000f^5m\u0013\u0011\u0011YD!\u0010\u0002\u000b\u0015\u0014(o\u001c:\u000b\u0007\t]b)\u0003\u0003\u0003B\t\r\u0013!D#se>\u0014\b*\u00198eY&twM\u0003\u0003\u0003<\tu\u0012\u0002\u0002B$\u0005\u0013\u0012qbQ8o]\u0016\u001cGo\u001c:SKN,H\u000e\u001e\u0006\u0005\u0005\u0003\u0012\u0019\u0005\u0003\u0004\u0003N=\u0002\ra^\u0001\tM&dWM\\1nK\u00061rO]5uK\u0012\u000bG/\u0019+p!\u0006\u0014\u0018/^3u\r&dW\r\u0006\u0003\u0003\"\tM\u0003b\u0002B+a\u0001\u0007!qK\u0001\nI\u0006$\u0018M\u00117pG.\u0004BA!\u0017\u0003`5\u0011!1\f\u0006\u0004\u0005;\"\u0015\u0001B2pe\u0016LAA!\u0019\u0003\\\tIA)\u0019;b\u00052|7m[\u0001\u0016G2|7/Z,sSR,\u0007+\u0019:rk\u0016$h)\u001b7f)\t\u0011\t#A\u0007u_N+G/T;mi&l\u0015\r]\u000b\u0007\u0005W\u0012YH!&\u0015\t\t5$\u0011\u0014\t\t\u0005_\u0012\u0019Ha\u001e\u0003\u000e6\u0011!\u0011\u000f\u0006\u0005\u0005o\tY&\u0003\u0003\u0003v\tE$aA'baB!!\u0011\u0010B>\u0019\u0001!qA! 3\u0005\u0004\u0011yHA\u0001L#\u0011\u0011\tIa\"\u0011\u0007=\u0013\u0019)C\u0002\u0003\u0006B\u0013qAT8uQ&tw\rE\u0002P\u0005\u0013K1Aa#Q\u0005\r\te.\u001f\t\u0007\u0005_\u0012yIa%\n\t\tE%\u0011\u000f\u0002\u0004'\u0016$\b\u0003\u0002B=\u0005+#qAa&3\u0005\u0004\u0011yHA\u0001W\u0011\u001d\u0011YJ\ra\u0001\u0005;\u000b1!\\1q!!\u0011yGa\u001d\u0003x\tM\u0015AF4fiB\u000b'/];fi\u001aKG.Z'fi\u0006$\u0017\r^1\u0015\t\t\r&1\u0016\t\u0007\u0005G\u0011)E!*\u0011\u0007U\u00139+C\u0002\u0003*\n\u00131\u0003U1scV,GOR5mK6+G/\u00193bi\u0006DaA!\u00144\u0001\u00049\u0018aE8qK:\u0014V-\u00193QCJ\fX/\u001a;GS2,G\u0003\u0002B\u0011\u0005cCq!!=5\u0001\u0004\u0011\u0019\f\u0005\u0003\u0003Z\tU\u0016\u0002\u0002B\\\u00057\u0012\u0001\u0003U1scV,GOR5mKJ\u000bgnZ3\u0002/I,\u0017\r\u001a#bi\u00064%o\\7QCJ\fX/\u001a;GS2,G\u0003\u0002B_\u0005\u007f\u0003bAa\t\u0003F\t]\u0003b\u0002Bak\u0001\u0007!1Y\u0001\nE2|7m[*ju\u0016\u00042a\u0014Bc\u0013\r\u00119\r\u0015\u0002\u0004\u0013:$\u0018\u0001F2m_N,'+Z1e!\u0006\u0014\u0018/^3u\r&dW-A\u0006hKR4\u0015\u000e\\3MSN$H\u0003\u0002Bh\u0005G\u0004bAa\t\u0003F\tE\u0007#\u0002Bj\u0005;<h\u0002\u0002Bk\u00053t1A\u001fBl\u0013\u0005\t\u0016b\u0001Bn!\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002Bp\u0005C\u00141aU3r\u0015\r\u0011Y\u000e\u0015\u0005\u0007\u0005\u001b:\u0004\u0019A<\u0002\u0015I,Wn\u001c<f\r&dW\r\u0006\u0003\u0003\"\t%\bB\u0002B'q\u0001\u0007q/A\u0005sK6|g/\u001a#jeR!!\u0011\u0005Bx\u0011\u0019\u0011i%\u000fa\u0001o\u0006Q1M]3bi\u00164\u0015\u000e\\3\u0015\t\t\u0005\"Q\u001f\u0005\u0007\u0005\u001bR\u0004\u0019A<\u0002\u0013\r\u0014X-\u0019;f\t&\u0014HC\u0002B\u0011\u0005w\u0014i\u0010\u0003\u0004\u0003Nm\u0002\ra\u001e\u0005\u0007\u0005\u007f\\\u0004\u0019A<\u0002\u0015A,'/\\5tg&|g.\u0001\u0006gS2,W\t_5tiN$Ba!\u0002\u0004\u000eA1!1\u0005B#\u0007\u000f\u00012aTB\u0005\u0013\r\u0019Y\u0001\u0015\u0002\b\u0005>|G.Z1o\u0011\u0019\u0011i\u0005\u0010a\u0001o\u0006)r-\u001a;J[B,'o]8oCRLwN\u001c+pW\u0016tG\u0003BB\n\u0007+\u0001RAa\t\u0003F]Daaa\u0006>\u0001\u00049\u0018\u0001B;tKJ\fQbZ3u\u000f2|'m\u0015;biV\u001cH\u0003\u0002Bh\u0007;Aaaa\b?\u0001\u00049\u0018a\u00029biR,'O\\\u0001\u000eO\u0016$\u0018iV*PaRLwN\\:\u0002\u001bU\u001cXMR5mKNK8\u000f^3n+\u0011\u00199c!\f\u0015\r\r%2\u0011GB\u001a!\u0019\u0011\u0019C!\u0012\u0004,A!!\u0011PB\u0017\t\u001d\u0019y\u0003\u0011b\u0001\u0005\u007f\u0012\u0011\u0001\u0016\u0005\u0007\u0005\u001b\u0002\u0005\u0019A<\t\u000f\rU\u0002\t1\u0001\u00048\u0005Aam]!di&|g\u000eE\u0005P\u0007s\u0019i$a=\u0004*%\u001911\b)\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003BA{\u0007\u007fIAa!\u0011\u0002x\nQa)\u001b7f'f\u001cH/Z7")
public class HadoopFileStoreLayer
implements FileStoreLayerInterface {
    private final FileStoreConfig fileStoreConfig;
    private final String S3_ACCESS_KEY;
    private final String S3_SECRET_KEY;
    private final String S3_SESSION_TOKEN;
    private final String AWS_CREDENTIALS_PROVIDER;
    private final String S3_ENDPOINT;
    private final String S3_ENABLE_SSL;
    private final Logger logger;
    private final Text WEBHDFS_DELEGATION_TOKEN_TEXT;
    private final Text SWEBHDFS_DELEGATION_TOKEN_TEXT;
    private final Text HDFS_DELEGATION_TOKEN_TEXT;
    private final String LEGACY_PARQUET_REBASE_MODE_IN_WRITE;
    private final String LEGACY_PARQUET_REBASE_MODE_IN_READ;
    private final String LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE;
    private Option<ParquetWriter<InternalRow>> writer;
    private Option<HadoopFileStoreReader> reader;
    private final Configuration hdfsConfig;
    private final AWSOptions awsOptions;
    private final Option<AWSAuth> awsAuth;

    private String S3_ACCESS_KEY() {
        return this.S3_ACCESS_KEY;
    }

    private String S3_SECRET_KEY() {
        return this.S3_SECRET_KEY;
    }

    private String S3_SESSION_TOKEN() {
        return this.S3_SESSION_TOKEN;
    }

    private String AWS_CREDENTIALS_PROVIDER() {
        return this.AWS_CREDENTIALS_PROVIDER;
    }

    private String S3_ENDPOINT() {
        return this.S3_ENDPOINT;
    }

    private String S3_ENABLE_SSL() {
        return this.S3_ENABLE_SSL;
    }

    public Logger logger() {
        return this.logger;
    }

    private Text WEBHDFS_DELEGATION_TOKEN_TEXT() {
        return this.WEBHDFS_DELEGATION_TOKEN_TEXT;
    }

    private Text SWEBHDFS_DELEGATION_TOKEN_TEXT() {
        return this.SWEBHDFS_DELEGATION_TOKEN_TEXT;
    }

    private Text HDFS_DELEGATION_TOKEN_TEXT() {
        return this.HDFS_DELEGATION_TOKEN_TEXT;
    }

    private String LEGACY_PARQUET_REBASE_MODE_IN_WRITE() {
        return this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE;
    }

    private String LEGACY_PARQUET_REBASE_MODE_IN_READ() {
        return this.LEGACY_PARQUET_REBASE_MODE_IN_READ;
    }

    private String LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE() {
        return this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE;
    }

    private Option<ParquetWriter<InternalRow>> writer() {
        return this.writer;
    }

    private void writer_$eq(Option<ParquetWriter<InternalRow>> x$1) {
        this.writer = x$1;
    }

    private Option<HadoopFileStoreReader> reader() {
        return this.reader;
    }

    private void reader_$eq(Option<HadoopFileStoreReader> x$1) {
        this.reader = x$1;
    }

    public Configuration hdfsConfig() {
        return this.hdfsConfig;
    }

    private AWSOptions awsOptions() {
        return this.awsOptions;
    }

    private Option<AWSAuth> awsAuth() {
        return this.awsAuth;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> openWriteParquetFile(String filename) {
        Left left;
        Either writerOrError;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(23).append("Opening write to file: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        VerticaParquetBuilder builder = new VerticaParquetBuilder(new Path(String.valueOf(filename)));
        Either either = writerOrError = this.removeFile(filename).flatMap((Function1 & Serializable & scala.Serializable)_ -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> builder.withConf(this.hdfsConfig()).withWriteMode(ParquetFileWriter.Mode.OVERWRITE).withCompressionCodec(CompressionCodecName.SNAPPY).build()).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new OpenWriteError((Throwable)exception).context("Error opening write to HDFS.")).map((Function1 & Serializable & scala.Serializable)writer -> writer));
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            ParquetWriter writer = (ParquetWriter)right.value();
            this.writer_$eq((Option<ParquetWriter<InternalRow>>)new Some((Object)writer));
            left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> writeDataToParquetFile(DataBlock dataBlock) {
        Right right;
        Option<ParquetWriter<InternalRow>> option = this.writer();
        if (option instanceof Some) {
            Some some = (Some)option;
            ParquetWriter reader = (ParquetWriter)some.value();
            right = package$.MODULE$.Right().apply((Object)reader);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreWriterNotInitializedError().context("Error writing parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return right.flatMap((Function1 & Serializable & scala.Serializable)writer -> ((Either)implicits$.MODULE$.toTraverseOps(dataBlock.data(), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)record -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writer.write(record)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new IntermediaryStoreWriteError((Throwable)exception).context("Error writing parquet file to HDFS.")), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable & scala.Serializable)_ -> {
            HadoopFileStoreLayer.$anonfun$writeDataToParquetFile$5(_);
            return BoxedUnit.UNIT;
        }));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> closeWriteParquetFile() {
        Right right;
        Option<ParquetWriter<InternalRow>> option = this.writer();
        if (option instanceof Some) {
            Some some = (Some)option;
            ParquetWriter reader = (ParquetWriter)some.value();
            right = package$.MODULE$.Right().apply((Object)reader);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreWriterNotInitializedError().context("Error closing write of parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return right.flatMap((Function1 & Serializable & scala.Serializable)writer -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writer.close()).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new CloseWriteError((Throwable)exception).context("Error closing write of parquet file to HDFS.")).map((Function1 & Serializable & scala.Serializable)_ -> {
            HadoopFileStoreLayer.$anonfun$closeWriteParquetFile$4(_);
            return BoxedUnit.UNIT;
        }));
    }

    private <K, V> Map<K, Set<V>> toSetMultiMap(Map<K, V> map) {
        HashMap setMultiMap = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(map.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> setMultiMap.put(entry.getKey(), Collections.singleton(entry.getValue())));
        return Collections.unmodifiableMap(setMultiMap);
    }

    @Override
    public Either<ConnectorError, ParquetFileMetadata> getParquetFileMetadata(String filename) {
        Path path = new Path(String.valueOf(filename));
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)path, (Configuration)this.hdfsConfig());
            ParquetFileReader reader = ParquetFileReader.open((InputFile)inputFile);
            int rowGroupCount = reader.getRowGroups().size();
            reader.close();
            return new ParquetFileMetadata(filename, rowGroupCount);
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new FileListError((Throwable)exception).context(new StringBuilder(33).append("Error getting metadata for file ").append(filename).append(".").toString()));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> openReadParquetFile(ParquetFileRange file) {
        Left left;
        Either readerOrError;
        BoxedUnit boxedUnit;
        String filename = file.filename();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(24).append("Opening read from file: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ParquetReadSupport readSupport = new ParquetReadSupport((Option<ZoneId>)None$.MODULE$, false, SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED(), SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED());
        Either either = readerOrError = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Path path = new Path(String.valueOf(filename));
            HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)path, (Configuration)this.hdfsConfig());
            ParquetFileReader fileReader = ParquetFileReader.open((InputFile)inputFile);
            FileMetaData parquetFileMetadata = fileReader.getFooter().getFileMetaData();
            MessageType fileSchema = parquetFileMetadata.getSchema();
            Map fileMetadata = parquetFileMetadata.getKeyValueMetaData();
            ReadSupport.ReadContext readContext = readSupport.init(new InitContext(this.hdfsConfig(), this.toSetMultiMap(fileMetadata), fileSchema));
            RecordMaterializer<InternalRow> recordConverter = readSupport.prepareForRead(this.hdfsConfig(), fileMetadata, fileSchema, readContext);
            MessageType requestedSchema = readContext.getRequestedSchema();
            fileReader.setRequestedSchema(requestedSchema);
            ColumnIOFactory columnIOFactory = new ColumnIOFactory(parquetFileMetadata.getCreatedBy());
            boolean strictTypeChecking = false;
            MessageColumnIO columnIO = columnIOFactory.getColumnIO(requestedSchema, fileSchema, strictTypeChecking);
            return new HadoopFileStoreReader(fileReader, columnIO, recordConverter, file);
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new OpenReadError((Throwable)exception).context("Error creating Parquet Reader"));
        if (either instanceof Right) {
            Right right = (Right)either;
            HadoopFileStoreReader reader = (HadoopFileStoreReader)right.value();
            this.reader_$eq((Option<HadoopFileStoreReader>)new Some((Object)reader));
            left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, DataBlock> readDataFromParquetFile(int blockSize) {
        Right right;
        Option<HadoopFileStoreReader> option = this.reader();
        if (option instanceof Some) {
            Some some = (Some)option;
            HadoopFileStoreReader reader2 = (HadoopFileStoreReader)some.value();
            right = package$.MODULE$.Right().apply((Object)reader2);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreReaderNotInitializedError().context("Error reading parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return right.flatMap((Function1 & Serializable & scala.Serializable)reader -> reader.read(blockSize).map((Function1 & Serializable & scala.Serializable)dataBlock -> dataBlock)).map((Function1 & Serializable & scala.Serializable)dataBlock -> dataBlock);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Either<ConnectorError, BoxedUnit> closeReadParquetFile() {
        void var2_5;
        Right right;
        Option<HadoopFileStoreReader> option = this.reader();
        if (option instanceof Some) {
            Some some = (Some)option;
            HadoopFileStoreReader reader2 = (HadoopFileStoreReader)some.value();
            right = package$.MODULE$.Right().apply((Object)reader2);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreReaderNotInitializedError().context("Error closing read of parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        Either r = right.flatMap((Function1 & Serializable & scala.Serializable)reader -> reader.close().map((Function1 & Serializable & scala.Serializable)_ -> {
            HadoopFileStoreLayer.$anonfun$closeReadParquetFile$2(_);
            return BoxedUnit.UNIT;
        }));
        this.reader_$eq((Option<HadoopFileStoreReader>)None$.MODULE$);
        return var2_5;
    }

    @Override
    public Either<ConnectorError, Seq<String>> getFileList(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> {
            Left left;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> fs.listStatus(path));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                FileStatus[] fileStatuses = (FileStatus[])success.value();
                left = package$.MODULE$.Right().apply((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatuses)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                left = package$.MODULE$.Left().apply((Object)new FileListError(exception).context("Error getting file list from HDFS."));
            } else {
                throw new MatchError((Object)try_);
            }
            return left;
        });
    }

    @Override
    public Either<ConnectorError, BoxedUnit> removeFile(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> fs.exists(path) ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.delete(path, true)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new RemoveFileError((Path)path, (Throwable)exception).context("Error removing HDFS file.")) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> removeDir(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> fs.exists(path) ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.delete(path, true)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new RemoveDirectoryError((Path)path, (Throwable)exception).context("Error removing HDFS directory.")) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createFile(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> !fs.exists(path) ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FSDataOutputStream stream = fs.create(path);
            stream.write(0);
            stream.close();
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new CreateFileError((Path)path, (Throwable)exception).context("Error creating HDFS file.")) : package$.MODULE$.Left().apply((Object)new CreateFileAlreadyExistsError(filename)));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createDir(String filename, String permission) {
        FsPermission perms = new FsPermission(permission);
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> {
            Left left;
            if (!fs.exists(path)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(31).append("Making path ").append(path).append(" with permissions: ").append(perms.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                left = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.mkdirs(path, perms)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new CreateDirectoryError((Path)path, (Throwable)exception).context("Error creating HDFS directory."));
            } else {
                left = package$.MODULE$.Left().apply((Object)new CreateDirectoryAlreadyExistsError(filename));
            }
            return left;
        });
    }

    @Override
    public Either<ConnectorError, Object> fileExists(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)fs.exists(path))));
    }

    @Override
    public Either<ConnectorError, String> getImpersonationToken(String user) {
        Right right;
        ObjectRef hdfsToken = ObjectRef.create((Object)None$.MODULE$);
        Option ugiUser = Option$.MODULE$.apply((Object)UserGroupInformation.getLoginUser());
        Option option = ugiUser;
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            UserGroupInformation user2 = (UserGroupInformation)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Got UGI user.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Collection existingTokens = user2.getCredentials().getAllTokens();
            for (Token token : existingTokens) {
                BoxedUnit boxedUnit2;
                Text tokenKind = token.getKind();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(21).append("Existing token kind: ").append(tokenKind.toString()).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (!this.WEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.SWEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.HDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind)) continue;
                hdfsToken.elem = new Some((Object)token.encodeToUrlString());
            }
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        this.useFileSystem(this.fileStoreConfig.address(), (Function2 & Serializable & scala.Serializable)(fs, x$3) -> {
            Token[] tokens = fs.addDelegationTokens(user, null);
            for (Token token : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens))) {
                BoxedUnit boxedUnit;
                Text tokenKind = token.getKind();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(31).append("Hadoop impersonation: IT kind: ").append(tokenKind.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (!this.WEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.SWEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.HDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind)) continue;
                hdfsToken$1.elem = new Some((Object)token.encodeToUrlString());
            }
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        });
        Option option2 = (Option)hdfsToken.elem;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String token = (String)some.value();
            right = package$.MODULE$.Right().apply((Object)token);
        } else if (None$.MODULE$.equals(option2)) {
            right = package$.MODULE$.Left().apply((Object)new MissingHDFSImpersonationTokenError(user, this.fileStoreConfig.address()));
        } else {
            throw new MatchError((Object)option2);
        }
        return right;
    }

    @Override
    public Either<ConnectorError, Seq<String>> getGlobStatus(String pattern) {
        return this.useFileSystem(pattern, (Function2 & Serializable & scala.Serializable)(fs, path) -> {
            Left left;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> fs.globStatus(path));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                FileStatus[] fileStatuses = (FileStatus[])success.value();
                left = package$.MODULE$.Right().apply((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatuses)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                left = package$.MODULE$.Left().apply((Object)new FileListError(exception).context("Error getting file list from HDFS."));
            } else {
                throw new MatchError((Object)try_);
            }
            return left;
        });
    }

    @Override
    public AWSOptions getAWSOptions() {
        return this.fileStoreConfig.awsOptions();
    }

    private <T> Either<ConnectorError, T> useFileSystem(String filename, Function2<FileSystem, Path, Either<ConnectorError, T>> fsAction) {
        Either either;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(16).append("Filestore path: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Path path = new Path(String.valueOf(filename));
            FileSystem fs = path.getFileSystem(this.hdfsConfig());
            return (Either)fsAction.apply((Object)fs, (Object)path);
        });
        if (try_ instanceof Success) {
            Either value;
            Success success = (Success)try_;
            either = value = (Either)success.value();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            either = package$.MODULE$.Left().apply((Object)new FileStoreThrownError(exception));
        } else {
            throw new MatchError((Object)try_);
        }
        return either;
    }

    public static final /* synthetic */ void $anonfun$writeDataToParquetFile$5(List _) {
    }

    public static final /* synthetic */ void $anonfun$closeWriteParquetFile$4(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$closeReadParquetFile$2(BoxedUnit _) {
    }

    public HadoopFileStoreLayer(FileStoreConfig fileStoreConfig, Option<StructType> schema) {
        this.fileStoreConfig = fileStoreConfig;
        this.S3_ACCESS_KEY = "fs.s3a.access.key";
        this.S3_SECRET_KEY = "fs.s3a.secret.key";
        this.S3_SESSION_TOKEN = "fs.s3a.session.token";
        this.AWS_CREDENTIALS_PROVIDER = "fs.s3a.aws.credentials.provider";
        this.S3_ENDPOINT = "fs.s3a.endpoint";
        this.S3_ENABLE_SSL = "fs.s3a.connection.ssl.enabled";
        this.logger = LogProvider$.MODULE$.getLogger(HadoopFileStoreLayer.class);
        this.WEBHDFS_DELEGATION_TOKEN_TEXT = new Text("WEBHDFS delegation");
        this.SWEBHDFS_DELEGATION_TOKEN_TEXT = new Text("SWEBHDFS delegation");
        this.HDFS_DELEGATION_TOKEN_TEXT = new Text("HDFS_DELEGATION_TOKEN");
        this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE = "spark.sql.legacy.parquet.datetimeRebaseModeInWrite";
        this.LEGACY_PARQUET_REBASE_MODE_IN_READ = "spark.sql.legacy.parquet.datetimeRebaseModeInRead";
        this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE = "spark.sql.legacy.parquet.int96RebaseModeInWrite";
        this.writer = None$.MODULE$;
        this.reader = None$.MODULE$;
        this.hdfsConfig = new Configuration();
        Option<StructType> option = schema;
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            StructType schema2 = (StructType)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(31).append("Read and write support schema: ").append(schema2).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.hdfsConfig().set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), schema2.json());
            this.hdfsConfig().set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), schema2.json());
            ParquetWriteSupport$.MODULE$.setSchema(schema2, this.hdfsConfig());
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        this.awsOptions = fileStoreConfig.awsOptions();
        this.awsAuth = this.awsOptions().awsAuth();
        Option<AWSArg<String>> option2 = this.awsOptions().awsCredentialsProvider();
        if (option2 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option2;
            AWSArg provider = (AWSArg)some.value();
            this.hdfsConfig().set(this.AWS_CREDENTIALS_PROVIDER(), (String)provider.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Setting {}: {}", new Object[]{this.AWS_CREDENTIALS_PROVIDER(), provider});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (None$.MODULE$.equals(option2)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS credentials provider for Hadoop config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else {
            throw new MatchError(option2);
        }
        Option<AWSAuth> option3 = this.awsAuth();
        if (option3 instanceof Some) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit5;
            Some some = (Some)option3;
            AWSAuth auth = (AWSAuth)some.value();
            this.hdfsConfig().set(this.S3_ACCESS_KEY(), auth.accessKeyId().arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ACCESS_KEY(), auth.accessKeyId().origin()});
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            this.hdfsConfig().set(this.S3_SECRET_KEY(), auth.secretAccessKey().arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_SECRET_KEY(), auth.secretAccessKey().origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit;
        } else if (None$.MODULE$.equals(option3)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS auth for Hadoop config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit7 = boxedUnit;
        } else {
            throw new MatchError(option3);
        }
        Option<AWSArg<String>> option4 = this.awsOptions().awsSessionToken();
        if (option4 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option4;
            AWSArg token = (AWSArg)some.value();
            this.hdfsConfig().set(this.S3_SESSION_TOKEN(), (String)token.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_SESSION_TOKEN(), token.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit8 = boxedUnit;
        } else if (None$.MODULE$.equals(option4)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS session token for Hadoop config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit9 = boxedUnit;
        } else {
            throw new MatchError(option4);
        }
        Option<AWSArg<String>> option5 = this.awsOptions().awsEndpoint();
        if (option5 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option5;
            AWSArg endpoint = (AWSArg)some.value();
            this.hdfsConfig().set(this.S3_ENDPOINT(), (String)endpoint.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ENDPOINT(), endpoint.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit10 = boxedUnit;
        } else if (None$.MODULE$.equals(option5)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not set AWS endpoint, using default.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit11 = boxedUnit;
        } else {
            throw new MatchError(option5);
        }
        Option<AWSArg<String>> option6 = this.awsOptions().enableSSL();
        if (option6 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option6;
            AWSArg enable = (AWSArg)some.value();
            this.hdfsConfig().set(this.S3_ENABLE_SSL(), (String)enable.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ENABLE_SSL(), enable.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit12 = boxedUnit;
        } else if (None$.MODULE$.equals(option6)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not set AWS SSL enabled flag, using default of true.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit13 = boxedUnit;
        } else {
            throw new MatchError(option6);
        }
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), "false");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), "true");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), "false");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), "INT96");
        this.hdfsConfig().set(this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE(), "CORRECTED");
        this.hdfsConfig().set(this.LEGACY_PARQUET_REBASE_MODE_IN_READ(), "CORRECTED");
        this.hdfsConfig().set(this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE(), "CORRECTED");
        this.hdfsConfig().setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        this.hdfsConfig().set("fs.permissions.umask-mode", "000");
    }

    public class VerticaParquetBuilder
    extends ParquetWriter.Builder<InternalRow, VerticaParquetBuilder> {
        public VerticaParquetBuilder self() {
            return this;
        }

        public ParquetWriteSupport getWriteSupport(Configuration conf) {
            return new ParquetWriteSupport();
        }

        public /* synthetic */ HadoopFileStoreLayer com$vertica$spark$datasource$fs$HadoopFileStoreLayer$VerticaParquetBuilder$$$outer() {
            return HadoopFileStoreLayer.this;
        }

        public VerticaParquetBuilder(Path file) {
            if (HadoopFileStoreLayer.this == null) {
                throw null;
            }
            super(file);
        }
    }
}

