/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.jdbc;

import buildinfo.BuildInfo$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.AWSArg;
import com.vertica.spark.config.AWSAuth;
import com.vertica.spark.config.AWSOptions;
import com.vertica.spark.config.BasicJdbcAuth;
import com.vertica.spark.config.JDBCConfig;
import com.vertica.spark.config.JDBCTLSConfig;
import com.vertica.spark.config.JdbcAuth;
import com.vertica.spark.config.KerberosAuth;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcLayerIntParam;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcLayerParam;
import com.vertica.spark.datasource.jdbc.JdbcLayerStringParam;
import com.vertica.spark.util.error.ConnectionDownError;
import com.vertica.spark.util.error.ConnectionError;
import com.vertica.spark.util.error.ConnectionSqlError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.DataError;
import com.vertica.spark.util.error.GenericError;
import com.vertica.spark.util.error.MissingNameNodeAddressError;
import com.vertica.spark.util.error.NoSparkSessionFound;
import com.vertica.spark.util.error.ParamsNotSupported;
import com.vertica.spark.util.error.SyntaxError;
import com.vertica.spark.util.general.Utils$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkEnv$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tMb\u0001B\u0010!\u0001-B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\u0006{\u0001!\tA\u0010\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0011\u0019Y\u0005\u0001)A\u0005\u0007\"9A\n\u0001b\u0001\n\u0013i\u0005B\u0002,\u0001A\u0003%a\nC\u0004X\u0001\t\u0007I\u0011\u0002-\t\r}\u0003\u0001\u0015!\u0003Z\u0011!\u0001\u0007\u0001#b\u0001\n\u0013\t\u0007BB@\u0001\t\u0013\t\t\u0001C\u0004\u0002\u0012\u0001!I!a\u0005\t\u000f\u0005M\u0002\u0001\"\u0003\u00026!9\u0011Q\b\u0001\u0005\n\u0005}\u0002bBA%\u0001\u0011%\u00111\n\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\ti\u0006\u0001C\u0005\u0003?Bq!!\u001e\u0001\t\u0003\t9\bC\u0005\u0002\u0006\u0002\t\n\u0011\"\u0001\u0002\b\"9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0005\"CAT\u0001E\u0005I\u0011AAD\u0011\u001d\tI\u000b\u0001C\u0001\u0003WC\u0011\"!/\u0001#\u0003%\t!a\"\t\u000f\u0005m\u0006\u0001\"\u0001\u0002>\"9\u0011q\u0018\u0001\u0005\u0002\u0005u\u0006bBAa\u0001\u0011\u0005\u0011Q\u0018\u0005\b\u0003\u0007\u0004A\u0011AAc\u0011\u001d\t9\u000e\u0001C\u0005\u00033Dq!!8\u0001\t\u0013\ty\u000eC\u0004\u0002d\u0002!I!!:\t\u000f\t\r\u0001\u0001\"\u0003\u0003\u0006\t\u0001b+\u001a:uS\u000e\f'\n\u001a2d\u0019\u0006LXM\u001d\u0006\u0003C\t\nAA\u001b3cG*\u00111\u0005J\u0001\u000bI\u0006$\u0018m]8ve\u000e,'BA\u0013'\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0003&A\u0004wKJ$\u0018nY1\u000b\u0003%\n1aY8n\u0007\u0001\u00192\u0001\u0001\u00173!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0019\te.\u001f*fMB\u00111\u0007N\u0007\u0002A%\u0011Q\u0007\t\u0002\u0013\u0015\u0012\u00147\rT1zKJLe\u000e^3sM\u0006\u001cW-A\u0002dM\u001e\u0004\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0013\u0002\r\r|gNZ5h\u0013\ta\u0014H\u0001\u0006K\t\n\u001b5i\u001c8gS\u001e\fa\u0001P5oSRtDCA A!\t\u0019\u0004\u0001C\u00037\u0005\u0001\u0007q'\u0001\u0004m_\u001e<WM]\u000b\u0002\u0007B\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003\u0011\"\n\u0001\u0002^=qKN\fg-Z\u0005\u0003\u0015\u0016\u0013a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u0005aJ|\u0007/F\u0001O!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0003vi&d'\"A*\u0002\t)\fg/Y\u0005\u0003+B\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003\u0015\u0001(o\u001c9!\u0003\u001dQGMY2V%&+\u0012!\u0017\t\u00035vk\u0011a\u0017\u0006\u00039J\u000bA\u0001\\1oO&\u0011al\u0017\u0002\u0007'R\u0014\u0018N\\4\u0002\u0011)$'mY+S\u0013\u0002\n!bY8o]\u0016\u001cG/[8o+\u0005\u0011\u0007cA2ws:\u0011Am\u001d\b\u0003KBt!AZ8\u000f\u0005\u001dtgB\u00015n\u001d\tIG.D\u0001k\u0015\tY'&\u0001\u0004=e>|GOP\u0005\u0002S%\u0011q\u0005K\u0005\u0003K\u0019J!!\u0015\u0013\n\u0005E\u0014\u0018!B3se>\u0014(BA)%\u0013\t!X/A\u0007FeJ|'\u000fS1oI2Lgn\u001a\u0006\u0003cJL!a\u001e=\u0003\u001f\r{gN\\3di>\u0014(+Z:vYRT!\u0001^;\u0011\u0005ilX\"A>\u000b\u0005q\u0014\u0016aA:rY&\u0011ap\u001f\u0002\u000b\u0007>tg.Z2uS>t\u0017!E2sK\u0006$Xm\u00117jK:$H*\u00192fYV\u0011\u00111\u0001\t\u0005\u0003\u000b\tiA\u0004\u0003\u0002\b\u0005%\u0001CA5/\u0013\r\tYAL\u0001\u0007!J,G-\u001a4\n\u0007y\u000byAC\u0002\u0002\f9\n\u0011\u0004[1oI2,7i\u001c8oK\u000e$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]R!\u0011QCA\u000f!\u0011\t9\"!\u0007\u000e\u0003UL1!a\u0007v\u00059\u0019uN\u001c8fGR|'/\u0012:s_JDq!a\b\f\u0001\u0004\t\t#A\u0001f!\u0011\t\u0019#!\f\u000f\t\u0005\u0015\u0012\u0011\u0006\b\u0004S\u0006\u001d\u0012\"A\u0018\n\u0007\u0005-b&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0012\u0011\u0007\u0002\n)\"\u0014xn^1cY\u0016T1!a\u000b/\u0003A\tG\r\u001a+M'B\u0013x\u000e]3si&,7\u000f\u0006\u0002\u00028A\u0019Q&!\u000f\n\u0007\u0005mbF\u0001\u0003V]&$\u0018\u0001D4fiN#\u0018\r^3nK:$XCAA!!\u0011\u0019g/a\u0011\u0011\u0007i\f)%C\u0002\u0002Hm\u0014\u0011b\u0015;bi\u0016lWM\u001c;\u0002)\u001d,G\u000f\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u)\u0011\ti%!\u0016\u0011\t\r4\u0018q\n\t\u0004u\u0006E\u0013bAA*w\n\t\u0002K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;\t\rqt\u0001\u0019AA\u0002\u0003MA\u0017M\u001c3mK*#%iQ#yG\u0016\u0004H/[8o)\u0011\t)\"a\u0017\t\u000f\u0005}q\u00021\u0001\u0002\"\u0005!\u0012\r\u001a3QCJ\fWn\u001d+p'R\fG/Z7f]R$b!a\u000e\u0002b\u0005\u0015\u0004bBA2!\u0001\u0007\u0011qJ\u0001\ngR\fG/Z7f]RDq!a\u001a\u0011\u0001\u0004\tI'\u0001\u0004qCJ\fWn\u001d\t\u0007\u0003G\tY'a\u001c\n\t\u00055\u0014\u0011\u0007\u0002\u0004'\u0016\f\bcA\u001a\u0002r%\u0019\u00111\u000f\u0011\u0003\u001d)#'m\u0019'bs\u0016\u0014\b+\u0019:b[\u0006)\u0011/^3ssR1\u0011\u0011PAA\u0003\u0007\u0003Ba\u0019<\u0002|A\u0019!0! \n\u0007\u0005}4PA\u0005SKN,H\u000e^*fi\"9\u0011QO\tA\u0002\u0005\r\u0001\"CA4#A\u0005\t\u0019AA5\u0003=\tX/\u001a:zI\u0011,g-Y;mi\u0012\u0012TCAAEU\u0011\tI'a#,\u0005\u00055\u0005\u0003BAH\u00033k!!!%\u000b\t\u0005M\u0015QS\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a&/\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\u000b\tJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq!\u001a=fGV$X\r\u0006\u0004\u0002\"\u0006\r\u0016Q\u0015\t\u0005GZ\f9\u0004C\u0004\u0002dM\u0001\r!a\u0001\t\u0013\u0005\u001d4\u0003%AA\u0002\u0005%\u0014!E3yK\u000e,H/\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u0005iQ\r_3dkR,W\u000b\u001d3bi\u0016$b!!,\u00026\u0006]\u0006\u0003B2w\u0003_\u00032!LAY\u0013\r\t\u0019L\f\u0002\u0004\u0013:$\bbBA2+\u0001\u0007\u00111\u0001\u0005\n\u0003O*\u0002\u0013!a\u0001\u0003S\nq#\u001a=fGV$X-\u00169eCR,G\u0005Z3gCVdG\u000f\n\u001a\u0002\u000b\rdwn]3\u0015\u0005\u0005\u0005\u0016AB2p[6LG/\u0001\u0005s_2d'-Y2l\u0003A\u0019wN\u001c4jOV\u0014XmU3tg&|g\u000e\u0006\u0003\u0002\"\u0006\u001d\u0007bBAe5\u0001\u0007\u00111Z\u0001\u000fM&dWm\u0015;pe\u0016d\u0015-_3s!\u0011\ti-a5\u000e\u0005\u0005='bAAiE\u0005\u0011am]\u0005\u0005\u0003+\fyMA\fGS2,7\u000b^8sK2\u000b\u00170\u001a:J]R,'OZ1dK\u000612m\u001c8gS\u001e,(/Z!X'B\u000b'/Y7fi\u0016\u00148\u000f\u0006\u0003\u0002\"\u0006m\u0007bBAe7\u0001\u0007\u00111Z\u0001\u001dG>tg-[4ve\u0016\\UM\u001d2fe>\u001cHk\u001c$jY\u0016\u001cHo\u001c:f)\u0011\t\t+!9\t\u000f\u0005%G\u00041\u0001\u0002L\u0006\u0001Bn\\4IC\u0012|w\u000e]\"p]\u001aLwm\u001d\u000b\u0005\u0003o\t9\u000fC\u0004\u0002jv\u0001\r!a;\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0002n\u0006}XBAAx\u0015\u0011\t\t0a=\u0002\t\r|gN\u001a\u0006\u0005\u0003k\f90\u0001\u0004iC\u0012|w\u000e\u001d\u0006\u0005\u0003s\fY0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003{\f1a\u001c:h\u0013\u0011\u0011\t!a<\u0003\u001b\r{gNZ5hkJ\fG/[8o\u00035)8/Z\"p]:,7\r^5p]V!!q\u0001B\b)!\u0011IA!\t\u0003$\t5\u0002\u0003B2w\u0005\u0017\u0001BA!\u0004\u0003\u00101\u0001Aa\u0002B\t=\t\u0007!1\u0003\u0002\u0002)F!!Q\u0003B\u000e!\ri#qC\u0005\u0004\u00053q#a\u0002(pi\"Lgn\u001a\t\u0004[\tu\u0011b\u0001B\u0010]\t\u0019\u0011I\\=\t\u000b\u0001t\u0002\u0019A=\t\u000f\t\u0015b\u00041\u0001\u0003(\u00051\u0011m\u0019;j_:\u0004b!\fB\u0015s\n-\u0011b\u0001B\u0016]\tIa)\u001e8di&|g.\r\u0005\b\u0005_q\u0002\u0019\u0001B\u0019\u0003A)\u0007pY3qi&|gnQ1uG\",'\u000fE\u0004.\u0005S\t\t#!\u0006")
public class VerticaJdbcLayer
implements JdbcLayerInterface {
    private Either<ConnectorError, Connection> connection;
    private final JDBCConfig cfg;
    private final Logger logger;
    private final Properties prop;
    private final String jdbcURI;
    private volatile boolean bitmap$0;

    private Logger logger() {
        return this.logger;
    }

    private Properties prop() {
        return this.prop;
    }

    private String jdbcURI() {
        return this.jdbcURI;
    }

    private Either<ConnectorError, Connection> connection$lzycompute() {
        VerticaJdbcLayer verticaJdbcLayer = this;
        synchronized (verticaJdbcLayer) {
            if (!this.bitmap$0) {
                this.connection = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> DriverManager.getConnection(this.jdbcURI(), this.prop())).toEither().left().map((Function1 & Serializable & scala.Serializable)e -> this.handleConnectionException((Throwable)e)).flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> {
                    BoxedUnit boxedUnit;
                    c.setClientInfo("APPLICATIONNAME", this.createClientLabel());
                    c.setAutoCommit(false);
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Successfully connected to Vertica.");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return c;
                }, (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleConnectionException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.context("Initial connection was not valid.")));
                this.bitmap$0 = true;
            }
        }
        return this.connection;
    }

    private Either<ConnectorError, Connection> connection() {
        return !this.bitmap$0 ? this.connection$lzycompute() : this.connection;
    }

    private String createClientLabel() {
        String string;
        JdbcAuth jdbcAuth = this.cfg.auth();
        if (jdbcAuth instanceof BasicJdbcAuth) {
            string = "-p";
        } else if (jdbcAuth instanceof KerberosAuth) {
            string = "-k";
        } else {
            throw new MatchError((Object)jdbcAuth);
        }
        String authMethod = string;
        String sparkVersion = SparkSession$.MODULE$.active().sparkContext().version();
        return new StringBuilder(12).append("vspark-vs").append(BuildInfo$.MODULE$.version()).append(authMethod).append("-sp").append(sparkVersion).toString();
    }

    private ConnectorError handleConnectionException(Throwable e) {
        Product product;
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            product = new ConnectionSqlError(sQLException);
        } else if (throwable != null) {
            Throwable throwable2 = throwable;
            product = new ConnectionError(throwable2);
        } else {
            throw new MatchError((Object)throwable);
        }
        return product;
    }

    private void addTLSProperties() {
        JDBCTLSConfig tlsConfig = this.cfg.tlsConfig();
        Utils$.MODULE$.ignore(this.prop().put("TLSmode", tlsConfig.tlsMode().toString()));
        Option<String> option = tlsConfig.keyStorePath();
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            Utils$.MODULE$.ignore(this.prop().put("KeyStorePath", path));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        Option<String> option2 = tlsConfig.keyStorePassword();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String password = (String)some.value();
            Utils$.MODULE$.ignore(this.prop().put("KeyStorePassword", password));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option2);
        }
        Option<String> option3 = tlsConfig.trustStorePath();
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            String path = (String)some.value();
            Utils$.MODULE$.ignore(this.prop().put("TrustStorePath", path));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option3)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option3);
        }
        Option<String> option4 = tlsConfig.trustStorePassword();
        if (option4 instanceof Some) {
            Some some = (Some)option4;
            String password = (String)some.value();
            Utils$.MODULE$.ignore(this.prop().put("TrustStorePassword", password));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option4)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option4);
        }
    }

    private Either<ConnectorError, Statement> getStatement() {
        return this.connection().flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> c.createStatement(), (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.context("getStatement: Error while trying to create statement.")));
    }

    private Either<ConnectorError, PreparedStatement> getPreparedStatement(String sql) {
        return this.connection().flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> c.prepareStatement(sql), (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.context("getPreparedStatement: Error while getting prepared statement.")));
    }

    @Override
    public ConnectorError handleJDBCException(Throwable e) {
        ConnectorError connectorError;
        Throwable throwable = e;
        if (throwable instanceof SQLSyntaxErrorException) {
            SQLSyntaxErrorException sQLSyntaxErrorException = (SQLSyntaxErrorException)throwable;
            connectorError = new SyntaxError(sQLSyntaxErrorException);
        } else if (throwable instanceof SQLDataException) {
            SQLDataException sQLDataException = (SQLDataException)throwable;
            connectorError = new DataError(sQLDataException);
        } else if (throwable != null) {
            connectorError = new GenericError(e).context("Unexpected SQL Error.");
        } else {
            throw new MatchError((Object)throwable);
        }
        return connectorError;
    }

    private void addParamsToStatement(PreparedStatement statement, Seq<JdbcLayerParam> params) {
        ((IterableLike)params.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            VerticaJdbcLayer.$anonfun$addParamsToStatement$1(statement, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Either<ConnectorError, ResultSet> query(String query, Seq<JdbcLayerParam> params) {
        Either either;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(26).append("Attempting to send query: ").append(query).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Left left;
            Either<ConnectorError, PreparedStatement> either = this.getPreparedStatement(query);
            if (either instanceof Right) {
                Right right = (Right)either;
                PreparedStatement stmt = (PreparedStatement)right.value();
                this.addParamsToStatement(stmt, params);
                left = package$.MODULE$.Right().apply((Object)stmt.executeQuery());
            } else if (either instanceof Left) {
                Left left2 = (Left)either;
                ConnectorError err = (ConnectorError)left2.value();
                left = package$.MODULE$.Left().apply((Object)err);
            } else {
                throw new MatchError(either);
            }
            return left;
        });
        if (try_ instanceof Success) {
            Either v;
            Success success = (Success)try_;
            either = v = (Either)success.value();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            either = package$.MODULE$.Left().apply((Object)this.handleJDBCException(e).context("Error when sending query"));
        } else {
            throw new MatchError((Object)try_);
        }
        return either;
    }

    @Override
    public Seq<JdbcLayerParam> query$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> execute(String statement, Seq<JdbcLayerParam> params) {
        Either either;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(33).append("Attempting to execute statement: ").append(statement).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Right right;
            if (params.nonEmpty()) {
                Left left;
                Either<ConnectorError, PreparedStatement> either = this.getPreparedStatement(statement);
                if (either instanceof Right) {
                    Right right2 = (Right)either;
                    PreparedStatement stmt = (PreparedStatement)right2.value();
                    this.addParamsToStatement(stmt, params);
                    stmt.execute();
                    left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                } else if (either instanceof Left) {
                    Left left2 = (Left)either;
                    ConnectorError err = (ConnectorError)left2.value();
                    left = package$.MODULE$.Left().apply((Object)err);
                } else {
                    throw new MatchError(either);
                }
                right = left;
            } else {
                Right right3;
                Either<ConnectorError, Statement> either = this.getStatement();
                if (either instanceof Right) {
                    Right right4 = (Right)either;
                    Statement stmt = (Statement)right4.value();
                    stmt.execute(statement);
                    right3 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                } else if (either instanceof Left) {
                    Left left = (Left)either;
                    ConnectorError err = (ConnectorError)left.value();
                    right3 = package$.MODULE$.Left().apply((Object)err);
                } else {
                    throw new MatchError(either);
                }
                right = right3;
            }
            return right;
        });
        if (try_ instanceof Success) {
            Either v;
            Success success = (Success)try_;
            either = v = (Either)success.value();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            either = package$.MODULE$.Left().apply((Object)this.handleJDBCException(e));
        } else {
            throw new MatchError((Object)try_);
        }
        return either;
    }

    @Override
    public Seq<JdbcLayerParam> execute$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public Either<ConnectorError, Object> executeUpdate(String statement, Seq<JdbcLayerParam> params) {
        Left left;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(33).append("Attempting to execute statement: ").append(statement).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (params.nonEmpty()) {
            left = package$.MODULE$.Left().apply((Object)new ParamsNotSupported("executeUpdate"));
        } else {
            Either either;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.getStatement().map((Function1 & Serializable & scala.Serializable)stmt -> BoxesRunTime.boxToInteger((int)stmt.executeUpdate(statement))));
            if (try_ instanceof Success) {
                Either v;
                Success success = (Success)try_;
                either = v = (Either)success.value();
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                either = package$.MODULE$.Left().apply((Object)this.handleJDBCException(e));
            } else {
                throw new MatchError((Object)try_);
            }
            left = either;
        }
        return left;
    }

    @Override
    public Seq<JdbcLayerParam> executeUpdate$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> close() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Closing connection.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.connection().flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> {
            c.close();
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.context("close: JDBC Error closing the connection.")));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> commit() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Commiting.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.connection().flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> {
            c.commit();
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.context("commit: JDBC Error while commiting.")));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> rollback() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Rolling back.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.connection().flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> {
            c.rollback();
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.context("rollback: JDBC Error while rolling back.")));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> configureSession(FileStoreLayerInterface fileStoreLayer) {
        return this.configureKerberosToFilestore(fileStoreLayer).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.configureAWSParameters(fileStoreLayer).map((Function1 & Serializable & scala.Serializable)_ -> {
            VerticaJdbcLayer.$anonfun$configureSession$2(_);
            return BoxedUnit.UNIT;
        }));
    }

    private Either<ConnectorError, BoxedUnit> configureAWSParameters(FileStoreLayerInterface fileStoreLayer) {
        Either<ConnectorError, BoxedUnit> either;
        AWSOptions awsOptions = fileStoreLayer.getAWSOptions();
        Option<AWSAuth> option = awsOptions.awsAuth();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            Some some = (Some)option;
            AWSAuth awsAuth = (AWSAuth)some.value();
            String sql = new StringBuilder(29).append("ALTER SESSION SET AWSAuth='").append((Object)awsAuth.accessKeyId().arg()).append(":").append((Object)awsAuth.secretAccessKey().arg()).append("'").toString();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded AWS access key ID from {}", new Object[]{awsAuth.accessKeyId().origin()});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded AWS secret access key from {}", new Object[]{awsAuth.secretAccessKey().origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            either = this.execute(sql, this.execute$default$2());
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWSAuth");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError(option);
        }
        return either.flatMap((Function1 & Serializable & scala.Serializable)_2 -> {
            Either<ConnectorError, BoxedUnit> either;
            Option<AWSArg<String>> option = awsOptions.awsRegion();
            if (option instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option;
                AWSArg awsRegion = (AWSArg)some.value();
                String sql = new StringBuilder(30).append("ALTER SESSION SET AWSRegion='").append(awsRegion.arg()).append("'").toString();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Setting AWSRegion for session: {}", new Object[]{awsRegion});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                either = this.execute(sql, this.execute$default$2());
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Did not set AWSRegion");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError(option);
            }
            return either.flatMap((Function1 & Serializable & scala.Serializable)_ -> {
                Either<ConnectorError, BoxedUnit> either;
                Option<AWSArg<String>> option = awsOptions.awsSessionToken();
                if (option instanceof Some) {
                    BoxedUnit boxedUnit;
                    Some some = (Some)option;
                    AWSArg token = (AWSArg)some.value();
                    String sql = new StringBuilder(36).append("ALTER SESSION SET AWSSessionToken='").append(token.arg()).append("'").toString();
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Loaded AWSSessionToken from {}", new Object[]{token.origin()});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    either = this.execute(sql, this.execute$default$2());
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Did not set AWSSessionToken");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                } else {
                    throw new MatchError(option);
                }
                return either.flatMap((Function1 & Serializable & scala.Serializable)_2 -> {
                    Either<ConnectorError, BoxedUnit> either;
                    Option<AWSArg<String>> option = awsOptions.awsEndpoint();
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        AWSArg endpoint = (AWSArg)some.value();
                        String sql = new StringBuilder(32).append("ALTER SESSION SET AWSEndpoint='").append(endpoint.arg()).append("'").toString();
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Loaded AWSEndpoint from {}", new Object[]{endpoint.origin()});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        either = this.execute(sql, this.execute$default$2());
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Did not set AWSEndpoint");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    } else {
                        throw new MatchError(option);
                    }
                    return either.flatMap((Function1 & Serializable & scala.Serializable)_ -> {
                        Either<ConnectorError, BoxedUnit> either;
                        Option<AWSArg<String>> option = awsOptions.enableSSL();
                        if (option instanceof Some) {
                            BoxedUnit boxedUnit;
                            Some some = (Some)option;
                            AWSArg enable = (AWSArg)some.value();
                            int enableInt = ((String)enable.arg()).equalsIgnoreCase("true") ? 1 : 0;
                            String sql = new StringBuilder(33).append("ALTER SESSION SET AWSEnableHttps=").append(enableInt).toString();
                            if (this.logger().underlying().isInfoEnabled()) {
                                this.logger().underlying().info("Loaded AWSEnableHttps from {}", new Object[]{enable.origin()});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            either = this.execute(sql, this.execute$default$2());
                        } else if (None$.MODULE$.equals(option)) {
                            BoxedUnit boxedUnit;
                            if (this.logger().underlying().isInfoEnabled()) {
                                this.logger().underlying().info("Did not set AWSEnableHttps");
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                        } else {
                            throw new MatchError(option);
                        }
                        return either.flatMap((Function1 & Serializable & scala.Serializable)_2 -> {
                            Either<ConnectorError, BoxedUnit> either;
                            Option<AWSArg<String>> option = awsOptions.enablePathStyle();
                            if (option instanceof Some) {
                                BoxedUnit boxedUnit;
                                Some some = (Some)option;
                                AWSArg enable = (AWSArg)some.value();
                                int enableInt = ((String)enable.arg()).equalsIgnoreCase("true") ? 0 : 1;
                                String sql = new StringBuilder(44).append("ALTER SESSION SET S3EnableVirtualAddressing=").append(enableInt).toString();
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("Loaded S3EnableVirtualAddressing from {}", new Object[]{enable.origin()});
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                either = this.execute(sql, this.execute$default$2());
                            } else if (None$.MODULE$.equals(option)) {
                                BoxedUnit boxedUnit;
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("Did not set S3EnableVirtualAddressing");
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                            } else {
                                throw new MatchError(option);
                            }
                            return either.map((Function1 & Serializable & scala.Serializable)_ -> {
                                VerticaJdbcLayer.$anonfun$configureAWSParameters$6(_);
                                return BoxedUnit.UNIT;
                            });
                        });
                    });
                });
            });
        });
    }

    /*
     * Unable to fully structure code
     */
    private Either<ConnectorError, BoxedUnit> configureKerberosToFilestore(FileStoreLayerInterface fileStoreLayer) {
        block13: {
            block12: {
                var4_2 = SparkSession$.MODULE$.getActiveSession();
                if (!(var4_2 instanceof Some)) break block12;
                var5_3 = (Some)var4_2;
                session = (SparkSession)var5_3.value();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Hadoop impersonation: found session");
                    v0 = BoxedUnit.UNIT;
                } else {
                    v0 = BoxedUnit.UNIT;
                }
                hadoopConf = session.sparkContext().hadoopConfiguration();
                authMethod = Option$.MODULE$.apply((Object)hadoopConf.get("hadoop.security.authentication"));
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logHadoopConfigs(hadoopConf);
                    v1 = BoxedUnit.UNIT;
                } else {
                    v1 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(35).append("Hadoop impersonation: auth method: ").append(authMethod).toString());
                    v2 = BoxedUnit.UNIT;
                } else {
                    v2 = BoxedUnit.UNIT;
                }
                var9_7 = authMethod;
                if (!(var9_7 instanceof Some)) ** GOTO lbl-1000
                var10_8 = (Some)var9_7;
                v3 = authMethod = (String)var10_8.value();
                var12_10 = "kerberos";
                if (!(v3 != null ? v3.equals(var12_10) == false : var12_10 != null)) {
                    var3_11 = Option$.MODULE$.apply((Object)hadoopConf.get("dfs.namenode.https-address")).orElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$configureKerberosToFilestore$1(org.apache.hadoop.conf.Configuration ), ()Lscala/Option;)((Configuration)hadoopConf)).toRight((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$configureKerberosToFilestore$2(), ()Lcom/vertica/spark/util/error/MissingNameNodeAddressError;)()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$configureKerberosToFilestore$3(com.vertica.spark.datasource.jdbc.VerticaJdbcLayer java.lang.String ), (Ljava/lang/String;)Lscala/Tuple2;)((VerticaJdbcLayer)this)).flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$configureKerberosToFilestore$4(com.vertica.spark.datasource.jdbc.VerticaJdbcLayer com.vertica.spark.datasource.fs.FileStoreLayerInterface org.apache.hadoop.conf.Configuration scala.Tuple2 ), (Lscala/Tuple2;)Lscala/util/Either;)((VerticaJdbcLayer)this, (FileStoreLayerInterface)fileStoreLayer, (Configuration)hadoopConf));
                } else lbl-1000:
                // 2 sources

                {
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Kerberos is not enabled in the hadoop config.");
                        v4 = BoxedUnit.UNIT;
                    } else {
                        v4 = BoxedUnit.UNIT;
                    }
                    var3_11 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                }
                var2_12 = var3_11;
                break block13;
            }
            if (None$.MODULE$.equals(var4_2)) {
                var2_12 = package$.MODULE$.Left().apply((Object)new NoSparkSessionFound());
            } else {
                throw new MatchError((Object)var4_2);
            }
        }
        return var2_12;
    }

    private void logHadoopConfigs(Configuration hadoopConf) {
        BoxedUnit boxedUnit;
        String configs = ((TraversableOnce)((List)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)hadoopConf).asScala()).toList().sortBy((Function1 & Serializable & scala.Serializable)x$10 -> (String)x$10.getKey(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)entry -> new StringBuilder(1).append(entry.getKey()).append(":").append(entry.getValue()).toString(), List$.MODULE$.canBuildFrom())).mkString("\n");
        String hostname = InetAddress.getLocalHost().getHostName();
        String executorId = SparkEnv$.MODULE$.get().executorId();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Hadoop configurations for host {}, executorId {}:\n{}", new Object[]{hostname, executorId, configs});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private <T> Either<ConnectorError, T> useConnection(Connection connection, Function1<Connection, T> action, Function1<Throwable, ConnectorError> exceptionCatcher) {
        Left left;
        block3: {
            try {
                if (connection.isValid(0)) {
                    left = package$.MODULE$.Right().apply(action.apply((Object)connection));
                    break block3;
                }
                left = package$.MODULE$.Left().apply((Object)new ConnectionDownError());
            }
            catch (Throwable e) {
                left = package$.MODULE$.Left().apply(exceptionCatcher.apply((Object)e));
            }
        }
        return left;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$addParamsToStatement$1(PreparedStatement statement$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        JdbcLayerParam param = (JdbcLayerParam)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        int i = idx + 1;
        JdbcLayerParam jdbcLayerParam = param;
        if (jdbcLayerParam instanceof JdbcLayerStringParam) {
            JdbcLayerStringParam jdbcLayerStringParam = (JdbcLayerStringParam)jdbcLayerParam;
            statement$1.setString(i, jdbcLayerStringParam.value());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!(jdbcLayerParam instanceof JdbcLayerIntParam)) throw new MatchError((Object)jdbcLayerParam);
            JdbcLayerIntParam jdbcLayerIntParam = (JdbcLayerIntParam)jdbcLayerParam;
            statement$1.setInt(i, jdbcLayerIntParam.value());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$configureSession$2(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$configureAWSParameters$6(BoxedUnit _) {
    }

    public static final /* synthetic */ Option $anonfun$configureKerberosToFilestore$1(Configuration hadoopConf$1) {
        return Option$.MODULE$.apply((Object)hadoopConf$1.get("dfs.namenode.http-address"));
    }

    public static final /* synthetic */ MissingNameNodeAddressError $anonfun$configureKerberosToFilestore$2() {
        return new MissingNameNodeAddressError();
    }

    public static final /* synthetic */ Tuple2 $anonfun$configureKerberosToFilestore$3(VerticaJdbcLayer $this, String nameNodeAddress) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(41).append("Hadoop impersonation: name node address: ").append(nameNodeAddress).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit x$7 = boxedUnit;
        return new Tuple2((Object)nameNodeAddress, (Object)x$7);
    }

    public static final /* synthetic */ void $anonfun$configureKerberosToFilestore$7(BoxedUnit _) {
    }

    public static final /* synthetic */ Either $anonfun$configureKerberosToFilestore$4(VerticaJdbcLayer $this, FileStoreLayerInterface fileStoreLayer$2, Configuration hadoopConf$1, Tuple2 x$9) {
        Tuple2 tuple2 = x$9;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String nameNodeAddress = (String)tuple2._1();
        Either either = fileStoreLayer$2.getImpersonationToken($this.cfg.auth().user()).map((Function1 & Serializable & scala.Serializable)encodedDelegationToken -> {
            String string;
            Option option = Option$.MODULE$.apply((Object)hadoopConf$1.get("dfs.nameservices"));
            if (option instanceof Some) {
                Some some = (Some)option;
                String nameservice = (String)some.value();
                string = new StringBuilder(113).append("\n                  {\n                     \"nameservice\": \"").append(nameservice).append("\",\n                     \"token\": \"").append((String)encodedDelegationToken).append("\"\n                  }").toString();
            } else if (None$.MODULE$.equals(option)) {
                string = new StringBuilder(111).append("\n                  {\n                     \"authority\": \"").append(nameNodeAddress).append("\",\n                     \"token\": \"").append((String)encodedDelegationToken).append("\"\n                  }").toString();
            } else {
                throw new MatchError((Object)option);
            }
            String jsonString = string;
            String sql = new StringBuilder(48).append("ALTER SESSION SET HadoopImpersonationConfig='[").append(jsonString).append("]'").toString();
            return new Tuple3(encodedDelegationToken, (Object)jsonString, (Object)sql);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> {
            Tuple3 tuple3 = x$8;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String sql = (String)tuple3._3();
            Either either = $this.execute(sql, $this.execute$default$2()).map((Function1 & Serializable & scala.Serializable)_ -> {
                VerticaJdbcLayer.$anonfun$configureKerberosToFilestore$7(_);
                return BoxedUnit.UNIT;
            });
            return either;
        });
        return either;
    }

    public VerticaJdbcLayer(JDBCConfig cfg) {
        BoxedUnit boxedUnit;
        this.cfg = cfg;
        this.logger = LogProvider$.MODULE$.getLogger(VerticaJdbcLayer.class);
        this.prop = new Properties();
        JdbcAuth jdbcAuth = cfg.auth();
        if (jdbcAuth instanceof BasicJdbcAuth) {
            BasicJdbcAuth basicJdbcAuth = (BasicJdbcAuth)jdbcAuth;
            String username = basicJdbcAuth.username();
            String password = basicJdbcAuth.password();
            Utils$.MODULE$.ignore(this.prop().put("user", username));
            Utils$.MODULE$.ignore(this.prop().put("password", password));
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (jdbcAuth instanceof KerberosAuth) {
            KerberosAuth kerberosAuth = (KerberosAuth)jdbcAuth;
            String username = kerberosAuth.username();
            String kerberosServiceName = kerberosAuth.kerberosServiceName();
            String kerberosHostname = kerberosAuth.kerberosHostname();
            String jaasConfigName = kerberosAuth.jaasConfigName();
            Utils$.MODULE$.ignore(this.prop().put("user", username));
            Utils$.MODULE$.ignore(this.prop().put("KerberosServiceName", kerberosServiceName));
            Utils$.MODULE$.ignore(this.prop().put("KerberosHostname", kerberosHostname));
            Utils$.MODULE$.ignore(this.prop().put("JAASConfigName", jaasConfigName));
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)jdbcAuth);
        }
        this.addTLSProperties();
        if (cfg.backupServerNodes().isDefined()) {
            Utils$.MODULE$.ignore(this.prop().put("BackupServerNode", cfg.backupServerNodes().get()));
        }
        Class.forName("com.vertica.jdbc.Driver");
        this.jdbcURI = new StringBuilder(17).append("jdbc:vertica://").append(cfg.host()).append(":").append(cfg.port()).append("/").append(cfg.db()).toString();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(32).append("Connecting to Vertica with URI: ").append(this.jdbcURI()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

