/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.schema;

import cats.Applicative;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.config.TableQuery;
import com.vertica.spark.config.TableSource;
import com.vertica.spark.config.ValidColumnList;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.DatabaseReadError;
import com.vertica.spark.util.error.ErrorList;
import com.vertica.spark.util.error.JdbcSchemaError;
import com.vertica.spark.util.error.MissingSparkConversionError;
import com.vertica.spark.util.error.MissingSqlConversionError;
import com.vertica.spark.util.error.SchemaConversionError;
import com.vertica.spark.util.error.SchemaError;
import com.vertica.spark.util.error.TableNotEnoughRowsError;
import com.vertica.spark.util.error.UnknownColumnTypesError;
import com.vertica.spark.util.schema.ColumnDef;
import com.vertica.spark.util.schema.SchemaToolsInterface;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Breaks$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t%a\u0001B\f\u0019\u0001\rBQA\f\u0001\u0005\u0002=Bq!\r\u0001C\u0002\u0013%!\u0007\u0003\u0004<\u0001\u0001\u0006Ia\r\u0005\by\u0001\u0011\r\u0011\"\u0003>\u0011\u00191\u0005\u0001)A\u0005}!9q\t\u0001b\u0001\n\u0013i\u0004B\u0002%\u0001A\u0003%a\bC\u0004J\u0001\t\u0007I\u0011\u0002&\t\r9\u0003\u0001\u0015!\u0003L\u0011\u0015y\u0005\u0001\"\u0003Q\u0011\u0015i\u0006\u0001\"\u0003_\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017Aq!!\u0017\u0001\t\u0003\tY\u0006C\u0004\u0002|\u0001!\t%! \t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\"9\u0011q\u0015\u0001\u0005\n\u0005%\u0006bBAY\u0001\u0011\u0005\u00111\u0017\u0005\b\u0003{\u0003A\u0011AA`\u0011\u001d\t)\r\u0001C\u0001\u0003\u000fDq!!8\u0001\t\u0003\ty\u000eC\u0004\u0002l\u0002!\t!!<\t\u000f\u0005m\b\u0001\"\u0001\u0002~\nY1k\u00195f[\u0006$vn\u001c7t\u0015\tI\"$\u0001\u0004tG\",W.\u0019\u0006\u00037q\tA!\u001e;jY*\u0011QDH\u0001\u0006gB\f'o\u001b\u0006\u0003?\u0001\nqA^3si&\u001c\u0017MC\u0001\"\u0003\r\u0019w.\\\u0002\u0001'\r\u0001AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-bS\"\u0001\r\n\u00055B\"\u0001F*dQ\u0016l\u0017\rV8pYNLe\u000e^3sM\u0006\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0002aA\u00111\u0006A\u0001\u0007Y><w-\u001a:\u0016\u0003M\u0002\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005a\u0002\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\n\u0005i*$A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u000fUt7N\\8x]V\ta\b\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u0006!A.\u00198h\u0015\u0005\u0019\u0015\u0001\u00026bm\u0006L!!\u0012!\u0003\rM#(/\u001b8h\u0003!)hn\u001b8po:\u0004\u0013!C7bq2,gn\u001a;i\u0003)i\u0017\r\u001f7f]\u001e$\b\u000eI\u0001\u000bY>tw\r\\3oORDW#A&\u0011\u0005\u0015b\u0015BA''\u0005\rIe\u000e^\u0001\fY>tw\r\\3oORD\u0007%A\bbI\u0012$u.\u001e2mKF+x\u000e^3t)\t\t6\f\u0005\u0002S3:\u00111k\u0016\t\u0003)\u001aj\u0011!\u0016\u0006\u0003-\n\na\u0001\u0010:p_Rt\u0014B\u0001-'\u0003\u0019\u0001&/\u001a3fM&\u0011QI\u0017\u0006\u00031\u001aBQ\u0001\u0018\u0006A\u0002E\u000b1a\u001d;s\u0003=9W\r^\"bi\u0006d\u0017p\u001d;UsB,GcB0xsnl\u0018Q\u0001\t\u0005A\n$'.D\u0001b\u0015\tYb%\u0003\u0002dC\n1Q)\u001b;iKJ\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a\u000e\u0002\u000b\u0015\u0014(o\u001c:\n\u0005%4'aC*dQ\u0016l\u0017-\u0012:s_J\u0004\"a[;\u000e\u00031T!!\u001c8\u0002\u000bQL\b/Z:\u000b\u0005=\u0004\u0018aA:rY*\u0011Q$\u001d\u0006\u0003eN\fa!\u00199bG\",'\"\u0001;\u0002\u0007=\u0014x-\u0003\u0002wY\nAA)\u0019;b)f\u0004X\rC\u0003y\u0017\u0001\u00071*A\u0004tc2$\u0016\u0010]3\t\u000bi\\\u0001\u0019A&\u0002\u0013A\u0014XmY5tS>t\u0007\"\u0002?\f\u0001\u0004Y\u0015!B:dC2,\u0007\"\u0002@\f\u0001\u0004y\u0018AB:jO:,G\rE\u0002&\u0003\u0003I1!a\u0001'\u0005\u001d\u0011un\u001c7fC:Da!a\u0002\f\u0001\u0004\t\u0016\u0001\u0003;za\u0016t\u0017-\\3\u0002\u0015I,\u0017\rZ*dQ\u0016l\u0017\r\u0006\u0004\u0002\u000e\u0005U\u0012\u0011\n\t\u0007\u0003\u001f\tI#a\f\u000f\t\u0005E\u0011Q\u0005\b\u0005\u0003'\t\u0019C\u0004\u0003\u0002\u0016\u0005\u0005b\u0002BA\f\u0003?qA!!\u0007\u0002\u001e9\u0019A+a\u0007\n\u0003\u0005J!a\b\u0011\n\u0005uq\u0012BA\u000e\u001d\u0013\t9'$C\u0002\u0002(\u0019\fQ\"\u0012:s_JD\u0015M\u001c3mS:<\u0017\u0002BA\u0016\u0003[\u0011qbQ8o]\u0016\u001cGo\u001c:SKN,H\u000e\u001e\u0006\u0004\u0003O1\u0007cA6\u00022%\u0019\u00111\u00077\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u000281\u0001\r!!\u000f\u0002\u0013)$'m\u0019'bs\u0016\u0014\b\u0003BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u0005U\u0012\u00147MC\u0002\u0002Dq\t!\u0002Z1uCN|WO]2f\u0013\u0011\t9%!\u0010\u0003%)#'m\u0019'bs\u0016\u0014\u0018J\u001c;fe\u001a\f7-\u001a\u0005\b\u0003\u0017b\u0001\u0019AA'\u0003-!\u0018M\u00197f'>,(oY3\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015\u001d\u0003\u0019\u0019wN\u001c4jO&!\u0011qKA)\u0005-!\u0016M\u00197f'>,(oY3\u0002\u001b\u001d,GoQ8mk6t\u0017J\u001c4p)\u0019\ti&a\u001e\u0002zA1\u0011qBA\u0015\u0003?\u0002b!!\u0019\u0002l\u0005Ed\u0002BA2\u0003Or1\u0001VA3\u0013\u00059\u0013bAA5M\u00059\u0001/Y2lC\u001e,\u0017\u0002BA7\u0003_\u00121aU3r\u0015\r\tIG\n\t\u0004W\u0005M\u0014bAA;1\tI1i\u001c7v[:$UM\u001a\u0005\b\u0003oi\u0001\u0019AA\u001d\u0011\u001d\tY%\u0004a\u0001\u0003\u001b\n1dZ3u-\u0016\u0014H/[2b)f\u0004XM\u0012:p[N\u0003\u0018M]6UsB,GCBA@\u0003\u000b\u000bI\tE\u0003\u0002\u0010\u0005\u0005\u0015+\u0003\u0003\u0002\u0004\u00065\"\u0001D*dQ\u0016l\u0017MU3tk2$\bBBAD\u001d\u0001\u0007!.A\u0005ta\u0006\u00148\u000eV=qK\"9\u00111\u0012\bA\u0002\u00055\u0015AB:ue2,g\u000eE\u0002&\u0003\u001fK1!!%'\u0005\u0011auN\\4\u0002#\u001d,GoQ8qs\u000e{G.^7o\u0019&\u001cH\u000f\u0006\u0005\u0002\u0018\u0006e\u00151TAS!\u0015\ty!!\u000bR\u0011\u001d\t9d\u0004a\u0001\u0003sAq!!(\u0010\u0001\u0004\ty*A\u0005uC\ndWMT1nKB!\u0011qJAQ\u0013\u0011\t\u0019+!\u0015\u0003\u0013Q\u000b'\r\\3OC6,\u0007BB\r\u0010\u0001\u0004\ty#A\u0007dCN$Hk\u001c,be\u000eD\u0017M]\u000b\u0003\u0003W\u0003R!JAW#FK1!a,'\u0005%1UO\\2uS>t\u0017'A\tnC.,7i\u001c7v[:\u001c8\u000b\u001e:j]\u001e$R!UA[\u0003sCq!a.\u0012\u0001\u0004\ty&\u0001\u0006d_2,XN\u001c#fMNDq!a/\u0012\u0001\u0004\ty#\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\u0002'5\f7.\u001a+bE2,7i\u001c7v[:$UMZ:\u0015\r\u0005]\u0015\u0011YAb\u0011\u0019I\"\u00031\u0001\u00020!9\u00111\u0012\nA\u0002\u00055\u0015\u0001F4fi6+'oZ3J]N,'\u000f\u001e,bYV,7\u000f\u0006\u0005\u0002\u0018\u0006%\u00171ZAg\u0011\u001d\t9d\u0005a\u0001\u0003sAq!!(\u0014\u0001\u0004\ty\nC\u0004\u0002PN\u0001\r!!5\u0002\u001d\r|\u0007/_\"pYVlg\u000eT5tiB)Q%a5\u0002X&\u0019\u0011Q\u001b\u0014\u0003\r=\u0003H/[8o!\u0011\ty%!7\n\t\u0005m\u0017\u0011\u000b\u0002\u0010-\u0006d\u0017\u000eZ\"pYVlg\u000eT5ti\u0006!r-\u001a;NKJ<W-\u00169eCR,g+\u00197vKN$\"\"a&\u0002b\u0006\r\u0018Q]Au\u0011\u001d\t9\u0004\u0006a\u0001\u0003sAq!!(\u0015\u0001\u0004\ty\nC\u0004\u0002hR\u0001\r!a(\u0002\u001bQ,W\u000e\u001d+bE2,g*Y7f\u0011\u001d\ty\r\u0006a\u0001\u0003#\f1#\u001e9eCR,g)[3mI\u0012\u000bG/\u0019+za\u0016$\u0012\"UAx\u0003g\f90!?\t\r\u0005EX\u00031\u0001R\u0003\r\u0019w\u000e\u001c\u0005\u0007\u0003k,\u0002\u0019A)\u0002\u000f\r|GNT1nK\"1\u0011$\u0006a\u0001\u0003_Aq!a#\u0016\u0001\u0004\ti)\u0001\rj]\u001a,'/\u0012=uKJt\u0017\r\u001c+bE2,7k\u00195f[\u0006$\"\"a&\u0002\u0000\n\r!Q\u0001B\u0004\u0011\u0019\u0011\tA\u0006a\u0001#\u000692M]3bi\u0016,\u0005\u0010^3s]\u0006dG+\u00192mKN#X\u000e\u001e\u0005\u00073Y\u0001\r!a\f\t\r\u0005ue\u00031\u0001R\u0011\u001d\tYI\u0006a\u0001\u0003\u001b\u0003")
public class SchemaTools
implements SchemaToolsInterface {
    private final Logger logger = LogProvider$.MODULE$.getLogger(SchemaTools.class);
    private final String unknown;
    private final String com$vertica$spark$util$schema$SchemaTools$$maxlength;
    private final int com$vertica$spark$util$schema$SchemaTools$$longlength;

    private Logger logger() {
        return this.logger;
    }

    private String unknown() {
        return this.unknown;
    }

    public String com$vertica$spark$util$schema$SchemaTools$$maxlength() {
        return this.com$vertica$spark$util$schema$SchemaTools$$maxlength;
    }

    public int com$vertica$spark$util$schema$SchemaTools$$longlength() {
        return this.com$vertica$spark$util$schema$SchemaTools$$longlength;
    }

    public String com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(String str) {
        return new java.lang.StringBuilder(2).append("\"").append(str).append("\"").toString();
    }

    private Either<SchemaError, DataType> getCatalystType(int sqlType, int precision, int scale, boolean signed, String typename) {
        BinaryType$ binaryType$;
        int n = sqlType;
        switch (n) {
            case 2003: {
                binaryType$ = null;
                break;
            }
            case -5: {
                if (signed) {
                    binaryType$ = LongType$.MODULE$;
                    break;
                }
                binaryType$ = new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 0);
                break;
            }
            case -2: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case -7: {
                binaryType$ = BooleanType$.MODULE$;
                break;
            }
            case 2004: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case 16: {
                binaryType$ = BooleanType$.MODULE$;
                break;
            }
            case 1: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2005: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 70: {
                binaryType$ = null;
                break;
            }
            case 91: {
                binaryType$ = DateType$.MODULE$;
                break;
            }
            case 3: {
                binaryType$ = new DecimalType(precision, scale);
                break;
            }
            case 2001: {
                binaryType$ = null;
                break;
            }
            case 8: {
                binaryType$ = DoubleType$.MODULE$;
                break;
            }
            case 6: {
                binaryType$ = FloatType$.MODULE$;
                break;
            }
            case 4: {
                if (signed) {
                    binaryType$ = IntegerType$.MODULE$;
                    break;
                }
                binaryType$ = LongType$.MODULE$;
                break;
            }
            case 2000: {
                binaryType$ = null;
                break;
            }
            case -16: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -4: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case -1: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2011: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 0: {
                binaryType$ = null;
                break;
            }
            case 2: {
                if (precision != 0 || scale != 0) {
                    binaryType$ = new DecimalType(precision, scale);
                    break;
                }
                binaryType$ = new DecimalType(DecimalType$.MODULE$.USER_DEFAULT().precision(), DecimalType$.MODULE$.USER_DEFAULT().scale());
                break;
            }
            case -9: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 1111: {
                String typenameNormalized = typename.toLowerCase();
                if (typenameNormalized.startsWith("interval") || typenameNormalized.startsWith("uuid")) {
                    binaryType$ = StringType$.MODULE$;
                    break;
                }
                binaryType$ = null;
                break;
            }
            case 7: {
                binaryType$ = DoubleType$.MODULE$;
                break;
            }
            case 2006: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -8: {
                binaryType$ = LongType$.MODULE$;
                break;
            }
            case 5: {
                binaryType$ = IntegerType$.MODULE$;
                break;
            }
            case 2009: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2002: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 92: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 93: {
                binaryType$ = TimestampType$.MODULE$;
                break;
            }
            case -6: {
                binaryType$ = IntegerType$.MODULE$;
                break;
            }
            case -3: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case 12: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            default: {
                binaryType$ = null;
                break;
            }
        }
        BinaryType$ answer = binaryType$;
        return answer == null ? package$.MODULE$.Left().apply((Object)new MissingSqlConversionError(((Object)BoxesRunTime.boxToInteger((int)sqlType)).toString(), typename)) : package$.MODULE$.Right().apply((Object)answer);
    }

    @Override
    public Either<ConnectorError, StructType> readSchema(JdbcLayerInterface jdbcLayer, TableSource tableSource) {
        Left left;
        Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tableSource);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq colInfo = (Seq)right.value();
            List errorsOrFields = ((TraversableOnce)colInfo.map((Function1 & Serializable & scala.Serializable)info -> this.getCatalystType(info.colType(), info.size(), info.scale(), info.signed(), info.colTypeName()).map((Function1 & Serializable & scala.Serializable)columnType -> new StructField(info.label(), columnType, info.nullable(), info.metadata())), Seq$.MODULE$.canBuildFrom())).toList();
            left = ((Validated)implicits$.MODULE$.toTraverseOps((Object)errorsOrFields, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$1 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$1), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)field -> StructType$.MODULE$.apply((Seq)field)).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, Seq<ColumnDef>> getColumnInfo(JdbcLayerInterface jdbcLayer, TableSource tableSource) {
        Left left;
        String string;
        TableSource tableSource2 = tableSource;
        if (tableSource2 instanceof TableName) {
            TableName tableName = (TableName)tableSource2;
            string = new java.lang.StringBuilder(24).append("SELECT * FROM ").append(tableName.getFullTableName()).append(" WHERE 1=0").toString();
        } else if (tableSource2 instanceof TableQuery) {
            TableQuery tableQuery = (TableQuery)tableSource2;
            String query = tableQuery.query();
            string = new java.lang.StringBuilder(31).append("SELECT * FROM (").append(query).append(") AS x WHERE 1=0").toString();
        } else {
            throw new MatchError((Object)tableSource2);
        }
        String query = string;
        Either<ConnectorError, ResultSet> either = jdbcLayer.query(query, jdbcLayer.query$default$2());
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
        } else if (either instanceof Right) {
            Left left3;
            Right right = (Right)either;
            try (ResultSet rs = (ResultSet)right.value();){
                try {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    left3 = package$.MODULE$.Right().apply(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), rsmd.getColumnCount()).map((Function1 & Serializable & scala.Serializable)idx -> SchemaTools.$anonfun$getColumnInfo$1(rsmd, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom()));
                }
                catch (Throwable e) {
                    left3 = package$.MODULE$.Left().apply((Object)new DatabaseReadError(e).context("Could not get column info"));
                }
            }
            left = left3;
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    @Override
    public Either<SchemaError, String> getVerticaTypeFromSparkType(DataType sparkType, long strlen) {
        Object object;
        DataType dataType = sparkType;
        if (BinaryType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)new java.lang.StringBuilder(11).append("VARBINARY(").append(this.com$vertica$spark$util$schema$SchemaTools$$longlength()).append(")").toString());
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"BOOLEAN");
        } else if (ByteType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"TINYINT");
        } else if (DateType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"DATE");
        } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"INTERVAL");
        } else if (DecimalType$.MODULE$.unapply(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"DECIMAL");
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"DOUBLE PRECISION");
        } else if (FloatType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"FLOAT");
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"INTEGER");
        } else if (LongType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"BIGINT");
        } else if (NullType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"null");
        } else if (ShortType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"SMALLINT");
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            object = package$.MODULE$.Right().apply((Object)"TIMESTAMP");
        } else if (StringType$.MODULE$.equals(dataType)) {
            String vtype = strlen > (long)this.com$vertica$spark$util$schema$SchemaTools$$longlength() ? "LONG VARCHAR" : "VARCHAR";
            object = package$.MODULE$.Right().apply((Object)new java.lang.StringBuilder(2).append(vtype).append("(").append(((Object)BoxesRunTime.boxToLong((long)strlen)).toString()).append(")").toString());
        } else {
            boolean bl = dataType instanceof ArrayType ? true : (dataType instanceof MapType ? true : dataType instanceof StructType);
            object = bl ? package$.MODULE$.Right().apply((Object)new java.lang.StringBuilder(11).append("VARBINARY(").append(this.com$vertica$spark$util$schema$SchemaTools$$longlength()).append(")").toString()) : package$.MODULE$.Left().apply((Object)new MissingSparkConversionError(sparkType));
        }
        return object;
    }

    @Override
    public Either<ConnectorError, String> getCopyColumnList(JdbcLayerInterface jdbcLayer, TableName tableName, StructType schema) {
        return this.getColumnInfo(jdbcLayer, tableName).flatMap((Function1 & Serializable & scala.Serializable)columns -> {
            Right right;
            int colCount = columns.length();
            IntRef colsFound = IntRef.create((int)0);
            columns.foreach((Function1 & Serializable & scala.Serializable)column -> {
                SchemaTools.$anonfun$getCopyColumnList$2(this, schema, colsFound, tableName, column);
                return BoxedUnit.UNIT;
            });
            if (schema.length() > colCount) {
                right = package$.MODULE$.Left().apply((Object)new TableNotEnoughRowsError().context(new java.lang.StringBuilder(187).append("Error: Number of columns in the target table should be greater or equal to number of columns in the DataFrame.  Number of columns in DataFrame: ").append(schema.length()).append(". Number of columns in the target table: ").append(tableName.getFullTableName()).append(": ").append(colCount).toString()));
            } else if (colsFound.elem == schema.length()) {
                BoxedUnit boxedUnit;
                ObjectRef columnList2 = ObjectRef.create((Object)"");
                BooleanRef first = BooleanRef.create((boolean)true);
                schema.foreach((Function1 & Serializable & scala.Serializable)s -> {
                    SchemaTools.$anonfun$getCopyColumnList$5(first, columnList2, s);
                    return BoxedUnit.UNIT;
                });
                columnList2.elem = new java.lang.StringBuilder(3).append("(").append((String)columnList2.elem).append("\")").toString();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new java.lang.StringBuilder(27).append("Load by name. Column list: ").append((String)columnList2.elem).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                right = package$.MODULE$.Right().apply((Object)((String)columnList2.elem));
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Load by Position");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                right = package$.MODULE$.Right().apply((Object)"");
            }
            return right.map((Function1 & Serializable & scala.Serializable)columnList -> columnList);
        });
    }

    private Function1<String, String> castToVarchar() {
        return (Function1 & Serializable & scala.Serializable)colName -> new java.lang.StringBuilder(13).append((String)colName).append("::varchar AS ").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes((String)colName)).toString();
    }

    @Override
    public String makeColumnsString(Seq<ColumnDef> columnDefs, StructType requiredSchema) {
        Seq requiredColumnDefs = requiredSchema.nonEmpty() ? (Seq)columnDefs.filter((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)SchemaTools.$anonfun$makeColumnsString$1(requiredSchema, cd))) : columnDefs;
        return ((TraversableOnce)requiredColumnDefs.map((Function1 & Serializable & scala.Serializable)info -> {
            String string;
            int n = info.colType();
            switch (n) {
                case 1111: {
                    String typenameNormalized = info.colTypeName().toLowerCase();
                    if (typenameNormalized.startsWith("interval") || typenameNormalized.startsWith("uuid")) {
                        string = (String)this.castToVarchar().apply((Object)info.label());
                        break;
                    }
                    string = this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(info.label());
                    break;
                }
                case 92: {
                    string = (String)this.castToVarchar().apply((Object)info.label());
                    break;
                }
                default: {
                    string = this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(info.label());
                    break;
                }
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    @Override
    public Either<ConnectorError, String> makeTableColumnDefs(StructType schema, long strlen) {
        Either either;
        Object object = new Object();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(" (");
            BooleanRef first = BooleanRef.create((boolean)true);
            schema.foreach((Function1 & Serializable & scala.Serializable)s -> {
                Either<SchemaError, String> either;
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new java.lang.StringBuilder(28).append("colname=\"").append(s.name()).append("\"").append("; type=").append(s.dataType()).append("; nullable=").append(s.nullable()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Object object = !first$2.elem ? sb.append(",\n") : BoxedUnit.UNIT;
                first$2.elem = false;
                sb.append(new java.lang.StringBuilder(3).append("\"").append(s.name()).append("\" ").toString());
                String decimal_qualifier = "";
                if (s.dataType().toString().contains("DecimalType")) {
                    Regex p = new StringOps(Predef$.MODULE$.augmentString("DecimalType\\((\\d+)\\)")).r();
                    if (s.dataType().toString().matches(p.toString())) {
                        String prec;
                        String string = s.dataType().toString();
                        Option option = p.unapplySeq((CharSequence)string);
                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                            throw new MatchError((Object)string);
                        }
                        String string2 = prec = (String)((LinearSeqOptimized)option.get()).apply(0);
                        String prec2 = string2;
                        decimal_qualifier = new java.lang.StringBuilder(2).append("(").append(prec2).append(")").toString();
                    }
                    Regex ps = new StringOps(Predef$.MODULE$.augmentString("DecimalType\\((\\d+),(\\d+)\\)")).r();
                    if (s.dataType().toString().matches(ps.toString())) {
                        String string = s.dataType().toString();
                        Option option = ps.unapplySeq((CharSequence)string);
                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) {
                            throw new MatchError((Object)string);
                        }
                        String prec = (String)((LinearSeqOptimized)option.get()).apply(0);
                        String scale = (String)((LinearSeqOptimized)option.get()).apply(1);
                        Tuple2 tuple2 = new Tuple2((Object)prec, (Object)scale);
                        Tuple2 tuple22 = tuple2;
                        String prec3 = (String)tuple22._1();
                        String scale2 = (String)tuple22._2();
                        decimal_qualifier = new java.lang.StringBuilder(3).append("(").append(prec3).append(",").append(scale2).append(")").toString();
                    }
                }
                if ((either = this.getVerticaTypeFromSparkType(s.dataType(), strlen)) instanceof Left) {
                    Left left = (Left)either;
                    SchemaError err = (SchemaError)left.value();
                    throw new NonLocalReturnControl(object, (Object)package$.MODULE$.Left().apply((Object)new SchemaConversionError(err).context("Schema error when trying to create table")));
                }
                if (!(either instanceof Right)) {
                    throw new MatchError(either);
                }
                Right right = (Right)either;
                String datatype = (String)right.value();
                Right right2 = package$.MODULE$.Right().apply((Object)new java.lang.StringBuilder(0).append(datatype).append(decimal_qualifier).toString());
                return right2.map((Function1 & Serializable & scala.Serializable)col -> {
                    StringBuilder x$3 = sb.append(col);
                    BoxedUnit x$4 = !s.nullable() ? sb.append(" NOT NULL") : BoxedUnit.UNIT;
                    return new Tuple3(col, (Object)x$3, (Object)x$4);
                }).map((Function1 & Serializable & scala.Serializable)x$5 -> {
                    SchemaTools.$anonfun$makeTableColumnDefs$3(x$5);
                    return BoxedUnit.UNIT;
                });
            });
            sb.append(")");
            either = package$.MODULE$.Right().apply((Object)sb.toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                either = (Either)ex.value();
            }
            throw ex;
        }
        return either;
    }

    @Override
    public Either<ConnectorError, String> getMergeInsertValues(JdbcLayerInterface jdbcLayer, TableName tableName, Option<ValidColumnList> copyColumnList) {
        Left left;
        Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tableName);
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq info = (Seq)right.value();
            left = package$.MODULE$.Right().apply((Object)((TraversableOnce)info.map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(5).append("temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).toString(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
        } else {
            throw new MatchError(either);
        }
        Left valueList = left;
        return valueList;
    }

    @Override
    public Either<ConnectorError, String> getMergeUpdateValues(JdbcLayerInterface jdbcLayer, TableName tableName, TableName tempTableName, Option<ValidColumnList> copyColumnList) {
        Left left;
        Option<ValidColumnList> option = copyColumnList;
        if (option instanceof Some) {
            Left colList;
            Left left2;
            Some some = (Some)option;
            ValidColumnList list = (ValidColumnList)some.value();
            List customColList = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])list.toString().split(","))).toList().map((Function1 & Serializable & scala.Serializable)col -> col.trim(), List$.MODULE$.canBuildFrom());
            Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tempTableName);
            if (either instanceof Right) {
                Right right = (Right)either;
                Seq info = (Seq)right.value();
                List tupleList = (List)customColList.zip((GenIterable)info, List$.MODULE$.canBuildFrom());
                left2 = package$.MODULE$.Right().apply((Object)((TraversableOnce)tupleList.map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(6).append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes((String)x._1())).append("=temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(((ColumnDef)x._2()).label())).toString(), List$.MODULE$.canBuildFrom())).mkString(", "));
            } else if (either instanceof Left) {
                Left left3 = (Left)either;
                ConnectorError err = (ConnectorError)left3.value();
                left2 = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
            } else {
                throw new MatchError(either);
            }
            left = colList = left2;
        } else if (None$.MODULE$.equals(option)) {
            Left updateList;
            Left left4;
            Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tempTableName);
            if (either instanceof Right) {
                Right right = (Right)either;
                Seq info = (Seq)right.value();
                left4 = package$.MODULE$.Right().apply((Object)((TraversableOnce)info.map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(6).append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).append("=temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).toString(), Seq$.MODULE$.canBuildFrom())).mkString(", "));
            } else if (either instanceof Left) {
                Left left5 = (Left)either;
                ConnectorError err = (ConnectorError)left5.value();
                left4 = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
            } else {
                throw new MatchError(either);
            }
            left = updateList = left4;
        } else {
            throw new MatchError(option);
        }
        Left columnList = left;
        return columnList;
    }

    public String updateFieldDataType(String col, String colName, StructType schema, long strlen) {
        Seq fieldType = (Seq)schema.collect((PartialFunction)new scala.Serializable(this, colName, strlen){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchemaTools $outer;
            private final String colName$1;
            private final long strlen$2;

            /*
             * Unable to fully structure code
             */
            public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> default) {
                block9: {
                    block6: {
                        block8: {
                            block7: {
                                var5_3 = x1;
                                v0 = this.$outer.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(var5_3.name());
                                var6_4 = this.colName$1;
                                if (v0 != null ? v0.equals(var6_4) == false : var6_4 != null) break block6;
                                if (!var5_3.metadata().contains(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())) break block7;
                                v1 = var5_3.dataType().simpleString();
                                var7_5 = "string";
                                if (v1 != null ? v1.equals(var7_5) == false : var7_5 != null) break block7;
                                v2 = var5_3.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength()) > (long)this.$outer.com$vertica$spark$util$schema$SchemaTools$$longlength() ? new java.lang.StringBuilder(14).append("long varchar(").append(BoxesRunTime.boxToLong((long)var5_3.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())).toString()).append(")").toString() : new java.lang.StringBuilder(9).append("varchar(").append(BoxesRunTime.boxToLong((long)var5_3.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())).toString()).append(")").toString();
                                break block8;
                            }
                            if (!var5_3.metadata().contains(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())) ** GOTO lbl-1000
                            v3 = var5_3.dataType().simpleString();
                            var8_6 = "binary";
                            if (!(v3 != null ? v3.equals(var8_6) == false : var8_6 != null)) {
                                v2 = new java.lang.StringBuilder(11).append("varbinary(").append(BoxesRunTime.boxToLong((long)var5_3.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())).toString()).append(")").toString();
                            } else lbl-1000:
                            // 2 sources

                            {
                                if ((var9_7 = this.$outer.getVerticaTypeFromSparkType(var5_3.dataType(), this.strlen$2)) instanceof Right) {
                                    var10_8 = (Right)var9_7;
                                    var4_10 = dataType = (String)var10_8.value();
                                } else if (var9_7 instanceof Left) {
                                    var12_11 = (Left)var9_7;
                                    err = (SchemaError)var12_11.value();
                                    var4_10 = package$.MODULE$.Left().apply((Object)err);
                                } else {
                                    throw new MatchError(var9_7);
                                }
                                v2 = var4_10;
                            }
                        }
                        var3_13 = v2;
                        break block9;
                    }
                    var3_13 = default.apply(x1);
                }
                return (B1)var3_13;
            }

            public final boolean isDefinedAt(StructField x1) {
                StructField structField = x1;
                String string = this.$outer.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(structField.name());
                String string2 = this.colName$1;
                boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.colName$1 = colName$1;
                this.strlen$2 = strlen$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return fieldType.nonEmpty() ? new java.lang.StringBuilder(1).append(colName).append(" ").append(fieldType.head()).toString() : col;
    }

    @Override
    public Either<ConnectorError, String> inferExternalTableSchema(String createExternalTableStmt, StructType schema, String tableName, long strlen) {
        Right right;
        int indexOfClosingParantheses;
        int indexOfOpeningParantheses;
        String stmt = createExternalTableStmt.replace(new java.lang.StringBuilder(2).append("\"").append(tableName).append("\"").toString(), tableName);
        String schemaString = stmt.substring((indexOfOpeningParantheses = stmt.indexOf("(")) + 1, indexOfClosingParantheses = stmt.indexOf(")"));
        List schemaList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schemaString.split(","))).toList();
        String updatedSchema = ((TraversableOnce)schemaList.map((Function1 & Serializable & scala.Serializable)col -> {
            int indexOfFirstDoubleQuote = col.indexOf("\"");
            int indexOfSpace = col.indexOf(" ", indexOfFirstDoubleQuote);
            String colName = col.substring(indexOfFirstDoubleQuote, indexOfSpace);
            return schema.nonEmpty() ? this.updateFieldDataType((String)col, colName, schema, strlen) : (col.toLowerCase().contains("varchar") ? new java.lang.StringBuilder(10).append(colName).append(" varchar(").append(strlen).append(")").toString() : (col.toLowerCase().contains("varbinary") ? new java.lang.StringBuilder(12).append(colName).append(" varbinary(").append(this.com$vertica$spark$util$schema$SchemaTools$$longlength()).append(")").toString() : col));
        }, List$.MODULE$.canBuildFrom())).mkString(",");
        if (updatedSchema.contains(this.unknown())) {
            right = package$.MODULE$.Left().apply((Object)new UnknownColumnTypesError().context(new java.lang.StringBuilder(30).append(this.unknown()).append(" partitioned column data type.").toString()));
        } else {
            BoxedUnit boxedUnit;
            String updatedCreateTableStmt = stmt.replace(schemaString, updatedSchema);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new java.lang.StringBuilder(41).append("Updated create external table statement: ").append(updatedCreateTableStmt).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            right = package$.MODULE$.Right().apply((Object)updatedCreateTableStmt);
        }
        return right;
    }

    public static final /* synthetic */ ColumnDef $anonfun$getColumnInfo$1(ResultSetMetaData rsmd$1, int idx) {
        String columnLabel = rsmd$1.getColumnLabel(idx);
        int dataType = rsmd$1.getColumnType(idx);
        String typeName = rsmd$1.getColumnTypeName(idx);
        int fieldSize = DecimalType$.MODULE$.MAX_PRECISION();
        int fieldScale = rsmd$1.getScale(idx);
        boolean isSigned = rsmd$1.isSigned(idx);
        boolean nullable = rsmd$1.isNullable(idx) != 0;
        Metadata metadata = new MetadataBuilder().putString("name", columnLabel).build();
        return new ColumnDef(columnLabel, dataType, typeName, fieldSize, fieldScale, isSigned, nullable, metadata);
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$4(SchemaTools $this, ColumnDef column$1, IntRef colsFound$1, TableName tableName$1, StructField s) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new java.lang.StringBuilder(48).append("Comparing target table column: ").append(column$1.label()).append(" with DF column: ").append(s.name()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (s.name().equalsIgnoreCase(column$1.label())) {
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            ++colsFound$1.elem;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug(new java.lang.StringBuilder(37).append("Column: ").append(s.name()).append(" found in target table and DF").toString());
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            if (!column$1.nullable()) {
                if (s.nullable()) {
                    if ($this.logger().underlying().isWarnEnabled()) {
                        $this.logger().underlying().warn(new java.lang.StringBuilder(128).append("S2V: Column ").append(s.name()).append(" is NOT NULL in target table ").append(tableName$1.getFullTableName()).append(" but it's nullable in the DataFrame. Rows with NULL values in column ").append(s.name()).append(" will be rejected.").toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw Breaks$.MODULE$.break();
        }
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$2(SchemaTools $this, StructType schema$1, IntRef colsFound$1, TableName tableName$1, ColumnDef column) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new java.lang.StringBuilder(43).append("Will check that target column: ").append(column.label()).append(" exist in DF").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> schema$1.foreach((Function1 & Serializable & scala.Serializable)s -> {
            SchemaTools.$anonfun$getCopyColumnList$4($this, column, colsFound$1, tableName$1, s);
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$5(BooleanRef first$1, ObjectRef columnList$1, StructField s) {
        if (first$1.elem) {
            columnList$1.elem = new java.lang.StringBuilder(1).append("\"").append(s.name()).toString();
            first$1.elem = false;
        } else {
            columnList$1.elem = new java.lang.StringBuilder(3).append((String)columnList$1.elem).append("\",\"").append(s.name()).toString();
        }
    }

    public static final /* synthetic */ boolean $anonfun$makeColumnsString$2(ColumnDef cd$1, StructField field) {
        String string = field.name();
        String string2 = cd$1.label();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$makeColumnsString$1(StructType requiredSchema$1, ColumnDef cd) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema$1.fields())).exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SchemaTools.$anonfun$makeColumnsString$2(cd, field)));
    }

    public static final /* synthetic */ void $anonfun$makeTableColumnDefs$3(Tuple3 x$5) {
        Tuple3 tuple3 = x$5;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public SchemaTools() {
        this.unknown = "UNKNOWN";
        this.com$vertica$spark$util$schema$SchemaTools$$maxlength = "maxlength";
        this.com$vertica$spark$util$schema$SchemaTools$$longlength = 65000;
    }
}

