/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.fs;

import cats.Applicative;
import cats.implicits$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.AWSArg;
import com.vertica.spark.config.AWSAuth;
import com.vertica.spark.config.AWSOptions;
import com.vertica.spark.config.FileStoreConfig;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.datasource.core.DataBlock;
import com.vertica.spark.datasource.core.ParquetFileRange;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.fs.HadoopFileStoreReader;
import com.vertica.spark.datasource.fs.ParquetFileMetadata;
import com.vertica.spark.util.error.CloseWriteError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.CreateDirectoryAlreadyExistsError;
import com.vertica.spark.util.error.CreateDirectoryError;
import com.vertica.spark.util.error.CreateFileAlreadyExistsError;
import com.vertica.spark.util.error.CreateFileError;
import com.vertica.spark.util.error.FileListError;
import com.vertica.spark.util.error.FileStoreThrownError;
import com.vertica.spark.util.error.IntermediaryStoreReaderNotInitializedError;
import com.vertica.spark.util.error.IntermediaryStoreWriteError;
import com.vertica.spark.util.error.IntermediaryStoreWriterNotInitializedError;
import com.vertica.spark.util.error.MissingHDFSImpersonationTokenError;
import com.vertica.spark.util.error.OpenReadError;
import com.vertica.spark.util.error.OpenWriteError;
import com.vertica.spark.util.error.RemoveDirectoryError;
import com.vertica.spark.util.error.RemoveFileError;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.vertica.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.vertica.ParquetReadSupport$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\reb\u0001B!C\u00015C\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t?\u0002\u0011\t\u0011)A\u0005A\")\u0001\u000f\u0001C\u0001c\"9Q\u000f\u0001b\u0001\n\u00131\bbBA\u0003\u0001\u0001\u0006Ia\u001e\u0005\t\u0003\u000f\u0001!\u0019!C\u0005m\"9\u0011\u0011\u0002\u0001!\u0002\u00139\b\u0002CA\u0006\u0001\t\u0007I\u0011\u0002<\t\u000f\u00055\u0001\u0001)A\u0005o\"A\u0011q\u0002\u0001C\u0002\u0013%a\u000fC\u0004\u0002\u0012\u0001\u0001\u000b\u0011B<\t\u0011\u0005M\u0001A1A\u0005\nYDq!!\u0006\u0001A\u0003%q\u000f\u0003\u0005\u0002\u0018\u0001\u0011\r\u0011\"\u0003w\u0011\u001d\tI\u0002\u0001Q\u0001\n]D\u0001\"a\u0007\u0001\u0005\u0004%IA\u001e\u0005\b\u0003;\u0001\u0001\u0015!\u0003x\u0011%\ty\u0002\u0001b\u0001\n\u0003\t\t\u0003\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\u0012\u0011%\t)\u0004\u0001b\u0001\n\u0013\t9\u0004\u0003\u0005\u0002J\u0001\u0001\u000b\u0011BA\u001d\u0011%\tY\u0005\u0001b\u0001\n\u0013\t9\u0004\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA\u001d\u0011%\ty\u0005\u0001b\u0001\n\u0013\t9\u0004\u0003\u0005\u0002R\u0001\u0001\u000b\u0011BA\u001d\u0011%\t\u0019\u0006\u0001b\u0001\n\u0013\t)\u0006\u0003\u0005\u0002f\u0001\u0001\u000b\u0011BA,\u0011%\t9\u0007\u0001b\u0001\n\u0013\t)\u0006\u0003\u0005\u0002j\u0001\u0001\u000b\u0011BA,\u0011%\tY\u0007\u0001b\u0001\n\u0013\t)\u0006\u0003\u0005\u0002n\u0001\u0001\u000b\u0011BA,\u0011%\ty\u0007\u0001a\u0001\n\u0013\t\t\bC\u0005\u0002\u0010\u0002\u0001\r\u0011\"\u0003\u0002\u0012\"A\u0011Q\u0014\u0001!B\u0013\t\u0019\bC\u0005\u0002 \u0002\u0001\r\u0011\"\u0003\u0002\"\"I\u00111\u0016\u0001A\u0002\u0013%\u0011Q\u0016\u0005\t\u0003c\u0003\u0001\u0015)\u0003\u0002$\"I\u00111\u0017\u0001C\u0002\u0013\u0005\u0011Q\u0017\u0005\t\u0003\u0007\u0004\u0001\u0015!\u0003\u00028\"I\u0011Q\u0019\u0001C\u0002\u0013%\u0011q\u0019\u0005\t\u0003\u001f\u0004\u0001\u0015!\u0003\u0002J\u001a1\u0011\u0011\u001b\u0001\u0005\u0003'D!\"a:+\u0005\u0003\u0005\u000b\u0011BAu\u0011\u0019\u0001(\u0006\"\u0001\u0002t\"9\u0011q\u001f\u0016\u0005R\u0005e\bbBA~U\u0011E\u0011Q \u0005\b\u0005'\u0001A\u0011\u0001B\u000b\u0011\u001d\u0011)\u0005\u0001C!\u0005\u000fBqA!\u0017\u0001\t\u0003\u0012Y\u0006C\u0004\u0003^\u0001!IAa\u0018\t\u000f\tU\u0005\u0001\"\u0011\u0003\u0018\"9!1\u0015\u0001\u0005B\t\u0015\u0006b\u0002BX\u0001\u0011\u0005#\u0011\u0017\u0005\b\u0005\u007f\u0003A\u0011\tB.\u0011\u001d\u0011\t\r\u0001C!\u0005\u0007DqAa7\u0001\t\u0003\u0012i\u000eC\u0004\u0003b\u0002!\tEa9\t\u000f\t\u001d\b\u0001\"\u0011\u0003j\"9!Q\u001e\u0001\u0005B\t=\bb\u0002B|\u0001\u0011\u0005!\u0011 \u0005\b\u0007\u000b\u0001A\u0011IB\u0004\u0011\u001d\u0019y\u0001\u0001C!\u0007#Aqaa\u0006\u0001\t\u0003\n9\rC\u0004\u0004\u001a\u0001!Iaa\u0007\u0003)!\u000bGm\\8q\r&dWm\u0015;pe\u0016d\u0015-_3s\u0015\t\u0019E)\u0001\u0002gg*\u0011QIR\u0001\u000bI\u0006$\u0018m]8ve\u000e,'BA$I\u0003\u0015\u0019\b/\u0019:l\u0015\tI%*A\u0004wKJ$\u0018nY1\u000b\u0003-\u000b1aY8n\u0007\u0001\u00192\u0001\u0001(U!\ty%+D\u0001Q\u0015\u0005\t\u0016!B:dC2\f\u0017BA*Q\u0005\u0019\te.\u001f*fMB\u0011QKV\u0007\u0002\u0005&\u0011qK\u0011\u0002\u0018\r&dWm\u0015;pe\u0016d\u0015-_3s\u0013:$XM\u001d4bG\u0016\fqBZ5mKN#xN]3D_:4\u0017n\u001a\t\u00035vk\u0011a\u0017\u0006\u00039\u001a\u000baaY8oM&<\u0017B\u00010\\\u0005=1\u0015\u000e\\3Ti>\u0014XmQ8oM&<\u0017AB:dQ\u0016l\u0017\rE\u0002PC\u000eL!A\u0019)\u0003\r=\u0003H/[8o!\t!g.D\u0001f\u0015\t1w-A\u0003usB,7O\u0003\u0002iS\u0006\u00191/\u001d7\u000b\u0005\u001dS'BA6m\u0003\u0019\t\u0007/Y2iK*\tQ.A\u0002pe\u001eL!a\\3\u0003\u0015M#(/^2u)f\u0004X-\u0001\u0004=S:LGO\u0010\u000b\u0004eN$\bCA+\u0001\u0011\u0015A6\u00011\u0001Z\u0011\u0015y6\u00011\u0001a\u00035\u00196gX!D\u0007\u0016\u001b6kX&F3V\tq\u000f\u0005\u0002y\u007f:\u0011\u00110 \t\u0003uBk\u0011a\u001f\u0006\u0003y2\u000ba\u0001\u0010:p_Rt\u0014B\u0001@Q\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011AA\u0002\u0005\u0019\u0019FO]5oO*\u0011a\u0010U\u0001\u000f'Nz\u0016iQ\"F'N{6*R-!\u00035\u00196gX*F\u0007J+EkX&F3\u0006q1kM0T\u000b\u000e\u0013V\tV0L\u000bf\u0003\u0013\u0001E*4?N+5kU%P\u001d~#vjS#O\u0003E\u00196gX*F'NKuJT0U\u001f.+e\nI\u0001\u0019\u0003^\u001bvl\u0011*F\t\u0016sE+S!M'~\u0003&k\u0014,J\t\u0016\u0013\u0016!G!X'~\u001b%+\u0012#F\u001dRK\u0015\tT*`!J{e+\u0013#F%\u0002\n1bU\u001a`\u000b:#\u0005kT%O)\u0006a1kM0F\u001d\u0012\u0003v*\u0013(UA\u0005i1kM0F\u001d\u0006\u0013E*R0T'2\u000babU\u001a`\u000b:\u000b%\tT#`'Nc\u0005%\u0001\u000bTg}+e*\u0011\"M\u000b~\u0003\u0016\t\u0016%`'RKF*R\u0001\u0016'NzVIT!C\u0019\u0016{\u0006+\u0011+I?N#\u0016\fT#!\u0003\u0019awnZ4feV\u0011\u00111\u0005\t\u0005\u0003K\ty#\u0004\u0002\u0002()!\u0011\u0011FA\u0016\u00031\u00198-\u00197bY><w-\u001b8h\u0015\r\tiCS\u0001\tif\u0004Xm]1gK&!\u0011\u0011GA\u0014\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013!H,F\u0005\"#eiU0E\u000b2+u)\u0011+J\u001f:{FkT&F\u001d~#V\t\u0017+\u0016\u0005\u0005e\u0002\u0003BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u0003S>T1!a\u0011k\u0003\u0019A\u0017\rZ8pa&!\u0011qIA\u001f\u0005\u0011!V\r\u001f;\u0002=]+%\t\u0013#G'~#U\tT#H\u0003RKuJT0U\u001f.+ej\u0018+F1R\u0003\u0013AH*X\u000b\nCEIR*`\t\u0016cUiR!U\u0013>su\fV(L\u000b:{F+\u0012-U\u0003}\u0019v+\u0012\"I\t\u001a\u001bv\fR#M\u000b\u001e\u000bE+S(O?R{5*\u0012(`)\u0016CF\u000bI\u0001\u001b\u0011\u001235k\u0018#F\u0019\u0016;\u0015\tV%P\u001d~#vjS#O?R+\u0005\fV\u0001\u001c\u0011\u001235k\u0018#F\u0019\u0016;\u0015\tV%P\u001d~#vjS#O?R+\u0005\f\u0016\u0011\u0002G1+u)Q\"Z?B\u000b%+U+F)~\u0013VIQ!T\u000b~ku\nR#`\u0013:{vKU%U\u000bV\u0011\u0011q\u000b\t\u0005\u00033\n\u0019'\u0004\u0002\u0002\\)!\u0011QLA0\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0014\u0001\u00026bm\u0006LA!!\u0001\u0002\\\u0005!C*R$B\u0007f{\u0006+\u0011*R+\u0016#vLU#C\u0003N+u,T(E\u000b~KejX,S\u0013R+\u0005%\u0001\u0012M\u000b\u001e\u000b5)W0Q\u0003J\u000bV+\u0012+`%\u0016\u0013\u0015iU#`\u001b>#UiX%O?J+\u0015\tR\u0001$\u0019\u0016;\u0015iQ-`!\u0006\u0013\u0016+V#U?J+%)Q*F?6{E)R0J\u001d~\u0013V)\u0011#!\u0003%bUiR!D3~\u0003\u0016IU)V\u000bR{\u0016J\u0014+:m}\u0013VIQ!T\u000b~ku\nR#`\u0013:{vKU%U\u000b\u0006QC*R$B\u0007f{\u0006+\u0011*R+\u0016#v,\u0013(UsYz&+\u0012\"B'\u0016{Vj\u0014#F?&sul\u0016*J)\u0016\u0003\u0013AB<sSR,'/\u0006\u0002\u0002tA!q*YA;!\u0019\t9(a \u0002\u00046\u0011\u0011\u0011\u0010\u0006\u0005\u0003\u0007\nYHC\u0002\u0002~)\fq\u0001]1scV,G/\u0003\u0003\u0002\u0002\u0006e$!\u0004)beF,X\r^,sSR,'\u000f\u0005\u0003\u0002\u0006\u0006-UBAAD\u0015\r\tIiZ\u0001\tG\u0006$\u0018\r\\=ti&!\u0011QRAD\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0015]\u0014\u0018\u000e^3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0006e\u0005cA(\u0002\u0016&\u0019\u0011q\u0013)\u0003\tUs\u0017\u000e\u001e\u0005\n\u00037\u000b\u0013\u0011!a\u0001\u0003g\n1\u0001\u001f\u00132\u0003\u001d9(/\u001b;fe\u0002\naA]3bI\u0016\u0014XCAAR!\u0011y\u0015-!*\u0011\u0007U\u000b9+C\u0002\u0002*\n\u0013Q\u0003S1e_>\u0004h)\u001b7f'R|'/\u001a*fC\u0012,'/\u0001\u0006sK\u0006$WM]0%KF$B!a%\u00020\"I\u00111\u0014\u0013\u0002\u0002\u0003\u0007\u00111U\u0001\be\u0016\fG-\u001a:!\u0003)AGMZ:D_:4\u0017nZ\u000b\u0003\u0003o\u0003B!!/\u0002@6\u0011\u00111\u0018\u0006\u0005\u0003{\u000b\t%\u0001\u0003d_:4\u0017\u0002BAa\u0003w\u0013QbQ8oM&<WO]1uS>t\u0017a\u00035eMN\u001cuN\u001c4jO\u0002\n!\"Y<t\u001fB$\u0018n\u001c8t+\t\tI\rE\u0002[\u0003\u0017L1!!4\\\u0005)\tukU(qi&|gn]\u0001\fC^\u001cx\n\u001d;j_:\u001c\bEA\u000bWKJ$\u0018nY1QCJ\fX/\u001a;Ck&dG-\u001a:\u0014\u0007)\n)\u000e\u0005\u0005\u0002X\u0006u\u00171QAr\u001d\u0011\t9(!7\n\t\u0005m\u0017\u0011P\u0001\u000e!\u0006\u0014\u0018/^3u/JLG/\u001a:\n\t\u0005}\u0017\u0011\u001d\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\tY.!\u001f\u0011\u0007\u0005\u0015(&D\u0001\u0001\u0003\u00111\u0017\u000e\\3\u0011\t\u0005-\u0018q^\u0007\u0003\u0003[T1aQA!\u0013\u0011\t\t0!<\u0003\tA\u000bG\u000f\u001b\u000b\u0005\u0003G\f)\u0010C\u0004\u0002h2\u0002\r!!;\u0002\tM,GN\u001a\u000b\u0003\u0003G\fqbZ3u/JLG/Z*vaB|'\u000f\u001e\u000b\u0005\u0003\u007f\u0014\t\u0002\u0005\u0003\u0003\u0002\t5QB\u0001B\u0002\u0015\u0011\tiH!\u0002\u000b\t\t\u001d!\u0011B\u0001\fI\u0006$\u0018m]8ve\u000e,7OC\u0002\u0003\f\u001d\f\u0011\"\u001a=fGV$\u0018n\u001c8\n\t\t=!1\u0001\u0002\u0014!\u0006\u0014\u0018/^3u/JLG/Z*vaB|'\u000f\u001e\u0005\b\u0003{s\u0003\u0019AA\\\u0003Qy\u0007/\u001a8Xe&$X\rU1scV,GOR5mKR!!q\u0003B!!\u0019\u0011IBa\u000f\u0002\u0014:!!1\u0004B\u001b\u001d\u0011\u0011iBa\f\u000f\t\t}!1\u0006\b\u0005\u0005C\u0011IC\u0004\u0003\u0003$\t\u001dbb\u0001>\u0003&%\t1*\u0003\u0002J\u0015&\u0011q\tS\u0005\u0004\u0005[1\u0015\u0001B;uS2LAA!\r\u00034\u0005)QM\u001d:pe*\u0019!Q\u0006$\n\t\t]\"\u0011H\u0001\u000e\u000bJ\u0014xN\u001d%b]\u0012d\u0017N\\4\u000b\t\tE\"1G\u0005\u0005\u0005{\u0011yDA\bD_:tWm\u0019;peJ+7/\u001e7u\u0015\u0011\u00119D!\u000f\t\r\t\rs\u00061\u0001x\u0003!1\u0017\u000e\\3oC6,\u0017AF<sSR,G)\u0019;b)>\u0004\u0016M]9vKR4\u0015\u000e\\3\u0015\t\t]!\u0011\n\u0005\b\u0005\u0017\u0002\u0004\u0019\u0001B'\u0003%!\u0017\r^1CY>\u001c7\u000e\u0005\u0003\u0003P\tUSB\u0001B)\u0015\r\u0011\u0019\u0006R\u0001\u0005G>\u0014X-\u0003\u0003\u0003X\tE#!\u0003#bi\u0006\u0014En\\2l\u0003U\u0019Gn\\:f/JLG/\u001a)beF,X\r\u001e$jY\u0016$\"Aa\u0006\u0002\u001bQ|7+\u001a;Nk2$\u0018.T1q+\u0019\u0011\tG!\u001d\u0003\fR!!1\rBH!!\u0011)G!\u001b\u0003n\t\rUB\u0001B4\u0015\u0011\u0011i#a\u0018\n\t\t-$q\r\u0002\u0004\u001b\u0006\u0004\b\u0003\u0002B8\u0005cb\u0001\u0001B\u0004\u0003tI\u0012\rA!\u001e\u0003\u0003-\u000bBAa\u001e\u0003~A\u0019qJ!\u001f\n\u0007\tm\u0004KA\u0004O_RD\u0017N\\4\u0011\u0007=\u0013y(C\u0002\u0003\u0002B\u00131!\u00118z!\u0019\u0011)G!\"\u0003\n&!!q\u0011B4\u0005\r\u0019V\r\u001e\t\u0005\u0005_\u0012Y\tB\u0004\u0003\u000eJ\u0012\rA!\u001e\u0003\u0003YCqA!%3\u0001\u0004\u0011\u0019*A\u0002nCB\u0004\u0002B!\u001a\u0003j\t5$\u0011R\u0001\u0017O\u0016$\b+\u0019:rk\u0016$h)\u001b7f\u001b\u0016$\u0018\rZ1uCR!!\u0011\u0014BQ!\u0019\u0011IBa\u000f\u0003\u001cB\u0019QK!(\n\u0007\t}%IA\nQCJ\fX/\u001a;GS2,W*\u001a;bI\u0006$\u0018\r\u0003\u0004\u0003DM\u0002\ra^\u0001\u0014_B,gNU3bIB\u000b'/];fi\u001aKG.\u001a\u000b\u0005\u0005/\u00119\u000bC\u0004\u0002hR\u0002\rA!+\u0011\t\t=#1V\u0005\u0005\u0005[\u0013\tF\u0001\tQCJ\fX/\u001a;GS2,'+\u00198hK\u00069\"/Z1e\t\u0006$\u0018M\u0012:p[B\u000b'/];fi\u001aKG.\u001a\u000b\u0005\u0005g\u0013)\f\u0005\u0004\u0003\u001a\tm\"Q\n\u0005\b\u0005o+\u0004\u0019\u0001B]\u0003%\u0011Gn\\2l'&TX\rE\u0002P\u0005wK1A!0Q\u0005\rIe\u000e^\u0001\u0015G2|7/\u001a*fC\u0012\u0004\u0016M]9vKR4\u0015\u000e\\3\u0002\u0017\u001d,GOR5mK2K7\u000f\u001e\u000b\u0005\u0005\u000b\u0014I\u000e\u0005\u0004\u0003\u001a\tm\"q\u0019\t\u0006\u0005\u0013\u0014\u0019n\u001e\b\u0005\u0005\u0017\u0014yMD\u0002{\u0005\u001bL\u0011!U\u0005\u0004\u0005#\u0004\u0016a\u00029bG.\fw-Z\u0005\u0005\u0005+\u00149NA\u0002TKFT1A!5Q\u0011\u0019\u0011\u0019e\u000ea\u0001o\u0006Q!/Z7pm\u00164\u0015\u000e\\3\u0015\t\t]!q\u001c\u0005\u0007\u0005\u0007B\u0004\u0019A<\u0002\u0013I,Wn\u001c<f\t&\u0014H\u0003\u0002B\f\u0005KDaAa\u0011:\u0001\u00049\u0018AC2sK\u0006$XMR5mKR!!q\u0003Bv\u0011\u0019\u0011\u0019E\u000fa\u0001o\u0006I1M]3bi\u0016$\u0015N\u001d\u000b\u0007\u0005/\u0011\tPa=\t\r\t\r3\b1\u0001x\u0011\u0019\u0011)p\u000fa\u0001o\u0006Q\u0001/\u001a:nSN\u001c\u0018n\u001c8\u0002\u0015\u0019LG.Z#ySN$8\u000f\u0006\u0003\u0003|\u000e\r\u0001C\u0002B\r\u0005w\u0011i\u0010E\u0002P\u0005\u007fL1a!\u0001Q\u0005\u001d\u0011un\u001c7fC:DaAa\u0011=\u0001\u00049\u0018!F4fi&k\u0007/\u001a:t_:\fG/[8o)>\\WM\u001c\u000b\u0005\u0007\u0013\u0019Y\u0001E\u0003\u0003\u001a\tmr\u000f\u0003\u0004\u0004\u000eu\u0002\ra^\u0001\u0005kN,'/A\u0007hKR<En\u001c2Ti\u0006$Xo\u001d\u000b\u0005\u0005\u000b\u001c\u0019\u0002\u0003\u0004\u0004\u0016y\u0002\ra^\u0001\ba\u0006$H/\u001a:o\u000359W\r^!X'>\u0003H/[8og\u0006iQo]3GS2,7+_:uK6,Ba!\b\u0004$Q11qDB\u0014\u0007S\u0001bA!\u0007\u0003<\r\u0005\u0002\u0003\u0002B8\u0007G!qa!\nA\u0005\u0004\u0011)HA\u0001U\u0011\u0019\u0011\u0019\u0005\u0011a\u0001o\"911\u0006!A\u0002\r5\u0012\u0001\u00034t\u0003\u000e$\u0018n\u001c8\u0011\u0013=\u001byca\r\u0002j\u000e}\u0011bAB\u0019!\nIa)\u001e8di&|gN\r\t\u0005\u0003W\u001c)$\u0003\u0003\u00048\u00055(A\u0003$jY\u0016\u001c\u0016p\u001d;f[\u0002")
public class HadoopFileStoreLayer
implements FileStoreLayerInterface {
    private final FileStoreConfig fileStoreConfig;
    private final String S3_ACCESS_KEY;
    private final String S3_SECRET_KEY;
    private final String S3_SESSION_TOKEN;
    private final String AWS_CREDENTIALS_PROVIDER;
    private final String S3_ENDPOINT;
    private final String S3_ENABLE_SSL;
    private final String S3_ENABLE_PATH_STYLE;
    private final Logger logger;
    private final Text WEBHDFS_DELEGATION_TOKEN_TEXT;
    private final Text SWEBHDFS_DELEGATION_TOKEN_TEXT;
    private final Text HDFS_DELEGATION_TOKEN_TEXT;
    private final String LEGACY_PARQUET_REBASE_MODE_IN_WRITE;
    private final String LEGACY_PARQUET_REBASE_MODE_IN_READ;
    private final String LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE;
    private Option<ParquetWriter<InternalRow>> writer;
    private Option<HadoopFileStoreReader> reader;
    private final Configuration hdfsConfig;
    private final AWSOptions awsOptions;

    private String S3_ACCESS_KEY() {
        return this.S3_ACCESS_KEY;
    }

    private String S3_SECRET_KEY() {
        return this.S3_SECRET_KEY;
    }

    private String S3_SESSION_TOKEN() {
        return this.S3_SESSION_TOKEN;
    }

    private String AWS_CREDENTIALS_PROVIDER() {
        return this.AWS_CREDENTIALS_PROVIDER;
    }

    private String S3_ENDPOINT() {
        return this.S3_ENDPOINT;
    }

    private String S3_ENABLE_SSL() {
        return this.S3_ENABLE_SSL;
    }

    private String S3_ENABLE_PATH_STYLE() {
        return this.S3_ENABLE_PATH_STYLE;
    }

    public Logger logger() {
        return this.logger;
    }

    private Text WEBHDFS_DELEGATION_TOKEN_TEXT() {
        return this.WEBHDFS_DELEGATION_TOKEN_TEXT;
    }

    private Text SWEBHDFS_DELEGATION_TOKEN_TEXT() {
        return this.SWEBHDFS_DELEGATION_TOKEN_TEXT;
    }

    private Text HDFS_DELEGATION_TOKEN_TEXT() {
        return this.HDFS_DELEGATION_TOKEN_TEXT;
    }

    private String LEGACY_PARQUET_REBASE_MODE_IN_WRITE() {
        return this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE;
    }

    private String LEGACY_PARQUET_REBASE_MODE_IN_READ() {
        return this.LEGACY_PARQUET_REBASE_MODE_IN_READ;
    }

    private String LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE() {
        return this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE;
    }

    private Option<ParquetWriter<InternalRow>> writer() {
        return this.writer;
    }

    private void writer_$eq(Option<ParquetWriter<InternalRow>> x$1) {
        this.writer = x$1;
    }

    private Option<HadoopFileStoreReader> reader() {
        return this.reader;
    }

    private void reader_$eq(Option<HadoopFileStoreReader> x$1) {
        this.reader = x$1;
    }

    public Configuration hdfsConfig() {
        return this.hdfsConfig;
    }

    private AWSOptions awsOptions() {
        return this.awsOptions;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> openWriteParquetFile(String filename) {
        Left left;
        Either writerOrError;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(23).append("Opening write to file: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        VerticaParquetBuilder builder = new VerticaParquetBuilder(new Path(String.valueOf(filename)));
        Either either = writerOrError = this.removeFile(filename).flatMap((Function1 & Serializable & scala.Serializable)_ -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> builder.withConf(this.hdfsConfig()).withWriteMode(ParquetFileWriter.Mode.OVERWRITE).withCompressionCodec(CompressionCodecName.SNAPPY).build()).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new OpenWriteError((Throwable)exception).context("Error opening write to HDFS.")).map((Function1 & Serializable & scala.Serializable)writer -> writer));
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            ParquetWriter writer = (ParquetWriter)right.value();
            this.writer_$eq((Option<ParquetWriter<InternalRow>>)new Some((Object)writer));
            left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> writeDataToParquetFile(DataBlock dataBlock) {
        Right right;
        Option<ParquetWriter<InternalRow>> option = this.writer();
        if (option instanceof Some) {
            Some some = (Some)option;
            ParquetWriter reader = (ParquetWriter)some.value();
            right = package$.MODULE$.Right().apply((Object)reader);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreWriterNotInitializedError().context("Error writing parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return right.flatMap((Function1 & Serializable & scala.Serializable)writer -> ((Either)implicits$.MODULE$.toTraverseOps(dataBlock.data(), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)record -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writer.write(record)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new IntermediaryStoreWriteError((Throwable)exception).context("Error writing parquet file to HDFS.")), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable & scala.Serializable)_ -> {
            HadoopFileStoreLayer.$anonfun$writeDataToParquetFile$5(_);
            return BoxedUnit.UNIT;
        }));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> closeWriteParquetFile() {
        Right right;
        Option<ParquetWriter<InternalRow>> option = this.writer();
        if (option instanceof Some) {
            Some some = (Some)option;
            ParquetWriter reader = (ParquetWriter)some.value();
            right = package$.MODULE$.Right().apply((Object)reader);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreWriterNotInitializedError().context("Error closing write of parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return right.flatMap((Function1 & Serializable & scala.Serializable)writer -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writer.close()).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new CloseWriteError((Throwable)exception).context("Error closing write of parquet file to HDFS.")).map((Function1 & Serializable & scala.Serializable)_ -> {
            HadoopFileStoreLayer.$anonfun$closeWriteParquetFile$4(_);
            return BoxedUnit.UNIT;
        }));
    }

    private <K, V> Map<K, Set<V>> toSetMultiMap(Map<K, V> map) {
        HashMap setMultiMap = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(map.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> setMultiMap.put(entry.getKey(), Collections.singleton(entry.getValue())));
        return Collections.unmodifiableMap(setMultiMap);
    }

    @Override
    public Either<ConnectorError, ParquetFileMetadata> getParquetFileMetadata(String filename) {
        Path path = new Path(String.valueOf(filename));
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)path, (Configuration)this.hdfsConfig());
            ParquetFileReader reader = ParquetFileReader.open((InputFile)inputFile);
            int rowGroupCount = reader.getRowGroups().size();
            reader.close();
            return new ParquetFileMetadata(filename, rowGroupCount);
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new FileListError((Throwable)exception).context(new StringBuilder(33).append("Error getting metadata for file ").append(filename).append(".").toString()));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> openReadParquetFile(ParquetFileRange file) {
        Left left;
        Either readerOrError;
        BoxedUnit boxedUnit;
        String filename = file.filename();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(24).append("Opening read from file: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ParquetReadSupport readSupport = new ParquetReadSupport((Option<ZoneId>)None$.MODULE$, false, SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED(), SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED());
        Either either = readerOrError = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Path path = new Path(String.valueOf(filename));
            HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)path, (Configuration)this.hdfsConfig());
            ParquetFileReader fileReader = ParquetFileReader.open((InputFile)inputFile);
            FileMetaData parquetFileMetadata = fileReader.getFooter().getFileMetaData();
            MessageType fileSchema = parquetFileMetadata.getSchema();
            Map fileMetadata = parquetFileMetadata.getKeyValueMetaData();
            ReadSupport.ReadContext readContext = readSupport.init(new InitContext(this.hdfsConfig(), this.toSetMultiMap(fileMetadata), fileSchema));
            RecordMaterializer<InternalRow> recordConverter = readSupport.prepareForRead(this.hdfsConfig(), fileMetadata, fileSchema, readContext);
            MessageType requestedSchema = readContext.getRequestedSchema();
            fileReader.setRequestedSchema(requestedSchema);
            ColumnIOFactory columnIOFactory = new ColumnIOFactory(parquetFileMetadata.getCreatedBy());
            boolean strictTypeChecking = false;
            MessageColumnIO columnIO = columnIOFactory.getColumnIO(requestedSchema, fileSchema, strictTypeChecking);
            return new HadoopFileStoreReader(fileReader, columnIO, recordConverter, file);
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new OpenReadError((Throwable)exception).context("Error creating Parquet Reader"));
        if (either instanceof Right) {
            Right right = (Right)either;
            HadoopFileStoreReader reader = (HadoopFileStoreReader)right.value();
            this.reader_$eq((Option<HadoopFileStoreReader>)new Some((Object)reader));
            left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, DataBlock> readDataFromParquetFile(int blockSize) {
        Right right;
        Option<HadoopFileStoreReader> option = this.reader();
        if (option instanceof Some) {
            Some some = (Some)option;
            HadoopFileStoreReader reader2 = (HadoopFileStoreReader)some.value();
            right = package$.MODULE$.Right().apply((Object)reader2);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreReaderNotInitializedError().context("Error reading parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return right.flatMap((Function1 & Serializable & scala.Serializable)reader -> reader.read(blockSize).map((Function1 & Serializable & scala.Serializable)dataBlock -> dataBlock)).map((Function1 & Serializable & scala.Serializable)dataBlock -> dataBlock);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Either<ConnectorError, BoxedUnit> closeReadParquetFile() {
        void var2_5;
        Right right;
        Option<HadoopFileStoreReader> option = this.reader();
        if (option instanceof Some) {
            Some some = (Some)option;
            HadoopFileStoreReader reader2 = (HadoopFileStoreReader)some.value();
            right = package$.MODULE$.Right().apply((Object)reader2);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreReaderNotInitializedError().context("Error closing read of parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        Either r = right.flatMap((Function1 & Serializable & scala.Serializable)reader -> reader.close().map((Function1 & Serializable & scala.Serializable)_ -> {
            HadoopFileStoreLayer.$anonfun$closeReadParquetFile$2(_);
            return BoxedUnit.UNIT;
        }));
        this.reader_$eq((Option<HadoopFileStoreReader>)None$.MODULE$);
        return var2_5;
    }

    @Override
    public Either<ConnectorError, Seq<String>> getFileList(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> {
            Left left;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> fs.listStatus(path));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                FileStatus[] fileStatuses = (FileStatus[])success.value();
                left = package$.MODULE$.Right().apply((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatuses)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                left = package$.MODULE$.Left().apply((Object)new FileListError(exception).context("Error getting file list from HDFS."));
            } else {
                throw new MatchError((Object)try_);
            }
            return left;
        });
    }

    @Override
    public Either<ConnectorError, BoxedUnit> removeFile(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> fs.exists(path) ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.delete(path, true)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new RemoveFileError((Path)path, (Throwable)exception).context("Error removing HDFS file.")) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> removeDir(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> fs.exists(path) ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.delete(path, true)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new RemoveDirectoryError((Path)path, (Throwable)exception).context("Error removing HDFS directory.")) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createFile(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> !fs.exists(path) ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FSDataOutputStream stream = fs.create(path);
            stream.write(0);
            stream.close();
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new CreateFileError((Path)path, (Throwable)exception).context("Error creating HDFS file.")) : package$.MODULE$.Left().apply((Object)new CreateFileAlreadyExistsError(filename)));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createDir(String filename, String permission) {
        FsPermission perms = new FsPermission(permission);
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> {
            Left left;
            if (!fs.exists(path)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(31).append("Making path ").append(path).append(" with permissions: ").append(perms.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                left = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.mkdirs(path, perms)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new CreateDirectoryError((Path)path, (Throwable)exception).context("Error creating HDFS directory."));
            } else {
                left = package$.MODULE$.Left().apply((Object)new CreateDirectoryAlreadyExistsError(filename));
            }
            return left;
        });
    }

    @Override
    public Either<ConnectorError, Object> fileExists(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)fs.exists(path))));
    }

    @Override
    public Either<ConnectorError, String> getImpersonationToken(String user) {
        Right right;
        ObjectRef hdfsToken = ObjectRef.create((Object)None$.MODULE$);
        Option ugiUser = Option$.MODULE$.apply((Object)UserGroupInformation.getLoginUser());
        Option option = ugiUser;
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            UserGroupInformation user2 = (UserGroupInformation)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Got UGI user.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Collection existingTokens = user2.getCredentials().getAllTokens();
            for (Token token : existingTokens) {
                BoxedUnit boxedUnit2;
                Text tokenKind = token.getKind();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(21).append("Existing token kind: ").append(tokenKind.toString()).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (!this.WEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.SWEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.HDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind)) continue;
                hdfsToken.elem = new Some((Object)token.encodeToUrlString());
            }
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        this.useFileSystem(this.fileStoreConfig.address(), (Function2 & Serializable & scala.Serializable)(fs, x$3) -> {
            Token[] tokens = fs.addDelegationTokens(user, null);
            for (Token token : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens))) {
                BoxedUnit boxedUnit;
                Text tokenKind = token.getKind();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(31).append("Hadoop impersonation: IT kind: ").append(tokenKind.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (!this.WEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.SWEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.HDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind)) continue;
                hdfsToken$1.elem = new Some((Object)token.encodeToUrlString());
            }
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        });
        Option option2 = (Option)hdfsToken.elem;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String token = (String)some.value();
            right = package$.MODULE$.Right().apply((Object)token);
        } else if (None$.MODULE$.equals(option2)) {
            right = package$.MODULE$.Left().apply((Object)new MissingHDFSImpersonationTokenError(user, this.fileStoreConfig.address()));
        } else {
            throw new MatchError((Object)option2);
        }
        return right;
    }

    @Override
    public Either<ConnectorError, Seq<String>> getGlobStatus(String pattern) {
        return this.useFileSystem(pattern, (Function2 & Serializable & scala.Serializable)(fs, path) -> {
            Left left;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> fs.globStatus(path));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                FileStatus[] fileStatuses = (FileStatus[])success.value();
                left = package$.MODULE$.Right().apply((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatuses)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                left = package$.MODULE$.Left().apply((Object)new FileListError(exception).context("Error getting file list from HDFS."));
            } else {
                throw new MatchError((Object)try_);
            }
            return left;
        });
    }

    @Override
    public AWSOptions getAWSOptions() {
        return this.fileStoreConfig.awsOptions();
    }

    private <T> Either<ConnectorError, T> useFileSystem(String filename, Function2<FileSystem, Path, Either<ConnectorError, T>> fsAction) {
        Either either;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(16).append("Filestore path: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Path path = new Path(String.valueOf(filename));
            FileSystem fs = path.getFileSystem(this.hdfsConfig());
            return (Either)fsAction.apply((Object)fs, (Object)path);
        });
        if (try_ instanceof Success) {
            Either value;
            Success success = (Success)try_;
            either = value = (Either)success.value();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            either = package$.MODULE$.Left().apply((Object)new FileStoreThrownError(exception));
        } else {
            throw new MatchError((Object)try_);
        }
        return either;
    }

    public static final /* synthetic */ void $anonfun$writeDataToParquetFile$5(List _) {
    }

    public static final /* synthetic */ void $anonfun$closeWriteParquetFile$4(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$closeReadParquetFile$2(BoxedUnit _) {
    }

    public HadoopFileStoreLayer(FileStoreConfig fileStoreConfig, Option<StructType> schema) {
        this.fileStoreConfig = fileStoreConfig;
        this.S3_ACCESS_KEY = "fs.s3a.access.key";
        this.S3_SECRET_KEY = "fs.s3a.secret.key";
        this.S3_SESSION_TOKEN = "fs.s3a.session.token";
        this.AWS_CREDENTIALS_PROVIDER = "fs.s3a.aws.credentials.provider";
        this.S3_ENDPOINT = "fs.s3a.endpoint";
        this.S3_ENABLE_SSL = "fs.s3a.connection.ssl.enabled";
        this.S3_ENABLE_PATH_STYLE = "fs.s3a.path.style.access";
        this.logger = LogProvider$.MODULE$.getLogger(HadoopFileStoreLayer.class);
        this.WEBHDFS_DELEGATION_TOKEN_TEXT = new Text("WEBHDFS delegation");
        this.SWEBHDFS_DELEGATION_TOKEN_TEXT = new Text("SWEBHDFS delegation");
        this.HDFS_DELEGATION_TOKEN_TEXT = new Text("HDFS_DELEGATION_TOKEN");
        this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE = "spark.sql.legacy.parquet.datetimeRebaseModeInWrite";
        this.LEGACY_PARQUET_REBASE_MODE_IN_READ = "spark.sql.legacy.parquet.datetimeRebaseModeInRead";
        this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE = "spark.sql.legacy.parquet.int96RebaseModeInWrite";
        this.writer = None$.MODULE$;
        this.reader = None$.MODULE$;
        this.hdfsConfig = new Configuration();
        Option<StructType> option = schema;
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            StructType schema2 = (StructType)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(31).append("Read and write support schema: ").append(schema2).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.hdfsConfig().set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), schema2.json());
            this.hdfsConfig().set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), schema2.json());
            ParquetWriteSupport$.MODULE$.setSchema(schema2, this.hdfsConfig());
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        this.awsOptions = fileStoreConfig.awsOptions();
        Option<AWSArg<String>> option2 = this.awsOptions().awsCredentialsProvider();
        if (option2 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option2;
            AWSArg provider = (AWSArg)some.value();
            this.hdfsConfig().set(this.AWS_CREDENTIALS_PROVIDER(), (String)provider.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Setting {}: {}", new Object[]{this.AWS_CREDENTIALS_PROVIDER(), provider});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (None$.MODULE$.equals(option2)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS credentials provider for Hadoop config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else {
            throw new MatchError(option2);
        }
        Option<AWSAuth> option3 = this.awsOptions().awsAuth();
        if (option3 instanceof Some) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit5;
            Some some = (Some)option3;
            AWSAuth auth = (AWSAuth)some.value();
            this.hdfsConfig().set(this.S3_ACCESS_KEY(), auth.accessKeyId().arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ACCESS_KEY(), auth.accessKeyId().origin()});
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            this.hdfsConfig().set(this.S3_SECRET_KEY(), auth.secretAccessKey().arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_SECRET_KEY(), auth.secretAccessKey().origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit;
        } else if (None$.MODULE$.equals(option3)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS auth for Hadoop config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit7 = boxedUnit;
        } else {
            throw new MatchError(option3);
        }
        Option<AWSArg<String>> option4 = this.awsOptions().awsSessionToken();
        if (option4 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option4;
            AWSArg token = (AWSArg)some.value();
            this.hdfsConfig().set(this.S3_SESSION_TOKEN(), (String)token.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_SESSION_TOKEN(), token.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit8 = boxedUnit;
        } else if (None$.MODULE$.equals(option4)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS session token for Hadoop config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit9 = boxedUnit;
        } else {
            throw new MatchError(option4);
        }
        Option<AWSArg<String>> option5 = this.awsOptions().awsEndpoint();
        if (option5 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option5;
            AWSArg endpoint = (AWSArg)some.value();
            this.hdfsConfig().set(this.S3_ENDPOINT(), (String)endpoint.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ENDPOINT(), endpoint.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit10 = boxedUnit;
        } else if (None$.MODULE$.equals(option5)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not set AWS endpoint, using default.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit11 = boxedUnit;
        } else {
            throw new MatchError(option5);
        }
        Option<AWSArg<String>> option6 = this.awsOptions().enableSSL();
        if (option6 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option6;
            AWSArg enable = (AWSArg)some.value();
            this.hdfsConfig().set(this.S3_ENABLE_SSL(), (String)enable.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ENABLE_SSL(), enable.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit12 = boxedUnit;
        } else if (None$.MODULE$.equals(option6)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not set AWS SSL enabled flag, using default of true.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit13 = boxedUnit;
        } else {
            throw new MatchError(option6);
        }
        Option<AWSArg<String>> option7 = this.awsOptions().enablePathStyle();
        if (option7 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option7;
            AWSArg enable = (AWSArg)some.value();
            this.hdfsConfig().set(this.S3_ENABLE_PATH_STYLE(), (String)enable.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ENABLE_PATH_STYLE(), enable.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit14 = boxedUnit;
        } else if (None$.MODULE$.equals(option7)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not set AWS path style enabled flag, using default of false.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit15 = boxedUnit;
        } else {
            throw new MatchError(option7);
        }
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), "false");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), "true");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), "false");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), "INT96");
        this.hdfsConfig().set(this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE(), "CORRECTED");
        this.hdfsConfig().set(this.LEGACY_PARQUET_REBASE_MODE_IN_READ(), "CORRECTED");
        this.hdfsConfig().set(this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE(), "CORRECTED");
        this.hdfsConfig().setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        this.hdfsConfig().set("fs.permissions.umask-mode", "000");
    }

    public class VerticaParquetBuilder
    extends ParquetWriter.Builder<InternalRow, VerticaParquetBuilder> {
        public VerticaParquetBuilder self() {
            return this;
        }

        public ParquetWriteSupport getWriteSupport(Configuration conf) {
            return new ParquetWriteSupport();
        }

        public /* synthetic */ HadoopFileStoreLayer com$vertica$spark$datasource$fs$HadoopFileStoreLayer$VerticaParquetBuilder$$$outer() {
            return HadoopFileStoreLayer.this;
        }

        public VerticaParquetBuilder(Path file) {
            if (HadoopFileStoreLayer.this == null) {
                throw null;
            }
            super(file);
        }
    }
}

