/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.core;

import cats.Applicative;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.DistributedFilesystemReadConfig;
import com.vertica.spark.config.FileStoreConfig;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.config.TableQuery;
import com.vertica.spark.config.TableSource;
import com.vertica.spark.config.ValidFilePermissions;
import com.vertica.spark.config.VerticaMetadata;
import com.vertica.spark.config.VerticaReadMetadata;
import com.vertica.spark.datasource.core.DataBlock;
import com.vertica.spark.datasource.core.ParquetFileRange;
import com.vertica.spark.datasource.core.PartitionInfo;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemPartition;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemPartition$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe$;
import com.vertica.spark.datasource.core.VerticaPartition;
import com.vertica.spark.datasource.core.VerticaPipeInterface;
import com.vertica.spark.datasource.core.VerticaPipeReadInterface;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.fs.ParquetFileMetadata;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.v2.PushdownFilter;
import com.vertica.spark.util.Timer;
import com.vertica.spark.util.cleanup.CleanupUtilsInterface;
import com.vertica.spark.util.cleanup.FileCleanupInfo;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.CreateDirectoryAlreadyExistsError;
import com.vertica.spark.util.error.DoneReading;
import com.vertica.spark.util.error.ExportFromVerticaError;
import com.vertica.spark.util.error.InvalidPartition;
import com.vertica.spark.util.error.UninitializedReadError;
import com.vertica.spark.util.listeners.ApplicationParquetCleaner;
import com.vertica.spark.util.listeners.SparkContextWrapper;
import com.vertica.spark.util.schema.ColumnDef;
import com.vertica.spark.util.schema.SchemaToolsInterface;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple7;
import scala.Tuple8;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\tuf\u0001\u0002\u001a4\u0001yB\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t!\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005\u001d\"AA\u000b\u0001BC\u0002\u0013\u0005Q\u000b\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003W\u0011!i\u0006A!b\u0001\n\u0003q\u0006\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011\u0019\u0004!Q1A\u0005\u0002\u001dD\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\tc\u0002\u0011)\u0019!C\u0001e\"A\u0011\u0010\u0001B\u0001B\u0003%1\u000f\u0003\u0005{\u0001\t\u0015\r\u0011\"\u0001|\u0011%\t)\u0001\u0001B\u0001B\u0003%A\u0010\u0003\u0006\u0002\b\u0001\u0011)\u0019!C\u0001\u0003\u0013A!\"!\u0005\u0001\u0005\u0003\u0005\u000b\u0011BA\u0006\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+A\u0011\"a\n\u0001\u0005\u0004%I!!\u000b\t\u0011\u0005m\u0002\u0001)A\u0005\u0003WA\u0011\"!\u0010\u0001\u0005\u0004%I!!\u0003\t\u0011\u0005}\u0002\u0001)A\u0005\u0003\u0017A\u0011\"!\u0011\u0001\u0005\u0004%I!!\u0003\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003\u0017Aq!!\u0012\u0001\t\u0013\t9\u0005C\u0004\u0002|\u0001!I!! \t\u000f\u0005E\u0006\u0001\"\u0011\u00024\"9\u0011Q\u0017\u0001\u0005B\u0005]\u0006bBAa\u0001\u0011%\u00111\u0019\u0005\b\u0003;\u0004A\u0011BAp\u0011\u001d\tY\u0010\u0001C\u0005\u0003{DqA!\u0001\u0001\t\u0013\ti\u0010C\u0004\u0003\u0004\u0001!IA!\u0002\t\u000f\t\u001d\u0001\u0001\"\u0003\u0003\n!9!\u0011\u0006\u0001\u0005B\t-\u0002\"\u0003B\u0018\u0001\u0001\u0007I\u0011\u0001B\u0019\u0011%\u0011y\u0004\u0001a\u0001\n\u0003\u0011\t\u0005\u0003\u0005\u0003N\u0001\u0001\u000b\u0015\u0002B\u001a\u0011%\u0011y\u0005\u0001a\u0001\n\u0003\tI\u0001C\u0005\u0003R\u0001\u0001\r\u0011\"\u0001\u0003T!A!q\u000b\u0001!B\u0013\tY\u0001C\u0005\u0003Z\u0001\u0011\r\u0011\"\u0001\u0003\\!A!Q\r\u0001!\u0002\u0013\u0011i\u0006C\u0004\u0003h\u0001!\tA!\u001b\t\u000f\t]\u0004\u0001\"\u0003\u0003z!9!1\u0012\u0001\u0005\u0002\t5\u0005b\u0002BL\u0001\u0011\u0005!\u0011\u0014\u0005\b\u00057\u0003A\u0011\u0001BM\u000f%\u0011ijMA\u0001\u0012\u0003\u0011yJ\u0002\u00053g\u0005\u0005\t\u0012\u0001BQ\u0011\u001d\t\u0019b\fC\u0001\u0005GC\u0011B!*0#\u0003%\tAa*\u0003IY+'\u000f^5dC\u0012K7\u000f\u001e:jEV$X\r\u001a$jY\u0016\u001c\u0018p\u001d;f[J+\u0017\r\u001a)ja\u0016T!\u0001N\u001b\u0002\t\r|'/\u001a\u0006\u0003m]\n!\u0002Z1uCN|WO]2f\u0015\tA\u0014(A\u0003ta\u0006\u00148N\u0003\u0002;w\u00059a/\u001a:uS\u000e\f'\"\u0001\u001f\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001yT)\u0013\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019;U\"A\u001a\n\u0005!\u001b$\u0001\u0006,feRL7-\u0019)ja\u0016Le\u000e^3sM\u0006\u001cW\r\u0005\u0002G\u0015&\u00111j\r\u0002\u0019-\u0016\u0014H/[2b!&\u0004XMU3bI&sG/\u001a:gC\u000e,\u0017AB2p]\u001aLw-F\u0001O!\ty\u0015+D\u0001Q\u0015\tau'\u0003\u0002S!\nyB)[:ue&\u0014W\u000f^3e\r&dWm]=ti\u0016l'+Z1e\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005qa-\u001b7f'R|'/\u001a'bs\u0016\u0014X#\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0005e+\u0014A\u00014t\u0013\tY\u0006LA\fGS2,7\u000b^8sK2\u000b\u00170\u001a:J]R,'OZ1dK\u0006ya-\u001b7f'R|'/\u001a'bs\u0016\u0014\b%A\u0005kI\n\u001cG*Y=feV\tq\f\u0005\u0002aG6\t\u0011M\u0003\u0002ck\u0005!!\u000e\u001a2d\u0013\t!\u0017M\u0001\nKI\n\u001cG*Y=fe&sG/\u001a:gC\u000e,\u0017A\u00036eE\u000ed\u0015-_3sA\u0005Y1o\u00195f[\u0006$vn\u001c7t+\u0005A\u0007CA5o\u001b\u0005Q'BA6m\u0003\u0019\u00198\r[3nC*\u0011QnN\u0001\u0005kRLG.\u0003\u0002pU\n!2k\u00195f[\u0006$vn\u001c7t\u0013:$XM\u001d4bG\u0016\fAb]2iK6\fGk\\8mg\u0002\nAb\u00197fC:,\b/\u0016;jYN,\u0012a\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003m2\fqa\u00197fC:,\b/\u0003\u0002yk\n)2\t\\3b]V\u0004X\u000b^5mg&sG/\u001a:gC\u000e,\u0017!D2mK\u0006tW\u000f]+uS2\u001c\b%\u0001\u0007ta\u0006\u00148nQ8oi\u0016DH/F\u0001}!\ri\u0018\u0011A\u0007\u0002}*\u0011q\u0010\\\u0001\nY&\u001cH/\u001a8feNL1!a\u0001\u007f\u0005M\u0019\u0006/\u0019:l\u0007>tG/\u001a=u/J\f\u0007\u000f]3s\u00035\u0019\b/\u0019:l\u0007>tG/\u001a=uA\u0005AA-\u0019;b'&TX-\u0006\u0002\u0002\fA\u0019\u0001)!\u0004\n\u0007\u0005=\u0011IA\u0002J]R\f\u0011\u0002Z1uCNK'0\u001a\u0011\u0002\rqJg.\u001b;?)A\t9\"!\u0007\u0002\u001c\u0005u\u0011qDA\u0011\u0003G\t)\u0003\u0005\u0002G\u0001!)Aj\u0004a\u0001\u001d\")Ak\u0004a\u0001-\")Ql\u0004a\u0001?\")am\u0004a\u0001Q\")\u0011o\u0004a\u0001g\")!p\u0004a\u0001y\"I\u0011qA\b\u0011\u0002\u0003\u0007\u00111B\u0001\u0007Y><w-\u001a:\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003oi!!a\f\u000b\t\u0005E\u00121G\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0004\u0003kY\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\n\t\u0005e\u0012q\u0006\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005YQ.\u0019=GS2,7+\u001b>f\u00031i\u0017\r\u001f$jY\u0016\u001c\u0016N_3!\u0003=i\u0017\r\u001f*po\u001e\u0013x.\u001e9TSj,\u0017\u0001E7bqJ{wo\u0012:pkB\u001c\u0016N_3!\u0003A\u0011X\r\u001e:jKZ,W*\u001a;bI\u0006$\u0018\r\u0006\u0002\u0002JA1\u00111JA8\u0003krA!!\u0014\u0002j9!\u0011qJA3\u001d\u0011\t\t&a\u0019\u000f\t\u0005M\u0013\u0011\r\b\u0005\u0003+\nyF\u0004\u0003\u0002X\u0005uSBAA-\u0015\r\tY&P\u0001\u0007yI|w\u000e\u001e \n\u0003qJ!AO\u001e\n\u0005aJ\u0014BA78\u0013\r\t9\u0007\\\u0001\u0006KJ\u0014xN]\u0005\u0005\u0003W\ni'A\u0007FeJ|'\u000fS1oI2Lgn\u001a\u0006\u0004\u0003Ob\u0017\u0002BA9\u0003g\u0012qbQ8o]\u0016\u001cGo\u001c:SKN,H\u000e\u001e\u0006\u0005\u0003W\ni\u0007E\u0002P\u0003oJ1!!\u001fQ\u0005=1VM\u001d;jG\u0006lU\r^1eCR\f\u0017AE1eIB+8\u000f\u001b3po:4\u0015\u000e\u001c;feN$B!a \u0002\u0010B!\u0011\u0011QAE\u001d\u0011\t\u0019)!\"\u0011\u0007\u0005]\u0013)C\u0002\u0002\b\u0006\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAF\u0003\u001b\u0013aa\u0015;sS:<'bAAD\u0003\"9\u0011\u0011S\fA\u0002\u0005M\u0015a\u00049vg\"$wn\u001e8GS2$XM]:\u0011\r\u0005U\u0015qTAS\u001d\u0011\t9*a'\u000f\t\u0005]\u0013\u0011T\u0005\u0002\u0005&\u0019\u0011QT!\u0002\u000fA\f7m[1hK&!\u0011\u0011UAR\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005u\u0015\t\u0005\u0003\u0002(\u00065VBAAU\u0015\r\tY+N\u0001\u0003mJJA!a,\u0002*\nq\u0001+^:iI><hNR5mi\u0016\u0014\u0018aC4fi6+G/\u00193bi\u0006,\"!!\u0013\u0002!\u001d,G\u000fR1uC\ncwnY6TSj,WCAA]!\u0019\tY%a\u001c\u0002<B\u0019\u0001)!0\n\u0007\u0005}\u0016I\u0001\u0003M_:<\u0017!G5oGJ,W.\u001a8u%\u0006tw-Z'ba\u001e+G/\u00138eKb$b!a\u0003\u0002F\u0006e\u0007bBAd5\u0001\u0007\u0011\u0011Z\u0001\u0004[\u0006\u0004\b\u0003CAf\u0003+\fy(a\u0003\u000e\u0005\u00055'\u0002BAh\u0003#\fq!\\;uC\ndWMC\u0002\u0002T\u0006\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9.!4\u0003\u00075\u000b\u0007\u000fC\u0004\u0002\\j\u0001\r!a \u0002\u0011\u0019LG.\u001a8b[\u0016\f\u0001cZ3u!\u0006\u0014H/\u001b;j_:LeNZ8\u0015\r\u0005\u0005\u0018q]A|!\r1\u00151]\u0005\u0004\u0003K\u001c$!\u0004)beRLG/[8o\u0013:4w\u000eC\u0004\u0002jn\u0001\r!a;\u0002\u0019\u0019LG.Z'fi\u0006$\u0017\r^1\u0011\r\u0005U\u0015Q^Ay\u0013\u0011\ty/a)\u0003\u0007M+\u0017\u000fE\u0002X\u0003gL1!!>Y\u0005M\u0001\u0016M]9vKR4\u0015\u000e\\3NKR\fG-\u0019;b\u0011\u001d\tIp\u0007a\u0001\u0003\u0017\ta\u0002]1si&$\u0018n\u001c8D_VtG/A\bhKR\u001cV\r\\3di\u000ec\u0017-^:f+\t\ty\u0010\u0005\u0004\u0002L\u0005=\u0014qP\u0001\u001cO\u0016$\b+^:iI><h.Q4he\u0016<\u0017\r^3D_2,XN\\:\u0002!\u001d,Go\u0012:pkB\u0014\u0017p\u00117bkN,WCAA@\u000399W\r^\"pYVlgNT1nKN$B!a@\u0003\f!9!QB\u0010A\u0002\t=\u0011A\u0004:fcVL'/\u001a3TG\",W.\u0019\t\u0005\u0005#\u0011)#\u0004\u0002\u0003\u0014)!!Q\u0003B\f\u0003\u0015!\u0018\u0010]3t\u0015\u0011\u0011IBa\u0007\u0002\u0007M\fHNC\u00029\u0005;QAAa\b\u0003\"\u00051\u0011\r]1dQ\u0016T!Aa\t\u0002\u0007=\u0014x-\u0003\u0003\u0003(\tM!AC*ueV\u001cG\u000fV=qK\u0006qAm\u001c)sKJ+\u0017\rZ*uKB\u001cHC\u0001B\u0017!\u0019\tY%a\u001c\u0002b\u0006I\u0001/\u0019:uSRLwN\\\u000b\u0003\u0005g\u0001R\u0001\u0011B\u001b\u0005sI1Aa\u000eB\u0005\u0019y\u0005\u000f^5p]B\u0019aIa\u000f\n\u0007\tu2GA\u0013WKJ$\u0018nY1ESN$(/\u001b2vi\u0016$g)\u001b7fgf\u001cH/Z7QCJ$\u0018\u000e^5p]\u0006i\u0001/\u0019:uSRLwN\\0%KF$BAa\u0011\u0003JA\u0019\u0001I!\u0012\n\u0007\t\u001d\u0013I\u0001\u0003V]&$\b\"\u0003B&E\u0005\u0005\t\u0019\u0001B\u001a\u0003\rAH%M\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013a\u00024jY\u0016LE\r_\u0001\fM&dW-\u00133y?\u0012*\u0017\u000f\u0006\u0003\u0003D\tU\u0003\"\u0003B&K\u0005\u0005\t\u0019AA\u0006\u0003!1\u0017\u000e\\3JIb\u0004\u0013!\u0002;j[\u0016\u0014XC\u0001B/!\u0011\u0011yF!\u0019\u000e\u00031L1Aa\u0019m\u0005\u0015!\u0016.\\3s\u0003\u0019!\u0018.\\3sA\u0005\u00112\u000f^1siB\u000b'\u000f^5uS>t'+Z1e)\u0011\u0011YG!\u001c\u0011\r\u0005-\u0013q\u000eB\"\u0011\u001d\u0011y'\u000ba\u0001\u0005c\n\u0001C^3si&\u001c\u0017\rU1si&$\u0018n\u001c8\u0011\u0007\u0019\u0013\u0019(C\u0002\u0003vM\u0012\u0001CV3si&\u001c\u0017\rU1si&$\u0018n\u001c8\u0002\u001d\u001d,Go\u00117fC:,\b/\u00138g_R1!1\u0010BB\u0005\u000f\u0003R\u0001\u0011B\u001b\u0005{\u00022\u0001\u001eB@\u0013\r\u0011\t)\u001e\u0002\u0010\r&dWm\u00117fC:,\b/\u00138g_\"9!Q\u0011\u0016A\u0002\te\u0012\u0001\u00029beRDqA!#+\u0001\u0004\tY!\u0001\u0004dkJLE\r_\u0001\te\u0016\fG\rR1uCV\u0011!q\u0012\t\u0007\u0003\u0017\nyG!%\u0011\u0007\u0019\u0013\u0019*C\u0002\u0003\u0016N\u0012\u0011\u0002R1uC\ncwnY6\u0002!\u0015tG\rU1si&$\u0018n\u001c8SK\u0006$GC\u0001B6\u00031\u0019G.Z1okB4\u0015\u000e\\3t\u0003\u00112VM\u001d;jG\u0006$\u0015n\u001d;sS\n,H/\u001a3GS2,7/_:uK6\u0014V-\u00193QSB,\u0007C\u0001$0'\tys\b\u0006\u0002\u0003 \u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"A!++\t\u0005-!1V\u0016\u0003\u0005[\u0003BAa,\u0003:6\u0011!\u0011\u0017\u0006\u0005\u0005g\u0013),A\u0005v]\u000eDWmY6fI*\u0019!qW!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003<\nE&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class VerticaDistributedFilesystemReadPipe
implements VerticaPipeInterface,
VerticaPipeReadInterface {
    private final DistributedFilesystemReadConfig config;
    private final FileStoreLayerInterface fileStoreLayer;
    private final JdbcLayerInterface jdbcLayer;
    private final SchemaToolsInterface schemaTools;
    private final CleanupUtilsInterface cleanupUtils;
    private final SparkContextWrapper sparkContext;
    private final int dataSize;
    private final Logger logger;
    private final int maxFileSize;
    private final int maxRowGroupSize;
    private Option<VerticaDistributedFilesystemPartition> partition;
    private int fileIdx;
    private final Timer timer;

    public static int $lessinit$greater$default$7() {
        return VerticaDistributedFilesystemReadPipe$.MODULE$.$lessinit$greater$default$7();
    }

    public DistributedFilesystemReadConfig config() {
        return this.config;
    }

    public FileStoreLayerInterface fileStoreLayer() {
        return this.fileStoreLayer;
    }

    public JdbcLayerInterface jdbcLayer() {
        return this.jdbcLayer;
    }

    public SchemaToolsInterface schemaTools() {
        return this.schemaTools;
    }

    public CleanupUtilsInterface cleanupUtils() {
        return this.cleanupUtils;
    }

    public SparkContextWrapper sparkContext() {
        return this.sparkContext;
    }

    public int dataSize() {
        return this.dataSize;
    }

    private Logger logger() {
        return this.logger;
    }

    private int maxFileSize() {
        return this.maxFileSize;
    }

    private int maxRowGroupSize() {
        return this.maxRowGroupSize;
    }

    private Either<ConnectorError, VerticaMetadata> retrieveMetadata() {
        Right right;
        Either<ConnectorError, StructType> either = this.schemaTools().readSchema(this.jdbcLayer(), this.config().tableSource());
        if (either instanceof Right) {
            Right right2 = (Right)either;
            StructType schema = (StructType)right2.value();
            right = package$.MODULE$.Right().apply((Object)new VerticaReadMetadata(schema));
        } else if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            right = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError(either);
        }
        return right;
    }

    private String addPushdownFilters(List<PushdownFilter> pushdownFilters) {
        List<PushdownFilter> list = pushdownFilters;
        String string = Nil$.MODULE$.equals(list) ? "" : new StringBuilder(7).append(" WHERE ").append(((TraversableOnce)pushdownFilters.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getFilterString(), List$.MODULE$.canBuildFrom())).mkString(" AND ")).toString();
        return string;
    }

    @Override
    public Either<ConnectorError, VerticaMetadata> getMetadata() {
        Right right;
        Option<VerticaReadMetadata> option = this.config().metadata();
        if (option instanceof Some) {
            Some some = (Some)option;
            VerticaReadMetadata data = (VerticaReadMetadata)some.value();
            right = package$.MODULE$.Right().apply((Object)data);
        } else if (None$.MODULE$.equals(option)) {
            right = this.retrieveMetadata();
        } else {
            throw new MatchError(option);
        }
        return right;
    }

    @Override
    public Either<ConnectorError, Object> getDataBlockSize() {
        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)this.dataSize()));
    }

    private int incrementRangeMapGetIndex(Map<String, Object> map, String filename) {
        if (!map.contains((Object)filename)) {
            map.update((Object)filename, (Object)BoxesRunTime.boxToInteger((int)1));
        } else {
            map.update((Object)filename, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)map.apply((Object)filename)) + 1)));
        }
        return BoxesRunTime.unboxToInt((Object)map.apply((Object)filename)) - 1;
    }

    private PartitionInfo getPartitionInfo(Seq<ParquetFileMetadata> fileMetadata, int partitionCount) {
        PartitionInfo partitionInfo;
        int totalRowGroups = BoxesRunTime.unboxToInt((Object)((TraversableOnce)fileMetadata.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.rowGroupCount()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        if (totalRowGroups == 0) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("No data. Returning empty partition list.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            partitionInfo = new PartitionInfo((InputPartition[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(InputPartition.class)));
        } else {
            BoxedUnit boxedUnit;
            int extraSpace = totalRowGroups % partitionCount == 0 ? 0 : 1;
            int rowGroupRoom = totalRowGroups / partitionCount + extraSpace;
            IntRef i = IntRef.create((int)0);
            ObjectRef partitions = ObjectRef.create((Object)Nil$.MODULE$);
            ObjectRef curFileRanges = ObjectRef.create((Object)Nil$.MODULE$);
            Map rangeCountMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Creating partitions.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            fileMetadata.foreach((Function1 & Serializable & scala.Serializable)m -> {
                VerticaDistributedFilesystemReadPipe.$anonfun$getPartitionInfo$2(this, i, rowGroupRoom, rangeCountMap, curFileRanges, partitions, m);
                return BoxedUnit.UNIT;
            });
            if (((List)curFileRanges.elem).nonEmpty()) {
                VerticaDistributedFilesystemPartition partition = new VerticaDistributedFilesystemPartition((Seq<ParquetFileRange>)((List)curFileRanges.elem), VerticaDistributedFilesystemPartition$.MODULE$.apply$default$2());
                partitions.elem = (List)((List)partitions.elem).$colon$plus((Object)partition, List$.MODULE$.canBuildFrom());
            }
            partitions.elem = (List)((List)partitions.elem).map((Function1 & Serializable & scala.Serializable)part -> {
                Some x$1 = new Some((Object)rangeCountMap.toMap(Predef$.MODULE$.$conforms()));
                Seq<ParquetFileRange> x$2 = part.copy$default$1();
                return part.copy(x$2, (Option<scala.collection.immutable.Map<String, Object>>)x$1);
            }, List$.MODULE$.canBuildFrom());
            partitionInfo = new PartitionInfo((InputPartition[])((List)partitions.elem).toArray(ClassTag$.MODULE$.apply(InputPartition.class)));
        }
        return partitionInfo;
    }

    private Either<ConnectorError, String> getSelectClause() {
        return this.config().isAggPushedDown() ? this.getPushdownAggregateColumns() : this.getColumnNames(this.config().getRequiredSchema());
    }

    private Either<ConnectorError, String> getPushdownAggregateColumns() {
        String selectClause = ((TraversableOnce)this.config().getRequiredSchema().map((Function1 & Serializable & scala.Serializable)col -> new StringBuilder(6).append(col.name()).append(" as ").append("\"").append(col.name()).append("\"").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        return package$.MODULE$.Right().apply((Object)selectClause);
    }

    private String getGroupbyClause() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.config().getGroupBy())).nonEmpty() ? new StringBuilder(10).append(" GROUP BY ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.config().getGroupBy())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ")).toString() : "";
    }

    private Either<ConnectorError, String> getColumnNames(StructType requiredSchema) {
        Left left;
        Either<ConnectorError, Seq<ColumnDef>> either = this.schemaTools().getColumnInfo(this.jdbcLayer(), this.config().tableSource());
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err.context("Failed to get table schema when checking for fields that need casts."));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq columnDefs = (Seq)right.value();
            left = package$.MODULE$.Right().apply((Object)this.schemaTools().makeColumnsString((Seq<ColumnDef>)columnDefs, requiredSchema));
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Either<ConnectorError, PartitionInfo> doPreReadSteps() {
        fileStoreConfig = this.config().fileStoreConfig();
        v0 = new StringOps(Predef$.MODULE$.augmentString(fileStoreConfig.address())).takeRight(1);
        var4_2 = "/";
        if (!(v0 == null ? var4_2 != null : v0.equals(var4_2) == false)) ** GOTO lbl-1000
        v1 = new StringOps(Predef$.MODULE$.augmentString(fileStoreConfig.address())).takeRight(1);
        var5_3 = "\\";
        if (!(v1 != null ? v1.equals(var5_3) == false : var5_3 != null)) lbl-1000:
        // 2 sources

        {
            v2 = "";
        } else {
            v2 = "/";
        }
        delimiter = v2;
        hdfsPath = new StringBuilder(0).append(fileStoreConfig.address()).append(delimiter).append(this.config().tableSource().identifier()).toString();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(13).append("Export path: ").append(hdfsPath).toString());
            v3 = BoxedUnit.UNIT;
        } else {
            v3 = BoxedUnit.UNIT;
        }
        var8_7 = ret = this.getMetadata().flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$doPreReadSteps$1(com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe com.vertica.spark.config.FileStoreConfig java.lang.String com.vertica.spark.config.VerticaMetadata ), (Lcom/vertica/spark/config/VerticaMetadata;)Lscala/util/Either;)((VerticaDistributedFilesystemReadPipe)this, (FileStoreConfig)fileStoreConfig, (String)hdfsPath));
        if (var8_7 instanceof Left) {
            if (!this.config().fileStoreConfig().preventCleanup()) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder(31).append("Cleaning up all files in path: ").append(hdfsPath).toString());
                    v4 = BoxedUnit.UNIT;
                } else {
                    v4 = BoxedUnit.UNIT;
                }
                v5 = this.cleanupUtils().cleanupAll(this.fileStoreLayer(), hdfsPath);
            } else {
                v5 = BoxedUnit.UNIT;
            }
            var1_8 = this.jdbcLayer().close();
        } else {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Reading data from Parquet file.");
                v6 = BoxedUnit.UNIT;
            } else {
                v6 = BoxedUnit.UNIT;
            }
            var1_8 = v6;
        }
        return ret;
    }

    public Option<VerticaDistributedFilesystemPartition> partition() {
        return this.partition;
    }

    public void partition_$eq(Option<VerticaDistributedFilesystemPartition> x$1) {
        this.partition = x$1;
    }

    public int fileIdx() {
        return this.fileIdx;
    }

    public void fileIdx_$eq(int x$1) {
        this.fileIdx = x$1;
    }

    public Timer timer() {
        return this.timer;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> startPartitionRead(VerticaPartition verticaPartition) {
        Right right;
        BoxedUnit boxedUnit;
        this.timer().startTime();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting partition read.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        VerticaPartition verticaPartition2 = verticaPartition;
        if (verticaPartition2 instanceof VerticaDistributedFilesystemPartition) {
            VerticaDistributedFilesystemPartition verticaDistributedFilesystemPartition = (VerticaDistributedFilesystemPartition)verticaPartition2;
            right = package$.MODULE$.Right().apply((Object)verticaDistributedFilesystemPartition);
        } else {
            right = package$.MODULE$.Left().apply((Object)new InvalidPartition());
        }
        return right.map((Function1 & Serializable & scala.Serializable)part -> {
            this.partition_$eq((Option<VerticaDistributedFilesystemPartition>)new Some(part));
            BoxedUnit x$21 = BoxedUnit.UNIT;
            this.fileIdx_$eq(0);
            BoxedUnit x$22 = BoxedUnit.UNIT;
            return new Tuple3(part, (Object)x$21, (Object)x$22);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$23 -> {
            Either<ConnectorError, BoxedUnit> either;
            Tuple3 tuple3 = x$23;
            if (tuple3 == null) throw new MatchError((Object)tuple3);
            VerticaDistributedFilesystemPartition part = (VerticaDistributedFilesystemPartition)tuple3._1();
            Option option = part.fileRanges().headOption();
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("No files to read set on partition.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                either = package$.MODULE$.Left().apply((Object)new DoneReading());
                return either.map((Function1 & Serializable & scala.Serializable)ret -> {
                    VerticaDistributedFilesystemReadPipe.$anonfun$startPartitionRead$3(ret);
                    return BoxedUnit.UNIT;
                });
            } else {
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                Some some = (Some)option;
                ParquetFileRange head = (ParquetFileRange)some.value();
                either = this.fileStoreLayer().openReadParquetFile(head);
            }
            return either.map((Function1 & Serializable & scala.Serializable)ret -> {
                VerticaDistributedFilesystemReadPipe.$anonfun$startPartitionRead$3(ret);
                return BoxedUnit.UNIT;
            });
        });
    }

    private Option<FileCleanupInfo> getCleanupInfo(VerticaDistributedFilesystemPartition part, int curIdx) {
        Some some;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(44).append("Getting cleanup info for partition with idx ").append(curIdx).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (curIdx >= part.fileRanges().size()) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(40).append("Invalid fileIdx ").append(this.fileIdx()).append(", can't perform cleanup.").toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            some = None$.MODULE$;
        } else {
            some = new Some((Object)BoxedUnit.UNIT);
        }
        return some.map((Function1 & Serializable & scala.Serializable)x$24 -> {
            ParquetFileRange curRange = (ParquetFileRange)part.fileRanges().apply(curIdx);
            return new Tuple2(x$24, (Object)curRange);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$25 -> {
            None$ none$;
            Tuple2 tuple2 = x$25;
            if (tuple2 != null) {
                Some some;
                scala.collection.immutable.Map rangeCountMap;
                ParquetFileRange curRange = (ParquetFileRange)tuple2._2();
                Option<scala.collection.immutable.Map<String, Object>> option = part.rangeCountMap();
                if (option instanceof Some && (rangeCountMap = (scala.collection.immutable.Map)(some = (Some)option).value()).contains((Object)curRange.filename())) {
                    None$ none$2;
                    Option<Object> option2 = curRange.rangeIdx();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        int rangeIdx = BoxesRunTime.unboxToInt((Object)some2.value());
                        none$2 = new Some((Object)new FileCleanupInfo(curRange.filename(), rangeIdx, BoxesRunTime.unboxToInt((Object)rangeCountMap.apply((Object)curRange.filename()))));
                    } else if (None$.MODULE$.equals(option2)) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn(new StringBuilder(63).append("Missing range count index. Not performing any cleanup for file ").append(curRange.filename()).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        none$2 = None$.MODULE$;
                    } else {
                        throw new MatchError(option2);
                    }
                    none$ = none$2;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder(61).append("Missing range count map. Not performing any cleanup for file ").append(curRange.filename()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    none$ = None$.MODULE$;
                } else {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder(70).append("Missing value in range count map. Not performing any cleanup for file ").append(curRange.filename()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    none$ = None$.MODULE$;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Option option = none$.map((Function1 & Serializable & scala.Serializable)ret -> ret);
            return option;
        });
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Either<ConnectorError, DataBlock> readData() {
        block30: {
            block32: {
                block34: {
                    block33: {
                        block31: {
                            block27: {
                                block29: {
                                    block28: {
                                        var7_1 = this.partition();
                                        if (None$.MODULE$.equals(var7_1)) {
                                            return package$.MODULE$.Left().apply((Object)new UninitializedReadError());
                                        }
                                        if (!(var7_1 instanceof Some)) {
                                            throw new MatchError(var7_1);
                                        }
                                        var8_2 = (Some)var7_1;
                                        var5_4 = p = (VerticaDistributedFilesystemPartition)var8_2.value();
                                        part = var5_4;
                                        var11_6 = this.fileStoreLayer().readDataFromParquetFile(this.dataSize());
                                        if (var11_6 instanceof Left) {
                                            var12_7 = (Left)var11_6;
                                            err = (ConnectorError)var12_7.value();
                                            var4_9 = package$.MODULE$.Left().apply((Object)err);
                                        } else if (var11_6 instanceof Right) {
                                            var14_10 = (Right)var11_6;
                                            data = (DataBlock)var14_10.value();
                                            if (data.data().nonEmpty()) {
                                                v0 = package$.MODULE$.Right().apply((Object)data);
                                            } else {
                                                if (this.logger().underlying().isInfoEnabled()) {
                                                    this.logger().underlying().info("Hit done reading for file segment.");
                                                    v1 = BoxedUnit.UNIT;
                                                } else {
                                                    v1 = BoxedUnit.UNIT;
                                                }
                                                this.fileIdx_$eq(this.fileIdx() + 1);
                                                if (this.fileIdx() >= part.fileRanges().size()) {
                                                    return package$.MODULE$.Right().apply((Object)data);
                                                }
                                                v0 = this.fileStoreLayer().closeReadParquetFile().flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$readData$1(com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe com.vertica.spark.datasource.core.VerticaDistributedFilesystemPartition scala.runtime.BoxedUnit ), (Lscala/runtime/BoxedUnit;)Lscala/util/Either;)((VerticaDistributedFilesystemReadPipe)this, (VerticaDistributedFilesystemPartition)part));
                                            }
                                            var4_9 = v0;
                                        } else {
                                            throw new MatchError(var11_6);
                                        }
                                        ret = var4_9;
                                        var16_13 = new Tuple2((Object)ret, this.getCleanupInfo(part, this.fileIdx()));
                                        if (var16_13 == null) break block27;
                                        var17_14 = (Either)var16_13._1();
                                        var18_15 = (Option)var16_13._2();
                                        if (!(var17_14 instanceof Left) || !(var18_15 instanceof Some)) break block27;
                                        var19_16 = (Some)var18_15;
                                        cleanupInfo = (FileCleanupInfo)var19_16.value();
                                        if (this.config().fileStoreConfig().preventCleanup()) break block28;
                                        var21_18 = this.cleanupUtils().checkAndCleanup(this.fileStoreLayer(), cleanupInfo);
                                        if (!(var21_18 instanceof Right)) ** GOTO lbl-1000
                                        var22_19 = (Right)var21_18;
                                        var23_20 = (BoxedUnit)var22_19.value();
                                        v2 = BoxedUnit.UNIT;
                                        var24_21 = var23_20;
                                        if (!(v2 != null ? v2.equals(var24_21) == false : var24_21 != null)) {
                                            var3_22 = BoxedUnit.UNIT;
                                        } else if (var21_18 instanceof Left) {
                                            var25_24 = (Left)var21_18;
                                            err = (ConnectorError)var25_24.value();
                                            if (this.logger().underlying().isWarnEnabled()) {
                                                this.logger().underlying().warn(new StringBuilder(33).append("Ran into error when cleaning up: ").append(err.getFullContext()).toString());
                                                v3 = BoxedUnit.UNIT;
                                            } else {
                                                v3 = BoxedUnit.UNIT;
                                            }
                                            var3_23 = v3;
                                        } else {
                                            throw new MatchError(var21_18);
                                        }
                                        v4 = BoxedUnit.UNIT;
                                        break block29;
                                    }
                                    v4 = BoxedUnit.UNIT;
                                }
                                var1_26 = v4;
                                break block30;
                            }
                            if (var16_13 == null) break block31;
                            var27_30 = (Either)var16_13._1();
                            var28_31 = (Option)var16_13._2();
                            if (!(var27_30 instanceof Left) || !None$.MODULE$.equals(var28_31)) break block31;
                            if (this.logger().underlying().isWarnEnabled()) {
                                this.logger().underlying().warn("No cleanup info found");
                                v5 = BoxedUnit.UNIT;
                            } else {
                                v5 = BoxedUnit.UNIT;
                            }
                            var1_27 = v5;
                            break block30;
                        }
                        if (var16_13 == null) break block32;
                        var29_32 = (Either)var16_13._1();
                        var30_33 = (Option)var16_13._2();
                        if (!(var29_32 instanceof Right)) break block32;
                        var31_34 = (Right)var29_32;
                        dataBlock = (DataBlock)var31_34.value();
                        if (!(var30_33 instanceof Some)) break block32;
                        var33_36 = (Some)var30_33;
                        cleanupInfo = (FileCleanupInfo)var33_36.value();
                        if (!dataBlock.data().isEmpty() || this.config().fileStoreConfig().preventCleanup()) break block33;
                        var35_38 = this.cleanupUtils().checkAndCleanup(this.fileStoreLayer(), cleanupInfo);
                        if (!(var35_38 instanceof Right)) ** GOTO lbl-1000
                        var36_39 = (Right)var35_38;
                        var37_40 = (BoxedUnit)var36_39.value();
                        v6 = BoxedUnit.UNIT;
                        var38_41 = var37_40;
                        if (!(v6 != null ? v6.equals(var38_41) == false : var38_41 != null)) {
                            var2_42 = BoxedUnit.UNIT;
                        } else if (var35_38 instanceof Left) {
                            var39_44 = (Left)var35_38;
                            err = (ConnectorError)var39_44.value();
                            if (this.logger().underlying().isWarnEnabled()) {
                                this.logger().underlying().warn(new StringBuilder(33).append("Ran into error when cleaning up: ").append(err.getFullContext()).toString());
                                v7 = BoxedUnit.UNIT;
                            } else {
                                v7 = BoxedUnit.UNIT;
                            }
                            var2_43 = v7;
                        } else {
                            throw new MatchError(var35_38);
                        }
                        v8 = BoxedUnit.UNIT;
                        break block34;
                    }
                    v8 = BoxedUnit.UNIT;
                }
                var1_28 = v8;
                break block30;
            }
            if (var16_13 == null) ** GOTO lbl-1000
            var41_46 = (Either)var16_13._1();
            var42_47 = (Option)var16_13._2();
            if (var41_46 instanceof Right && None$.MODULE$.equals(var42_47)) {
                var1_29 = BoxedUnit.UNIT;
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var16_13);
            }
        }
        return ret;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> endPartitionRead() {
        this.timer().endTime();
        return this.cleanupFiles().flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.fileStoreLayer().closeReadParquetFile().map((Function1 & Serializable & scala.Serializable)_ -> {
            VerticaDistributedFilesystemReadPipe.$anonfun$endPartitionRead$2(_);
            return BoxedUnit.UNIT;
        }));
    }

    public Either<ConnectorError, BoxedUnit> cleanupFiles() {
        VerticaDistributedFilesystemPartition p;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Removing files before closing read pipe.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option<VerticaDistributedFilesystemPartition> option = this.partition();
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)new UninitializedReadError());
        }
        if (!(option instanceof Some)) {
            throw new MatchError(option);
        }
        Some some = (Some)option;
        VerticaDistributedFilesystemPartition verticaDistributedFilesystemPartition = p = (VerticaDistributedFilesystemPartition)some.value();
        VerticaDistributedFilesystemPartition part = verticaDistributedFilesystemPartition;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), part.fileRanges().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)fileIdx -> {
            if (!this.config().fileStoreConfig().preventCleanup()) {
                Option<FileCleanupInfo> option = this.getCleanupInfo(part, fileIdx);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FileCleanupInfo cleanupInfo = (FileCleanupInfo)some.value();
                    Either<ConnectorError, BoxedUnit> either = this.cleanupUtils().checkAndCleanup(this.fileStoreLayer(), cleanupInfo);
                    if (either instanceof Left) {
                        BoxedUnit boxedUnit;
                        Left left = (Left)either;
                        ConnectorError err = (ConnectorError)left.value();
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn(new StringBuilder(69).append("Ran into error when calling cleaning up. Treating as non-fatal. Err: ").append(err.getFullContext()).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else if (either instanceof Right) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(either);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("No cleanup info found.");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                } else {
                    throw new MatchError(option);
                }
            }
        });
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    public static final /* synthetic */ void $anonfun$getPartitionInfo$2(VerticaDistributedFilesystemReadPipe $this, IntRef i$1, int rowGroupRoom$1, Map rangeCountMap$1, ObjectRef curFileRanges$1, ObjectRef partitions$1, ParquetFileMetadata m) {
        BoxedUnit boxedUnit;
        int size = m.rowGroupCount();
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(37).append("Splitting file ").append(m.filename()).append(" with row group count ").append(size).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        int low = 0;
        for (int j = 0; j < size; ++j) {
            if (i$1.elem == rowGroupRoom$1 - 1) {
                BoxedUnit boxedUnit2;
                int rangeIdx = $this.incrementRangeMapGetIndex((Map<String, Object>)rangeCountMap$1, m.filename());
                ParquetFileRange frange = new ParquetFileRange(m.filename(), low, j, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)rangeIdx)));
                curFileRanges$1.elem = (List)((List)curFileRanges$1.elem).$colon$plus((Object)frange, List$.MODULE$.canBuildFrom());
                VerticaDistributedFilesystemPartition partition = new VerticaDistributedFilesystemPartition((Seq<ParquetFileRange>)((List)curFileRanges$1.elem), VerticaDistributedFilesystemPartition$.MODULE$.apply$default$2());
                partitions$1.elem = (List)((List)partitions$1.elem).$colon$plus((Object)partition, List$.MODULE$.canBuildFrom());
                curFileRanges$1.elem = Nil$.MODULE$;
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug(new StringBuilder(65).append("Reached partition with file ").append(m.filename()).append(" , range low: ").append(low).append(" , range high: ").append(j).append(" , idx: ").append(rangeIdx).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                i$1.elem = 0;
                low = j + 1;
                continue;
            }
            if (j == size - 1) {
                BoxedUnit boxedUnit3;
                int rangeIdx = $this.incrementRangeMapGetIndex((Map<String, Object>)rangeCountMap$1, m.filename());
                ParquetFileRange frange = new ParquetFileRange(m.filename(), low, j, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)rangeIdx)));
                curFileRanges$1.elem = (List)((List)curFileRanges$1.elem).$colon$plus((Object)frange, List$.MODULE$.canBuildFrom());
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug(new StringBuilder(57).append("Reached end of file ").append(m.filename()).append(" , range low: ").append(low).append(" , range high: ").append(j).append(" , idx: ").append(rangeIdx).toString());
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                ++i$1.elem;
                continue;
            }
            ++i$1.elem;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$doPreReadSteps$5(VerticaDistributedFilesystemReadPipe $this, boolean exportDone) {
        ValidFilePermissions filePermissions = $this.config().filePermissions();
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exportDone), (Object)filePermissions);
    }

    public static final /* synthetic */ Either $anonfun$doPreReadSteps$11(VerticaDistributedFilesystemReadPipe $this, String hdfsPath$1, boolean dirExists) {
        return (!dirExists ? package$.MODULE$.Right().apply((Object)Nil$.MODULE$) : $this.fileStoreLayer().getFileList(hdfsPath$1)).map((Function1 & Serializable & scala.Serializable)fullFileList -> {
            BoxedUnit boxedUnit;
            BoxedUnit x$10;
            BoxedUnit boxedUnit2;
            int n;
            Seq parquetFileList = (Seq)fullFileList.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)x.endsWith(".parquet")));
            Option<Object> option = $this.config().partitionCount();
            if (option instanceof Some) {
                int count;
                Some some = (Some)option;
                n = count = BoxesRunTime.unboxToInt((Object)some.value());
            } else if (None$.MODULE$.equals(option)) {
                n = parquetFileList.size();
            } else {
                throw new MatchError(option);
            }
            int requestedPartitionCount = n;
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringBuilder(27).append("Requested partition count: ").append(requestedPartitionCount).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = x$10 = BoxedUnit.UNIT;
            }
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringBuilder(24).append("Parquet file list size: ").append(parquetFileList.size()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$11 = boxedUnit;
            Timer partitionTimer = new Timer($this.config().timeOperations(), $this.logger(), "Reading Parquet Files Metadata and creating partitions");
            partitionTimer.startTime();
            BoxedUnit x$12 = BoxedUnit.UNIT;
            return new Tuple7(fullFileList, (Object)parquetFileList, (Object)BoxesRunTime.boxToInteger((int)requestedPartitionCount), (Object)x$10, (Object)x$11, (Object)partitionTimer, (Object)x$12);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$17 -> {
            Tuple7 tuple7 = x$17;
            if (tuple7 == null) {
                throw new MatchError((Object)tuple7);
            }
            Seq parquetFileList = (Seq)tuple7._2();
            int requestedPartitionCount = BoxesRunTime.unboxToInt((Object)tuple7._3());
            Timer partitionTimer = (Timer)tuple7._6();
            Either either = ((Either)implicits$.MODULE$.toTraverseOps((Object)parquetFileList.toList(), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)filename -> $this.fileStoreLayer().getParquetFileMetadata((String)filename), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable & scala.Serializable)fileMetadata -> {
                int n;
                Either<ConnectorError, BoxedUnit> x$14;
                Either<ConnectorError, BoxedUnit> either;
                BoxedUnit x$13;
                BoxedUnit boxedUnit;
                int totalRowGroups = BoxesRunTime.unboxToInt((Object)((TraversableOnce)fileMetadata.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.rowGroupCount()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info(new StringBuilder(18).append("Total row groups: ").append(totalRowGroups).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = x$13 = BoxedUnit.UNIT;
                }
                if (totalRowGroups == 0) {
                    if (!$this.config().fileStoreConfig().preventCleanup()) {
                        BoxedUnit boxedUnit2;
                        if ($this.logger().underlying().isDebugEnabled()) {
                            $this.logger().underlying().debug(new StringBuilder(37).append("Cleaning up empty directory in path: ").append(hdfsPath$1).toString());
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        either = $this.cleanupUtils().cleanupAll($this.fileStoreLayer(), hdfsPath$1);
                    } else {
                        either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    }
                } else {
                    either = x$14 = BoxedUnit.UNIT;
                }
                if (totalRowGroups < requestedPartitionCount) {
                    BoxedUnit boxedUnit3;
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(43).append("Less than ").append(requestedPartitionCount).append(" partitions required, only using ").append(totalRowGroups).toString());
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    n = totalRowGroups;
                } else {
                    n = requestedPartitionCount;
                }
                int partitionCount = n;
                PartitionInfo partitionInfo = $this.getPartitionInfo((Seq<ParquetFileMetadata>)fileMetadata, partitionCount);
                partitionTimer.endTime();
                BoxedUnit x$15 = BoxedUnit.UNIT;
                return new Tuple7(fileMetadata, (Object)BoxesRunTime.boxToInteger((int)totalRowGroups), (Object)x$13, x$14, (Object)BoxesRunTime.boxToInteger((int)partitionCount), (Object)partitionInfo, (Object)x$15);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> {
                Tuple7 tuple7 = x$16;
                if (tuple7 == null) {
                    throw new MatchError((Object)tuple7);
                }
                PartitionInfo partitionInfo = (PartitionInfo)tuple7._6();
                Either either = $this.jdbcLayer().close().map((Function1 & Serializable & scala.Serializable)_ -> partitionInfo);
                return either;
            });
            return either;
        });
    }

    public static final /* synthetic */ Either $anonfun$doPreReadSteps$1(VerticaDistributedFilesystemReadPipe $this, FileStoreConfig fileStoreConfig$1, String hdfsPath$1, VerticaMetadata _) {
        return $this.jdbcLayer().configureSession($this.fileStoreLayer()).map((Function1 & Serializable & scala.Serializable)x$5 -> {
            BoxedUnit boxedUnit;
            ValidFilePermissions perm = $this.config().filePermissions();
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringBuilder(46).append("Creating unique directory: ").append(fileStoreConfig$1.address()).append(" with permissions: ").append(perm).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$6 = boxedUnit;
            return new Tuple3(x$5, (Object)perm, (Object)x$6);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$20 -> {
            Right right;
            Tuple3 tuple3 = x$20;
            if (tuple3 == null) throw new MatchError((Object)tuple3);
            ValidFilePermissions perm = (ValidFilePermissions)tuple3._2();
            Either<ConnectorError, BoxedUnit> either = $this.fileStoreLayer().createDir(fileStoreConfig$1.address(), perm.toString());
            if (either instanceof Left) {
                Right right2;
                Left left = (Left)either;
                ConnectorError err = (ConnectorError)left.value();
                ConnectorError connectorError = err.getUnderlyingError();
                if (connectorError instanceof CreateDirectoryAlreadyExistsError) {
                    BoxedUnit boxedUnit;
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(27).append("Directory already existed: ").append(fileStoreConfig$1.address()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    right2 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                } else {
                    right2 = package$.MODULE$.Left().apply((Object)err.context(new StringBuilder(28).append("Failed to create directory: ").append(fileStoreConfig$1.address()).toString()));
                }
                right = right2;
                return right.flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.fileStoreLayer().fileExists(hdfsPath$1).map((Function1 & Serializable & scala.Serializable)exportDone -> VerticaDistributedFilesystemReadPipe.$anonfun$doPreReadSteps$5($this, BoxesRunTime.unboxToBoolean((Object)exportDone))).flatMap((Function1 & Serializable & scala.Serializable)x$19 -> {
                    Tuple2 tuple2 = x$19;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    boolean exportDone = tuple2._1$mcZ$sp();
                    ValidFilePermissions filePermissions = (ValidFilePermissions)tuple2._2();
                    Either either = $this.getSelectClause().map((Function1 & Serializable & scala.Serializable)selectClause -> {
                        BoxedUnit boxedUnit;
                        String string;
                        BoxedUnit boxedUnit2;
                        BoxedUnit boxedUnit3;
                        if ($this.logger().underlying().isInfoEnabled()) {
                            $this.logger().underlying().info(new StringBuilder(25).append("Select clause requested: ").append((String)selectClause).toString());
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        BoxedUnit x$7 = boxedUnit3;
                        String groupbyClause = $this.getGroupbyClause();
                        String pushdownFilters = $this.addPushdownFilters($this.config().getPushdownFilters());
                        if ($this.logger().underlying().isInfoEnabled()) {
                            $this.logger().underlying().info(new StringBuilder(18).append("Pushdown filters: ").append(pushdownFilters).toString());
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        BoxedUnit x$8 = boxedUnit2;
                        TableSource tableSource = $this.config().tableSource();
                        if (tableSource instanceof TableName) {
                            TableName tableName = (TableName)tableSource;
                            string = tableName.getFullTableName();
                        } else if (tableSource instanceof TableQuery) {
                            TableQuery tableQuery = (TableQuery)tableSource;
                            String query = tableQuery.query();
                            string = new StringBuilder(7).append("(").append(query).append(") AS x").toString();
                        } else {
                            throw new MatchError((Object)tableSource);
                        }
                        String exportSource = string;
                        if ($this.logger().underlying().isInfoEnabled()) {
                            $this.logger().underlying().info(new StringBuilder(15).append("Export Source: ").append(exportSource).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit x$9 = boxedUnit;
                        String exportStatement = new StringBuilder(114).append("EXPORT TO PARQUET(directory = '").append(hdfsPath$1).append("', fileSizeMB = ").append($this.maxFileSize()).append(", rowGroupSizeMB = ").append($this.maxRowGroupSize()).append(", fileMode = '").append(filePermissions).append("', dirMode = '").append(filePermissions).append("') AS SELECT ").append((String)selectClause).append(" FROM ").append(exportSource).append(pushdownFilters).append(groupbyClause).append(";").toString();
                        return new Tuple8(selectClause, (Object)x$7, (Object)groupbyClause, (Object)pushdownFilters, (Object)x$8, (Object)exportSource, (Object)x$9, (Object)exportStatement);
                    }).flatMap((Function1 & Serializable & scala.Serializable)x$18 -> {
                        Right right;
                        Tuple8 tuple8 = x$18;
                        if (tuple8 != null) {
                            String exportStatement = (String)tuple8._8();
                            if (exportDone) {
                                BoxedUnit boxedUnit;
                                if ($this.logger().underlying().isInfoEnabled()) {
                                    $this.logger().underlying().info("Export already done, skipping export step.");
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                            } else {
                                BoxedUnit boxedUnit;
                                if ($this.logger().underlying().isInfoEnabled()) {
                                    $this.logger().underlying().info(new StringBuilder(28).append("Exporting using statement: \n").append(exportStatement).toString());
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                Timer timer = new Timer($this.config().timeOperations(), $this.logger(), "Export To Parquet From Vertica");
                                timer.startTime();
                                Either res = EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither($this.jdbcLayer().execute(exportStatement, $this.jdbcLayer().execute$default$2())), (Function1 & Serializable & scala.Serializable)err -> new ExportFromVerticaError((ConnectorError)err));
                                $this.sparkContext().addSparkListener(new ApplicationParquetCleaner($this.config()));
                                timer.endTime();
                                right = res;
                            }
                        } else {
                            throw new MatchError((Object)tuple8);
                        }
                        Either either = right.flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.fileStoreLayer().fileExists(hdfsPath$1).flatMap((Function1 & Serializable & scala.Serializable)dirExists -> VerticaDistributedFilesystemReadPipe.$anonfun$doPreReadSteps$11($this, hdfsPath$1, BoxesRunTime.unboxToBoolean((Object)dirExists))));
                        return either;
                    });
                    return either;
                }));
            } else {
                if (!(either instanceof Right)) throw new MatchError(either);
                right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            return right.flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.fileStoreLayer().fileExists(hdfsPath$1).map((Function1 & Serializable & scala.Serializable)exportDone -> VerticaDistributedFilesystemReadPipe.$anonfun$doPreReadSteps$5($this, BoxesRunTime.unboxToBoolean((Object)exportDone))).flatMap((Function1 & Serializable & scala.Serializable)x$19 -> {
                Tuple2 tuple2 = x$19;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                boolean exportDone = tuple2._1$mcZ$sp();
                ValidFilePermissions filePermissions = (ValidFilePermissions)tuple2._2();
                Either either = $this.getSelectClause().map((Function1 & Serializable & scala.Serializable)selectClause -> {
                    BoxedUnit boxedUnit;
                    String string;
                    BoxedUnit boxedUnit2;
                    BoxedUnit boxedUnit3;
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(25).append("Select clause requested: ").append((String)selectClause).toString());
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    BoxedUnit x$7 = boxedUnit3;
                    String groupbyClause = $this.getGroupbyClause();
                    String pushdownFilters = $this.addPushdownFilters($this.config().getPushdownFilters());
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(18).append("Pushdown filters: ").append(pushdownFilters).toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    BoxedUnit x$8 = boxedUnit2;
                    TableSource tableSource = $this.config().tableSource();
                    if (tableSource instanceof TableName) {
                        TableName tableName = (TableName)tableSource;
                        string = tableName.getFullTableName();
                    } else if (tableSource instanceof TableQuery) {
                        TableQuery tableQuery = (TableQuery)tableSource;
                        String query = tableQuery.query();
                        string = new StringBuilder(7).append("(").append(query).append(") AS x").toString();
                    } else {
                        throw new MatchError((Object)tableSource);
                    }
                    String exportSource = string;
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(15).append("Export Source: ").append(exportSource).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit x$9 = boxedUnit;
                    String exportStatement = new StringBuilder(114).append("EXPORT TO PARQUET(directory = '").append(hdfsPath$1).append("', fileSizeMB = ").append($this.maxFileSize()).append(", rowGroupSizeMB = ").append($this.maxRowGroupSize()).append(", fileMode = '").append(filePermissions).append("', dirMode = '").append(filePermissions).append("') AS SELECT ").append((String)selectClause).append(" FROM ").append(exportSource).append(pushdownFilters).append(groupbyClause).append(";").toString();
                    return new Tuple8(selectClause, (Object)x$7, (Object)groupbyClause, (Object)pushdownFilters, (Object)x$8, (Object)exportSource, (Object)x$9, (Object)exportStatement);
                }).flatMap((Function1 & Serializable & scala.Serializable)x$18 -> {
                    Right right;
                    Tuple8 tuple8 = x$18;
                    if (tuple8 != null) {
                        String exportStatement = (String)tuple8._8();
                        if (exportDone) {
                            BoxedUnit boxedUnit;
                            if ($this.logger().underlying().isInfoEnabled()) {
                                $this.logger().underlying().info("Export already done, skipping export step.");
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                        } else {
                            BoxedUnit boxedUnit;
                            if ($this.logger().underlying().isInfoEnabled()) {
                                $this.logger().underlying().info(new StringBuilder(28).append("Exporting using statement: \n").append(exportStatement).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            Timer timer = new Timer($this.config().timeOperations(), $this.logger(), "Export To Parquet From Vertica");
                            timer.startTime();
                            Either res = EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither($this.jdbcLayer().execute(exportStatement, $this.jdbcLayer().execute$default$2())), (Function1 & Serializable & scala.Serializable)err -> new ExportFromVerticaError((ConnectorError)err));
                            $this.sparkContext().addSparkListener(new ApplicationParquetCleaner($this.config()));
                            timer.endTime();
                            right = res;
                        }
                    } else {
                        throw new MatchError((Object)tuple8);
                    }
                    Either either = right.flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.fileStoreLayer().fileExists(hdfsPath$1).flatMap((Function1 & Serializable & scala.Serializable)dirExists -> VerticaDistributedFilesystemReadPipe.$anonfun$doPreReadSteps$11($this, hdfsPath$1, BoxesRunTime.unboxToBoolean((Object)dirExists))));
                    return either;
                });
                return either;
            }));
        });
    }

    public static final /* synthetic */ void $anonfun$startPartitionRead$3(BoxedUnit ret) {
    }

    public static final /* synthetic */ Either $anonfun$readData$1(VerticaDistributedFilesystemReadPipe $this, VerticaDistributedFilesystemPartition part$2, BoxedUnit _2) {
        return $this.fileStoreLayer().openReadParquetFile((ParquetFileRange)part$2.fileRanges().apply($this.fileIdx())).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.fileStoreLayer().readDataFromParquetFile($this.dataSize()).map((Function1 & Serializable & scala.Serializable)data -> data));
    }

    public static final /* synthetic */ void $anonfun$endPartitionRead$2(BoxedUnit _) {
    }

    public VerticaDistributedFilesystemReadPipe(DistributedFilesystemReadConfig config, FileStoreLayerInterface fileStoreLayer, JdbcLayerInterface jdbcLayer, SchemaToolsInterface schemaTools, CleanupUtilsInterface cleanupUtils, SparkContextWrapper sparkContext, int dataSize) {
        this.config = config;
        this.fileStoreLayer = fileStoreLayer;
        this.jdbcLayer = jdbcLayer;
        this.schemaTools = schemaTools;
        this.cleanupUtils = cleanupUtils;
        this.sparkContext = sparkContext;
        this.dataSize = dataSize;
        this.logger = LogProvider$.MODULE$.getLogger(VerticaDistributedFilesystemReadPipe.class);
        this.maxFileSize = config.maxFileSize();
        this.maxRowGroupSize = config.maxRowGroupSize();
        this.partition = None$.MODULE$;
        this.fileIdx = 0;
        this.timer = new Timer(config.timeOperations(), this.logger(), "Partition Read");
    }
}

