/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.schema;

import cats.Applicative;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.config.TableQuery;
import com.vertica.spark.config.TableSource;
import com.vertica.spark.config.ValidColumnList;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcUtils$;
import com.vertica.spark.util.error.ArrayElementConversionError;
import com.vertica.spark.util.error.ArrayElementTypeNotFound;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.DatabaseReadError;
import com.vertica.spark.util.error.ErrorList;
import com.vertica.spark.util.error.JdbcSchemaError;
import com.vertica.spark.util.error.MissingElementTypeError;
import com.vertica.spark.util.error.MissingSparkConversionError;
import com.vertica.spark.util.error.MissingSqlConversionError;
import com.vertica.spark.util.error.SchemaConversionError;
import com.vertica.spark.util.error.SchemaError;
import com.vertica.spark.util.error.TableNotEnoughRowsError;
import com.vertica.spark.util.error.UnknownColumnTypesError;
import com.vertica.spark.util.schema.ColumnDef;
import com.vertica.spark.util.schema.ColumnDef$;
import com.vertica.spark.util.schema.SchemaToolsInterface;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Breaks$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t\rg\u0001\u0002\u0012$\u00019BQ!\u000f\u0001\u0005\u0002iBq\u0001\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004G\u0001\u0001\u0006IA\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003I\u0011\u0019\t\u0006\u0001)A\u0005\u0013\"9!\u000b\u0001b\u0001\n\u0013A\u0005BB*\u0001A\u0003%\u0011\nC\u0004U\u0001\t\u0007I\u0011B+\t\re\u0003\u0001\u0015!\u0003W\u0011\u0015Q\u0006\u0001\"\u0003\\\u0011\u0015A\u0007\u0001\"\u0003j\u0011\u001d\tY\u0004\u0001C\u0005\u0003{Aq!a\u0013\u0001\t\u0013\ti\u0005C\u0004\u0002b\u0001!\t!a\u0019\t\u000f\u0005E\u0006\u0001\"\u0001\u00024\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0007bBAi\u0001\u0011%\u00111\u001b\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\t9\u000f\u0001C\u0005\u0003SDq!a>\u0001\t\u0013\tI\u0010C\u0004\u0002\u0000\u0002!IA!\u0001\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e!9!q\u0004\u0001\u0005B\t\u0005\u0002b\u0002B\u001b\u0001\u0011%!q\u0007\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0011\u001d\u0011I\u0005\u0001C\u0001\u0005\u0017BqAa\u0017\u0001\t\u0013\u0011i\u0006C\u0004\u0003f\u0001!\tAa\u001a\t\u000f\tE\u0004\u0001\"\u0001\u0003t!9!Q\u0010\u0001\u0005\u0002\t}\u0004b\u0002BK\u0001\u0011\u0005!q\u0013\u0005\b\u0005G\u0003A\u0011\u0001BS\u0011\u001d\u0011\u0019\f\u0001C\u0001\u0005k\u00131bU2iK6\fGk\\8mg*\u0011A%J\u0001\u0007g\u000eDW-\\1\u000b\u0005\u0019:\u0013\u0001B;uS2T!\u0001K\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005)Z\u0013a\u0002<feRL7-\u0019\u0006\u0002Y\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aL\u001b\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\r\u0005s\u0017PU3g!\t1t'D\u0001$\u0013\tA4E\u0001\u000bTG\",W.\u0019+p_2\u001c\u0018J\u001c;fe\u001a\f7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0002\"A\u000e\u0001\u0002\r1|wmZ3s+\u0005q\u0004CA E\u001b\u0005\u0001%BA!C\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t\u00195&\u0001\u0005usB,7/\u00194f\u0013\t)\u0005I\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\u001d)hn\u001b8po:,\u0012!\u0013\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000bA\u0001\\1oO*\ta*\u0001\u0003kCZ\f\u0017B\u0001)L\u0005\u0019\u0019FO]5oO\u0006AQO\\6o_^t\u0007%A\u0005nCbdWM\\4uQ\u0006QQ.\u0019=mK:<G\u000f\u001b\u0011\u0002\u00151|gn\u001a7f]\u001e$\b.F\u0001W!\t\u0001t+\u0003\u0002Yc\t\u0019\u0011J\u001c;\u0002\u00171|gn\u001a7f]\u001e$\b\u000eI\u0001\u0010C\u0012$Gi\\;cY\u0016\fVo\u001c;fgR\u0011AL\u001a\t\u0003;\u0012t!A\u00182\u0011\u0005}\u000bT\"\u00011\u000b\u0005\u0005l\u0013A\u0002\u001fs_>$h(\u0003\u0002dc\u00051\u0001K]3eK\u001aL!\u0001U3\u000b\u0005\r\f\u0004\"B4\u000b\u0001\u0004a\u0016aA:ue\u0006yq-\u001a;DCR\fG._:u)f\u0004X\rF\u0007k\u0003\u000b\tI!!\u0004\u0002\u0012\u0005m\u0011q\u0004\t\u0005W6|W/D\u0001m\u0015\t1\u0013'\u0003\u0002oY\n1Q)\u001b;iKJ\u0004\"\u0001]:\u000e\u0003ET!A]\u0013\u0002\u000b\u0015\u0014(o\u001c:\n\u0005Q\f(aC*dQ\u0016l\u0017-\u0012:s_J\u00042A^A\u0001\u001b\u00059(B\u0001=z\u0003\u0015!\u0018\u0010]3t\u0015\tQ80A\u0002tc2T!\u0001\u000b?\u000b\u0005ut\u0018AB1qC\u000eDWMC\u0001\u0000\u0003\ry'oZ\u0005\u0004\u0003\u00079(\u0001\u0003#bi\u0006$\u0016\u0010]3\t\r\u0005\u001d1\u00021\u0001W\u0003\u001d\u0019\u0018\u000f\u001c+za\u0016Da!a\u0003\f\u0001\u00041\u0016!\u00039sK\u000eL7/[8o\u0011\u0019\tya\u0003a\u0001-\u0006)1oY1mK\"9\u00111C\u0006A\u0002\u0005U\u0011AB:jO:,G\rE\u00021\u0003/I1!!\u00072\u0005\u001d\u0011un\u001c7fC:Da!!\b\f\u0001\u0004a\u0016\u0001\u0003;za\u0016t\u0017-\\3\t\u000f\u0005\u00052\u00021\u0001\u0002$\u0005I1\r[5mI\u0012+gm\u001d\t\u0007\u0003K\ty#!\u000e\u000f\t\u0005\u001d\u00121\u0006\b\u0004?\u0006%\u0012\"\u0001\u001a\n\u0007\u00055\u0012'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00121\u0007\u0002\u0005\u0019&\u001cHOC\u0002\u0002.E\u00022ANA\u001c\u0013\r\tId\t\u0002\n\u0007>dW/\u001c8EK\u001a\fAbZ3u\u0003J\u0014\u0018-\u001f+za\u0016$B!a\u0010\u0002HA)1.\\8\u0002BA\u0019a/a\u0011\n\u0007\u0005\u0015sOA\u0005BeJ\f\u0017\u0010V=qK\"9\u0011\u0011\n\u0007A\u0002\u0005\r\u0012AC3mK6,g\u000e\u001e#fM\u0006Yr-\u001a;DCR\fG._:u)f\u0004XM\u0012:p[*#'m\u0019+za\u0016$B\"a\u0014\u0002X\u0005e\u00131LA/\u0003?\u0002Ra[7\u0002RU\u00042\u0001]A*\u0013\r\t)&\u001d\u0002\u001a\u001b&\u001c8/\u001b8h'Fd7i\u001c8wKJ\u001c\u0018n\u001c8FeJ|'\u000f\u0003\u0004\u0002\b5\u0001\rA\u0016\u0005\u0007\u0003\u0017i\u0001\u0019\u0001,\t\r\u0005=Q\u00021\u0001W\u0011\u001d\t\u0019\"\u0004a\u0001\u0003+Aa!!\b\u000e\u0001\u0004a\u0016A\u0003:fC\u0012\u001c6\r[3nCR1\u0011QMAG\u0003C\u0003b!a\u001a\u0002\u0002\u0006\u001de\u0002BA5\u0003{rA!a\u001b\u0002|9!\u0011QNA=\u001d\u0011\ty'a\u001e\u000f\t\u0005E\u0014Q\u000f\b\u0004?\u0006M\u0014\"\u0001\u0017\n\u0005)Z\u0013B\u0001\u0015*\u0013\t1s%\u0003\u0002sK%\u0019\u0011qP9\u0002\u001b\u0015\u0013(o\u001c:IC:$G.\u001b8h\u0013\u0011\t\u0019)!\"\u0003\u001f\r{gN\\3di>\u0014(+Z:vYRT1!a r!\r1\u0018\u0011R\u0005\u0004\u0003\u0017;(AC*ueV\u001cG\u000fV=qK\"9\u0011q\u0012\bA\u0002\u0005E\u0015!\u00036eE\u000ed\u0015-_3s!\u0011\t\u0019*!(\u000e\u0005\u0005U%\u0002BAL\u00033\u000bAA\u001b3cG*\u0019\u00111T\u0014\u0002\u0015\u0011\fG/Y:pkJ\u001cW-\u0003\u0003\u0002 \u0006U%A\u0005&eE\u000ed\u0015-_3s\u0013:$XM\u001d4bG\u0016Dq!a)\u000f\u0001\u0004\t)+A\u0006uC\ndWmU8ve\u000e,\u0007\u0003BAT\u0003[k!!!+\u000b\u0007\u0005-v%\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003_\u000bIKA\u0006UC\ndWmU8ve\u000e,\u0017!D4fi\u000e{G.^7o\u0013:4w\u000e\u0006\u0004\u00026\u0006u\u0016q\u0018\t\u0007\u0003O\n\t)a.\u0011\r\u0005\u0015\u0012\u0011XA\u001b\u0013\u0011\tY,a\r\u0003\u0007M+\u0017\u000fC\u0004\u0002\u0010>\u0001\r!!%\t\u000f\u0005\rv\u00021\u0001\u0002&\u0006\u00192\r[3dW\u001a{'oQ8na2,\u0007\u0010V=qKRA\u0011QYAd\u0003\u0017\fy\r\u0005\u0004\u0002h\u0005\u0005\u0015Q\u0007\u0005\b\u0003\u0013\u0004\u0002\u0019AA\u001b\u0003\u0019\u0019w\u000e\u001c#fM\"1\u0011Q\u001a\tA\u0002q\u000b\u0011\u0002^1cY\u0016t\u0015-\\3\t\u000f\u0005=\u0005\u00031\u0001\u0002\u0012\u0006aQ.Y6f\u0003J\u0014\u0018-\u001f#fMR1\u0011QYAk\u00033Dq!a6\u0012\u0001\u0004\t)$\u0001\u0005beJ\f\u0017\u0010R3g\u0011\u001d\tI%\u0005a\u0001\u0003\u000b\f!cZ3u\u0003J\u0014\u0018-_#mK6,g\u000e\u001e#fMRA\u0011QYAp\u0003G\f)\u000f\u0003\u0004\u0002bJ\u0001\r\u0001X\u0001\bG>dg*Y7f\u0011\u0019\tiM\u0005a\u00019\"9\u0011q\u0012\nA\u0002\u0005E\u0015aD9vKJLX\t\\3nK:$H)\u001a4\u0015\r\u0005\u0015\u00171^A{\u0011\u001d\tio\u0005a\u0001\u0003_\f1B^3si&\u001c\u0017\rV=qKB\u0019\u0001'!=\n\u0007\u0005M\u0018G\u0001\u0003M_:<\u0007bBAH'\u0001\u0007\u0011\u0011S\u0001\u0014O\u0016$h*Z:uK\u0012,E.Z7f]R$UM\u001a\u000b\u0007\u0003\u000b\fY0!@\t\u000f\u00055H\u00031\u0001\u0002p\"9\u0011q\u0012\u000bA\u0002\u0005E\u0015\u0001F9vKJLh+\u001a:uS\u000e\fG+\u001f9fg\u0012+g\r\u0006\u0005\u0002F\n\r!Q\u0001B\u0005\u0011\u001d\ti/\u0006a\u0001\u0003_DaAa\u0002\u0016\u0001\u00041\u0016!\u00023faRD\u0007bBAH+\u0001\u0007\u0011\u0011S\u0001\u0014[\u0006\\W-\u0011:sCf,E.Z7f]R$UM\u001a\u000b\u0007\u0003k\u0011yA!\b\t\u000f\tEa\u00031\u0001\u0003\u0014\u0005\u0011!o\u001d\t\u0005\u0005+\u0011I\"\u0004\u0002\u0003\u0018)\u0011!0T\u0005\u0005\u00057\u00119BA\u0005SKN,H\u000e^*fi\"1!q\u0001\fA\u0002Y\u000b1dZ3u-\u0016\u0014H/[2b)f\u0004XM\u0012:p[N\u0003\u0018M]6UsB,G\u0003\u0003B\u0012\u0005S\u0011iC!\r\u0011\u000b\u0005\u001d$Q\u0005/\n\t\t\u001d\u0012Q\u0011\u0002\r'\u000eDW-\\1SKN,H\u000e\u001e\u0005\u0007\u0005W9\u0002\u0019A;\u0002\u0013M\u0004\u0018M]6UsB,\u0007b\u0002B\u0018/\u0001\u0007\u0011q^\u0001\u0007gR\u0014H.\u001a8\t\u000f\tMr\u00031\u0001\u0002p\u0006Y\u0011M\u001d:bs2+gn\u001a;i\u0003a\u0019\b/\u0019:l\u0003J\u0014\u0018-\u001f+p-\u0016\u0014H/[2b\u0003J\u0014\u0018-\u001f\u000b\t\u0005G\u0011ID!\u0010\u0003@!1!1\b\rA\u0002U\f\u0001\u0002Z1uCRK\b/\u001a\u0005\b\u0005_A\u0002\u0019AAx\u0011\u001d\u0011\u0019\u0004\u0007a\u0001\u0003_\f\u0001e\u001d9be.\u0004&/[7ji&4X\rV8WKJ$\u0018nY1Qe&l\u0017\u000e^5wKR1!1\u0005B#\u0005\u000fBaAa\u000b\u001a\u0001\u0004)\bb\u0002B\u00183\u0001\u0007\u0011q^\u0001\u0012O\u0016$8i\u001c9z\u0007>dW/\u001c8MSN$H\u0003\u0003B'\u0005\u001f\u0012\tF!\u0017\u0011\u000b\u0005\u001d\u0014\u0011\u0011/\t\u000f\u0005=%\u00041\u0001\u0002\u0012\"9\u0011Q\u001a\u000eA\u0002\tM\u0003\u0003BAT\u0005+JAAa\u0016\u0002*\nIA+\u00192mK:\u000bW.\u001a\u0005\u0007Ii\u0001\r!a\"\u0002\u001b\r\f7\u000f\u001e+p-\u0006\u00148\r[1s+\t\u0011y\u0006E\u00031\u0005CbF,C\u0002\u0003dE\u0012\u0011BR;oGRLwN\\\u0019\u0002#5\f7.Z\"pYVlgn]*ue&tw\rF\u0003]\u0005S\u0012i\u0007C\u0004\u0003lq\u0001\r!a.\u0002\u0015\r|G.^7o\t\u001647\u000fC\u0004\u0003pq\u0001\r!a\"\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nC\u0006\u0019R.Y6f)\u0006\u0014G.Z\"pYVlg\u000eR3ggRQ!Q\nB;\u0005o\u0012IHa\u001f\t\r\u0011j\u0002\u0019AAD\u0011\u001d\u0011y#\ba\u0001\u0003_Dq!a$\u001e\u0001\u0004\t\t\nC\u0004\u00034u\u0001\r!a<\u0002)\u001d,G/T3sO\u0016Len]3siZ\u000bG.^3t)!\u0011iE!!\u0003\u0004\n\u0015\u0005bBAH=\u0001\u0007\u0011\u0011\u0013\u0005\b\u0003\u001bt\u0002\u0019\u0001B*\u0011\u001d\u00119I\ba\u0001\u0005\u0013\u000babY8qs\u000e{G.^7o\u0019&\u001cH\u000fE\u00031\u0005\u0017\u0013y)C\u0002\u0003\u000eF\u0012aa\u00149uS>t\u0007\u0003BAT\u0005#KAAa%\u0002*\nya+\u00197jI\u000e{G.^7o\u0019&\u001cH/\u0001\u000bhKRlUM]4f+B$\u0017\r^3WC2,Xm\u001d\u000b\u000b\u0005\u001b\u0012IJa'\u0003\u001e\n\u0005\u0006bBAH?\u0001\u0007\u0011\u0011\u0013\u0005\b\u0003\u001b|\u0002\u0019\u0001B*\u0011\u001d\u0011yj\ba\u0001\u0005'\nQ\u0002^3naR\u000b'\r\\3OC6,\u0007b\u0002BD?\u0001\u0007!\u0011R\u0001\u0014kB$\u0017\r^3GS\u0016dG\rR1uCRK\b/\u001a\u000b\f9\n\u001d&1\u0016BW\u0005_\u0013\t\f\u0003\u0004\u0003*\u0002\u0002\r\u0001X\u0001\u0004G>d\u0007BBAqA\u0001\u0007A\f\u0003\u0004%A\u0001\u0007\u0011q\u0011\u0005\b\u0005_\u0001\u0003\u0019AAx\u0011\u001d\u0011\u0019\u0004\ta\u0001\u0003_\f\u0001$\u001b8gKJ,\u0005\u0010^3s]\u0006dG+\u00192mKN\u001b\u0007.Z7b)1\u0011iEa.\u0003<\nu&q\u0018Ba\u0011\u0019\u0011I,\ta\u00019\u000692M]3bi\u0016,\u0005\u0010^3s]\u0006dG+\u00192mKN#X\u000e\u001e\u0005\u0007I\u0005\u0002\r!a\"\t\r\u00055\u0017\u00051\u0001]\u0011\u001d\u0011y#\ta\u0001\u0003_DqAa\r\"\u0001\u0004\ty\u000f")
public class SchemaTools
implements SchemaToolsInterface {
    private final Logger logger = LogProvider$.MODULE$.getLogger(SchemaTools.class);
    private final String unknown;
    private final String com$vertica$spark$util$schema$SchemaTools$$maxlength;
    private final int com$vertica$spark$util$schema$SchemaTools$$longlength;

    private Logger logger() {
        return this.logger;
    }

    private String unknown() {
        return this.unknown;
    }

    public String com$vertica$spark$util$schema$SchemaTools$$maxlength() {
        return this.com$vertica$spark$util$schema$SchemaTools$$maxlength;
    }

    public int com$vertica$spark$util$schema$SchemaTools$$longlength() {
        return this.com$vertica$spark$util$schema$SchemaTools$$longlength;
    }

    public String com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(String str) {
        return new java.lang.StringBuilder(2).append("\"").append(str).append("\"").toString();
    }

    private Either<SchemaError, DataType> getCatalystType(int sqlType, int precision, int scale, boolean signed, String typename, List<ColumnDef> childDefs) {
        Either<SchemaError, ArrayType> either;
        int n = sqlType;
        switch (n) {
            case 2003: {
                either = this.getArrayType(childDefs);
                break;
            }
            default: {
                either = this.getCatalystTypeFromJdbcType(sqlType, precision, scale, signed, typename);
                break;
            }
        }
        return either;
    }

    private Either<SchemaError, ArrayType> getArrayType(List<ColumnDef> elementDef) {
        Left left;
        Option option = elementDef.headOption();
        if (option instanceof Some) {
            Right right;
            Some some = (Some)option;
            ColumnDef element = (ColumnDef)some.value();
            Either<MissingSqlConversionError, DataType> either = this.getCatalystTypeFromJdbcType(element.colType(), element.size(), element.scale(), element.signed(), element.colTypeName());
            if (either instanceof Right) {
                Right right2 = (Right)either;
                DataType elementType = (DataType)right2.value();
                right = package$.MODULE$.Right().apply((Object)ArrayType$.MODULE$.apply(this.makeNestedArrays$1(element.metadata().getLong("depth"), elementType)));
            } else if (either instanceof Left) {
                Left left2 = (Left)either;
                MissingSqlConversionError err = (MissingSqlConversionError)left2.value();
                right = package$.MODULE$.Left().apply((Object)new ArrayElementConversionError(err.sqlType(), err.typename()));
            } else {
                throw new MatchError(either);
            }
            left = right;
        } else if (None$.MODULE$.equals(option)) {
            left = package$.MODULE$.Left().apply((Object)new MissingElementTypeError());
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    private Either<MissingSqlConversionError, DataType> getCatalystTypeFromJdbcType(int sqlType, int precision, int scale, boolean signed, String typename) {
        BinaryType$ binaryType$;
        int n = sqlType;
        switch (n) {
            case -5: {
                if (signed) {
                    binaryType$ = LongType$.MODULE$;
                    break;
                }
                binaryType$ = new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 0);
                break;
            }
            case -2: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case -7: {
                binaryType$ = BooleanType$.MODULE$;
                break;
            }
            case 2004: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case 16: {
                binaryType$ = BooleanType$.MODULE$;
                break;
            }
            case 1: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2005: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 70: {
                binaryType$ = null;
                break;
            }
            case 91: {
                binaryType$ = DateType$.MODULE$;
                break;
            }
            case 3: {
                binaryType$ = new DecimalType(precision, scale);
                break;
            }
            case 2001: {
                binaryType$ = null;
                break;
            }
            case 8: {
                binaryType$ = DoubleType$.MODULE$;
                break;
            }
            case 6: {
                binaryType$ = FloatType$.MODULE$;
                break;
            }
            case 4: {
                if (signed) {
                    binaryType$ = IntegerType$.MODULE$;
                    break;
                }
                binaryType$ = LongType$.MODULE$;
                break;
            }
            case 2000: {
                binaryType$ = null;
                break;
            }
            case -16: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -4: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case -1: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2011: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 0: {
                binaryType$ = null;
                break;
            }
            case 2: {
                if (precision != 0 || scale != 0) {
                    binaryType$ = new DecimalType(precision, scale);
                    break;
                }
                binaryType$ = new DecimalType(DecimalType$.MODULE$.USER_DEFAULT().precision(), DecimalType$.MODULE$.USER_DEFAULT().scale());
                break;
            }
            case -9: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 1111: {
                String typenameNormalized = typename.toLowerCase();
                if (typenameNormalized.startsWith("interval") || typenameNormalized.startsWith("uuid")) {
                    binaryType$ = StringType$.MODULE$;
                    break;
                }
                binaryType$ = null;
                break;
            }
            case 7: {
                binaryType$ = DoubleType$.MODULE$;
                break;
            }
            case 2006: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -8: {
                binaryType$ = LongType$.MODULE$;
                break;
            }
            case 5: {
                binaryType$ = IntegerType$.MODULE$;
                break;
            }
            case 2009: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2002: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 92: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 93: {
                binaryType$ = TimestampType$.MODULE$;
                break;
            }
            case -6: {
                binaryType$ = IntegerType$.MODULE$;
                break;
            }
            case -3: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case 12: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            default: {
                binaryType$ = null;
                break;
            }
        }
        BinaryType$ answer = binaryType$;
        return answer == null ? package$.MODULE$.Left().apply((Object)new MissingSqlConversionError(((Object)BoxesRunTime.boxToInteger((int)sqlType)).toString(), typename)) : package$.MODULE$.Right().apply((Object)answer);
    }

    @Override
    public Either<ConnectorError, StructType> readSchema(JdbcLayerInterface jdbcLayer, TableSource tableSource) {
        Left left;
        String string;
        TableSource tableSource2 = tableSource;
        if (tableSource2 instanceof TableName) {
            TableName tableName = (TableName)tableSource2;
            string = tableName.getFullTableName().replaceAll("\"", "");
        } else {
            string = "";
        }
        String string2 = string;
        Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tableSource);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq colInfo = (Seq)right.value();
            List errorsOrFields = ((TraversableOnce)colInfo.map((Function1 & Serializable & scala.Serializable)info -> this.getCatalystType(info.colType(), info.size(), info.scale(), info.signed(), info.colTypeName(), info.childDefinitions()).map((Function1 & Serializable & scala.Serializable)columnType -> new StructField(info.label(), columnType, info.nullable(), info.metadata())), Seq$.MODULE$.canBuildFrom())).toList();
            left = ((Validated)implicits$.MODULE$.toTraverseOps((Object)errorsOrFields, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$1 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$1), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)field -> StructType$.MODULE$.apply((Seq)field)).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, Seq<ColumnDef>> getColumnInfo(JdbcLayerInterface jdbcLayer, TableSource tableSource) {
        Left left;
        Tuple2 tuple2;
        TableSource tableSource2 = tableSource;
        if (tableSource2 instanceof TableName) {
            TableName tableName = (TableName)tableSource2;
            tuple2 = new Tuple2((Object)tableName.getFullTableName(), (Object)new java.lang.StringBuilder(24).append("SELECT * FROM ").append(tableName.getFullTableName()).append(" WHERE 1=0").toString());
        } else if (tableSource2 instanceof TableQuery) {
            TableQuery tableQuery = (TableQuery)tableSource2;
            String query = tableQuery.query();
            tuple2 = new Tuple2((Object)"", (Object)new java.lang.StringBuilder(31).append("SELECT * FROM (").append(query).append(") AS x WHERE 1=0").toString());
        } else {
            throw new MatchError((Object)tableSource2);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String tableName = (String)tuple22._1();
        String query = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)tableName, (Object)query);
        Tuple2 tuple24 = tuple23;
        String tableName2 = (String)tuple24._1();
        String query2 = (String)tuple24._2();
        Either<ConnectorError, ResultSet> either = jdbcLayer.query(query2, jdbcLayer.query$default$2());
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
        } else if (either instanceof Right) {
            Left left3;
            Right right = (Right)either;
            try (ResultSet rs = (ResultSet)right.value();){
                try {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    Seq colDefSeq = (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), rsmd.getColumnCount()).map((Function1 & Serializable & scala.Serializable)idx -> SchemaTools.$anonfun$getColumnInfo$1(this, rsmd, tableName2, jdbcLayer, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom());
                    left3 = package$.MODULE$.Right().apply((Object)colDefSeq);
                }
                catch (Throwable e) {
                    left3 = package$.MODULE$.Left().apply((Object)new DatabaseReadError(e).context("Could not get column info from Vertica"));
                }
            }
            left = left3;
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    private Either<ConnectorError, ColumnDef> checkForComplexType(ColumnDef colDef, String tableName, JdbcLayerInterface jdbcLayer) {
        Either<ConnectorError, ColumnDef> either;
        int n = colDef.colType();
        switch (n) {
            case 2003: {
                Either<ConnectorError, ColumnDef> elementDef = this.getArrayElementDef(colDef.label(), tableName, jdbcLayer);
                either = this.makeArrayDef(colDef, elementDef);
                break;
            }
            default: {
                either = package$.MODULE$.Right().apply((Object)colDef);
                break;
            }
        }
        return either;
    }

    private Either<ConnectorError, ColumnDef> makeArrayDef(ColumnDef arrayDef, Either<ConnectorError, ColumnDef> elementDef) {
        Left left;
        Either<ConnectorError, ColumnDef> either = elementDef;
        if (either instanceof Right) {
            Right right = (Right)either;
            ColumnDef value = (ColumnDef)right.value();
            Metadata metaData = new MetadataBuilder().putString("name", arrayDef.label()).putLong("depth", value.metadata().getLong("depth")).build();
            .colon.colon x$1 = new .colon.colon((Object)value, (List)Nil$.MODULE$);
            Metadata x$2 = metaData;
            String x$3 = arrayDef.copy$default$1();
            int x$4 = arrayDef.copy$default$2();
            String x$5 = arrayDef.copy$default$3();
            int x$6 = arrayDef.copy$default$4();
            int x$7 = arrayDef.copy$default$5();
            boolean x$8 = arrayDef.copy$default$6();
            boolean x$9 = arrayDef.copy$default$7();
            left = package$.MODULE$.Right().apply((Object)arrayDef.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$2, (List<ColumnDef>)x$1));
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    private Either<ConnectorError, ColumnDef> getArrayElementDef(String colName, String tableName, JdbcLayerInterface jdbcLayer) {
        String table = tableName.replace("\"", "");
        String queryColType = new java.lang.StringBuilder(71).append("SELECT data_type_id FROM columns WHERE table_name='").append(table).append("' AND column_name='").append(colName).append("'").toString();
        return JdbcUtils$.MODULE$.queryAndNext(queryColType, jdbcLayer, (Function1 & Serializable & scala.Serializable)rs -> {
            long verticaType = rs.getLong("data_type_id");
            return this.queryElementDef(verticaType, jdbcLayer);
        }, JdbcUtils$.MODULE$.queryAndNext$default$4());
    }

    private Either<ConnectorError, ColumnDef> queryElementDef(long verticaType, JdbcLayerInterface jdbcLayer) {
        long verticaTypeId = verticaType - 1500L;
        String queryType = new java.lang.StringBuilder(53).append("SELECT jdbc_type, type_name FROM types WHERE type_id=").append(verticaTypeId).toString();
        return JdbcUtils$.MODULE$.queryAndNext(queryType, jdbcLayer, (Function1 & Serializable & scala.Serializable)rs -> package$.MODULE$.Right().apply((Object)this.makeArrayElementDef((ResultSet)rs, 0)), (Function1 & Serializable & scala.Serializable)x$3 -> this.getNestedElementDef(verticaType, jdbcLayer));
    }

    private Either<ConnectorError, ColumnDef> getNestedElementDef(long verticaType, JdbcLayerInterface jdbcLayer) {
        return this.getNestedElementDef$1(verticaType, jdbcLayer, 0);
    }

    private Either<ConnectorError, ColumnDef> queryVerticaTypesDef(long verticaType, int depth, JdbcLayerInterface jdbcLayer) {
        String queryNativeTypes = new java.lang.StringBuilder(53).append("SELECT jdbc_type, type_name FROM types WHERE type_id=").append(verticaType).toString();
        return JdbcUtils$.MODULE$.queryAndNext(queryNativeTypes, jdbcLayer, (Function1 & Serializable & scala.Serializable)rs -> package$.MODULE$.Right().apply((Object)this.makeArrayElementDef((ResultSet)rs, depth)), (Function1 & Serializable & scala.Serializable)x$4 -> package$.MODULE$.Left().apply((Object)new ArrayElementTypeNotFound(verticaType)));
    }

    private ColumnDef makeArrayElementDef(ResultSet rs, int depth) {
        int sqlType = (int)rs.getLong("jdbc_type");
        String typeName = rs.getString("type_name");
        int fieldSize = DecimalType$.MODULE$.MAX_PRECISION();
        int fieldScale = 0;
        boolean isSigned = true;
        boolean nullable = true;
        Metadata metadata = new MetadataBuilder().putString("name", "element").putLong("depth", (long)depth).build();
        return new ColumnDef("element", sqlType, typeName, fieldSize, fieldScale, isSigned, nullable, metadata, ColumnDef$.MODULE$.apply$default$9());
    }

    @Override
    public Either<SchemaError, String> getVerticaTypeFromSparkType(DataType sparkType, long strlen, long arrayLength) {
        Either<SchemaError, String> either;
        DataType dataType = sparkType;
        boolean bl = dataType instanceof MapType ? true : dataType instanceof StructType;
        if (bl) {
            either = package$.MODULE$.Right().apply((Object)new java.lang.StringBuilder(11).append("VARBINARY(").append(this.com$vertica$spark$util$schema$SchemaTools$$longlength()).append(")").toString());
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType sparkType2 = arrayType.elementType();
            either = this.sparkArrayToVerticaArray(sparkType2, strlen, arrayLength);
        } else {
            either = this.sparkPrimitiveToVerticaPrimitive(sparkType, strlen);
        }
        return either;
    }

    private Either<SchemaError, String> sparkArrayToVerticaArray(DataType dataType, long strlen, long arrayLength) {
        String length = arrayLength <= 0L ? "" : new java.lang.StringBuilder(1).append(",").append(arrayLength).toString();
        return this.recursion$1(dataType, "ARRAY[", new java.lang.StringBuilder(1).append(length).append("]").toString(), 0, length, strlen);
    }

    private Either<SchemaError, String> sparkPrimitiveToVerticaPrimitive(DataType sparkType, long strlen) {
        Right right;
        DataType dataType = sparkType;
        if (BinaryType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)new java.lang.StringBuilder(11).append("VARBINARY(").append(this.com$vertica$spark$util$schema$SchemaTools$$longlength()).append(")").toString());
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"BOOLEAN");
        } else if (ByteType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"TINYINT");
        } else if (DateType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"DATE");
        } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"INTERVAL");
        } else if (DecimalType$.MODULE$.unapply(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"DECIMAL");
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"DOUBLE PRECISION");
        } else if (FloatType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"FLOAT");
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"INTEGER");
        } else if (LongType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"BIGINT");
        } else if (NullType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"null");
        } else if (ShortType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"SMALLINT");
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"TIMESTAMP");
        } else if (StringType$.MODULE$.equals(dataType)) {
            String vtype = strlen > (long)this.com$vertica$spark$util$schema$SchemaTools$$longlength() ? "LONG VARCHAR" : "VARCHAR";
            right = package$.MODULE$.Right().apply((Object)new java.lang.StringBuilder(2).append(vtype).append("(").append(((Object)BoxesRunTime.boxToLong((long)strlen)).toString()).append(")").toString());
        } else {
            right = package$.MODULE$.Left().apply((Object)new MissingSparkConversionError(sparkType));
        }
        return right;
    }

    @Override
    public Either<ConnectorError, String> getCopyColumnList(JdbcLayerInterface jdbcLayer, TableName tableName, StructType schema) {
        return this.getColumnInfo(jdbcLayer, tableName).flatMap((Function1 & Serializable & scala.Serializable)columns -> {
            Right right;
            int colCount = columns.length();
            IntRef colsFound = IntRef.create((int)0);
            columns.foreach((Function1 & Serializable & scala.Serializable)column -> {
                SchemaTools.$anonfun$getCopyColumnList$2(this, schema, colsFound, tableName, column);
                return BoxedUnit.UNIT;
            });
            if (schema.length() > colCount) {
                right = package$.MODULE$.Left().apply((Object)new TableNotEnoughRowsError().context(new java.lang.StringBuilder(187).append("Error: Number of columns in the target table should be greater or equal to number of columns in the DataFrame.  Number of columns in DataFrame: ").append(schema.length()).append(". Number of columns in the target table: ").append(tableName.getFullTableName()).append(": ").append(colCount).toString()));
            } else if (colsFound.elem == schema.length()) {
                BoxedUnit boxedUnit;
                ObjectRef columnList2 = ObjectRef.create((Object)"");
                BooleanRef first = BooleanRef.create((boolean)true);
                schema.foreach((Function1 & Serializable & scala.Serializable)s -> {
                    SchemaTools.$anonfun$getCopyColumnList$5(first, columnList2, s);
                    return BoxedUnit.UNIT;
                });
                columnList2.elem = new java.lang.StringBuilder(3).append("(").append((String)columnList2.elem).append("\")").toString();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new java.lang.StringBuilder(27).append("Load by name. Column list: ").append((String)columnList2.elem).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                right = package$.MODULE$.Right().apply((Object)((String)columnList2.elem));
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Load by Position");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                right = package$.MODULE$.Right().apply((Object)"");
            }
            return right.map((Function1 & Serializable & scala.Serializable)columnList -> columnList);
        });
    }

    private Function1<String, String> castToVarchar() {
        return (Function1 & Serializable & scala.Serializable)colName -> new java.lang.StringBuilder(13).append((String)colName).append("::varchar AS ").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes((String)colName)).toString();
    }

    @Override
    public String makeColumnsString(Seq<ColumnDef> columnDefs, StructType requiredSchema) {
        Seq requiredColumnDefs = requiredSchema.nonEmpty() ? (Seq)columnDefs.filter((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)SchemaTools.$anonfun$makeColumnsString$1(requiredSchema, cd))) : columnDefs;
        return ((TraversableOnce)requiredColumnDefs.map((Function1 & Serializable & scala.Serializable)info -> {
            String string;
            int n = info.colType();
            switch (n) {
                case 1111: {
                    String typenameNormalized = info.colTypeName().toLowerCase();
                    if (typenameNormalized.startsWith("interval") || typenameNormalized.startsWith("uuid")) {
                        string = (String)this.castToVarchar().apply((Object)info.label());
                        break;
                    }
                    string = this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(info.label());
                    break;
                }
                case 92: {
                    string = (String)this.castToVarchar().apply((Object)info.label());
                    break;
                }
                default: {
                    string = this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(info.label());
                    break;
                }
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    @Override
    public Either<ConnectorError, String> makeTableColumnDefs(StructType schema, long strlen, JdbcLayerInterface jdbcLayer, long arrayLength) {
        Either either;
        Object object = new Object();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(" (");
            BooleanRef first = BooleanRef.create((boolean)true);
            schema.foreach((Function1 & Serializable & scala.Serializable)s -> {
                Either<SchemaError, String> either;
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new java.lang.StringBuilder(28).append("colname=\"").append(s.name()).append("\"").append("; type=").append(s.dataType()).append("; nullable=").append(s.nullable()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Object object = !first$2.elem ? sb.append(",\n") : BoxedUnit.UNIT;
                first$2.elem = false;
                sb.append(new java.lang.StringBuilder(3).append("\"").append(s.name()).append("\" ").toString());
                String decimal_qualifier = "";
                if (s.dataType().toString().contains("DecimalType")) {
                    Regex p = new StringOps(Predef$.MODULE$.augmentString("DecimalType\\((\\d+)\\)")).r();
                    if (s.dataType().toString().matches(p.toString())) {
                        String prec;
                        String string = s.dataType().toString();
                        Option option = p.unapplySeq((CharSequence)string);
                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                            throw new MatchError((Object)string);
                        }
                        String string2 = prec = (String)((LinearSeqOptimized)option.get()).apply(0);
                        String prec2 = string2;
                        decimal_qualifier = new java.lang.StringBuilder(2).append("(").append(prec2).append(")").toString();
                    }
                    Regex ps = new StringOps(Predef$.MODULE$.augmentString("DecimalType\\((\\d+),(\\d+)\\)")).r();
                    if (s.dataType().toString().matches(ps.toString())) {
                        String string = s.dataType().toString();
                        Option option = ps.unapplySeq((CharSequence)string);
                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) {
                            throw new MatchError((Object)string);
                        }
                        String prec = (String)((LinearSeqOptimized)option.get()).apply(0);
                        String scale = (String)((LinearSeqOptimized)option.get()).apply(1);
                        Tuple2 tuple2 = new Tuple2((Object)prec, (Object)scale);
                        Tuple2 tuple22 = tuple2;
                        String prec3 = (String)tuple22._1();
                        String scale2 = (String)tuple22._2();
                        decimal_qualifier = new java.lang.StringBuilder(3).append("(").append(prec3).append(",").append(scale2).append(")").toString();
                    }
                }
                if ((either = this.getVerticaTypeFromSparkType(s.dataType(), strlen, arrayLength)) instanceof Left) {
                    Left left = (Left)either;
                    SchemaError err = (SchemaError)left.value();
                    throw new NonLocalReturnControl(object, (Object)package$.MODULE$.Left().apply((Object)new SchemaConversionError(err).context("Schema error when trying to create table")));
                }
                if (!(either instanceof Right)) {
                    throw new MatchError(either);
                }
                Right right = (Right)either;
                String datatype = (String)right.value();
                Right right2 = package$.MODULE$.Right().apply((Object)new java.lang.StringBuilder(0).append(datatype).append(decimal_qualifier).toString());
                return right2.map((Function1 & Serializable & scala.Serializable)col -> {
                    StringBuilder x$6 = sb.append(col);
                    BoxedUnit x$7 = !s.nullable() ? sb.append(" NOT NULL") : BoxedUnit.UNIT;
                    return new Tuple3(col, (Object)x$6, (Object)x$7);
                }).map((Function1 & Serializable & scala.Serializable)x$8 -> {
                    SchemaTools.$anonfun$makeTableColumnDefs$3(x$8);
                    return BoxedUnit.UNIT;
                });
            });
            sb.append(")");
            either = package$.MODULE$.Right().apply((Object)sb.toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                either = (Either)ex.value();
            }
            throw ex;
        }
        return either;
    }

    @Override
    public Either<ConnectorError, String> getMergeInsertValues(JdbcLayerInterface jdbcLayer, TableName tableName, Option<ValidColumnList> copyColumnList) {
        Left left;
        Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tableName);
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq info = (Seq)right.value();
            left = package$.MODULE$.Right().apply((Object)((TraversableOnce)info.map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(5).append("temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).toString(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
        } else {
            throw new MatchError(either);
        }
        Left valueList = left;
        return valueList;
    }

    @Override
    public Either<ConnectorError, String> getMergeUpdateValues(JdbcLayerInterface jdbcLayer, TableName tableName, TableName tempTableName, Option<ValidColumnList> copyColumnList) {
        Left left;
        Option<ValidColumnList> option = copyColumnList;
        if (option instanceof Some) {
            Left colList;
            Left left2;
            Some some = (Some)option;
            ValidColumnList list = (ValidColumnList)some.value();
            List customColList = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])list.toString().split(","))).toList().map((Function1 & Serializable & scala.Serializable)col -> col.trim(), List$.MODULE$.canBuildFrom());
            Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tempTableName);
            if (either instanceof Right) {
                Right right = (Right)either;
                Seq info = (Seq)right.value();
                List tupleList = (List)customColList.zip((GenIterable)info, List$.MODULE$.canBuildFrom());
                left2 = package$.MODULE$.Right().apply((Object)((TraversableOnce)tupleList.map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(6).append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes((String)x._1())).append("=temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(((ColumnDef)x._2()).label())).toString(), List$.MODULE$.canBuildFrom())).mkString(", "));
            } else if (either instanceof Left) {
                Left left3 = (Left)either;
                ConnectorError err = (ConnectorError)left3.value();
                left2 = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
            } else {
                throw new MatchError(either);
            }
            left = colList = left2;
        } else if (None$.MODULE$.equals(option)) {
            Left updateList;
            Left left4;
            Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tempTableName);
            if (either instanceof Right) {
                Right right = (Right)either;
                Seq info = (Seq)right.value();
                left4 = package$.MODULE$.Right().apply((Object)((TraversableOnce)info.map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(6).append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).append("=temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).toString(), Seq$.MODULE$.canBuildFrom())).mkString(", "));
            } else if (either instanceof Left) {
                Left left5 = (Left)either;
                ConnectorError err = (ConnectorError)left5.value();
                left4 = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
            } else {
                throw new MatchError(either);
            }
            left = updateList = left4;
        } else {
            throw new MatchError(option);
        }
        Left columnList = left;
        return columnList;
    }

    public String updateFieldDataType(String col, String colName, StructType schema, long strlen, long arrayLength) {
        Seq fieldType = (Seq)schema.collect((PartialFunction)new scala.Serializable(this, colName, strlen, arrayLength){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchemaTools $outer;
            private final String colName$1;
            private final long strlen$3;
            private final long arrayLength$2;

            /*
             * Unable to fully structure code
             */
            public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> default) {
                block9: {
                    block6: {
                        block8: {
                            block7: {
                                var5_3 = x1;
                                v0 = this.$outer.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(var5_3.name());
                                var6_4 = this.colName$1;
                                if (v0 != null ? v0.equals(var6_4) == false : var6_4 != null) break block6;
                                if (!var5_3.metadata().contains(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())) break block7;
                                v1 = var5_3.dataType().simpleString();
                                var7_5 = "string";
                                if (v1 != null ? v1.equals(var7_5) == false : var7_5 != null) break block7;
                                v2 = var5_3.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength()) > (long)this.$outer.com$vertica$spark$util$schema$SchemaTools$$longlength() ? new java.lang.StringBuilder(14).append("long varchar(").append(BoxesRunTime.boxToLong((long)var5_3.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())).toString()).append(")").toString() : new java.lang.StringBuilder(9).append("varchar(").append(BoxesRunTime.boxToLong((long)var5_3.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())).toString()).append(")").toString();
                                break block8;
                            }
                            if (!var5_3.metadata().contains(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())) ** GOTO lbl-1000
                            v3 = var5_3.dataType().simpleString();
                            var8_6 = "binary";
                            if (!(v3 != null ? v3.equals(var8_6) == false : var8_6 != null)) {
                                v2 = new java.lang.StringBuilder(11).append("varbinary(").append(BoxesRunTime.boxToLong((long)var5_3.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())).toString()).append(")").toString();
                            } else lbl-1000:
                            // 2 sources

                            {
                                if ((var9_7 = this.$outer.getVerticaTypeFromSparkType(var5_3.dataType(), this.strlen$3, this.arrayLength$2)) instanceof Right) {
                                    var10_8 = (Right)var9_7;
                                    var4_10 = dataType = (String)var10_8.value();
                                } else if (var9_7 instanceof Left) {
                                    var12_11 = (Left)var9_7;
                                    err = (SchemaError)var12_11.value();
                                    var4_10 = package$.MODULE$.Left().apply((Object)err);
                                } else {
                                    throw new MatchError(var9_7);
                                }
                                v2 = var4_10;
                            }
                        }
                        var3_13 = v2;
                        break block9;
                    }
                    var3_13 = default.apply(x1);
                }
                return (B1)var3_13;
            }

            public final boolean isDefinedAt(StructField x1) {
                StructField structField = x1;
                String string = this.$outer.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(structField.name());
                String string2 = this.colName$1;
                boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.colName$1 = colName$1;
                this.strlen$3 = strlen$3;
                this.arrayLength$2 = arrayLength$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return fieldType.nonEmpty() ? new java.lang.StringBuilder(1).append(colName).append(" ").append(fieldType.head()).toString() : col;
    }

    @Override
    public Either<ConnectorError, String> inferExternalTableSchema(String createExternalTableStmt, StructType schema, String tableName, long strlen, long arrayLength) {
        Right right;
        int indexOfClosingParantheses;
        int indexOfOpeningParantheses;
        String stmt = createExternalTableStmt.replace(new java.lang.StringBuilder(2).append("\"").append(tableName).append("\"").toString(), tableName);
        String schemaString = stmt.substring((indexOfOpeningParantheses = stmt.indexOf("(")) + 1, indexOfClosingParantheses = stmt.indexOf(")"));
        List schemaList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schemaString.split(","))).toList();
        String updatedSchema = ((TraversableOnce)schemaList.map((Function1 & Serializable & scala.Serializable)col -> {
            int indexOfFirstDoubleQuote = col.indexOf("\"");
            int indexOfSpace = col.indexOf(" ", indexOfFirstDoubleQuote);
            String colName = col.substring(indexOfFirstDoubleQuote, indexOfSpace);
            return schema.nonEmpty() ? this.updateFieldDataType((String)col, colName, schema, strlen, arrayLength) : (col.toLowerCase().contains("varchar") ? new java.lang.StringBuilder(10).append(colName).append(" varchar(").append(strlen).append(")").toString() : (col.toLowerCase().contains("varbinary") ? new java.lang.StringBuilder(12).append(colName).append(" varbinary(").append(this.com$vertica$spark$util$schema$SchemaTools$$longlength()).append(")").toString() : col));
        }, List$.MODULE$.canBuildFrom())).mkString(",");
        if (updatedSchema.contains(this.unknown())) {
            right = package$.MODULE$.Left().apply((Object)new UnknownColumnTypesError().context(new java.lang.StringBuilder(30).append(this.unknown()).append(" partitioned column data type.").toString()));
        } else {
            BoxedUnit boxedUnit;
            String updatedCreateTableStmt = stmt.replace(schemaString, updatedSchema);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new java.lang.StringBuilder(41).append("Updated create external table statement: ").append(updatedCreateTableStmt).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            right = package$.MODULE$.Right().apply((Object)updatedCreateTableStmt);
        }
        return right;
    }

    private final DataType makeNestedArrays$1(long arrayDepth, DataType arrayElement) {
        while (arrayDepth > 0L) {
            arrayElement = ArrayType$.MODULE$.apply(arrayElement);
            --arrayDepth;
        }
        return arrayElement;
    }

    public static final /* synthetic */ ColumnDef $anonfun$getColumnInfo$1(SchemaTools $this, ResultSetMetaData rsmd$1, String tableName$1, JdbcLayerInterface jdbcLayer$1, int idx) {
        ColumnDef columnDef;
        String columnLabel = rsmd$1.getColumnLabel(idx);
        String typeName = rsmd$1.getColumnTypeName(idx);
        int fieldSize = DecimalType$.MODULE$.MAX_PRECISION();
        int fieldScale = rsmd$1.getScale(idx);
        boolean isSigned = rsmd$1.isSigned(idx);
        boolean nullable = rsmd$1.isNullable(idx) != 0;
        Metadata metadata = new MetadataBuilder().putString("name", columnLabel).build();
        int colType = rsmd$1.getColumnType(idx);
        ColumnDef colDef = new ColumnDef(columnLabel, colType, typeName, fieldSize, fieldScale, isSigned, nullable, metadata, ColumnDef$.MODULE$.apply$default$9());
        Either<ConnectorError, ColumnDef> either = $this.checkForComplexType(colDef, tableName$1, jdbcLayer$1);
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                Left left = (Left)either;
                ConnectorError err = (ConnectorError)left.value();
                ConnectorError connectorError = err;
                if (connectorError instanceof ArrayElementTypeNotFound) {
                    ArrayElementTypeNotFound arrayElementTypeNotFound = (ArrayElementTypeNotFound)connectorError;
                    throw arrayElementTypeNotFound;
                }
                throw new RuntimeException(err.getFullContext());
            }
            throw new MatchError(either);
        }
        Right right = (Right)either;
        ColumnDef columnDef2 = columnDef = (ColumnDef)right.value();
        return columnDef2;
    }

    private final Either getNestedElementDef$1(long verticaType, JdbcLayerInterface jdbcLayer, int depth) {
        Left left;
        block6: {
            String queryComplexType;
            Either<ConnectorError, ResultSet> either;
            while ((either = jdbcLayer.query(queryComplexType = new java.lang.StringBuilder(92).append("SELECT field_type_name, type_id ,field_id, numeric_scale FROM complex_types WHERE type_id='").append(verticaType).append("'").toString(), jdbcLayer.query$default$2())) instanceof Right) {
                Either<ConnectorError, ColumnDef> either2;
                Right right = (Right)either;
                ResultSet rs = (ResultSet)right.value();
                if (rs.next()) {
                    String fieldTypeName = rs.getString("field_type_name");
                    long verticaType2 = rs.getLong("field_id");
                    rs.close();
                    if (fieldTypeName.startsWith("_ct_")) {
                        ++depth;
                        verticaType = verticaType2;
                        continue;
                    }
                    either2 = this.queryVerticaTypesDef(verticaType2, depth, jdbcLayer);
                } else {
                    rs.close();
                    either2 = package$.MODULE$.Left().apply((Object)new ArrayElementTypeNotFound(verticaType));
                }
                left = either2;
                break block6;
            }
            if (either instanceof Left) {
                Left left2 = (Left)either;
                ConnectorError error = (ConnectorError)left2.value();
                left = package$.MODULE$.Left().apply((Object)error);
            } else {
                throw new MatchError(either);
            }
        }
        return left;
    }

    private final Either recursion$1(DataType dataType, String leftAccumulator, String rightAccumulator, int depth, String length$1, long strlen$1) {
        Left left;
        DataType dataType2;
        while ((dataType2 = dataType) instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            ++depth;
            rightAccumulator = new java.lang.StringBuilder(1).append(length$1).append("]").append(rightAccumulator).toString();
            leftAccumulator = new java.lang.StringBuilder(6).append(leftAccumulator).append("ARRAY[").toString();
            dataType = elementType;
        }
        Either<SchemaError, String> either = this.sparkPrimitiveToVerticaPrimitive(dataType, strlen$1);
        if (either instanceof Right) {
            Right right = (Right)either;
            String verticaType = (String)right.value();
            left = package$.MODULE$.Right().apply((Object)new java.lang.StringBuilder(0).append(leftAccumulator).append(verticaType).append(rightAccumulator).toString());
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            SchemaError error = (SchemaError)left2.value();
            left = package$.MODULE$.Left().apply((Object)error);
        } else {
            throw new MatchError(either);
        }
        Left left3 = left;
        return left3;
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$4(SchemaTools $this, ColumnDef column$1, IntRef colsFound$1, TableName tableName$2, StructField s) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new java.lang.StringBuilder(48).append("Comparing target table column: ").append(column$1.label()).append(" with DF column: ").append(s.name()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (s.name().equalsIgnoreCase(column$1.label())) {
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            ++colsFound$1.elem;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug(new java.lang.StringBuilder(37).append("Column: ").append(s.name()).append(" found in target table and DF").toString());
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            if (!column$1.nullable()) {
                if (s.nullable()) {
                    if ($this.logger().underlying().isWarnEnabled()) {
                        $this.logger().underlying().warn(new java.lang.StringBuilder(128).append("S2V: Column ").append(s.name()).append(" is NOT NULL in target table ").append(tableName$2.getFullTableName()).append(" but it's nullable in the DataFrame. Rows with NULL values in column ").append(s.name()).append(" will be rejected.").toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw Breaks$.MODULE$.break();
        }
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$2(SchemaTools $this, StructType schema$1, IntRef colsFound$1, TableName tableName$2, ColumnDef column) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new java.lang.StringBuilder(43).append("Will check that target column: ").append(column.label()).append(" exist in DF").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> schema$1.foreach((Function1 & Serializable & scala.Serializable)s -> {
            SchemaTools.$anonfun$getCopyColumnList$4($this, column, colsFound$1, tableName$2, s);
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$5(BooleanRef first$1, ObjectRef columnList$1, StructField s) {
        if (first$1.elem) {
            columnList$1.elem = new java.lang.StringBuilder(1).append("\"").append(s.name()).toString();
            first$1.elem = false;
        } else {
            columnList$1.elem = new java.lang.StringBuilder(3).append((String)columnList$1.elem).append("\",\"").append(s.name()).toString();
        }
    }

    public static final /* synthetic */ boolean $anonfun$makeColumnsString$2(ColumnDef cd$1, StructField field) {
        String string = field.name();
        String string2 = cd$1.label();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$makeColumnsString$1(StructType requiredSchema$1, ColumnDef cd) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema$1.fields())).exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SchemaTools.$anonfun$makeColumnsString$2(cd, field)));
    }

    public static final /* synthetic */ void $anonfun$makeTableColumnDefs$3(Tuple3 x$8) {
        Tuple3 tuple3 = x$8;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public SchemaTools() {
        this.unknown = "UNKNOWN";
        this.com$vertica$spark$util$schema$SchemaTools$$maxlength = "maxlength";
        this.com$vertica$spark$util$schema$SchemaTools$$longlength = 65000;
    }
}

