/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.version;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcUtils$;
import com.vertica.spark.util.error.NoResultError;
import com.vertica.spark.util.version.VerticaVersion;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class VerticaVersionUtils$ {
    public static VerticaVersionUtils$ MODULE$;
    private final Logger logger;
    private final Option<VerticaVersion> version;
    private final VerticaVersion DEFAULT_VERTICA_VERSION;

    static {
        new VerticaVersionUtils$();
    }

    private Logger logger() {
        return this.logger;
    }

    private Option<VerticaVersion> version() {
        return this.version;
    }

    private VerticaVersion DEFAULT_VERTICA_VERSION() {
        return this.DEFAULT_VERTICA_VERSION;
    }

    public VerticaVersion get(JdbcLayerInterface jdbcLayer) {
        return (VerticaVersion)JdbcUtils$.MODULE$.queryAndNext("SELECT version();", jdbcLayer, (Function1 & Serializable & scala.Serializable)rs -> {
            BoxedUnit boxedUnit;
            VerticaVersion verticaVersion = MODULE$.extractVersion(rs.getString(1));
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info(new StringBuilder(17).append("VERTICA VERSION: ").append(verticaVersion).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return package$.MODULE$.Right().apply((Object)verticaVersion);
        }, (Function1 & Serializable & scala.Serializable)query -> {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isErrorEnabled()) {
                MODULE$.logger().underlying().error(new StringBuilder(48).append("Failed to query for version number. Defaults to ").append(MODULE$.DEFAULT_VERTICA_VERSION()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return package$.MODULE$.Left().apply((Object)new NoResultError((String)query));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_VERTICA_VERSION());
    }

    private VerticaVersion extractVersion(String str) {
        Regex pattern = new StringOps(Predef$.MODULE$.augmentString(".*v([0-9]+)\\.([0-9]+)\\.([0-9])+-([0-9]+).*")).r();
        return (VerticaVersion)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String string = str;
            Option option = pattern.unapplySeq((CharSequence)string);
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(4) != 0) {
                throw new MatchError((Object)string);
            }
            String major = (String)((LinearSeqOptimized)option.get()).apply(0);
            String minor = (String)((LinearSeqOptimized)option.get()).apply(1);
            String service = (String)((LinearSeqOptimized)option.get()).apply(2);
            String hotfix = (String)((LinearSeqOptimized)option.get()).apply(3);
            Tuple4 tuple4 = new Tuple4((Object)major, (Object)minor, (Object)service, (Object)hotfix);
            Tuple4 tuple42 = tuple4;
            String major2 = (String)tuple42._1();
            String minor2 = (String)tuple42._2();
            String service2 = (String)tuple42._3();
            String hotfix2 = (String)tuple42._4();
            return new VerticaVersion(new StringOps(Predef$.MODULE$.augmentString(major2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(minor2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(service2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(hotfix2)).toInt());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.DEFAULT_VERTICA_VERSION());
    }

    private VerticaVersionUtils$() {
        MODULE$ = this;
        this.logger = LogProvider$.MODULE$.getLogger(this.getClass());
        this.version = None$.MODULE$;
        this.DEFAULT_VERTICA_VERSION = new VerticaVersion(11, 0, 0, 0);
    }
}

