/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.core;

import cats.Applicative;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.DistributedFilesystemReadConfig;
import com.vertica.spark.config.FileStoreConfig;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.config.TableQuery;
import com.vertica.spark.config.TableSource;
import com.vertica.spark.config.ValidFilePermissions;
import com.vertica.spark.config.VerticaMetadata;
import com.vertica.spark.config.VerticaReadMetadata;
import com.vertica.spark.datasource.core.DataBlock;
import com.vertica.spark.datasource.core.ParquetFileRange;
import com.vertica.spark.datasource.core.PartitionInfo;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemPartition;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemPartition$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe$;
import com.vertica.spark.datasource.core.VerticaPartition;
import com.vertica.spark.datasource.core.VerticaPipeInterface;
import com.vertica.spark.datasource.core.VerticaPipeReadInterface;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.fs.ParquetFileMetadata;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.v2.PushdownFilter;
import com.vertica.spark.util.Timer;
import com.vertica.spark.util.cleanup.CleanupUtilsInterface;
import com.vertica.spark.util.cleanup.FileCleanupInfo;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.CreateDirectoryAlreadyExistsError;
import com.vertica.spark.util.error.DoneReading;
import com.vertica.spark.util.error.ExportFromVerticaError;
import com.vertica.spark.util.error.InvalidPartition;
import com.vertica.spark.util.error.UninitializedReadError;
import com.vertica.spark.util.listeners.ApplicationParquetCleaner;
import com.vertica.spark.util.listeners.SparkContextWrapper;
import com.vertica.spark.util.schema.ColumnDef;
import com.vertica.spark.util.schema.SchemaToolsInterface;
import com.vertica.spark.util.version.VerticaVersion;
import com.vertica.spark.util.version.VerticaVersionUtils$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple7;
import scala.Tuple8;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t\u001dg\u0001B\u001a5\u0001}B\u0001\"\u0014\u0001\u0003\u0006\u0004%\tA\u0014\u0005\t)\u0002\u0011\t\u0011)A\u0005\u001f\"AQ\u000b\u0001BC\u0002\u0013\u0005a\u000b\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003X\u0011!q\u0006A!b\u0001\n\u0003y\u0006\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u0011\u001d\u0004!Q1A\u0005\u0002!D\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\te\u0002\u0011)\u0019!C\u0001g\"A!\u0010\u0001B\u0001B\u0003%A\u000f\u0003\u0005|\u0001\t\u0015\r\u0011\"\u0001}\u0011%\t9\u0001\u0001B\u0001B\u0003%Q\u0010\u0003\u0006\u0002\n\u0001\u0011)\u0019!C\u0001\u0003\u0017A!\"a\u0005\u0001\u0005\u0003\u0005\u000b\u0011BA\u0007\u0011\u001d\t)\u0002\u0001C\u0001\u0003/A\u0011\"!\u000b\u0001\u0005\u0004%I!a\u000b\t\u0011\u0005u\u0002\u0001)A\u0005\u0003[A\u0011\"a\u0010\u0001\u0005\u0004%I!a\u0003\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003\u001bA\u0011\"a\u0011\u0001\u0005\u0004%I!a\u0003\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003\u001bAq!a\u0012\u0001\t\u0013\tI\u0005C\u0004\u0002~\u0001!I!a \t\u000f\u0005M\u0006\u0001\"\u0011\u00026\"9\u0011q\u0017\u0001\u0005B\u0005e\u0006bBAb\u0001\u0011%\u0011Q\u0019\u0005\b\u0003?\u0004A\u0011BAq\u0011\u001d\ti\u0010\u0001C\u0005\u0003\u007fDqAa\u0001\u0001\t\u0013\ty\u0010C\u0004\u0003\u0006\u0001!IAa\u0002\t\u000f\t%\u0001\u0001\"\u0003\u0003\f!9!1\u0006\u0001\u0005B\t5\u0002b\u0002B\u0019\u0001\u0011%!1\u0007\u0005\n\u0005\u0003\u0002\u0001\u0019!C\u0001\u0005\u0007B\u0011B!\u0015\u0001\u0001\u0004%\tAa\u0015\t\u0011\te\u0003\u0001)Q\u0005\u0005\u000bB\u0011Ba\u0017\u0001\u0001\u0004%\t!a\u0003\t\u0013\tu\u0003\u00011A\u0005\u0002\t}\u0003\u0002\u0003B2\u0001\u0001\u0006K!!\u0004\t\u0013\t\u0015\u0004A1A\u0005\u0002\t\u001d\u0004\u0002\u0003B9\u0001\u0001\u0006IA!\u001b\t\u000f\tM\u0004\u0001\"\u0001\u0003v!9!\u0011\u0011\u0001\u0005\n\t\r\u0005b\u0002BK\u0001\u0011\u0005!q\u0013\u0005\b\u0005C\u0003A\u0011\u0001BR\u0011\u001d\u0011)\u000b\u0001C\u0001\u0005G;\u0011Ba*5\u0003\u0003E\tA!+\u0007\u0011M\"\u0014\u0011!E\u0001\u0005WCq!!\u00061\t\u0003\u0011i\u000bC\u0005\u00030B\n\n\u0011\"\u0001\u00032\n!c+\u001a:uS\u000e\fG)[:ue&\u0014W\u000f^3e\r&dWm]=ti\u0016l'+Z1e!&\u0004XM\u0003\u00026m\u0005!1m\u001c:f\u0015\t9\u0004(\u0001\u0006eCR\f7o\\;sG\u0016T!!\u000f\u001e\u0002\u000bM\u0004\u0018M]6\u000b\u0005mb\u0014a\u0002<feRL7-\u0019\u0006\u0002{\u0005\u00191m\\7\u0004\u0001M!\u0001\u0001\u0011$K!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u0019\te.\u001f*fMB\u0011q\tS\u0007\u0002i%\u0011\u0011\n\u000e\u0002\u0015-\u0016\u0014H/[2b!&\u0004X-\u00138uKJ4\u0017mY3\u0011\u0005\u001d[\u0015B\u0001'5\u0005a1VM\u001d;jG\u0006\u0004\u0016\u000e]3SK\u0006$\u0017J\u001c;fe\u001a\f7-Z\u0001\u0007G>tg-[4\u0016\u0003=\u0003\"\u0001\u0015*\u000e\u0003ES!!\u0014\u001d\n\u0005M\u000b&a\b#jgR\u0014\u0018NY;uK\u00124\u0015\u000e\\3tsN$X-\u001c*fC\u0012\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013A\u00044jY\u0016\u001cFo\u001c:f\u0019\u0006LXM]\u000b\u0002/B\u0011\u0001lW\u0007\u00023*\u0011!LN\u0001\u0003MNL!\u0001X-\u0003/\u0019KG.Z*u_J,G*Y=fe&sG/\u001a:gC\u000e,\u0017a\u00044jY\u0016\u001cFo\u001c:f\u0019\u0006LXM\u001d\u0011\u0002\u0013)$'m\u0019'bs\u0016\u0014X#\u00011\u0011\u0005\u0005$W\"\u00012\u000b\u0005\r4\u0014\u0001\u00026eE\u000eL!!\u001a2\u0003%)#'m\u0019'bs\u0016\u0014\u0018J\u001c;fe\u001a\f7-Z\u0001\u000bU\u0012\u00147\rT1zKJ\u0004\u0013aC:dQ\u0016l\u0017\rV8pYN,\u0012!\u001b\t\u0003U>l\u0011a\u001b\u0006\u0003Y6\faa]2iK6\f'B\u000189\u0003\u0011)H/\u001b7\n\u0005A\\'\u0001F*dQ\u0016l\u0017\rV8pYNLe\u000e^3sM\u0006\u001cW-\u0001\u0007tG\",W.\u0019+p_2\u001c\b%\u0001\u0007dY\u0016\fg.\u001e9Vi&d7/F\u0001u!\t)\b0D\u0001w\u0015\t9X.A\u0004dY\u0016\fg.\u001e9\n\u0005e4(!F\"mK\u0006tW\u000f]+uS2\u001c\u0018J\u001c;fe\u001a\f7-Z\u0001\u000eG2,\u0017M\\;q+RLGn\u001d\u0011\u0002\u0019M\u0004\u0018M]6D_:$X\r\u001f;\u0016\u0003u\u00042A`A\u0002\u001b\u0005y(bAA\u0001[\u0006IA.[:uK:,'o]\u0005\u0004\u0003\u000by(aE*qCJ\\7i\u001c8uKb$xK]1qa\u0016\u0014\u0018!D:qCJ\\7i\u001c8uKb$\b%\u0001\u0005eCR\f7+\u001b>f+\t\ti\u0001E\u0002B\u0003\u001fI1!!\u0005C\u0005\rIe\u000e^\u0001\nI\u0006$\u0018mU5{K\u0002\na\u0001P5oSRtD\u0003EA\r\u00037\ti\"a\b\u0002\"\u0005\r\u0012QEA\u0014!\t9\u0005\u0001C\u0003N\u001f\u0001\u0007q\nC\u0003V\u001f\u0001\u0007q\u000bC\u0003_\u001f\u0001\u0007\u0001\rC\u0003h\u001f\u0001\u0007\u0011\u000eC\u0003s\u001f\u0001\u0007A\u000fC\u0003|\u001f\u0001\u0007Q\u0010C\u0005\u0002\n=\u0001\n\u00111\u0001\u0002\u000e\u00051An\\4hKJ,\"!!\f\u0011\t\u0005=\u0012\u0011H\u0007\u0003\u0003cQA!a\r\u00026\u0005a1oY1mC2|wmZ5oO*\u0019\u0011q\u0007\u001f\u0002\u0011QL\b/Z:bM\u0016LA!a\u000f\u00022\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0006nCb4\u0015\u000e\\3TSj,\u0017\u0001D7bq\u001aKG.Z*ju\u0016\u0004\u0013aD7bqJ{wo\u0012:pkB\u001c\u0016N_3\u0002!5\f\u0007PU8x\u000fJ|W\u000f]*ju\u0016\u0004\u0013\u0001\u0005:fiJLWM^3NKR\fG-\u0019;b)\t\tY\u0005\u0005\u0004\u0002N\u0005E\u0014q\u000f\b\u0005\u0003\u001f\nYG\u0004\u0003\u0002R\u0005\u001dd\u0002BA*\u0003KrA!!\u0016\u0002d9!\u0011qKA1\u001d\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/}\u00051AH]8pizJ\u0011!P\u0005\u0003wqJ!!\u000f\u001e\n\u00059D\u0014bAA5[\u0006)QM\u001d:pe&!\u0011QNA8\u00035)%O]8s\u0011\u0006tG\r\\5oO*\u0019\u0011\u0011N7\n\t\u0005M\u0014Q\u000f\u0002\u0010\u0007>tg.Z2u_J\u0014Vm];mi*!\u0011QNA8!\r\u0001\u0016\u0011P\u0005\u0004\u0003w\n&a\u0004,feRL7-Y'fi\u0006$\u0017\r^1\u0002%\u0005$G\rU;tQ\u0012|wO\u001c$jYR,'o\u001d\u000b\u0005\u0003\u0003\u000b\t\n\u0005\u0003\u0002\u0004\u0006-e\u0002BAC\u0003\u000f\u00032!!\u0017C\u0013\r\tIIQ\u0001\u0007!J,G-\u001a4\n\t\u00055\u0015q\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%%\tC\u0004\u0002\u0014^\u0001\r!!&\u0002\u001fA,8\u000f\u001b3po:4\u0015\u000e\u001c;feN\u0004b!a&\u0002\"\u0006\u001df\u0002BAM\u0003;sA!!\u0017\u0002\u001c&\t1)C\u0002\u0002 \n\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002$\u0006\u0015&\u0001\u0002'jgRT1!a(C!\u0011\tI+a,\u000e\u0005\u0005-&bAAWm\u0005\u0011aOM\u0005\u0005\u0003c\u000bYK\u0001\bQkNDGm\\<o\r&dG/\u001a:\u0002\u0017\u001d,G/T3uC\u0012\fG/Y\u000b\u0003\u0003\u0017\n\u0001cZ3u\t\u0006$\u0018M\u00117pG.\u001c\u0016N_3\u0016\u0005\u0005m\u0006CBA'\u0003c\ni\fE\u0002B\u0003\u007fK1!!1C\u0005\u0011auN\\4\u00023%t7M]3nK:$(+\u00198hK6\u000b\u0007oR3u\u0013:$W\r\u001f\u000b\u0007\u0003\u001b\t9-a7\t\u000f\u0005%'\u00041\u0001\u0002L\u0006\u0019Q.\u00199\u0011\u0011\u00055\u0017q[AA\u0003\u001bi!!a4\u000b\t\u0005E\u00171[\u0001\b[V$\u0018M\u00197f\u0015\r\t)NQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAm\u0003\u001f\u00141!T1q\u0011\u001d\tiN\u0007a\u0001\u0003\u0003\u000b\u0001BZ5mK:\fW.Z\u0001\u0011O\u0016$\b+\u0019:uSRLwN\\%oM>$b!a9\u0002j\u0006e\bcA$\u0002f&\u0019\u0011q\u001d\u001b\u0003\u001bA\u000b'\u000f^5uS>t\u0017J\u001c4p\u0011\u001d\tYo\u0007a\u0001\u0003[\fABZ5mK6+G/\u00193bi\u0006\u0004b!a&\u0002p\u0006M\u0018\u0002BAy\u0003K\u00131aU3r!\rA\u0016Q_\u0005\u0004\u0003oL&a\u0005)beF,X\r\u001e$jY\u0016lU\r^1eCR\f\u0007bBA~7\u0001\u0007\u0011QB\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u\u0003=9W\r^*fY\u0016\u001cGo\u00117bkN,WC\u0001B\u0001!\u0019\ti%!\u001d\u0002\u0002\u0006Yr-\u001a;QkNDGm\\<o\u0003\u001e<'/Z4bi\u0016\u001cu\u000e\\;n]N\f\u0001cZ3u\u000fJ|W\u000f\u001d2z\u00072\fWo]3\u0016\u0005\u0005\u0005\u0015AD4fi\u000e{G.^7o\u001d\u0006lWm\u001d\u000b\u0005\u0005\u0003\u0011i\u0001C\u0004\u0003\u0010}\u0001\rA!\u0005\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nCB!!1\u0003B\u0014\u001b\t\u0011)B\u0003\u0003\u0003\u0018\te\u0011!\u0002;za\u0016\u001c(\u0002\u0002B\u000e\u0005;\t1a]9m\u0015\rI$q\u0004\u0006\u0005\u0005C\u0011\u0019#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0005K\t1a\u001c:h\u0013\u0011\u0011IC!\u0006\u0003\u0015M#(/^2u)f\u0004X-\u0001\be_B\u0013XMU3bIN#X\r]:\u0015\u0005\t=\u0002CBA'\u0003c\n\u0019/A\fdQ\u0016\u001c7nU2iK6\fG+\u001f9fgN+\b\u000f]8siR1!Q\u0007B\u001f\u0005\u007f\u0001b!!\u0014\u0002r\t]\u0002cA!\u0003:%\u0019!1\b\"\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u001b\u0006\u0002\ra\u0014\u0005\u0006=\u0006\u0002\r\u0001Y\u0001\na\u0006\u0014H/\u001b;j_:,\"A!\u0012\u0011\u000b\u0005\u00139Ea\u0013\n\u0007\t%#I\u0001\u0004PaRLwN\u001c\t\u0004\u000f\n5\u0013b\u0001B(i\t)c+\u001a:uS\u000e\fG)[:ue&\u0014W\u000f^3e\r&dWm]=ti\u0016l\u0007+\u0019:uSRLwN\\\u0001\u000ea\u0006\u0014H/\u001b;j_:|F%Z9\u0015\t\t]\"Q\u000b\u0005\n\u0005/\u001a\u0013\u0011!a\u0001\u0005\u000b\n1\u0001\u001f\u00132\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\bM&dW-\u00133y\u0003-1\u0017\u000e\\3JIb|F%Z9\u0015\t\t]\"\u0011\r\u0005\n\u0005/2\u0013\u0011!a\u0001\u0003\u001b\t\u0001BZ5mK&#\u0007\u0010I\u0001\u0006i&lWM]\u000b\u0003\u0005S\u0002BAa\u001b\u0003n5\tQ.C\u0002\u0003p5\u0014Q\u0001V5nKJ\fa\u0001^5nKJ\u0004\u0013AE:uCJ$\b+\u0019:uSRLwN\u001c*fC\u0012$BA!\u000e\u0003x!9!\u0011\u0010\u0016A\u0002\tm\u0014\u0001\u0005<feRL7-\u0019)beRLG/[8o!\r9%QP\u0005\u0004\u0005\u007f\"$\u0001\u0005,feRL7-\u0019)beRLG/[8o\u000399W\r^\"mK\u0006tW\u000f]%oM>$bA!\"\u0003\u000e\nE\u0005#B!\u0003H\t\u001d\u0005cA;\u0003\n&\u0019!1\u0012<\u0003\u001f\u0019KG.Z\"mK\u0006tW\u000f]%oM>DqAa$,\u0001\u0004\u0011Y%\u0001\u0003qCJ$\bb\u0002BJW\u0001\u0007\u0011QB\u0001\u0007GV\u0014\u0018\n\u001a=\u0002\u0011I,\u0017\r\u001a#bi\u0006,\"A!'\u0011\r\u00055\u0013\u0011\u000fBN!\r9%QT\u0005\u0004\u0005?#$!\u0003#bi\u0006\u0014En\\2l\u0003A)g\u000e\u001a)beRLG/[8o%\u0016\fG\r\u0006\u0002\u00036\u0005a1\r\\3b]V\u0004h)\u001b7fg\u0006!c+\u001a:uS\u000e\fG)[:ue&\u0014W\u000f^3e\r&dWm]=ti\u0016l'+Z1e!&\u0004X\r\u0005\u0002HaM\u0011\u0001\u0007\u0011\u000b\u0003\u0005S\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:TC\u0001BZU\u0011\tiA!.,\u0005\t]\u0006\u0003\u0002B]\u0005\u0007l!Aa/\u000b\t\tu&qX\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!1C\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u000b\u0014YLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class VerticaDistributedFilesystemReadPipe
implements VerticaPipeInterface,
VerticaPipeReadInterface {
    private final DistributedFilesystemReadConfig config;
    private final FileStoreLayerInterface fileStoreLayer;
    private final JdbcLayerInterface jdbcLayer;
    private final SchemaToolsInterface schemaTools;
    private final CleanupUtilsInterface cleanupUtils;
    private final SparkContextWrapper sparkContext;
    private final int dataSize;
    private final Logger logger;
    private final int maxFileSize;
    private final int maxRowGroupSize;
    private Option<VerticaDistributedFilesystemPartition> partition;
    private int fileIdx;
    private final Timer timer;

    public static int $lessinit$greater$default$7() {
        return VerticaDistributedFilesystemReadPipe$.MODULE$.$lessinit$greater$default$7();
    }

    public DistributedFilesystemReadConfig config() {
        return this.config;
    }

    public FileStoreLayerInterface fileStoreLayer() {
        return this.fileStoreLayer;
    }

    public JdbcLayerInterface jdbcLayer() {
        return this.jdbcLayer;
    }

    public SchemaToolsInterface schemaTools() {
        return this.schemaTools;
    }

    public CleanupUtilsInterface cleanupUtils() {
        return this.cleanupUtils;
    }

    public SparkContextWrapper sparkContext() {
        return this.sparkContext;
    }

    public int dataSize() {
        return this.dataSize;
    }

    private Logger logger() {
        return this.logger;
    }

    private int maxFileSize() {
        return this.maxFileSize;
    }

    private int maxRowGroupSize() {
        return this.maxRowGroupSize;
    }

    private Either<ConnectorError, VerticaMetadata> retrieveMetadata() {
        Right right;
        Either<ConnectorError, StructType> either = this.schemaTools().readSchema(this.jdbcLayer(), this.config().tableSource());
        if (either instanceof Right) {
            Right right2 = (Right)either;
            StructType schema = (StructType)right2.value();
            right = package$.MODULE$.Right().apply((Object)new VerticaReadMetadata(schema));
        } else if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            right = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError(either);
        }
        return right;
    }

    private String addPushdownFilters(List<PushdownFilter> pushdownFilters) {
        List<PushdownFilter> list = pushdownFilters;
        String string = Nil$.MODULE$.equals(list) ? "" : new StringBuilder(7).append(" WHERE ").append(((TraversableOnce)pushdownFilters.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getFilterString(), List$.MODULE$.canBuildFrom())).mkString(" AND ")).toString();
        return string;
    }

    @Override
    public Either<ConnectorError, VerticaMetadata> getMetadata() {
        Right right;
        Option<VerticaReadMetadata> option = this.config().metadata();
        if (option instanceof Some) {
            Some some = (Some)option;
            VerticaReadMetadata data = (VerticaReadMetadata)some.value();
            right = package$.MODULE$.Right().apply((Object)data);
        } else if (None$.MODULE$.equals(option)) {
            right = this.retrieveMetadata();
        } else {
            throw new MatchError(option);
        }
        return right;
    }

    @Override
    public Either<ConnectorError, Object> getDataBlockSize() {
        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)this.dataSize()));
    }

    private int incrementRangeMapGetIndex(Map<String, Object> map, String filename) {
        if (!map.contains((Object)filename)) {
            map.update((Object)filename, (Object)BoxesRunTime.boxToInteger((int)1));
        } else {
            map.update((Object)filename, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)map.apply((Object)filename)) + 1)));
        }
        return BoxesRunTime.unboxToInt((Object)map.apply((Object)filename)) - 1;
    }

    private PartitionInfo getPartitionInfo(Seq<ParquetFileMetadata> fileMetadata, int partitionCount) {
        PartitionInfo partitionInfo;
        int totalRowGroups = BoxesRunTime.unboxToInt((Object)((TraversableOnce)fileMetadata.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.rowGroupCount()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        if (totalRowGroups == 0) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("No data. Returning empty partition list.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            partitionInfo = new PartitionInfo((InputPartition[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(InputPartition.class)));
        } else {
            BoxedUnit boxedUnit;
            int extraSpace = totalRowGroups % partitionCount == 0 ? 0 : 1;
            int rowGroupRoom = totalRowGroups / partitionCount + extraSpace;
            IntRef i = IntRef.create((int)0);
            ObjectRef partitions = ObjectRef.create((Object)Nil$.MODULE$);
            ObjectRef curFileRanges = ObjectRef.create((Object)Nil$.MODULE$);
            Map rangeCountMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Creating partitions.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            fileMetadata.foreach((Function1 & Serializable & scala.Serializable)m -> {
                VerticaDistributedFilesystemReadPipe.$anonfun$getPartitionInfo$2(this, i, rowGroupRoom, rangeCountMap, curFileRanges, partitions, m);
                return BoxedUnit.UNIT;
            });
            if (((List)curFileRanges.elem).nonEmpty()) {
                VerticaDistributedFilesystemPartition partition = new VerticaDistributedFilesystemPartition((Seq<ParquetFileRange>)((List)curFileRanges.elem), VerticaDistributedFilesystemPartition$.MODULE$.apply$default$2());
                partitions.elem = (List)((List)partitions.elem).$colon$plus((Object)partition, List$.MODULE$.canBuildFrom());
            }
            partitions.elem = (List)((List)partitions.elem).map((Function1 & Serializable & scala.Serializable)part -> {
                Some x$1 = new Some((Object)rangeCountMap.toMap(Predef$.MODULE$.$conforms()));
                Seq<ParquetFileRange> x$2 = part.copy$default$1();
                return part.copy(x$2, (Option<scala.collection.immutable.Map<String, Object>>)x$1);
            }, List$.MODULE$.canBuildFrom());
            partitionInfo = new PartitionInfo((InputPartition[])((List)partitions.elem).toArray(ClassTag$.MODULE$.apply(InputPartition.class)));
        }
        return partitionInfo;
    }

    private Either<ConnectorError, String> getSelectClause() {
        return this.config().isAggPushedDown() ? this.getPushdownAggregateColumns() : this.getColumnNames(this.config().getRequiredSchema());
    }

    private Either<ConnectorError, String> getPushdownAggregateColumns() {
        String selectClause = ((TraversableOnce)this.config().getRequiredSchema().map((Function1 & Serializable & scala.Serializable)col -> new StringBuilder(6).append(col.name()).append(" as ").append("\"").append(col.name()).append("\"").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        return package$.MODULE$.Right().apply((Object)selectClause);
    }

    private String getGroupbyClause() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.config().getGroupBy())).nonEmpty() ? new StringBuilder(10).append(" GROUP BY ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.config().getGroupBy())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ")).toString() : "";
    }

    private Either<ConnectorError, String> getColumnNames(StructType requiredSchema) {
        Left left;
        Either<ConnectorError, Seq<ColumnDef>> either = this.schemaTools().getColumnInfo(this.jdbcLayer(), this.config().tableSource());
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err.context("Failed to get table schema when checking for fields that need casts."));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq columnDefs = (Seq)right.value();
            left = package$.MODULE$.Right().apply((Object)this.schemaTools().makeColumnsString((Seq<ColumnDef>)columnDefs, requiredSchema));
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Either<ConnectorError, PartitionInfo> doPreReadSteps() {
        fileStoreConfig = this.config().fileStoreConfig();
        v0 = new StringOps(Predef$.MODULE$.augmentString(fileStoreConfig.address())).takeRight(1);
        var4_2 = "/";
        if (!(v0 == null ? var4_2 != null : v0.equals(var4_2) == false)) ** GOTO lbl-1000
        v1 = new StringOps(Predef$.MODULE$.augmentString(fileStoreConfig.address())).takeRight(1);
        var5_3 = "\\";
        if (!(v1 != null ? v1.equals(var5_3) == false : var5_3 != null)) lbl-1000:
        // 2 sources

        {
            v2 = "";
        } else {
            v2 = "/";
        }
        delimiter = v2;
        hdfsPath = new StringBuilder(0).append(fileStoreConfig.address()).append(delimiter).append(this.config().tableSource().identifier()).toString();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(13).append("Export path: ").append(hdfsPath).toString());
            v3 = BoxedUnit.UNIT;
        } else {
            v3 = BoxedUnit.UNIT;
        }
        var8_7 = ret = this.getMetadata().flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$doPreReadSteps$1(com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe com.vertica.spark.config.FileStoreConfig java.lang.String com.vertica.spark.config.VerticaMetadata ), (Lcom/vertica/spark/config/VerticaMetadata;)Lscala/util/Either;)((VerticaDistributedFilesystemReadPipe)this, (FileStoreConfig)fileStoreConfig, (String)hdfsPath));
        if (var8_7 instanceof Left) {
            if (!this.config().fileStoreConfig().preventCleanup()) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder(31).append("Cleaning up all files in path: ").append(hdfsPath).toString());
                    v4 = BoxedUnit.UNIT;
                } else {
                    v4 = BoxedUnit.UNIT;
                }
                v5 = this.cleanupUtils().cleanupAll(this.fileStoreLayer(), hdfsPath);
            } else {
                v5 = BoxedUnit.UNIT;
            }
            var1_8 = this.jdbcLayer().close();
        } else {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Reading data from Parquet file.");
                v6 = BoxedUnit.UNIT;
            } else {
                v6 = BoxedUnit.UNIT;
            }
            var1_8 = v6;
        }
        return ret;
    }

    private Either<ConnectorError, BoxedUnit> checkSchemaTypesSupport(DistributedFilesystemReadConfig config, JdbcLayerInterface jdbcLayer) {
        VerticaVersion version = VerticaVersionUtils$.MODULE$.getVersion(jdbcLayer);
        return VerticaVersionUtils$.MODULE$.checkSchemaTypesReadSupport(config.getRequiredSchema(), version);
    }

    public Option<VerticaDistributedFilesystemPartition> partition() {
        return this.partition;
    }

    public void partition_$eq(Option<VerticaDistributedFilesystemPartition> x$1) {
        this.partition = x$1;
    }

    public int fileIdx() {
        return this.fileIdx;
    }

    public void fileIdx_$eq(int x$1) {
        this.fileIdx = x$1;
    }

    public Timer timer() {
        return this.timer;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> startPartitionRead(VerticaPartition verticaPartition) {
        Right right;
        BoxedUnit boxedUnit;
        this.timer().startTime();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting partition read.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        VerticaPartition verticaPartition2 = verticaPartition;
        if (verticaPartition2 instanceof VerticaDistributedFilesystemPartition) {
            VerticaDistributedFilesystemPartition verticaDistributedFilesystemPartition = (VerticaDistributedFilesystemPartition)verticaPartition2;
            right = package$.MODULE$.Right().apply((Object)verticaDistributedFilesystemPartition);
        } else {
            right = package$.MODULE$.Left().apply((Object)new InvalidPartition());
        }
        return right.map((Function1 & Serializable & scala.Serializable)part -> {
            this.partition_$eq((Option<VerticaDistributedFilesystemPartition>)new Some(part));
            BoxedUnit x$21 = BoxedUnit.UNIT;
            this.fileIdx_$eq(0);
            BoxedUnit x$22 = BoxedUnit.UNIT;
            return new Tuple3(part, (Object)x$21, (Object)x$22);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$23 -> {
            Either<ConnectorError, BoxedUnit> either;
            Tuple3 tuple3 = x$23;
            if (tuple3 == null) throw new MatchError((Object)tuple3);
            VerticaDistributedFilesystemPartition part = (VerticaDistributedFilesystemPartition)tuple3._1();
            Option option = part.fileRanges().headOption();
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("No files to read set on partition.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                either = package$.MODULE$.Left().apply((Object)new DoneReading());
                return either.map((Function1 & Serializable & scala.Serializable)ret -> {
                    VerticaDistributedFilesystemReadPipe.$anonfun$startPartitionRead$3(ret);
                    return BoxedUnit.UNIT;
                });
            } else {
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                Some some = (Some)option;
                ParquetFileRange head = (ParquetFileRange)some.value();
                either = this.fileStoreLayer().openReadParquetFile(head);
            }
            return either.map((Function1 & Serializable & scala.Serializable)ret -> {
                VerticaDistributedFilesystemReadPipe.$anonfun$startPartitionRead$3(ret);
                return BoxedUnit.UNIT;
            });
        });
    }

    private Option<FileCleanupInfo> getCleanupInfo(VerticaDistributedFilesystemPartition part, int curIdx) {
        Some some;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(44).append("Getting cleanup info for partition with idx ").append(curIdx).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (curIdx >= part.fileRanges().size()) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(40).append("Invalid fileIdx ").append(this.fileIdx()).append(", can't perform cleanup.").toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            some = None$.MODULE$;
        } else {
            some = new Some((Object)BoxedUnit.UNIT);
        }
        return some.map((Function1 & Serializable & scala.Serializable)x$24 -> {
            ParquetFileRange curRange = (ParquetFileRange)part.fileRanges().apply(curIdx);
            return new Tuple2(x$24, (Object)curRange);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$25 -> {
            None$ none$;
            Tuple2 tuple2 = x$25;
            if (tuple2 != null) {
                Some some;
                scala.collection.immutable.Map rangeCountMap;
                ParquetFileRange curRange = (ParquetFileRange)tuple2._2();
                Option<scala.collection.immutable.Map<String, Object>> option = part.rangeCountMap();
                if (option instanceof Some && (rangeCountMap = (scala.collection.immutable.Map)(some = (Some)option).value()).contains((Object)curRange.filename())) {
                    None$ none$2;
                    Option<Object> option2 = curRange.rangeIdx();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        int rangeIdx = BoxesRunTime.unboxToInt((Object)some2.value());
                        none$2 = new Some((Object)new FileCleanupInfo(curRange.filename(), rangeIdx, BoxesRunTime.unboxToInt((Object)rangeCountMap.apply((Object)curRange.filename()))));
                    } else if (None$.MODULE$.equals(option2)) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn(new StringBuilder(63).append("Missing range count index. Not performing any cleanup for file ").append(curRange.filename()).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        none$2 = None$.MODULE$;
                    } else {
                        throw new MatchError(option2);
                    }
                    none$ = none$2;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder(61).append("Missing range count map. Not performing any cleanup for file ").append(curRange.filename()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    none$ = None$.MODULE$;
                } else {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder(70).append("Missing value in range count map. Not performing any cleanup for file ").append(curRange.filename()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    none$ = None$.MODULE$;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Option option = none$.map((Function1 & Serializable & scala.Serializable)ret -> ret);
            return option;
        });
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Either<ConnectorError, DataBlock> readData() {
        block30: {
            block32: {
                block34: {
                    block33: {
                        block31: {
                            block27: {
                                block29: {
                                    block28: {
                                        var7_1 = this.partition();
                                        if (None$.MODULE$.equals(var7_1)) {
                                            return package$.MODULE$.Left().apply((Object)new UninitializedReadError());
                                        }
                                        if (!(var7_1 instanceof Some)) {
                                            throw new MatchError(var7_1);
                                        }
                                        var8_2 = (Some)var7_1;
                                        var5_4 = p = (VerticaDistributedFilesystemPartition)var8_2.value();
                                        part = var5_4;
                                        var11_6 = this.fileStoreLayer().readDataFromParquetFile(this.dataSize());
                                        if (var11_6 instanceof Left) {
                                            var12_7 = (Left)var11_6;
                                            err = (ConnectorError)var12_7.value();
                                            var4_9 = package$.MODULE$.Left().apply((Object)err);
                                        } else if (var11_6 instanceof Right) {
                                            var14_10 = (Right)var11_6;
                                            data = (DataBlock)var14_10.value();
                                            if (data.data().nonEmpty()) {
                                                v0 = package$.MODULE$.Right().apply((Object)data);
                                            } else {
                                                if (this.logger().underlying().isInfoEnabled()) {
                                                    this.logger().underlying().info("Hit done reading for file segment.");
                                                    v1 = BoxedUnit.UNIT;
                                                } else {
                                                    v1 = BoxedUnit.UNIT;
                                                }
                                                this.fileIdx_$eq(this.fileIdx() + 1);
                                                if (this.fileIdx() >= part.fileRanges().size()) {
                                                    return package$.MODULE$.Right().apply((Object)data);
                                                }
                                                v0 = this.fileStoreLayer().closeReadParquetFile().flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$readData$1(com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe com.vertica.spark.datasource.core.VerticaDistributedFilesystemPartition scala.runtime.BoxedUnit ), (Lscala/runtime/BoxedUnit;)Lscala/util/Either;)((VerticaDistributedFilesystemReadPipe)this, (VerticaDistributedFilesystemPartition)part));
                                            }
                                            var4_9 = v0;
                                        } else {
                                            throw new MatchError(var11_6);
                                        }
                                        ret = var4_9;
                                        var16_13 = new Tuple2((Object)ret, this.getCleanupInfo(part, this.fileIdx()));
                                        if (var16_13 == null) break block27;
                                        var17_14 = (Either)var16_13._1();
                                        var18_15 = (Option)var16_13._2();
                                        if (!(var17_14 instanceof Left) || !(var18_15 instanceof Some)) break block27;
                                        var19_16 = (Some)var18_15;
                                        cleanupInfo = (FileCleanupInfo)var19_16.value();
                                        if (this.config().fileStoreConfig().preventCleanup()) break block28;
                                        var21_18 = this.cleanupUtils().checkAndCleanup(this.fileStoreLayer(), cleanupInfo);
                                        if (!(var21_18 instanceof Right)) ** GOTO lbl-1000
                                        var22_19 = (Right)var21_18;
                                        var23_20 = (BoxedUnit)var22_19.value();
                                        v2 = BoxedUnit.UNIT;
                                        var24_21 = var23_20;
                                        if (!(v2 != null ? v2.equals(var24_21) == false : var24_21 != null)) {
                                            var3_22 = BoxedUnit.UNIT;
                                        } else if (var21_18 instanceof Left) {
                                            var25_24 = (Left)var21_18;
                                            err = (ConnectorError)var25_24.value();
                                            if (this.logger().underlying().isWarnEnabled()) {
                                                this.logger().underlying().warn(new StringBuilder(33).append("Ran into error when cleaning up: ").append(err.getFullContext()).toString());
                                                v3 = BoxedUnit.UNIT;
                                            } else {
                                                v3 = BoxedUnit.UNIT;
                                            }
                                            var3_23 = v3;
                                        } else {
                                            throw new MatchError(var21_18);
                                        }
                                        v4 = BoxedUnit.UNIT;
                                        break block29;
                                    }
                                    v4 = BoxedUnit.UNIT;
                                }
                                var1_26 = v4;
                                break block30;
                            }
                            if (var16_13 == null) break block31;
                            var27_30 = (Either)var16_13._1();
                            var28_31 = (Option)var16_13._2();
                            if (!(var27_30 instanceof Left) || !None$.MODULE$.equals(var28_31)) break block31;
                            if (this.logger().underlying().isWarnEnabled()) {
                                this.logger().underlying().warn("No cleanup info found");
                                v5 = BoxedUnit.UNIT;
                            } else {
                                v5 = BoxedUnit.UNIT;
                            }
                            var1_27 = v5;
                            break block30;
                        }
                        if (var16_13 == null) break block32;
                        var29_32 = (Either)var16_13._1();
                        var30_33 = (Option)var16_13._2();
                        if (!(var29_32 instanceof Right)) break block32;
                        var31_34 = (Right)var29_32;
                        dataBlock = (DataBlock)var31_34.value();
                        if (!(var30_33 instanceof Some)) break block32;
                        var33_36 = (Some)var30_33;
                        cleanupInfo = (FileCleanupInfo)var33_36.value();
                        if (!dataBlock.data().isEmpty() || this.config().fileStoreConfig().preventCleanup()) break block33;
                        var35_38 = this.cleanupUtils().checkAndCleanup(this.fileStoreLayer(), cleanupInfo);
                        if (!(var35_38 instanceof Right)) ** GOTO lbl-1000
                        var36_39 = (Right)var35_38;
                        var37_40 = (BoxedUnit)var36_39.value();
                        v6 = BoxedUnit.UNIT;
                        var38_41 = var37_40;
                        if (!(v6 != null ? v6.equals(var38_41) == false : var38_41 != null)) {
                            var2_42 = BoxedUnit.UNIT;
                        } else if (var35_38 instanceof Left) {
                            var39_44 = (Left)var35_38;
                            err = (ConnectorError)var39_44.value();
                            if (this.logger().underlying().isWarnEnabled()) {
                                this.logger().underlying().warn(new StringBuilder(33).append("Ran into error when cleaning up: ").append(err.getFullContext()).toString());
                                v7 = BoxedUnit.UNIT;
                            } else {
                                v7 = BoxedUnit.UNIT;
                            }
                            var2_43 = v7;
                        } else {
                            throw new MatchError(var35_38);
                        }
                        v8 = BoxedUnit.UNIT;
                        break block34;
                    }
                    v8 = BoxedUnit.UNIT;
                }
                var1_28 = v8;
                break block30;
            }
            if (var16_13 == null) ** GOTO lbl-1000
            var41_46 = (Either)var16_13._1();
            var42_47 = (Option)var16_13._2();
            if (var41_46 instanceof Right && None$.MODULE$.equals(var42_47)) {
                var1_29 = BoxedUnit.UNIT;
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var16_13);
            }
        }
        return ret;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> endPartitionRead() {
        this.timer().endTime();
        return this.cleanupFiles().flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.fileStoreLayer().closeReadParquetFile().map((Function1 & Serializable & scala.Serializable)_ -> {
            VerticaDistributedFilesystemReadPipe.$anonfun$endPartitionRead$2(_);
            return BoxedUnit.UNIT;
        }));
    }

    public Either<ConnectorError, BoxedUnit> cleanupFiles() {
        VerticaDistributedFilesystemPartition p;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Removing files before closing read pipe.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Option<VerticaDistributedFilesystemPartition> option = this.partition();
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)new UninitializedReadError());
        }
        if (!(option instanceof Some)) {
            throw new MatchError(option);
        }
        Some some = (Some)option;
        VerticaDistributedFilesystemPartition verticaDistributedFilesystemPartition = p = (VerticaDistributedFilesystemPartition)some.value();
        VerticaDistributedFilesystemPartition part = verticaDistributedFilesystemPartition;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), part.fileRanges().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)fileIdx -> {
            if (!this.config().fileStoreConfig().preventCleanup()) {
                Option<FileCleanupInfo> option = this.getCleanupInfo(part, fileIdx);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FileCleanupInfo cleanupInfo = (FileCleanupInfo)some.value();
                    Either<ConnectorError, BoxedUnit> either = this.cleanupUtils().checkAndCleanup(this.fileStoreLayer(), cleanupInfo);
                    if (either instanceof Left) {
                        BoxedUnit boxedUnit;
                        Left left = (Left)either;
                        ConnectorError err = (ConnectorError)left.value();
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn(new StringBuilder(69).append("Ran into error when calling cleaning up. Treating as non-fatal. Err: ").append(err.getFullContext()).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else if (either instanceof Right) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(either);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("No cleanup info found.");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                } else {
                    throw new MatchError(option);
                }
            }
        });
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    public static final /* synthetic */ void $anonfun$getPartitionInfo$2(VerticaDistributedFilesystemReadPipe $this, IntRef i$1, int rowGroupRoom$1, Map rangeCountMap$1, ObjectRef curFileRanges$1, ObjectRef partitions$1, ParquetFileMetadata m) {
        BoxedUnit boxedUnit;
        int size = m.rowGroupCount();
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(37).append("Splitting file ").append(m.filename()).append(" with row group count ").append(size).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        int low = 0;
        for (int j = 0; j < size; ++j) {
            if (i$1.elem == rowGroupRoom$1 - 1) {
                BoxedUnit boxedUnit2;
                int rangeIdx = $this.incrementRangeMapGetIndex((Map<String, Object>)rangeCountMap$1, m.filename());
                ParquetFileRange frange = new ParquetFileRange(m.filename(), low, j, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)rangeIdx)));
                curFileRanges$1.elem = (List)((List)curFileRanges$1.elem).$colon$plus((Object)frange, List$.MODULE$.canBuildFrom());
                VerticaDistributedFilesystemPartition partition = new VerticaDistributedFilesystemPartition((Seq<ParquetFileRange>)((List)curFileRanges$1.elem), VerticaDistributedFilesystemPartition$.MODULE$.apply$default$2());
                partitions$1.elem = (List)((List)partitions$1.elem).$colon$plus((Object)partition, List$.MODULE$.canBuildFrom());
                curFileRanges$1.elem = Nil$.MODULE$;
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug(new StringBuilder(65).append("Reached partition with file ").append(m.filename()).append(" , range low: ").append(low).append(" , range high: ").append(j).append(" , idx: ").append(rangeIdx).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                i$1.elem = 0;
                low = j + 1;
                continue;
            }
            if (j == size - 1) {
                BoxedUnit boxedUnit3;
                int rangeIdx = $this.incrementRangeMapGetIndex((Map<String, Object>)rangeCountMap$1, m.filename());
                ParquetFileRange frange = new ParquetFileRange(m.filename(), low, j, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)rangeIdx)));
                curFileRanges$1.elem = (List)((List)curFileRanges$1.elem).$colon$plus((Object)frange, List$.MODULE$.canBuildFrom());
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug(new StringBuilder(57).append("Reached end of file ").append(m.filename()).append(" , range low: ").append(low).append(" , range high: ").append(j).append(" , idx: ").append(rangeIdx).toString());
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                ++i$1.elem;
                continue;
            }
            ++i$1.elem;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$doPreReadSteps$6(VerticaDistributedFilesystemReadPipe $this, boolean exportDone) {
        ValidFilePermissions filePermissions = $this.config().filePermissions();
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exportDone), (Object)filePermissions);
    }

    public static final /* synthetic */ Either $anonfun$doPreReadSteps$12(VerticaDistributedFilesystemReadPipe $this, String hdfsPath$1, boolean dirExists) {
        return (!dirExists ? package$.MODULE$.Right().apply((Object)Nil$.MODULE$) : $this.fileStoreLayer().getFileList(hdfsPath$1)).map((Function1 & Serializable & scala.Serializable)fullFileList -> {
            BoxedUnit boxedUnit;
            BoxedUnit x$10;
            BoxedUnit boxedUnit2;
            int n;
            Seq parquetFileList = (Seq)fullFileList.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)x.endsWith(".parquet")));
            Option<Object> option = $this.config().partitionCount();
            if (option instanceof Some) {
                int count;
                Some some = (Some)option;
                n = count = BoxesRunTime.unboxToInt((Object)some.value());
            } else if (None$.MODULE$.equals(option)) {
                n = parquetFileList.size();
            } else {
                throw new MatchError(option);
            }
            int requestedPartitionCount = n;
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringBuilder(27).append("Requested partition count: ").append(requestedPartitionCount).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = x$10 = BoxedUnit.UNIT;
            }
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringBuilder(24).append("Parquet file list size: ").append(parquetFileList.size()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$11 = boxedUnit;
            Timer partitionTimer = new Timer($this.config().timeOperations(), $this.logger(), "Reading Parquet Files Metadata and creating partitions");
            partitionTimer.startTime();
            BoxedUnit x$12 = BoxedUnit.UNIT;
            return new Tuple7(fullFileList, (Object)parquetFileList, (Object)BoxesRunTime.boxToInteger((int)requestedPartitionCount), (Object)x$10, (Object)x$11, (Object)partitionTimer, (Object)x$12);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$17 -> {
            Tuple7 tuple7 = x$17;
            if (tuple7 == null) {
                throw new MatchError((Object)tuple7);
            }
            Seq parquetFileList = (Seq)tuple7._2();
            int requestedPartitionCount = BoxesRunTime.unboxToInt((Object)tuple7._3());
            Timer partitionTimer = (Timer)tuple7._6();
            Either either = ((Either)implicits$.MODULE$.toTraverseOps((Object)parquetFileList.toList(), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)filename -> $this.fileStoreLayer().getParquetFileMetadata((String)filename), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable & scala.Serializable)fileMetadata -> {
                int n;
                Either<ConnectorError, BoxedUnit> x$14;
                Either<ConnectorError, BoxedUnit> either;
                BoxedUnit x$13;
                BoxedUnit boxedUnit;
                int totalRowGroups = BoxesRunTime.unboxToInt((Object)((TraversableOnce)fileMetadata.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.rowGroupCount()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info(new StringBuilder(18).append("Total row groups: ").append(totalRowGroups).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = x$13 = BoxedUnit.UNIT;
                }
                if (totalRowGroups == 0) {
                    if (!$this.config().fileStoreConfig().preventCleanup()) {
                        BoxedUnit boxedUnit2;
                        if ($this.logger().underlying().isDebugEnabled()) {
                            $this.logger().underlying().debug(new StringBuilder(37).append("Cleaning up empty directory in path: ").append(hdfsPath$1).toString());
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        either = $this.cleanupUtils().cleanupAll($this.fileStoreLayer(), hdfsPath$1);
                    } else {
                        either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    }
                } else {
                    either = x$14 = BoxedUnit.UNIT;
                }
                if (totalRowGroups < requestedPartitionCount) {
                    BoxedUnit boxedUnit3;
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(43).append("Less than ").append(requestedPartitionCount).append(" partitions required, only using ").append(totalRowGroups).toString());
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    n = totalRowGroups;
                } else {
                    n = requestedPartitionCount;
                }
                int partitionCount = n;
                PartitionInfo partitionInfo = $this.getPartitionInfo((Seq<ParquetFileMetadata>)fileMetadata, partitionCount);
                partitionTimer.endTime();
                BoxedUnit x$15 = BoxedUnit.UNIT;
                return new Tuple7(fileMetadata, (Object)BoxesRunTime.boxToInteger((int)totalRowGroups), (Object)x$13, x$14, (Object)BoxesRunTime.boxToInteger((int)partitionCount), (Object)partitionInfo, (Object)x$15);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> {
                Tuple7 tuple7 = x$16;
                if (tuple7 == null) {
                    throw new MatchError((Object)tuple7);
                }
                PartitionInfo partitionInfo = (PartitionInfo)tuple7._6();
                Either either = $this.jdbcLayer().close().map((Function1 & Serializable & scala.Serializable)_ -> partitionInfo);
                return either;
            });
            return either;
        });
    }

    public static final /* synthetic */ Either $anonfun$doPreReadSteps$1(VerticaDistributedFilesystemReadPipe $this, FileStoreConfig fileStoreConfig$1, String hdfsPath$1, VerticaMetadata _2) {
        return $this.jdbcLayer().configureSession($this.fileStoreLayer()).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.checkSchemaTypesSupport($this.config(), $this.jdbcLayer()).map((Function1 & Serializable & scala.Serializable)x$5 -> {
            BoxedUnit boxedUnit;
            ValidFilePermissions perm = $this.config().filePermissions();
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringBuilder(46).append("Creating unique directory: ").append(fileStoreConfig$1.address()).append(" with permissions: ").append(perm).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$6 = boxedUnit;
            return new Tuple3(x$5, (Object)perm, (Object)x$6);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$20 -> {
            Right right;
            Tuple3 tuple3 = x$20;
            if (tuple3 == null) throw new MatchError((Object)tuple3);
            ValidFilePermissions perm = (ValidFilePermissions)tuple3._2();
            Either<ConnectorError, BoxedUnit> either = $this.fileStoreLayer().createDir(fileStoreConfig$1.address(), perm.toString());
            if (either instanceof Left) {
                Right right2;
                Left left = (Left)either;
                ConnectorError err = (ConnectorError)left.value();
                ConnectorError connectorError = err.getUnderlyingError();
                if (connectorError instanceof CreateDirectoryAlreadyExistsError) {
                    BoxedUnit boxedUnit;
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(27).append("Directory already existed: ").append(fileStoreConfig$1.address()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    right2 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                } else {
                    right2 = package$.MODULE$.Left().apply((Object)err.context(new StringBuilder(28).append("Failed to create directory: ").append(fileStoreConfig$1.address()).toString()));
                }
                right = right2;
                return right.flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.fileStoreLayer().fileExists(hdfsPath$1).map((Function1 & Serializable & scala.Serializable)exportDone -> VerticaDistributedFilesystemReadPipe.$anonfun$doPreReadSteps$6($this, BoxesRunTime.unboxToBoolean((Object)exportDone))).flatMap((Function1 & Serializable & scala.Serializable)x$19 -> {
                    Tuple2 tuple2 = x$19;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    boolean exportDone = tuple2._1$mcZ$sp();
                    ValidFilePermissions filePermissions = (ValidFilePermissions)tuple2._2();
                    Either either = $this.getSelectClause().map((Function1 & Serializable & scala.Serializable)selectClause -> {
                        BoxedUnit boxedUnit;
                        String string;
                        BoxedUnit boxedUnit2;
                        BoxedUnit boxedUnit3;
                        if ($this.logger().underlying().isInfoEnabled()) {
                            $this.logger().underlying().info(new StringBuilder(25).append("Select clause requested: ").append((String)selectClause).toString());
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        BoxedUnit x$7 = boxedUnit3;
                        String groupbyClause = $this.getGroupbyClause();
                        String pushdownFilters = $this.addPushdownFilters($this.config().getPushdownFilters());
                        if ($this.logger().underlying().isInfoEnabled()) {
                            $this.logger().underlying().info(new StringBuilder(18).append("Pushdown filters: ").append(pushdownFilters).toString());
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        BoxedUnit x$8 = boxedUnit2;
                        TableSource tableSource = $this.config().tableSource();
                        if (tableSource instanceof TableName) {
                            TableName tableName = (TableName)tableSource;
                            string = tableName.getFullTableName();
                        } else if (tableSource instanceof TableQuery) {
                            TableQuery tableQuery = (TableQuery)tableSource;
                            String query = tableQuery.query();
                            string = new StringBuilder(7).append("(").append(query).append(") AS x").toString();
                        } else {
                            throw new MatchError((Object)tableSource);
                        }
                        String exportSource = string;
                        if ($this.logger().underlying().isInfoEnabled()) {
                            $this.logger().underlying().info(new StringBuilder(15).append("Export Source: ").append(exportSource).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit x$9 = boxedUnit;
                        String exportStatement = new StringBuilder(114).append("EXPORT TO PARQUET(directory = '").append(hdfsPath$1).append("', fileSizeMB = ").append($this.maxFileSize()).append(", rowGroupSizeMB = ").append($this.maxRowGroupSize()).append(", fileMode = '").append(filePermissions).append("', dirMode = '").append(filePermissions).append("') AS SELECT ").append((String)selectClause).append(" FROM ").append(exportSource).append(pushdownFilters).append(groupbyClause).append(";").toString();
                        return new Tuple8(selectClause, (Object)x$7, (Object)groupbyClause, (Object)pushdownFilters, (Object)x$8, (Object)exportSource, (Object)x$9, (Object)exportStatement);
                    }).flatMap((Function1 & Serializable & scala.Serializable)x$18 -> {
                        Right right;
                        Tuple8 tuple8 = x$18;
                        if (tuple8 != null) {
                            String exportStatement = (String)tuple8._8();
                            if (exportDone) {
                                BoxedUnit boxedUnit;
                                if ($this.logger().underlying().isInfoEnabled()) {
                                    $this.logger().underlying().info("Export already done, skipping export step.");
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                            } else {
                                BoxedUnit boxedUnit;
                                if ($this.logger().underlying().isInfoEnabled()) {
                                    $this.logger().underlying().info(new StringBuilder(28).append("Exporting using statement: \n").append(exportStatement).toString());
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                Timer timer = new Timer($this.config().timeOperations(), $this.logger(), "Export To Parquet From Vertica");
                                timer.startTime();
                                Either res = EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither($this.jdbcLayer().execute(exportStatement, $this.jdbcLayer().execute$default$2())), (Function1 & Serializable & scala.Serializable)err -> new ExportFromVerticaError((ConnectorError)err));
                                $this.sparkContext().addSparkListener(new ApplicationParquetCleaner($this.config()));
                                timer.endTime();
                                right = res;
                            }
                        } else {
                            throw new MatchError((Object)tuple8);
                        }
                        Either either = right.flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.fileStoreLayer().fileExists(hdfsPath$1).flatMap((Function1 & Serializable & scala.Serializable)dirExists -> VerticaDistributedFilesystemReadPipe.$anonfun$doPreReadSteps$12($this, hdfsPath$1, BoxesRunTime.unboxToBoolean((Object)dirExists))));
                        return either;
                    });
                    return either;
                }));
            } else {
                if (!(either instanceof Right)) throw new MatchError(either);
                right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            return right.flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.fileStoreLayer().fileExists(hdfsPath$1).map((Function1 & Serializable & scala.Serializable)exportDone -> VerticaDistributedFilesystemReadPipe.$anonfun$doPreReadSteps$6($this, BoxesRunTime.unboxToBoolean((Object)exportDone))).flatMap((Function1 & Serializable & scala.Serializable)x$19 -> {
                Tuple2 tuple2 = x$19;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                boolean exportDone = tuple2._1$mcZ$sp();
                ValidFilePermissions filePermissions = (ValidFilePermissions)tuple2._2();
                Either either = $this.getSelectClause().map((Function1 & Serializable & scala.Serializable)selectClause -> {
                    BoxedUnit boxedUnit;
                    String string;
                    BoxedUnit boxedUnit2;
                    BoxedUnit boxedUnit3;
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(25).append("Select clause requested: ").append((String)selectClause).toString());
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    BoxedUnit x$7 = boxedUnit3;
                    String groupbyClause = $this.getGroupbyClause();
                    String pushdownFilters = $this.addPushdownFilters($this.config().getPushdownFilters());
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(18).append("Pushdown filters: ").append(pushdownFilters).toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    BoxedUnit x$8 = boxedUnit2;
                    TableSource tableSource = $this.config().tableSource();
                    if (tableSource instanceof TableName) {
                        TableName tableName = (TableName)tableSource;
                        string = tableName.getFullTableName();
                    } else if (tableSource instanceof TableQuery) {
                        TableQuery tableQuery = (TableQuery)tableSource;
                        String query = tableQuery.query();
                        string = new StringBuilder(7).append("(").append(query).append(") AS x").toString();
                    } else {
                        throw new MatchError((Object)tableSource);
                    }
                    String exportSource = string;
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(15).append("Export Source: ").append(exportSource).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit x$9 = boxedUnit;
                    String exportStatement = new StringBuilder(114).append("EXPORT TO PARQUET(directory = '").append(hdfsPath$1).append("', fileSizeMB = ").append($this.maxFileSize()).append(", rowGroupSizeMB = ").append($this.maxRowGroupSize()).append(", fileMode = '").append(filePermissions).append("', dirMode = '").append(filePermissions).append("') AS SELECT ").append((String)selectClause).append(" FROM ").append(exportSource).append(pushdownFilters).append(groupbyClause).append(";").toString();
                    return new Tuple8(selectClause, (Object)x$7, (Object)groupbyClause, (Object)pushdownFilters, (Object)x$8, (Object)exportSource, (Object)x$9, (Object)exportStatement);
                }).flatMap((Function1 & Serializable & scala.Serializable)x$18 -> {
                    Right right;
                    Tuple8 tuple8 = x$18;
                    if (tuple8 != null) {
                        String exportStatement = (String)tuple8._8();
                        if (exportDone) {
                            BoxedUnit boxedUnit;
                            if ($this.logger().underlying().isInfoEnabled()) {
                                $this.logger().underlying().info("Export already done, skipping export step.");
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                        } else {
                            BoxedUnit boxedUnit;
                            if ($this.logger().underlying().isInfoEnabled()) {
                                $this.logger().underlying().info(new StringBuilder(28).append("Exporting using statement: \n").append(exportStatement).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            Timer timer = new Timer($this.config().timeOperations(), $this.logger(), "Export To Parquet From Vertica");
                            timer.startTime();
                            Either res = EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither($this.jdbcLayer().execute(exportStatement, $this.jdbcLayer().execute$default$2())), (Function1 & Serializable & scala.Serializable)err -> new ExportFromVerticaError((ConnectorError)err));
                            $this.sparkContext().addSparkListener(new ApplicationParquetCleaner($this.config()));
                            timer.endTime();
                            right = res;
                        }
                    } else {
                        throw new MatchError((Object)tuple8);
                    }
                    Either either = right.flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.fileStoreLayer().fileExists(hdfsPath$1).flatMap((Function1 & Serializable & scala.Serializable)dirExists -> VerticaDistributedFilesystemReadPipe.$anonfun$doPreReadSteps$12($this, hdfsPath$1, BoxesRunTime.unboxToBoolean((Object)dirExists))));
                    return either;
                });
                return either;
            }));
        }));
    }

    public static final /* synthetic */ void $anonfun$startPartitionRead$3(BoxedUnit ret) {
    }

    public static final /* synthetic */ Either $anonfun$readData$1(VerticaDistributedFilesystemReadPipe $this, VerticaDistributedFilesystemPartition part$2, BoxedUnit _2) {
        return $this.fileStoreLayer().openReadParquetFile((ParquetFileRange)part$2.fileRanges().apply($this.fileIdx())).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.fileStoreLayer().readDataFromParquetFile($this.dataSize()).map((Function1 & Serializable & scala.Serializable)data -> data));
    }

    public static final /* synthetic */ void $anonfun$endPartitionRead$2(BoxedUnit _) {
    }

    public VerticaDistributedFilesystemReadPipe(DistributedFilesystemReadConfig config, FileStoreLayerInterface fileStoreLayer, JdbcLayerInterface jdbcLayer, SchemaToolsInterface schemaTools, CleanupUtilsInterface cleanupUtils, SparkContextWrapper sparkContext, int dataSize) {
        this.config = config;
        this.fileStoreLayer = fileStoreLayer;
        this.jdbcLayer = jdbcLayer;
        this.schemaTools = schemaTools;
        this.cleanupUtils = cleanupUtils;
        this.sparkContext = sparkContext;
        this.dataSize = dataSize;
        this.logger = LogProvider$.MODULE$.getLogger(VerticaDistributedFilesystemReadPipe.class);
        this.maxFileSize = config.maxFileSize();
        this.maxRowGroupSize = config.maxRowGroupSize();
        this.partition = None$.MODULE$;
        this.fileIdx = 0;
        this.timer = new Timer(config.timeOperations(), this.logger(), "Partition Read");
    }
}

