/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.core.factory;

import com.vertica.spark.config.DistributedFilesystemReadConfig;
import com.vertica.spark.config.DistributedFilesystemWriteConfig;
import com.vertica.spark.config.FileStoreConfig;
import com.vertica.spark.config.JDBCConfig;
import com.vertica.spark.config.ReadConfig;
import com.vertica.spark.config.VerticaReadMetadata;
import com.vertica.spark.config.WriteConfig;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipe;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipe$;
import com.vertica.spark.datasource.core.VerticaPipeInterface;
import com.vertica.spark.datasource.core.factory.VerticaPipeFactoryInterface;
import com.vertica.spark.datasource.fs.HadoopFileStoreLayer;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.VerticaJdbcLayer;
import com.vertica.spark.util.cleanup.CleanupUtils;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.listeners.SparkContextWrapper;
import com.vertica.spark.util.schema.SchemaTools;
import com.vertica.spark.util.schema.SchemaToolsV10;
import com.vertica.spark.util.table.TableUtils;
import com.vertica.spark.util.version.VerticaVersion;
import com.vertica.spark.util.version.VerticaVersionUtils$;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.StructType;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.util.Either;

public final class VerticaPipeFactory$
implements VerticaPipeFactoryInterface {
    public static VerticaPipeFactory$ MODULE$;
    private Option<VerticaJdbcLayer> readLayer;
    private Option<VerticaJdbcLayer> writeLayer;

    static {
        new VerticaPipeFactory$();
    }

    private Option<VerticaJdbcLayer> readLayer() {
        return this.readLayer;
    }

    private void readLayer_$eq(Option<VerticaJdbcLayer> x$1) {
        this.readLayer = x$1;
    }

    private Option<VerticaJdbcLayer> writeLayer() {
        return this.writeLayer;
    }

    private void writeLayer_$eq(Option<VerticaJdbcLayer> x$1) {
        this.writeLayer = x$1;
    }

    private Option<VerticaJdbcLayer> checkJdbcLayer(Option<VerticaJdbcLayer> jdbcLayer, JDBCConfig jdbcConfig) {
        Some some;
        Some some2 = jdbcLayer;
        if (some2 instanceof Some) {
            Some some3 = some2;
            VerticaJdbcLayer layer = (VerticaJdbcLayer)some3.value();
            some = layer.isClosed() ? new Some((Object)new VerticaJdbcLayer(jdbcConfig)) : jdbcLayer;
        } else if (None$.MODULE$.equals(some2)) {
            some = new Some((Object)new VerticaJdbcLayer(jdbcConfig));
        } else {
            throw new MatchError(some2);
        }
        return some;
    }

    private void closeJdbcLayer(Option<VerticaJdbcLayer> jdbcLayer) {
        Option<VerticaJdbcLayer> option = jdbcLayer;
        if (option instanceof Some) {
            Some some = (Some)option;
            VerticaJdbcLayer layer = (VerticaJdbcLayer)some.value();
            Either<ConnectorError, BoxedUnit> either = layer.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public VerticaPipeInterface getReadPipe(ReadConfig config) {
        None$ none$;
        None$ none$2;
        ReadConfig readConfig = config;
        if (!(readConfig instanceof DistributedFilesystemReadConfig)) throw new MatchError((Object)readConfig);
        DistributedFilesystemReadConfig distributedFilesystemReadConfig = (DistributedFilesystemReadConfig)readConfig;
        FileStoreConfig fileStoreConfig = distributedFilesystemReadConfig.fileStoreConfig();
        Option<VerticaReadMetadata> option = distributedFilesystemReadConfig.metadata();
        if (option instanceof Some) {
            Some some = (Some)option;
            VerticaReadMetadata metadata = (VerticaReadMetadata)some.value();
            none$2 = distributedFilesystemReadConfig.getRequiredSchema().nonEmpty() ? new Some((Object)distributedFilesystemReadConfig.getRequiredSchema()) : new Some((Object)metadata.schema());
        } else {
            none$2 = None$.MODULE$;
        }
        HadoopFileStoreLayer hadoopFileStoreLayer = new HadoopFileStoreLayer(fileStoreConfig, (Option<StructType>)none$2);
        this.readLayer_$eq(this.checkJdbcLayer(this.readLayer(), distributedFilesystemReadConfig.jdbcConfig()));
        Option option2 = SparkSession$.MODULE$.getActiveSession();
        if (None$.MODULE$.equals(option2)) {
            none$ = None$.MODULE$;
        } else {
            if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
            Some some = (Some)option2;
            SparkSession session = (SparkSession)some.value();
            none$ = new Some((Object)session.sparkContext());
        }
        None$ sparkContext = none$;
        VerticaVersion verticaVersion = VerticaVersionUtils$.MODULE$.getVersion((JdbcLayerInterface)this.readLayer().get());
        SchemaTools schemaTools = verticaVersion.major() == 10 ? new SchemaToolsV10() : new SchemaTools();
        return new VerticaDistributedFilesystemReadPipe(distributedFilesystemReadConfig, hadoopFileStoreLayer, (JdbcLayerInterface)this.readLayer().get(), schemaTools, new CleanupUtils(), new SparkContextWrapper((Option<SparkContext>)sparkContext), VerticaDistributedFilesystemReadPipe$.MODULE$.$lessinit$greater$default$7());
    }

    @Override
    public VerticaPipeInterface getWritePipe(WriteConfig config) {
        WriteConfig writeConfig = config;
        if (!(writeConfig instanceof DistributedFilesystemWriteConfig)) {
            throw new MatchError((Object)writeConfig);
        }
        DistributedFilesystemWriteConfig distributedFilesystemWriteConfig = (DistributedFilesystemWriteConfig)writeConfig;
        this.writeLayer_$eq(this.checkJdbcLayer(this.writeLayer(), distributedFilesystemWriteConfig.jdbcConfig()));
        VerticaVersion verticaVersion = VerticaVersionUtils$.MODULE$.getVersion((JdbcLayerInterface)this.writeLayer().get());
        SchemaTools schemaTools = verticaVersion.major() == 10 ? new SchemaToolsV10() : new SchemaTools();
        VerticaDistributedFilesystemWritePipe verticaDistributedFilesystemWritePipe = new VerticaDistributedFilesystemWritePipe(distributedFilesystemWriteConfig, new HadoopFileStoreLayer(distributedFilesystemWriteConfig.fileStoreConfig(), (Option<StructType>)new Some((Object)distributedFilesystemWriteConfig.schema())), (JdbcLayerInterface)this.writeLayer().get(), schemaTools, new TableUtils(schemaTools, (JdbcLayerInterface)this.writeLayer().get()), VerticaDistributedFilesystemWritePipe$.MODULE$.$lessinit$greater$default$6());
        return verticaDistributedFilesystemWritePipe;
    }

    @Override
    public void closeJdbcLayers() {
        this.closeJdbcLayer(this.readLayer());
        this.closeJdbcLayer(this.writeLayer());
    }

    private VerticaPipeFactory$() {
        MODULE$ = this;
        this.readLayer = None$.MODULE$;
        this.writeLayer = None$.MODULE$;
    }
}

