/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.jdbc;

import buildinfo.BuildInfo$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.AWSArg;
import com.vertica.spark.config.AWSAuth;
import com.vertica.spark.config.AWSOptions;
import com.vertica.spark.config.BasicJdbcAuth;
import com.vertica.spark.config.JDBCConfig;
import com.vertica.spark.config.JDBCTLSConfig;
import com.vertica.spark.config.JdbcAuth;
import com.vertica.spark.config.KerberosAuth;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcLayerIntParam;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcLayerParam;
import com.vertica.spark.datasource.jdbc.JdbcLayerStringParam;
import com.vertica.spark.util.error.ConnectionDownError;
import com.vertica.spark.util.error.ConnectionError;
import com.vertica.spark.util.error.ConnectionSqlError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.DataError;
import com.vertica.spark.util.error.GenericError;
import com.vertica.spark.util.error.MissingNameNodeAddressError;
import com.vertica.spark.util.error.NoSparkSessionFound;
import com.vertica.spark.util.error.ParamsNotSupported;
import com.vertica.spark.util.error.SyntaxError;
import com.vertica.spark.util.general.Utils$;
import com.vertica.spark.util.version.VerticaVersionUtils$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkEnv$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t}b\u0001\u0002\u0011\"\u00011B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\u0006}\u0001!\ta\u0010\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0011\u0019a\u0005\u0001)A\u0005\t\"9Q\n\u0001b\u0001\n\u0013q\u0005BB,\u0001A\u0003%q\nC\u0004Y\u0001\t\u0007I\u0011B-\t\r\u0001\u0004\u0001\u0015!\u0003[\u0011!\t\u0007\u0001#b\u0001\n\u0013\u0011\u0007bBA\u0001\u0001\u0011%\u00111\u0001\u0005\b\u0003'\u0001A\u0011BA\u000b\u0011\u001d\t)\u0004\u0001C\u0005\u0003oAq!a\u0010\u0001\t\u0013\t\t\u0005C\u0004\u0002L\u0001!I!!\u0014\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!9\u0011q\f\u0001\u0005\n\u0005\u0005\u0004bBA<\u0001\u0011\u0005\u0011\u0011\u0010\u0005\n\u0003\u000f\u0003\u0011\u0013!C\u0001\u0003\u0013Cq!a(\u0001\t\u0003\t\t\u000bC\u0005\u0002*\u0002\t\n\u0011\"\u0001\u0002\n\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0006\"CA^\u0001E\u0005I\u0011AAE\u0011\u001d\ti\f\u0001C\u0001\u0003\u007fCq!!1\u0001\t\u0003\ty\fC\u0004\u0002D\u0002!\t!a0\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\"9\u0011q\u001a\u0001\u0005\u0002\u0005E\u0007bBAr\u0001\u0011%\u0011Q\u001d\u0005\b\u0003S\u0004A\u0011BAv\u0011\u001d\ty\u000f\u0001C\u0005\u0003cDqAa\u0004\u0001\t\u0013\u0011\tB\u0001\tWKJ$\u0018nY1KI\n\u001cG*Y=fe*\u0011!eI\u0001\u0005U\u0012\u00147M\u0003\u0002%K\u0005QA-\u0019;bg>,(oY3\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u001d1XM\u001d;jG\u0006T\u0011AK\u0001\u0004G>l7\u0001A\n\u0004\u00015\u001a\u0004C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#AB!osJ+g\r\u0005\u00025k5\t\u0011%\u0003\u00027C\t\u0011\"\n\u001a2d\u0019\u0006LXM]%oi\u0016\u0014h-Y2f\u0003\r\u0019gm\u001a\t\u0003sqj\u0011A\u000f\u0006\u0003w\u0015\naaY8oM&<\u0017BA\u001f;\u0005)QEIQ\"D_:4\u0017nZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0001\u000b\u0005C\u0001\u001b\u0001\u0011\u00159$\u00011\u00019\u0003\u0019awnZ4feV\tA\t\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006a1oY1mC2|wmZ5oO*\u0011\u0011*K\u0001\tif\u0004Xm]1gK&\u00111J\u0012\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005!\u0001O]8q+\u0005y\u0005C\u0001)V\u001b\u0005\t&B\u0001*T\u0003\u0011)H/\u001b7\u000b\u0003Q\u000bAA[1wC&\u0011a+\u0015\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u00029s_B\u0004\u0013a\u00026eE\u000e,&+S\u000b\u00025B\u00111LX\u0007\u00029*\u0011QlU\u0001\u0005Y\u0006tw-\u0003\u0002`9\n11\u000b\u001e:j]\u001e\f\u0001B\u001b3cGV\u0013\u0016\nI\u0001\u000bG>tg.Z2uS>tW#A2\u0011\u0007\u0011<(P\u0004\u0002fi:\u0011a-\u001d\b\u0003OBt!\u0001[8\u000f\u0005%tgB\u00016n\u001b\u0005Y'B\u00017,\u0003\u0019a$o\\8u}%\t!&\u0003\u0002)S%\u0011aeJ\u0005\u0003%\u0016J!A]:\u0002\u000b\u0015\u0014(o\u001c:\u000b\u0005I+\u0013BA;w\u00035)%O]8s\u0011\u0006tG\r\\5oO*\u0011!o]\u0005\u0003qf\u0014qbQ8o]\u0016\u001cGo\u001c:SKN,H\u000e\u001e\u0006\u0003kZ\u0004\"a\u001f@\u000e\u0003qT!!`*\u0002\u0007M\fH.\u0003\u0002\u0000y\nQ1i\u001c8oK\u000e$\u0018n\u001c8\u0002#\r\u0014X-\u0019;f\u00072LWM\u001c;MC\n,G.\u0006\u0002\u0002\u0006A!\u0011qAA\b\u001d\u0011\tI!a\u0003\u0011\u0005)|\u0013bAA\u0007_\u00051\u0001K]3eK\u001aL1aXA\t\u0015\r\tiaL\u0001\u001aQ\u0006tG\r\\3D_:tWm\u0019;j_:,\u0005pY3qi&|g\u000e\u0006\u0003\u0002\u0018\u0005}\u0001\u0003BA\r\u00037i\u0011A^\u0005\u0004\u0003;1(AD\"p]:,7\r^8s\u000bJ\u0014xN\u001d\u0005\b\u0003CY\u0001\u0019AA\u0012\u0003\u0005)\u0007\u0003BA\u0013\u0003_qA!a\n\u0002,9\u0019!.!\u000b\n\u0003AJ1!!\f0\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\r\u00024\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003[y\u0013\u0001E1eIRc5\u000b\u0015:pa\u0016\u0014H/[3t)\t\tI\u0004E\u0002/\u0003wI1!!\u00100\u0005\u0011)f.\u001b;\u0002\u0019\u001d,Go\u0015;bi\u0016lWM\u001c;\u0016\u0005\u0005\r\u0003\u0003\u00023x\u0003\u000b\u00022a_A$\u0013\r\tI\u0005 \u0002\n'R\fG/Z7f]R\fAcZ3u!J,\u0007/\u0019:fIN#\u0018\r^3nK:$H\u0003BA(\u0003/\u0002B\u0001Z<\u0002RA\u001910a\u0015\n\u0007\u0005UCPA\tQe\u0016\u0004\u0018M]3e'R\fG/Z7f]RDa! \bA\u0002\u0005\u0015\u0011a\u00055b]\u0012dWM\u0013#C\u0007\u0016C8-\u001a9uS>tG\u0003BA\f\u0003;Bq!!\t\u0010\u0001\u0004\t\u0019#\u0001\u000bbI\u0012\u0004\u0016M]1ngR{7\u000b^1uK6,g\u000e\u001e\u000b\u0007\u0003s\t\u0019'a\u001a\t\u000f\u0005\u0015\u0004\u00031\u0001\u0002R\u0005I1\u000f^1uK6,g\u000e\u001e\u0005\b\u0003S\u0002\u0002\u0019AA6\u0003\u0019\u0001\u0018M]1ngB1\u0011QEA7\u0003cJA!a\u001c\u00024\t\u00191+Z9\u0011\u0007Q\n\u0019(C\u0002\u0002v\u0005\u0012aB\u00133cG2\u000b\u00170\u001a:QCJ\fW.A\u0003rk\u0016\u0014\u0018\u0010\u0006\u0004\u0002|\u0005\r\u0015Q\u0011\t\u0005I^\fi\bE\u0002|\u0003\u007fJ1!!!}\u0005%\u0011Vm];miN+G\u000fC\u0004\u0002xE\u0001\r!!\u0002\t\u0013\u0005%\u0014\u0003%AA\u0002\u0005-\u0014aD9vKJLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005-%\u0006BA6\u0003\u001b[#!a$\u0011\t\u0005E\u00151T\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00033{\u0013AC1o]>$\u0018\r^5p]&!\u0011QTAJ\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\bKb,7-\u001e;f)\u0019\t\u0019+!*\u0002(B!Am^A\u001d\u0011\u001d\t)g\u0005a\u0001\u0003\u000bA\u0011\"!\u001b\u0014!\u0003\u0005\r!a\u001b\u0002#\u0015DXmY;uK\u0012\"WMZ1vYR$#'A\u0007fq\u0016\u001cW\u000f^3Va\u0012\fG/\u001a\u000b\u0007\u0003_\u000b9,!/\u0011\t\u0011<\u0018\u0011\u0017\t\u0004]\u0005M\u0016bAA[_\t\u0019\u0011J\u001c;\t\u000f\u0005\u0015T\u00031\u0001\u0002\u0006!I\u0011\u0011N\u000b\u0011\u0002\u0003\u0007\u00111N\u0001\u0018Kb,7-\u001e;f+B$\u0017\r^3%I\u00164\u0017-\u001e7uII\nQa\u00197pg\u0016$\"!a)\u0002\r\r|W.\\5u\u0003!\u0011x\u000e\u001c7cC\u000e\\\u0017\u0001C5t\u00072|7/\u001a3\u0015\u0005\u0005%\u0007c\u0001\u0018\u0002L&\u0019\u0011QZ\u0018\u0003\u000f\t{w\u000e\\3b]\u0006\u00012m\u001c8gS\u001e,(/Z*fgNLwN\u001c\u000b\u0005\u0003G\u000b\u0019\u000eC\u0004\u0002Vn\u0001\r!a6\u0002\u001d\u0019LG.Z*u_J,G*Y=feB!\u0011\u0011\\Ap\u001b\t\tYNC\u0002\u0002^\u000e\n!AZ:\n\t\u0005\u0005\u00181\u001c\u0002\u0018\r&dWm\u0015;pe\u0016d\u0015-_3s\u0013:$XM\u001d4bG\u0016\facY8oM&<WO]3B/N\u0003\u0016M]1nKR,'o\u001d\u000b\u0005\u0003G\u000b9\u000fC\u0004\u0002Vr\u0001\r!a6\u00029\r|gNZ5hkJ,7*\u001a:cKJ|7\u000fV8GS2,7\u000f^8sKR!\u00111UAw\u0011\u001d\t).\ba\u0001\u0003/\f\u0001\u0003\\8h\u0011\u0006$wn\u001c9D_:4\u0017nZ:\u0015\t\u0005e\u00121\u001f\u0005\b\u0003kt\u0002\u0019AA|\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0005\u0003s\u0014Y!\u0004\u0002\u0002|*!\u0011Q`A\u0000\u0003\u0011\u0019wN\u001c4\u000b\t\t\u0005!1A\u0001\u0007Q\u0006$wn\u001c9\u000b\t\t\u0015!qA\u0001\u0007CB\f7\r[3\u000b\u0005\t%\u0011aA8sO&!!QBA~\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006iQo]3D_:tWm\u0019;j_:,BAa\u0005\u0003\u001cQA!Q\u0003B\u0017\u0005_\u0011I\u0004\u0005\u0003eo\n]\u0001\u0003\u0002B\r\u00057a\u0001\u0001B\u0004\u0003\u001e}\u0011\rAa\b\u0003\u0003Q\u000bBA!\t\u0003(A\u0019aFa\t\n\u0007\t\u0015rFA\u0004O_RD\u0017N\\4\u0011\u00079\u0012I#C\u0002\u0003,=\u00121!\u00118z\u0011\u0015\tw\u00041\u0001{\u0011\u001d\u0011\td\ba\u0001\u0005g\ta!Y2uS>t\u0007C\u0002\u0018\u00036i\u00149\"C\u0002\u00038=\u0012\u0011BR;oGRLwN\\\u0019\t\u000f\tmr\u00041\u0001\u0003>\u0005\u0001R\r_2faRLwN\\\"bi\u000eDWM\u001d\t\b]\tU\u00121EA\f\u0001")
public class VerticaJdbcLayer
implements JdbcLayerInterface {
    private Either<ConnectorError, Connection> connection;
    private final JDBCConfig cfg;
    private final Logger logger;
    private final Properties prop;
    private final String jdbcURI;
    private volatile boolean bitmap$0;

    private Logger logger() {
        return this.logger;
    }

    private Properties prop() {
        return this.prop;
    }

    private String jdbcURI() {
        return this.jdbcURI;
    }

    private Either<ConnectorError, Connection> connection$lzycompute() {
        VerticaJdbcLayer verticaJdbcLayer = this;
        synchronized (verticaJdbcLayer) {
            if (!this.bitmap$0) {
                this.connection = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> DriverManager.getConnection(this.jdbcURI(), this.prop())).toEither().left().map((Function1 & Serializable & scala.Serializable)e -> this.handleConnectionException((Throwable)e)).flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> {
                    BoxedUnit boxedUnit;
                    c.setClientInfo("APPLICATIONNAME", this.createClientLabel());
                    c.setAutoCommit(false);
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Successfully connected to Vertica.");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return c;
                }, (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleConnectionException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.context("Initial connection was not valid.")));
                this.bitmap$0 = true;
            }
        }
        return this.connection;
    }

    private Either<ConnectorError, Connection> connection() {
        return !this.bitmap$0 ? this.connection$lzycompute() : this.connection;
    }

    private String createClientLabel() {
        String string;
        JdbcAuth jdbcAuth = this.cfg.auth();
        if (jdbcAuth instanceof BasicJdbcAuth) {
            string = "-p";
        } else if (jdbcAuth instanceof KerberosAuth) {
            string = "-k";
        } else {
            throw new MatchError((Object)jdbcAuth);
        }
        String authMethod = string;
        String sparkVersion = SparkSession$.MODULE$.active().sparkContext().version();
        return new StringBuilder(12).append("vspark-vs").append(BuildInfo$.MODULE$.version()).append(authMethod).append("-sp").append(sparkVersion).toString();
    }

    private ConnectorError handleConnectionException(Throwable e) {
        Product product;
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            product = new ConnectionSqlError(sQLException);
        } else if (throwable != null) {
            Throwable throwable2 = throwable;
            product = new ConnectionError(throwable2);
        } else {
            throw new MatchError((Object)throwable);
        }
        return product;
    }

    private void addTLSProperties() {
        JDBCTLSConfig tlsConfig = this.cfg.tlsConfig();
        Utils$.MODULE$.ignore(this.prop().put("TLSmode", tlsConfig.tlsMode().toString()));
        Option<String> option = tlsConfig.keyStorePath();
        if (option instanceof Some) {
            Some some = (Some)option;
            String path = (String)some.value();
            Utils$.MODULE$.ignore(this.prop().put("KeyStorePath", path));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        Option<String> option2 = tlsConfig.keyStorePassword();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String password = (String)some.value();
            Utils$.MODULE$.ignore(this.prop().put("KeyStorePassword", password));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option2);
        }
        Option<String> option3 = tlsConfig.trustStorePath();
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            String path = (String)some.value();
            Utils$.MODULE$.ignore(this.prop().put("TrustStorePath", path));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option3)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option3);
        }
        Option<String> option4 = tlsConfig.trustStorePassword();
        if (option4 instanceof Some) {
            Some some = (Some)option4;
            String password = (String)some.value();
            Utils$.MODULE$.ignore(this.prop().put("TrustStorePassword", password));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option4)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option4);
        }
    }

    private Either<ConnectorError, Statement> getStatement() {
        return this.connection().flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> c.createStatement(), (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.context("getStatement: Error while trying to create statement.")));
    }

    private Either<ConnectorError, PreparedStatement> getPreparedStatement(String sql) {
        return this.connection().flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> c.prepareStatement(sql), (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.context("getPreparedStatement: Error while getting prepared statement.")));
    }

    @Override
    public ConnectorError handleJDBCException(Throwable e) {
        ConnectorError connectorError;
        Throwable throwable = e;
        if (throwable instanceof SQLSyntaxErrorException) {
            SQLSyntaxErrorException sQLSyntaxErrorException = (SQLSyntaxErrorException)throwable;
            connectorError = new SyntaxError(sQLSyntaxErrorException);
        } else if (throwable instanceof SQLDataException) {
            SQLDataException sQLDataException = (SQLDataException)throwable;
            connectorError = new DataError(sQLDataException);
        } else if (throwable != null) {
            connectorError = new GenericError(e).context("Unexpected SQL Error.");
        } else {
            throw new MatchError((Object)throwable);
        }
        return connectorError;
    }

    private void addParamsToStatement(PreparedStatement statement, Seq<JdbcLayerParam> params) {
        ((IterableLike)params.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            VerticaJdbcLayer.$anonfun$addParamsToStatement$1(statement, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Either<ConnectorError, ResultSet> query(String query, Seq<JdbcLayerParam> params) {
        Either either;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(26).append("Attempting to send query: ").append(query).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Left left;
            Either<ConnectorError, PreparedStatement> either = this.getPreparedStatement(query);
            if (either instanceof Right) {
                Right right = (Right)either;
                PreparedStatement stmt = (PreparedStatement)right.value();
                this.addParamsToStatement(stmt, params);
                left = package$.MODULE$.Right().apply((Object)stmt.executeQuery());
            } else if (either instanceof Left) {
                Left left2 = (Left)either;
                ConnectorError err = (ConnectorError)left2.value();
                left = package$.MODULE$.Left().apply((Object)err);
            } else {
                throw new MatchError(either);
            }
            return left;
        });
        if (try_ instanceof Success) {
            Either v;
            Success success = (Success)try_;
            either = v = (Either)success.value();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            either = package$.MODULE$.Left().apply((Object)this.handleJDBCException(e).context("Error when sending query"));
        } else {
            throw new MatchError((Object)try_);
        }
        return either;
    }

    @Override
    public Seq<JdbcLayerParam> query$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> execute(String statement, Seq<JdbcLayerParam> params) {
        Either either;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(33).append("Attempting to execute statement: ").append(statement).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Right right;
            if (params.nonEmpty()) {
                Left left;
                Either<ConnectorError, PreparedStatement> either = this.getPreparedStatement(statement);
                if (either instanceof Right) {
                    Right right2 = (Right)either;
                    PreparedStatement stmt = (PreparedStatement)right2.value();
                    this.addParamsToStatement(stmt, params);
                    stmt.execute();
                    left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                } else if (either instanceof Left) {
                    Left left2 = (Left)either;
                    ConnectorError err = (ConnectorError)left2.value();
                    left = package$.MODULE$.Left().apply((Object)err);
                } else {
                    throw new MatchError(either);
                }
                right = left;
            } else {
                Right right3;
                Either<ConnectorError, Statement> either = this.getStatement();
                if (either instanceof Right) {
                    Right right4 = (Right)either;
                    Statement stmt = (Statement)right4.value();
                    stmt.execute(statement);
                    right3 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                } else if (either instanceof Left) {
                    Left left = (Left)either;
                    ConnectorError err = (ConnectorError)left.value();
                    right3 = package$.MODULE$.Left().apply((Object)err);
                } else {
                    throw new MatchError(either);
                }
                right = right3;
            }
            return right;
        });
        if (try_ instanceof Success) {
            Either v;
            Success success = (Success)try_;
            either = v = (Either)success.value();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            either = package$.MODULE$.Left().apply((Object)this.handleJDBCException(e));
        } else {
            throw new MatchError((Object)try_);
        }
        return either;
    }

    @Override
    public Seq<JdbcLayerParam> execute$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public Either<ConnectorError, Object> executeUpdate(String statement, Seq<JdbcLayerParam> params) {
        Left left;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(33).append("Attempting to execute statement: ").append(statement).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (params.nonEmpty()) {
            left = package$.MODULE$.Left().apply((Object)new ParamsNotSupported("executeUpdate"));
        } else {
            Either either;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.getStatement().map((Function1 & Serializable & scala.Serializable)stmt -> BoxesRunTime.boxToInteger((int)stmt.executeUpdate(statement))));
            if (try_ instanceof Success) {
                Either v;
                Success success = (Success)try_;
                either = v = (Either)success.value();
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                either = package$.MODULE$.Left().apply((Object)this.handleJDBCException(e));
            } else {
                throw new MatchError((Object)try_);
            }
            left = either;
        }
        return left;
    }

    @Override
    public Seq<JdbcLayerParam> executeUpdate$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> close() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Closing connection.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.connection().flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> {
            c.close();
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.context("close: JDBC Error closing the connection.")));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> commit() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Commiting.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.connection().flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> {
            c.commit();
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.context("commit: JDBC Error while commiting.")));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> rollback() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Rolling back.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.connection().flatMap((Function1 & Serializable & scala.Serializable)conn -> this.useConnection((Connection)conn, (Function1 & Serializable & scala.Serializable)c -> {
            c.rollback();
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, ConnectorError>)(Function1 & Serializable & scala.Serializable)e -> this.handleJDBCException((Throwable)e)).left().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.context("rollback: JDBC Error while rolling back.")));
    }

    @Override
    public boolean isClosed() {
        boolean bl;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Checking if connection is closed.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            bl = BoxesRunTime.unboxToBoolean((Object)this.connection().fold((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)VerticaJdbcLayer.$anonfun$isClosed$1(x$7)), (Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToBoolean((boolean)conn.isClosed())));
        }
        catch (Throwable throwable) {
            bl = true;
        }
        return bl;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> configureSession(FileStoreLayerInterface fileStoreLayer) {
        return this.configureKerberosToFilestore(fileStoreLayer).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.configureAWSParameters(fileStoreLayer).map((Function1 & Serializable & scala.Serializable)_ -> {
            VerticaJdbcLayer.$anonfun$configureSession$2(_);
            return BoxedUnit.UNIT;
        }));
    }

    private Either<ConnectorError, BoxedUnit> configureAWSParameters(FileStoreLayerInterface fileStoreLayer) {
        AWSOptions awsOptions = fileStoreLayer.getAWSOptions();
        return package$.MODULE$.Right().apply((Object)VerticaVersionUtils$.MODULE$.getVersion(this)).flatMap((Function1 & Serializable & scala.Serializable)verticaVersion -> {
            Either<ConnectorError, BoxedUnit> either;
            Option<AWSAuth> option = awsOptions.awsAuth();
            if (option instanceof Some) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                Some some = (Some)option;
                AWSAuth awsAuth = (AWSAuth)some.value();
                String sql = new StringBuilder(29).append("ALTER SESSION SET AWSAuth='").append((Object)awsAuth.accessKeyId().arg()).append(":").append((Object)awsAuth.secretAccessKey().arg()).append("'").toString();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Loaded AWS access key ID from {}", new Object[]{awsAuth.accessKeyId().origin()});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Loaded AWS secret access key from {}", new Object[]{awsAuth.secretAccessKey().origin()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                either = this.execute(sql, this.execute$default$2());
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Did not set AWSAuth");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError(option);
            }
            return either.flatMap((Function1 & Serializable & scala.Serializable)_2 -> {
                Either<ConnectorError, BoxedUnit> either;
                Option<AWSArg<String>> option = awsOptions.awsRegion();
                if (option instanceof Some) {
                    BoxedUnit boxedUnit;
                    Some some = (Some)option;
                    AWSArg awsRegion = (AWSArg)some.value();
                    String sql = new StringBuilder(30).append("ALTER SESSION SET AWSRegion='").append(awsRegion.arg()).append("'").toString();
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Setting AWSRegion for session: {}", new Object[]{awsRegion});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    either = this.execute(sql, this.execute$default$2());
                } else if (None$.MODULE$.equals(option)) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Did not set AWSRegion");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                } else {
                    throw new MatchError(option);
                }
                return either.flatMap((Function1 & Serializable & scala.Serializable)_ -> {
                    Either<ConnectorError, BoxedUnit> either;
                    Option<AWSArg<String>> option = awsOptions.awsSessionToken();
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        AWSArg token = (AWSArg)some.value();
                        String sql = new StringBuilder(36).append("ALTER SESSION SET AWSSessionToken='").append(token.arg()).append("'").toString();
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Loaded AWSSessionToken from {}", new Object[]{token.origin()});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        either = this.execute(sql, this.execute$default$2());
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Did not set AWSSessionToken");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    } else {
                        throw new MatchError(option);
                    }
                    return either.flatMap((Function1 & Serializable & scala.Serializable)_2 -> {
                        Either<ConnectorError, BoxedUnit> either;
                        Option<AWSArg<String>> option = awsOptions.awsEndpoint();
                        if (option instanceof Some) {
                            BoxedUnit boxedUnit;
                            Some some = (Some)option;
                            AWSArg endpoint = (AWSArg)some.value();
                            String sql = new StringBuilder(32).append("ALTER SESSION SET AWSEndpoint='").append(endpoint.arg()).append("'").toString();
                            if (this.logger().underlying().isInfoEnabled()) {
                                this.logger().underlying().info("Loaded AWSEndpoint from {}", new Object[]{endpoint.origin()});
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            either = this.execute(sql, this.execute$default$2());
                        } else if (None$.MODULE$.equals(option)) {
                            BoxedUnit boxedUnit;
                            if (this.logger().underlying().isInfoEnabled()) {
                                this.logger().underlying().info("Did not set AWSEndpoint");
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                        } else {
                            throw new MatchError(option);
                        }
                        return either.flatMap((Function1 & Serializable & scala.Serializable)_ -> {
                            Right right;
                            Option<AWSArg<String>> option = awsOptions.enableSSL();
                            if (option instanceof Some) {
                                Either<ConnectorError, BoxedUnit> either;
                                Some some = (Some)option;
                                AWSArg enable = (AWSArg)some.value();
                                if (verticaVersion.major() < 11) {
                                    BoxedUnit boxedUnit;
                                    BoxedUnit boxedUnit2;
                                    if (this.logger().underlying().isWarnEnabled()) {
                                        this.logger().underlying().warn("enable_ssl is only support for Vertica version 11+");
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    }
                                    if (this.logger().underlying().isInfoEnabled()) {
                                        this.logger().underlying().info("Did not set AWSEnableHttps");
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                                } else {
                                    BoxedUnit boxedUnit;
                                    int enableInt = ((String)enable.arg()).equalsIgnoreCase("true") ? 1 : 0;
                                    String sql = new StringBuilder(33).append("ALTER SESSION SET AWSEnableHttps=").append(enableInt).toString();
                                    if (this.logger().underlying().isInfoEnabled()) {
                                        this.logger().underlying().info("Loaded AWSEnableHttps from {}", new Object[]{enable.origin()});
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    either = this.execute(sql, this.execute$default$2());
                                }
                                right = either;
                            } else if (None$.MODULE$.equals(option)) {
                                BoxedUnit boxedUnit;
                                if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("Did not set AWSEnableHttps");
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                            } else {
                                throw new MatchError(option);
                            }
                            return right.flatMap((Function1 & Serializable & scala.Serializable)_2 -> {
                                Either<ConnectorError, BoxedUnit> either;
                                Option<AWSArg<String>> option = awsOptions.enablePathStyle();
                                if (option instanceof Some) {
                                    BoxedUnit boxedUnit;
                                    Some some = (Some)option;
                                    AWSArg enable = (AWSArg)some.value();
                                    int enableInt = ((String)enable.arg()).equalsIgnoreCase("true") ? 0 : 1;
                                    String sql = new StringBuilder(44).append("ALTER SESSION SET S3EnableVirtualAddressing=").append(enableInt).toString();
                                    if (this.logger().underlying().isInfoEnabled()) {
                                        this.logger().underlying().info("Loaded S3EnableVirtualAddressing from {}", new Object[]{enable.origin()});
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    either = this.execute(sql, this.execute$default$2());
                                } else if (None$.MODULE$.equals(option)) {
                                    BoxedUnit boxedUnit;
                                    if (this.logger().underlying().isInfoEnabled()) {
                                        this.logger().underlying().info("Did not set S3EnableVirtualAddressing");
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                                } else {
                                    throw new MatchError(option);
                                }
                                return either.map((Function1 & Serializable & scala.Serializable)_ -> {
                                    VerticaJdbcLayer.$anonfun$configureAWSParameters$7(_);
                                    return BoxedUnit.UNIT;
                                });
                            });
                        });
                    });
                });
            });
        });
    }

    /*
     * Unable to fully structure code
     */
    private Either<ConnectorError, BoxedUnit> configureKerberosToFilestore(FileStoreLayerInterface fileStoreLayer) {
        block13: {
            block12: {
                var4_2 = SparkSession$.MODULE$.getActiveSession();
                if (!(var4_2 instanceof Some)) break block12;
                var5_3 = (Some)var4_2;
                session = (SparkSession)var5_3.value();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Hadoop impersonation: found session");
                    v0 = BoxedUnit.UNIT;
                } else {
                    v0 = BoxedUnit.UNIT;
                }
                hadoopConf = session.sparkContext().hadoopConfiguration();
                authMethod = Option$.MODULE$.apply((Object)hadoopConf.get("hadoop.security.authentication"));
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logHadoopConfigs(hadoopConf);
                    v1 = BoxedUnit.UNIT;
                } else {
                    v1 = BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(35).append("Hadoop impersonation: auth method: ").append(authMethod).toString());
                    v2 = BoxedUnit.UNIT;
                } else {
                    v2 = BoxedUnit.UNIT;
                }
                var9_7 = authMethod;
                if (!(var9_7 instanceof Some)) ** GOTO lbl-1000
                var10_8 = (Some)var9_7;
                v3 = authMethod = (String)var10_8.value();
                var12_10 = "kerberos";
                if (!(v3 != null ? v3.equals(var12_10) == false : var12_10 != null)) {
                    var3_11 = Option$.MODULE$.apply((Object)hadoopConf.get("dfs.namenode.https-address")).orElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$configureKerberosToFilestore$1(org.apache.hadoop.conf.Configuration ), ()Lscala/Option;)((Configuration)hadoopConf)).orElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$configureKerberosToFilestore$2(org.apache.hadoop.conf.Configuration ), ()Lscala/Option;)((Configuration)hadoopConf)).toRight((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$configureKerberosToFilestore$3(), ()Lcom/vertica/spark/util/error/MissingNameNodeAddressError;)()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$configureKerberosToFilestore$4(com.vertica.spark.datasource.jdbc.VerticaJdbcLayer java.lang.String ), (Ljava/lang/String;)Lscala/Tuple2;)((VerticaJdbcLayer)this)).flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$configureKerberosToFilestore$5(com.vertica.spark.datasource.jdbc.VerticaJdbcLayer com.vertica.spark.datasource.fs.FileStoreLayerInterface org.apache.hadoop.conf.Configuration scala.Tuple2 ), (Lscala/Tuple2;)Lscala/util/Either;)((VerticaJdbcLayer)this, (FileStoreLayerInterface)fileStoreLayer, (Configuration)hadoopConf));
                } else lbl-1000:
                // 2 sources

                {
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Kerberos is not enabled in the hadoop config.");
                        v4 = BoxedUnit.UNIT;
                    } else {
                        v4 = BoxedUnit.UNIT;
                    }
                    var3_11 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                }
                var2_12 = var3_11;
                break block13;
            }
            if (None$.MODULE$.equals(var4_2)) {
                var2_12 = package$.MODULE$.Left().apply((Object)new NoSparkSessionFound());
            } else {
                throw new MatchError((Object)var4_2);
            }
        }
        return var2_12;
    }

    private void logHadoopConfigs(Configuration hadoopConf) {
        BoxedUnit boxedUnit;
        String configs = ((TraversableOnce)((List)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)hadoopConf).asScala()).toList().sortBy((Function1 & Serializable & scala.Serializable)x$11 -> (String)x$11.getKey(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable & scala.Serializable)entry -> new StringBuilder(1).append(entry.getKey()).append(":").append(entry.getValue()).toString(), List$.MODULE$.canBuildFrom())).mkString("\n");
        String hostname = InetAddress.getLocalHost().getHostName();
        String executorId = SparkEnv$.MODULE$.get().executorId();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Hadoop configurations for host {}, executorId {}:\n{}", new Object[]{hostname, executorId, configs});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private <T> Either<ConnectorError, T> useConnection(Connection connection, Function1<Connection, T> action, Function1<Throwable, ConnectorError> exceptionCatcher) {
        Left left;
        block3: {
            try {
                if (connection.isValid(0)) {
                    left = package$.MODULE$.Right().apply(action.apply((Object)connection));
                    break block3;
                }
                left = package$.MODULE$.Left().apply((Object)new ConnectionDownError());
            }
            catch (Throwable e) {
                left = package$.MODULE$.Left().apply(exceptionCatcher.apply((Object)e));
            }
        }
        return left;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$addParamsToStatement$1(PreparedStatement statement$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        JdbcLayerParam param = (JdbcLayerParam)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        int i = idx + 1;
        JdbcLayerParam jdbcLayerParam = param;
        if (jdbcLayerParam instanceof JdbcLayerStringParam) {
            JdbcLayerStringParam jdbcLayerStringParam = (JdbcLayerStringParam)jdbcLayerParam;
            statement$1.setString(i, jdbcLayerStringParam.value());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!(jdbcLayerParam instanceof JdbcLayerIntParam)) throw new MatchError((Object)jdbcLayerParam);
            JdbcLayerIntParam jdbcLayerIntParam = (JdbcLayerIntParam)jdbcLayerParam;
            statement$1.setInt(i, jdbcLayerIntParam.value());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$isClosed$1(ConnectorError x$7) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$configureSession$2(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$configureAWSParameters$7(BoxedUnit _) {
    }

    public static final /* synthetic */ Option $anonfun$configureKerberosToFilestore$1(Configuration hadoopConf$1) {
        return Option$.MODULE$.apply((Object)hadoopConf$1.get("dfs.namenode.http-address"));
    }

    public static final /* synthetic */ Option $anonfun$configureKerberosToFilestore$2(Configuration hadoopConf$1) {
        return Option$.MODULE$.apply((Object)hadoopConf$1.get("dfs.nameservices"));
    }

    public static final /* synthetic */ MissingNameNodeAddressError $anonfun$configureKerberosToFilestore$3() {
        return new MissingNameNodeAddressError();
    }

    public static final /* synthetic */ Tuple2 $anonfun$configureKerberosToFilestore$4(VerticaJdbcLayer $this, String nameNodeAddressOrNameservice) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(56).append("Hadoop impersonation: name node address or nameservice: ").append(nameNodeAddressOrNameservice).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit x$8 = boxedUnit;
        return new Tuple2((Object)nameNodeAddressOrNameservice, (Object)x$8);
    }

    public static final /* synthetic */ void $anonfun$configureKerberosToFilestore$8(BoxedUnit _) {
    }

    public static final /* synthetic */ Either $anonfun$configureKerberosToFilestore$5(VerticaJdbcLayer $this, FileStoreLayerInterface fileStoreLayer$2, Configuration hadoopConf$1, Tuple2 x$10) {
        Tuple2 tuple2 = x$10;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String nameNodeAddressOrNameservice = (String)tuple2._1();
        Either either = fileStoreLayer$2.getImpersonationToken($this.cfg.auth().user()).map((Function1 & Serializable & scala.Serializable)encodedDelegationToken -> {
            String string;
            Option option = Option$.MODULE$.apply((Object)hadoopConf$1.get("dfs.nameservices"));
            if (option instanceof Some) {
                Some some = (Some)option;
                String nameservice = (String)some.value();
                string = new StringBuilder(113).append("\n                  {\n                     \"nameservice\": \"").append(nameservice).append("\",\n                     \"token\": \"").append((String)encodedDelegationToken).append("\"\n                  }").toString();
            } else if (None$.MODULE$.equals(option)) {
                string = new StringBuilder(111).append("\n                  {\n                     \"authority\": \"").append(nameNodeAddressOrNameservice).append("\",\n                     \"token\": \"").append((String)encodedDelegationToken).append("\"\n                  }").toString();
            } else {
                throw new MatchError((Object)option);
            }
            String jsonString = string;
            String sql = new StringBuilder(48).append("ALTER SESSION SET HadoopImpersonationConfig='[").append(jsonString).append("]'").toString();
            return new Tuple3(encodedDelegationToken, (Object)jsonString, (Object)sql);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
            Tuple3 tuple3 = x$9;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String sql = (String)tuple3._3();
            Either either = $this.execute(sql, $this.execute$default$2()).map((Function1 & Serializable & scala.Serializable)_ -> {
                VerticaJdbcLayer.$anonfun$configureKerberosToFilestore$8(_);
                return BoxedUnit.UNIT;
            });
            return either;
        });
        return either;
    }

    public VerticaJdbcLayer(JDBCConfig cfg) {
        BoxedUnit boxedUnit;
        this.cfg = cfg;
        this.logger = LogProvider$.MODULE$.getLogger(VerticaJdbcLayer.class);
        this.prop = new Properties();
        JdbcAuth jdbcAuth = cfg.auth();
        if (jdbcAuth instanceof BasicJdbcAuth) {
            BasicJdbcAuth basicJdbcAuth = (BasicJdbcAuth)jdbcAuth;
            String username = basicJdbcAuth.username();
            String password = basicJdbcAuth.password();
            Utils$.MODULE$.ignore(this.prop().put("user", username));
            Utils$.MODULE$.ignore(this.prop().put("password", password));
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (jdbcAuth instanceof KerberosAuth) {
            KerberosAuth kerberosAuth = (KerberosAuth)jdbcAuth;
            String username = kerberosAuth.username();
            String kerberosServiceName = kerberosAuth.kerberosServiceName();
            String kerberosHostname = kerberosAuth.kerberosHostname();
            String jaasConfigName = kerberosAuth.jaasConfigName();
            Utils$.MODULE$.ignore(this.prop().put("user", username));
            Utils$.MODULE$.ignore(this.prop().put("KerberosServiceName", kerberosServiceName));
            Utils$.MODULE$.ignore(this.prop().put("KerberosHostname", kerberosHostname));
            Utils$.MODULE$.ignore(this.prop().put("JAASConfigName", jaasConfigName));
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)jdbcAuth);
        }
        this.addTLSProperties();
        if (cfg.backupServerNodes().isDefined()) {
            Utils$.MODULE$.ignore(this.prop().put("BackupServerNode", cfg.backupServerNodes().get()));
        }
        Class.forName("com.vertica.jdbc.Driver");
        this.jdbcURI = new StringBuilder(17).append("jdbc:vertica://").append(cfg.host()).append(":").append(cfg.port()).append("/").append(cfg.db()).toString();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(32).append("Connecting to Vertica with URI: ").append(this.jdbcURI()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }
}

