/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.schema;

import cats.Applicative;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.config.TableQuery;
import com.vertica.spark.config.TableSource;
import com.vertica.spark.config.ValidColumnList;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcUtils$;
import com.vertica.spark.util.complex.ComplexTypeUtils;
import com.vertica.spark.util.error.ArrayElementConversionError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.DatabaseReadError;
import com.vertica.spark.util.error.EmptySchemaError;
import com.vertica.spark.util.error.ErrorList;
import com.vertica.spark.util.error.InvalidMapSchemaError;
import com.vertica.spark.util.error.InvalidTableSchemaComplexType;
import com.vertica.spark.util.error.JdbcSchemaError;
import com.vertica.spark.util.error.MapDataTypeConversionError;
import com.vertica.spark.util.error.MissingElementTypeError;
import com.vertica.spark.util.error.MissingSparkPrimitivesConversionError;
import com.vertica.spark.util.error.MissingSqlConversionError;
import com.vertica.spark.util.error.SchemaConversionError;
import com.vertica.spark.util.error.SchemaError;
import com.vertica.spark.util.error.StructFieldsError;
import com.vertica.spark.util.error.TableNotEnoughRowsError;
import com.vertica.spark.util.error.UnknownColumnTypesError;
import com.vertica.spark.util.error.VerticaComplexTypeNotFound;
import com.vertica.spark.util.error.VerticaNativeTypeNotFound;
import com.vertica.spark.util.schema.ColumnDef;
import com.vertica.spark.util.schema.ColumnDef$;
import com.vertica.spark.util.schema.MetadataKey$;
import com.vertica.spark.util.schema.SchemaTools$;
import com.vertica.spark.util.schema.SchemaTools$ColumnInfoQueryData$;
import com.vertica.spark.util.schema.SchemaToolsInterface;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\u0011}s!\u0002(P\u0011\u0003Qf!\u0002/P\u0011\u0003i\u0006\"\u00023\u0002\t\u0003)\u0007b\u00024\u0002\u0005\u0004%\ta\u001a\u0005\u0007W\u0006\u0001\u000b\u0011\u00025\t\u000f1\f!\u0019!C\u0001O\"1Q.\u0001Q\u0001\n!DqA\\\u0001C\u0002\u0013\u0005q\r\u0003\u0004p\u0003\u0001\u0006I\u0001\u001b\u0005\ba\u0006\u0011\r\u0011\"\u0001h\u0011\u0019\t\u0018\u0001)A\u0005Q\u001a!Al\u0014\u0001s\u0011\u0015!7\u0002\"\u0001w\u0011\u001dA8B1A\u0005\neDq!!\u0002\fA\u0003%!\u0010C\u0005\u0002\b-\u0011\r\u0011\"\u0003\u0002\n!A\u00111D\u0006!\u0002\u0013\tY\u0001C\u0005\u0002\u001e-\u0011\r\u0011\"\u0003\u0002\n!A\u0011qD\u0006!\u0002\u0013\tY\u0001C\u0005\u0002\"-\u0011\r\u0011\"\u0003\u0002$!A\u00111F\u0006!\u0002\u0013\t)\u0003C\u0005\u0002.-\u0011\r\u0011\"\u0003\u00020!A\u0011QH\u0006!\u0002\u0013\t\t\u0004C\u0004\u0002@-!I!!\u0011\t\u000f\u0005m3\u0002\"\u0003\u0002^!9\u0011QY\u0006\u0005\n\u0005\u001d\u0007bBAk\u0017\u0011E\u0011q\u001b\u0005\b\u0003W\\A\u0011AAw\r\u0019\u0011Yd\u0003!\u0003>!Q!1\n\u000f\u0003\u0016\u0004%\tA!\u0014\t\u0015\t=CD!E!\u0002\u0013\t\u0019\u0005\u0003\u0006\u0003Rq\u0011)\u001a!C\u0001\u0005\u001bB!Ba\u0015\u001d\u0005#\u0005\u000b\u0011BA\"\u0011)\u0011)\u0006\bBK\u0002\u0013\u0005!Q\n\u0005\u000b\u0005/b\"\u0011#Q\u0001\n\u0005\r\u0003B\u00023\u001d\t\u0003\u0011I\u0006C\u0005\u0003fq\t\t\u0011\"\u0001\u0003h!I!q\u000e\u000f\u0012\u0002\u0013\u0005!\u0011\u000f\u0005\n\u0005\u000fc\u0012\u0013!C\u0001\u0005cB\u0011B!#\u001d#\u0003%\tA!\u001d\t\u0013\t-E$!A\u0005B\u0005%\u0001\"\u0003BG9\u0005\u0005I\u0011AA\u0012\u0011%\u0011y\tHA\u0001\n\u0003\u0011\t\nC\u0005\u0003\u001er\t\t\u0011\"\u0011\u0003 \"I!Q\u0016\u000f\u0002\u0002\u0013\u0005!q\u0016\u0005\n\u0005gc\u0012\u0011!C!\u0005kC\u0011Ba.\u001d\u0003\u0003%\tE!/\t\u0013\tmF$!A\u0005B\tuv!\u0003Ba\u0017\u0005\u0005\t\u0012\u0001Bb\r%\u0011YdCA\u0001\u0012\u0003\u0011)\r\u0003\u0004ec\u0011\u0005!1\u001b\u0005\n\u0005o\u000b\u0014\u0011!C#\u0005sC\u0011B!62\u0003\u0003%\tIa6\t\u0013\t}\u0017'!A\u0005\u0002\n\u0005\bb\u0002Bz\u0017\u0011E!Q\u001f\u0005\b\u0005s\\A\u0011\u0001B~\u0011\u001d\u0019Ia\u0003C\u0005\u0007\u0017Aqa!\u0007\f\t\u0013\u0019Y\u0002C\u0004\u0004(-!Ia!\u000b\t\u000f\rU2\u0002\"\u0003\u00048!911I\u0006\u0005\n\r\u0015\u0003bBB'\u0017\u0011%1q\n\u0005\b\u00073ZA\u0011CB.\u0011\u001d\u00199g\u0003C!\u0007SBqaa\"\f\t\u0013\u0019I\tC\u0004\u0004\u0016.!Iaa&\t\u000f\r56\u0002\"\u0003\u00040\"911X\u0006\u0005\n\ru\u0006bBBb\u0017\u0011\u00051Q\u0019\u0005\b\u0007+\\A\u0011ABl\u0011\u001d\u0019\to\u0003C\u0001\u0007GDqaa;\f\t\u0003\u0019i\u000fC\u0004\u0004\u0000.!\t\u0001\"\u0001\t\u000f\u001151\u0002\"\u0003\u0005\u0010!9AqD\u0006\u0005\n\u0011\u0005\u0002b\u0002C\u0019\u0017\u0011\u0005A1\u0007\u0005\b\t\u007fYA\u0011\u0001C!\u0011\u001d!ye\u0003C\u0001\t#\n1bU2iK6\fGk\\8mg*\u0011\u0001+U\u0001\u0007g\u000eDW-\\1\u000b\u0005I\u001b\u0016\u0001B;uS2T!\u0001V+\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y;\u0016a\u0002<feRL7-\u0019\u0006\u00021\u0006\u00191m\\7\u0004\u0001A\u00111,A\u0007\u0002\u001f\nY1k\u00195f[\u0006$vn\u001c7t'\t\ta\f\u0005\u0002`E6\t\u0001MC\u0001b\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0007M\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u000bADV#S)&\u001b\u0015i\u0018(B)&3ViX!S%\u0006KvLQ!T\u000b~KE)F\u0001i!\ty\u0016.\u0003\u0002kA\n!Aj\u001c8h\u0003u1VI\u0015+J\u0007\u0006{f*\u0011+J-\u0016{\u0016I\u0015*B3~\u0013\u0015iU#`\u0013\u0012\u0003\u0013a\u0005,F%RK5)Q0T\u000bR{&)Q*F?&#\u0015\u0001\u0006,F%RK5)Q0T\u000bR{&)Q*F?&#\u0005%A\rW\u000bJ#\u0016jQ!`!JKU*\u0013+J-\u0016\u001bv,T!Y?&#\u0015A\u0007,F%RK5)Q0Q%&k\u0015\nV%W\u000bN{V*\u0011-`\u0013\u0012\u0003\u0013A\u0005,F%RK5)Q0T\u000bR{V*\u0011-`\u0013\u0012\u000b1CV#S)&\u001b\u0015iX*F)~k\u0015\tW0J\t\u0002\u001a2a\u00030t!\tYF/\u0003\u0002v\u001f\n!2k\u00195f[\u0006$vn\u001c7t\u0013:$XM\u001d4bG\u0016$\u0012a\u001e\t\u00037.\ta\u0001\\8hO\u0016\u0014X#\u0001>\u0011\u0007m\f\t!D\u0001}\u0015\tih0\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002\u0000/\u0006AA/\u001f9fg\u00064W-C\u0002\u0002\u0004q\u0014a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\bk:\\gn\\<o+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005]QBAA\b\u0015\u0011\t\t\"a\u0005\u0002\t1\fgn\u001a\u0006\u0003\u0003+\tAA[1wC&!\u0011\u0011DA\b\u0005\u0019\u0019FO]5oO\u0006AQO\\6o_^t\u0007%A\u0005nCbdWM\\4uQ\u0006QQ.\u0019=mK:<G\u000f\u001b\u0011\u0002\u00151|gn\u001a7f]\u001e$\b.\u0006\u0002\u0002&A\u0019q,a\n\n\u0007\u0005%\u0002MA\u0002J]R\f1\u0002\\8oO2,gn\u001a;iA\u0005\u00012m\\7qY\u0016DH+\u001f9f+RLGn]\u000b\u0003\u0003c\u0001B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004\u0003o\t\u0016aB2p[BdW\r_\u0005\u0005\u0003w\t)D\u0001\tD_6\u0004H.\u001a=UsB,W\u000b^5mg\u0006\t2m\\7qY\u0016DH+\u001f9f+RLGn\u001d\u0011\u0002\u001f\u0005$G\rR8vE2,\u0017+^8uKN$B!a\u0011\u0002XA!\u0011QIA*\u001d\u0011\t9%a\u0014\u0011\u0007\u0005%\u0003-\u0004\u0002\u0002L)\u0019\u0011QJ-\u0002\rq\u0012xn\u001c;?\u0013\r\t\t\u0006Y\u0001\u0007!J,G-\u001a4\n\t\u0005e\u0011Q\u000b\u0006\u0004\u0003#\u0002\u0007bBA-/\u0001\u0007\u00111I\u0001\u0004gR\u0014\u0018aD4fi\u000e\u000bG/\u00197zgR$\u0016\u0010]3\u0015\u001d\u0005}\u0013qRAJ\u0003/\u000bY*!*\u0002*BA\u0011\u0011MA3\u0003S\n)(\u0004\u0002\u0002d)\u0011!\u000bY\u0005\u0005\u0003O\n\u0019G\u0001\u0004FSRDWM\u001d\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011qN)\u0002\u000b\u0015\u0014(o\u001c:\n\t\u0005M\u0014Q\u000e\u0002\f'\u000eDW-\\1FeJ|'\u000f\u0005\u0003\u0002x\u0005-UBAA=\u0015\u0011\tY(! \u0002\u000bQL\b/Z:\u000b\t\u0005}\u0014\u0011Q\u0001\u0004gFd'b\u0001+\u0002\u0004*!\u0011QQAD\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011R\u0001\u0004_J<\u0017\u0002BAG\u0003s\u0012\u0001\u0002R1uCRK\b/\u001a\u0005\b\u0003#C\u0002\u0019AA\u0013\u0003\u001d\u0019\u0018\u000f\u001c+za\u0016Dq!!&\u0019\u0001\u0004\t)#A\u0005qe\u0016\u001c\u0017n]5p]\"9\u0011\u0011\u0014\rA\u0002\u0005\u0015\u0012!B:dC2,\u0007bBAO1\u0001\u0007\u0011qT\u0001\u0007g&<g.\u001a3\u0011\u0007}\u000b\t+C\u0002\u0002$\u0002\u0014qAQ8pY\u0016\fg\u000eC\u0004\u0002(b\u0001\r!a\u0011\u0002\u0011QL\b/\u001a8b[\u0016Dq!a+\u0019\u0001\u0004\ti+A\u0005dQ&dG\rR3ggB1\u0011qVA]\u0003\u007fsA!!-\u00026:!\u0011\u0011JAZ\u0013\u0005\t\u0017bAA\\A\u00069\u0001/Y2lC\u001e,\u0017\u0002BA^\u0003{\u0013A\u0001T5ti*\u0019\u0011q\u00171\u0011\u0007m\u000b\t-C\u0002\u0002D>\u0013\u0011bQ8mk6tG)\u001a4\u0002\u0019\u001d,G/\u0011:sCf$\u0016\u0010]3\u0015\t\u0005%\u0017\u0011\u001b\t\t\u0003C\n)'!\u001b\u0002LB!\u0011qOAg\u0013\u0011\ty-!\u001f\u0003\u0013\u0005\u0013(/Y=UsB,\u0007bBAj3\u0001\u0007\u0011QV\u0001\u000bK2,W.\u001a8u\t\u00164\u0017aG4fi\u000e\u000bG/\u00197zgR$\u0016\u0010]3Ge>l'\n\u001a2d)f\u0004X\r\u0006\u0007\u0002Z\u0006\u0005\u00181]As\u0003O\fI\u000f\u0005\u0005\u0002b\u0005\u0015\u00141\\A;!\u0011\tY'!8\n\t\u0005}\u0017Q\u000e\u0002\u001a\u001b&\u001c8/\u001b8h'Fd7i\u001c8wKJ\u001c\u0018n\u001c8FeJ|'\u000fC\u0004\u0002\u0012j\u0001\r!!\n\t\u000f\u0005U%\u00041\u0001\u0002&!9\u0011\u0011\u0014\u000eA\u0002\u0005\u0015\u0002bBAO5\u0001\u0007\u0011q\u0014\u0005\b\u0003OS\u0002\u0019AA\"\u0003)\u0011X-\u00193TG\",W.\u0019\u000b\u0007\u0003_\u00149Ba\u000b\u0011\r\u0005E(1\u0002B\t\u001d\u0011\t\u0019Pa\u0002\u000f\t\u0005U(Q\u0001\b\u0005\u0003o\u0014\u0019A\u0004\u0003\u0002z\n\u0005a\u0002BA~\u0003\u007ftA!!\u0013\u0002~&\t\u0001,\u0003\u0002W/&\u0011A+V\u0005\u0003%NK1!a\u001cR\u0013\u0011\u0011I!!\u001c\u0002\u001b\u0015\u0013(o\u001c:IC:$G.\u001b8h\u0013\u0011\u0011iAa\u0004\u0003\u001f\r{gN\\3di>\u0014(+Z:vYRTAA!\u0003\u0002nA!\u0011q\u000fB\n\u0013\u0011\u0011)\"!\u001f\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0003\u001am\u0001\rAa\u0007\u0002\u0013)$'m\u0019'bs\u0016\u0014\b\u0003\u0002B\u000f\u0005Oi!Aa\b\u000b\t\t\u0005\"1E\u0001\u0005U\u0012\u00147MC\u0002\u0003&M\u000b!\u0002Z1uCN|WO]2f\u0013\u0011\u0011ICa\b\u0003%)#'m\u0019'bs\u0016\u0014\u0018J\u001c;fe\u001a\f7-\u001a\u0005\b\u0005[Y\u0002\u0019\u0001B\u0018\u0003-!\u0018M\u00197f'>,(oY3\u0011\t\tE\"qG\u0007\u0003\u0005gQ1A!\u000eT\u0003\u0019\u0019wN\u001c4jO&!!\u0011\bB\u001a\u0005-!\u0016M\u00197f'>,(oY3\u0003'\r{G.^7o\u0013:4w.U;fef$\u0015\r^1\u0014\rqq&q\bB#!\ry&\u0011I\u0005\u0004\u0005\u0007\u0002'a\u0002)s_\u0012,8\r\u001e\t\u0004?\n\u001d\u0013b\u0001B%A\na1+\u001a:jC2L'0\u00192mK\u0006IA/\u00192mK:\u000bW.Z\u000b\u0003\u0003\u0007\n!\u0002^1cY\u0016t\u0015-\\3!\u0003!!'mU2iK6\f\u0017!\u00033c'\u000eDW-\\1!\u0003))W\u000e\u001d;z#V,'/_\u0001\fK6\u0004H/_)vKJL\b\u0005\u0006\u0005\u0003\\\t}#\u0011\rB2!\r\u0011i\u0006H\u0007\u0002\u0017!9!1J\u0012A\u0002\u0005\r\u0003b\u0002B)G\u0001\u0007\u00111\t\u0005\b\u0005+\u001a\u0003\u0019AA\"\u0003\u0011\u0019w\u000e]=\u0015\u0011\tm#\u0011\u000eB6\u0005[B\u0011Ba\u0013%!\u0003\u0005\r!a\u0011\t\u0013\tEC\u0005%AA\u0002\u0005\r\u0003\"\u0003B+IA\u0005\t\u0019AA\"\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u001d+\t\u0005\r#QO\u0016\u0003\u0005o\u0002BA!\u001f\u0003\u00046\u0011!1\u0010\u0006\u0005\u0005{\u0012y(A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u00111\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0006\nm$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0013BM!\ry&QS\u0005\u0004\u0005/\u0003'aA!os\"I!1\u0014\u0016\u0002\u0002\u0003\u0007\u0011QE\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0005\u0006C\u0002BR\u0005S\u0013\u0019*\u0004\u0002\u0003&*\u0019!q\u00151\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003,\n\u0015&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a(\u00032\"I!1\u0014\u0017\u0002\u0002\u0003\u0007!1S\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QE\u0001\ti>\u001cFO]5oOR\u0011\u00111B\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005}%q\u0018\u0005\n\u00057{\u0013\u0011!a\u0001\u0005'\u000b1cQ8mk6t\u0017J\u001c4p#V,'/\u001f#bi\u0006\u00042A!\u00182'\u0015\t$q\u0019B#!1\u0011IMa4\u0002D\u0005\r\u00131\tB.\u001b\t\u0011YMC\u0002\u0003N\u0002\fqA];oi&lW-\u0003\u0003\u0003R\n-'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogQ\u0011!1Y\u0001\u0006CB\u0004H.\u001f\u000b\t\u00057\u0012INa7\u0003^\"9!1\n\u001bA\u0002\u0005\r\u0003b\u0002B)i\u0001\u0007\u00111\t\u0005\b\u0005+\"\u0004\u0019AA\"\u0003\u001d)h.\u00199qYf$BAa9\u0003pB)qL!:\u0003j&\u0019!q\u001d1\u0003\r=\u0003H/[8o!%y&1^A\"\u0003\u0007\n\u0019%C\u0002\u0003n\u0002\u0014a\u0001V;qY\u0016\u001c\u0004\"\u0003Byk\u0005\u0005\t\u0019\u0001B.\u0003\rAH\u0005M\u0001\u0017O\u0016$8i\u001c7v[:LeNZ8Rk\u0016\u0014\u0018\u0010R1uCR!!1\fB|\u0011\u001d\u0011iC\u000ea\u0001\u0005_\tQbZ3u\u0007>dW/\u001c8J]\u001a|GC\u0002B\u007f\u0007\u000b\u00199\u0001\u0005\u0004\u0002r\n-!q \t\u0007\u0003_\u001b\t!a0\n\t\r\r\u0011Q\u0018\u0002\u0004'\u0016\f\bb\u0002B\ro\u0001\u0007!1\u0004\u0005\b\u0005[9\u0004\u0019\u0001B\u0018\u0003M\u0019\u0007.Z2l\r>\u00148i\\7qY\u0016DH+\u001f9f))\u0019iaa\u0004\u0004\u0014\rU1q\u0003\t\u0007\u0003c\u0014Y!a0\t\u000f\rE\u0001\b1\u0001\u0002@\u000611m\u001c7EK\u001aDqAa\u00139\u0001\u0004\t\u0019\u0005C\u0004\u0003Ra\u0002\r!a\u0011\t\u000f\te\u0001\b1\u0001\u0003\u001c\u0005q\u0011/^3ss\u000e{G.^7o\t\u00164GCCB\u0007\u0007;\u0019\tca\t\u0004&!91qD\u001dA\u0002\u0005}\u0016!E2p[BdW\r\u001f+za\u0016\u001cu\u000e\u001c#fM\"9!1J\u001dA\u0002\u0005\r\u0003b\u0002B)s\u0001\u0007\u00111\t\u0005\b\u00053I\u0004\u0019\u0001B\u000e\u0003Ii\u0017m[3BeJ\f\u0017pQ8mk6tG)\u001a4\u0015\u0011\r511FB\u0018\u0007gAqa!\f;\u0001\u0004\ty,A\u0006beJ\f\u0017pQ8m\t\u00164\u0007BBB\u0019u\u0001\u0007\u0001.A\u0007wKJ$\u0018nY1UsB,\u0017\n\u001a\u0005\b\u00053Q\u0004\u0019\u0001B\u000e\u0003I1\u0017\u000e\u001c7BeJ\f\u0017pQ8mk6tG)\u001a4\u0015\u0011\r51\u0011HB\u001f\u0007\u007fAqaa\u000f<\u0001\u0004\ty,A\u0006te\u000e\f%O]1z\t\u00164\u0007bBAjw\u0001\u00071Q\u0002\u0005\b\u0007\u0003Z\u0004\u0019AAP\u00031I7OV3si&\u001c\u0017mU3u\u0003a9W\r\u001e(fgR,G-\u0011:sCf,E.Z7f]R$UM\u001a\u000b\u0007\u0007\u001b\u00199ea\u0013\t\r\r%C\b1\u0001i\u0003-1XM\u001d;jG\u0006$\u0016\u0010]3\t\u000f\teA\b1\u0001\u0003\u001c\u0005A\u0012/^3ssZ+'\u000f^5dCB\u0013\u0018.\\5uSZ,G)\u001a4\u0015\u0011\r51\u0011KB*\u0007/Baa!\u0013>\u0001\u0004A\u0007bBB+{\u0001\u0007\u0011QE\u0001\u0006I\u0016\u0004H\u000f\u001b\u0005\b\u00053i\u0004\u0019\u0001B\u000e\u0003Mi\u0017m[3BeJ\f\u00170\u00127f[\u0016tG\u000fR3g)!\tyl!\u0018\u0004b\r\u0015\u0004bBB0}\u0001\u0007\u0011QE\u0001\tU\u0012\u00147\rV=qK\"911\r A\u0002\u0005\r\u0013\u0001\u0003;za\u0016t\u0015-\\3\t\u000f\rUc\b1\u0001\u0002&\u0005Yr-\u001a;WKJ$\u0018nY1UsB,gI]8n'B\f'o\u001b+za\u0016$\"ba\u001b\u0004r\rU4\u0011PB?!\u0019\t\tp!\u001c\u0002D%!1q\u000eB\b\u00051\u00196\r[3nCJ+7/\u001e7u\u0011\u001d\u0019\u0019h\u0010a\u0001\u0003k\n\u0011b\u001d9be.$\u0016\u0010]3\t\r\r]t\b1\u0001i\u0003\u0019\u0019HO\u001d7f]\"111P A\u0002!\f1\"\u0019:sCfdUM\\4uQ\"91qP A\u0002\r\u0005\u0015\u0001C7fi\u0006$\u0017\r^1\u0011\t\u0005]41Q\u0005\u0005\u0007\u000b\u000bIH\u0001\u0005NKR\fG-\u0019;b\u0003Q\u0019\b/\u0019:l\u001b\u0006\u0004Hk\u001c,feRL7-Y'baRA11NBF\u0007\u001f\u001b\u0019\nC\u0004\u0004\u000e\u0002\u0003\r!!\u001e\u0002\u000f-,\u0017\u0010V=qK\"91\u0011\u0013!A\u0002\u0005U\u0014!\u0003<bYV,G+\u001f9f\u0011\u0019\u00199\b\u0011a\u0001Q\u000692\u000f]1sWN#(/^2u)>4VM\u001d;jG\u0006\u0014vn\u001e\u000b\t\u0007W\u001aIj!+\u0004,\"911T!A\u0002\ru\u0015A\u00024jK2$7\u000fE\u0003`\u0007?\u001b\u0019+C\u0002\u0004\"\u0002\u0014Q!\u0011:sCf\u0004B!a\u001e\u0004&&!1qUA=\u0005-\u0019FO];di\u001aKW\r\u001c3\t\r\r]\u0014\t1\u0001i\u0011\u0019\u0019Y(\u0011a\u0001Q\u0006A2\u000f]1sW\u0006\u0013(/Y=U_Z+'\u000f^5dC\u0006\u0013(/Y=\u0015\u0015\r-4\u0011WB[\u0007o\u001bI\fC\u0004\u00044\n\u0003\r!!\u001e\u0002\u0011\u0011\fG/\u0019+za\u0016Daaa\u001eC\u0001\u0004A\u0007BBB>\u0005\u0002\u0007\u0001\u000eC\u0004\u0004\u0000\t\u0003\ra!!\u0002AM\u0004\u0018M]6Qe&l\u0017\u000e^5wKR{g+\u001a:uS\u000e\f\u0007K]5nSRLg/\u001a\u000b\u0007\u0007W\u001ayl!1\t\u000f\rM4\t1\u0001\u0002v!11qO\"A\u0002!\f\u0011cZ3u\u0007>\u0004\u0018pQ8mk6tG*[:u)!\u00199m!3\u0004L\u000eM\u0007CBAy\u0005\u0017\t\u0019\u0005C\u0004\u0003\u001a\u0011\u0003\rAa\u0007\t\u000f\t-C\t1\u0001\u0004NB!!\u0011GBh\u0013\u0011\u0019\tNa\r\u0003\u0013Q\u000b'\r\\3OC6,\u0007B\u0002)E\u0001\u0004\u0011\t\"A\tnC.,7i\u001c7v[:\u001c8\u000b\u001e:j]\u001e$b!a\u0011\u0004Z\u000eu\u0007bBBn\u000b\u0002\u0007!q`\u0001\u000bG>dW/\u001c8EK\u001a\u001c\bbBBp\u000b\u0002\u0007!\u0011C\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b\u0003Mi\u0017m[3UC\ndWmQ8mk6tG)\u001a4t)!\u00199m!:\u0004h\u000e%\bB\u0002)G\u0001\u0004\u0011\t\u0002\u0003\u0004\u0004x\u0019\u0003\r\u0001\u001b\u0005\u0007\u0007w2\u0005\u0019\u00015\u0002)\u001d,G/T3sO\u0016Len]3siZ\u000bG.^3t)!\u00199ma<\u0004r\u000eM\bb\u0002B\r\u000f\u0002\u0007!1\u0004\u0005\b\u0005\u0017:\u0005\u0019ABg\u0011\u001d\u0019)p\u0012a\u0001\u0007o\fabY8qs\u000e{G.^7o\u0019&\u001cH\u000fE\u0003`\u0005K\u001cI\u0010\u0005\u0003\u00032\rm\u0018\u0002BB\u007f\u0005g\u0011qBV1mS\u0012\u001cu\u000e\\;n]2K7\u000f^\u0001\u0016G\",7m\u001b,bY&$G+\u00192mKN\u001b\u0007.Z7b)\u0011!\u0019\u0001b\u0003\u0011\r\u0005E(1\u0002C\u0003!\ryFqA\u0005\u0004\t\u0013\u0001'\u0001B+oSRDa\u0001\u0015%A\u0002\tE\u0011!F2iK\u000e\\W*\u00199D_2,XN\\:TG\",W.\u0019\u000b\u0005\t#!I\u0002\u0005\u0005\u0002b\u0005\u0015D1\u0003C\u0003!\u0011\tY\u0007\"\u0006\n\t\u0011]\u0011Q\u000e\u0002\n\u000bJ\u0014xN\u001d'jgRDq\u0001b\u0007J\u0001\u0004!i\"A\bd_6\u0004H.\u001a=UsB,7i\u001c7t!\u0019\ty+!/\u0004$\u0006Q2\r[3dW6\u000b\u0007oQ8oi\u0006Lgn\u001d)sS6LG/\u001b<fgR1A1\u0001C\u0012\tOAq\u0001\"\nK\u0001\u0004\t\u0019%A\u0004d_2t\u0015-\\3\t\u000f\u0011%\"\n1\u0001\u0005,\u0005\u0019Q.\u00199\u0011\t\u0005]DQF\u0005\u0005\t_\tIHA\u0004NCB$\u0016\u0010]3\u0002)\u001d,G/T3sO\u0016,\u0006\u000fZ1uKZ\u000bG.^3t))\u00199\r\"\u000e\u00058\u0011eBQ\b\u0005\b\u00053Y\u0005\u0019\u0001B\u000e\u0011\u001d\u0011Ye\u0013a\u0001\u0007\u001bDq\u0001b\u000fL\u0001\u0004\u0019i-A\u0007uK6\u0004H+\u00192mK:\u000bW.\u001a\u0005\b\u0007k\\\u0005\u0019AB|\u0003M)\b\u000fZ1uK\u001aKW\r\u001c3ECR\fG+\u001f9f)1\t\u0019\u0005b\u0011\u0005H\u0011%C1\nC'\u0011\u001d!)\u0005\u0014a\u0001\u0003\u0007\n1aY8m\u0011\u001d!)\u0003\u0014a\u0001\u0003\u0007Ba\u0001\u0015'A\u0002\tE\u0001BBB<\u0019\u0002\u0007\u0001\u000e\u0003\u0004\u0004|1\u0003\r\u0001[\u0001\u0019S:4WM]#yi\u0016\u0014h.\u00197UC\ndWmU2iK6\fG\u0003DBd\t'\"9\u0006\"\u0017\u0005\\\u0011u\u0003b\u0002C+\u001b\u0002\u0007\u00111I\u0001\u0018GJ,\u0017\r^3FqR,'O\\1m)\u0006\u0014G.Z*u[RDa\u0001U'A\u0002\tE\u0001b\u0002B&\u001b\u0002\u0007\u00111\t\u0005\u0007\u0007oj\u0005\u0019\u00015\t\r\rmT\n1\u0001i\u0001")
public class SchemaTools
implements SchemaToolsInterface {
    private volatile SchemaTools$ColumnInfoQueryData$ ColumnInfoQueryData$module;
    private final Logger logger = LogProvider$.MODULE$.getLogger(SchemaTools.class);
    private final String unknown;
    private final String com$vertica$spark$util$schema$SchemaTools$$maxlength;
    private final int com$vertica$spark$util$schema$SchemaTools$$longlength;
    private final ComplexTypeUtils complexTypeUtils = new ComplexTypeUtils();

    public static long VERTICA_SET_MAX_ID() {
        return SchemaTools$.MODULE$.VERTICA_SET_MAX_ID();
    }

    public static long VERTICA_PRIMITIVES_MAX_ID() {
        return SchemaTools$.MODULE$.VERTICA_PRIMITIVES_MAX_ID();
    }

    public static long VERTICA_SET_BASE_ID() {
        return SchemaTools$.MODULE$.VERTICA_SET_BASE_ID();
    }

    public static long VERTICA_NATIVE_ARRAY_BASE_ID() {
        return SchemaTools$.MODULE$.VERTICA_NATIVE_ARRAY_BASE_ID();
    }

    public SchemaTools$ColumnInfoQueryData$ ColumnInfoQueryData() {
        if (this.ColumnInfoQueryData$module == null) {
            this.ColumnInfoQueryData$lzycompute$1();
        }
        return this.ColumnInfoQueryData$module;
    }

    private Logger logger() {
        return this.logger;
    }

    private String unknown() {
        return this.unknown;
    }

    public String com$vertica$spark$util$schema$SchemaTools$$maxlength() {
        return this.com$vertica$spark$util$schema$SchemaTools$$maxlength;
    }

    public int com$vertica$spark$util$schema$SchemaTools$$longlength() {
        return this.com$vertica$spark$util$schema$SchemaTools$$longlength;
    }

    private ComplexTypeUtils complexTypeUtils() {
        return this.complexTypeUtils;
    }

    public String com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(String str) {
        return new StringBuilder(2).append("\"").append(str).append("\"").toString();
    }

    private Either<SchemaError, DataType> getCatalystType(int sqlType, int precision, int scale, boolean signed, String typename, List<ColumnDef> childDefs) {
        Either<MissingSqlConversionError, DataType> either;
        int n = sqlType;
        switch (n) {
            case 2003: {
                either = this.getArrayType(childDefs);
                break;
            }
            case 2002: {
                either = package$.MODULE$.Right().apply((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
                break;
            }
            default: {
                either = this.getCatalystTypeFromJdbcType(sqlType, precision, scale, signed, typename);
                break;
            }
        }
        return either;
    }

    private Either<SchemaError, ArrayType> getArrayType(List<ColumnDef> elementDef) {
        Left left;
        Option option = elementDef.headOption();
        if (option instanceof Some) {
            Right right;
            Some some = (Some)option;
            ColumnDef element = (ColumnDef)some.value();
            Either<MissingSqlConversionError, DataType> either = this.getCatalystTypeFromJdbcType(element.colType(), element.size(), element.scale(), element.signed(), element.colTypeName());
            if (either instanceof Right) {
                Right right2 = (Right)either;
                DataType elementType = (DataType)right2.value();
                ArrayType arrayType = this.makeNestedArrays$1(element.metadata().getLong(MetadataKey$.MODULE$.DEPTH()), elementType);
                right = package$.MODULE$.Right().apply((Object)arrayType);
            } else if (either instanceof Left) {
                Left left2 = (Left)either;
                MissingSqlConversionError err = (MissingSqlConversionError)left2.value();
                right = package$.MODULE$.Left().apply((Object)new ArrayElementConversionError(err.sqlType(), err.typename()));
            } else {
                throw new MatchError(either);
            }
            left = right;
        } else if (None$.MODULE$.equals(option)) {
            left = package$.MODULE$.Left().apply((Object)new MissingElementTypeError());
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    public Either<MissingSqlConversionError, DataType> getCatalystTypeFromJdbcType(int sqlType, int precision, int scale, boolean signed, String typename) {
        BinaryType$ binaryType$;
        int n = sqlType;
        switch (n) {
            case -5: {
                if (signed) {
                    binaryType$ = LongType$.MODULE$;
                    break;
                }
                binaryType$ = new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 0);
                break;
            }
            case -2: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case -7: {
                binaryType$ = BooleanType$.MODULE$;
                break;
            }
            case 2004: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case 16: {
                binaryType$ = BooleanType$.MODULE$;
                break;
            }
            case 1: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2005: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 70: {
                binaryType$ = null;
                break;
            }
            case 91: {
                binaryType$ = DateType$.MODULE$;
                break;
            }
            case 3: {
                binaryType$ = new DecimalType(precision, scale);
                break;
            }
            case 2001: {
                binaryType$ = null;
                break;
            }
            case 8: {
                binaryType$ = DoubleType$.MODULE$;
                break;
            }
            case 6: {
                binaryType$ = FloatType$.MODULE$;
                break;
            }
            case 4: {
                if (signed) {
                    binaryType$ = IntegerType$.MODULE$;
                    break;
                }
                binaryType$ = LongType$.MODULE$;
                break;
            }
            case 2000: {
                binaryType$ = null;
                break;
            }
            case -16: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -4: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case -1: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2011: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 0: {
                binaryType$ = null;
                break;
            }
            case 2: {
                if (precision != 0 || scale != 0) {
                    binaryType$ = new DecimalType(precision, scale);
                    break;
                }
                binaryType$ = new DecimalType(DecimalType$.MODULE$.USER_DEFAULT().precision(), DecimalType$.MODULE$.USER_DEFAULT().scale());
                break;
            }
            case -9: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 1111: {
                String typenameNormalized = typename.toLowerCase();
                if (typenameNormalized.startsWith("interval") || typenameNormalized.startsWith("uuid")) {
                    binaryType$ = StringType$.MODULE$;
                    break;
                }
                binaryType$ = null;
                break;
            }
            case 7: {
                binaryType$ = DoubleType$.MODULE$;
                break;
            }
            case 2006: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -8: {
                binaryType$ = LongType$.MODULE$;
                break;
            }
            case 5: {
                binaryType$ = IntegerType$.MODULE$;
                break;
            }
            case 2009: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 92: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 93: {
                binaryType$ = TimestampType$.MODULE$;
                break;
            }
            case -6: {
                binaryType$ = IntegerType$.MODULE$;
                break;
            }
            case -3: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case 12: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            default: {
                binaryType$ = null;
                break;
            }
        }
        BinaryType$ answer = binaryType$;
        return answer == null ? package$.MODULE$.Left().apply((Object)new MissingSqlConversionError(((Object)BoxesRunTime.boxToInteger((int)sqlType)).toString(), typename)) : package$.MODULE$.Right().apply((Object)answer);
    }

    @Override
    public Either<ConnectorError, StructType> readSchema(JdbcLayerInterface jdbcLayer, TableSource tableSource) {
        Left left;
        Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tableSource);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq colInfo = (Seq)right.value();
            List errorsOrFields = ((TraversableOnce)colInfo.map((Function1 & Serializable & scala.Serializable)info -> this.getCatalystType(info.colType(), info.size(), info.scale(), info.signed(), info.colTypeName(), info.childDefinitions()).map((Function1 & Serializable & scala.Serializable)columnType -> new StructField(info.label(), columnType, info.nullable(), info.metadata())), Seq$.MODULE$.canBuildFrom())).toList();
            left = ((Validated)implicits$.MODULE$.toTraverseOps((Object)errorsOrFields, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$1 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$1), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)field -> StructType$.MODULE$.apply((Seq)field)).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    public ColumnInfoQueryData getColumnInfoQueryData(TableSource tableSource) {
        ColumnInfoQueryData columnInfoQueryData;
        TableSource tableSource2 = tableSource;
        if (tableSource2 instanceof TableName) {
            TableName tableName = (TableName)tableSource2;
            columnInfoQueryData = new ColumnInfoQueryData(this, tableName.getTableName().replace("\"", ""), tableName.getDbSchema().replace("\"", ""), new StringBuilder(24).append("SELECT * FROM ").append(tableName.getFullTableName()).append(" WHERE 1=0").toString());
        } else if (tableSource2 instanceof TableQuery) {
            TableQuery tableQuery = (TableQuery)tableSource2;
            String query = tableQuery.query();
            columnInfoQueryData = new ColumnInfoQueryData(this, "", "", new StringBuilder(31).append("SELECT * FROM (").append(query).append(") AS x WHERE 1=0").toString());
        } else {
            throw new MatchError((Object)tableSource2);
        }
        return columnInfoQueryData;
    }

    @Override
    public Either<ConnectorError, Seq<ColumnDef>> getColumnInfo(JdbcLayerInterface jdbcLayer, TableSource tableSource) {
        Left left;
        ColumnInfoQueryData tableInfo = this.getColumnInfoQueryData(tableSource);
        Either<ConnectorError, ResultSet> either = jdbcLayer.query(tableInfo.emptyQuery(), jdbcLayer.query$default$2());
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
        } else if (either instanceof Right) {
            Left left3;
            Right right = (Right)either;
            try (ResultSet rs = (ResultSet)right.value();){
                try {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    List colDefsOrErrors = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), rsmd.getColumnCount()).map((Function1 & Serializable & scala.Serializable)idx -> SchemaTools.$anonfun$getColumnInfo$1(this, rsmd, tableInfo, jdbcLayer, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
                    left3 = ((Validated)implicits$.MODULE$.toTraverseOps((Object)colDefsOrErrors, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$2 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$2), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)columnDef -> columnDef).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
                }
                catch (Throwable e) {
                    left3 = package$.MODULE$.Left().apply((Object)new DatabaseReadError(e).context("Could not get column info from Vertica"));
                }
            }
            left = left3;
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    private Either<ConnectorError, ColumnDef> checkForComplexType(ColumnDef colDef, String tableName, String dbSchema, JdbcLayerInterface jdbcLayer) {
        Either<ConnectorError, ColumnDef> either;
        int n = colDef.colType();
        switch (n) {
            case 2002: 
            case 2003: {
                either = this.queryColumnDef(colDef, tableName, dbSchema, jdbcLayer);
                break;
            }
            default: {
                either = package$.MODULE$.Right().apply((Object)colDef);
                break;
            }
        }
        return either;
    }

    private Either<ConnectorError, ColumnDef> queryColumnDef(ColumnDef complexTypeColDef, String tableName, String dbSchema, JdbcLayerInterface jdbcLayer) {
        String colName = complexTypeColDef.label();
        String schemaCond = new StringOps(Predef$.MODULE$.augmentString(dbSchema)).nonEmpty() ? new StringBuilder(20).append(" AND table_schema='").append(dbSchema).append("'").toString() : "";
        String queryColType = new StringBuilder(82).append("SELECT data_type_id, data_type FROM columns WHERE table_name='").append(tableName).append("'").append(schemaCond).append(" AND column_name='").append(colName).append("'").toString();
        return JdbcUtils$.MODULE$.queryAndNext(queryColType, jdbcLayer, (Function1 & Serializable & scala.Serializable)rs -> this.handleColumnExist$1((ResultSet)rs, complexTypeColDef, jdbcLayer), JdbcUtils$.MODULE$.queryAndNext$default$4());
    }

    private Either<ConnectorError, ColumnDef> makeArrayColumnDef(ColumnDef arrayColDef, long verticaTypeId, JdbcLayerInterface jdbcLayer) {
        long id = verticaTypeId - SchemaTools$.MODULE$.VERTICA_NATIVE_ARRAY_BASE_ID();
        boolean isSet = id > SchemaTools$.MODULE$.VERTICA_PRIMITIVES_MAX_ID() && id < SchemaTools$.MODULE$.VERTICA_SET_MAX_ID();
        long elementId = isSet ? verticaTypeId - SchemaTools$.MODULE$.VERTICA_SET_BASE_ID() : id;
        boolean isNativeArray = elementId < SchemaTools$.MODULE$.VERTICA_PRIMITIVES_MAX_ID();
        Either<ConnectorError, ColumnDef> elementDef = isNativeArray ? this.queryVerticaPrimitiveDef(elementId, 0, jdbcLayer) : this.getNestedArrayElementDef(verticaTypeId, jdbcLayer);
        return this.fillArrayColumnDef(arrayColDef, elementDef, isSet);
    }

    private Either<ConnectorError, ColumnDef> fillArrayColumnDef(ColumnDef srcArrayDef, Either<ConnectorError, ColumnDef> elementDef, boolean isVerticaSet) {
        Left left;
        Either<ConnectorError, ColumnDef> either = elementDef;
        if (either instanceof Right) {
            Right right = (Right)either;
            ColumnDef element = (ColumnDef)right.value();
            Metadata metaData = new MetadataBuilder().putString(MetadataKey$.MODULE$.NAME(), srcArrayDef.label()).putBoolean(MetadataKey$.MODULE$.IS_VERTICA_SET(), isVerticaSet).putLong(MetadataKey$.MODULE$.DEPTH(), element.metadata().getLong(MetadataKey$.MODULE$.DEPTH())).build();
            .colon.colon x$1 = new .colon.colon((Object)element, (List)Nil$.MODULE$);
            Metadata x$2 = metaData;
            String x$3 = srcArrayDef.copy$default$1();
            int x$4 = srcArrayDef.copy$default$2();
            String x$5 = srcArrayDef.copy$default$3();
            int x$6 = srcArrayDef.copy$default$4();
            int x$7 = srcArrayDef.copy$default$5();
            boolean x$8 = srcArrayDef.copy$default$6();
            boolean x$9 = srcArrayDef.copy$default$7();
            left = package$.MODULE$.Right().apply((Object)srcArrayDef.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$2, (List<ColumnDef>)x$1));
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    private Either<ConnectorError, ColumnDef> getNestedArrayElementDef(long verticaType, JdbcLayerInterface jdbcLayer) {
        return this.getNestedElementDef$1(verticaType, jdbcLayer, 0);
    }

    private Either<ConnectorError, ColumnDef> queryVerticaPrimitiveDef(long verticaType, int depth, JdbcLayerInterface jdbcLayer) {
        String queryNativeTypes = new StringBuilder(62).append("SELECT type_id, jdbc_type, type_name FROM types WHERE type_id=").append(verticaType).toString();
        return JdbcUtils$.MODULE$.queryAndNext(queryNativeTypes, jdbcLayer, (Function1 & Serializable & scala.Serializable)rs -> {
            int jdbcType = (int)rs.getLong("jdbc_type");
            String typeName = rs.getString("type_name");
            return package$.MODULE$.Right().apply((Object)this.makeArrayElementDef(jdbcType, typeName, depth));
        }, (Function1 & Serializable & scala.Serializable)x$3 -> package$.MODULE$.Left().apply((Object)new VerticaNativeTypeNotFound(verticaType)));
    }

    public ColumnDef makeArrayElementDef(int jdbcType, String typeName, int depth) {
        int sqlType = jdbcType;
        int fieldSize = DecimalType$.MODULE$.MAX_PRECISION();
        int fieldScale = 0;
        boolean isSigned = true;
        boolean nullable = true;
        Metadata metadata = new MetadataBuilder().putString(MetadataKey$.MODULE$.NAME(), "element").putLong(MetadataKey$.MODULE$.DEPTH(), (long)depth).build();
        return new ColumnDef("element", sqlType, typeName, fieldSize, fieldScale, isSigned, nullable, metadata, ColumnDef$.MODULE$.apply$default$9());
    }

    @Override
    public Either<SchemaError, String> getVerticaTypeFromSparkType(DataType sparkType, long strlen, long arrayLength, Metadata metadata) {
        Either<SchemaError, String> either;
        DataType dataType = sparkType;
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            either = this.sparkMapToVerticaMap(keyType, valueType, strlen);
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            either = this.sparkStructToVerticaRow(fields, strlen, arrayLength);
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType sparkType2 = arrayType.elementType();
            either = this.sparkArrayToVerticaArray(sparkType2, strlen, arrayLength, metadata);
        } else {
            either = this.sparkPrimitiveToVerticaPrimitive(sparkType, strlen);
        }
        return either;
    }

    private Either<SchemaError, String> sparkMapToVerticaMap(DataType keyType, DataType valueType, long strlen) {
        Right right;
        Either<SchemaError, String> keyVerticaType = this.sparkPrimitiveToVerticaPrimitive(keyType, strlen);
        Either<SchemaError, String> valueVerticaType = this.sparkPrimitiveToVerticaPrimitive(valueType, strlen);
        if (keyVerticaType.isRight() && valueVerticaType.isRight()) {
            right = package$.MODULE$.Right().apply((Object)new StringBuilder(7).append("MAP<").append(keyVerticaType.right().get()).append(", ").append(valueVerticaType.right().get()).append(">").toString());
        } else {
            String string;
            String string2;
            Either<SchemaError, String> either = keyVerticaType;
            if (either instanceof Left) {
                Left left = (Left)either;
                SchemaError error = (SchemaError)left.value();
                string2 = error.getFullContext();
            } else if (either instanceof Right) {
                string2 = "None";
            } else {
                throw new MatchError(either);
            }
            String keyErrorMsg = string2;
            Either<SchemaError, String> either2 = valueVerticaType;
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                SchemaError error = (SchemaError)left.value();
                string = error.getFullContext();
            } else if (either2 instanceof Right) {
                string = "None";
            } else {
                throw new MatchError(either2);
            }
            String valueErrorMsg = string;
            right = package$.MODULE$.Left().apply((Object)new MapDataTypeConversionError(keyErrorMsg, valueErrorMsg));
        }
        return right;
    }

    private Either<SchemaError, String> sparkStructToVerticaRow(StructField[] fields, long strlen, long arrayLength) {
        Left left;
        Either<ConnectorError, String> either = this.makeTableColumnDefs(new StructType(fields), strlen, arrayLength);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new StructFieldsError(err));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            String fieldDefs = (String)right.value();
            left = package$.MODULE$.Right().apply((Object)new StringBuilder(3).append("ROW").append(fieldDefs.replace(" NOT NULL", "").trim()).toString());
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    private Either<SchemaError, String> sparkArrayToVerticaArray(DataType dataType, long strlen, long arrayLength, Metadata metadata) {
        String length = arrayLength <= 0L ? "" : new StringBuilder(1).append(",").append(arrayLength).toString();
        boolean isSet = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> metadata.getBoolean(MetadataKey$.MODULE$.IS_VERTICA_SET())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        String keyword = isSet ? "SET" : "ARRAY";
        return this.recursion$1(dataType, new StringBuilder(1).append(keyword).append("[").toString(), new StringBuilder(1).append(length).append("]").toString(), 0, keyword, length, strlen, arrayLength, metadata);
    }

    private Either<SchemaError, String> sparkPrimitiveToVerticaPrimitive(DataType sparkType, long strlen) {
        Right right;
        DataType dataType = sparkType;
        if (BinaryType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)new StringBuilder(11).append("VARBINARY(").append(this.com$vertica$spark$util$schema$SchemaTools$$longlength()).append(")").toString());
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"BOOLEAN");
        } else if (ByteType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"TINYINT");
        } else if (DateType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"DATE");
        } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"INTERVAL");
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            right = decimalType.precision() == 0 ? package$.MODULE$.Right().apply((Object)"DECIMAL") : package$.MODULE$.Right().apply((Object)new StringBuilder(11).append("DECIMAL(").append(decimalType.precision()).append(", ").append(decimalType.scale()).append(")").toString());
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"DOUBLE PRECISION");
        } else if (FloatType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"FLOAT");
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"INTEGER");
        } else if (LongType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"BIGINT");
        } else if (NullType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"null");
        } else if (ShortType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"SMALLINT");
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"TIMESTAMP");
        } else if (StringType$.MODULE$.equals(dataType)) {
            String vtype = strlen > (long)this.com$vertica$spark$util$schema$SchemaTools$$longlength() ? "LONG VARCHAR" : "VARCHAR";
            right = package$.MODULE$.Right().apply((Object)new StringBuilder(2).append(vtype).append("(").append(((Object)BoxesRunTime.boxToLong((long)strlen)).toString()).append(")").toString());
        } else {
            right = package$.MODULE$.Left().apply((Object)new MissingSparkPrimitivesConversionError(sparkType));
        }
        return right;
    }

    @Override
    public Either<ConnectorError, String> getCopyColumnList(JdbcLayerInterface jdbcLayer, TableName tableName, StructType schema) {
        return this.getColumnInfo(jdbcLayer, tableName).flatMap((Function1 & Serializable & scala.Serializable)columns -> {
            Right right;
            int colCount = columns.length();
            IntRef colsFound = IntRef.create((int)0);
            columns.foreach((Function1 & Serializable & scala.Serializable)column -> {
                SchemaTools.$anonfun$getCopyColumnList$2(this, schema, colsFound, tableName, column);
                return BoxedUnit.UNIT;
            });
            if (schema.length() > colCount) {
                right = package$.MODULE$.Left().apply((Object)new TableNotEnoughRowsError().context(new StringBuilder(187).append("Error: Number of columns in the target table should be greater or equal to number of columns in the DataFrame.  Number of columns in DataFrame: ").append(schema.length()).append(". Number of columns in the target table: ").append(tableName.getFullTableName()).append(": ").append(colCount).toString()));
            } else if (colsFound.elem == schema.length()) {
                BoxedUnit boxedUnit;
                ObjectRef columnList2 = ObjectRef.create((Object)"");
                BooleanRef first = BooleanRef.create((boolean)true);
                schema.foreach((Function1 & Serializable & scala.Serializable)s -> {
                    SchemaTools.$anonfun$getCopyColumnList$5(first, columnList2, s);
                    return BoxedUnit.UNIT;
                });
                columnList2.elem = new StringBuilder(3).append("(").append((String)columnList2.elem).append("\")").toString();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder(27).append("Load by name. Column list: ").append((String)columnList2.elem).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                right = package$.MODULE$.Right().apply((Object)((String)columnList2.elem));
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Load by Position");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                right = package$.MODULE$.Right().apply((Object)"");
            }
            return right.map((Function1 & Serializable & scala.Serializable)columnList -> columnList);
        });
    }

    @Override
    public String makeColumnsString(Seq<ColumnDef> columnDefs, StructType requiredSchema) {
        Seq requiredColumnDefs = requiredSchema.nonEmpty() ? (Seq)columnDefs.filter((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)SchemaTools.$anonfun$makeColumnsString$1(requiredSchema, cd))) : columnDefs;
        return ((TraversableOnce)requiredColumnDefs.map((Function1 & Serializable & scala.Serializable)info -> {
            String string;
            int n = info.colType();
            switch (n) {
                case 1111: {
                    String typenameNormalized = info.colTypeName().toLowerCase();
                    if (typenameNormalized.startsWith("interval") || typenameNormalized.startsWith("uuid")) {
                        string = (String)this.castToVarchar$1().apply((Object)info.label());
                        break;
                    }
                    string = this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(info.label());
                    break;
                }
                case 92: {
                    string = (String)this.castToVarchar$1().apply((Object)info.label());
                    break;
                }
                case 2003: {
                    boolean isSet = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> info.metadata().getBoolean(MetadataKey$.MODULE$.IS_VERTICA_SET())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                    if (isSet) {
                        string = SchemaTools.castToArray$1(info);
                        break;
                    }
                    string = info.label();
                    break;
                }
                default: {
                    string = this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(info.label());
                    break;
                }
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    @Override
    public Either<ConnectorError, String> makeTableColumnDefs(StructType schema, long strlen, long arrayLength) {
        Left left;
        List colDefsOrErrors = ((TraversableOnce)schema.map((Function1 & Serializable & scala.Serializable)col -> {
            Left left;
            String colName = new StringBuilder(2).append("\"").append(col.name()).append("\"").toString();
            String notNull = !col.nullable() ? "NOT NULL" : "";
            Either<SchemaError, String> either = this.getVerticaTypeFromSparkType(col.dataType(), strlen, arrayLength, col.metadata());
            if (either instanceof Left) {
                Left left2 = (Left)either;
                SchemaError err = (SchemaError)left2.value();
                left = package$.MODULE$.Left().apply((Object)new SchemaConversionError(err).context("Schema error when trying to create table"));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                String colType = (String)right.value();
                left = package$.MODULE$.Right().apply((Object)new StringBuilder(2).append(colName).append(" ").append(colType).append(" ").append(notNull).toString().trim());
            } else {
                throw new MatchError(either);
            }
            return left;
        }, Seq$.MODULE$.canBuildFrom())).toList();
        Either result = ((Validated)implicits$.MODULE$.toTraverseOps((Object)colDefsOrErrors, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$4 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$4), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)columnDef -> columnDef).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
        Either either = result;
        if (either instanceof Right) {
            Right right = (Right)either;
            List colDefList = (List)right.value();
            left = package$.MODULE$.Right().apply((Object)new StringBuilder(3).append(" (").append(colDefList.mkString(", ")).append(")").toString());
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ErrorList err = (ErrorList)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, String> getMergeInsertValues(JdbcLayerInterface jdbcLayer, TableName tableName, Option<ValidColumnList> copyColumnList) {
        Left left;
        Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tableName);
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq info = (Seq)right.value();
            left = package$.MODULE$.Right().apply((Object)((TraversableOnce)info.map((Function1 & Serializable & scala.Serializable)x -> new StringBuilder(5).append("temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).toString(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
        } else {
            throw new MatchError(either);
        }
        Left valueList = left;
        return valueList;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> checkValidTableSchema(StructType schema) {
        Tuple2<List<StructField>, List<StructField>> tuple2 = this.complexTypeUtils().getComplexTypeColumns(schema);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List nativeCols = (List)tuple2._1();
        List complexTypeCols = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nativeCols, (Object)complexTypeCols);
        Tuple2 tuple23 = tuple22;
        List nativeCols2 = (List)tuple23._1();
        List complexTypeCols2 = (List)tuple23._2();
        return nativeCols2.isEmpty() ? (complexTypeCols2.nonEmpty() ? package$.MODULE$.Left().apply((Object)new InvalidTableSchemaComplexType()) : package$.MODULE$.Left().apply((Object)new EmptySchemaError())) : this.checkMapColumnsSchema((List<StructField>)complexTypeCols2);
    }

    private Either<ErrorList, BoxedUnit> checkMapColumnsSchema(List<StructField> complexTypeCols) {
        return ((Validated)implicits$.MODULE$.toTraverseOps(((List)complexTypeCols.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)SchemaTools.$anonfun$checkMapColumnsSchema$1(x$6)))).map((Function1 & Serializable & scala.Serializable)col -> this.checkMapContainsPrimitives(col.name(), (MapType)col.dataType()), List$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$7 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$7), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)x$8 -> {
            SchemaTools.$anonfun$checkMapColumnsSchema$5(x$8);
            return BoxedUnit.UNIT;
        }).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
    }

    private Either<ConnectorError, BoxedUnit> checkMapContainsPrimitives(String colName, MapType map) {
        Either<SchemaError, String> keyType = this.sparkPrimitiveToVerticaPrimitive(map.keyType(), 0L);
        Either<SchemaError, String> valueType = this.sparkPrimitiveToVerticaPrimitive(map.valueType(), 0L);
        return keyType.isRight() && valueType.isRight() ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)new InvalidMapSchemaError(colName));
    }

    @Override
    public Either<ConnectorError, String> getMergeUpdateValues(JdbcLayerInterface jdbcLayer, TableName tableName, TableName tempTableName, Option<ValidColumnList> copyColumnList) {
        Left left;
        Option<ValidColumnList> option = copyColumnList;
        if (option instanceof Some) {
            Left colList;
            Left left2;
            Some some = (Some)option;
            ValidColumnList list = (ValidColumnList)some.value();
            List customColList = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])list.toString().split(","))).toList().map((Function1 & Serializable & scala.Serializable)col -> col.trim(), List$.MODULE$.canBuildFrom());
            Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tempTableName);
            if (either instanceof Right) {
                Right right = (Right)either;
                Seq info = (Seq)right.value();
                List tupleList = (List)customColList.zip((GenIterable)info, List$.MODULE$.canBuildFrom());
                left2 = package$.MODULE$.Right().apply((Object)((TraversableOnce)tupleList.map((Function1 & Serializable & scala.Serializable)x -> new StringBuilder(6).append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes((String)x._1())).append("=temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(((ColumnDef)x._2()).label())).toString(), List$.MODULE$.canBuildFrom())).mkString(", "));
            } else if (either instanceof Left) {
                Left left3 = (Left)either;
                ConnectorError err = (ConnectorError)left3.value();
                left2 = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
            } else {
                throw new MatchError(either);
            }
            left = colList = left2;
        } else if (None$.MODULE$.equals(option)) {
            Left updateList;
            Left left4;
            Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tempTableName);
            if (either instanceof Right) {
                Right right = (Right)either;
                Seq info = (Seq)right.value();
                left4 = package$.MODULE$.Right().apply((Object)((TraversableOnce)info.map((Function1 & Serializable & scala.Serializable)x -> new StringBuilder(6).append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).append("=temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).toString(), Seq$.MODULE$.canBuildFrom())).mkString(", "));
            } else if (either instanceof Left) {
                Left left5 = (Left)either;
                ConnectorError err = (ConnectorError)left5.value();
                left4 = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
            } else {
                throw new MatchError(either);
            }
            left = updateList = left4;
        } else {
            throw new MatchError(option);
        }
        Left columnList = left;
        return columnList;
    }

    public String updateFieldDataType(String col, String colName, StructType schema, long strlen, long arrayLength) {
        Seq fieldType = (Seq)schema.collect((PartialFunction)new scala.Serializable(this, colName, strlen, arrayLength){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchemaTools $outer;
            private final String colName$1;
            private final long strlen$3;
            private final long arrayLength$3;

            /*
             * Unable to fully structure code
             */
            public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> default) {
                block9: {
                    block6: {
                        block8: {
                            block7: {
                                var5_3 = x1;
                                v0 = this.$outer.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(var5_3.name());
                                var6_4 = this.colName$1;
                                if (v0 != null ? v0.equals(var6_4) == false : var6_4 != null) break block6;
                                if (!var5_3.metadata().contains(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())) break block7;
                                v1 = var5_3.dataType().simpleString();
                                var7_5 = "string";
                                if (v1 != null ? v1.equals(var7_5) == false : var7_5 != null) break block7;
                                v2 = var5_3.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength()) > (long)this.$outer.com$vertica$spark$util$schema$SchemaTools$$longlength() ? new StringBuilder(14).append("long varchar(").append(BoxesRunTime.boxToLong((long)var5_3.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())).toString()).append(")").toString() : new StringBuilder(9).append("varchar(").append(BoxesRunTime.boxToLong((long)var5_3.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())).toString()).append(")").toString();
                                break block8;
                            }
                            if (!var5_3.metadata().contains(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())) ** GOTO lbl-1000
                            v3 = var5_3.dataType().simpleString();
                            var8_6 = "binary";
                            if (!(v3 != null ? v3.equals(var8_6) == false : var8_6 != null)) {
                                v2 = new StringBuilder(11).append("varbinary(").append(BoxesRunTime.boxToLong((long)var5_3.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())).toString()).append(")").toString();
                            } else lbl-1000:
                            // 2 sources

                            {
                                if ((var9_7 = this.$outer.getVerticaTypeFromSparkType(var5_3.dataType(), this.strlen$3, this.arrayLength$3, var5_3.metadata())) instanceof Right) {
                                    var10_8 = (Right)var9_7;
                                    var4_10 = dataType = (String)var10_8.value();
                                } else if (var9_7 instanceof Left) {
                                    var12_11 = (Left)var9_7;
                                    err = (SchemaError)var12_11.value();
                                    var4_10 = package$.MODULE$.Left().apply((Object)err);
                                } else {
                                    throw new MatchError(var9_7);
                                }
                                v2 = var4_10;
                            }
                        }
                        var3_13 = v2;
                        break block9;
                    }
                    var3_13 = default.apply(x1);
                }
                return (B1)var3_13;
            }

            public final boolean isDefinedAt(StructField x1) {
                StructField structField = x1;
                String string = this.$outer.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(structField.name());
                String string2 = this.colName$1;
                boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.colName$1 = colName$1;
                this.strlen$3 = strlen$3;
                this.arrayLength$3 = arrayLength$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return fieldType.nonEmpty() ? new StringBuilder(1).append(colName).append(" ").append(fieldType.head()).toString() : col;
    }

    @Override
    public Either<ConnectorError, String> inferExternalTableSchema(String createExternalTableStmt, StructType schema, String tableName, long strlen, long arrayLength) {
        Right right;
        int indexOfClosingParantheses;
        int indexOfOpeningParantheses;
        String stmt = createExternalTableStmt.replace(new StringBuilder(2).append("\"").append(tableName).append("\"").toString(), tableName);
        String schemaString = stmt.substring((indexOfOpeningParantheses = stmt.indexOf("(")) + 1, indexOfClosingParantheses = stmt.indexOf(")"));
        List schemaList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schemaString.split(","))).toList();
        String updatedSchema = ((TraversableOnce)schemaList.map((Function1 & Serializable & scala.Serializable)col -> {
            int indexOfFirstDoubleQuote = col.indexOf("\"");
            int indexOfSpace = col.indexOf(" ", indexOfFirstDoubleQuote);
            String colName = col.substring(indexOfFirstDoubleQuote, indexOfSpace);
            return schema.nonEmpty() ? this.updateFieldDataType((String)col, colName, schema, strlen, arrayLength) : (col.toLowerCase().contains("varchar") ? new StringBuilder(10).append(colName).append(" varchar(").append(strlen).append(")").toString() : (col.toLowerCase().contains("varbinary") ? new StringBuilder(12).append(colName).append(" varbinary(").append(this.com$vertica$spark$util$schema$SchemaTools$$longlength()).append(")").toString() : col));
        }, List$.MODULE$.canBuildFrom())).mkString(",");
        if (updatedSchema.contains(this.unknown())) {
            right = package$.MODULE$.Left().apply((Object)new UnknownColumnTypesError().context(new StringBuilder(30).append(this.unknown()).append(" partitioned column data type.").toString()));
        } else {
            BoxedUnit boxedUnit;
            String updatedCreateTableStmt = stmt.replace(schemaString, updatedSchema);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder(41).append("Updated create external table statement: ").append(updatedCreateTableStmt).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            right = package$.MODULE$.Right().apply((Object)updatedCreateTableStmt);
        }
        return right;
    }

    private final void ColumnInfoQueryData$lzycompute$1() {
        SchemaTools schemaTools = this;
        synchronized (schemaTools) {
            if (this.ColumnInfoQueryData$module == null) {
                this.ColumnInfoQueryData$module = new SchemaTools$ColumnInfoQueryData$(this);
            }
        }
    }

    private final ArrayType makeNestedArrays$1(long arrayDepth, DataType arrayElement) {
        while (arrayDepth > 0L) {
            arrayElement = ArrayType$.MODULE$.apply(arrayElement);
            --arrayDepth;
        }
        return ArrayType$.MODULE$.apply(arrayElement);
    }

    public static final /* synthetic */ Either $anonfun$getColumnInfo$1(SchemaTools $this, ResultSetMetaData rsmd$1, ColumnInfoQueryData tableInfo$1, JdbcLayerInterface jdbcLayer$1, int idx) {
        String columnLabel = rsmd$1.getColumnLabel(idx);
        String typeName = rsmd$1.getColumnTypeName(idx);
        int fieldSize = DecimalType$.MODULE$.MAX_PRECISION();
        int fieldScale = rsmd$1.getScale(idx);
        boolean isSigned = rsmd$1.isSigned(idx);
        boolean nullable = rsmd$1.isNullable(idx) != 0;
        Metadata metadata = new MetadataBuilder().putString(MetadataKey$.MODULE$.NAME(), columnLabel).build();
        int colType = rsmd$1.getColumnType(idx);
        ColumnDef colDef = new ColumnDef(columnLabel, colType, typeName, fieldSize, fieldScale, isSigned, nullable, metadata, ColumnDef$.MODULE$.apply$default$9());
        return $this.checkForComplexType(colDef, tableInfo$1.tableName(), tableInfo$1.dbSchema(), jdbcLayer$1);
    }

    private static final String getTypeName$1(String dataType) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(dataType.replaceFirst("\\[", ",").replaceFirst("\\(", ","))).split(','))).head();
    }

    private final Either handleColumnExist$1(ResultSet rs, ColumnDef complexTypeColDef$1, JdbcLayerInterface jdbcLayer$2) {
        Left left;
        long verticaType = rs.getLong("data_type_id");
        String typeName = SchemaTools.getTypeName$1(rs.getString("data_type"));
        int n = complexTypeColDef$1.colType();
        switch (n) {
            case 2003: {
                left = this.makeArrayColumnDef(complexTypeColDef$1, verticaType, jdbcLayer$2);
                break;
            }
            case 2002: {
                left = package$.MODULE$.Right().apply((Object)complexTypeColDef$1);
                break;
            }
            default: {
                left = package$.MODULE$.Left().apply((Object)new MissingSqlConversionError(((Object)BoxesRunTime.boxToInteger((int)complexTypeColDef$1.colType())).toString(), typeName));
                break;
            }
        }
        return left;
    }

    private final Either getNestedElementDef$1(long verticaType, JdbcLayerInterface jdbcLayer, int depth) {
        Left left;
        block6: {
            String queryComplexType;
            Either<ConnectorError, ResultSet> either;
            while ((either = jdbcLayer.query(queryComplexType = new StringBuilder(92).append("SELECT field_type_name, type_id ,field_id, numeric_scale FROM complex_types WHERE type_id='").append(verticaType).append("'").toString(), jdbcLayer.query$default$2())) instanceof Right) {
                Either<ConnectorError, ColumnDef> either2;
                Right right = (Right)either;
                ResultSet rs = (ResultSet)right.value();
                if (rs.next()) {
                    String fieldTypeName = rs.getString("field_type_name");
                    long verticaType2 = rs.getLong("field_id");
                    rs.close();
                    if (fieldTypeName.startsWith("_ct_")) {
                        ++depth;
                        verticaType = verticaType2;
                        continue;
                    }
                    either2 = this.queryVerticaPrimitiveDef(verticaType2, depth, jdbcLayer);
                } else {
                    rs.close();
                    either2 = package$.MODULE$.Left().apply((Object)new VerticaComplexTypeNotFound(verticaType));
                }
                left = either2;
                break block6;
            }
            if (either instanceof Left) {
                Left left2 = (Left)either;
                ConnectorError error = (ConnectorError)left2.value();
                left = package$.MODULE$.Left().apply((Object)error);
            } else {
                throw new MatchError(either);
            }
        }
        return left;
    }

    private final Either recursion$1(DataType dataType, String leftAccumulator, String rightAccumulator, int depth, String keyword$1, String length$1, long strlen$1, long arrayLength$1, Metadata metadata$1) {
        Left left;
        DataType dataType2;
        while ((dataType2 = dataType) instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            ++depth;
            rightAccumulator = new StringBuilder(1).append(length$1).append("]").append(rightAccumulator).toString();
            leftAccumulator = new StringBuilder(1).append(leftAccumulator).append(keyword$1).append("[").toString();
            dataType = elementType;
        }
        Either<SchemaError, String> either = this.getVerticaTypeFromSparkType(dataType, strlen$1, arrayLength$1, metadata$1);
        if (either instanceof Right) {
            Right right = (Right)either;
            String verticaType = (String)right.value();
            left = package$.MODULE$.Right().apply((Object)new StringBuilder(0).append(leftAccumulator).append(verticaType).append(rightAccumulator).toString());
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            SchemaError error = (SchemaError)left2.value();
            left = package$.MODULE$.Left().apply((Object)error);
        } else {
            throw new MatchError(either);
        }
        Left left3 = left;
        return left3;
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$4(SchemaTools $this, ColumnDef column$1, IntRef colsFound$1, TableName tableName$1, StructField s) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(48).append("Comparing target table column: ").append(column$1.label()).append(" with DF column: ").append(s.name()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (s.name().equalsIgnoreCase(column$1.label())) {
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            ++colsFound$1.elem;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug(new StringBuilder(37).append("Column: ").append(s.name()).append(" found in target table and DF").toString());
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            if (!column$1.nullable()) {
                if (s.nullable()) {
                    if ($this.logger().underlying().isWarnEnabled()) {
                        $this.logger().underlying().warn(new StringBuilder(128).append("S2V: Column ").append(s.name()).append(" is NOT NULL in target table ").append(tableName$1.getFullTableName()).append(" but it's nullable in the DataFrame. Rows with NULL values in column ").append(s.name()).append(" will be rejected.").toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw Breaks$.MODULE$.break();
        }
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$2(SchemaTools $this, StructType schema$1, IntRef colsFound$1, TableName tableName$1, ColumnDef column) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(43).append("Will check that target column: ").append(column.label()).append(" exist in DF").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> schema$1.foreach((Function1 & Serializable & scala.Serializable)s -> {
            SchemaTools.$anonfun$getCopyColumnList$4($this, column, colsFound$1, tableName$1, s);
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$5(BooleanRef first$1, ObjectRef columnList$1, StructField s) {
        if (first$1.elem) {
            columnList$1.elem = new StringBuilder(1).append("\"").append(s.name()).toString();
            first$1.elem = false;
        } else {
            columnList$1.elem = new StringBuilder(3).append((String)columnList$1.elem).append("\",\"").append(s.name()).toString();
        }
    }

    public static final /* synthetic */ boolean $anonfun$makeColumnsString$2(ColumnDef cd$1, StructField field) {
        String string = field.name();
        String string2 = cd$1.label();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$makeColumnsString$1(StructType requiredSchema$1, ColumnDef cd) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema$1.fields())).exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SchemaTools.$anonfun$makeColumnsString$2(cd, field)));
    }

    private final Function1 castToVarchar$1() {
        return (Function1 & Serializable & scala.Serializable)colName -> new StringBuilder(13).append((String)colName).append("::varchar AS ").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes((String)colName)).toString();
    }

    private static final String castToArray$1(ColumnDef colInfo) {
        String string;
        String colName = colInfo.label();
        Option option = colInfo.childDefinitions().headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            ColumnDef element = (ColumnDef)some.value();
            string = new StringBuilder(15).append("(").append(colName).append("::ARRAY[").append(element.colTypeName()).append("]) as ").append(colName).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(22).append("(").append(colName).append("::ARRAY[UNKNOWN]) as ").append(colName).toString();
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$checkMapColumnsSchema$1(StructField x$6) {
        return x$6.dataType() instanceof MapType;
    }

    public static final /* synthetic */ void $anonfun$checkMapColumnsSchema$5(List x$8) {
    }

    public SchemaTools() {
        this.unknown = "UNKNOWN";
        this.com$vertica$spark$util$schema$SchemaTools$$maxlength = "maxlength";
        this.com$vertica$spark$util$schema$SchemaTools$$longlength = 65000;
    }

    public class ColumnInfoQueryData
    implements Product,
    scala.Serializable {
        private final String tableName;
        private final String dbSchema;
        private final String emptyQuery;
        public final /* synthetic */ SchemaTools $outer;

        public String tableName() {
            return this.tableName;
        }

        public String dbSchema() {
            return this.dbSchema;
        }

        public String emptyQuery() {
            return this.emptyQuery;
        }

        public ColumnInfoQueryData copy(String tableName, String dbSchema, String emptyQuery) {
            return new ColumnInfoQueryData(this.com$vertica$spark$util$schema$SchemaTools$ColumnInfoQueryData$$$outer(), tableName, dbSchema, emptyQuery);
        }

        public String copy$default$1() {
            return this.tableName();
        }

        public String copy$default$2() {
            return this.dbSchema();
        }

        public String copy$default$3() {
            return this.emptyQuery();
        }

        public String productPrefix() {
            return "ColumnInfoQueryData";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = this.tableName();
                    break;
                }
                case 1: {
                    string = this.dbSchema();
                    break;
                }
                case 2: {
                    string = this.emptyQuery();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return string;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ColumnInfoQueryData;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ColumnInfoQueryData)) return false;
            if (((ColumnInfoQueryData)object).com$vertica$spark$util$schema$SchemaTools$ColumnInfoQueryData$$$outer() != this.com$vertica$spark$util$schema$SchemaTools$ColumnInfoQueryData$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ColumnInfoQueryData columnInfoQueryData = (ColumnInfoQueryData)x$1;
            String string = this.tableName();
            String string2 = columnInfoQueryData.tableName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.dbSchema();
            String string4 = columnInfoQueryData.dbSchema();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.emptyQuery();
            String string6 = columnInfoQueryData.emptyQuery();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (!columnInfoQueryData.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ SchemaTools com$vertica$spark$util$schema$SchemaTools$ColumnInfoQueryData$$$outer() {
            return this.$outer;
        }

        public ColumnInfoQueryData(SchemaTools $outer, String tableName, String dbSchema, String emptyQuery) {
            this.tableName = tableName;
            this.dbSchema = dbSchema;
            this.emptyQuery = emptyQuery;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

