/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.fs;

import cats.Applicative;
import cats.implicits$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.AWSAuth;
import com.vertica.spark.config.AWSOptions;
import com.vertica.spark.config.FileStoreConfig;
import com.vertica.spark.config.GCSOptions;
import com.vertica.spark.config.GCSServiceAuth;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.SensitiveArg;
import com.vertica.spark.datasource.core.DataBlock;
import com.vertica.spark.datasource.core.ParquetFileRange;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.fs.GCSSparkOptions$;
import com.vertica.spark.datasource.fs.HadoopFileStoreReader;
import com.vertica.spark.datasource.fs.ParquetFileMetadata;
import com.vertica.spark.util.error.CloseWriteError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.CreateDirectoryAlreadyExistsError;
import com.vertica.spark.util.error.CreateDirectoryError;
import com.vertica.spark.util.error.CreateFileAlreadyExistsError;
import com.vertica.spark.util.error.CreateFileError;
import com.vertica.spark.util.error.FileListError;
import com.vertica.spark.util.error.FileStoreThrownError;
import com.vertica.spark.util.error.IntermediaryStoreReaderNotInitializedError;
import com.vertica.spark.util.error.IntermediaryStoreWriteError;
import com.vertica.spark.util.error.IntermediaryStoreWriterNotInitializedError;
import com.vertica.spark.util.error.MissingHDFSImpersonationTokenError;
import com.vertica.spark.util.error.OpenReadError;
import com.vertica.spark.util.error.OpenWriteError;
import com.vertica.spark.util.error.RemoveDirectoryError;
import com.vertica.spark.util.error.RemoveFileError;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.vertica.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.vertica.ParquetReadSupport$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r5c\u0001\u0002#F\u0001AC\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\tE\u0002\u0011\t\u0011)A\u0005G\")1\u000f\u0001C\u0001i\"9\u0001\u0010\u0001b\u0001\n\u0013I\bbBA\u0006\u0001\u0001\u0006IA\u001f\u0005\t\u0003\u001b\u0001!\u0019!C\u0005s\"9\u0011q\u0002\u0001!\u0002\u0013Q\b\u0002CA\t\u0001\t\u0007I\u0011B=\t\u000f\u0005M\u0001\u0001)A\u0005u\"A\u0011Q\u0003\u0001C\u0002\u0013%\u0011\u0010C\u0004\u0002\u0018\u0001\u0001\u000b\u0011\u0002>\t\u0011\u0005e\u0001A1A\u0005\neDq!a\u0007\u0001A\u0003%!\u0010\u0003\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0003z\u0011\u001d\ty\u0002\u0001Q\u0001\niD\u0001\"!\t\u0001\u0005\u0004%I!\u001f\u0005\b\u0003G\u0001\u0001\u0015!\u0003{\u0011%\t)\u0003\u0001b\u0001\n\u0003\t9\u0003\u0003\u0005\u0002:\u0001\u0001\u000b\u0011BA\u0015\u0011%\tY\u0004\u0001b\u0001\n\u0013\ti\u0004\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA \u0011%\t\t\u0006\u0001b\u0001\n\u0013\ti\u0004\u0003\u0005\u0002T\u0001\u0001\u000b\u0011BA \u0011%\t)\u0006\u0001b\u0001\n\u0013\ti\u0004\u0003\u0005\u0002X\u0001\u0001\u000b\u0011BA \u0011%\tI\u0006\u0001b\u0001\n\u0013\tY\u0006\u0003\u0005\u0002l\u0001\u0001\u000b\u0011BA/\u0011%\ti\u0007\u0001b\u0001\n\u0013\tY\u0006\u0003\u0005\u0002p\u0001\u0001\u000b\u0011BA/\u0011%\t\t\b\u0001b\u0001\n\u0013\tY\u0006\u0003\u0005\u0002t\u0001\u0001\u000b\u0011BA/\u0011%\t)\b\u0001a\u0001\n\u0013\t9\bC\u0005\u0002\u0016\u0002\u0001\r\u0011\"\u0003\u0002\u0018\"A\u00111\u0015\u0001!B\u0013\tI\bC\u0005\u0002&\u0002\u0001\r\u0011\"\u0003\u0002(\"I\u0011\u0011\u0017\u0001A\u0002\u0013%\u00111\u0017\u0005\t\u0003o\u0003\u0001\u0015)\u0003\u0002*\"I\u0011\u0011\u0018\u0001C\u0002\u0013\u0005\u00111\u0018\u0005\t\u0003\u0013\u0004\u0001\u0015!\u0003\u0002>\"I\u00111\u001a\u0001C\u0002\u0013%\u0011Q\u001a\u0005\t\u0003+\u0004\u0001\u0015!\u0003\u0002P\"I\u0011q\u001b\u0001C\u0002\u0013%\u0011\u0011\u001c\u0005\t\u0003C\u0004\u0001\u0015!\u0003\u0002\\\u001a1\u00111\u001d\u0001\u0005\u0003KD!\"!?-\u0005\u0003\u0005\u000b\u0011BA~\u0011\u0019\u0019H\u0006\"\u0001\u0003\u0006!9!\u0011\u0002\u0017\u0005R\t-\u0001b\u0002B\u0007Y\u0011E!q\u0002\u0005\b\u0005K\u0001A\u0011\u0001B\u0014\u0011\u001d\u00119\u0006\u0001C!\u00053BqAa\u001b\u0001\t\u0003\u0012i\u0007C\u0004\u0003p\u0001!IA!\u001d\t\u000f\t\u001d\u0006\u0001\"\u0011\u0003*\"9!Q\u0017\u0001\u0005B\t]\u0006b\u0002Ba\u0001\u0011\u0005#1\u0019\u0005\b\u0005#\u0004A\u0011\tB7\u0011\u001d\u0011\u0019\u000e\u0001C!\u0005+DqA!<\u0001\t\u0003\u0012y\u000fC\u0004\u0003t\u0002!\tE!>\t\u000f\te\b\u0001\"\u0011\u0003|\"9!q \u0001\u0005B\r\u0005\u0001bBB\u0005\u0001\u0011\u000511\u0002\u0005\b\u0007/\u0001A\u0011IB\r\u0011\u001d\u0019\t\u0003\u0001C!\u0007GAqa!\u000b\u0001\t\u0003\ni\rC\u0004\u0004,\u0001!\t%!7\t\u000f\r5\u0002\u0001\"\u0003\u00040\t!\u0002*\u00193p_B4\u0015\u000e\\3Ti>\u0014X\rT1zKJT!AR$\u0002\u0005\u0019\u001c(B\u0001%J\u0003)!\u0017\r^1t_V\u00148-\u001a\u0006\u0003\u0015.\u000bQa\u001d9be.T!\u0001T'\u0002\u000fY,'\u000f^5dC*\ta*A\u0002d_6\u001c\u0001aE\u0002\u0001#^\u0003\"AU+\u000e\u0003MS\u0011\u0001V\u0001\u0006g\u000e\fG.Y\u0005\u0003-N\u0013a!\u00118z%\u00164\u0007C\u0001-Z\u001b\u0005)\u0015B\u0001.F\u0005]1\u0015\u000e\\3Ti>\u0014X\rT1zKJLe\u000e^3sM\u0006\u001cW-A\bgS2,7\u000b^8sK\u000e{gNZ5h!\ti\u0006-D\u0001_\u0015\ty\u0016*\u0001\u0004d_:4\u0017nZ\u0005\u0003Cz\u0013qBR5mKN#xN]3D_:4\u0017nZ\u0001\u0007g\u000eDW-\\1\u0011\u0007I#g-\u0003\u0002f'\n1q\n\u001d;j_:\u0004\"aZ9\u000e\u0003!T!!\u001b6\u0002\u000bQL\b/Z:\u000b\u0005-d\u0017aA:rY*\u0011!*\u001c\u0006\u0003]>\fa!\u00199bG\",'\"\u00019\u0002\u0007=\u0014x-\u0003\u0002sQ\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\rqJg.\u001b;?)\r)ho\u001e\t\u00031\u0002AQaW\u0002A\u0002qCQAY\u0002A\u0002\r\fQbU\u001a`\u0003\u000e\u001bUiU*`\u0017\u0016KV#\u0001>\u0011\u0007m\f)AD\u0002}\u0003\u0003\u0001\"!`*\u000e\u0003yT!a`(\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019aU\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0011\u0011\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\r1+\u0001\bTg}\u000b5iQ#T'~[U)\u0017\u0011\u0002\u001bM\u001btlU#D%\u0016#vlS#Z\u00039\u00196gX*F\u0007J+EkX&F3\u0002\n\u0001cU\u001a`'\u0016\u001b6+S(O?R{5*\u0012(\u0002#M\u001btlU#T'&{ej\u0018+P\u0017\u0016s\u0005%\u0001\rB/N{6IU#E\u000b:#\u0016*\u0011'T?B\u0013vJV%E\u000bJ\u000b\u0011$Q,T?\u000e\u0013V\tR#O)&\u000bEjU0Q%>3\u0016\nR#SA\u0005Y1kM0F\u001d\u0012\u0003v*\u0013(U\u00031\u00196gX#O\tB{\u0015J\u0014+!\u00035\u00196gX#O\u0003\ncUiX*T\u0019\u0006q1kM0F\u001d\u0006\u0013E*R0T'2\u0003\u0013\u0001F*4?\u0016s\u0015I\u0011'F?B\u000bE\u000bS0T)fcU)A\u000bTg}+e*\u0011\"M\u000b~\u0003\u0016\t\u0016%`'RKF*\u0012\u0011\u0002\r1|wmZ3s+\t\tI\u0003\u0005\u0003\u0002,\u0005URBAA\u0017\u0015\u0011\ty#!\r\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0007\u0005MR*\u0001\u0005usB,7/\u00194f\u0013\u0011\t9$!\f\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nQdV#C\u0011\u001235k\u0018#F\u0019\u0016;\u0015\tV%P\u001d~#vjS#O?R+\u0005\fV\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0002j_*\u0019\u0011\u0011J7\u0002\r!\fGm\\8q\u0013\u0011\ti%a\u0011\u0003\tQ+\u0007\u0010^\u0001\u001f/\u0016\u0013\u0005\n\u0012$T?\u0012+E*R$B)&{ej\u0018+P\u0017\u0016su\fV#Y)\u0002\nadU,F\u0005\"#eiU0E\u000b2+u)\u0011+J\u001f:{FkT&F\u001d~#V\t\u0017+\u0002?M;VI\u0011%E\rN{F)\u0012'F\u000f\u0006#\u0016j\u0014(`)>[UIT0U\u000bb#\u0006%\u0001\u000eI\t\u001a\u001bv\fR#M\u000b\u001e\u000bE+S(O?R{5*\u0012(`)\u0016CF+A\u000eI\t\u001a\u001bv\fR#M\u000b\u001e\u000bE+S(O?R{5*\u0012(`)\u0016CF\u000bI\u0001$\u0019\u0016;\u0015iQ-`!\u0006\u0013\u0016+V#U?J+%)Q*F?6{E)R0J\u001d~;&+\u0013+F+\t\ti\u0006\u0005\u0003\u0002`\u0005%TBAA1\u0015\u0011\t\u0019'!\u001a\u0002\t1\fgn\u001a\u0006\u0003\u0003O\nAA[1wC&!\u0011qAA1\u0003\u0011bUiR!D3~\u0003\u0016IU)V\u000bR{&+\u0012\"B'\u0016{Vj\u0014#F?&sul\u0016*J)\u0016\u0003\u0013A\t'F\u000f\u0006\u001b\u0015l\u0018)B%F+V\tV0S\u000b\n\u000b5+R0N\u001f\u0012+u,\u0013(`%\u0016\u000bE)A\u0012M\u000b\u001e\u000b5)W0Q\u0003J\u000bV+\u0012+`%\u0016\u0013\u0015iU#`\u001b>#UiX%O?J+\u0015\t\u0012\u0011\u0002S1+u)Q\"Z?B\u000b%+U+F)~Ke\nV\u001d7?J+%)Q*F?6{E)R0J\u001d~;&+\u0013+F\u0003)bUiR!D3~\u0003\u0016IU)V\u000bR{\u0016J\u0014+:m}\u0013VIQ!T\u000b~ku\nR#`\u0013:{vKU%U\u000b\u0002\naa\u001e:ji\u0016\u0014XCAA=!\u0011\u0011F-a\u001f\u0011\r\u0005u\u0014QQAE\u001b\t\tyH\u0003\u0003\u0002J\u0005\u0005%bAAB[\u00069\u0001/\u0019:rk\u0016$\u0018\u0002BAD\u0003\u007f\u0012Q\u0002U1scV,Go\u0016:ji\u0016\u0014\b\u0003BAF\u0003#k!!!$\u000b\u0007\u0005=%.\u0001\u0005dCR\fG._:u\u0013\u0011\t\u0019*!$\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u000boJLG/\u001a:`I\u0015\fH\u0003BAM\u0003?\u00032AUAN\u0013\r\tij\u0015\u0002\u0005+:LG\u000fC\u0005\u0002\"\u0006\n\t\u00111\u0001\u0002z\u0005\u0019\u0001\u0010J\u0019\u0002\u000f]\u0014\u0018\u000e^3sA\u00051!/Z1eKJ,\"!!+\u0011\tI#\u00171\u0016\t\u00041\u00065\u0016bAAX\u000b\n)\u0002*\u00193p_B4\u0015\u000e\\3Ti>\u0014XMU3bI\u0016\u0014\u0018A\u0003:fC\u0012,'o\u0018\u0013fcR!\u0011\u0011TA[\u0011%\t\t\u000bJA\u0001\u0002\u0004\tI+A\u0004sK\u0006$WM\u001d\u0011\u0002\u0015!$gm]\"p]\u001aLw-\u0006\u0002\u0002>B!\u0011qXAc\u001b\t\t\tM\u0003\u0003\u0002D\u0006\u001d\u0013\u0001B2p]\u001aLA!a2\u0002B\ni1i\u001c8gS\u001e,(/\u0019;j_:\f1\u0002\u001b3gg\u000e{gNZ5hA\u0005Q\u0011m^:PaRLwN\\:\u0016\u0005\u0005=\u0007cA/\u0002R&\u0019\u00111\u001b0\u0003\u0015\u0005;6k\u00149uS>t7/A\u0006boN|\u0005\u000f^5p]N\u0004\u0013AC4dg>\u0003H/[8ogV\u0011\u00111\u001c\t\u0004;\u0006u\u0017bAAp=\nQqiQ*PaRLwN\\:\u0002\u0017\u001d\u001c7o\u00149uS>t7\u000f\t\u0002\u0016-\u0016\u0014H/[2b!\u0006\u0014\u0018/^3u\u0005VLG\u000eZ3s'\ra\u0013q\u001d\t\t\u0003S\fy/!#\u0002v:!\u0011QPAv\u0013\u0011\ti/a \u0002\u001bA\u000b'/];fi^\u0013\u0018\u000e^3s\u0013\u0011\t\t0a=\u0003\u000f\t+\u0018\u000e\u001c3fe*!\u0011Q^A@!\r\t9\u0010L\u0007\u0002\u0001\u0005!a-\u001b7f!\u0011\tiP!\u0001\u000e\u0005\u0005}(b\u0001$\u0002H%!!1AA\u0000\u0005\u0011\u0001\u0016\r\u001e5\u0015\t\u0005U(q\u0001\u0005\b\u0003st\u0003\u0019AA~\u0003\u0011\u0019X\r\u001c4\u0015\u0005\u0005U\u0018aD4fi^\u0013\u0018\u000e^3TkB\u0004xN\u001d;\u0015\t\tE!1\u0005\t\u0005\u0005'\u0011y\"\u0004\u0002\u0003\u0016)!\u00111\u0011B\f\u0015\u0011\u0011IBa\u0007\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0004\u0005;Q\u0017!C3yK\u000e,H/[8o\u0013\u0011\u0011\tC!\u0006\u0003'A\u000b'/];fi^\u0013\u0018\u000e^3TkB\u0004xN\u001d;\t\u000f\u0005\r\u0007\u00071\u0001\u0002>\u0006!r\u000e]3o/JLG/\u001a)beF,X\r\u001e$jY\u0016$BA!\u000b\u0003TA1!1\u0006B'\u00033sAA!\f\u0003H9!!q\u0006B!\u001d\u0011\u0011\tD!\u0010\u000f\t\tM\"1\b\b\u0005\u0005k\u0011IDD\u0002~\u0005oI\u0011AT\u0005\u0003\u00196K!AS&\n\u0007\t}\u0012*\u0001\u0003vi&d\u0017\u0002\u0002B\"\u0005\u000b\nQ!\u001a:s_JT1Aa\u0010J\u0013\u0011\u0011IEa\u0013\u0002\u001b\u0015\u0013(o\u001c:IC:$G.\u001b8h\u0015\u0011\u0011\u0019E!\u0012\n\t\t=#\u0011\u000b\u0002\u0010\u0007>tg.Z2u_J\u0014Vm];mi*!!\u0011\nB&\u0011\u0019\u0011)&\ra\u0001u\u0006Aa-\u001b7f]\u0006lW-\u0001\fxe&$X\rR1uCR{\u0007+\u0019:rk\u0016$h)\u001b7f)\u0011\u0011ICa\u0017\t\u000f\tu#\u00071\u0001\u0003`\u0005IA-\u0019;b\u00052|7m\u001b\t\u0005\u0005C\u00129'\u0004\u0002\u0003d)\u0019!QM$\u0002\t\r|'/Z\u0005\u0005\u0005S\u0012\u0019GA\u0005ECR\f'\t\\8dW\u0006)2\r\\8tK^\u0013\u0018\u000e^3QCJ\fX/\u001a;GS2,GC\u0001B\u0015\u00035!xnU3u\u001bVdG/['baV1!1\u000fBB\u0005;#BA!\u001e\u0003\"BA!q\u000fB>\u0005\u007f\u0012)*\u0004\u0002\u0003z)!!qHA3\u0013\u0011\u0011iH!\u001f\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0003\u0002\n\rE\u0002\u0001\u0003\b\u0005\u000b#$\u0019\u0001BD\u0005\u0005Y\u0015\u0003\u0002BE\u0005\u001f\u00032A\u0015BF\u0013\r\u0011ii\u0015\u0002\b\u001d>$\b.\u001b8h!\r\u0011&\u0011S\u0005\u0004\u0005'\u001b&aA!osB1!q\u000fBL\u00057KAA!'\u0003z\t\u00191+\u001a;\u0011\t\t\u0005%Q\u0014\u0003\b\u0005?#$\u0019\u0001BD\u0005\u00051\u0006b\u0002BRi\u0001\u0007!QU\u0001\u0004[\u0006\u0004\b\u0003\u0003B<\u0005w\u0012yHa'\u0002-\u001d,G\u000fU1scV,GOR5mK6+G/\u00193bi\u0006$BAa+\u00034B1!1\u0006B'\u0005[\u00032\u0001\u0017BX\u0013\r\u0011\t,\u0012\u0002\u0014!\u0006\u0014\u0018/^3u\r&dW-T3uC\u0012\fG/\u0019\u0005\u0007\u0005+*\u0004\u0019\u0001>\u0002'=\u0004XM\u001c*fC\u0012\u0004\u0016M]9vKR4\u0015\u000e\\3\u0015\t\t%\"\u0011\u0018\u0005\b\u0003s4\u0004\u0019\u0001B^!\u0011\u0011\tG!0\n\t\t}&1\r\u0002\u0011!\u0006\u0014\u0018/^3u\r&dWMU1oO\u0016\fqC]3bI\u0012\u000bG/\u0019$s_6\u0004\u0016M]9vKR4\u0015\u000e\\3\u0015\t\t\u0015'q\u0019\t\u0007\u0005W\u0011iEa\u0018\t\u000f\t%w\u00071\u0001\u0003L\u0006I!\r\\8dWNK'0\u001a\t\u0004%\n5\u0017b\u0001Bh'\n\u0019\u0011J\u001c;\u0002)\rdwn]3SK\u0006$\u0007+\u0019:rk\u0016$h)\u001b7f\u0003-9W\r\u001e$jY\u0016d\u0015n\u001d;\u0015\t\t]'1\u001e\t\u0007\u0005W\u0011iE!7\u0011\u000b\tm'Q\u001d>\u000f\t\tu'\u0011\u001d\b\u0004{\n}\u0017\"\u0001+\n\u0007\t\r8+A\u0004qC\u000e\\\u0017mZ3\n\t\t\u001d(\u0011\u001e\u0002\u0004'\u0016\f(b\u0001Br'\"1!QK\u001dA\u0002i\f!B]3n_Z,g)\u001b7f)\u0011\u0011IC!=\t\r\tU#\b1\u0001{\u0003%\u0011X-\\8wK\u0012K'\u000f\u0006\u0003\u0003*\t]\bB\u0002B+w\u0001\u0007!0\u0001\u0006de\u0016\fG/\u001a$jY\u0016$BA!\u000b\u0003~\"1!Q\u000b\u001fA\u0002i\f\u0011b\u0019:fCR,G)\u001b:\u0015\r\t%21AB\u0003\u0011\u0019\u0011)&\u0010a\u0001u\"11qA\u001fA\u0002i\f!\u0002]3s[&\u001c8/[8o\u0003)1\u0017\u000e\\3Fq&\u001cHo\u001d\u000b\u0005\u0007\u001b\u0019)\u0002\u0005\u0004\u0003,\t53q\u0002\t\u0004%\u000eE\u0011bAB\n'\n9!i\\8mK\u0006t\u0007B\u0002B+}\u0001\u0007!0A\u000bhKRLU\u000e]3sg>t\u0017\r^5p]R{7.\u001a8\u0015\t\rm1Q\u0004\t\u0006\u0005W\u0011iE\u001f\u0005\u0007\u0007?y\u0004\u0019\u0001>\u0002\tU\u001cXM]\u0001\u000eO\u0016$x\t\\8c'R\fG/^:\u0015\t\t]7Q\u0005\u0005\u0007\u0007O\u0001\u0005\u0019\u0001>\u0002\u000fA\fG\u000f^3s]\u0006iq-\u001a;B/N{\u0005\u000f^5p]N\fQbZ3u\u000f\u000e\u001bv\n\u001d;j_:\u001c\u0018!D;tK\u001aKG.Z*zgR,W.\u0006\u0003\u00042\r]BCBB\u001a\u0007w\u0019i\u0004\u0005\u0004\u0003,\t53Q\u0007\t\u0005\u0005\u0003\u001b9\u0004B\u0004\u0004:\r\u0013\rAa\"\u0003\u0003QCaA!\u0016D\u0001\u0004Q\bbBB \u0007\u0002\u00071\u0011I\u0001\tMN\f5\r^5p]BI!ka\u0011\u0004H\u0005m81G\u0005\u0004\u0007\u000b\u001a&!\u0003$v]\u000e$\u0018n\u001c83!\u0011\tip!\u0013\n\t\r-\u0013q \u0002\u000b\r&dWmU=ti\u0016l\u0007")
public class HadoopFileStoreLayer
implements FileStoreLayerInterface {
    private final FileStoreConfig fileStoreConfig;
    private final String S3_ACCESS_KEY;
    private final String S3_SECRET_KEY;
    private final String S3_SESSION_TOKEN;
    private final String AWS_CREDENTIALS_PROVIDER;
    private final String S3_ENDPOINT;
    private final String S3_ENABLE_SSL;
    private final String S3_ENABLE_PATH_STYLE;
    private final Logger logger;
    private final Text WEBHDFS_DELEGATION_TOKEN_TEXT;
    private final Text SWEBHDFS_DELEGATION_TOKEN_TEXT;
    private final Text HDFS_DELEGATION_TOKEN_TEXT;
    private final String LEGACY_PARQUET_REBASE_MODE_IN_WRITE;
    private final String LEGACY_PARQUET_REBASE_MODE_IN_READ;
    private final String LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE;
    private Option<ParquetWriter<InternalRow>> writer;
    private Option<HadoopFileStoreReader> reader;
    private final Configuration hdfsConfig;
    private final AWSOptions awsOptions;
    private final GCSOptions gcsOptions;

    private String S3_ACCESS_KEY() {
        return this.S3_ACCESS_KEY;
    }

    private String S3_SECRET_KEY() {
        return this.S3_SECRET_KEY;
    }

    private String S3_SESSION_TOKEN() {
        return this.S3_SESSION_TOKEN;
    }

    private String AWS_CREDENTIALS_PROVIDER() {
        return this.AWS_CREDENTIALS_PROVIDER;
    }

    private String S3_ENDPOINT() {
        return this.S3_ENDPOINT;
    }

    private String S3_ENABLE_SSL() {
        return this.S3_ENABLE_SSL;
    }

    private String S3_ENABLE_PATH_STYLE() {
        return this.S3_ENABLE_PATH_STYLE;
    }

    public Logger logger() {
        return this.logger;
    }

    private Text WEBHDFS_DELEGATION_TOKEN_TEXT() {
        return this.WEBHDFS_DELEGATION_TOKEN_TEXT;
    }

    private Text SWEBHDFS_DELEGATION_TOKEN_TEXT() {
        return this.SWEBHDFS_DELEGATION_TOKEN_TEXT;
    }

    private Text HDFS_DELEGATION_TOKEN_TEXT() {
        return this.HDFS_DELEGATION_TOKEN_TEXT;
    }

    private String LEGACY_PARQUET_REBASE_MODE_IN_WRITE() {
        return this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE;
    }

    private String LEGACY_PARQUET_REBASE_MODE_IN_READ() {
        return this.LEGACY_PARQUET_REBASE_MODE_IN_READ;
    }

    private String LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE() {
        return this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE;
    }

    private Option<ParquetWriter<InternalRow>> writer() {
        return this.writer;
    }

    private void writer_$eq(Option<ParquetWriter<InternalRow>> x$1) {
        this.writer = x$1;
    }

    private Option<HadoopFileStoreReader> reader() {
        return this.reader;
    }

    private void reader_$eq(Option<HadoopFileStoreReader> x$1) {
        this.reader = x$1;
    }

    public Configuration hdfsConfig() {
        return this.hdfsConfig;
    }

    private AWSOptions awsOptions() {
        return this.awsOptions;
    }

    private GCSOptions gcsOptions() {
        return this.gcsOptions;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> openWriteParquetFile(String filename) {
        Left left;
        Either writerOrError;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(23).append("Opening write to file: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        VerticaParquetBuilder builder = new VerticaParquetBuilder(new Path(String.valueOf(filename)));
        Either either = writerOrError = this.removeFile(filename).flatMap((Function1 & Serializable & scala.Serializable)_ -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> builder.withConf(this.hdfsConfig()).withWriteMode(ParquetFileWriter.Mode.OVERWRITE).withCompressionCodec(CompressionCodecName.SNAPPY).build()).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new OpenWriteError((Throwable)exception).context("Error opening write to HDFS.")).map((Function1 & Serializable & scala.Serializable)writer -> writer));
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            ParquetWriter writer = (ParquetWriter)right.value();
            this.writer_$eq((Option<ParquetWriter<InternalRow>>)new Some((Object)writer));
            left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> writeDataToParquetFile(DataBlock dataBlock) {
        Right right;
        Option<ParquetWriter<InternalRow>> option = this.writer();
        if (option instanceof Some) {
            Some some = (Some)option;
            ParquetWriter reader = (ParquetWriter)some.value();
            right = package$.MODULE$.Right().apply((Object)reader);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreWriterNotInitializedError().context("Error writing parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return right.flatMap((Function1 & Serializable & scala.Serializable)writer -> ((Either)implicits$.MODULE$.toTraverseOps(dataBlock.data(), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)record -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writer.write(record)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new IntermediaryStoreWriteError((Throwable)exception).context("Error writing parquet file to HDFS.")), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable & scala.Serializable)_ -> {
            HadoopFileStoreLayer.$anonfun$writeDataToParquetFile$5(_);
            return BoxedUnit.UNIT;
        }));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> closeWriteParquetFile() {
        Right right;
        Option<ParquetWriter<InternalRow>> option = this.writer();
        if (option instanceof Some) {
            Some some = (Some)option;
            ParquetWriter reader = (ParquetWriter)some.value();
            right = package$.MODULE$.Right().apply((Object)reader);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreWriterNotInitializedError().context("Error closing write of parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return right.flatMap((Function1 & Serializable & scala.Serializable)writer -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writer.close()).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new CloseWriteError((Throwable)exception).context("Error closing write of parquet file to HDFS.")).map((Function1 & Serializable & scala.Serializable)_ -> {
            HadoopFileStoreLayer.$anonfun$closeWriteParquetFile$4(_);
            return BoxedUnit.UNIT;
        }));
    }

    private <K, V> Map<K, Set<V>> toSetMultiMap(Map<K, V> map) {
        HashMap setMultiMap = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(map.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> setMultiMap.put(entry.getKey(), Collections.singleton(entry.getValue())));
        return Collections.unmodifiableMap(setMultiMap);
    }

    @Override
    public Either<ConnectorError, ParquetFileMetadata> getParquetFileMetadata(String filename) {
        Path path = new Path(String.valueOf(filename));
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)path, (Configuration)this.hdfsConfig());
            ParquetFileReader reader = ParquetFileReader.open((InputFile)inputFile);
            int rowGroupCount = reader.getRowGroups().size();
            reader.close();
            return new ParquetFileMetadata(filename, rowGroupCount);
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new FileListError((Throwable)exception).context(new StringBuilder(33).append("Error getting metadata for file ").append(filename).append(".").toString()));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> openReadParquetFile(ParquetFileRange file) {
        Left left;
        Either readerOrError;
        BoxedUnit boxedUnit;
        String filename = file.filename();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(24).append("Opening read from file: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ParquetReadSupport readSupport = new ParquetReadSupport((Option<ZoneId>)None$.MODULE$, false, SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED(), SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED());
        Either either = readerOrError = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Path path = new Path(String.valueOf(filename));
            HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)path, (Configuration)this.hdfsConfig());
            ParquetFileReader fileReader = ParquetFileReader.open((InputFile)inputFile);
            FileMetaData parquetFileMetadata = fileReader.getFooter().getFileMetaData();
            MessageType fileSchema = parquetFileMetadata.getSchema();
            Map fileMetadata = parquetFileMetadata.getKeyValueMetaData();
            ReadSupport.ReadContext readContext = readSupport.init(new InitContext(this.hdfsConfig(), this.toSetMultiMap(fileMetadata), fileSchema));
            RecordMaterializer<InternalRow> recordConverter = readSupport.prepareForRead(this.hdfsConfig(), fileMetadata, fileSchema, readContext);
            MessageType requestedSchema = readContext.getRequestedSchema();
            fileReader.setRequestedSchema(requestedSchema);
            ColumnIOFactory columnIOFactory = new ColumnIOFactory(parquetFileMetadata.getCreatedBy());
            boolean strictTypeChecking = false;
            MessageColumnIO columnIO = columnIOFactory.getColumnIO(requestedSchema, fileSchema, strictTypeChecking);
            return new HadoopFileStoreReader(fileReader, columnIO, recordConverter, file);
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new OpenReadError((Throwable)exception).context("Error creating Parquet Reader"));
        if (either instanceof Right) {
            Right right = (Right)either;
            HadoopFileStoreReader reader = (HadoopFileStoreReader)right.value();
            this.reader_$eq((Option<HadoopFileStoreReader>)new Some((Object)reader));
            left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, DataBlock> readDataFromParquetFile(int blockSize) {
        Right right;
        Option<HadoopFileStoreReader> option = this.reader();
        if (option instanceof Some) {
            Some some = (Some)option;
            HadoopFileStoreReader reader2 = (HadoopFileStoreReader)some.value();
            right = package$.MODULE$.Right().apply((Object)reader2);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreReaderNotInitializedError().context("Error reading parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return right.flatMap((Function1 & Serializable & scala.Serializable)reader -> reader.read(blockSize).map((Function1 & Serializable & scala.Serializable)dataBlock -> dataBlock)).map((Function1 & Serializable & scala.Serializable)dataBlock -> dataBlock);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Either<ConnectorError, BoxedUnit> closeReadParquetFile() {
        void var2_5;
        Right right;
        Option<HadoopFileStoreReader> option = this.reader();
        if (option instanceof Some) {
            Some some = (Some)option;
            HadoopFileStoreReader reader2 = (HadoopFileStoreReader)some.value();
            right = package$.MODULE$.Right().apply((Object)reader2);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreReaderNotInitializedError().context("Error closing read of parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        Either r = right.flatMap((Function1 & Serializable & scala.Serializable)reader -> reader.close().map((Function1 & Serializable & scala.Serializable)_ -> {
            HadoopFileStoreLayer.$anonfun$closeReadParquetFile$2(_);
            return BoxedUnit.UNIT;
        }));
        this.reader_$eq((Option<HadoopFileStoreReader>)None$.MODULE$);
        return var2_5;
    }

    @Override
    public Either<ConnectorError, Seq<String>> getFileList(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> {
            Left left;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> fs.listStatus(path));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                FileStatus[] fileStatuses = (FileStatus[])success.value();
                left = package$.MODULE$.Right().apply((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatuses)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                left = package$.MODULE$.Left().apply((Object)new FileListError(exception).context("Error getting file list from HDFS."));
            } else {
                throw new MatchError((Object)try_);
            }
            return left;
        });
    }

    @Override
    public Either<ConnectorError, BoxedUnit> removeFile(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> fs.exists(path) ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.delete(path, true)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new RemoveFileError((Path)path, (Throwable)exception).context("Error removing HDFS file.")) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> removeDir(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> fs.exists(path) ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.delete(path, true)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new RemoveDirectoryError((Path)path, (Throwable)exception).context("Error removing HDFS directory.")) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createFile(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> !fs.exists(path) ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FSDataOutputStream stream = fs.create(path);
            stream.write(0);
            stream.close();
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new CreateFileError((Path)path, (Throwable)exception).context("Error creating HDFS file.")) : package$.MODULE$.Left().apply((Object)new CreateFileAlreadyExistsError(filename)));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createDir(String filename, String permission) {
        FsPermission perms = new FsPermission(permission);
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> {
            Left left;
            if (!fs.exists(path)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(31).append("Making path ").append(path).append(" with permissions: ").append(perms.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                left = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.mkdirs(path, perms)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new CreateDirectoryError((Path)path, (Throwable)exception).context("Error creating HDFS directory."));
            } else {
                left = package$.MODULE$.Left().apply((Object)new CreateDirectoryAlreadyExistsError(filename));
            }
            return left;
        });
    }

    @Override
    public Either<ConnectorError, Object> fileExists(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)fs.exists(path))));
    }

    @Override
    public Either<ConnectorError, String> getImpersonationToken(String user) {
        Right right;
        ObjectRef hdfsToken = ObjectRef.create((Object)None$.MODULE$);
        Option ugiUser = Option$.MODULE$.apply((Object)UserGroupInformation.getLoginUser());
        Option option = ugiUser;
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            UserGroupInformation user2 = (UserGroupInformation)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Got UGI user.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Collection existingTokens = user2.getCredentials().getAllTokens();
            for (Token token : existingTokens) {
                BoxedUnit boxedUnit2;
                Text tokenKind = token.getKind();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(21).append("Existing token kind: ").append(tokenKind.toString()).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (!this.WEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.SWEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.HDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind)) continue;
                hdfsToken.elem = new Some((Object)token.encodeToUrlString());
            }
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        this.useFileSystem(this.fileStoreConfig.address(), (Function2 & Serializable & scala.Serializable)(fs, x$3) -> {
            Token[] tokens = fs.addDelegationTokens(user, null);
            for (Token token : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens))) {
                BoxedUnit boxedUnit;
                Text tokenKind = token.getKind();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(31).append("Hadoop impersonation: IT kind: ").append(tokenKind.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (!this.WEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.SWEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.HDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind)) continue;
                hdfsToken$1.elem = new Some((Object)token.encodeToUrlString());
            }
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        });
        Option option2 = (Option)hdfsToken.elem;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String token = (String)some.value();
            right = package$.MODULE$.Right().apply((Object)token);
        } else if (None$.MODULE$.equals(option2)) {
            right = package$.MODULE$.Left().apply((Object)new MissingHDFSImpersonationTokenError(user, this.fileStoreConfig.address()));
        } else {
            throw new MatchError((Object)option2);
        }
        return right;
    }

    @Override
    public Either<ConnectorError, Seq<String>> getGlobStatus(String pattern) {
        return this.useFileSystem(pattern, (Function2 & Serializable & scala.Serializable)(fs, path) -> {
            Left left;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> fs.globStatus(path));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                FileStatus[] fileStatuses = (FileStatus[])success.value();
                left = package$.MODULE$.Right().apply((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatuses)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                left = package$.MODULE$.Left().apply((Object)new FileListError(exception).context("Error getting file list from HDFS."));
            } else {
                throw new MatchError((Object)try_);
            }
            return left;
        });
    }

    @Override
    public AWSOptions getAWSOptions() {
        return this.fileStoreConfig.awsOptions();
    }

    @Override
    public GCSOptions getGCSOptions() {
        return this.fileStoreConfig.gcsOptions();
    }

    private <T> Either<ConnectorError, T> useFileSystem(String filename, Function2<FileSystem, Path, Either<ConnectorError, T>> fsAction) {
        Either either;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(16).append("Filestore path: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Path path = new Path(String.valueOf(filename));
            FileSystem fs = path.getFileSystem(this.hdfsConfig());
            return (Either)fsAction.apply((Object)fs, (Object)path);
        });
        if (try_ instanceof Success) {
            Either value;
            Success success = (Success)try_;
            either = value = (Either)success.value();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            either = package$.MODULE$.Left().apply((Object)new FileStoreThrownError(exception));
        } else {
            throw new MatchError((Object)try_);
        }
        return either;
    }

    public static final /* synthetic */ void $anonfun$writeDataToParquetFile$5(List _) {
    }

    public static final /* synthetic */ void $anonfun$closeWriteParquetFile$4(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$closeReadParquetFile$2(BoxedUnit _) {
    }

    public HadoopFileStoreLayer(FileStoreConfig fileStoreConfig, Option<StructType> schema) {
        this.fileStoreConfig = fileStoreConfig;
        this.S3_ACCESS_KEY = "fs.s3a.access.key";
        this.S3_SECRET_KEY = "fs.s3a.secret.key";
        this.S3_SESSION_TOKEN = "fs.s3a.session.token";
        this.AWS_CREDENTIALS_PROVIDER = "fs.s3a.aws.credentials.provider";
        this.S3_ENDPOINT = "fs.s3a.endpoint";
        this.S3_ENABLE_SSL = "fs.s3a.connection.ssl.enabled";
        this.S3_ENABLE_PATH_STYLE = "fs.s3a.path.style.access";
        this.logger = LogProvider$.MODULE$.getLogger(HadoopFileStoreLayer.class);
        this.WEBHDFS_DELEGATION_TOKEN_TEXT = new Text("WEBHDFS delegation");
        this.SWEBHDFS_DELEGATION_TOKEN_TEXT = new Text("SWEBHDFS delegation");
        this.HDFS_DELEGATION_TOKEN_TEXT = new Text("HDFS_DELEGATION_TOKEN");
        this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE = "spark.sql.legacy.parquet.datetimeRebaseModeInWrite";
        this.LEGACY_PARQUET_REBASE_MODE_IN_READ = "spark.sql.legacy.parquet.datetimeRebaseModeInRead";
        this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE = "spark.sql.legacy.parquet.int96RebaseModeInWrite";
        this.writer = None$.MODULE$;
        this.reader = None$.MODULE$;
        this.hdfsConfig = new Configuration();
        Option<StructType> option = schema;
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            StructType schema2 = (StructType)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(31).append("Read and write support schema: ").append(schema2).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.hdfsConfig().set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), schema2.json());
            this.hdfsConfig().set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), schema2.json());
            ParquetWriteSupport$.MODULE$.setSchema(schema2, this.hdfsConfig());
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        this.awsOptions = fileStoreConfig.awsOptions();
        Option<SensitiveArg<String>> option2 = this.awsOptions().awsCredentialsProvider();
        if (option2 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option2;
            SensitiveArg provider = (SensitiveArg)some.value();
            this.hdfsConfig().set(this.AWS_CREDENTIALS_PROVIDER(), (String)provider.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Setting {}: {}", new Object[]{this.AWS_CREDENTIALS_PROVIDER(), provider});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (None$.MODULE$.equals(option2)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS credentials provider for Hadoop config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else {
            throw new MatchError(option2);
        }
        Option<AWSAuth> option3 = this.awsOptions().awsAuth();
        if (option3 instanceof Some) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit5;
            Some some = (Some)option3;
            AWSAuth auth = (AWSAuth)some.value();
            this.hdfsConfig().set(this.S3_ACCESS_KEY(), auth.accessKeyId().arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ACCESS_KEY(), auth.accessKeyId().origin()});
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            this.hdfsConfig().set(this.S3_SECRET_KEY(), auth.secretAccessKey().arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_SECRET_KEY(), auth.secretAccessKey().origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit;
        } else if (None$.MODULE$.equals(option3)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS auth for Hadoop config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit7 = boxedUnit;
        } else {
            throw new MatchError(option3);
        }
        Option<SensitiveArg<String>> option4 = this.awsOptions().awsSessionToken();
        if (option4 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option4;
            SensitiveArg token = (SensitiveArg)some.value();
            this.hdfsConfig().set(this.S3_SESSION_TOKEN(), (String)token.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_SESSION_TOKEN(), token.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit8 = boxedUnit;
        } else if (None$.MODULE$.equals(option4)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS session token for Hadoop config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit9 = boxedUnit;
        } else {
            throw new MatchError(option4);
        }
        Option<SensitiveArg<String>> option5 = this.awsOptions().awsEndpoint();
        if (option5 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option5;
            SensitiveArg endpoint = (SensitiveArg)some.value();
            this.hdfsConfig().set(this.S3_ENDPOINT(), (String)endpoint.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ENDPOINT(), endpoint.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit10 = boxedUnit;
        } else if (None$.MODULE$.equals(option5)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not set AWS endpoint, using default.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit11 = boxedUnit;
        } else {
            throw new MatchError(option5);
        }
        Option<SensitiveArg<String>> option6 = this.awsOptions().enableSSL();
        if (option6 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option6;
            SensitiveArg enable = (SensitiveArg)some.value();
            this.hdfsConfig().set(this.S3_ENABLE_SSL(), (String)enable.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ENABLE_SSL(), enable.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit12 = boxedUnit;
        } else if (None$.MODULE$.equals(option6)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not set AWS SSL enabled flag, using default of true.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit13 = boxedUnit;
        } else {
            throw new MatchError(option6);
        }
        Option<SensitiveArg<String>> option7 = this.awsOptions().enablePathStyle();
        if (option7 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option7;
            SensitiveArg enable = (SensitiveArg)some.value();
            this.hdfsConfig().set(this.S3_ENABLE_PATH_STYLE(), (String)enable.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ENABLE_PATH_STYLE(), enable.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit14 = boxedUnit;
        } else if (None$.MODULE$.equals(option7)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not set AWS path style enabled flag, using default of false.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit15 = boxedUnit;
        } else {
            throw new MatchError(option7);
        }
        this.gcsOptions = fileStoreConfig.gcsOptions();
        Option<SensitiveArg<String>> option8 = this.gcsOptions().gcsServiceKeyFile();
        if (option8 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option8;
            SensitiveArg auth = (SensitiveArg)some.value();
            this.hdfsConfig().set(GCSSparkOptions$.MODULE$.SERVICE_JSON_KEYFILE(), (String)auth.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{GCSSparkOptions$.MODULE$.SERVICE_JSON_KEYFILE(), auth.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit16 = boxedUnit;
        } else if (None$.MODULE$.equals(option8)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not load GCS key file");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit17 = boxedUnit;
        } else {
            throw new MatchError(option8);
        }
        Option<GCSServiceAuth> option9 = this.gcsOptions().gcsServiceAuth();
        if (option9 instanceof Some) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit18;
            BoxedUnit boxedUnit19;
            Some some = (Some)option9;
            GCSServiceAuth auth = (GCSServiceAuth)some.value();
            this.hdfsConfig().set(GCSSparkOptions$.MODULE$.SERVICE_ACC_KEY_ID(), auth.serviceKeyId().arg());
            this.hdfsConfig().set(GCSSparkOptions$.MODULE$.SERVICE_ACC_KEY(), auth.serviceKeySecret().arg());
            this.hdfsConfig().set(GCSSparkOptions$.MODULE$.SERVICE_ACC_EMAIL(), auth.serviceEmail().arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded Google Cloud Storage service account key id from {}", new Object[]{auth.serviceKeyId().origin()});
                boxedUnit19 = BoxedUnit.UNIT;
            } else {
                boxedUnit19 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded Google Cloud Storage service account key secret from {}", new Object[]{auth.serviceKeySecret().origin()});
                boxedUnit18 = BoxedUnit.UNIT;
            } else {
                boxedUnit18 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded Google Cloud Storage service account key email from {}", new Object[]{auth.serviceEmail().origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit20 = boxedUnit;
        } else if (None$.MODULE$.equals(option9)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not load Google Cloud Storage service account authentications");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit21 = boxedUnit;
        } else {
            throw new MatchError(option9);
        }
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), "false");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), "true");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), "false");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), "INT96");
        this.hdfsConfig().set(this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE(), "CORRECTED");
        this.hdfsConfig().set(this.LEGACY_PARQUET_REBASE_MODE_IN_READ(), "CORRECTED");
        this.hdfsConfig().set(this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE(), "CORRECTED");
        this.hdfsConfig().setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        this.hdfsConfig().set("fs.permissions.umask-mode", "000");
    }

    public class VerticaParquetBuilder
    extends ParquetWriter.Builder<InternalRow, VerticaParquetBuilder> {
        public VerticaParquetBuilder self() {
            return this;
        }

        public ParquetWriteSupport getWriteSupport(Configuration conf) {
            return new ParquetWriteSupport();
        }

        public /* synthetic */ HadoopFileStoreLayer com$vertica$spark$datasource$fs$HadoopFileStoreLayer$VerticaParquetBuilder$$$outer() {
            return HadoopFileStoreLayer.this;
        }

        public VerticaParquetBuilder(Path file) {
            if (HadoopFileStoreLayer.this == null) {
                throw null;
            }
            super(file);
        }
    }
}

