/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.schema;

import cats.Applicative;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.vertica.spark.config.TableSource;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcUtils$;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.ErrorList;
import com.vertica.spark.util.error.MissingSqlConversionError;
import com.vertica.spark.util.schema.ColumnDef;
import com.vertica.spark.util.schema.SchemaTools;
import com.vertica.spark.util.schema.SchemaTools$;
import java.io.Serializable;
import java.sql.ResultSet;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0002\u0004\u0001#!)a\u0003\u0001C\u0001/!)\u0011\u0004\u0001C!5!)\u0011\u000b\u0001C\u0005%\")1\r\u0001C\u0005I\nq1k\u00195f[\u0006$vn\u001c7t-F\u0002$BA\u0004\t\u0003\u0019\u00198\r[3nC*\u0011\u0011BC\u0001\u0005kRLGN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\bm\u0016\u0014H/[2b\u0015\u0005y\u0011aA2p[\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u0007\u0013\t)bAA\u0006TG\",W.\u0019+p_2\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u0019!\t\u0019\u0002!A\u0007hKR\u001cu\u000e\\;n]&sgm\u001c\u000b\u00047}J\u0005c\u0001\u000f/c9\u0011Qd\u000b\b\u0003=%r!a\b\u0015\u000f\u0005\u0001:cBA\u0011'\u001d\t\u0011S%D\u0001$\u0015\t!\u0003#\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011QBD\u0005\u0003\u00171I!!\u0003\u0006\n\u0005)B\u0011!B3se>\u0014\u0018B\u0001\u0017.\u00035)%O]8s\u0011\u0006tG\r\\5oO*\u0011!\u0006C\u0005\u0003_A\u0012qbQ8o]\u0016\u001cGo\u001c:SKN,H\u000e\u001e\u0006\u0003Y5\u00022AM\u001d=\u001d\t\u0019dG\u0004\u0002#i%\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028q\u00059\u0001/Y2lC\u001e,'\"A\u001b\n\u0005iZ$aA*fc*\u0011q\u0007\u000f\t\u0003'uJ!A\u0010\u0004\u0003\u0013\r{G.^7o\t\u00164\u0007\"\u0002!\u0003\u0001\u0004\t\u0015!\u00036eE\u000ed\u0015-_3s!\t\u0011u)D\u0001D\u0015\t!U)\u0001\u0003kI\n\u001c'B\u0001$\u000b\u0003)!\u0017\r^1t_V\u00148-Z\u0005\u0003\u0011\u000e\u0013!C\u00133cG2\u000b\u00170\u001a:J]R,'OZ1dK\")!J\u0001a\u0001\u0017\u0006YA/\u00192mKN{WO]2f!\tau*D\u0001N\u0015\tq%\"\u0001\u0004d_:4\u0017nZ\u0005\u0003!6\u00131\u0002V1cY\u0016\u001cv.\u001e:dK\u0006A2\r[3dW\u000e{G.^7o\u0013N\u001cu.\u001c9mKb$\u0016\u0010]3\u0015\u000bM#f\u000b\u00192\u0011\u0007qqC\bC\u0003V\u0007\u0001\u0007A(A\u0002d_2DQaV\u0002A\u0002a\u000b\u0011\u0002^1cY\u0016t\u0015-\\3\u0011\u0005ekfB\u0001.\\!\t\u0011\u0003(\u0003\u0002]q\u00051\u0001K]3eK\u001aL!AX0\u0003\rM#(/\u001b8h\u0015\ta\u0006\bC\u0003b\u0007\u0001\u0007\u0001,\u0001\u0005eEN\u001b\u0007.Z7b\u0011\u0015\u00015\u00011\u0001B\u0003M\u0019\u0007.Z2l-F\u00024i\\7qY\u0016DH+\u001f9f)\u0015\u0019Vm\u001a5j\u0011\u00151G\u00011\u0001=\u0003\u0019\u0019w\u000e\u001c#fM\")q\u000b\u0002a\u00011\")\u0011\r\u0002a\u00011\")\u0001\t\u0002a\u0001\u0003\u0002")
public class SchemaToolsV10
extends SchemaTools {
    @Override
    public Either<ConnectorError, Seq<ColumnDef>> getColumnInfo(JdbcLayerInterface jdbcLayer, TableSource tableSource) {
        Left left;
        SchemaTools.ColumnInfoQueryData tableInfo = this.getColumnInfoQueryData(tableSource);
        Either<ConnectorError, Seq<ColumnDef>> either = super.getColumnInfo(jdbcLayer, tableSource);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq colList = (Seq)right.value();
            left = ((Validated)implicits$.MODULE$.toTraverseOps((Object)((TraversableOnce)colList.map((Function1 & Serializable & scala.Serializable)col -> this.checkColumnIsComplexType((ColumnDef)col, tableInfo.tableName(), tableInfo.dbSchema(), jdbcLayer), Seq$.MODULE$.canBuildFrom())).toList(), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$9 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$9), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)list -> list).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    private Either<ConnectorError, ColumnDef> checkColumnIsComplexType(ColumnDef col, String tableName, String dbSchema, JdbcLayerInterface jdbcLayer) {
        Either<ConnectorError, ColumnDef> either;
        Either<MissingSqlConversionError, DataType> either2 = super.getCatalystTypeFromJdbcType(col.colType(), 0, 0, false, "");
        if (either2 instanceof Right) {
            Right right = (Right)either2;
            DataType dataType = (DataType)right.value();
            DataType dataType2 = dataType;
            Either<ConnectorError, ColumnDef> either3 = StringType$.MODULE$.equals(dataType2) ? this.checkV10ComplexType(col, tableName, dbSchema, jdbcLayer) : package$.MODULE$.Right().apply((Object)col);
            either = either3;
        } else if (either2 instanceof Left) {
            either = package$.MODULE$.Right().apply((Object)col);
        } else {
            throw new MatchError(either2);
        }
        return either;
    }

    private Either<ConnectorError, ColumnDef> checkV10ComplexType(ColumnDef colDef, String tableName, String dbSchema, JdbcLayerInterface jdbcLayer) {
        String schemaCond = new StringOps(Predef$.MODULE$.augmentString(dbSchema)).nonEmpty() ? new StringBuilder(20).append(" AND table_schema='").append(dbSchema).append("'").toString() : "";
        String queryColType = new StringBuilder(71).append("SELECT data_type_id FROM columns WHERE table_name='").append(tableName).append("'").append(schemaCond).append(" AND column_name='").append(colDef.label()).append("'").toString();
        return JdbcUtils$.MODULE$.queryAndNext(queryColType, jdbcLayer, (Function1 & Serializable & scala.Serializable)rs -> this.handleVerticaTypeFound$1((ResultSet)rs, colDef, jdbcLayer), JdbcUtils$.MODULE$.queryAndNext$default$4());
    }

    private static final Either handleCTFound$1(ResultSet rs, ColumnDef colDef$1) {
        int x$1 = 2002;
        String x$2 = colDef$1.copy$default$1();
        String x$3 = colDef$1.copy$default$3();
        int x$4 = colDef$1.copy$default$4();
        int x$5 = colDef$1.copy$default$5();
        boolean x$6 = colDef$1.copy$default$6();
        boolean x$7 = colDef$1.copy$default$7();
        Metadata x$8 = colDef$1.copy$default$8();
        List<ColumnDef> x$9 = colDef$1.copy$default$9();
        return package$.MODULE$.Right().apply((Object)colDef$1.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9));
    }

    private static final Either handleCTNotFound$1(String q, ColumnDef colDef$1) {
        return package$.MODULE$.Right().apply((Object)colDef$1);
    }

    private final Either handleVerticaTypeFound$1(ResultSet rs2, ColumnDef colDef$1, JdbcLayerInterface jdbcLayer$4) {
        Right right;
        long verticaType = rs2.getLong("data_type_id");
        if (verticaType > SchemaTools$.MODULE$.VERTICA_NATIVE_ARRAY_BASE_ID() && verticaType < SchemaTools$.MODULE$.VERTICA_SET_MAX_ID()) {
            ColumnDef dummyChild = this.makeArrayElementDef(12, "STRING", 0);
            int x$1 = 2003;
            .colon.colon x$2 = new .colon.colon((Object)dummyChild, (List)Nil$.MODULE$);
            String x$3 = colDef$1.copy$default$1();
            String x$4 = colDef$1.copy$default$3();
            int x$5 = colDef$1.copy$default$4();
            int x$6 = colDef$1.copy$default$5();
            boolean x$7 = colDef$1.copy$default$6();
            boolean x$8 = colDef$1.copy$default$7();
            Metadata x$9 = colDef$1.copy$default$8();
            right = package$.MODULE$.Right().apply((Object)colDef$1.copy(x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, (List<ColumnDef>)x$2));
        } else {
            String queryComplexType = new StringBuilder(58).append("SELECT field_type_name FROM complex_types WHERE type_id='").append(verticaType).append("'").toString();
            right = JdbcUtils$.MODULE$.queryAndNext(queryComplexType, jdbcLayer$4, (Function1 & Serializable & scala.Serializable)rs -> SchemaToolsV10.handleCTFound$1(rs, colDef$1), (Function1 & Serializable & scala.Serializable)q -> SchemaToolsV10.handleCTNotFound$1(q, colDef$1));
        }
        return right;
    }
}

