/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.table;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.EscapeUtils$;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcLayerParam;
import com.vertica.spark.datasource.jdbc.JdbcLayerStringParam;
import com.vertica.spark.datasource.jdbc.JdbcUtils$;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.CreateTableError;
import com.vertica.spark.util.error.JdbcError;
import com.vertica.spark.util.error.JobStatusCreateError;
import com.vertica.spark.util.error.JobStatusUpdateError;
import com.vertica.spark.util.error.TableCheckError;
import com.vertica.spark.util.schema.SchemaToolsInterface;
import com.vertica.spark.util.table.TableUtilsInterface;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001\u0002\n\u0014\u0001yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!)\u0011\b\u0001C\u0001u!9a\b\u0001b\u0001\n\u0013y\u0004B\u0002%\u0001A\u0003%\u0001\tC\u0003J\u0001\u0011%!\nC\u0005\u0002\u0018\u0001\t\n\u0011\"\u0003\u0002\u001a!9\u0011q\u0006\u0001\u0005B\u0005E\u0002bBA\u001c\u0001\u0011\u0005\u0013\u0011\b\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!a\u001a\u0001\t\u0003\nI\u0007C\u0004\u0002p\u0001!\t%!\u001d\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000!9\u00111\u0011\u0001\u0005B\u0005\u0015\u0005bBAH\u0001\u0011\u0005\u0013\u0011\u0013\u0005\b\u0003C\u0003A\u0011IAR\u0005)!\u0016M\u00197f+RLGn\u001d\u0006\u0003)U\tQ\u0001^1cY\u0016T!AF\f\u0002\tU$\u0018\u000e\u001c\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\u000fY,'\u000f^5dC*\tA$A\u0002d_6\u001c\u0001aE\u0002\u0001?\u0015\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014(\u001b\u0005\u0019\u0012B\u0001\u0015\u0014\u0005M!\u0016M\u00197f+RLGn]%oi\u0016\u0014h-Y2f\u0003-\u00198\r[3nCR{w\u000e\\:\u0011\u0005-rS\"\u0001\u0017\u000b\u00055*\u0012AB:dQ\u0016l\u0017-\u0003\u00020Y\t!2k\u00195f[\u0006$vn\u001c7t\u0013:$XM\u001d4bG\u0016\f\u0011B\u001b3cG2\u000b\u00170\u001a:\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014\u0001\u00026eE\u000eT!AN\f\u0002\u0015\u0011\fG/Y:pkJ\u001cW-\u0003\u00029g\t\u0011\"\n\u001a2d\u0019\u0006LXM]%oi\u0016\u0014h-Y2f\u0003\u0019a\u0014N\\5u}Q\u00191\bP\u001f\u0011\u0005\u0019\u0002\u0001\"B\u0015\u0004\u0001\u0004Q\u0003\"\u0002\u0019\u0004\u0001\u0004\t\u0014A\u00027pO\u001e,'/F\u0001A!\t\te)D\u0001C\u0015\t\u0019E)\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002F7\u0005AA/\u001f9fg\u00064W-\u0003\u0002H\u0005\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%\u0001\u000bck&dGm\u0011:fCR,G+\u00192mKN#X\u000e\u001e\u000b\t\u0017&\fx0!\u0003\u0002\u000eA\u0019AJX1\u000f\u00055[fB\u0001(Z\u001d\ty\u0005L\u0004\u0002Q/:\u0011\u0011K\u0016\b\u0003%Vk\u0011a\u0015\u0006\u0003)v\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000f\n\u0005iY\u0012B\u0001\r\u001a\u0013\t1r#\u0003\u0002[+\u0005)QM\u001d:pe&\u0011A,X\u0001\u000e\u000bJ\u0014xN\u001d%b]\u0012d\u0017N\\4\u000b\u0005i+\u0012BA0a\u0005=\u0019uN\u001c8fGR|'OU3tk2$(B\u0001/^!\t\u0011gM\u0004\u0002dIB\u0011!+I\u0005\u0003K\u0006\na\u0001\u0015:fI\u00164\u0017BA4i\u0005\u0019\u0019FO]5oO*\u0011Q-\t\u0005\u0006U\u001a\u0001\ra[\u0001\ni\u0006\u0014G.\u001a8b[\u0016\u0004\"\u0001\\8\u000e\u00035T!A\\\f\u0002\r\r|gNZ5h\u0013\t\u0001XNA\u0005UC\ndWMT1nK\")QF\u0002a\u0001eB\u00111/`\u0007\u0002i*\u0011QO^\u0001\u0006if\u0004Xm\u001d\u0006\u0003ob\f1a]9m\u0015\tA\u0012P\u0003\u0002{w\u00061\u0011\r]1dQ\u0016T\u0011\u0001`\u0001\u0004_J<\u0017B\u0001@u\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003\u00031\u0001\u0019AA\u0002\u0003\u0019\u0019HO\u001d7f]B\u0019\u0001%!\u0002\n\u0007\u0005\u001d\u0011E\u0001\u0003M_:<\u0007bBA\u0006\r\u0001\u0007\u00111A\u0001\fCJ\u0014\u0018-\u001f'f]\u001e$\b\u000eC\u0005\u0002\u0010\u0019\u0001\n\u00111\u0001\u0002\u0012\u0005!A/Z7q!\r\u0001\u00131C\u0005\u0004\u0003+\t#a\u0002\"p_2,\u0017M\\\u0001\u001fEVLG\u000eZ\"sK\u0006$X\rV1cY\u0016\u001cF/\u001c;%I\u00164\u0017-\u001e7uIU*\"!a\u0007+\t\u0005E\u0011QD\u0016\u0003\u0003?\u0001B!!\t\u0002,5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011F\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002.\u0005\r\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006yA/Z7q)\u0006\u0014G.Z#ySN$8\u000f\u0006\u0003\u00024\u0005U\u0002\u0003\u0002'_\u0003#AQ\u0001\u0006\u0005A\u0002-\f!B^5fo\u0016C\u0018n\u001d;t)\u0011\t\u0019$a\u000f\t\r\u0005u\u0012\u00021\u0001l\u0003\u00111\u0018.Z<\u0002\u0017Q\f'\r\\3Fq&\u001cHo\u001d\u000b\u0005\u0003g\t\u0019\u0005C\u0003\u0015\u0015\u0001\u00071.A\nde\u0016\fG/Z#yi\u0016\u0014h.\u00197UC\ndW\r\u0006\b\u0002J\u0005E\u00131KA/\u0003?\n\t'!\u001a\u0011\t1s\u00161\n\t\u0004A\u00055\u0013bAA(C\t!QK\\5u\u0011\u0015Q7\u00021\u0001l\u0011\u001d\t)f\u0003a\u0001\u0003/\na\u0002^1sO\u0016$H+\u00192mKN\u000bH\u000e\u0005\u0003!\u00033\n\u0017bAA.C\t1q\n\u001d;j_:DQ!L\u0006A\u0002IDq!!\u0001\f\u0001\u0004\t\u0019\u0001\u0003\u0004\u0002d-\u0001\r!Y\u0001\u000ekJdGk\\\"paf4%o\\7\t\u000f\u0005-1\u00021\u0001\u0002\u0004\u0005)b/\u00197jI\u0006$X-\u0012=uKJt\u0017\r\u001c+bE2,GCBA%\u0003W\ni\u0007C\u0003k\u0019\u0001\u00071\u000eC\u0003.\u0019\u0001\u0007!/A\u0006de\u0016\fG/\u001a+bE2,G\u0003DA%\u0003g\n)(a\u001e\u0002z\u0005m\u0004\"\u00026\u000e\u0001\u0004Y\u0007bBA+\u001b\u0001\u0007\u0011q\u000b\u0005\u0006[5\u0001\rA\u001d\u0005\b\u0003\u0003i\u0001\u0019AA\u0002\u0011\u001d\tY!\u0004a\u0001\u0003\u0007\t\u0011\u0002\u001a:paR\u000b'\r\\3\u0015\t\u0005%\u0013\u0011\u0011\u0005\u0006U:\u0001\ra[\u0001\u0010GJ,\u0017\r^3UK6\u0004H+\u00192mKRQ\u0011\u0011JAD\u0003\u0013\u000bY)!$\t\u000b)|\u0001\u0019A6\t\u000b5z\u0001\u0019\u0001:\t\u000f\u0005\u0005q\u00021\u0001\u0002\u0004!9\u00111B\bA\u0002\u0005\r\u0011aG2sK\u0006$X-\u00118e\u0013:LGOS8c'R\fG/^:UC\ndW\r\u0006\u0006\u0002J\u0005M\u0015QSAM\u0003;CQA\u001b\tA\u0002-Da!a&\u0011\u0001\u0004\t\u0017\u0001B;tKJDa!a'\u0011\u0001\u0004\t\u0017!C:fgNLwN\\%e\u0011\u0019\ty\n\u0005a\u0001C\u0006A1/\u0019<f\u001b>$W-\u0001\u000bva\u0012\fG/\u001a&pEN#\u0018\r^;t)\u0006\u0014G.\u001a\u000b\r\u0003\u0013\n)+!+\u0002,\u0006U\u0016q\u0017\u0005\u0007\u0003O\u000b\u0002\u0019A6\u0002\u001b5\f\u0017N\u001c+bE2,g*Y7f\u0011\u0019\t9*\u0005a\u0001C\"9\u0011QV\tA\u0002\u0005=\u0016!\u00054bS2,GMU8xgB+'oY3oiB\u0019\u0001%!-\n\u0007\u0005M\u0016E\u0001\u0004E_V\u0014G.\u001a\u0005\u0007\u00037\u000b\u0002\u0019A1\t\u000f\u0005e\u0016\u00031\u0001\u0002\u0012\u000591/^2dKN\u001c\b")
public class TableUtils
implements TableUtilsInterface {
    private final SchemaToolsInterface schemaTools;
    private final JdbcLayerInterface jdbcLayer;
    private final Logger logger;

    private Logger logger() {
        return this.logger;
    }

    private Either<ConnectorError, String> buildCreateTableStmt(TableName tablename, StructType schema, long strlen, long arrayLength, boolean temp) {
        return this.schemaTools.checkValidTableSchema(schema).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.schemaTools.makeTableColumnDefs(schema, strlen, arrayLength).map((Function1 & Serializable & scala.Serializable)columnDefs -> {
            StringBuilder sb = new StringBuilder();
            StringBuilder stringBuilder = temp ? sb.append("CREATE TEMPORARY TABLE ") : sb.append("CREATE table ");
            sb.append(tablename.getFullTableName());
            sb.append(columnDefs);
            StringBuilder stringBuilder2 = temp ? sb.append(" ON COMMIT PRESERVE ROWS INCLUDE SCHEMA PRIVILEGES ") : sb.append(" INCLUDE SCHEMA PRIVILEGES ");
            return sb.toString();
        }));
    }

    private boolean buildCreateTableStmt$default$5() {
        return false;
    }

    @Override
    public Either<ConnectorError, Object> tempTableExists(TableName table) {
        String dbschema = (String)table.dbschema().getOrElse((Function0 & Serializable & scala.Serializable)() -> "public");
        String query = "select is_temp_table as t from v_catalog.tables where table_name=? and table_schema=?";
        Seq params = (Seq)new .colon.colon((Object)new JdbcLayerStringParam(table.name()), (List)new .colon.colon((Object)new JdbcLayerStringParam(dbschema), (List)Nil$.MODULE$));
        Either ret = this.jdbcLayer.query(query, (Seq<JdbcLayerParam>)params).map((Function1 & Serializable & scala.Serializable)rs -> {
            Try res = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> rs.next() ? rs.getBoolean("t") : false);
            rs.close();
            BoxedUnit x$1 = BoxedUnit.UNIT;
            return new Tuple3(rs, (Object)res, (Object)x$1);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple3 tuple3 = x$2;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Try res = (Try)tuple3._2();
            Either either = JdbcUtils$.MODULE$.tryJdbcToResult($this.jdbcLayer, res).map((Function1 & Serializable & scala.Serializable)isTemp -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)isTemp)));
            return either;
        });
        return ret.left().map((Function1 & Serializable & scala.Serializable)err -> new TableCheckError((Option<ConnectorError>)new Some(err)).context("Cannot append to a temporary table"));
    }

    @Override
    public Either<ConnectorError, Object> viewExists(TableName view) {
        Left left;
        String query = "select count(*) from views where table_schema ILIKE ? and table_name ILIKE ?";
        String dbschema = (String)view.dbschema().getOrElse((Function0 & Serializable & scala.Serializable)() -> "public");
        Seq params = (Seq)new .colon.colon((Object)new JdbcLayerStringParam(dbschema), (List)new .colon.colon((Object)new JdbcLayerStringParam(view.name()), (List)Nil$.MODULE$));
        Either<ConnectorError, ResultSet> either = this.jdbcLayer.query(query, (Seq<JdbcLayerParam>)params);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new TableCheckError((Option<ConnectorError>)new Some((Object)err)).context("JDBC Error when checking if view exists"));
        } else if (either instanceof Right) {
            Left left3;
            block10: {
                Right right = (Right)either;
                try (ResultSet rs = (ResultSet)right.value();){
                    try {
                        if (!rs.next()) {
                            left3 = package$.MODULE$.Left().apply((Object)new TableCheckError((Option<ConnectorError>)None$.MODULE$).context("View check: empty result"));
                            break block10;
                        }
                        left3 = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((rs.getInt(1) >= 1 ? 1 : 0) != 0));
                    }
                    catch (Throwable e) {
                        this.jdbcLayer.handleJDBCException(e);
                        left3 = package$.MODULE$.Left().apply((Object)new TableCheckError((Option<ConnectorError>)None$.MODULE$));
                    }
                }
            }
            left = left3;
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, Object> tableExists(TableName table) {
        Left left;
        String query = "select count(*) from v_catalog.tables where table_schema ILIKE ? and table_name ILIKE ?";
        String dbschema = (String)table.dbschema().getOrElse((Function0 & Serializable & scala.Serializable)() -> "public");
        Seq params = (Seq)new .colon.colon((Object)new JdbcLayerStringParam(dbschema), (List)new .colon.colon((Object)new JdbcLayerStringParam(table.name()), (List)Nil$.MODULE$));
        Either<ConnectorError, ResultSet> either = this.jdbcLayer.query(query, (Seq<JdbcLayerParam>)params);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new TableCheckError((Option<ConnectorError>)new Some((Object)err)).context("JDBC Error when checking if table exists"));
        } else if (either instanceof Right) {
            Left left3;
            block10: {
                Right right = (Right)either;
                try (ResultSet rs = (ResultSet)right.value();){
                    try {
                        if (!rs.next()) {
                            left3 = package$.MODULE$.Left().apply((Object)new TableCheckError((Option<ConnectorError>)None$.MODULE$).context("Table check: empty result"));
                            break block10;
                        }
                        left3 = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((rs.getInt(1) >= 1 ? 1 : 0) != 0));
                    }
                    catch (Throwable e) {
                        this.jdbcLayer.handleJDBCException(e);
                        left3 = package$.MODULE$.Left().apply((Object)new TableCheckError((Option<ConnectorError>)None$.MODULE$));
                    }
                }
            }
            left = left3;
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createExternalTable(TableName tablename, Option<String> targetTableSql, StructType schema, long strlen, String urlToCopyFrom, long arrayLength) {
        Left left;
        Right statement;
        Right right;
        Option<String> option = targetTableSql;
        if (option instanceof Some) {
            Some some = (Some)option;
            String sql = (String)some.value();
            right = package$.MODULE$.Right().apply((Object)sql);
        } else if (None$.MODULE$.equals(option)) {
            Left left2;
            Either<ConnectorError, String> either = this.schemaTools.makeTableColumnDefs(schema, strlen, arrayLength);
            if (either instanceof Right) {
                Right right2 = (Right)either;
                String columnDefs = (String)right2.value();
                StringBuilder sb = new StringBuilder();
                sb.append("CREATE EXTERNAL table ");
                sb.append(tablename.getFullTableName());
                sb.append(columnDefs);
                sb.append(" AS COPY FROM '");
                sb.append(urlToCopyFrom);
                sb.append("' PARQUET");
                left2 = package$.MODULE$.Right().apply((Object)sb.toString());
            } else if (either instanceof Left) {
                Left left3 = (Left)either;
                ConnectorError err2 = (ConnectorError)left3.value();
                left2 = package$.MODULE$.Left().apply((Object)err2);
            } else {
                throw new MatchError(either);
            }
            right = left2;
        } else {
            throw new MatchError(option);
        }
        Right right3 = statement = right;
        if (right3 instanceof Left) {
            Left left4 = (Left)right3;
            ConnectorError err3 = (ConnectorError)left4.value();
            left = package$.MODULE$.Left().apply((Object)err3);
        } else if (right3 instanceof Right) {
            BoxedUnit boxedUnit;
            Right right4 = right3;
            String st = (String)right4.value();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new java.lang.StringBuilder(38).append("BUILDING EXTERNAL TABLE WITH COMMAND: ").append(statement).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            left = this.jdbcLayer.execute(st, this.jdbcLayer.execute$default$2()).left().map((Function1 & Serializable & scala.Serializable)err -> new CreateTableError((Option<ConnectorError>)new Some(err)).context("JDBC Error creating external table"));
        } else {
            throw new MatchError((Object)right3);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> validateExternalTable(TableName tablename, StructType schema) {
        Right right;
        Seq schemaNoMap = (Seq)schema.filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TableUtils.$anonfun$validateExternalTable$1(x$3)));
        if (schemaNoMap.isEmpty()) {
            right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            Right right2;
            String cols = ((TraversableOnce)schemaNoMap.map((Function1 & Serializable & scala.Serializable)col -> new java.lang.StringBuilder(2).append("\"").append(col.name()).append("\"").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
            Either<ConnectorError, ResultSet> either = this.jdbcLayer.query(new java.lang.StringBuilder(22).append("SELECT ").append(cols).append(" FROM ").append(tablename.getFullTableName()).append(" LIMIT 1;").toString(), this.jdbcLayer.query$default$2());
            if (either instanceof Right) {
                right2 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else if (either instanceof Left) {
                Left left = (Left)either;
                ConnectorError err = (ConnectorError)left.value();
                right2 = package$.MODULE$.Left().apply((Object)err);
            } else {
                throw new MatchError(either);
            }
            right = right2;
        }
        return right;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createTable(TableName tablename, Option<String> targetTableSql, StructType schema, long strlen, long arrayLength) {
        Left left;
        Either<ConnectorError, String> statement;
        Either<ConnectorError, String> either;
        Option<String> option = targetTableSql;
        if (option instanceof Some) {
            Some some = (Some)option;
            String sql = (String)some.value();
            either = package$.MODULE$.Right().apply((Object)sql);
        } else if (None$.MODULE$.equals(option)) {
            either = this.buildCreateTableStmt(tablename, schema, strlen, arrayLength, this.buildCreateTableStmt$default$5());
        } else {
            throw new MatchError(option);
        }
        Either<ConnectorError, String> either2 = statement = either;
        if (either2 instanceof Left) {
            Left left2 = (Left)either2;
            ConnectorError err2 = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err2);
        } else if (either2 instanceof Right) {
            BoxedUnit boxedUnit;
            Right right = (Right)either2;
            String st = (String)right.value();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new java.lang.StringBuilder(29).append("BUILDING TABLE WITH COMMAND: ").append(statement).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            left = this.jdbcLayer.execute(st, this.jdbcLayer.execute$default$2()).left().map((Function1 & Serializable & scala.Serializable)err -> new CreateTableError((Option<ConnectorError>)new Some(err)).context("JDBC Error creating table"));
        } else {
            throw new MatchError(either2);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> dropTable(TableName tablename) {
        return this.jdbcLayer.execute(new java.lang.StringBuilder(21).append("DROP TABLE IF EXISTS ").append(tablename.getFullTableName()).toString(), this.jdbcLayer.execute$default$2()).left().map((Function1 & Serializable & scala.Serializable)err -> err.context("JDBC Error dropping table"));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createTempTable(TableName tablename, StructType schema, long strlen, long arrayLength) {
        Left left;
        BoxedUnit boxedUnit;
        Either<ConnectorError, String> statement = this.buildCreateTableStmt(tablename, schema, strlen, arrayLength, true);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new java.lang.StringBuilder(34).append("BUILDING TEMP TABLE WITH COMMAND: ").append(statement).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Either<ConnectorError, String> either = statement;
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err2 = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err2);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            String st = (String)right.value();
            left = this.jdbcLayer.execute(st, this.jdbcLayer.execute$default$2()).left().map((Function1 & Serializable & scala.Serializable)err -> new CreateTableError((Option<ConnectorError>)new Some(err)).context("JDBC Error creating table"));
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createAndInitJobStatusTable(TableName tablename, String user, String sessionId, String saveMode) {
        Right right;
        Either ret;
        String string;
        Option<String> option = tablename.dbschema();
        if (option instanceof Some) {
            String schema;
            Some some = (Some)option;
            string = schema = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = "public";
        } else {
            throw new MatchError(option);
        }
        String dbschema = string;
        String table = new java.lang.StringBuilder(20).append("S2V_JOB_STATUS_USER_").append(user.toUpperCase()).toString();
        TableName jobStatusTableName = new TableName(table, (Option<String>)new Some((Object)dbschema));
        String createStatement = new java.lang.StringBuilder(255).append("CREATE TABLE IF NOT EXISTS ").append(jobStatusTableName.getFullTableName()).append("(target_table_schema VARCHAR(128), ").append("target_table_name VARCHAR(128), ").append("save_mode VARCHAR(128), ").append("job_name VARCHAR(256), ").append("start_time TIMESTAMPTZ, ").append("all_done BOOLEAN NOT NULL, ").append("success BOOLEAN NOT NULL, ").append("percent_failed_rows DOUBLE PRECISION)").toString();
        String jobStartTime = Calendar.getInstance().getTime().toString();
        Date date = new Date();
        Timestamp timestamp = new Timestamp(date.getTime());
        String randJobName = sessionId;
        String comment = new java.lang.StringBuilder(149).append("COMMENT ON TABLE ").append(jobStatusTableName.getFullTableName()).append(" IS 'Persistent job status table showing all jobs, serving as permanent record of data loaded from Spark to Vertica. Creation time:").append(jobStartTime).append("'").toString();
        String insertStatement = new java.lang.StringBuilder(49).append("INSERT into ").append(jobStatusTableName.getFullTableName()).append(" VALUES ('").append(EscapeUtils$.MODULE$.sqlEscape(dbschema, '\'')).append("','").append(EscapeUtils$.MODULE$.sqlEscape(tablename.name(), '\'')).append("','").append(saveMode).append("','").append(randJobName).append("','").append(timestamp).append("',").append("false,false,").append(((Object)BoxesRunTime.boxToDouble((double)-1.0)).toString()).append(")").toString();
        Either either = ret = this.tableExists(jobStatusTableName).flatMap((Function1 & Serializable & scala.Serializable)tableExists -> TableUtils.$anonfun$createAndInitJobStatusTable$1(this, createStatement, comment, insertStatement, BoxesRunTime.unboxToBoolean((Object)tableExists)));
        if (either instanceof Left) {
            Left left;
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            ConnectorError connectorError = err.getUnderlyingError();
            if (connectorError instanceof JdbcError) {
                JdbcError jdbcError = (JdbcError)connectorError;
                left = package$.MODULE$.Left().apply((Object)new JobStatusCreateError(jdbcError).context("JDBC error when trying to initialize job status table"));
            } else if (connectorError != null) {
                left = package$.MODULE$.Left().apply((Object)err);
            } else {
                throw new MatchError((Object)connectorError);
            }
            right = left;
        } else if (either instanceof Right) {
            right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError((Object)either);
        }
        return right;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> updateJobStatusTable(TableName mainTableName, String user, double failedRowsPercent, String sessionId, boolean success) {
        Left left;
        BoxedUnit boxedUnit;
        String dbschema = (String)mainTableName.dbschema().getOrElse((Function0 & Serializable & scala.Serializable)() -> "public");
        String tablename = new java.lang.StringBuilder(20).append("S2V_JOB_STATUS_USER_").append(user.toUpperCase()).toString();
        TableName jobStatusTableName = new TableName(tablename, (Option<String>)new Some((Object)dbschema));
        String updateStatusTable = new java.lang.StringBuilder(83).append("UPDATE ").append(jobStatusTableName.getFullTableName()).append(" SET all_done=").append(true).append(",").append("success=").append(success).append(",").append("percent_failed_rows=").append(((Object)BoxesRunTime.boxToDouble((double)failedRowsPercent)).toString()).append(" ").append("WHERE job_name='").append(sessionId).append("' ").append("AND all_done=").append(false).toString();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new java.lang.StringBuilder(17).append("Updating ").append(jobStatusTableName.getFullTableName()).append(" next...").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Either<ConnectorError, Object> either = this.jdbcLayer.executeUpdate(updateStatusTable, this.jdbcLayer.executeUpdate$default$2());
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new JobStatusUpdateError((Option<ConnectorError>)new Some((Object)err)).context("JDBC Error when updating status table"));
        } else if (either instanceof Right) {
            Left left3;
            Right right = (Right)either;
            int c = BoxesRunTime.unboxToInt((Object)right.value());
            if (c == 1) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new java.lang.StringBuilder(21).append("Update of ").append(jobStatusTableName.getFullTableName()).append(" succeeded.").toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                left3 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else {
                left3 = package$.MODULE$.Left().apply((Object)new JobStatusUpdateError((Option<ConnectorError>)None$.MODULE$).context("Status_table update failed."));
            }
            left = left3;
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    public static final /* synthetic */ boolean $anonfun$validateExternalTable$1(StructField x$3) {
        return x$3.dataType() instanceof MapType;
    }

    public static final /* synthetic */ void $anonfun$createAndInitJobStatusTable$5(BoxedUnit _) {
    }

    public static final /* synthetic */ Either $anonfun$createAndInitJobStatusTable$1(TableUtils $this, String createStatement$1, String comment$1, String insertStatement$1, boolean tableExists) {
        return (!tableExists ? $this.jdbcLayer.execute(createStatement$1, $this.jdbcLayer.execute$default$2()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> (!tableExists ? $this.jdbcLayer.execute(comment$1, $this.jdbcLayer.execute$default$2()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.jdbcLayer.execute(insertStatement$1, $this.jdbcLayer.execute$default$2()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> $this.jdbcLayer.commit().map((Function1 & Serializable & scala.Serializable)_ -> {
            TableUtils.$anonfun$createAndInitJobStatusTable$5(_);
            return BoxedUnit.UNIT;
        }))));
    }

    public TableUtils(SchemaToolsInterface schemaTools, JdbcLayerInterface jdbcLayer) {
        this.schemaTools = schemaTools;
        this.jdbcLayer = jdbcLayer;
        this.logger = LogProvider$.MODULE$.getLogger(TableUtils.class);
    }
}

