/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.version;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcUtils$;
import com.vertica.spark.util.complex.ComplexTypeUtils;
import com.vertica.spark.util.error.ComplexTypeReadNotSupported;
import com.vertica.spark.util.error.ComplexTypeWriteNotSupported;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.InternalMapNotSupported;
import com.vertica.spark.util.error.NativeArrayReadNotSupported;
import com.vertica.spark.util.error.NativeArrayWriteNotSupported;
import com.vertica.spark.util.error.NoResultError;
import com.vertica.spark.util.version.VerticaVersion;
import com.vertica.spark.util.version.VerticaVersion$;
import java.io.Serializable;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class VerticaVersionUtils$ {
    public static VerticaVersionUtils$ MODULE$;
    private final Logger logger;
    private final Option<VerticaVersion> version;
    private final VerticaVersion VERRTICA_LATEST;
    private final ComplexTypeUtils complexTypeUtils;

    static {
        new VerticaVersionUtils$();
    }

    private Logger logger() {
        return this.logger;
    }

    private Option<VerticaVersion> version() {
        return this.version;
    }

    public VerticaVersion VERRTICA_LATEST() {
        return this.VERRTICA_LATEST;
    }

    public ComplexTypeUtils complexTypeUtils() {
        return this.complexTypeUtils;
    }

    public VerticaVersion getVersion(JdbcLayerInterface jdbcLayer) {
        return (VerticaVersion)JdbcUtils$.MODULE$.queryAndNext("SELECT version();", jdbcLayer, (Function1 & Serializable & scala.Serializable)rs -> {
            BoxedUnit boxedUnit;
            VerticaVersion verticaVersion = MODULE$.extractVersion(rs.getString(1));
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info(new StringBuilder(17).append("VERTICA VERSION: ").append(verticaVersion).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return package$.MODULE$.Right().apply((Object)verticaVersion);
        }, (Function1 & Serializable & scala.Serializable)query -> {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isErrorEnabled()) {
                MODULE$.logger().underlying().error(new StringBuilder(48).append("Failed to query for version number. Defaults to ").append(MODULE$.VERRTICA_LATEST()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return package$.MODULE$.Left().apply((Object)new NoResultError((String)query));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.VERRTICA_LATEST());
    }

    private VerticaVersion extractVersion(String str) {
        Regex pattern = new StringOps(Predef$.MODULE$.augmentString(".*v([0-9]+)\\.([0-9]+)\\.([0-9])+-([0-9]+).*")).r();
        return (VerticaVersion)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String string = str;
            Option option = pattern.unapplySeq((CharSequence)string);
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(4) != 0) {
                throw new MatchError((Object)string);
            }
            String major = (String)((LinearSeqOptimized)option.get()).apply(0);
            String minor = (String)((LinearSeqOptimized)option.get()).apply(1);
            String service = (String)((LinearSeqOptimized)option.get()).apply(2);
            String hotfix = (String)((LinearSeqOptimized)option.get()).apply(3);
            Tuple4 tuple4 = new Tuple4((Object)major, (Object)minor, (Object)service, (Object)hotfix);
            Tuple4 tuple42 = tuple4;
            String major2 = (String)tuple42._1();
            String minor2 = (String)tuple42._2();
            String service2 = (String)tuple42._3();
            String hotfix2 = (String)tuple42._4();
            return new VerticaVersion(new StringOps(Predef$.MODULE$.augmentString(major2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(minor2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(service2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(hotfix2)).toInt());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.VERRTICA_LATEST());
    }

    public Either<ConnectorError, BoxedUnit> checkSchemaTypesWriteSupport(StructType schema, VerticaVersion version, boolean toInternalTable) {
        Tuple2<List<StructField>, List<StructField>> tuple2 = this.complexTypeUtils().getComplexTypeColumns(schema);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List nativeCols = (List)tuple2._1();
        List complexTypeCols = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nativeCols, (Object)complexTypeCols);
        Tuple2 tuple23 = tuple22;
        List nativeCols2 = (List)tuple23._1();
        List complexTypeCols2 = (List)tuple23._2();
        boolean complexTypeFound = complexTypeCols2.nonEmpty();
        List nativeArrayCols = (List)nativeCols2.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)VerticaVersionUtils$.$anonfun$checkSchemaTypesWriteSupport$1(x$3)));
        return version.major() <= 9 ? (complexTypeFound ? package$.MODULE$.Left().apply((Object)new ComplexTypeWriteNotSupported((List<StructField>)complexTypeCols2, version.toString())) : (nativeArrayCols.nonEmpty() ? package$.MODULE$.Left().apply((Object)new NativeArrayWriteNotSupported((List<StructField>)nativeArrayCols, version.toString())) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT))) : (version.major() == 10 ? (complexTypeFound ? package$.MODULE$.Left().apply((Object)new ComplexTypeWriteNotSupported((List<StructField>)complexTypeCols2, version.toString())) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)) : (toInternalTable && complexTypeCols2.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)VerticaVersionUtils$.$anonfun$checkSchemaTypesWriteSupport$2(x$4))) ? package$.MODULE$.Left().apply((Object)new InternalMapNotSupported()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)));
    }

    public Either<ConnectorError, BoxedUnit> checkSchemaTypesReadSupport(StructType schema, VerticaVersion version) {
        Tuple2<List<StructField>, List<StructField>> tuple2 = this.complexTypeUtils().getComplexTypeColumns(schema);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List nativeCols = (List)tuple2._1();
        List complexTypeCols = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nativeCols, (Object)complexTypeCols);
        Tuple2 tuple23 = tuple22;
        List nativeCols2 = (List)tuple23._1();
        List complexTypeCols2 = (List)tuple23._2();
        List nativeArrayCols = (List)nativeCols2.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)VerticaVersionUtils$.$anonfun$checkSchemaTypesReadSupport$1(x$6)));
        return version.major() <= 10 ? (complexTypeCols2.nonEmpty() ? package$.MODULE$.Left().apply((Object)new ComplexTypeReadNotSupported((List<StructField>)complexTypeCols2, version.toString())) : (nativeArrayCols.nonEmpty() ? package$.MODULE$.Left().apply((Object)new NativeArrayReadNotSupported((List<StructField>)nativeArrayCols, version.toString())) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT))) : (complexTypeCols2.nonEmpty() ? package$.MODULE$.Left().apply((Object)new ComplexTypeReadNotSupported((List<StructField>)complexTypeCols2, version.toString())) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    public static final /* synthetic */ boolean $anonfun$checkSchemaTypesWriteSupport$1(StructField x$3) {
        return x$3.dataType() instanceof ArrayType;
    }

    public static final /* synthetic */ boolean $anonfun$checkSchemaTypesWriteSupport$2(StructField x$4) {
        return x$4.dataType() instanceof MapType;
    }

    public static final /* synthetic */ boolean $anonfun$checkSchemaTypesReadSupport$1(StructField x$6) {
        return x$6.dataType() instanceof ArrayType;
    }

    private VerticaVersionUtils$() {
        MODULE$ = this;
        this.logger = LogProvider$.MODULE$.getLogger(this.getClass());
        this.version = None$.MODULE$;
        this.VERRTICA_LATEST = new VerticaVersion(11, VerticaVersion$.MODULE$.apply$default$2(), VerticaVersion$.MODULE$.apply$default$3(), VerticaVersion$.MODULE$.apply$default$4());
        this.complexTypeUtils = new ComplexTypeUtils();
    }
}

