/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.core;

import cats.Applicative;
import cats.Functor;
import cats.Semigroupal;
import cats.data.Chain$;
import cats.data.NonEmptyChainImpl$;
import cats.data.NonEmptyChainOps$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import cats.syntax.ValidatedIdOpsBinCompat0$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.AWSAuth;
import com.vertica.spark.config.AWSAuth$;
import com.vertica.spark.config.AWSOptions$;
import com.vertica.spark.config.BasicJdbcAuth;
import com.vertica.spark.config.ConnectorOption$;
import com.vertica.spark.config.EnvVar$;
import com.vertica.spark.config.FileStoreConfig;
import com.vertica.spark.config.FileStoreConfig$;
import com.vertica.spark.config.GCSOptions$;
import com.vertica.spark.config.GCSServiceAuth;
import com.vertica.spark.config.GCSServiceAuth$;
import com.vertica.spark.config.GCSVerticaAuth;
import com.vertica.spark.config.GCSVerticaAuth$;
import com.vertica.spark.config.JDBCConfig;
import com.vertica.spark.config.JDBCConfig$;
import com.vertica.spark.config.JDBCTLSConfig;
import com.vertica.spark.config.JDBCTLSConfig$;
import com.vertica.spark.config.JdbcAuth;
import com.vertica.spark.config.KerberosAuth;
import com.vertica.spark.config.Secret$;
import com.vertica.spark.config.SensitiveArg;
import com.vertica.spark.config.SparkConf$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.config.TableQuery;
import com.vertica.spark.config.TableSource;
import com.vertica.spark.config.ValidColumnList;
import com.vertica.spark.config.ValidColumnList$;
import com.vertica.spark.config.ValidFilePermissions;
import com.vertica.spark.config.ValidFilePermissions$;
import com.vertica.spark.config.Visibility;
import com.vertica.spark.config.Visible$;
import com.vertica.spark.datasource.core.CreateExternalTableOption;
import com.vertica.spark.datasource.core.DSConfigSetupUtils;
import com.vertica.spark.datasource.core.Disable$;
import com.vertica.spark.datasource.core.ExistingData$;
import com.vertica.spark.datasource.core.NewData$;
import com.vertica.spark.datasource.core.Require$;
import com.vertica.spark.datasource.core.SessionId$;
import com.vertica.spark.datasource.core.TLSMode;
import com.vertica.spark.datasource.core.VerifyCA$;
import com.vertica.spark.datasource.core.VerifyFull$;
import com.vertica.spark.datasource.fs.GCSConnectorOptions$;
import com.vertica.spark.datasource.fs.GCSEnvVars$;
import com.vertica.spark.datasource.fs.GCSSparkOptions$;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.DbMissingError;
import com.vertica.spark.util.error.HostMissingError;
import com.vertica.spark.util.error.InvalidArrayLengthError;
import com.vertica.spark.util.error.InvalidCreateExternalTableOption;
import com.vertica.spark.util.error.InvalidFailedRowsTolerance;
import com.vertica.spark.util.error.InvalidIntegerField;
import com.vertica.spark.util.error.InvalidPartitionCountError;
import com.vertica.spark.util.error.InvalidPortError;
import com.vertica.spark.util.error.InvalidPreventCleanupOption;
import com.vertica.spark.util.error.InvalidSaveJobStatusTableOption;
import com.vertica.spark.util.error.InvalidStrlenError;
import com.vertica.spark.util.error.KerberosAuthMissingError;
import com.vertica.spark.util.error.LoadConfigMissingSparkSessionError;
import com.vertica.spark.util.error.MissingAWSAccessKeyId;
import com.vertica.spark.util.error.MissingAWSSecretAccessKey;
import com.vertica.spark.util.error.MissingGCSServiceAccountAuthentications;
import com.vertica.spark.util.error.MissingGCSVerticaKeyId;
import com.vertica.spark.util.error.MissingGCSVerticaKeySecret;
import com.vertica.spark.util.error.PasswordMissingError;
import com.vertica.spark.util.error.QuerySpecifiedOnWriteError;
import com.vertica.spark.util.error.StagingFsUrlMissingError;
import com.vertica.spark.util.error.TLSModeParseError;
import com.vertica.spark.util.error.TableAndQueryMissingError;
import com.vertica.spark.util.error.TablenameMissingError;
import com.vertica.spark.util.error.UserMissingError;
import com.vertica.spark.util.error.V1ReplacementOption;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function5;
import scala.Function6;
import scala.Function7;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.Tuple6;
import scala.Tuple7;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DSConfigSetupUtils$ {
    public static DSConfigSetupUtils$ MODULE$;

    static {
        new DSConfigSetupUtils$();
    }

    public Seq<ConnectorError> checkOldConnectorOptions(Map<String, String> config) {
        String[] oldList = (String[])((Object[])new String[]{"target_table_ddl", "numpartitions", "hdfs_url", "web_hdfs_url"});
        String[] replacementsList = (String[])((Object[])new String[]{"target_table_sql", "num_partitions", "staging_fs_url", "staging_fs_url"});
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])oldList)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])replacementsList), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DSConfigSetupUtils$.$anonfun$checkOldConnectorOptions$1(config, x0$1))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String old = (String)tuple2._1();
            String replacement = (String)tuple2._2();
            V1ReplacementOption v1ReplacementOption = new V1ReplacementOption(old, replacement);
            return v1ReplacementOption;
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public <T> Validated<Object, T> logOrAppendErrorsForOldConnectorOptions(Map<String, String> config, Validated<Object, T> res, Logger logger) {
        Validated.Valid valid;
        Seq<ConnectorError> oldConnectorMessages = this.checkOldConnectorOptions(config);
        Option oldConnectorChain = cats.data.package$.MODULE$.NonEmptyChain().fromChain(Chain$.MODULE$.fromSeq(oldConnectorMessages));
        Validated<Object, T> validated = res;
        if (validated instanceof Validated.Valid) {
            Validated.Valid valid2 = (Validated.Valid)validated;
            Object a = valid2.a();
            oldConnectorMessages.foreach((Function1 & Serializable & scala.Serializable)m -> {
                DSConfigSetupUtils$.$anonfun$logOrAppendErrorsForOldConnectorOptions$1(logger, m);
                return BoxedUnit.UNIT;
            });
            valid = new Validated.Valid(a);
        } else if (validated instanceof Validated.Invalid) {
            Object object;
            Validated.Invalid invalid = (Validated.Invalid)validated;
            Object errList = invalid.e();
            Option option = oldConnectorChain;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object chain = some.value();
                object = NonEmptyChainOps$.MODULE$.concat$extension(NonEmptyChainImpl$.MODULE$.catsNonEmptyChainOps(errList), chain);
            } else if (None$.MODULE$.equals(option)) {
                object = errList;
            } else {
                throw new MatchError((Object)option);
            }
            valid = new Validated.Invalid(object);
        } else {
            throw new MatchError(validated);
        }
        return valid;
    }

    public Validated<Object, String> getHost(Map<String, String> config) {
        Validated validated;
        Option option = config.get((Object)"host");
        if (option instanceof Some) {
            Some some = (Some)option;
            String host = (String)some.value();
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)host));
        } else if (None$.MODULE$.equals(option)) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new HostMissingError()));
        } else {
            throw new MatchError((Object)option);
        }
        return validated;
    }

    public Validated<Object, Option<CreateExternalTableOption>> getCreateExternalTable(Map<String, String> config) {
        Validated validated;
        Option option = config.get((Object)"create_external_table");
        if (option instanceof Some) {
            Some some = (Some)option;
            String str = (String)some.value();
            String string = str;
            boolean bl = "new-data".equals(string) ? true : "true".equals(string);
            Validated validated2 = bl ? ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new Some((Object)NewData$.MODULE$))) : ("existing-data".equals(string) ? ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new Some((Object)ExistingData$.MODULE$))) : ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new InvalidCreateExternalTableOption())));
            validated = validated2;
        } else if (None$.MODULE$.equals(option)) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)None$.MODULE$));
        } else {
            throw new MatchError((Object)option);
        }
        return validated;
    }

    public Validated<Object, Object> getSaveJobStatusTable(Map<String, String> config) {
        Validated validated;
        Option option = config.get((Object)"save_job_status_table");
        if (option instanceof Some) {
            Some some = (Some)option;
            String str = (String)some.value();
            String string = str;
            Validated validated2 = "true".equals(string) ? ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)BoxesRunTime.boxToBoolean((boolean)true))) : ("false".equals(string) ? ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)BoxesRunTime.boxToBoolean((boolean)false))) : ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new InvalidSaveJobStatusTableOption())));
            validated = validated2;
        } else if (None$.MODULE$.equals(option)) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        } else {
            throw new MatchError((Object)option);
        }
        return validated;
    }

    public Validated<Object, String> getStagingFsUrl(Map<String, String> config) {
        Validated validated;
        Option option = config.get((Object)"staging_fs_url");
        if (option instanceof Some) {
            Some some = (Some)option;
            String address = (String)some.value();
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)address));
        } else if (None$.MODULE$.equals(option)) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new StagingFsUrlMissingError()));
        } else {
            throw new MatchError((Object)option);
        }
        return validated;
    }

    public Validated<Object, Object> getPort(Map<String, String> config) {
        Validated validated;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)config.getOrElse((Object)"port", (Function0 & Serializable & scala.Serializable)() -> "5433"))).toInt());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            int i = BoxesRunTime.unboxToInt((Object)success.value());
            validated = i >= 1 && i <= 65535 ? ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)BoxesRunTime.boxToInteger((int)i))) : ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new InvalidPortError()));
        } else if (try_ instanceof Failure) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new InvalidPortError()));
        } else {
            throw new MatchError((Object)try_);
        }
        return validated;
    }

    public Validated<Object, Object> getMaxFileSize(Map<String, String> config) {
        Validated validated;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)config.getOrElse((Object)"max_file_size_export_mb", (Function0 & Serializable & scala.Serializable)() -> "4096"))).toInt());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            int i = BoxesRunTime.unboxToInt((Object)success.value());
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)BoxesRunTime.boxToInteger((int)i)));
        } else if (try_ instanceof Failure) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new InvalidIntegerField("max_file_size_export_mb")));
        } else {
            throw new MatchError((Object)try_);
        }
        return validated;
    }

    public Validated<Object, Object> getMaxRowGroupSize(Map<String, String> config) {
        Validated validated;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)config.getOrElse((Object)"max_row_group_size_export_mb", (Function0 & Serializable & scala.Serializable)() -> "16"))).toInt());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            int i = BoxesRunTime.unboxToInt((Object)success.value());
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)BoxesRunTime.boxToInteger((int)i)));
        } else if (try_ instanceof Failure) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new InvalidIntegerField("max_row_group_size_export_mb")));
        } else {
            throw new MatchError((Object)try_);
        }
        return validated;
    }

    public Validated<Object, Object> getFailedRowsPercentTolerance(Map<String, String> config) {
        Validated validated;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)config.getOrElse((Object)"failed_rows_percent_tolerance", (Function0 & Serializable & scala.Serializable)() -> "0.00"))).toFloat());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            float f = BoxesRunTime.unboxToFloat((Object)success.value());
            validated = (double)f >= 0.0 && (double)f <= 1.0 ? ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)BoxesRunTime.boxToFloat((float)f))) : ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new InvalidFailedRowsTolerance()));
        } else if (try_ instanceof Failure) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new InvalidFailedRowsTolerance()));
        } else {
            throw new MatchError((Object)try_);
        }
        return validated;
    }

    public Validated<Object, String> getDb(Map<String, String> config) {
        Validated validated;
        Option option = config.get((Object)"db");
        if (option instanceof Some) {
            Some some = (Some)option;
            String db = (String)some.value();
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)db));
        } else if (None$.MODULE$.equals(option)) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new DbMissingError()));
        } else {
            throw new MatchError((Object)option);
        }
        return validated;
    }

    public Option<String> getUser(Map<String, String> config) {
        return config.get((Object)"user");
    }

    public Option<String> getPassword(Map<String, String> config) {
        return config.get((Object)"password");
    }

    public Option<String> getKerberosServiceName(Map<String, String> config) {
        return config.get((Object)"kerberos_service_name");
    }

    public Option<String> getKerberosHostname(Map<String, String> config) {
        return config.get((Object)"kerberos_host_name");
    }

    public Option<String> getJaasConfigName(Map<String, String> config) {
        return config.get((Object)"jaas_config_name");
    }

    public Validated<Object, TLSMode> getTLS(Map<String, String> config) {
        Validated validated;
        Option option = config.get((Object)"tls_mode");
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            String string = value;
            Validated validated2 = "disable".equals(string) ? ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)Disable$.MODULE$)) : ("require".equals(string) ? ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)Require$.MODULE$)) : ("verify-ca".equals(string) ? ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)VerifyCA$.MODULE$)) : ("verify-full".equals(string) ? ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)VerifyFull$.MODULE$)) : ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new TLSModeParseError())))));
            validated = validated2;
        } else if (None$.MODULE$.equals(option)) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)Disable$.MODULE$));
        } else {
            throw new MatchError((Object)option);
        }
        return validated;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Validated<Object, Option<AWSAuth>> getAWSAuth(Map<String, String> config) {
        Option secretAccessKeyOpt;
        Secret$ visibility = Secret$.MODULE$;
        Option accessKeyIdOpt = (Option)implicits$.MODULE$.toTraverseOps(this.getSensitiveOption(visibility, config, "aws_access_key_id", "spark.hadoop.fs.s3a.access.key", "AWS_ACCESS_KEY_ID"), Validated$.MODULE$.catsDataTraverseFunctorForValidated()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForOption());
        Tuple2 tuple2 = new Tuple2((Object)accessKeyIdOpt, (Object)(secretAccessKeyOpt = (Option)implicits$.MODULE$.toTraverseOps(this.getSensitiveOption(visibility, config, "aws_secret_access_key", "spark.hadoop.fs.s3a.secret.key", "AWS_SECRET_ACCESS_KEY"), Validated$.MODULE$.catsDataTraverseFunctorForValidated()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForOption())));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Validated accessKeyId = (Validated)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Validated secretAccessKey = (Validated)some2.value();
                    return ((Validated)implicits$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)accessKeyId, (Object)secretAccessKey)).mapN((Function2)AWSAuth$.MODULE$, (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()))).map((Function1 & Serializable & scala.Serializable)x$1 -> new Some(x$1));
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option3)) {
                return ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)None$.MODULE$));
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option4 = (Option)tuple2._2();
            if (option instanceof Some && None$.MODULE$.equals(option4)) {
                return ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new MissingAWSAccessKeyId()));
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option option = (Option)tuple2._1();
        Option option5 = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
        if (!(option5 instanceof Some)) throw new MatchError((Object)tuple2);
        return ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new MissingAWSSecretAccessKey()));
    }

    public Validated<Object, Option<SensitiveArg<String>>> getGCSKeyFile(Map<String, String> config) {
        Secret$ visibility = Secret$.MODULE$;
        return this.getSensitiveOption(visibility, config, GCSConnectorOptions$.MODULE$.SERVICE_JSON_KEYFILE(), GCSSparkOptions$.MODULE$.SERVICE_JSON_KEYFILE(), GCSEnvVars$.MODULE$.SERVICE_JSON_KEYFILE());
    }

    public Validated<Object, Option<GCSServiceAuth>> getGCSServiceAccountAuth(Map<String, String> config) {
        Validated validated;
        DSConfigSetupUtils.SensitiveOptionFound emailFound;
        DSConfigSetupUtils.SensitiveOptionFound keySecretFound;
        Secret$ visibility = Secret$.MODULE$;
        DSConfigSetupUtils.SensitiveOptionFound keyIdFound = this.getSensitiveOptionWithName(visibility, config, GCSConnectorOptions$.MODULE$.SERVICE_KEY_ID(), GCSSparkOptions$.MODULE$.SERVICE_ACC_KEY_ID(), GCSEnvVars$.MODULE$.SERVICE_KEY_ID());
        .colon.colon results = new .colon.colon((Object)keyIdFound, (List)new .colon.colon((Object)(keySecretFound = this.getSensitiveOptionWithName(visibility, config, GCSConnectorOptions$.MODULE$.SERVICE_KEY(), GCSSparkOptions$.MODULE$.SERVICE_ACC_KEY(), GCSEnvVars$.MODULE$.SERVICE_KEY())), (List)new .colon.colon((Object)(emailFound = this.getSensitiveOptionWithName(visibility, config, GCSConnectorOptions$.MODULE$.SERVICE_EMAIL(), GCSSparkOptions$.MODULE$.SERVICE_ACC_EMAIL(), GCSEnvVars$.MODULE$.SERVICE_EMAIL())), (List)Nil$.MODULE$)));
        List invalids = (List)results.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DSConfigSetupUtils$.$anonfun$getGCSServiceAccountAuth$1(x$2)));
        if (invalids.isEmpty()) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0(implicits$.MODULE$.catsSyntaxTuple3Semigroupal(new Tuple3(keyIdFound.option().toOption().get(), keySecretFound.option().toOption().get(), emailFound.option().toOption().get())).mapN((Function3)GCSServiceAuth$.MODULE$, (Functor)implicits$.MODULE$.catsStdInstancesForOption(), (Semigroupal)implicits$.MODULE$.catsStdInstancesForOption())));
        } else {
            List found = (List)((List)results.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DSConfigSetupUtils$.$anonfun$getGCSServiceAccountAuth$2(x$3)))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.optionName(), List$.MODULE$.canBuildFrom());
            List missing = (List)invalids.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.optionName(), List$.MODULE$.canBuildFrom());
            validated = ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new MissingGCSServiceAccountAuthentications((Seq<String>)found, (Seq<String>)missing)));
        }
        return validated;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Validated<Object, Option<GCSVerticaAuth>> getVerticaGCSAuth(Map<String, String> config) {
        Option option;
        Option secretAccessKeyOpt;
        Secret$ visibility = Secret$.MODULE$;
        Option accessKeyIdOpt = (Option)implicits$.MODULE$.toTraverseOps(this.getSensitiveOption(visibility, config, GCSConnectorOptions$.MODULE$.GCS_HMAC_KEY_ID(), GCSSparkOptions$.MODULE$.GCS_HMAC_KEY_ID(), GCSEnvVars$.MODULE$.GCS_HMAC_KEY_ID()), Validated$.MODULE$.catsDataTraverseFunctorForValidated()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForOption());
        Tuple2 tuple2 = new Tuple2((Object)accessKeyIdOpt, (Object)(secretAccessKeyOpt = (Option)implicits$.MODULE$.toTraverseOps(this.getSensitiveOption(visibility, config, GCSConnectorOptions$.MODULE$.GCS_HMAC_KEY_SECRET(), GCSSparkOptions$.MODULE$.GCS_HMAC_KEY_SECRET(), GCSEnvVars$.MODULE$.GCS_HMAC_KEY_SECRET()), Validated$.MODULE$.catsDataTraverseFunctorForValidated()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForOption())));
        if (tuple2 != null) {
            Option option2 = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Validated accessKeyId = (Validated)some.value();
                if (option3 instanceof Some) {
                    Some some2 = (Some)option3;
                    Validated secretAccessKey = (Validated)some2.value();
                    return ((Validated)implicits$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)accessKeyId, (Object)secretAccessKey)).mapN((Function2)GCSVerticaAuth$.MODULE$, (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()))).map((Function1 & Serializable & scala.Serializable)x$6 -> new Some(x$6));
                }
            }
        }
        if (tuple2 != null) {
            Option option4 = (Option)tuple2._1();
            Option option5 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option4) && None$.MODULE$.equals(option5)) {
                return ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)None$.MODULE$));
            }
        }
        if (tuple2 != null && None$.MODULE$.equals(option = (Option)tuple2._1())) {
            return ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new MissingGCSVerticaKeyId()));
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option option6 = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option6)) throw new MatchError((Object)tuple2);
        return ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new MissingGCSVerticaKeySecret()));
    }

    public Validated<Object, Option<SensitiveArg<String>>> getAWSRegion(Map<String, String> config) {
        Visible$ visibility = Visible$.MODULE$;
        return this.getSensitiveArgFromConnectorOptions(visibility, config, "aws_region", (Function1<BoxedUnit, Validated<Object, Option<SensitiveArg<String>>>>)(Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.getSensitiveArgFromEnvVar(visibility, "AWS_DEFAULT_REGION"));
    }

    public Validated<Object, Option<SensitiveArg<String>>> getAWSSessionToken(Map<String, String> config) {
        return this.getSensitiveOption(Secret$.MODULE$, config, "aws_session_token", "spark.hadoop.fs.s3a.session.token", "AWS_SESSION_TOKEN");
    }

    public Validated<Object, Option<SensitiveArg<String>>> getAWSCredentialsProvider(Map<String, String> config) {
        Visible$ visibility = Visible$.MODULE$;
        return this.getSensitiveArgFromConnectorOptions(visibility, config, "aws_credentials_provider", (Function1<BoxedUnit, Validated<Object, Option<SensitiveArg<String>>>>)(Function1 & Serializable & scala.Serializable)x$8 -> MODULE$.getSensitiveArgFromSparkConfigOptions(visibility, "spark.hadoop.fs.s3a.aws.credentials.provider", (Function1<BoxedUnit, Validated<Object, Option<SensitiveArg<String>>>>)(Function1 & Serializable & scala.Serializable)x$9 -> ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)None$.MODULE$))));
    }

    public Validated<Object, Option<SensitiveArg<String>>> getAWSEndpoint(Map<String, String> config) {
        Visible$ visibility = Visible$.MODULE$;
        return this.getSensitiveArgFromConnectorOptions(visibility, config, "aws_endpoint", (Function1<BoxedUnit, Validated<Object, Option<SensitiveArg<String>>>>)(Function1 & Serializable & scala.Serializable)x$10 -> MODULE$.getSensitiveArgFromSparkConfigOptions(visibility, "spark.hadoop.fs.s3a.endpoint", (Function1<BoxedUnit, Validated<Object, Option<SensitiveArg<String>>>>)(Function1 & Serializable & scala.Serializable)x$11 -> ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)None$.MODULE$))));
    }

    public Validated<Object, Option<SensitiveArg<String>>> getAWSSSLEnabled(Map<String, String> config) {
        Visible$ visibility = Visible$.MODULE$;
        return this.getSensitiveArgFromConnectorOptions(visibility, config, "aws_enable_ssl", (Function1<BoxedUnit, Validated<Object, Option<SensitiveArg<String>>>>)(Function1 & Serializable & scala.Serializable)x$12 -> MODULE$.getSensitiveArgFromSparkConfigOptions(visibility, "fs.s3a.connection.ssl.enabled", (Function1<BoxedUnit, Validated<Object, Option<SensitiveArg<String>>>>)(Function1 & Serializable & scala.Serializable)x$13 -> ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)None$.MODULE$))));
    }

    public Validated<Object, Option<SensitiveArg<String>>> getAWSPathStyleEnabled(Map<String, String> config) {
        Visible$ visibility = Visible$.MODULE$;
        return this.getSensitiveArgFromConnectorOptions(visibility, config, "aws_enable_path_style", (Function1<BoxedUnit, Validated<Object, Option<SensitiveArg<String>>>>)(Function1 & Serializable & scala.Serializable)x$14 -> MODULE$.getSensitiveArgFromSparkConfigOptions(visibility, "fs.s3a.path.style.access", (Function1<BoxedUnit, Validated<Object, Option<SensitiveArg<String>>>>)(Function1 & Serializable & scala.Serializable)x$15 -> ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)None$.MODULE$))));
    }

    public Validated<Object, Option<String>> getBackupServerNode(Map<String, String> config) {
        Validated validated;
        Option option = config.get((Object)"backup_server_node");
        if (option instanceof Some) {
            Some some = (Some)option;
            String backUpServer = (String)some.value();
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new Some((Object)backUpServer)));
        } else if (None$.MODULE$.equals(option)) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)None$.MODULE$));
        } else {
            throw new MatchError((Object)option);
        }
        return validated;
    }

    private Validated<Object, Option<SensitiveArg<String>>> getSensitiveOption(Visibility visibility, Map<String, String> config, String connectorOption, String sparkConfigOption, String envVar) {
        return this.getSensitiveArgFromConnectorOptions(visibility, config, connectorOption, (Function1<BoxedUnit, Validated<Object, Option<SensitiveArg<String>>>>)(Function1 & Serializable & scala.Serializable)x$16 -> MODULE$.getSensitiveArgFromSparkConfigOptions(visibility, sparkConfigOption, (Function1<BoxedUnit, Validated<Object, Option<SensitiveArg<String>>>>)(Function1 & Serializable & scala.Serializable)x$17 -> MODULE$.getSensitiveArgFromEnvVar(visibility, envVar)));
    }

    private DSConfigSetupUtils.SensitiveOptionFound getSensitiveOptionWithName(Visibility visibility, Map<String, String> config, String connectorOption, String sparkConfigOption, String envVar) {
        return new DSConfigSetupUtils.SensitiveOptionFound(this.getSensitiveOption(visibility, config, connectorOption, sparkConfigOption, envVar), connectorOption);
    }

    private Validated<Object, Option<SensitiveArg<String>>> getSensitiveArgFromConnectorOptions(Visibility visibility, Map<String, String> config, String connectorOption, Function1<BoxedUnit, Validated<Object, Option<SensitiveArg<String>>>> next) {
        Validated validated;
        Option option = config.get((Object)connectorOption);
        if (option instanceof Some) {
            Some some = (Some)option;
            String token = (String)some.value();
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new Some(new SensitiveArg<String>(visibility, ConnectorOption$.MODULE$, token))));
        } else if (None$.MODULE$.equals(option)) {
            validated = (Validated)next.apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError((Object)option);
        }
        return validated;
    }

    private Validated<Object, Option<SensitiveArg<String>>> getSensitiveArgFromSparkConfigOptions(Visibility visibility, String sparkConfigOption, Function1<BoxedUnit, Validated<Object, Option<SensitiveArg<String>>>> next) {
        Validated validated;
        Option option = SparkSession$.MODULE$.getActiveSession();
        if (option instanceof Some) {
            Validated validated2;
            Some some = (Some)option;
            SparkSession session = (SparkSession)some.value();
            SparkConf sparkConf = session.sparkContext().getConf();
            Option option2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> sparkConf.get(sparkConfigOption)).toOption();
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String token = (String)some2.value();
                validated2 = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new Some(new SensitiveArg<String>(visibility, SparkConf$.MODULE$, token))));
            } else if (None$.MODULE$.equals(option2)) {
                validated2 = (Validated)next.apply((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError((Object)option2);
            }
            validated = validated2;
        } else if (None$.MODULE$.equals(option)) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new LoadConfigMissingSparkSessionError()));
        } else {
            throw new MatchError((Object)option);
        }
        return validated;
    }

    private Validated<Object, Option<SensitiveArg<String>>> getSensitiveArgFromEnvVar(Visibility visibility, String envVar) {
        return ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)package$.MODULE$.env().get((Object)envVar).map((Function1 & Serializable & scala.Serializable)token -> new SensitiveArg<String>(visibility, EnvVar$.MODULE$, (String)token))));
    }

    public Validated<Object, Option<String>> getKeyStorePath(Map<String, String> config) {
        return ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)config.get((Object)"key_store_path")));
    }

    public Validated<Object, Option<String>> getKeyStorePassword(Map<String, String> config) {
        return ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)config.get((Object)"key_store_password")));
    }

    public Validated<Object, Option<String>> getTrustStorePath(Map<String, String> config) {
        return ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)config.get((Object)"trust_store_path")));
    }

    public Validated<Object, Option<String>> getTrustStorePassword(Map<String, String> config) {
        return ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)config.get((Object)"trust_store_password")));
    }

    public Option<String> getTablename(Map<String, String> config) {
        return config.get((Object)"table");
    }

    public Option<String> getQuery(Map<String, String> config) {
        None$ none$;
        Option option = config.get((Object)"query");
        if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            none$ = new Some((Object)new StringOps(Predef$.MODULE$.augmentString(value)).stripSuffix(";"));
        } else {
            throw new MatchError((Object)option);
        }
        return none$;
    }

    public Option<String> getDbSchema(Map<String, String> config) {
        return config.get((Object)"dbschema");
    }

    public Validated<Object, Option<String>> getTargetTableSQL(Map<String, String> config) {
        return ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)config.get((Object)"target_table_sql")));
    }

    public Validated<Object, Option<ValidColumnList>> getCopyColumnList(Map<String, String> config) {
        Validated<Object, Option<ValidColumnList>> validated;
        Option option = config.get((Object)"copy_column_list");
        if (None$.MODULE$.equals(option)) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)None$.MODULE$));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String listStr = (String)some.value();
            validated = ValidColumnList$.MODULE$.apply(listStr);
        } else {
            throw new MatchError((Object)option);
        }
        return validated;
    }

    public Validated<Object, ValidFilePermissions> getFilePermissions(Map<String, String> config) {
        Validated<Object, ValidFilePermissions> validated;
        Option option = config.get((Object)"file_permissions");
        if (None$.MODULE$.equals(option)) {
            validated = ValidFilePermissions$.MODULE$.apply("700");
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String str = (String)some.value();
            validated = ValidFilePermissions$.MODULE$.apply(str);
        } else {
            throw new MatchError((Object)option);
        }
        return validated;
    }

    public Validated<Object, Option<Object>> getPartitionCount(Map<String, String> config) {
        Validated validated;
        Option option = config.get((Object)"num_partitions");
        if (option instanceof Some) {
            Validated validated2;
            Some some = (Some)option;
            String partitionCount = (String)some.value();
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(partitionCount)).toInt());
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                int i = BoxesRunTime.unboxToInt((Object)success.value());
                validated2 = i > 0 ? ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new Some((Object)BoxesRunTime.boxToInteger((int)i)))) : ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new InvalidPartitionCountError()));
            } else if (try_ instanceof Failure) {
                validated2 = ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new InvalidPartitionCountError()));
            } else {
                throw new MatchError((Object)try_);
            }
            validated = validated2;
        } else if (None$.MODULE$.equals(option)) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)None$.MODULE$));
        } else {
            throw new MatchError((Object)option);
        }
        return validated;
    }

    public Validated<Object, Object> getStrLen(Map<String, String> config) {
        Validated validated;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)config.getOrElse((Object)"strlen", (Function0 & Serializable & scala.Serializable)() -> "1024"))).toLong());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            long i = BoxesRunTime.unboxToLong((Object)success.value());
            validated = i >= 1L && i <= 32000000L ? ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)BoxesRunTime.boxToLong((long)i))) : ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new InvalidStrlenError()));
        } else if (try_ instanceof Failure) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new InvalidStrlenError()));
        } else {
            throw new MatchError((Object)try_);
        }
        return validated;
    }

    public Validated<Object, Option<ValidColumnList>> getMergeKey(Map<String, String> config) {
        Validated<Object, Option<ValidColumnList>> validated;
        Option option = config.get((Object)"merge_key");
        if (None$.MODULE$.equals(option)) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)None$.MODULE$));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String listStr = (String)some.value();
            validated = ValidColumnList$.MODULE$.apply(listStr);
        } else {
            throw new MatchError((Object)option);
        }
        return validated;
    }

    public Validated<Object, Object> getPreventCleanup(Map<String, String> config) {
        Validated validated;
        Option option = config.get((Object)"prevent_cleanup");
        if (option instanceof Some) {
            Some some = (Some)option;
            String str = (String)some.value();
            String string = str;
            Validated validated2 = "true".equals(string) ? ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)BoxesRunTime.boxToBoolean((boolean)true))) : ("false".equals(string) ? ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)BoxesRunTime.boxToBoolean((boolean)false))) : ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new InvalidPreventCleanupOption())));
            validated = validated2;
        } else if (None$.MODULE$.equals(option)) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        } else {
            throw new MatchError((Object)option);
        }
        return validated;
    }

    public Validated<Object, Object> getTimeOperations(Map<String, String> config) {
        Validated validated;
        Option option = config.get((Object)"time_operations");
        if (option instanceof Some) {
            Some some = (Some)option;
            String str = (String)some.value();
            String string = str;
            Validated validated2 = "true".equals(string) ? ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)BoxesRunTime.boxToBoolean((boolean)true))) : ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)BoxesRunTime.boxToBoolean((boolean)false)));
            validated = validated2;
        } else if (None$.MODULE$.equals(option)) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        } else {
            throw new MatchError((Object)option);
        }
        return validated;
    }

    public Validated<Object, Object> getArrayLength(Map<String, String> config) {
        Validated validated;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString((String)config.getOrElse((Object)"array_length", (Function0 & Serializable & scala.Serializable)() -> "0"))).toLong());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            long len = BoxesRunTime.unboxToLong((Object)success.value());
            validated = len < 0L ? ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new InvalidArrayLengthError())) : ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)BoxesRunTime.boxToLong((long)len)));
        } else if (try_ instanceof Failure) {
            validated = ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new InvalidArrayLengthError()));
        } else {
            throw new MatchError((Object)try_);
        }
        return validated;
    }

    public Validated<Object, Object> getJsonOption(Map<String, String> config) {
        return ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString((String)config.getOrElse((Object)"json", (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Validated<Object, JdbcAuth> validateAndGetJDBCAuth(Map<String, String> config) {
        Option option;
        Option<String> jaasConfig;
        Option<String> hostname;
        Option<String> serviceName;
        Option<String> password;
        Option<String> user = this.getUser(config);
        Tuple5 tuple5 = new Tuple5(user, password = this.getPassword(config), serviceName = this.getKerberosServiceName(config), hostname = this.getKerberosHostname(config), jaasConfig = this.getJaasConfigName(config));
        if (tuple5 != null) {
            Option option2 = (Option)tuple5._1();
            Option option3 = (Option)tuple5._3();
            Option option4 = (Option)tuple5._4();
            Option option5 = (Option)tuple5._5();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String u = (String)some.value();
                if (option3 instanceof Some) {
                    Some some2 = (Some)option3;
                    String s = (String)some2.value();
                    if (option4 instanceof Some) {
                        Some some3 = (Some)option4;
                        String h = (String)some3.value();
                        if (option5 instanceof Some) {
                            Some some4 = (Some)option5;
                            String j = (String)some4.value();
                            return ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new KerberosAuth(u, s, h, j)));
                        }
                    }
                }
            }
        }
        if (tuple5 != null) {
            Option option6 = (Option)tuple5._1();
            Option option7 = (Option)tuple5._2();
            if (option6 instanceof Some) {
                Some some = (Some)option6;
                String u = (String)some.value();
                if (option7 instanceof Some) {
                    Some some5 = (Some)option7;
                    String p = (String)some5.value();
                    return ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new BasicJdbcAuth(u, p)));
                }
            }
        }
        if (tuple5 != null && None$.MODULE$.equals(option = (Option)tuple5._1())) {
            return ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new UserMissingError()));
        }
        if (tuple5 != null) {
            Option option8 = (Option)tuple5._2();
            Option option9 = (Option)tuple5._3();
            Option option10 = (Option)tuple5._4();
            Option option11 = (Option)tuple5._5();
            if (None$.MODULE$.equals(option8) && None$.MODULE$.equals(option9) && None$.MODULE$.equals(option10) && None$.MODULE$.equals(option11)) {
                return ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new PasswordMissingError()));
            }
        }
        if (tuple5 == null) throw new MatchError((Object)tuple5);
        return ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new KerberosAuthMissingError()));
    }

    public Validated<Object, JDBCTLSConfig> validateAndGetJDBCSSLConfig(Map<String, String> config) {
        return (Validated)implicits$.MODULE$.catsSyntaxTuple5Semigroupal(new Tuple5(this.getTLS(config), this.getKeyStorePath(config), this.getKeyStorePassword(config), this.getTrustStorePath(config), this.getTrustStorePassword(config))).mapN((Function5)JDBCTLSConfig$.MODULE$, (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()));
    }

    public Validated<Object, JDBCConfig> validateAndGetJDBCConfig(Map<String, String> config) {
        return (Validated)implicits$.MODULE$.catsSyntaxTuple6Semigroupal(new Tuple6(this.getHost(config), this.getPort(config), this.getDb(config), this.validateAndGetJDBCAuth(config), this.validateAndGetJDBCSSLConfig(config), this.getBackupServerNode(config))).mapN((Function6)JDBCConfig$.MODULE$, (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()));
    }

    public Validated<Object, FileStoreConfig> validateAndGetFilestoreConfig(Map<String, String> config, String sessionId) {
        Validated awsOptions = (Validated)implicits$.MODULE$.catsSyntaxTuple7Semigroupal(new Tuple7(this.getAWSAuth(config), this.getAWSRegion(config), this.getAWSSessionToken(config), this.getAWSCredentialsProvider(config), this.getAWSEndpoint(config), this.getAWSSSLEnabled(config), this.getAWSPathStyleEnabled(config))).mapN((Function7)AWSOptions$.MODULE$, (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()));
        Validated gcsOptions = (Validated)implicits$.MODULE$.catsSyntaxTuple3Semigroupal(new Tuple3(this.getVerticaGCSAuth(config), this.getGCSKeyFile(config), this.getGCSServiceAccountAuth(config))).mapN((Function3)GCSOptions$.MODULE$, (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()));
        return (Validated)implicits$.MODULE$.catsSyntaxTuple5Semigroupal(new Tuple5(this.getStagingFsUrl(config), (Object)ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)sessionId)), this.getPreventCleanup(config), (Object)awsOptions, (Object)gcsOptions)).mapN((Function5)FileStoreConfig$.MODULE$, (Functor)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()), (Semigroupal)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyChainImpl$.MODULE$.catsDataSemigroupForNonEmptyChain()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Validated<Object, TableSource> validateAndGetTableSource(Map<String, String> config) {
        Option option;
        Option<String> name = this.getTablename(config);
        Option<String> schema = this.getDbSchema(config);
        Option<String> query = this.getQuery(config);
        Tuple2 tuple2 = new Tuple2(query, name);
        if (tuple2 != null && (option = (Option)tuple2._1()) instanceof Some) {
            Some some = (Some)option;
            String q = (String)some.value();
            return ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new TableQuery(q, SessionId$.MODULE$.getId())));
        }
        if (tuple2 != null) {
            Option option2 = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option2) && option3 instanceof Some) {
                Some some = (Some)option3;
                String n = (String)some.value();
                return ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new TableName(n, schema)));
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option option4 = (Option)tuple2._1();
        Option option5 = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option4)) throw new MatchError((Object)tuple2);
        if (!None$.MODULE$.equals(option5)) throw new MatchError((Object)tuple2);
        return ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new TableAndQueryMissingError()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Validated<Object, TableName> validateAndGetFullTableName(Map<String, String> config) {
        Option option;
        Option<String> name = this.getTablename(config);
        Option<String> schema = this.getDbSchema(config);
        Option<String> query = this.getQuery(config);
        Tuple2 tuple2 = new Tuple2(query, name);
        if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some) {
            Some some = (Some)option;
            String n = (String)some.value();
            return ValidatedIdOpsBinCompat0$.MODULE$.validNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new TableName(n, schema)));
        }
        if (tuple2 != null) {
            Option option2 = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option2 instanceof Some && None$.MODULE$.equals(option3)) {
                return ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new QuerySpecifiedOnWriteError()));
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option option4 = (Option)tuple2._1();
        Option option5 = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option4)) throw new MatchError((Object)tuple2);
        if (!None$.MODULE$.equals(option5)) throw new MatchError((Object)tuple2);
        return ValidatedIdOpsBinCompat0$.MODULE$.invalidNec$extension(implicits$.MODULE$.catsSyntaxValidatedIdBinCompat0((Object)new TablenameMissingError()));
    }

    public static final /* synthetic */ boolean $anonfun$checkOldConnectorOptions$1(Map config$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String old = (String)tuple2._1();
        boolean bl = config$1.contains((Object)old);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$logOrAppendErrorsForOldConnectorOptions$1(Logger logger$1, ConnectorError m) {
        BoxedUnit boxedUnit;
        if (logger$1.underlying().isWarnEnabled()) {
            logger$1.underlying().warn(m.getUserMessage());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getGCSServiceAccountAuth$1(DSConfigSetupUtils.SensitiveOptionFound x$2) {
        return x$2.option().isInvalid();
    }

    public static final /* synthetic */ boolean $anonfun$getGCSServiceAccountAuth$2(DSConfigSetupUtils.SensitiveOptionFound x$3) {
        return x$3.option().isValid();
    }

    private DSConfigSetupUtils$() {
        MODULE$ = this;
    }
}

