/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.core;

import cats.Applicative;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.DistributedFilesystemReadConfig;
import com.vertica.spark.config.FileStoreConfig;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.config.TableQuery;
import com.vertica.spark.config.TableSource;
import com.vertica.spark.config.ValidFilePermissions;
import com.vertica.spark.config.VerticaMetadata;
import com.vertica.spark.config.VerticaReadMetadata;
import com.vertica.spark.datasource.core.DataBlock;
import com.vertica.spark.datasource.core.PartitionInfo;
import com.vertica.spark.datasource.core.PartitionInfo$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe$;
import com.vertica.spark.datasource.core.VerticaPartition;
import com.vertica.spark.datasource.core.VerticaPipeInterface;
import com.vertica.spark.datasource.core.VerticaPipeReadInterface;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.fs.ParquetFileMetadata;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.partitions.parquet.ParquetFileRange;
import com.vertica.spark.datasource.partitions.parquet.VerticaDistributedFilesystemPartition;
import com.vertica.spark.datasource.v2.PushdownFilter;
import com.vertica.spark.util.Timer;
import com.vertica.spark.util.cleanup.CleanupUtilsInterface;
import com.vertica.spark.util.cleanup.DistributedFilesCleaner;
import com.vertica.spark.util.cleanup.FileCleanupInfo;
import com.vertica.spark.util.error.BinaryTypeNotSupported;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.CreateDirectoryAlreadyExistsError;
import com.vertica.spark.util.error.DoneReading;
import com.vertica.spark.util.error.ErrorList;
import com.vertica.spark.util.error.ExportFromVerticaError;
import com.vertica.spark.util.error.InvalidPartition;
import com.vertica.spark.util.error.UninitializedReadError;
import com.vertica.spark.util.listeners.ApplicationParquetCleaner;
import com.vertica.spark.util.listeners.SparkContextWrapper;
import com.vertica.spark.util.schema.ColumnDef;
import com.vertica.spark.util.schema.SchemaToolsInterface;
import com.vertica.spark.util.version.VerticaVersion;
import com.vertica.spark.util.version.VerticaVersionUtils$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple7;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t=g\u0001\u0002\u001b6\u0001\u0001C\u0001B\u0014\u0001\u0003\u0006\u0004%\ta\u0014\u0005\t+\u0002\u0011\t\u0011)A\u0005!\"Aa\u000b\u0001BC\u0002\u0013\u0005q\u000b\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003Y\u0011!y\u0006A!b\u0001\n\u0003\u0001\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011B1\t\u0011!\u0004!Q1A\u0005\u0002%D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\tg\u0002\u0011)\u0019!C\u0001i\"A1\u0010\u0001B\u0001B\u0003%Q\u000f\u0003\u0005}\u0001\t\u0015\r\u0011\"\u0001~\u0011%\tI\u0001\u0001B\u0001B\u0003%a\u0010\u0003\u0006\u0002\f\u0001\u0011)\u0019!C\u0001\u0003\u001bA!\"!\u0006\u0001\u0005\u0003\u0005\u000b\u0011BA\b\u0011\u001d\t9\u0002\u0001C\u0001\u00033A\u0011\"a\u000b\u0001\u0005\u0004%I!!\f\t\u0011\u0005}\u0002\u0001)A\u0005\u0003_A\u0011\"!\u0011\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003\u001fA\u0011\"!\u0012\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003\u001fAq!!\u0013\u0001\t\u0013\tY\u0005C\u0004\u0002\u0000\u0001!I!!!\t\u000f\u0005U\u0006\u0001\"\u0011\u00028\"9\u0011\u0011\u0018\u0001\u0005B\u0005m\u0006bBAc\u0001\u0011%\u0011q\u0019\u0005\b\u0003C\u0004A\u0011BAr\u0011\u001d\ty\u0010\u0001C\u0005\u0005\u0003AqA!\u0002\u0001\t\u0013\u0011\t\u0001C\u0004\u0003\b\u0001!IA!\u0003\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e!9!Q\u0006\u0001\u0005B\t=\u0002b\u0002B\u001a\u0001\u0011%!Q\u0007\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0011%\u0011I\u0005\u0001a\u0001\n\u0003\u0011Y\u0005C\u0005\u0003d\u0001\u0001\r\u0011\"\u0001\u0003f!A!1\u000e\u0001!B\u0013\u0011i\u0005C\u0005\u0003n\u0001\u0001\r\u0011\"\u0001\u0002\u000e!I!q\u000e\u0001A\u0002\u0013\u0005!\u0011\u000f\u0005\t\u0005k\u0002\u0001\u0015)\u0003\u0002\u0010!I!q\u000f\u0001C\u0002\u0013%!\u0011\u0010\u0005\t\u0005\u0003\u0003\u0001\u0015!\u0003\u0003|!I!1\u0011\u0001C\u0002\u0013\u0005!Q\u0011\u0005\t\u0005\u001f\u0003\u0001\u0015!\u0003\u0003\b\"9!\u0011\u0013\u0001\u0005\u0002\tM\u0005b\u0002BP\u0001\u0011\u0005!\u0011\u0015\u0005\b\u0005W\u0003A\u0011\u0001BW\u000f%\u0011y+NA\u0001\u0012\u0003\u0011\tL\u0002\u00055k\u0005\u0005\t\u0012\u0001BZ\u0011\u001d\t9\"\rC\u0001\u0005kC\u0011Ba.2#\u0003%\tA!/\u0003IY+'\u000f^5dC\u0012K7\u000f\u001e:jEV$X\r\u001a$jY\u0016\u001c\u0018p\u001d;f[J+\u0017\r\u001a)ja\u0016T!AN\u001c\u0002\t\r|'/\u001a\u0006\u0003qe\n!\u0002Z1uCN|WO]2f\u0015\tQ4(A\u0003ta\u0006\u00148N\u0003\u0002={\u00059a/\u001a:uS\u000e\f'\"\u0001 \u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001\tui\u0013\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!KU\"A\u001b\n\u0005)+$\u0001\u0006,feRL7-\u0019)ja\u0016Le\u000e^3sM\u0006\u001cW\r\u0005\u0002I\u0019&\u0011Q*\u000e\u0002\u0019-\u0016\u0014H/[2b!&\u0004XMU3bI&sG/\u001a:gC\u000e,\u0017AB2p]\u001aLw-F\u0001Q!\t\t6+D\u0001S\u0015\tq\u0015(\u0003\u0002U%\nyB)[:ue&\u0014W\u000f^3e\r&dWm]=ti\u0016l'+Z1e\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005qa-\u001b7f'R|'/\u001a'bs\u0016\u0014X#\u0001-\u0011\u0005ecV\"\u0001.\u000b\u0005m;\u0014A\u00014t\u0013\ti&LA\fGS2,7\u000b^8sK2\u000b\u00170\u001a:J]R,'OZ1dK\u0006ya-\u001b7f'R|'/\u001a'bs\u0016\u0014\b%A\u0005kI\n\u001cG*Y=feV\t\u0011\r\u0005\u0002cK6\t1M\u0003\u0002eo\u0005!!\u000e\u001a2d\u0013\t17M\u0001\nKI\n\u001cG*Y=fe&sG/\u001a:gC\u000e,\u0017A\u00036eE\u000ed\u0015-_3sA\u0005Y1o\u00195f[\u0006$vn\u001c7t+\u0005Q\u0007CA6q\u001b\u0005a'BA7o\u0003\u0019\u00198\r[3nC*\u0011q.O\u0001\u0005kRLG.\u0003\u0002rY\n!2k\u00195f[\u0006$vn\u001c7t\u0013:$XM\u001d4bG\u0016\fAb]2iK6\fGk\\8mg\u0002\nAb\u00197fC:,\b/\u0016;jYN,\u0012!\u001e\t\u0003mfl\u0011a\u001e\u0006\u0003q:\fqa\u00197fC:,\b/\u0003\u0002{o\n)2\t\\3b]V\u0004X\u000b^5mg&sG/\u001a:gC\u000e,\u0017!D2mK\u0006tW\u000f]+uS2\u001c\b%\u0001\u0007ta\u0006\u00148nQ8oi\u0016DH/F\u0001\u007f!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001o\u0003%a\u0017n\u001d;f]\u0016\u00148/\u0003\u0003\u0002\b\u0005\u0005!aE*qCJ\\7i\u001c8uKb$xK]1qa\u0016\u0014\u0018!D:qCJ\\7i\u001c8uKb$\b%\u0001\u0005eCR\f7+\u001b>f+\t\ty\u0001E\u0002C\u0003#I1!a\u0005D\u0005\rIe\u000e^\u0001\nI\u0006$\u0018mU5{K\u0002\na\u0001P5oSRtD\u0003EA\u000e\u0003;\ty\"!\t\u0002$\u0005\u0015\u0012qEA\u0015!\tA\u0005\u0001C\u0003O\u001f\u0001\u0007\u0001\u000bC\u0003W\u001f\u0001\u0007\u0001\fC\u0003`\u001f\u0001\u0007\u0011\rC\u0003i\u001f\u0001\u0007!\u000eC\u0003t\u001f\u0001\u0007Q\u000fC\u0003}\u001f\u0001\u0007a\u0010C\u0005\u0002\f=\u0001\n\u00111\u0001\u0002\u0010\u00051An\\4hKJ,\"!a\f\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u0005a1oY1mC2|wmZ5oO*\u0019\u0011\u0011H\u001f\u0002\u0011QL\b/Z:bM\u0016LA!!\u0010\u00024\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0006nCb4\u0015\u000e\\3TSj,\u0017\u0001D7bq\u001aKG.Z*ju\u0016\u0004\u0013aD7bqJ{wo\u0012:pkB\u001c\u0016N_3\u0002!5\f\u0007PU8x\u000fJ|W\u000f]*ju\u0016\u0004\u0013\u0001\u0005:fiJLWM^3NKR\fG-\u0019;b)\t\ti\u0005\u0005\u0004\u0002P\u0005M\u0014\u0011\u0010\b\u0005\u0003#\niG\u0004\u0003\u0002T\u0005%d\u0002BA+\u0003OrA!a\u0016\u0002f9!\u0011\u0011LA2\u001d\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0\u007f\u00051AH]8pizJ\u0011AP\u0005\u0003yuJ!AO\u001e\n\u0005=L\u0014bAA6]\u0006)QM\u001d:pe&!\u0011qNA9\u00035)%O]8s\u0011\u0006tG\r\\5oO*\u0019\u00111\u000e8\n\t\u0005U\u0014q\u000f\u0002\u0010\u0007>tg.Z2u_J\u0014Vm];mi*!\u0011qNA9!\r\t\u00161P\u0005\u0004\u0003{\u0012&a\u0004,feRL7-Y'fi\u0006$\u0017\r^1\u0002%\u0005$G\rU;tQ\u0012|wO\u001c$jYR,'o\u001d\u000b\u0005\u0003\u0007\u000b\u0019\n\u0005\u0003\u0002\u0006\u00065e\u0002BAD\u0003\u0013\u00032!a\u0017D\u0013\r\tYiQ\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0015\u0011\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-5\tC\u0004\u0002\u0016^\u0001\r!a&\u0002\u001fA,8\u000f\u001b3po:4\u0015\u000e\u001c;feN\u0004b!!'\u0002$\u0006%f\u0002BAN\u0003?sA!a\u0017\u0002\u001e&\tA)C\u0002\u0002\"\u000e\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002&\u0006\u001d&\u0001\u0002'jgRT1!!)D!\u0011\tY+!-\u000e\u0005\u00055&bAAXo\u0005\u0011aOM\u0005\u0005\u0003g\u000biK\u0001\bQkNDGm\\<o\r&dG/\u001a:\u0002\u0017\u001d,G/T3uC\u0012\fG/Y\u000b\u0003\u0003\u001b\n\u0001cZ3u\t\u0006$\u0018M\u00117pG.\u001c\u0016N_3\u0016\u0005\u0005u\u0006CBA(\u0003g\ny\fE\u0002C\u0003\u0003L1!a1D\u0005\u0011auN\\4\u00023%t7M]3nK:$(+\u00198hK6\u000b\u0007oR3u\u0013:$W\r\u001f\u000b\u0007\u0003\u001f\tI-!8\t\u000f\u0005-'\u00041\u0001\u0002N\u0006\u0019Q.\u00199\u0011\u0011\u0005=\u0017\u0011\\AB\u0003\u001fi!!!5\u000b\t\u0005M\u0017Q[\u0001\b[V$\u0018M\u00197f\u0015\r\t9nQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAn\u0003#\u00141!T1q\u0011\u001d\tyN\u0007a\u0001\u0003\u0007\u000b\u0001BZ5mK:\fW.Z\u0001\u0011O\u0016$\b+\u0019:uSRLwN\\%oM>$b!!:\u0002l\u0006m\bc\u0001%\u0002h&\u0019\u0011\u0011^\u001b\u0003\u001bA\u000b'\u000f^5uS>t\u0017J\u001c4p\u0011\u001d\tio\u0007a\u0001\u0003_\fABZ5mK6+G/\u00193bi\u0006\u0004b!!'\u0002r\u0006U\u0018\u0002BAz\u0003O\u00131aU3r!\rI\u0016q_\u0005\u0004\u0003sT&a\u0005)beF,X\r\u001e$jY\u0016lU\r^1eCR\f\u0007bBA\u007f7\u0001\u0007\u0011qB\u0001\u0018e\u0016\fX/Z:uK\u0012\u0004\u0016M\u001d;ji&|gnQ8v]R\fqbZ3u'\u0016dWm\u0019;DY\u0006,8/Z\u000b\u0003\u0005\u0007\u0001b!a\u0014\u0002t\u0005\r\u0015aG4fiB+8\u000f\u001b3po:\fum\u001a:fO\u0006$XmQ8mk6t7/\u0001\thKR<%o\\;qEf\u001cE.Y;tKV\u0011\u00111Q\u0001\u000fO\u0016$8i\u001c7v[:t\u0015-\\3t)\u0011\u0011\u0019Aa\u0004\t\u000f\tEq\u00041\u0001\u0003\u0014\u0005q!/Z9vSJ,GmU2iK6\f\u0007\u0003\u0002B\u000b\u0005Si!Aa\u0006\u000b\t\te!1D\u0001\u0006if\u0004Xm\u001d\u0006\u0005\u0005;\u0011y\"A\u0002tc2T1A\u000fB\u0011\u0015\u0011\u0011\u0019C!\n\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\u00119#A\u0002pe\u001eLAAa\u000b\u0003\u0018\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u001d\u0011|\u0007K]3SK\u0006$7\u000b^3qgR\u0011!\u0011\u0007\t\u0007\u0003\u001f\n\u0019(!:\u00023\rDWmY6WKJ\u001c\u0018n\u001c8D_6\u0004\u0018\r^5cS2LG/\u001f\u000b\u0005\u0005o\u0011y\u0004\u0005\u0004\u0002P\u0005M$\u0011\b\t\u0004\u0005\nm\u0012b\u0001B\u001f\u0007\n!QK\\5u\u0011\u0015q\u0015\u00051\u0001Q\u0003m\u0019\u0007.Z2l\u0015N{e*\u0012=q_J$H+\u001f9fgN+\b\u000f]8siR!!q\u0007B#\u0011\u0019\u00119E\ta\u0001!\u0006Q!/Z1e\u0007>tg-[4\u0002\u0013A\f'\u000f^5uS>tWC\u0001B'!\u0015\u0011%q\nB*\u0013\r\u0011\tf\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\tU#qL\u0007\u0003\u0005/RAA!\u0017\u0003\\\u00059\u0001/\u0019:rk\u0016$(b\u0001B/o\u0005Q\u0001/\u0019:uSRLwN\\:\n\t\t\u0005$q\u000b\u0002&-\u0016\u0014H/[2b\t&\u001cHO]5ckR,GMR5mKNL8\u000f^3n!\u0006\u0014H/\u001b;j_:\fQ\u0002]1si&$\u0018n\u001c8`I\u0015\fH\u0003\u0002B\u001d\u0005OB\u0011B!\u001b%\u0003\u0003\u0005\rA!\u0014\u0002\u0007a$\u0013'\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\nqAZ5mK&#\u00070A\u0006gS2,\u0017\n\u001a=`I\u0015\fH\u0003\u0002B\u001d\u0005gB\u0011B!\u001b(\u0003\u0003\u0005\r!a\u0004\u0002\u0011\u0019LG.Z%eq\u0002\nqa\u00197fC:,'/\u0006\u0002\u0003|A\u0019aO! \n\u0007\t}tOA\fESN$(/\u001b2vi\u0016$g)\u001b7fg\u000ecW-\u00198fe\u0006A1\r\\3b]\u0016\u0014\b%A\u0003uS6,'/\u0006\u0002\u0003\bB!!\u0011\u0012BF\u001b\u0005q\u0017b\u0001BG]\n)A+[7fe\u00061A/[7fe\u0002\n!c\u001d;beR\u0004\u0016M\u001d;ji&|gNU3bIR!!q\u0007BK\u0011\u001d\u00119*\fa\u0001\u00053\u000b\u0001C^3si&\u001c\u0017\rU1si&$\u0018n\u001c8\u0011\u0007!\u0013Y*C\u0002\u0003\u001eV\u0012\u0001CV3si&\u001c\u0017\rU1si&$\u0018n\u001c8\u0002\u0011I,\u0017\r\u001a#bi\u0006,\"Aa)\u0011\r\u0005=\u00131\u000fBS!\rA%qU\u0005\u0004\u0005S+$!\u0003#bi\u0006\u0014En\\2l\u0003A)g\u000e\u001a)beRLG/[8o%\u0016\fG\r\u0006\u0002\u00038\u0005!c+\u001a:uS\u000e\fG)[:ue&\u0014W\u000f^3e\r&dWm]=ti\u0016l'+Z1e!&\u0004X\r\u0005\u0002IcM\u0011\u0011'\u0011\u000b\u0003\u0005c\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012:TC\u0001B^U\u0011\tyA!0,\u0005\t}\u0006\u0003\u0002Ba\u0005\u0017l!Aa1\u000b\t\t\u0015'qY\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!3D\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001b\u0014\u0019MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class VerticaDistributedFilesystemReadPipe
implements VerticaPipeInterface,
VerticaPipeReadInterface {
    private final DistributedFilesystemReadConfig config;
    private final FileStoreLayerInterface fileStoreLayer;
    private final JdbcLayerInterface jdbcLayer;
    private final SchemaToolsInterface schemaTools;
    private final CleanupUtilsInterface cleanupUtils;
    private final SparkContextWrapper sparkContext;
    private final int dataSize;
    private final Logger logger;
    private final int maxFileSize;
    private final int maxRowGroupSize;
    private Option<VerticaDistributedFilesystemPartition> partition;
    private int fileIdx;
    private final DistributedFilesCleaner cleaner;
    private final Timer timer;

    public static int $lessinit$greater$default$7() {
        return VerticaDistributedFilesystemReadPipe$.MODULE$.$lessinit$greater$default$7();
    }

    public DistributedFilesystemReadConfig config() {
        return this.config;
    }

    public FileStoreLayerInterface fileStoreLayer() {
        return this.fileStoreLayer;
    }

    public JdbcLayerInterface jdbcLayer() {
        return this.jdbcLayer;
    }

    public SchemaToolsInterface schemaTools() {
        return this.schemaTools;
    }

    public CleanupUtilsInterface cleanupUtils() {
        return this.cleanupUtils;
    }

    public SparkContextWrapper sparkContext() {
        return this.sparkContext;
    }

    public int dataSize() {
        return this.dataSize;
    }

    private Logger logger() {
        return this.logger;
    }

    private int maxFileSize() {
        return this.maxFileSize;
    }

    private int maxRowGroupSize() {
        return this.maxRowGroupSize;
    }

    private Either<ConnectorError, VerticaMetadata> retrieveMetadata() {
        Right right;
        Either<ConnectorError, StructType> either = this.schemaTools().readSchema(this.jdbcLayer(), this.config().tableSource());
        if (either instanceof Right) {
            Right right2 = (Right)either;
            StructType schema = (StructType)right2.value();
            right = package$.MODULE$.Right().apply((Object)new VerticaReadMetadata(schema));
        } else if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            right = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError(either);
        }
        return right;
    }

    private String addPushdownFilters(List<PushdownFilter> pushdownFilters) {
        List<PushdownFilter> list = pushdownFilters;
        String string = Nil$.MODULE$.equals(list) ? "" : new StringBuilder(7).append(" WHERE ").append(((TraversableOnce)pushdownFilters.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getFilterString(), List$.MODULE$.canBuildFrom())).mkString(" AND ")).toString();
        return string;
    }

    @Override
    public Either<ConnectorError, VerticaMetadata> getMetadata() {
        Right right;
        Option<VerticaReadMetadata> option = this.config().metadata();
        if (option instanceof Some) {
            Some some = (Some)option;
            VerticaReadMetadata data = (VerticaReadMetadata)some.value();
            right = package$.MODULE$.Right().apply((Object)data);
        } else if (None$.MODULE$.equals(option)) {
            right = this.retrieveMetadata();
        } else {
            throw new MatchError(option);
        }
        return right;
    }

    @Override
    public Either<ConnectorError, Object> getDataBlockSize() {
        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)this.dataSize()));
    }

    private int incrementRangeMapGetIndex(Map<String, Object> map, String filename) {
        if (!map.contains((Object)filename)) {
            map.update((Object)filename, (Object)BoxesRunTime.boxToInteger((int)1));
        } else {
            map.update((Object)filename, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)map.apply((Object)filename)) + 1)));
        }
        return BoxesRunTime.unboxToInt((Object)map.apply((Object)filename)) - 1;
    }

    private PartitionInfo getPartitionInfo(Seq<ParquetFileMetadata> fileMetadata, int requestedPartitionCount) {
        PartitionInfo partitionInfo;
        int totalRowGroups = BoxesRunTime.unboxToInt((Object)((TraversableOnce)fileMetadata.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.rowGroupCount()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        if (totalRowGroups == 0) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("No data. Returning empty partition list.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            partitionInfo = new PartitionInfo((InputPartition[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(InputPartition.class)), PartitionInfo$.MODULE$.apply$default$2());
        } else {
            BoxedUnit boxedUnit;
            ObjectRef partitions = ObjectRef.create((Object)Nil$.MODULE$);
            ObjectRef fileRanges = ObjectRef.create((Object)Nil$.MODULE$);
            Map rangeCountMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Creating partitions.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            int extraSpace = totalRowGroups % requestedPartitionCount == 0 ? 0 : 1;
            int maxSize = totalRowGroups / requestedPartitionCount + extraSpace;
            IntRef partitionSize = IntRef.create((int)0);
            fileMetadata.foreach((Function1 & Serializable & scala.Serializable)file -> {
                VerticaDistributedFilesystemReadPipe.$anonfun$getPartitionInfo$2(this, rangeCountMap, fileRanges, partitions, partitionSize, maxSize, file);
                return BoxedUnit.UNIT;
            });
            if (((List)fileRanges.elem).nonEmpty()) {
                VerticaDistributedFilesystemPartition partition = new VerticaDistributedFilesystemPartition((Seq<ParquetFileRange>)((List)fileRanges.elem), (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
                partitions.elem = (List)((List)partitions.elem).$colon$plus((Object)partition, List$.MODULE$.canBuildFrom());
            }
            partitions.elem = (List)((List)partitions.elem).map((Function1 & Serializable & scala.Serializable)part -> {
                scala.collection.immutable.Map x$1 = rangeCountMap.toMap(Predef$.MODULE$.$conforms());
                Seq<ParquetFileRange> x$2 = part.copy$default$1();
                return part.copy(x$2, (scala.collection.immutable.Map<String, Object>)x$1);
            }, List$.MODULE$.canBuildFrom());
            partitionInfo = new PartitionInfo((InputPartition[])((List)partitions.elem).toArray(ClassTag$.MODULE$.apply(InputPartition.class)), PartitionInfo$.MODULE$.apply$default$2());
        }
        return partitionInfo;
    }

    private Either<ConnectorError, String> getSelectClause() {
        return this.config().isAggPushedDown() ? this.getPushdownAggregateColumns() : this.getColumnNames(this.config().getRequiredSchema());
    }

    private Either<ConnectorError, String> getPushdownAggregateColumns() {
        String selectClause = ((TraversableOnce)this.config().getRequiredSchema().map((Function1 & Serializable & scala.Serializable)col -> new StringBuilder(6).append(col.name()).append(" as ").append("\"").append(col.name()).append("\"").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        return package$.MODULE$.Right().apply((Object)selectClause);
    }

    private String getGroupbyClause() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.config().getGroupBy())).nonEmpty() ? new StringBuilder(10).append(" GROUP BY ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.config().getGroupBy())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ")).toString() : "";
    }

    private Either<ConnectorError, String> getColumnNames(StructType requiredSchema) {
        Left left;
        Either<ConnectorError, Seq<ColumnDef>> either = this.schemaTools().getColumnInfo(this.jdbcLayer(), this.config().tableSource());
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err.context("Failed to get table schema when checking for fields that need casts."));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq columnDefs = (Seq)right.value();
            left = package$.MODULE$.Right().apply((Object)this.schemaTools().makeColumnsString((Seq<ColumnDef>)columnDefs, requiredSchema));
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Either<ConnectorError, PartitionInfo> doPreReadSteps() {
        fileStoreConfig = this.config().fileStoreConfig();
        v0 = new StringOps(Predef$.MODULE$.augmentString(fileStoreConfig.address())).takeRight(1);
        var5_2 = "/";
        if (!(v0 == null ? var5_2 != null : v0.equals(var5_2) == false)) ** GOTO lbl-1000
        v1 = new StringOps(Predef$.MODULE$.augmentString(fileStoreConfig.address())).takeRight(1);
        var6_3 = "\\";
        if (!(v1 != null ? v1.equals(var6_3) == false : var6_3 != null)) lbl-1000:
        // 2 sources

        {
            v2 = "";
        } else {
            v2 = "/";
        }
        delimiter = v2;
        exportPath = new StringBuilder(0).append(fileStoreConfig.address()).append(delimiter).append(this.config().tableSource().identifier()).toString();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(13).append("Export path: ").append(exportPath).toString());
            v3 = BoxedUnit.UNIT;
        } else {
            v3 = BoxedUnit.UNIT;
        }
        var9_6 = this.exportData$1(fileStoreConfig, exportPath);
        if (var9_6 instanceof Left) {
            var10_7 = (Left)var9_6;
            error = (ConnectorError)var10_7.value();
            var2_9 = package$.MODULE$.Left().apply((Object)error);
        } else if (var9_6 instanceof Right) {
            var2_9 = this.config().useJson() != false ? package$.MODULE$.Right().apply((Object)new PartitionInfo((InputPartition[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(InputPartition.class)), exportPath)) : this.getParquetPartitionInfo$1(exportPath);
        } else {
            throw new MatchError((Object)var9_6);
        }
        var12_11 = ret = var2_9;
        if (var12_11 instanceof Left) {
            if (!this.config().fileStoreConfig().preventCleanup()) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder(31).append("Cleaning up all files in path: ").append(exportPath).toString());
                    v4 = BoxedUnit.UNIT;
                } else {
                    v4 = BoxedUnit.UNIT;
                }
                v5 = this.cleanupUtils().cleanupAll(this.fileStoreLayer(), exportPath);
            } else {
                v5 = BoxedUnit.UNIT;
            }
            var1_12 = this.jdbcLayer().close();
        } else {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Reading data from Parquet file.");
                v6 = BoxedUnit.UNIT;
            } else {
                v6 = BoxedUnit.UNIT;
            }
            var1_12 = v6;
        }
        return ret;
    }

    private Either<ConnectorError, BoxedUnit> checkVersionCompatibility(DistributedFilesystemReadConfig config) {
        VerticaVersion version = VerticaVersionUtils$.MODULE$.getVersion(this.jdbcLayer());
        return VerticaVersionUtils$.MODULE$.checkSchemaTypesReadSupport(config.getRequiredSchema(), version).flatMap((Function1 & Serializable & scala.Serializable)_2 -> (config.useJson() ? VerticaVersionUtils$.MODULE$.checkJsonSupport(version) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).map((Function1 & Serializable & scala.Serializable)_ -> {
            VerticaDistributedFilesystemReadPipe.$anonfun$checkVersionCompatibility$2(_);
            return BoxedUnit.UNIT;
        }));
    }

    private Either<ConnectorError, BoxedUnit> checkJSONExportTypesSupport(DistributedFilesystemReadConfig readConfig) {
        boolean useJson = readConfig.useJson();
        return this.checkStructFields$1(readConfig.getRequiredSchema(), useJson);
    }

    public Option<VerticaDistributedFilesystemPartition> partition() {
        return this.partition;
    }

    public void partition_$eq(Option<VerticaDistributedFilesystemPartition> x$1) {
        this.partition = x$1;
    }

    public int fileIdx() {
        return this.fileIdx;
    }

    public void fileIdx_$eq(int x$1) {
        this.fileIdx = x$1;
    }

    private DistributedFilesCleaner cleaner() {
        return this.cleaner;
    }

    public Timer timer() {
        return this.timer;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> startPartitionRead(VerticaPartition verticaPartition) {
        Right right;
        BoxedUnit boxedUnit;
        this.timer().startTime();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Starting partition read.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        VerticaPartition verticaPartition2 = verticaPartition;
        if (verticaPartition2 instanceof VerticaDistributedFilesystemPartition) {
            VerticaDistributedFilesystemPartition verticaDistributedFilesystemPartition = (VerticaDistributedFilesystemPartition)verticaPartition2;
            right = package$.MODULE$.Right().apply((Object)verticaDistributedFilesystemPartition);
        } else {
            right = package$.MODULE$.Left().apply((Object)new InvalidPartition());
        }
        return right.map((Function1 & Serializable & scala.Serializable)part -> {
            this.partition_$eq((Option<VerticaDistributedFilesystemPartition>)new Some(part));
            BoxedUnit x$17 = BoxedUnit.UNIT;
            this.fileIdx_$eq(0);
            BoxedUnit x$18 = BoxedUnit.UNIT;
            return new Tuple3(part, (Object)x$17, (Object)x$18);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$19 -> {
            Either<ConnectorError, BoxedUnit> either;
            Tuple3 tuple3 = x$19;
            if (tuple3 == null) throw new MatchError((Object)tuple3);
            VerticaDistributedFilesystemPartition part = (VerticaDistributedFilesystemPartition)tuple3._1();
            Option option = part.fileRanges().headOption();
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("No files to read set on partition.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                either = package$.MODULE$.Left().apply((Object)new DoneReading());
                return either.map((Function1 & Serializable & scala.Serializable)ret -> {
                    VerticaDistributedFilesystemReadPipe.$anonfun$startPartitionRead$3(ret);
                    return BoxedUnit.UNIT;
                });
            } else {
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                Some some = (Some)option;
                ParquetFileRange head = (ParquetFileRange)some.value();
                either = this.fileStoreLayer().openReadParquetFile(head);
            }
            return either.map((Function1 & Serializable & scala.Serializable)ret -> {
                VerticaDistributedFilesystemReadPipe.$anonfun$startPartitionRead$3(ret);
                return BoxedUnit.UNIT;
            });
        });
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Either<ConnectorError, DataBlock> readData() {
        block30: {
            block32: {
                block34: {
                    block33: {
                        block31: {
                            block27: {
                                block29: {
                                    block28: {
                                        var7_1 = this.partition();
                                        if (None$.MODULE$.equals(var7_1)) {
                                            return package$.MODULE$.Left().apply((Object)new UninitializedReadError());
                                        }
                                        if (!(var7_1 instanceof Some)) {
                                            throw new MatchError(var7_1);
                                        }
                                        var8_2 = (Some)var7_1;
                                        var5_4 = p = (VerticaDistributedFilesystemPartition)var8_2.value();
                                        part = var5_4;
                                        var11_6 = this.fileStoreLayer().readDataFromParquetFile(this.dataSize());
                                        if (var11_6 instanceof Left) {
                                            var12_7 = (Left)var11_6;
                                            err = (ConnectorError)var12_7.value();
                                            var4_9 = package$.MODULE$.Left().apply((Object)err);
                                        } else if (var11_6 instanceof Right) {
                                            var14_10 = (Right)var11_6;
                                            data = (DataBlock)var14_10.value();
                                            if (data.data().nonEmpty()) {
                                                v0 = package$.MODULE$.Right().apply((Object)data);
                                            } else {
                                                if (this.logger().underlying().isInfoEnabled()) {
                                                    this.logger().underlying().info("Hit done reading for file segment.");
                                                    v1 = BoxedUnit.UNIT;
                                                } else {
                                                    v1 = BoxedUnit.UNIT;
                                                }
                                                this.fileIdx_$eq(this.fileIdx() + 1);
                                                if (this.fileIdx() >= part.fileRanges().size()) {
                                                    return package$.MODULE$.Right().apply((Object)data);
                                                }
                                                v0 = this.fileStoreLayer().closeReadParquetFile().flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$readData$1(com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe com.vertica.spark.datasource.partitions.parquet.VerticaDistributedFilesystemPartition scala.runtime.BoxedUnit ), (Lscala/runtime/BoxedUnit;)Lscala/util/Either;)((VerticaDistributedFilesystemReadPipe)this, (VerticaDistributedFilesystemPartition)part));
                                            }
                                            var4_9 = v0;
                                        } else {
                                            throw new MatchError(var11_6);
                                        }
                                        ret = var4_9;
                                        var16_13 = new Tuple2((Object)ret, this.cleaner().getCleanupInfo(part, this.fileIdx()));
                                        if (var16_13 == null) break block27;
                                        var17_14 = (Either)var16_13._1();
                                        var18_15 = (Option)var16_13._2();
                                        if (!(var17_14 instanceof Left) || !(var18_15 instanceof Some)) break block27;
                                        var19_16 = (Some)var18_15;
                                        cleanupInfo = (FileCleanupInfo)var19_16.value();
                                        if (this.config().fileStoreConfig().preventCleanup()) break block28;
                                        var21_18 = this.cleanupUtils().checkAndCleanup(this.fileStoreLayer(), cleanupInfo);
                                        if (!(var21_18 instanceof Right)) ** GOTO lbl-1000
                                        var22_19 = (Right)var21_18;
                                        var23_20 = (BoxedUnit)var22_19.value();
                                        v2 = BoxedUnit.UNIT;
                                        var24_21 = var23_20;
                                        if (!(v2 != null ? v2.equals(var24_21) == false : var24_21 != null)) {
                                            var3_22 = BoxedUnit.UNIT;
                                        } else if (var21_18 instanceof Left) {
                                            var25_24 = (Left)var21_18;
                                            err = (ConnectorError)var25_24.value();
                                            if (this.logger().underlying().isWarnEnabled()) {
                                                this.logger().underlying().warn(new StringBuilder(33).append("Ran into error when cleaning up: ").append(err.getFullContext()).toString());
                                                v3 = BoxedUnit.UNIT;
                                            } else {
                                                v3 = BoxedUnit.UNIT;
                                            }
                                            var3_23 = v3;
                                        } else {
                                            throw new MatchError(var21_18);
                                        }
                                        v4 = BoxedUnit.UNIT;
                                        break block29;
                                    }
                                    v4 = BoxedUnit.UNIT;
                                }
                                var1_26 = v4;
                                break block30;
                            }
                            if (var16_13 == null) break block31;
                            var27_30 = (Either)var16_13._1();
                            var28_31 = (Option)var16_13._2();
                            if (!(var27_30 instanceof Left) || !None$.MODULE$.equals(var28_31)) break block31;
                            if (this.logger().underlying().isWarnEnabled()) {
                                this.logger().underlying().warn("No cleanup info found");
                                v5 = BoxedUnit.UNIT;
                            } else {
                                v5 = BoxedUnit.UNIT;
                            }
                            var1_27 = v5;
                            break block30;
                        }
                        if (var16_13 == null) break block32;
                        var29_32 = (Either)var16_13._1();
                        var30_33 = (Option)var16_13._2();
                        if (!(var29_32 instanceof Right)) break block32;
                        var31_34 = (Right)var29_32;
                        dataBlock = (DataBlock)var31_34.value();
                        if (!(var30_33 instanceof Some)) break block32;
                        var33_36 = (Some)var30_33;
                        cleanupInfo = (FileCleanupInfo)var33_36.value();
                        if (!dataBlock.data().isEmpty() || this.config().fileStoreConfig().preventCleanup()) break block33;
                        var35_38 = this.cleanupUtils().checkAndCleanup(this.fileStoreLayer(), cleanupInfo);
                        if (!(var35_38 instanceof Right)) ** GOTO lbl-1000
                        var36_39 = (Right)var35_38;
                        var37_40 = (BoxedUnit)var36_39.value();
                        v6 = BoxedUnit.UNIT;
                        var38_41 = var37_40;
                        if (!(v6 != null ? v6.equals(var38_41) == false : var38_41 != null)) {
                            var2_42 = BoxedUnit.UNIT;
                        } else if (var35_38 instanceof Left) {
                            var39_44 = (Left)var35_38;
                            err = (ConnectorError)var39_44.value();
                            if (this.logger().underlying().isWarnEnabled()) {
                                this.logger().underlying().warn(new StringBuilder(33).append("Ran into error when cleaning up: ").append(err.getFullContext()).toString());
                                v7 = BoxedUnit.UNIT;
                            } else {
                                v7 = BoxedUnit.UNIT;
                            }
                            var2_43 = v7;
                        } else {
                            throw new MatchError(var35_38);
                        }
                        v8 = BoxedUnit.UNIT;
                        break block34;
                    }
                    v8 = BoxedUnit.UNIT;
                }
                var1_28 = v8;
                break block30;
            }
            if (var16_13 == null) ** GOTO lbl-1000
            var41_46 = (Either)var16_13._1();
            var42_47 = (Option)var16_13._2();
            if (var41_46 instanceof Right && None$.MODULE$.equals(var42_47)) {
                var1_29 = BoxedUnit.UNIT;
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var16_13);
            }
        }
        return ret;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> endPartitionRead() {
        Either<ConnectorError, BoxedUnit> either;
        this.timer().endTime();
        Option<VerticaDistributedFilesystemPartition> option = this.partition();
        if (option instanceof Some) {
            Some some = (Some)option;
            VerticaDistributedFilesystemPartition partition = (VerticaDistributedFilesystemPartition)some.value();
            this.cleaner().cleanupFiles(partition);
            either = this.fileStoreLayer().closeReadParquetFile();
        } else if (None$.MODULE$.equals(option)) {
            either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError(option);
        }
        return either;
    }

    private final void addNewPartition$1(int currRowGroup, Map rangeCountMap$1, ParquetFileMetadata file$1, ObjectRef fileRanges$1, IntRef start$1, ObjectRef partitions$1, IntRef partitionSize$1) {
        BoxedUnit boxedUnit;
        int rangeIdx = this.incrementRangeMapGetIndex((Map<String, Object>)rangeCountMap$1, file$1.filename());
        fileRanges$1.elem = (List)((List)fileRanges$1.elem).$colon$plus((Object)new ParquetFileRange(file$1.filename(), start$1.elem, currRowGroup, rangeIdx), List$.MODULE$.canBuildFrom());
        partitions$1.elem = (List)((List)partitions$1.elem).$colon$plus((Object)new VerticaDistributedFilesystemPartition((Seq<ParquetFileRange>)((List)fileRanges$1.elem), (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))), List$.MODULE$.canBuildFrom());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(65).append("Reached partition with file ").append(file$1.filename()).append(" , range low: ").append(start$1.elem).append(" , range high: ").append(currRowGroup).append(" , idx: ").append(rangeIdx).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        partitionSize$1.elem = 0;
        start$1.elem = currRowGroup + 1;
        fileRanges$1.elem = Nil$.MODULE$;
    }

    private final void addNewFileRange$1(int currRowGroup, Map rangeCountMap$1, ParquetFileMetadata file$1, IntRef start$1, ObjectRef fileRanges$1, IntRef partitionSize$1) {
        BoxedUnit boxedUnit;
        int rangeIdx = this.incrementRangeMapGetIndex((Map<String, Object>)rangeCountMap$1, file$1.filename());
        ParquetFileRange frange = new ParquetFileRange(file$1.filename(), start$1.elem, currRowGroup, rangeIdx);
        fileRanges$1.elem = (List)((List)fileRanges$1.elem).$colon$plus((Object)frange, List$.MODULE$.canBuildFrom());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(57).append("Reached end of file ").append(file$1.filename()).append(" , range low: ").append(start$1.elem).append(" , range high: ").append(currRowGroup).append(" , idx: ").append(rangeIdx).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ++partitionSize$1.elem;
    }

    public static final /* synthetic */ void $anonfun$getPartitionInfo$2(VerticaDistributedFilesystemReadPipe $this, Map rangeCountMap$1, ObjectRef fileRanges$1, ObjectRef partitions$1, IntRef partitionSize$1, int maxSize$1, ParquetFileMetadata file) {
        int fileRowGroupCount = file.rowGroupCount();
        IntRef start = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), fileRowGroupCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)currRowGroup -> {
            if (partitionSize$1.elem == maxSize$1 - 1) {
                $this.addNewPartition$1(currRowGroup, rangeCountMap$1, file, fileRanges$1, start, partitions$1, partitionSize$1);
            } else if (currRowGroup == fileRowGroupCount - 1) {
                $this.addNewFileRange$1(currRowGroup, rangeCountMap$1, file, start, fileRanges$1, partitionSize$1);
            } else {
                ++partitionSize$1.elem;
            }
        });
    }

    private final String exportType$1() {
        return this.config().useJson() ? "JSON" : "PARQUET";
    }

    private final Either buildExportStatement$1(String exportPath$1) {
        return this.getSelectClause().map((Function1 & Serializable & scala.Serializable)selectClause -> {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            String rowGroupSize;
            String string;
            ValidFilePermissions filePermissions = this.config().filePermissions();
            String groupbyClause = this.getGroupbyClause();
            String pushdownFilters = this.addPushdownFilters(this.config().getPushdownFilters());
            TableSource tableSource = this.config().tableSource();
            if (tableSource instanceof TableName) {
                TableName tableName = (TableName)tableSource;
                string = tableName.getFullTableName();
            } else if (tableSource instanceof TableQuery) {
                TableQuery tableQuery = (TableQuery)tableSource;
                String query = tableQuery.query();
                string = new StringBuilder(7).append("(").append(query).append(") AS x").toString();
            } else {
                throw new MatchError((Object)tableSource);
            }
            String exportSource = string;
            String string2 = rowGroupSize = this.config().useJson() ? "" : new StringBuilder(19).append(", rowGroupSizeMB = ").append(this.maxRowGroupSize()).toString();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder(25).append("Select clause requested: ").append((String)selectClause).toString());
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder(18).append("Pushdown filters: ").append(pushdownFilters).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder(15).append("Export Source: ").append(exportSource).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new StringBuilder(88).append("EXPORT TO ").append(this.exportType$1()).append("(").append("directory = '").append(exportPath$1).append("', fileSizeMB = ").append(this.maxFileSize()).append(rowGroupSize).append(", fileMode = '").append(filePermissions).append("', dirMode = '").append(filePermissions).append("') AS SELECT ").append((String)selectClause).append(" FROM ").append(exportSource).append(pushdownFilters).append(groupbyClause).append(";").toString();
        });
    }

    public static final /* synthetic */ void $anonfun$doPreReadSteps$11(BoxedUnit _) {
    }

    public static final /* synthetic */ Either $anonfun$doPreReadSteps$8(VerticaDistributedFilesystemReadPipe $this, String exportPath$1, boolean exportDone) {
        return $this.buildExportStatement$1(exportPath$1).flatMap((Function1 & Serializable & scala.Serializable)exportStatement -> {
            Right right;
            if (exportDone) {
                BoxedUnit boxedUnit;
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info("Export already done, skipping export step.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else {
                BoxedUnit boxedUnit;
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info(new StringBuilder(28).append("Exporting using statement: \n").append((String)exportStatement).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Timer timer = new Timer($this.config().timeOperations(), $this.logger(), "Export To Parquet From Vertica");
                timer.startTime();
                Either res = EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither($this.jdbcLayer().execute((String)exportStatement, $this.jdbcLayer().execute$default$2())), (Function1 & Serializable & scala.Serializable)err -> new ExportFromVerticaError((ConnectorError)err));
                $this.sparkContext().addSparkListener(new ApplicationParquetCleaner($this.config()));
                timer.endTime();
                right = res;
            }
            return right.map((Function1 & Serializable & scala.Serializable)_ -> {
                VerticaDistributedFilesystemReadPipe.$anonfun$doPreReadSteps$11(_);
                return BoxedUnit.UNIT;
            });
        });
    }

    private final Either exportData$1(FileStoreConfig fileStoreConfig$1, String exportPath$1) {
        return this.getMetadata().flatMap((Function1 & Serializable & scala.Serializable)_ -> this.jdbcLayer().configureSession(this.fileStoreLayer()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.checkVersionCompatibility(this.config()).flatMap((Function1 & Serializable & scala.Serializable)_ -> (this.config().useJson() ? this.checkJSONExportTypesSupport(this.config()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            BoxedUnit boxedUnit;
            ValidFilePermissions perm = this.config().filePermissions();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder(46).append("Creating unique directory: ").append(fileStoreConfig$1.address()).append(" with permissions: ").append(perm).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$5 = boxedUnit;
            return new Tuple3(x$4, (Object)perm, (Object)x$5);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> {
            Right right;
            Tuple3 tuple3 = x$6;
            if (tuple3 == null) throw new MatchError((Object)tuple3);
            ValidFilePermissions perm = (ValidFilePermissions)tuple3._2();
            Either<ConnectorError, BoxedUnit> either = this.fileStoreLayer().createDir(fileStoreConfig$1.address(), perm.toString());
            if (either instanceof Left) {
                Right right2;
                Left left = (Left)either;
                ConnectorError err = (ConnectorError)left.value();
                ConnectorError connectorError = err.getUnderlyingError();
                if (connectorError instanceof CreateDirectoryAlreadyExistsError) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info(new StringBuilder(27).append("Directory already existed: ").append(fileStoreConfig$1.address()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    right2 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                } else {
                    right2 = package$.MODULE$.Left().apply((Object)err.context(new StringBuilder(28).append("Failed to create directory: ").append(fileStoreConfig$1.address()).toString()));
                }
                right = right2;
                return right.flatMap((Function1 & Serializable & scala.Serializable)_ -> this.fileStoreLayer().fileExists(exportPath$1).flatMap((Function1 & Serializable & scala.Serializable)exportDone -> VerticaDistributedFilesystemReadPipe.$anonfun$doPreReadSteps$8(this, exportPath$1, BoxesRunTime.unboxToBoolean((Object)exportDone))));
            } else {
                if (!(either instanceof Right)) throw new MatchError(either);
                right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            return right.flatMap((Function1 & Serializable & scala.Serializable)_ -> this.fileStoreLayer().fileExists(exportPath$1).flatMap((Function1 & Serializable & scala.Serializable)exportDone -> VerticaDistributedFilesystemReadPipe.$anonfun$doPreReadSteps$8(this, exportPath$1, BoxesRunTime.unboxToBoolean((Object)exportDone))));
        }))));
    }

    public static final /* synthetic */ Either $anonfun$doPreReadSteps$12(VerticaDistributedFilesystemReadPipe $this, String exportPath$1, boolean dirExists) {
        return (!dirExists ? package$.MODULE$.Right().apply((Object)Nil$.MODULE$) : $this.fileStoreLayer().getFileList(exportPath$1)).map((Function1 & Serializable & scala.Serializable)fullFileList -> {
            BoxedUnit boxedUnit;
            BoxedUnit x$8;
            BoxedUnit boxedUnit2;
            int n;
            Seq parquetFileList = (Seq)fullFileList.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)x.endsWith(".parquet")));
            Option<Object> option = $this.config().partitionCount();
            if (option instanceof Some) {
                int count;
                Some some = (Some)option;
                n = count = BoxesRunTime.unboxToInt((Object)some.value());
            } else if (None$.MODULE$.equals(option)) {
                n = parquetFileList.size();
            } else {
                throw new MatchError(option);
            }
            int requestedPartitionCount = n;
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringBuilder(27).append("Requested partition count: ").append(requestedPartitionCount).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = x$8 = BoxedUnit.UNIT;
            }
            if ($this.logger().underlying().isInfoEnabled()) {
                $this.logger().underlying().info(new StringBuilder(24).append("Parquet file list size: ").append(parquetFileList.size()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$9 = boxedUnit;
            Timer partitionTimer = new Timer($this.config().timeOperations(), $this.logger(), "Reading Parquet Files Metadata and creating partitions");
            partitionTimer.startTime();
            BoxedUnit x$10 = BoxedUnit.UNIT;
            return new Tuple7(fullFileList, (Object)parquetFileList, (Object)BoxesRunTime.boxToInteger((int)requestedPartitionCount), (Object)x$8, (Object)x$9, (Object)partitionTimer, (Object)x$10);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$15 -> {
            Tuple7 tuple7 = x$15;
            if (tuple7 == null) {
                throw new MatchError((Object)tuple7);
            }
            Seq parquetFileList = (Seq)tuple7._2();
            int requestedPartitionCount = BoxesRunTime.unboxToInt((Object)tuple7._3());
            Timer partitionTimer = (Timer)tuple7._6();
            Either either = ((Either)implicits$.MODULE$.toTraverseOps((Object)parquetFileList.toList(), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)filename -> $this.fileStoreLayer().getParquetFileMetadata((String)filename), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable & scala.Serializable)fileMetadata -> {
                int n;
                Either<ConnectorError, BoxedUnit> x$12;
                Either<ConnectorError, BoxedUnit> either;
                BoxedUnit x$11;
                BoxedUnit boxedUnit;
                int totalRowGroups = BoxesRunTime.unboxToInt((Object)((TraversableOnce)fileMetadata.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.rowGroupCount()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info(new StringBuilder(18).append("Total row groups: ").append(totalRowGroups).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = x$11 = BoxedUnit.UNIT;
                }
                if (totalRowGroups == 0) {
                    if (!$this.config().fileStoreConfig().preventCleanup()) {
                        BoxedUnit boxedUnit2;
                        if ($this.logger().underlying().isDebugEnabled()) {
                            $this.logger().underlying().debug(new StringBuilder(37).append("Cleaning up empty directory in path: ").append(exportPath$1).toString());
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        either = $this.cleanupUtils().cleanupAll($this.fileStoreLayer(), exportPath$1);
                    } else {
                        either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    }
                } else {
                    either = x$12 = BoxedUnit.UNIT;
                }
                if (totalRowGroups < requestedPartitionCount) {
                    BoxedUnit boxedUnit3;
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(43).append("Less than ").append(requestedPartitionCount).append(" partitions required, only using ").append(totalRowGroups).toString());
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    n = totalRowGroups;
                } else {
                    n = requestedPartitionCount;
                }
                int partitionCount = n;
                PartitionInfo partitionInfo = $this.getPartitionInfo((Seq<ParquetFileMetadata>)fileMetadata, partitionCount);
                partitionTimer.endTime();
                BoxedUnit x$13 = BoxedUnit.UNIT;
                return new Tuple7(fileMetadata, (Object)BoxesRunTime.boxToInteger((int)totalRowGroups), (Object)x$11, x$12, (Object)BoxesRunTime.boxToInteger((int)partitionCount), (Object)partitionInfo, (Object)x$13);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$14 -> {
                Tuple7 tuple7 = x$14;
                if (tuple7 == null) {
                    throw new MatchError((Object)tuple7);
                }
                PartitionInfo partitionInfo = (PartitionInfo)tuple7._6();
                Either either = $this.jdbcLayer().close().map((Function1 & Serializable & scala.Serializable)_ -> partitionInfo);
                return either;
            });
            return either;
        });
    }

    private final Either getParquetPartitionInfo$1(String exportPath$1) {
        return this.fileStoreLayer().fileExists(exportPath$1).flatMap((Function1 & Serializable & scala.Serializable)dirExists -> VerticaDistributedFilesystemReadPipe.$anonfun$doPreReadSteps$12(this, exportPath$1, BoxesRunTime.unboxToBoolean((Object)dirExists)));
    }

    public static final /* synthetic */ void $anonfun$checkVersionCompatibility$2(BoxedUnit _) {
    }

    private final Either checkFieldType$1(String name, DataType dataType, boolean useJson$1) {
        Right right;
        block4: {
            DataType dataType2;
            while (true) {
                DataType elementType;
                if (BinaryType$.MODULE$.equals(dataType2 = dataType)) {
                    right = useJson$1 ? package$.MODULE$.Left().apply((Object)new BinaryTypeNotSupported(name)) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    break block4;
                }
                if (!(dataType2 instanceof ArrayType)) break;
                ArrayType arrayType = (ArrayType)dataType2;
                dataType = elementType = arrayType.elementType();
            }
            if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                right = this.checkStructFields$1(structType, useJson$1);
            } else {
                right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
        }
        return right;
    }

    public static final /* synthetic */ void $anonfun$checkJSONExportTypesSupport$4(List x$16) {
    }

    private final Either checkStructFields$1(StructType structType, boolean useJson$1) {
        return ((Validated)implicits$.MODULE$.toTraverseOps((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).map((Function1 & Serializable & scala.Serializable)field -> this.checkFieldType$1(field.name(), field.dataType(), useJson$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Either.class))))).toList(), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)field -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(field), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)x$16 -> {
            VerticaDistributedFilesystemReadPipe.$anonfun$checkJSONExportTypesSupport$4(x$16);
            return BoxedUnit.UNIT;
        }).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
    }

    public static final /* synthetic */ void $anonfun$startPartitionRead$3(BoxedUnit ret) {
    }

    public static final /* synthetic */ Either $anonfun$readData$1(VerticaDistributedFilesystemReadPipe $this, VerticaDistributedFilesystemPartition part$1, BoxedUnit _2) {
        return $this.fileStoreLayer().openReadParquetFile((ParquetFileRange)part$1.fileRanges().apply($this.fileIdx())).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.fileStoreLayer().readDataFromParquetFile($this.dataSize()).map((Function1 & Serializable & scala.Serializable)data -> data));
    }

    public VerticaDistributedFilesystemReadPipe(DistributedFilesystemReadConfig config, FileStoreLayerInterface fileStoreLayer, JdbcLayerInterface jdbcLayer, SchemaToolsInterface schemaTools, CleanupUtilsInterface cleanupUtils, SparkContextWrapper sparkContext, int dataSize) {
        this.config = config;
        this.fileStoreLayer = fileStoreLayer;
        this.jdbcLayer = jdbcLayer;
        this.schemaTools = schemaTools;
        this.cleanupUtils = cleanupUtils;
        this.sparkContext = sparkContext;
        this.dataSize = dataSize;
        this.logger = LogProvider$.MODULE$.getLogger(VerticaDistributedFilesystemReadPipe.class);
        this.maxFileSize = config.maxFileSize();
        this.maxRowGroupSize = config.maxRowGroupSize();
        this.partition = None$.MODULE$;
        this.fileIdx = 0;
        this.cleaner = new DistributedFilesCleaner(config, cleanupUtils, (Option<FileStoreLayerInterface>)new Some((Object)fileStoreLayer));
        this.timer = new Timer(config.timeOperations(), this.logger(), "Partition Read");
    }
}

