/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.core;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.DistributedFilesystemWriteConfig;
import com.vertica.spark.config.EscapeUtils$;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.config.ValidColumnList;
import com.vertica.spark.config.ValidFilePermissions;
import com.vertica.spark.config.VerticaMetadata;
import com.vertica.spark.config.VerticaWriteMetadata;
import com.vertica.spark.datasource.core.CreateExternalTableOption;
import com.vertica.spark.datasource.core.DataBlock;
import com.vertica.spark.datasource.core.ExistingData$;
import com.vertica.spark.datasource.core.NewData$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipe$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$;
import com.vertica.spark.datasource.core.VerticaPipeInterface;
import com.vertica.spark.datasource.core.VerticaPipeWriteInterface;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcUtils$;
import com.vertica.spark.util.Timer;
import com.vertica.spark.util.error.CommitError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.CreateExternalTableAlreadyExistsError;
import com.vertica.spark.util.error.CreateExternalTableMergeKey;
import com.vertica.spark.util.error.CreateTableError;
import com.vertica.spark.util.error.DropTableError;
import com.vertica.spark.util.error.DuplicateColumnsError;
import com.vertica.spark.util.error.FaultToleranceTestFail;
import com.vertica.spark.util.error.InferExternalSchemaError;
import com.vertica.spark.util.error.InferExternalTableSchemaError;
import com.vertica.spark.util.error.MergeColumnListError;
import com.vertica.spark.util.error.NonEmptyDataFrameError;
import com.vertica.spark.util.error.SchemaColumnListError;
import com.vertica.spark.util.error.TempTableExistsError;
import com.vertica.spark.util.error.ViewExistsError;
import com.vertica.spark.util.schema.SchemaToolsInterface;
import com.vertica.spark.util.table.TableUtilsInterface;
import com.vertica.spark.util.version.VerticaVersion;
import com.vertica.spark.util.version.VerticaVersionUtils$;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r\rd\u0001\u0002%J\u0001QC\u0001B\u0019\u0001\u0003\u0006\u0004%\ta\u0019\u0005\tS\u0002\u0011\t\u0011)A\u0005I\"A!\u000e\u0001BC\u0002\u0013\u00051\u000e\u0003\u0005s\u0001\t\u0005\t\u0015!\u0003m\u0011!\u0019\bA!b\u0001\n\u0003!\b\u0002C>\u0001\u0005\u0003\u0005\u000b\u0011B;\t\u0011q\u0004!Q1A\u0005\u0002uD\u0011\"!\u0004\u0001\u0005\u0003\u0005\u000b\u0011\u0002@\t\u0015\u0005=\u0001A!b\u0001\n\u0003\t\t\u0002\u0003\u0006\u0002 \u0001\u0011\t\u0011)A\u0005\u0003'A!\"!\t\u0001\u0005\u000b\u0007I\u0011AA\u0012\u0011)\tY\u0003\u0001B\u0001B\u0003%\u0011Q\u0005\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011%\ty\u0004\u0001b\u0001\n\u0013\t\t\u0005\u0003\u0005\u0002T\u0001\u0001\u000b\u0011BA\"\u0011%\t)\u0006\u0001b\u0001\n\u0013\t9\u0006\u0003\u0005\u0002`\u0001\u0001\u000b\u0011BA-\u0011%\t\t\u0007\u0001b\u0001\n\u0013\t\u0019\u0007\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA3\u0011%\t9\b\u0001b\u0001\n\u0013\t\u0019\u0007\u0003\u0005\u0002z\u0001\u0001\u000b\u0011BA3\u0011\u001d\tY\b\u0001C\u0001\u0003{Bq!!-\u0001\t\u0003\t\u0019\fC\u0004\u0002>\u0002!\t!a0\t\u000f\u0005\u0015\b\u0001\"\u0003\u0002h\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\bbBA~\u0001\u0011\u0005\u0011Q \u0005\b\u0003\u007f\u0004A\u0011\u0002B\u0001\u0011%\u0011)\u0001\u0001b\u0001\n\u0003\u00119\u0001\u0003\u0005\u0003\u0012\u0001\u0001\u000b\u0011\u0002B\u0005\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0005+AqAa\u0007\u0001\t\u0003\u0011i\u0002C\u0004\u0003*\u0001!\t!!@\t\u000f\t-\u0002\u0001\"\u0001\u0003.!9!1\t\u0001\u0005\u0002\t\u0015\u0003b\u0002B)\u0001\u0011\u0005!1\u000b\u0005\b\u00053\u0002A\u0011\u0001B.\u0011\u001d\u0011y\u0006\u0001C\t\u0005CBqA!\u001b\u0001\t\u0013\u0011YG\u0002\u0004\u0003n\u0001!%q\u000e\u0005\u000b\u0005{B#Q3A\u0005\u0002\t}\u0004B\u0003BDQ\tE\t\u0015!\u0003\u0003\u0002\"Q!\u0011\u0012\u0015\u0003\u0016\u0004%\tAa#\t\u0015\tM\u0005F!E!\u0002\u0013\u0011i\tC\u0004\u0002.!\"\tA!&\t\u0013\t}\u0005&!A\u0005\u0002\t\u0005\u0006\"\u0003BTQE\u0005I\u0011\u0001BU\u0011%\u0011y\fKI\u0001\n\u0003\u0011\t\rC\u0005\u0003F\"\n\t\u0011\"\u0011\u0002d!I!q\u0019\u0015\u0002\u0002\u0013\u0005\u00111\u0005\u0005\n\u0005\u0013D\u0013\u0011!C\u0001\u0005\u0017D\u0011Ba6)\u0003\u0003%\tE!7\t\u0013\t\u001d\b&!A\u0005\u0002\t%\b\"\u0003BwQ\u0005\u0005I\u0011\tBx\u0011%\u0011\t\u0010KA\u0001\n\u0003\u0012\u0019\u0010C\u0005\u0003v\"\n\t\u0011\"\u0011\u0003x\u001eI!1 \u0001\u0002\u0002#%!Q \u0004\n\u0005[\u0002\u0011\u0011!E\u0005\u0005\u007fDq!!\f;\t\u0003\u0019i\u0001C\u0005\u0003rj\n\t\u0011\"\u0012\u0003t\"I1q\u0002\u001e\u0002\u0002\u0013\u00055\u0011\u0003\u0005\n\u0007/Q\u0014\u0011!CA\u00073Aqaa\u000b\u0001\t\u0013\u0019i\u0003C\u0004\u0004:\u0001!\taa\u000f\t\u000f\r\u001d\u0003\u0001\"\u0001\u0004J!91Q\n\u0001\u0005\u0002\r=\u0003bBB*\u0001\u0011\u0005\u0011Q`\u0004\n\u0007+J\u0015\u0011!E\u0001\u0007/2\u0001\u0002S%\u0002\u0002#\u00051\u0011\f\u0005\b\u0003[)E\u0011AB.\u0011%\u0019i&RI\u0001\n\u0003\u0019yFA\u0013WKJ$\u0018nY1ESN$(/\u001b2vi\u0016$g)\u001b7fgf\u001cH/Z7Xe&$X\rU5qK*\u0011!jS\u0001\u0005G>\u0014XM\u0003\u0002M\u001b\u0006QA-\u0019;bg>,(oY3\u000b\u00059{\u0015!B:qCJ\\'B\u0001)R\u0003\u001d1XM\u001d;jG\u0006T\u0011AU\u0001\u0004G>l7\u0001A\n\u0005\u0001U[v\f\u0005\u0002W36\tqKC\u0001Y\u0003\u0015\u00198-\u00197b\u0013\tQvK\u0001\u0004B]f\u0014VM\u001a\t\u00039vk\u0011!S\u0005\u0003=&\u0013ACV3si&\u001c\u0017\rU5qK&sG/\u001a:gC\u000e,\u0007C\u0001/a\u0013\t\t\u0017JA\rWKJ$\u0018nY1QSB,wK]5uK&sG/\u001a:gC\u000e,\u0017AB2p]\u001aLw-F\u0001e!\t)w-D\u0001g\u0015\t\u0011W*\u0003\u0002iM\n\u0001C)[:ue&\u0014W\u000f^3e\r&dWm]=ti\u0016lwK]5uK\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\naBZ5mKN#xN]3MCf,'/F\u0001m!\ti\u0007/D\u0001o\u0015\ty7*\u0001\u0002gg&\u0011\u0011O\u001c\u0002\u0018\r&dWm\u0015;pe\u0016d\u0015-_3s\u0013:$XM\u001d4bG\u0016\fqBZ5mKN#xN]3MCf,'\u000fI\u0001\nU\u0012\u00147\rT1zKJ,\u0012!\u001e\t\u0003mfl\u0011a\u001e\u0006\u0003q.\u000bAA\u001b3cG&\u0011!p\u001e\u0002\u0013\u0015\u0012\u00147\rT1zKJLe\u000e^3sM\u0006\u001cW-\u0001\u0006kI\n\u001cG*Y=fe\u0002\n1b]2iK6\fGk\\8mgV\ta\u0010E\u0002\u0000\u0003\u0013i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0007g\u000eDW-\\1\u000b\u0007\u0005\u001dQ*\u0001\u0003vi&d\u0017\u0002BA\u0006\u0003\u0003\u0011AcU2iK6\fGk\\8mg&sG/\u001a:gC\u000e,\u0017\u0001D:dQ\u0016l\u0017\rV8pYN\u0004\u0013A\u0003;bE2,W\u000b^5mgV\u0011\u00111\u0003\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u0003\u0003\u0015!\u0018M\u00197f\u0013\u0011\ti\"a\u0006\u0003'Q\u000b'\r\\3Vi&d7/\u00138uKJ4\u0017mY3\u0002\u0017Q\f'\r\\3Vi&d7\u000fI\u0001\tI\u0006$\u0018mU5{KV\u0011\u0011Q\u0005\t\u0004-\u0006\u001d\u0012bAA\u0015/\n\u0019\u0011J\u001c;\u0002\u0013\u0011\fG/Y*ju\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\b\u00022\u0005M\u0012QGA\u001c\u0003s\tY$!\u0010\u0011\u0005q\u0003\u0001\"\u00022\u000e\u0001\u0004!\u0007\"\u00026\u000e\u0001\u0004a\u0007\"B:\u000e\u0001\u0004)\b\"\u0002?\u000e\u0001\u0004q\bbBA\b\u001b\u0001\u0007\u00111\u0003\u0005\n\u0003Ci\u0001\u0013!a\u0001\u0003K\ta\u0001\\8hO\u0016\u0014XCAA\"!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\nAb]2bY\u0006dwnZ4j]\u001eT1!!\u0014R\u0003!!\u0018\u0010]3tC\u001a,\u0017\u0002BA)\u0003\u000f\u0012a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u000ei\u0016l\u0007\u000fV1cY\u0016t\u0015-\\3\u0016\u0005\u0005e\u0003cA3\u0002\\%\u0019\u0011Q\f4\u0003\u0013Q\u000b'\r\\3OC6,\u0017A\u0004;f[B$\u0016M\u00197f\u001d\u0006lW\rI\u0001$\u0019\u0016;\u0015iQ-`!\u0006\u0013\u0016+V#U?J+%)Q*F?6{E)R0J\u001d~;&+\u0013+F+\t\t)\u0007\u0005\u0003\u0002h\u0005ETBAA5\u0015\u0011\tY'!\u001c\u0002\t1\fgn\u001a\u0006\u0003\u0003_\nAA[1wC&!\u00111OA5\u0005\u0019\u0019FO]5oO\u0006!C*R$B\u0007f{\u0006+\u0011*R+\u0016#vLU#C\u0003N+u,T(E\u000b~KejX,S\u0013R+\u0005%A\u0015M\u000b\u001e\u000b5)W0Q\u0003J\u000bV+\u0012+`\u0013:#\u0016HN0S\u000b\n\u000b5+R0N\u001f\u0012+u,\u0013(`/JKE+R\u0001+\u0019\u0016;\u0015iQ-`!\u0006\u0013\u0016+V#U?&sE+\u000f\u001c`%\u0016\u0013\u0015iU#`\u001b>#UiX%O?^\u0013\u0016\nV#!\u0003-9W\r^'fi\u0006$\u0017\r^1\u0016\u0005\u0005}\u0004CBAA\u0003K\u000bYK\u0004\u0003\u0002\u0004\u0006}e\u0002BAC\u00037sA!a\"\u0002\u001a:!\u0011\u0011RAL\u001d\u0011\tY)!&\u000f\t\u00055\u00151S\u0007\u0003\u0003\u001fS1!!%T\u0003\u0019a$o\\8u}%\t!+\u0003\u0002Q#&\u0011ajT\u0005\u0004\u0003\u000fi\u0015\u0002BAO\u0003\u000b\tQ!\u001a:s_JLA!!)\u0002$\u0006iQI\u001d:pe\"\u000bg\u000e\u001a7j]\u001eTA!!(\u0002\u0006%!\u0011qUAU\u0005=\u0019uN\u001c8fGR|'OU3tk2$(\u0002BAQ\u0003G\u00032!ZAW\u0013\r\tyK\u001a\u0002\u0010-\u0016\u0014H/[2b\u001b\u0016$\u0018\rZ1uC\u0006\u0001r-\u001a;ECR\f'\t\\8dWNK'0Z\u000b\u0003\u0003k\u0003b!!!\u0002&\u0006]\u0006c\u0001,\u0002:&\u0019\u00111X,\u0003\t1{gnZ\u0001\u0019G\",7m[*dQ\u0016l\u0017MR8s\tV\u0004H.[2bi\u0016\u001cH\u0003BAa\u0003\u0013\u0004b!!!\u0002&\u0006\r\u0007c\u0001,\u0002F&\u0019\u0011qY,\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u0007A\u0002\u0019AAf!\u0011\ti-!9\u000e\u0005\u0005='\u0002BAi\u0003'\fQ\u0001^=qKNTA!!6\u0002X\u0006\u00191/\u001d7\u000b\u00079\u000bIN\u0003\u0003\u0002\\\u0006u\u0017AB1qC\u000eDWM\u0003\u0002\u0002`\u0006\u0019qN]4\n\t\u0005\r\u0018q\u001a\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017\u0001F:fiN\u0003\u0018M]6DC2,g\u000eZ1s\u0007>tg\r\u0006\u0002\u0002D\u0006Qq-\u001a;BI\u0012\u0014Xm]:\u0015\u0005\u00055\b\u0003BAx\u0003otA!!=\u0002tB\u0019\u0011QR,\n\u0007\u0005Ux+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\nIPC\u0002\u0002v^\u000bq\u0002Z8Qe\u0016<&/\u001b;f'R,\u0007o\u001d\u000b\u0003\u0003\u0003\fqc\u00195fG.\u001c6\r[3nCRK\b/Z:TkB\u0004xN\u001d;\u0015\t\u0005\u0005'1\u0001\u0005\u0006Er\u0001\r\u0001Z\u0001\u0006i&lWM]\u000b\u0003\u0005\u0013\u0001BAa\u0003\u0003\u000e5\u0011\u0011QA\u0005\u0005\u0005\u001f\t)AA\u0003US6,'/\u0001\u0004uS6,'\u000fI\u0001\u0014gR\f'\u000f\u001e)beRLG/[8o/JLG/\u001a\u000b\u0005\u0003\u0003\u00149\u0002C\u0004\u0003\u001a}\u0001\r!!<\u0002\u0011Ut\u0017.];f\u0013\u0012\f\u0011b\u001e:ji\u0016$\u0015\r^1\u0015\t\u0005\u0005'q\u0004\u0005\b\u0005C\u0001\u0003\u0019\u0001B\u0012\u0003\u0011!\u0017\r^1\u0011\u0007q\u0013)#C\u0002\u0003(%\u0013\u0011\u0002R1uC\ncwnY6\u0002#\u0015tG\rU1si&$\u0018n\u001c8Xe&$X-\u0001\nck&dGmQ8qsN#\u0018\r^3nK:$H\u0003DAw\u0005_\u0011\u0019Da\u000e\u0003<\t}\u0002b\u0002B\u0019E\u0001\u0007\u0011Q^\u0001\fi\u0006\u0014x-\u001a;UC\ndW\rC\u0004\u00036\t\u0002\r!!<\u0002\u0015\r|G.^7o\u0019&\u001cH\u000fC\u0004\u0003:\t\u0002\r!!<\u0002\u0007U\u0014H\u000eC\u0004\u0003>\t\u0002\r!!<\u0002!I,'.Z2ugR\u000b'\r\\3OC6,\u0007b\u0002B!E\u0001\u0007\u0011Q^\u0001\u000bM&dWMR8s[\u0006$\u0018a\u00052vS2$W*\u001a:hKN#\u0018\r^3nK:$H\u0003CAw\u0005\u000f\u0012YE!\u0014\t\u000f\t%3\u00051\u0001\u0002Z\u0005yA/\u0019:hKR$\u0016M\u00197f\u001d\u0006lW\rC\u0004\u00036\r\u0002\r!!<\t\u000f\t=3\u00051\u0001\u0002n\u0006IA/Z7q)\u0006\u0014G.Z\u0001\ra\u0016\u0014hm\u001c:n\u001b\u0016\u0014x-\u001a\u000b\u0005\u0003\u0003\u0014)\u0006C\u0004\u0003X\u0011\u0002\r!!<\u0002\u001d5,'oZ3Ti\u0006$X-\\3oi\u0006A\u0012N\u001c4fe\u0016CH/\u001a:oC2$\u0016M\u00197f'\u000eDW-\\1\u0015\u0005\tu\u0003CBAA\u0003K\u000bi/A\nck&dG-\u00138gKJ\u001cF/\u0019;f[\u0016tG\u000f\u0006\u0004\u0002n\n\r$Q\r\u0005\b\u0005s1\u0003\u0019AAw\u0011\u001d\u00119G\na\u0001\u0003[\f\u0011\u0002^1cY\u0016t\u0015-\\3\u0002\u001b\u001d,GoQ8mk6tG*[:u+\t\u0011iF\u0001\rGCVdG\u000fV8mKJ\fgnY3UKN$(+Z:vYR\u001cb\u0001K+\u0003r\t]\u0004c\u0001,\u0003t%\u0019!QO,\u0003\u000fA\u0013x\u000eZ;diB\u0019aK!\u001f\n\u0007\tmtK\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0004tk\u000e\u001cWm]:\u0016\u0005\t\u0005\u0005c\u0001,\u0003\u0004&\u0019!QQ,\u0003\u000f\t{w\u000e\\3b]\u0006A1/^2dKN\u001c\b%A\tgC&dW\r\u001a*poN\u0004VM]2f]R,\"A!$\u0011\u0007Y\u0013y)C\u0002\u0003\u0012^\u0013a\u0001R8vE2,\u0017A\u00054bS2,GMU8xgB+'oY3oi\u0002\"bAa&\u0003\u001c\nu\u0005c\u0001BMQ5\t\u0001\u0001C\u0004\u0003~5\u0002\rA!!\t\u000f\t%U\u00061\u0001\u0003\u000e\u0006!1m\u001c9z)\u0019\u00119Ja)\u0003&\"I!Q\u0010\u0018\u0011\u0002\u0003\u0007!\u0011\u0011\u0005\n\u0005\u0013s\u0003\u0013!a\u0001\u0005\u001b\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003,*\"!\u0011\u0011BWW\t\u0011y\u000b\u0005\u0003\u00032\nmVB\u0001BZ\u0015\u0011\u0011)La.\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B]/\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tu&1\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005\u0007TCA!$\u0003.\u0006i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003N\nM\u0007c\u0001,\u0003P&\u0019!\u0011[,\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003VN\n\t\u00111\u0001\u0002&\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa7\u0011\r\tu'1\u001dBg\u001b\t\u0011yNC\u0002\u0003b^\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Oa8\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u0003\u0013Y\u000fC\u0005\u0003VV\n\t\u00111\u0001\u0003N\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002&\u0005AAo\\*ue&tw\r\u0006\u0002\u0002f\u00051Q-];bYN$BA!!\u0003z\"I!Q\u001b\u001d\u0002\u0002\u0003\u0007!QZ\u0001\u0019\r\u0006,H\u000e\u001e+pY\u0016\u0014\u0018M\\2f)\u0016\u001cHOU3tk2$\bc\u0001BMuM)!h!\u0001\u0003xAQ11AB\u0005\u0005\u0003\u0013iIa&\u000e\u0005\r\u0015!bAB\u0004/\u00069!/\u001e8uS6,\u0017\u0002BB\u0006\u0007\u000b\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011i0A\u0003baBd\u0017\u0010\u0006\u0004\u0003\u0018\u000eM1Q\u0003\u0005\b\u0005{j\u0004\u0019\u0001BA\u0011\u001d\u0011I)\u0010a\u0001\u0005\u001b\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004\u001c\r\u001d\u0002#\u0002,\u0004\u001e\r\u0005\u0012bAB\u0010/\n1q\n\u001d;j_:\u0004rAVB\u0012\u0005\u0003\u0013i)C\u0002\u0004&]\u0013a\u0001V;qY\u0016\u0014\u0004\"CB\u0015}\u0005\u0005\t\u0019\u0001BL\u0003\rAH\u0005M\u0001\u0013i\u0016\u001cHOR1vYR$v\u000e\\3sC:\u001cW\r\u0006\u0004\u00040\rE2Q\u0007\t\u0007\u0003\u0003\u000b)Ka&\t\u000f\rMr\b1\u0001\u0002&\u0005Q!o\\<t\u0007>\u0004\u0018.\u001a3\t\u000f\r]r\b1\u0001\u0002n\u0006a!/\u001a6fGR\u001cH+\u00192mK\u0006Y\u0001/\u001a:g_Jl7i\u001c9z)\u0019\u0019ida\u0010\u0004DA1\u0011\u0011QAS\u0003KAqa!\u0011A\u0001\u0004\ti/A\u0007d_BL8\u000b^1uK6,g\u000e\u001e\u0005\b\u0007\u000b\u0002\u0005\u0019AA-\u0003%!\u0018M\u00197f]\u0006lW-A\u000bd_6l\u0017\u000e\u001e#bi\u0006Le\u000e^8WKJ$\u0018nY1\u0015\t\u0005\u000571\n\u0005\b\u0005s\t\u0005\u0019AAw\u0003e\u0019w.\\7ji\u0012\u000bG/Y!t\u000bb$XM\u001d8bYR\u000b'\r\\3\u0015\t\u0005\u00057\u0011\u000b\u0005\b\u0005s\u0011\u0005\u0019AAw\u0003\u0019\u0019w.\\7ji\u0006)c+\u001a:uS\u000e\fG)[:ue&\u0014W\u000f^3e\r&dWm]=ti\u0016lwK]5uKBK\u0007/\u001a\t\u00039\u0016\u001b\"!R+\u0015\u0005\r]\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'\u0006\u0002\u0004b)\"\u0011Q\u0005BW\u0001")
public class VerticaDistributedFilesystemWritePipe
implements VerticaPipeInterface,
VerticaPipeWriteInterface {
    private volatile VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$ FaultToleranceTestResult$module;
    private final DistributedFilesystemWriteConfig config;
    private final FileStoreLayerInterface fileStoreLayer;
    private final JdbcLayerInterface jdbcLayer;
    private final SchemaToolsInterface schemaTools;
    private final TableUtilsInterface tableUtils;
    private final int dataSize;
    private final Logger logger;
    private final TableName tempTableName;
    private final String LEGACY_PARQUET_REBASE_MODE_IN_WRITE;
    private final String LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE;
    private final Timer timer;

    public static int $lessinit$greater$default$6() {
        return VerticaDistributedFilesystemWritePipe$.MODULE$.$lessinit$greater$default$6();
    }

    private VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$ FaultToleranceTestResult() {
        if (this.FaultToleranceTestResult$module == null) {
            this.FaultToleranceTestResult$lzycompute$1();
        }
        return this.FaultToleranceTestResult$module;
    }

    public DistributedFilesystemWriteConfig config() {
        return this.config;
    }

    public FileStoreLayerInterface fileStoreLayer() {
        return this.fileStoreLayer;
    }

    public JdbcLayerInterface jdbcLayer() {
        return this.jdbcLayer;
    }

    public SchemaToolsInterface schemaTools() {
        return this.schemaTools;
    }

    public TableUtilsInterface tableUtils() {
        return this.tableUtils;
    }

    public int dataSize() {
        return this.dataSize;
    }

    private Logger logger() {
        return this.logger;
    }

    private TableName tempTableName() {
        return this.tempTableName;
    }

    private String LEGACY_PARQUET_REBASE_MODE_IN_WRITE() {
        return this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE;
    }

    private String LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE() {
        return this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE;
    }

    @Override
    public Either<ConnectorError, VerticaMetadata> getMetadata() {
        return package$.MODULE$.Right().apply((Object)new VerticaWriteMetadata());
    }

    @Override
    public Either<ConnectorError, Object> getDataBlockSize() {
        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)this.dataSize()));
    }

    public Either<ConnectorError, BoxedUnit> checkSchemaForDuplicates(StructType schema) {
        String[] names = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)f -> f.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])names)).distinct()).length != names.length ? package$.MODULE$.Left().apply((Object)new DuplicateColumnsError()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private void setSparkCalendarConf() {
        Option option = SparkSession$.MODULE$.getActiveSession();
        if (option instanceof Some) {
            Some some = (Some)option;
            SparkSession session = (SparkSession)some.value();
            session.sparkContext().setLocalProperty(this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE(), "CORRECTED");
            session.sparkContext().setLocalProperty(this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE(), "CORRECTED");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("No spark session found to set config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private String getAddress() {
        return this.config().createExternalTable().isDefined() ? this.config().fileStoreConfig().externalTableAddress() : this.config().fileStoreConfig().address();
    }

    @Override
    public Either<ConnectorError, BoxedUnit> doPreWriteSteps() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.config().mergeKey().isDefined() && this.config().isOverwrite()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Save mode is specified as Overwrite during a merge.");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Writing data to Parquet file.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.checkSchemaForDuplicates(this.config().schema()).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.checkSchemaTypesSupport(this.config()).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.setSparkCalendarConf();
            BoxedUnit x$2 = BoxedUnit.UNIT;
            return new Tuple2(x$1, (Object)x$2);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Either either = (this.config().isOverwrite() && this.config().mergeKey().isEmpty() ? this.tableUtils().dropTable(this.config().tablename()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> (this.config().createExternalTable().isDefined() && this.config().mergeKey().isDefined() ? package$.MODULE$.Left().apply((Object)new CreateExternalTableMergeKey()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.tableUtils().tableExists(this.config().tablename()).flatMap((Function1 & Serializable & scala.Serializable)tableExistsPre -> VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$6(this, BoxesRunTime.unboxToBoolean((Object)tableExistsPre)))));
            return either;
        }));
    }

    private Either<ConnectorError, BoxedUnit> checkSchemaTypesSupport(DistributedFilesystemWriteConfig config) {
        VerticaVersion verticaVersion = VerticaVersionUtils$.MODULE$.getVersion(this.jdbcLayer());
        boolean toInternalTable = config.createExternalTable().isEmpty();
        return VerticaVersionUtils$.MODULE$.checkSchemaTypesWriteSupport(config.schema(), verticaVersion, toInternalTable);
    }

    public Timer timer() {
        return this.timer;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Either<ConnectorError, BoxedUnit> startPartitionWrite(String uniqueId) {
        block9: {
            block8: {
                address = this.getAddress();
                v0 = new StringOps(Predef$.MODULE$.augmentString(address)).takeRight(1);
                var5_3 = "/";
                if (!(v0 == null ? var5_3 != null : v0.equals(var5_3) == false)) ** GOTO lbl-1000
                v1 = new StringOps(Predef$.MODULE$.augmentString(address)).takeRight(1);
                var6_4 = "\\";
                if (!(v1 != null ? v1.equals(var6_4) == false : var6_4 != null)) lbl-1000:
                // 2 sources

                {
                    v2 = "";
                } else {
                    v2 = "/";
                }
                delimiter = v2;
                filename = new StringBuilder(15).append(address).append(delimiter).append(uniqueId).append(".snappy.parquet").toString();
                this.timer().startTime();
                var8_7 = this.fileStoreLayer().openWriteParquetFile(filename);
                if (!(var8_7 instanceof Left)) break block8;
                var9_8 = (Left)var8_7;
                err = (ConnectorError)var9_8.value();
                if (!this.config().fileStoreConfig().preventCleanup()) {
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info(new StringBuilder(31).append("Cleaning up all files in path: ").append(address).toString());
                        v3 = BoxedUnit.UNIT;
                    } else {
                        v3 = BoxedUnit.UNIT;
                    }
                    v4 = this.fileStoreLayer().removeDir(address);
                } else {
                    v4 = BoxedUnit.UNIT;
                }
                var2_10 = package$.MODULE$.Left().apply((Object)err);
                break block9;
            }
            if (!(var8_7 instanceof Right)) ** GOTO lbl-1000
            var11_11 = (Right)var8_7;
            var12_12 = (BoxedUnit)var11_11.value();
            v5 = BoxedUnit.UNIT;
            var13_13 = var12_12;
            if (!(v5 != null ? v5.equals(var13_13) == false : var13_13 != null)) {
                var2_10 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError(var8_7);
            }
        }
        return var2_10;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> writeData(DataBlock data) {
        Either<ConnectorError, BoxedUnit> either;
        Option<CreateExternalTableOption> option = this.config().createExternalTable();
        if (option instanceof Some) {
            Either<ConnectorError, BoxedUnit> either2;
            Some some = (Some)option;
            CreateExternalTableOption value = (CreateExternalTableOption)some.value();
            CreateExternalTableOption createExternalTableOption = value;
            if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                either2 = package$.MODULE$.Left().apply((Object)new NonEmptyDataFrameError());
            } else if (NewData$.MODULE$.equals(createExternalTableOption)) {
                either2 = this.fileStoreLayer().writeDataToParquetFile(data);
            } else {
                throw new MatchError((Object)createExternalTableOption);
            }
            either = either2;
        } else if (None$.MODULE$.equals(option)) {
            either = this.fileStoreLayer().writeDataToParquetFile(data);
        } else {
            throw new MatchError(option);
        }
        return either;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> endPartitionWrite() {
        Either<ConnectorError, BoxedUnit> either;
        this.timer().endTime();
        Option<CreateExternalTableOption> option = this.config().createExternalTable();
        if (option instanceof Some) {
            Either<ConnectorError, BoxedUnit> either2;
            Some some = (Some)option;
            CreateExternalTableOption value = (CreateExternalTableOption)some.value();
            CreateExternalTableOption createExternalTableOption = value;
            if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                either2 = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else if (NewData$.MODULE$.equals(createExternalTableOption)) {
                either2 = this.fileStoreLayer().closeWriteParquetFile();
            } else {
                throw new MatchError((Object)createExternalTableOption);
            }
            either = either2;
        } else if (None$.MODULE$.equals(option)) {
            either = this.fileStoreLayer().closeWriteParquetFile();
        } else {
            throw new MatchError(option);
        }
        return either;
    }

    public String buildCopyStatement(String targetTable, String columnList, String url, String rejectsTableName, String fileFormat) {
        return this.config().mergeKey().isDefined() ? new StringBuilder(60).append("COPY ").append(targetTable).append(" FROM '").append(url).append("' ON ANY NODE ").append(fileFormat).append(" REJECTED DATA AS TABLE ").append(rejectsTableName).append(" NO COMMIT").toString() : new StringBuilder(61).append("COPY ").append(targetTable).append(" ").append(columnList).append(" FROM '").append(url).append("' ON ANY NODE ").append(fileFormat).append(" REJECTED DATA AS TABLE ").append(rejectsTableName).append(" NO COMMIT").toString();
    }

    public String buildMergeStatement(TableName targetTableName, String columnList, String tempTable) {
        Object object;
        String string;
        String string2;
        String targetTable = targetTableName.getFullTableName();
        Either<ConnectorError, String> either = this.schemaTools().getMergeUpdateValues(this.jdbcLayer(), targetTableName, this.tempTableName(), this.config().copyColumnList());
        if (either instanceof Right) {
            String values;
            Right right = (Right)either;
            string2 = values = (String)right.value();
        } else if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            string2 = package$.MODULE$.Left().apply((Object)new MergeColumnListError(err));
        } else {
            throw new MatchError(either);
        }
        String updateColValues = string2;
        Either<ConnectorError, String> either2 = this.schemaTools().getMergeInsertValues(this.jdbcLayer(), this.tempTableName(), this.config().copyColumnList());
        if (either2 instanceof Right) {
            String values;
            Right right = (Right)either2;
            string = values = (String)right.value();
        } else if (either2 instanceof Left) {
            Left left = (Left)either2;
            ConnectorError err = (ConnectorError)left.value();
            string = package$.MODULE$.Left().apply((Object)new MergeColumnListError(err));
        } else {
            throw new MatchError(either2);
        }
        String insertColValues = string;
        Option<ValidColumnList> option = this.config().mergeKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            ValidColumnList key = (ValidColumnList)some.value();
            List trimmedCols = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])key.toString().split(","))).toList().map((Function1 & Serializable & scala.Serializable)col -> col.trim(), List$.MODULE$.canBuildFrom());
            object = ((TraversableOnce)trimmedCols.map((Function1 & Serializable & scala.Serializable)trimmedCol -> new StringBuilder(13).append("target.").append((String)trimmedCol).append("=temp.").append((String)trimmedCol).toString(), List$.MODULE$.canBuildFrom())).mkString(" AND ");
        } else if (None$.MODULE$.equals(option)) {
            object = Nil$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        Nil$ mergeList = object;
        return new StringBuilder(112).append("MERGE INTO ").append(targetTable).append(" as target using ").append(tempTable).append(" as temp ON (").append(mergeList).append(") WHEN MATCHED THEN UPDATE SET ").append((Object)updateColValues).append(" WHEN NOT MATCHED THEN INSERT ").append(columnList).append(" VALUES (").append((Object)insertColValues).append(")").toString();
    }

    public Either<ConnectorError, BoxedUnit> performMerge(String mergeStatement) {
        BoxedUnit boxedUnit;
        Either ret = this.jdbcLayer().query(new StringBuilder(8).append("EXPLAIN ").append(mergeStatement).toString(), this.jdbcLayer().query$default$2()).map((Function1 & Serializable & scala.Serializable)rs -> {
            rs.close();
            BoxedUnit x$6 = BoxedUnit.UNIT;
            return new Tuple2(rs, (Object)x$6);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Either either = this.jdbcLayer().execute(mergeStatement, this.jdbcLayer().execute$default$2()).map((Function1 & Serializable & scala.Serializable)_ -> {
                VerticaDistributedFilesystemWritePipe.$anonfun$performMerge$3(_);
                return BoxedUnit.UNIT;
            });
            return either;
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Executing merge");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ret.left().map((Function1 & Serializable & scala.Serializable)err -> new CommitError((ConnectorError)err).context("performMerge: JDBC error when trying to merge"));
    }

    public Either<ConnectorError, String> inferExternalTableSchema() {
        Left left;
        BoxedUnit boxedUnit;
        String string;
        String tableName = this.config().tablename().getFullTableName().replaceAll("\"", "");
        Either<ConnectorError, Seq<String>> either = this.fileStoreLayer().getGlobStatus(EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(10).append(new StringOps(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress())).stripSuffix("/")).append("/*.parquet").toString(), EscapeUtils$.MODULE$.sqlEscape$default$2()));
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq list = (Seq)right.value();
            String url = list.nonEmpty() ? EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(10).append(new StringOps(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress())).stripSuffix("/")).append("/*.parquet").toString(), EscapeUtils$.MODULE$.sqlEscape$default$2()) : EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(13).append(new StringOps(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress())).stripSuffix("/")).append("/**/*.parquet").toString(), EscapeUtils$.MODULE$.sqlEscape$default$2());
            string = this.buildInferStatement(url, tableName);
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            string = err.getFullContext();
        } else {
            throw new MatchError(either);
        }
        String inferStatement = string;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(24).append("The infer statement is: ").append(inferStatement).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Either<ConnectorError, ResultSet> either2 = this.jdbcLayer().query(inferStatement, this.jdbcLayer().query$default$2());
        if (either2 instanceof Left) {
            Left left3 = (Left)either2;
            ConnectorError err = (ConnectorError)left3.value();
            left = package$.MODULE$.Left().apply((Object)new InferExternalTableSchemaError(err));
        } else if (either2 instanceof Right) {
            Right right;
            block22: {
                Right right2 = (Right)either2;
                try (ResultSet resultSet = (ResultSet)right2.value();){
                    try {
                        BoxedUnit boxedUnit2;
                        resultSet.next();
                        String createExternalTableStatement = resultSet.getString(1);
                        boolean isPartitioned = inferStatement.contains(EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(13).append(new StringOps(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress())).stripSuffix("/")).append("/**/*.parquet").toString(), EscapeUtils$.MODULE$.sqlEscape$default$2()));
                        if (!(isPartitioned || createExternalTableStatement.contains("varchar") || createExternalTableStatement.contains("varbinary"))) {
                            BoxedUnit boxedUnit3;
                            BoxedUnit boxedUnit4;
                            if (this.logger().underlying().isInfoEnabled()) {
                                this.logger().underlying().info("Inferring schema from parquet data");
                                boxedUnit4 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit4 = BoxedUnit.UNIT;
                            }
                            String updatedStatement = createExternalTableStatement.replace(new StringBuilder(2).append("\"").append(tableName).append("\"").toString(), tableName);
                            if (this.logger().underlying().isDebugEnabled()) {
                                this.logger().underlying().debug(new StringBuilder(40).append("The create external table statement is: ").append(updatedStatement).toString());
                                boxedUnit3 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit3 = BoxedUnit.UNIT;
                            }
                            right = package$.MODULE$.Right().apply((Object)updatedStatement);
                            break block22;
                        }
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Inferring partial schema from dataframe");
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        right = this.schemaTools().inferExternalTableSchema(createExternalTableStatement, this.config().schema(), tableName, this.config().strlen(), this.config().arrayLength());
                    }
                    catch (Throwable e) {
                        right = package$.MODULE$.Left().apply((Object)new InferExternalSchemaError(e));
                    }
                }
            }
            left = right;
        } else {
            throw new MatchError(either2);
        }
        return left;
    }

    public String buildInferStatement(String url, String tableName) {
        return new StringBuilder(105).append("SELECT INFER_TABLE_DDL('").append(url).append("' USING PARAMETERS format = 'parquet', table_name = '").append(tableName).append("', table_type = 'external');").toString();
    }

    private Either<ConnectorError, String> getColumnList() {
        Either either;
        Option<ValidColumnList> option = this.config().copyColumnList();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            ValidColumnList list = (ValidColumnList)some.value();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder(66).append("Using custom COPY column list. ").append("Target table: ").append(this.config().tablename().getFullTableName()).append(", ").append("copy_column_list: ").append(list).append(".").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            either = package$.MODULE$.Right().apply((Object)new StringBuilder(2).append("(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])list.toString().split(","))).map((Function1 & Serializable & scala.Serializable)col -> col.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",")).append(")").toString());
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Building default copy column list");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            either = this.schemaTools().getCopyColumnList(this.jdbcLayer(), this.config().tablename(), this.config().schema()).left().map((Function1 & Serializable & scala.Serializable)err -> new SchemaColumnListError((ConnectorError)err).context("getColumnList: Error building default copy column list"));
        } else {
            throw new MatchError(option);
        }
        return either;
    }

    private Either<ConnectorError, FaultToleranceTestResult> testFaultTolerance(int rowsCopied, String rejectsTable) {
        BoxedUnit boxedUnit;
        String rejectsQuery = new StringBuilder(30).append("SELECT COUNT(*) as count FROM ").append(rejectsTable).toString();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(48).append("Checking number of rejected rows via statement: ").append(rejectsQuery).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.jdbcLayer().query(rejectsQuery, this.jdbcLayer().query$default$2()).map((Function1 & Serializable & scala.Serializable)rs -> {
            Try res = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                int n;
                if (rs.next()) {
                    n = rs.getInt("count");
                } else {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Could not retrieve rejected row count.");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    n = 0;
                }
                return n;
            });
            rs.close();
            BoxedUnit x$11 = BoxedUnit.UNIT;
            return new Tuple3(rs, (Object)res, (Object)x$11);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$17 -> {
            Tuple3 tuple3 = x$17;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Try res = (Try)tuple3._2();
            Either either = JdbcUtils$.MODULE$.tryJdbcToResult(this.jdbcLayer(), res).map((Function1 & Serializable & scala.Serializable)rejectedCount -> VerticaDistributedFilesystemWritePipe.$anonfun$testFaultTolerance$4(this, rowsCopied, BoxesRunTime.unboxToInt((Object)rejectedCount))).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> {
                Right right;
                boolean passedFaultToleranceTest;
                double failedRowsPercent;
                Tuple6 tuple6 = x$16;
                if (tuple6 != null) {
                    int rejectedCount = BoxesRunTime.unboxToInt((Object)tuple6._1());
                    failedRowsPercent = BoxesRunTime.unboxToDouble((Object)tuple6._2());
                    passedFaultToleranceTest = BoxesRunTime.unboxToBoolean((Object)tuple6._3());
                    if (rejectedCount == 0) {
                        BoxedUnit boxedUnit;
                        String dropRejectsTableStatement = new StringBuilder(29).append("DROP TABLE IF EXISTS ").append(rejectsTable).append(" CASCADE").toString();
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info(new StringBuilder(36).append("Dropping Vertica rejects table now: ").append(dropRejectsTableStatement).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        right = this.jdbcLayer().execute(dropRejectsTableStatement, this.jdbcLayer().execute$default$2());
                    } else {
                        BoxedUnit boxedUnit;
                        String rejectsDataQuery = new StringBuilder(131).append("SELECT COUNT(*) count, MIN(rejected_data) example_data, rejected_reason FROM ").append(rejectsTable).append(" GROUP BY rejected_reason ORDER BY count DESC LIMIT 10").toString();
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info(new StringBuilder(48).append("Getting summary of rejected rows via statement: ").append(rejectsDataQuery).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        this.jdbcLayer().query(rejectsDataQuery, this.jdbcLayer().query$default$2()).map((Function1 & Serializable & scala.Serializable)rs -> {
                            Try x$8 = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                                BoxedUnit boxedUnit;
                                BoxedUnit boxedUnit2;
                                ResultSetMetaData rsmd = rs.getMetaData();
                                if (this.logger().underlying().isErrorEnabled()) {
                                    this.logger().underlying().error("Found {} rejected rows, displaying up to 10 of the most common reasons:", new Object[]{BoxesRunTime.boxToInteger((int)rejectedCount)});
                                    boxedUnit2 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                if (this.logger().underlying().isErrorEnabled()) {
                                    this.logger().underlying().error(((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), rsmd.getColumnCount()).map((Function1 & Serializable & scala.Serializable)idx -> rsmd.getColumnName(BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).toList().mkString(" | "));
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                while (rs.next()) {
                                    BoxedUnit boxedUnit3;
                                    if (this.logger().underlying().isErrorEnabled()) {
                                        this.logger().underlying().error(((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), rsmd.getColumnCount()).map((Function1 & Serializable & scala.Serializable)idx -> rs.getString(BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).toList().mkString(" | "));
                                        boxedUnit3 = BoxedUnit.UNIT;
                                        continue;
                                    }
                                    boxedUnit3 = BoxedUnit.UNIT;
                                }
                            });
                            rs.close();
                            BoxedUnit x$9 = BoxedUnit.UNIT;
                            return new Tuple3(rs, (Object)x$8, (Object)x$9);
                        }).map((Function1 & Serializable & scala.Serializable)x$10 -> {
                            VerticaDistributedFilesystemWritePipe.$anonfun$testFaultTolerance$10(x$10);
                            return BoxedUnit.UNIT;
                        });
                        right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    }
                } else {
                    throw new MatchError((Object)tuple6);
                }
                Either either = right.map((Function1 & Serializable & scala.Serializable)x$14 -> {
                    FaultToleranceTestResult testResult = new FaultToleranceTestResult(this, passedFaultToleranceTest, failedRowsPercent);
                    return new Tuple2(x$14, (Object)testResult);
                }).map((Function1 & Serializable & scala.Serializable)x$15 -> {
                    FaultToleranceTestResult testResult;
                    Tuple2 tuple2 = x$15;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    FaultToleranceTestResult faultToleranceTestResult = testResult = (FaultToleranceTestResult)tuple2._2();
                    return faultToleranceTestResult;
                });
                return either;
            });
            return either;
        });
    }

    public Either<ConnectorError, Object> performCopy(String copyStatement, TableName tablename) {
        BoxedUnit boxedUnit;
        String emptyCopy = new StringBuilder(14).append("COPY ").append(tablename.getFullTableName()).append(" FROM '';").toString();
        this.jdbcLayer().executeUpdate(emptyCopy, this.jdbcLayer().executeUpdate$default$2());
        Either ret = this.jdbcLayer().query(new StringBuilder(8).append("EXPLAIN ").append(copyStatement).toString(), this.jdbcLayer().query$default$2()).map((Function1 & Serializable & scala.Serializable)rs -> {
            rs.close();
            BoxedUnit x$18 = BoxedUnit.UNIT;
            return new Tuple2(rs, (Object)x$18);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$19 -> {
            Tuple2 tuple2 = x$19;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Either either = this.jdbcLayer().executeUpdate(copyStatement, this.jdbcLayer().executeUpdate$default$2()).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)rowsCopied -> rowsCopied);
            return either;
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Performing copy from file store to Vertica");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ret.left().map((Function1 & Serializable & scala.Serializable)err -> new CommitError((ConnectorError)err).context("performCopy: JDBC error when trying to copy"));
    }

    public Either<ConnectorError, BoxedUnit> commitDataIntoVertica(String url) {
        BoxedUnit boxedUnit;
        int tableNameMaxLength = 30;
        Timer timer = new Timer(this.config().timeOperations(), this.logger(), "Copy and commit data into Vertica");
        timer.startTime();
        Either ret = this.jdbcLayer().configureSession(this.fileStoreLayer()).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.getColumnList().left().map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.context("commit: Failed to get column list")).map((Function1 & Serializable & scala.Serializable)columnList -> {
            String tableName = this.config().tablename().name();
            String sessionId = this.config().sessionId();
            return new Tuple3(columnList, (Object)tableName, (Object)sessionId);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$29 -> {
            Tuple3 tuple3 = x$29;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String columnList = (String)tuple3._1();
            String tableName = (String)tuple3._2();
            String sessionId = (String)tuple3._3();
            Either either = (this.config().mergeKey().isDefined() ? this.tableUtils().createTempTable(this.tempTableName(), this.config().schema(), this.config().strlen(), this.config().arrayLength()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.tableUtils().tempTableExists(this.tempTableName()).flatMap((Function1 & Serializable & scala.Serializable)tempTableExists -> VerticaDistributedFilesystemWritePipe.$anonfun$commitDataIntoVertica$6(this, tableName, tableNameMaxLength, sessionId, columnList, url, BoxesRunTime.unboxToBoolean((Object)tempTableExists))));
            return either;
        }));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Committing data into Vertica.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Either<ConnectorError, BoxedUnit> either = !this.config().fileStoreConfig().preventCleanup() ? this.fileStoreLayer().removeDir(this.config().fileStoreConfig().address()) : BoxedUnit.UNIT;
        timer.endTime();
        return ret;
    }

    public Either<ConnectorError, BoxedUnit> commitDataAsExternalTable(String url) {
        Right right;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Timer timer = new Timer(this.config().timeOperations(), this.logger(), "Commit data as external table");
        timer.startTime();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Committing data as external table.");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.config().copyColumnList().isDefined()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Custom copy column list was specified, but will be ignored when creating new external table.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Either ret = this.jdbcLayer().configureSession(this.fileStoreLayer()).map((Function1 & Serializable & scala.Serializable)x$30 -> {
            boolean bl;
            Option<CreateExternalTableOption> option = this.config().createExternalTable();
            if (option instanceof Some) {
                boolean bl2;
                Some some = (Some)option;
                CreateExternalTableOption value = (CreateExternalTableOption)some.value();
                CreateExternalTableOption createExternalTableOption = value;
                if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                    bl2 = true;
                } else if (NewData$.MODULE$.equals(createExternalTableOption)) {
                    bl2 = false;
                } else {
                    throw new MatchError((Object)createExternalTableOption);
                }
                bl = bl2;
            } else if (None$.MODULE$.equals(option)) {
                bl = false;
            } else {
                throw new MatchError(option);
            }
            boolean existingData = bl;
            return new Tuple2(x$30, (Object)BoxesRunTime.boxToBoolean((boolean)existingData));
        }).flatMap((Function1 & Serializable & scala.Serializable)x$31 -> {
            Tuple2 tuple2 = x$31;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            boolean existingData = tuple2._2$mcZ$sp();
            Either either = (existingData ? this.inferExternalTableSchema() : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)createExternalTableStmt -> this.tableUtils().createExternalTable(this.config().tablename(), (Option<String>)(existingData ? new Some((Object)createExternalTableStmt.toString()) : this.config().targetTableSql()), this.config().schema(), this.config().strlen(), url, this.config().arrayLength()).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.tableUtils().validateExternalTable(this.config().tablename(), this.config().schema()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> (this.config().saveJobStatusTable() ? this.tableUtils().updateJobStatusTable(this.config().tablename(), this.config().jdbcConfig().auth().user(), 0.0, this.config().sessionId(), true) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).map((Function1 & Serializable & scala.Serializable)_ -> {
                VerticaDistributedFilesystemWritePipe.$anonfun$commitDataAsExternalTable$6(_);
                return BoxedUnit.UNIT;
            }))));
            return either;
        });
        timer.endTime();
        Either either = ret;
        if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            this.tableUtils().dropTable(this.config().tablename());
            right = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError((Object)either);
        }
        return right;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> commit() {
        Either either;
        String globPattern = "*.parquet";
        String url = EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(1).append(new StringOps(Predef$.MODULE$.augmentString(this.getAddress())).stripSuffix("/")).append("/").append(globPattern).toString(), EscapeUtils$.MODULE$.sqlEscape$default$2());
        Either<ConnectorError, BoxedUnit> ret = this.config().createExternalTable().isDefined() ? this.commitDataAsExternalTable(url) : this.commitDataIntoVertica(url);
        Either<ConnectorError, BoxedUnit> either2 = ret;
        if (either2 instanceof Right) {
            either = this.jdbcLayer().commit().left().map((Function1 & Serializable & scala.Serializable)err -> new CommitError((ConnectorError)err).context("JDBC Error when trying to commit"));
        } else if (either2 instanceof Left) {
            Left left;
            Left left2 = (Left)either2;
            ConnectorError retError = (ConnectorError)left2.value();
            Either<ConnectorError, BoxedUnit> either3 = this.jdbcLayer().rollback();
            if (either3 instanceof Right) {
                left = package$.MODULE$.Left().apply((Object)retError);
            } else if (either3 instanceof Left) {
                Left left3 = (Left)either3;
                ConnectorError err2 = (ConnectorError)left3.value();
                left = package$.MODULE$.Left().apply((Object)retError.context(new StringBuilder(36).append("JDBC Error when trying to rollback: ").append(err2.getFullContext()).toString()));
            } else {
                throw new MatchError(either3);
            }
            either = left;
        } else {
            throw new MatchError(either2);
        }
        Either result = either;
        this.jdbcLayer().close();
        return result;
    }

    private final void FaultToleranceTestResult$lzycompute$1() {
        VerticaDistributedFilesystemWritePipe verticaDistributedFilesystemWritePipe = this;
        synchronized (verticaDistributedFilesystemWritePipe) {
            if (this.FaultToleranceTestResult$module == null) {
                this.FaultToleranceTestResult$module = new VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$doPreWriteSteps$18(BoxedUnit _) {
    }

    public static final /* synthetic */ Either $anonfun$doPreWriteSteps$14(VerticaDistributedFilesystemWritePipe $this, boolean tableExistsPost) {
        return (tableExistsPost || $this.config().createExternalTable().isDefined() ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)new CreateTableError((Option<ConnectorError>)None$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            boolean bl;
            ValidFilePermissions perm = $this.config().filePermissions();
            Option<CreateExternalTableOption> option = $this.config().createExternalTable();
            if (option instanceof Some) {
                boolean bl2;
                Some some = (Some)option;
                CreateExternalTableOption value = (CreateExternalTableOption)some.value();
                CreateExternalTableOption createExternalTableOption = value;
                if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                    bl2 = true;
                } else if (NewData$.MODULE$.equals(createExternalTableOption)) {
                    bl2 = false;
                } else {
                    throw new MatchError((Object)createExternalTableOption);
                }
                bl = bl2;
            } else if (None$.MODULE$.equals(option)) {
                bl = false;
            } else {
                throw new MatchError(option);
            }
            boolean existingData = bl;
            return new Tuple3(x$3, (Object)perm, (Object)BoxesRunTime.boxToBoolean((boolean)existingData));
        }).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple3 tuple3 = x$4;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            ValidFilePermissions perm = (ValidFilePermissions)tuple3._2();
            boolean existingData = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            Either either = (existingData ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : $this.fileStoreLayer().createDir($this.getAddress(), perm.toString())).flatMap((Function1 & Serializable & scala.Serializable)_2 -> ($this.config().saveJobStatusTable() ? $this.tableUtils().createAndInitJobStatusTable($this.config().tablename(), $this.config().jdbcConfig().auth().user(), $this.config().sessionId(), $this.config().isOverwrite() ? "OVERWRITE" : "APPEND") : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).map((Function1 & Serializable & scala.Serializable)_ -> {
                VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$18(_);
                return BoxedUnit.UNIT;
            }));
            return either;
        });
    }

    public static final /* synthetic */ Either $anonfun$doPreWriteSteps$11(VerticaDistributedFilesystemWritePipe $this, boolean tableExistsPre$1, boolean tempTableExists) {
        return (tempTableExists ? package$.MODULE$.Left().apply((Object)new TempTableExistsError()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> (!tableExistsPre$1 && $this.config().createExternalTable().isEmpty() ? $this.tableUtils().createTable($this.config().tablename(), $this.config().targetTableSql(), $this.config().schema(), $this.config().strlen(), $this.config().arrayLength()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.tableUtils().tableExists($this.config().tablename()).flatMap((Function1 & Serializable & scala.Serializable)tableExistsPost -> VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$14($this, BoxesRunTime.unboxToBoolean((Object)tableExistsPost)))));
    }

    public static final /* synthetic */ Either $anonfun$doPreWriteSteps$9(VerticaDistributedFilesystemWritePipe $this, boolean tableExistsPre$1, boolean viewExists) {
        return (viewExists ? package$.MODULE$.Left().apply((Object)new ViewExistsError()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.tableUtils().tempTableExists($this.config().tablename()).flatMap((Function1 & Serializable & scala.Serializable)tempTableExists -> VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$11($this, tableExistsPre$1, BoxesRunTime.unboxToBoolean((Object)tempTableExists))));
    }

    public static final /* synthetic */ Either $anonfun$doPreWriteSteps$6(VerticaDistributedFilesystemWritePipe $this, boolean tableExistsPre) {
        return ($this.config().isOverwrite() && $this.config().mergeKey().isEmpty() && tableExistsPre ? package$.MODULE$.Left().apply((Object)new DropTableError()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> ($this.config().createExternalTable().isDefined() && tableExistsPre ? package$.MODULE$.Left().apply((Object)new CreateExternalTableAlreadyExistsError()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.tableUtils().viewExists($this.config().tablename()).flatMap((Function1 & Serializable & scala.Serializable)viewExists -> VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$9($this, tableExistsPre, BoxesRunTime.unboxToBoolean((Object)viewExists)))));
    }

    public static final /* synthetic */ void $anonfun$performMerge$3(BoxedUnit _) {
    }

    public static final /* synthetic */ Tuple6 $anonfun$testFaultTolerance$4(VerticaDistributedFilesystemWritePipe $this, int rowsCopied$1, int rejectedCount) {
        BoxedUnit boxedUnit;
        BoxedUnit x$12;
        BoxedUnit boxedUnit2;
        double failedRowsPercent = rowsCopied$1 > 0 ? (double)rejectedCount / ((double)rowsCopied$1 + (double)rejectedCount) : 1.0;
        boolean passedFaultToleranceTest = failedRowsPercent <= (double)$this.config().failedRowPercentTolerance();
        String tolerance_message = new StringBuilder(124).append("Number of rows_rejected=").append(rejectedCount).append(". rows_copied=").append(rowsCopied$1).append(". failedRowsPercent=").append(failedRowsPercent).append(". user's failed_rows_percent_tolerance=").append($this.config().failedRowPercentTolerance()).append(". passedFaultToleranceTest=").append(((Object)BoxesRunTime.boxToBoolean((boolean)passedFaultToleranceTest)).toString()).toString();
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Verifying rows saved to Vertica is within user tolerance...");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = x$12 = BoxedUnit.UNIT;
        }
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info(new StringBuilder(0).append(tolerance_message).append((Object)(passedFaultToleranceTest ? "...PASSED.  OK to commit to database." : "...FAILED.  NOT OK to commit to database")).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit x$13 = boxedUnit;
        return new Tuple6((Object)BoxesRunTime.boxToInteger((int)rejectedCount), (Object)BoxesRunTime.boxToDouble((double)failedRowsPercent), (Object)BoxesRunTime.boxToBoolean((boolean)passedFaultToleranceTest), (Object)tolerance_message, (Object)x$12, (Object)x$13);
    }

    public static final /* synthetic */ void $anonfun$testFaultTolerance$10(Tuple3 x$10) {
        Tuple3 tuple3 = x$10;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$commitDataIntoVertica$20(BoxedUnit _) {
    }

    public static final /* synthetic */ Either $anonfun$commitDataIntoVertica$13(VerticaDistributedFilesystemWritePipe $this, String rejectsTableName$1, String columnList$1, int rowsCopied) {
        return $this.testFaultTolerance(rowsCopied, rejectsTableName$1).left().map((Function1 & Serializable & scala.Serializable)err -> new CommitError((ConnectorError)err).context("commit: JDBC Error when trying to determine fault tolerance")).flatMap((Function1 & Serializable & scala.Serializable)faultToleranceResults -> ($this.config().saveJobStatusTable() ? $this.tableUtils().updateJobStatusTable($this.config().tablename(), $this.config().jdbcConfig().auth().user(), faultToleranceResults.failedRowsPercent(), $this.config().sessionId(), faultToleranceResults.success()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable & scala.Serializable)_2 -> (faultToleranceResults.success() ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)new FaultToleranceTestFail())).flatMap((Function1 & Serializable & scala.Serializable)_ -> ($this.config().mergeKey().isDefined() ? package$.MODULE$.Right().apply((Object)$this.buildMergeStatement($this.config().tablename(), columnList$1, $this.tempTableName().getFullTableName())) : package$.MODULE$.Right().apply((Object)"")).map((Function1 & Serializable & scala.Serializable)mergeStatement -> {
            BoxedUnit boxedUnit;
            if ($this.config().mergeKey().isDefined()) {
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info(new StringBuilder(25).append("The merge statement is: \n").append((String)mergeStatement).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$25 = boxedUnit;
            return new Tuple2(mergeStatement, (Object)x$25);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$26 -> {
            Tuple2 tuple2 = x$26;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String mergeStatement = (String)tuple2._1();
            Either either = ($this.config().mergeKey().isDefined() ? $this.performMerge(mergeStatement) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).map((Function1 & Serializable & scala.Serializable)_ -> {
                VerticaDistributedFilesystemWritePipe.$anonfun$commitDataIntoVertica$20(_);
                return BoxedUnit.UNIT;
            });
            return either;
        }))));
    }

    public static final /* synthetic */ Either $anonfun$commitDataIntoVertica$6(VerticaDistributedFilesystemWritePipe $this, String tableName$1, int tableNameMaxLength$1, String sessionId$1, String columnList$1, String url$1, boolean tempTableExists) {
        return ($this.config().mergeKey().isDefined() && !tempTableExists ? package$.MODULE$.Left().apply((Object)new CreateTableError((Option<ConnectorError>)None$.MODULE$)) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).map((Function1 & Serializable & scala.Serializable)x$23 -> {
            String rejectsTableName = new StringBuilder(11).append("\"").append(EscapeUtils$.MODULE$.sqlEscape(tableName$1.substring(0, Math.min(tableNameMaxLength$1, tableName$1.length())), EscapeUtils$.MODULE$.sqlEscape$default$2())).append("_").append(sessionId$1).append("_COMMITS").append("\"").toString();
            return new Tuple2(x$23, (Object)rejectsTableName);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$28 -> {
            Tuple2 tuple2 = x$28;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String rejectsTableName = (String)tuple2._2();
            Either either = ($this.config().mergeKey().isDefined() ? package$.MODULE$.Right().apply((Object)$this.tempTableName().getFullTableName()) : package$.MODULE$.Right().apply((Object)$this.config().tablename().getFullTableName())).map((Function1 & Serializable & scala.Serializable)fullTableName -> {
                BoxedUnit boxedUnit;
                String copyStatement = $this.buildCopyStatement((String)fullTableName, columnList$1, url$1, rejectsTableName, "parquet");
                if ($this.logger().underlying().isInfoEnabled()) {
                    $this.logger().underlying().info(new StringBuilder(24).append("The copy statement is: \n").append(copyStatement).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit x$24 = boxedUnit;
                return new Tuple3(fullTableName, (Object)copyStatement, (Object)x$24);
            }).flatMap((Function1 & Serializable & scala.Serializable)x$27 -> {
                Tuple3 tuple3 = x$27;
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                String copyStatement = (String)tuple3._2();
                Either either = ($this.config().mergeKey().isDefined() ? $this.performCopy(copyStatement, $this.tempTableName()).left().map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.context("commit: Failed to copy rows into temp table")) : $this.performCopy(copyStatement, $this.config().tablename()).left().map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.context("commit: Failed to copy rows into target table"))).flatMap((Function1 & Serializable & scala.Serializable)rowsCopied -> VerticaDistributedFilesystemWritePipe.$anonfun$commitDataIntoVertica$13($this, rejectsTableName, columnList$1, BoxesRunTime.unboxToInt((Object)rowsCopied)));
                return either;
            });
            return either;
        });
    }

    public static final /* synthetic */ void $anonfun$commitDataAsExternalTable$6(BoxedUnit _) {
    }

    public VerticaDistributedFilesystemWritePipe(DistributedFilesystemWriteConfig config, FileStoreLayerInterface fileStoreLayer, JdbcLayerInterface jdbcLayer, SchemaToolsInterface schemaTools, TableUtilsInterface tableUtils, int dataSize) {
        this.config = config;
        this.fileStoreLayer = fileStoreLayer;
        this.jdbcLayer = jdbcLayer;
        this.schemaTools = schemaTools;
        this.tableUtils = tableUtils;
        this.dataSize = dataSize;
        this.logger = LogProvider$.MODULE$.getLogger(VerticaDistributedFilesystemWritePipe.class);
        this.tempTableName = new TableName(new StringBuilder(1).append(config.tablename().name()).append("_").append(config.sessionId()).toString(), (Option<String>)None$.MODULE$);
        this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE = "spark.sql.legacy.parquet.datetimeRebaseModeInWrite";
        this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE = "spark.sql.legacy.parquet.int96RebaseModeInWrite";
        this.timer = new Timer(config.timeOperations(), this.logger(), "Writing Partition.");
    }

    public class FaultToleranceTestResult
    implements Product,
    scala.Serializable {
        private final boolean success;
        private final double failedRowsPercent;
        public final /* synthetic */ VerticaDistributedFilesystemWritePipe $outer;

        public boolean success() {
            return this.success;
        }

        public double failedRowsPercent() {
            return this.failedRowsPercent;
        }

        public FaultToleranceTestResult copy(boolean success, double failedRowsPercent) {
            return new FaultToleranceTestResult(this.com$vertica$spark$datasource$core$VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$$$outer(), success, failedRowsPercent);
        }

        public boolean copy$default$1() {
            return this.success();
        }

        public double copy$default$2() {
            return this.failedRowsPercent();
        }

        public String productPrefix() {
            return "FaultToleranceTestResult";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Comparable<Boolean> comparable;
            int n = x$1;
            switch (n) {
                case 0: {
                    comparable = BoxesRunTime.boxToBoolean((boolean)this.success());
                    break;
                }
                case 1: {
                    comparable = BoxesRunTime.boxToDouble((double)this.failedRowsPercent());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return comparable;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FaultToleranceTestResult;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)(this.success() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.failedRowsPercent()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FaultToleranceTestResult)) return false;
            if (((FaultToleranceTestResult)object).com$vertica$spark$datasource$core$VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$$$outer() != this.com$vertica$spark$datasource$core$VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FaultToleranceTestResult faultToleranceTestResult = (FaultToleranceTestResult)x$1;
            if (this.success() != faultToleranceTestResult.success()) return false;
            if (this.failedRowsPercent() != faultToleranceTestResult.failedRowsPercent()) return false;
            if (!faultToleranceTestResult.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ VerticaDistributedFilesystemWritePipe com$vertica$spark$datasource$core$VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$$$outer() {
            return this.$outer;
        }

        public FaultToleranceTestResult(VerticaDistributedFilesystemWritePipe $outer, boolean success, double failedRowsPercent) {
            this.success = success;
            this.failedRowsPercent = failedRowsPercent;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

