/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.core.factory;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import com.vertica.spark.config.DistributedFilesystemReadConfig;
import com.vertica.spark.config.DistributedFilesystemWriteConfig;
import com.vertica.spark.config.JDBCConfig;
import com.vertica.spark.config.ReadConfig;
import com.vertica.spark.config.WriteConfig;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipe;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipe$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipeLegacy;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipeLegacy$;
import com.vertica.spark.datasource.core.VerticaPipeInterface;
import com.vertica.spark.datasource.core.factory.VerticaPipeFactoryInterface;
import com.vertica.spark.datasource.fs.HadoopFileStoreLayer;
import com.vertica.spark.datasource.fs.HadoopFileStoreLayer$;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.VerticaJdbcLayer;
import com.vertica.spark.util.cleanup.CleanupUtils;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.listeners.SparkContextWrapper;
import com.vertica.spark.util.schema.SchemaTools;
import com.vertica.spark.util.schema.SchemaTools$;
import com.vertica.spark.util.schema.SchemaToolsV10;
import com.vertica.spark.util.table.TableUtils;
import com.vertica.spark.util.version.VerticaVersion;
import com.vertica.spark.util.version.VerticaVersion$;
import com.vertica.spark.util.version.VerticaVersionUtils$;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.StructType;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.util.Either;

public final class VerticaPipeFactory$
implements VerticaPipeFactoryInterface {
    public static VerticaPipeFactory$ MODULE$;
    private final Logger logger;
    private Option<VerticaJdbcLayer> readLayerJdbc;
    private Option<VerticaJdbcLayer> writeLayerJdbc;

    static {
        new VerticaPipeFactory$();
    }

    private Logger logger() {
        return this.logger;
    }

    private Option<VerticaJdbcLayer> readLayerJdbc() {
        return this.readLayerJdbc;
    }

    private void readLayerJdbc_$eq(Option<VerticaJdbcLayer> x$1) {
        this.readLayerJdbc = x$1;
    }

    private Option<VerticaJdbcLayer> writeLayerJdbc() {
        return this.writeLayerJdbc;
    }

    private void writeLayerJdbc_$eq(Option<VerticaJdbcLayer> x$1) {
        this.writeLayerJdbc = x$1;
    }

    private Option<VerticaJdbcLayer> checkJdbcLayer(Option<VerticaJdbcLayer> jdbcLayer, JDBCConfig jdbcConfig) {
        Some some;
        Some some2 = jdbcLayer;
        if (some2 instanceof Some) {
            Some some3 = some2;
            VerticaJdbcLayer layer = (VerticaJdbcLayer)some3.value();
            some = layer.isClosed() ? new Some((Object)new VerticaJdbcLayer(jdbcConfig)) : jdbcLayer;
        } else if (None$.MODULE$.equals(some2)) {
            some = new Some((Object)new VerticaJdbcLayer(jdbcConfig));
        } else {
            throw new MatchError(some2);
        }
        return some;
    }

    private void closeJdbcLayer(Option<VerticaJdbcLayer> jdbcLayer) {
        Option<VerticaJdbcLayer> option = jdbcLayer;
        if (option instanceof Some) {
            Some some = (Some)option;
            VerticaJdbcLayer layer = (VerticaJdbcLayer)some.value();
            Either<ConnectorError, BoxedUnit> either = layer.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public VerticaPipeInterface getReadPipe(ReadConfig config, boolean getVersion) {
        None$ none$;
        BoxedUnit boxedUnit;
        String thread = new StringBuilder(2).append(Thread.currentThread().getName()).append(": ").toString();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(17).append(thread).append("Getting read pipe").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ReadConfig readConfig = config;
        if (!(readConfig instanceof DistributedFilesystemReadConfig)) throw new MatchError((Object)readConfig);
        DistributedFilesystemReadConfig distributedFilesystemReadConfig = (DistributedFilesystemReadConfig)readConfig;
        HadoopFileStoreLayer hadoopFileStoreLayer = HadoopFileStoreLayer$.MODULE$.make(distributedFilesystemReadConfig);
        this.readLayerJdbc_$eq(this.checkJdbcLayer(this.readLayerJdbc(), distributedFilesystemReadConfig.jdbcConfig()));
        Option option = SparkSession$.MODULE$.getActiveSession();
        if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            if (!(option instanceof Some)) throw new MatchError((Object)option);
            Some some = (Some)option;
            SparkSession session = (SparkSession)some.value();
            none$ = new Some((Object)session.sparkContext());
        }
        None$ sparkContext = none$;
        VerticaVersion verticaVersion = getVersion ? VerticaVersionUtils$.MODULE$.getVersion((JdbcLayerInterface)this.readLayerJdbc().get()) : new VerticaVersion(0, VerticaVersion$.MODULE$.apply$default$2(), VerticaVersion$.MODULE$.apply$default$3(), VerticaVersion$.MODULE$.apply$default$4());
        SchemaTools schemaTools = verticaVersion.major() == 10 ? new SchemaToolsV10() : new SchemaTools(SchemaTools$.MODULE$.$lessinit$greater$default$1());
        return new VerticaDistributedFilesystemReadPipe(distributedFilesystemReadConfig, hadoopFileStoreLayer, (JdbcLayerInterface)this.readLayerJdbc().get(), schemaTools, new CleanupUtils(), new SparkContextWrapper((Option<SparkContext>)sparkContext), VerticaDistributedFilesystemReadPipe$.MODULE$.$lessinit$greater$default$7());
    }

    @Override
    public VerticaPipeInterface getWritePipe(WriteConfig config, boolean getVersion) {
        BoxedUnit boxedUnit;
        String thread = new StringBuilder(2).append(Thread.currentThread().getName()).append(": ").toString();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(18).append(thread).append("Getting write pipe").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        WriteConfig writeConfig = config;
        if (!(writeConfig instanceof DistributedFilesystemWriteConfig)) {
            throw new MatchError((Object)writeConfig);
        }
        DistributedFilesystemWriteConfig distributedFilesystemWriteConfig = (DistributedFilesystemWriteConfig)writeConfig;
        this.writeLayerJdbc_$eq(this.checkJdbcLayer(this.writeLayerJdbc(), distributedFilesystemWriteConfig.jdbcConfig()));
        VerticaJdbcLayer jdbcLayer = (VerticaJdbcLayer)this.writeLayerJdbc().get();
        VerticaVersion verticaVersion = getVersion ? VerticaVersionUtils$.MODULE$.getVersion(jdbcLayer) : new VerticaVersion(0, VerticaVersion$.MODULE$.apply$default$2(), VerticaVersion$.MODULE$.apply$default$3(), VerticaVersion$.MODULE$.apply$default$4());
        SchemaTools schemaTools = verticaVersion.major() == 10 ? new SchemaToolsV10() : new SchemaTools(SchemaTools$.MODULE$.$lessinit$greater$default$1());
        VerticaDistributedFilesystemWritePipe verticaDistributedFilesystemWritePipe = verticaVersion.largerOrEqual(new VerticaVersion(11, 1, 1, VerticaVersion$.MODULE$.apply$default$4())) ? new VerticaDistributedFilesystemWritePipe(distributedFilesystemWriteConfig, new HadoopFileStoreLayer(distributedFilesystemWriteConfig.fileStoreConfig(), (Option<StructType>)new Some((Object)distributedFilesystemWriteConfig.schema())), jdbcLayer, schemaTools, new TableUtils(schemaTools, jdbcLayer), VerticaDistributedFilesystemWritePipe$.MODULE$.$lessinit$greater$default$6()) : new VerticaDistributedFilesystemWritePipeLegacy(distributedFilesystemWriteConfig, new HadoopFileStoreLayer(distributedFilesystemWriteConfig.fileStoreConfig(), (Option<StructType>)new Some((Object)distributedFilesystemWriteConfig.schema())), jdbcLayer, schemaTools, new TableUtils(schemaTools, jdbcLayer), VerticaDistributedFilesystemWritePipeLegacy$.MODULE$.$lessinit$greater$default$6());
        return verticaDistributedFilesystemWritePipe;
    }

    @Override
    public void closeJdbcLayers() {
        this.closeJdbcLayer(this.readLayerJdbc());
        this.closeJdbcLayer(this.writeLayerJdbc());
    }

    private VerticaPipeFactory$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(this.getClass().getName());
        this.readLayerJdbc = None$.MODULE$;
        this.writeLayerJdbc = None$.MODULE$;
    }
}

