/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.fs;

import cats.Applicative;
import cats.implicits$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.AWSAuth;
import com.vertica.spark.config.AWSOptions;
import com.vertica.spark.config.DistributedFilesystemReadConfig;
import com.vertica.spark.config.FileStoreConfig;
import com.vertica.spark.config.GCSOptions;
import com.vertica.spark.config.GCSServiceAuth;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.SensitiveArg;
import com.vertica.spark.datasource.core.DataBlock;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.fs.GCSSparkOptions$;
import com.vertica.spark.datasource.fs.HadoopFileStoreLayer$;
import com.vertica.spark.datasource.fs.HadoopFileStoreReader;
import com.vertica.spark.datasource.fs.ParquetFileMetadata;
import com.vertica.spark.datasource.partitions.parquet.ParquetFileRange;
import com.vertica.spark.util.error.CloseWriteError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.CreateDirectoryAlreadyExistsError;
import com.vertica.spark.util.error.CreateDirectoryError;
import com.vertica.spark.util.error.CreateFileAlreadyExistsError;
import com.vertica.spark.util.error.CreateFileError;
import com.vertica.spark.util.error.FileListError;
import com.vertica.spark.util.error.FileStoreThrownError;
import com.vertica.spark.util.error.IntermediaryStoreReaderNotInitializedError;
import com.vertica.spark.util.error.IntermediaryStoreWriteError;
import com.vertica.spark.util.error.IntermediaryStoreWriterNotInitializedError;
import com.vertica.spark.util.error.MissingHDFSImpersonationTokenError;
import com.vertica.spark.util.error.OpenReadError;
import com.vertica.spark.util.error.OpenWriteError;
import com.vertica.spark.util.error.RemoveDirectoryError;
import com.vertica.spark.util.error.RemoveFileError;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.vertica.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.vertica.ParquetReadSupport$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\rEt!\u0002%J\u0011\u0003!f!\u0002,J\u0011\u00039\u0006\"\u00020\u0002\t\u0003y\u0006\"\u00021\u0002\t\u0003\tg\u0001\u0002,J\u0001\rD\u0001b\u001a\u0003\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\t]\u0012\u0011\t\u0011)A\u0005_\")a\f\u0002C\u0001\u007f\"I\u0011Q\u0001\u0003C\u0002\u0013%\u0011q\u0001\u0005\t\u0003?!\u0001\u0015!\u0003\u0002\n!I\u0011\u0011\u0005\u0003C\u0002\u0013%\u0011q\u0001\u0005\t\u0003G!\u0001\u0015!\u0003\u0002\n!I\u0011Q\u0005\u0003C\u0002\u0013%\u0011q\u0001\u0005\t\u0003O!\u0001\u0015!\u0003\u0002\n!I\u0011\u0011\u0006\u0003C\u0002\u0013%\u0011q\u0001\u0005\t\u0003W!\u0001\u0015!\u0003\u0002\n!I\u0011Q\u0006\u0003C\u0002\u0013%\u0011q\u0001\u0005\t\u0003_!\u0001\u0015!\u0003\u0002\n!I\u0011\u0011\u0007\u0003C\u0002\u0013%\u0011q\u0001\u0005\t\u0003g!\u0001\u0015!\u0003\u0002\n!I\u0011Q\u0007\u0003C\u0002\u0013%\u0011q\u0001\u0005\t\u0003o!\u0001\u0015!\u0003\u0002\n!I\u0011\u0011\b\u0003C\u0002\u0013\u0005\u00111\b\u0005\t\u0003\u001b\"\u0001\u0015!\u0003\u0002>!I\u0011q\n\u0003C\u0002\u0013%\u0011\u0011\u000b\u0005\t\u0003G\"\u0001\u0015!\u0003\u0002T!I\u0011Q\r\u0003C\u0002\u0013%\u0011\u0011\u000b\u0005\t\u0003O\"\u0001\u0015!\u0003\u0002T!I\u0011\u0011\u000e\u0003C\u0002\u0013%\u0011\u0011\u000b\u0005\t\u0003W\"\u0001\u0015!\u0003\u0002T!I\u0011Q\u000e\u0003C\u0002\u0013%\u0011q\u000e\u0005\t\u0003\u007f\"\u0001\u0015!\u0003\u0002r!I\u0011\u0011\u0011\u0003C\u0002\u0013%\u0011q\u000e\u0005\t\u0003\u0007#\u0001\u0015!\u0003\u0002r!I\u0011Q\u0011\u0003C\u0002\u0013%\u0011q\u000e\u0005\t\u0003\u000f#\u0001\u0015!\u0003\u0002r!I\u0011\u0011\u0012\u0003A\u0002\u0013%\u00111\u0012\u0005\n\u0003S#\u0001\u0019!C\u0005\u0003WC\u0001\"a.\u0005A\u0003&\u0011Q\u0012\u0005\n\u0003s#\u0001\u0019!C\u0005\u0003wC\u0011\"!2\u0005\u0001\u0004%I!a2\t\u0011\u0005-G\u0001)Q\u0005\u0003{C\u0011\"!4\u0005\u0005\u0004%\t!a4\t\u0011\u0005uG\u0001)A\u0005\u0003#D\u0011\"a8\u0005\u0005\u0004%I!!9\t\u0011\u0005%H\u0001)A\u0005\u0003GD\u0011\"a;\u0005\u0005\u0004%I!!<\t\u0011\u0005UH\u0001)A\u0005\u0003_4a!a>\u0005\t\u0005e\bB\u0003B\u0007a\t\u0005\t\u0015!\u0003\u0003\u0010!1a\f\rC\u0001\u00053AqA!\b1\t#\u0012y\u0002C\u0004\u0003\"A\"\tBa\t\t\u000f\teB\u0001\"\u0001\u0003<!9!1\u000e\u0003\u0005B\t5\u0004b\u0002B@\t\u0011\u0005#\u0011\u0011\u0005\b\u0005\u0007#A\u0011\u0002BC\u0011\u001d\u0011Y\f\u0002C!\u0005{CqA!3\u0005\t\u0003\u0012Y\rC\u0004\u0003^\u0012!\tEa8\t\u000f\t5H\u0001\"\u0011\u0003\u0002\"9!q\u001e\u0003\u0005B\tE\bbBB\u0005\t\u0011\u000531\u0002\u0005\b\u0007\u001f!A\u0011IB\t\u0011\u001d\u0019)\u0002\u0002C!\u0007/Aqaa\u0007\u0005\t\u0003\u001ai\u0002C\u0004\u0004&\u0011!\taa\n\t\u000f\rMB\u0001\"\u0011\u00046!91Q\b\u0003\u0005B\r}\u0002bBB#\t\u0011\u0005\u0013\u0011\u001d\u0005\b\u0007\u000f\"A\u0011IAw\u0011\u001d\u0019I\u0005\u0002C\u0005\u0007\u0017\nA\u0003S1e_>\u0004h)\u001b7f'R|'/\u001a'bs\u0016\u0014(B\u0001&L\u0003\t17O\u0003\u0002M\u001b\u0006QA-\u0019;bg>,(oY3\u000b\u00059{\u0015!B:qCJ\\'B\u0001)R\u0003\u001d1XM\u001d;jG\u0006T\u0011AU\u0001\u0004G>l7\u0001\u0001\t\u0003+\u0006i\u0011!\u0013\u0002\u0015\u0011\u0006$wn\u001c9GS2,7\u000b^8sK2\u000b\u00170\u001a:\u0014\u0005\u0005A\u0006CA-]\u001b\u0005Q&\"A.\u0002\u000bM\u001c\u0017\r\\1\n\u0005uS&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002)\u0006!Q.Y6f)\r\u00117\u0011\u000e\t\u0003+\u0012\u00192\u0001\u0002-e!\t)V-\u0003\u0002g\u0013\n9b)\u001b7f'R|'/\u001a'bs\u0016\u0014\u0018J\u001c;fe\u001a\f7-Z\u0001\u0010M&dWm\u0015;pe\u0016\u001cuN\u001c4jOB\u0011\u0011\u000e\\\u0007\u0002U*\u00111.T\u0001\u0007G>tg-[4\n\u00055T'a\u0004$jY\u0016\u001cFo\u001c:f\u0007>tg-[4\u0002\rM\u001c\u0007.Z7b!\rI\u0006O]\u0005\u0003cj\u0013aa\u00149uS>t\u0007CA:~\u001b\u0005!(BA;w\u0003\u0015!\u0018\u0010]3t\u0015\t9\b0A\u0002tc2T!AT=\u000b\u0005i\\\u0018AB1qC\u000eDWMC\u0001}\u0003\ry'oZ\u0005\u0003}R\u0014!b\u0015;sk\u000e$H+\u001f9f)\u0015\u0011\u0017\u0011AA\u0002\u0011\u00159w\u00011\u0001i\u0011\u0015qw\u00011\u0001p\u00035\u00196gX!D\u0007\u0016\u001b6kX&F3V\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\tIB\u0004\u0003\u0002\u000e\u0005U\u0001cAA\b56\u0011\u0011\u0011\u0003\u0006\u0004\u0003'\u0019\u0016A\u0002\u001fs_>$h(C\u0002\u0002\u0018i\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u000e\u0003;\u0011aa\u0015;sS:<'bAA\f5\u0006q1kM0B\u0007\u000e+5kU0L\u000bf\u0003\u0013!D*4?N+5IU#U?.+\u0015,\u0001\bTg}\u001bVi\u0011*F)~[U)\u0017\u0011\u0002!M\u001btlU#T'&{ej\u0018+P\u0017\u0016s\u0015!E*4?N+5kU%P\u001d~#vjS#OA\u0005A\u0012iV*`\u0007J+E)\u0012(U\u0013\u0006c5k\u0018)S\u001fZKE)\u0012*\u00023\u0005;6kX\"S\u000b\u0012+e\nV%B\u0019N{\u0006KU(W\u0013\u0012+%\u000bI\u0001\f'NzVI\u0014#Q\u001f&sE+\u0001\u0007Tg}+e\n\u0012)P\u0013:#\u0006%A\u0007Tg}+e*\u0011\"M\u000b~\u001b6\u000bT\u0001\u000f'NzVIT!C\u0019\u0016{6k\u0015'!\u0003Q\u00196gX#O\u0003\ncUi\u0018)B)\"{6\u000bV-M\u000b\u0006)2kM0F\u001d\u0006\u0013E*R0Q\u0003RCul\u0015+Z\u0019\u0016\u0003\u0013A\u00027pO\u001e,'/\u0006\u0002\u0002>A!\u0011qHA%\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013\u0001D:dC2\fGn\\4hS:<'bAA$#\u0006AA/\u001f9fg\u00064W-\u0003\u0003\u0002L\u0005\u0005#A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002;]+%\t\u0013#G'~#U\tT#H\u0003RKuJT0U\u001f.+ej\u0018+F1R+\"!a\u0015\u0011\t\u0005U\u0013qL\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005\u0011\u0011n\u001c\u0006\u0004\u0003;J\u0018A\u00025bI>|\u0007/\u0003\u0003\u0002b\u0005]#\u0001\u0002+fqR\fadV#C\u0011\u001235k\u0018#F\u0019\u0016;\u0015\tV%P\u001d~#vjS#O?R+\u0005\f\u0016\u0011\u0002=M;VI\u0011%E\rN{F)\u0012'F\u000f\u0006#\u0016j\u0014(`)>[UIT0U\u000bb#\u0016aH*X\u000b\nCEIR*`\t\u0016cUiR!U\u0013>su\fV(L\u000b:{F+\u0012-UA\u0005Q\u0002\n\u0012$T?\u0012+E*R$B)&{ej\u0018+P\u0017\u0016su\fV#Y)\u0006Y\u0002\n\u0012$T?\u0012+E*R$B)&{ej\u0018+P\u0017\u0016su\fV#Y)\u0002\n1\u0005T#H\u0003\u000eKv\fU!S#V+Ek\u0018*F\u0005\u0006\u001bViX'P\t\u0016{\u0016JT0X%&#V)\u0006\u0002\u0002rA!\u00111OA?\u001b\t\t)H\u0003\u0003\u0002x\u0005e\u0014\u0001\u00027b]\u001eT!!a\u001f\u0002\t)\fg/Y\u0005\u0005\u00037\t)(\u0001\u0013M\u000b\u001e\u000b5)W0Q\u0003J\u000bV+\u0012+`%\u0016\u0013\u0015iU#`\u001b>#UiX%O?^\u0013\u0016\nV#!\u0003\tbUiR!D3~\u0003\u0016IU)V\u000bR{&+\u0012\"B'\u0016{Vj\u0014#F?&suLU#B\t\u0006\u0019C*R$B\u0007f{\u0006+\u0011*R+\u0016#vLU#C\u0003N+u,T(E\u000b~Kej\u0018*F\u0003\u0012\u0003\u0013!\u000b'F\u000f\u0006\u001b\u0015l\u0018)B%F+V\tV0J\u001dRKdg\u0018*F\u0005\u0006\u001bViX'P\t\u0016{\u0016JT0X%&#V)\u0001\u0016M\u000b\u001e\u000b5)W0Q\u0003J\u000bV+\u0012+`\u0013:#\u0016HN0S\u000b\n\u000b5+R0N\u001f\u0012+u,\u0013(`/JKE+\u0012\u0011\u0002\r]\u0014\u0018\u000e^3s+\t\ti\t\u0005\u0003Za\u0006=\u0005CBAI\u00033\u000bi*\u0004\u0002\u0002\u0014*!\u0011QLAK\u0015\r\t9*_\u0001\ba\u0006\u0014\u0018/^3u\u0013\u0011\tY*a%\u0003\u001bA\u000b'/];fi^\u0013\u0018\u000e^3s!\u0011\ty*!*\u000e\u0005\u0005\u0005&bAARm\u0006A1-\u0019;bYf\u001cH/\u0003\u0003\u0002(\u0006\u0005&aC%oi\u0016\u0014h.\u00197S_^\f!b\u001e:ji\u0016\u0014x\fJ3r)\u0011\ti+a-\u0011\u0007e\u000by+C\u0002\u00022j\u0013A!\u00168ji\"I\u0011QW\u0013\u0002\u0002\u0003\u0007\u0011QR\u0001\u0004q\u0012\n\u0014aB<sSR,'\u000fI\u0001\u0007e\u0016\fG-\u001a:\u0016\u0005\u0005u\u0006\u0003B-q\u0003\u007f\u00032!VAa\u0013\r\t\u0019-\u0013\u0002\u0016\u0011\u0006$wn\u001c9GS2,7\u000b^8sKJ+\u0017\rZ3s\u0003)\u0011X-\u00193fe~#S-\u001d\u000b\u0005\u0003[\u000bI\rC\u0005\u00026\"\n\t\u00111\u0001\u0002>\u00069!/Z1eKJ\u0004\u0013A\u00035eMN\u001cuN\u001c4jOV\u0011\u0011\u0011\u001b\t\u0005\u0003'\fI.\u0004\u0002\u0002V*!\u0011q[A.\u0003\u0011\u0019wN\u001c4\n\t\u0005m\u0017Q\u001b\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0017!$gm]\"p]\u001aLw\rI\u0001\u000bC^\u001cx\n\u001d;j_:\u001cXCAAr!\rI\u0017Q]\u0005\u0004\u0003OT'AC!X'>\u0003H/[8og\u0006Y\u0011m^:PaRLwN\\:!\u0003)97m](qi&|gn]\u000b\u0003\u0003_\u00042![Ay\u0013\r\t\u0019P\u001b\u0002\u000b\u000f\u000e\u001bv\n\u001d;j_:\u001c\u0018aC4dg>\u0003H/[8og\u0002\u0012QCV3si&\u001c\u0017\rU1scV,GOQ;jY\u0012,'oE\u00021\u0003w\u0004\u0002\"!@\u0003\u0004\u0005u%\u0011\u0002\b\u0005\u0003#\u000by0\u0003\u0003\u0003\u0002\u0005M\u0015!\u0004)beF,X\r^,sSR,'/\u0003\u0003\u0003\u0006\t\u001d!a\u0002\"vS2$WM\u001d\u0006\u0005\u0005\u0003\t\u0019\nE\u0002\u0003\fAj\u0011\u0001B\u0001\u0005M&dW\r\u0005\u0003\u0003\u0012\tUQB\u0001B\n\u0015\rQ\u00151L\u0005\u0005\u0005/\u0011\u0019B\u0001\u0003QCRDG\u0003\u0002B\u0005\u00057AqA!\u00043\u0001\u0004\u0011y!\u0001\u0003tK24GC\u0001B\u0005\u0003=9W\r^,sSR,7+\u001e9q_J$H\u0003\u0002B\u0013\u0005o\u0001BAa\n\u000345\u0011!\u0011\u0006\u0006\u0005\u0003/\u0013YC\u0003\u0003\u0003.\t=\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT1A!\rw\u0003%)\u00070Z2vi&|g.\u0003\u0003\u00036\t%\"a\u0005)beF,X\r^,sSR,7+\u001e9q_J$\bbBAli\u0001\u0007\u0011\u0011[\u0001\u0015_B,gn\u0016:ji\u0016\u0004\u0016M]9vKR4\u0015\u000e\\3\u0015\t\tu\"q\r\t\u0007\u0005\u007f\u0011\t'!,\u000f\t\t\u0005#1\f\b\u0005\u0005\u0007\u0012)F\u0004\u0003\u0003F\tEc\u0002\u0002B$\u0005\u001frAA!\u0013\u0003N9!\u0011q\u0002B&\u0013\u0005\u0011\u0016B\u0001)R\u0013\tqu*C\u0002\u0003T5\u000bA!\u001e;jY&!!q\u000bB-\u0003\u0015)'O]8s\u0015\r\u0011\u0019&T\u0005\u0005\u0005;\u0012y&A\u0007FeJ|'\u000fS1oI2Lgn\u001a\u0006\u0005\u0005/\u0012I&\u0003\u0003\u0003d\t\u0015$aD\"p]:,7\r^8s%\u0016\u001cX\u000f\u001c;\u000b\t\tu#q\f\u0005\b\u0005S*\u0004\u0019AA\u0005\u0003!1\u0017\u000e\\3oC6,\u0017AF<sSR,G)\u0019;b)>\u0004\u0016M]9vKR4\u0015\u000e\\3\u0015\t\tu\"q\u000e\u0005\b\u0005c2\u0004\u0019\u0001B:\u0003%!\u0017\r^1CY>\u001c7\u000e\u0005\u0003\u0003v\tmTB\u0001B<\u0015\r\u0011IhS\u0001\u0005G>\u0014X-\u0003\u0003\u0003~\t]$!\u0003#bi\u0006\u0014En\\2l\u0003U\u0019Gn\\:f/JLG/\u001a)beF,X\r\u001e$jY\u0016$\"A!\u0010\u0002\u001bQ|7+\u001a;Nk2$\u0018.T1q+\u0019\u00119Ia&\u00032R!!\u0011\u0012B[!!\u0011YIa$\u0003\u0014\n%VB\u0001BG\u0015\u0011\u0011\u0019&!\u001f\n\t\tE%Q\u0012\u0002\u0004\u001b\u0006\u0004\b\u0003\u0002BK\u0005/c\u0001\u0001B\u0004\u0003\u001ab\u0012\rAa'\u0003\u0003-\u000bBA!(\u0003$B\u0019\u0011La(\n\u0007\t\u0005&LA\u0004O_RD\u0017N\\4\u0011\u0007e\u0013)+C\u0002\u0003(j\u00131!\u00118z!\u0019\u0011YIa+\u00030&!!Q\u0016BG\u0005\r\u0019V\r\u001e\t\u0005\u0005+\u0013\t\fB\u0004\u00034b\u0012\rAa'\u0003\u0003YCqAa.9\u0001\u0004\u0011I,A\u0002nCB\u0004\u0002Ba#\u0003\u0010\nM%qV\u0001\u0017O\u0016$\b+\u0019:rk\u0016$h)\u001b7f\u001b\u0016$\u0018\rZ1uCR!!q\u0018Bd!\u0019\u0011yD!\u0019\u0003BB\u0019QKa1\n\u0007\t\u0015\u0017JA\nQCJ\fX/\u001a;GS2,W*\u001a;bI\u0006$\u0018\rC\u0004\u0003je\u0002\r!!\u0003\u0002'=\u0004XM\u001c*fC\u0012\u0004\u0016M]9vKR4\u0015\u000e\\3\u0015\t\tu\"Q\u001a\u0005\b\u0005\u001bQ\u0004\u0019\u0001Bh!\u0011\u0011\tN!7\u000e\u0005\tM'\u0002BAL\u0005+T1Aa6L\u0003)\u0001\u0018M\u001d;ji&|gn]\u0005\u0005\u00057\u0014\u0019N\u0001\tQCJ\fX/\u001a;GS2,'+\u00198hK\u00069\"/Z1e\t\u0006$\u0018M\u0012:p[B\u000b'/];fi\u001aKG.\u001a\u000b\u0005\u0005C\u0014\u0019\u000f\u0005\u0004\u0003@\t\u0005$1\u000f\u0005\b\u0005K\\\u0004\u0019\u0001Bt\u0003%\u0011Gn\\2l'&TX\rE\u0002Z\u0005SL1Aa;[\u0005\rIe\u000e^\u0001\u0015G2|7/\u001a*fC\u0012\u0004\u0016M]9vKR4\u0015\u000e\\3\u0002\u0017\u001d,GOR5mK2K7\u000f\u001e\u000b\u0005\u0005g\u001c9\u0001\u0005\u0004\u0003@\t\u0005$Q\u001f\t\u0007\u0005o\u001c\t!!\u0003\u000f\t\te(Q \b\u0005\u0003\u001f\u0011Y0C\u0001\\\u0013\r\u0011yPW\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0019\u0019a!\u0002\u0003\u0007M+\u0017OC\u0002\u0003\u0000jCqA!\u001b>\u0001\u0004\tI!\u0001\u0006sK6|g/\u001a$jY\u0016$BA!\u0010\u0004\u000e!9!\u0011\u000e A\u0002\u0005%\u0011!\u0003:f[>4X\rR5s)\u0011\u0011ida\u0005\t\u000f\t%t\b1\u0001\u0002\n\u0005Q1M]3bi\u00164\u0015\u000e\\3\u0015\t\tu2\u0011\u0004\u0005\b\u0005S\u0002\u0005\u0019AA\u0005\u0003%\u0019'/Z1uK\u0012K'\u000f\u0006\u0004\u0003>\r}1\u0011\u0005\u0005\b\u0005S\n\u0005\u0019AA\u0005\u0011\u001d\u0019\u0019#\u0011a\u0001\u0003\u0013\t!\u0002]3s[&\u001c8/[8o\u0003)1\u0017\u000e\\3Fq&\u001cHo\u001d\u000b\u0005\u0007S\u0019\t\u0004\u0005\u0004\u0003@\t\u000541\u0006\t\u00043\u000e5\u0012bAB\u00185\n9!i\\8mK\u0006t\u0007b\u0002B5\u0005\u0002\u0007\u0011\u0011B\u0001\u0016O\u0016$\u0018*\u001c9feN|g.\u0019;j_:$vn[3o)\u0011\u00199d!\u000f\u0011\r\t}\"\u0011MA\u0005\u0011\u001d\u0019Yd\u0011a\u0001\u0003\u0013\tA!^:fe\u0006iq-\u001a;HY>\u00147\u000b^1ukN$BAa=\u0004B!911\t#A\u0002\u0005%\u0011a\u00029biR,'O\\\u0001\u000eO\u0016$\u0018iV*PaRLwN\\:\u0002\u001b\u001d,GoR\"T\u001fB$\u0018n\u001c8t\u00035)8/\u001a$jY\u0016\u001c\u0016p\u001d;f[V!1QJB*)\u0019\u0019yea\u0016\u0004ZA1!q\bB1\u0007#\u0002BA!&\u0004T\u001191QK$C\u0002\tm%!\u0001+\t\u000f\t%t\t1\u0001\u0002\n!911L$A\u0002\ru\u0013\u0001\u00034t\u0003\u000e$\u0018n\u001c8\u0011\u0013e\u001byfa\u0019\u0003\u0010\r=\u0013bAB15\nIa)\u001e8di&|gN\r\t\u0005\u0005#\u0019)'\u0003\u0003\u0004h\tM!A\u0003$jY\u0016\u001c\u0016p\u001d;f[\"11n\u0001a\u0001\u0007W\u00022![B7\u0013\r\u0019yG\u001b\u0002 \t&\u001cHO]5ckR,GMR5mKNL8\u000f^3n%\u0016\fGmQ8oM&<\u0007")
public class HadoopFileStoreLayer
implements FileStoreLayerInterface {
    private final FileStoreConfig fileStoreConfig;
    private final String S3_ACCESS_KEY;
    private final String S3_SECRET_KEY;
    private final String S3_SESSION_TOKEN;
    private final String AWS_CREDENTIALS_PROVIDER;
    private final String S3_ENDPOINT;
    private final String S3_ENABLE_SSL;
    private final String S3_ENABLE_PATH_STYLE;
    private final Logger logger;
    private final Text WEBHDFS_DELEGATION_TOKEN_TEXT;
    private final Text SWEBHDFS_DELEGATION_TOKEN_TEXT;
    private final Text HDFS_DELEGATION_TOKEN_TEXT;
    private final String LEGACY_PARQUET_REBASE_MODE_IN_WRITE;
    private final String LEGACY_PARQUET_REBASE_MODE_IN_READ;
    private final String LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE;
    private Option<ParquetWriter<InternalRow>> writer;
    private Option<HadoopFileStoreReader> reader;
    private final Configuration hdfsConfig;
    private final AWSOptions awsOptions;
    private final GCSOptions gcsOptions;

    public static HadoopFileStoreLayer make(DistributedFilesystemReadConfig distributedFilesystemReadConfig) {
        return HadoopFileStoreLayer$.MODULE$.make(distributedFilesystemReadConfig);
    }

    private String S3_ACCESS_KEY() {
        return this.S3_ACCESS_KEY;
    }

    private String S3_SECRET_KEY() {
        return this.S3_SECRET_KEY;
    }

    private String S3_SESSION_TOKEN() {
        return this.S3_SESSION_TOKEN;
    }

    private String AWS_CREDENTIALS_PROVIDER() {
        return this.AWS_CREDENTIALS_PROVIDER;
    }

    private String S3_ENDPOINT() {
        return this.S3_ENDPOINT;
    }

    private String S3_ENABLE_SSL() {
        return this.S3_ENABLE_SSL;
    }

    private String S3_ENABLE_PATH_STYLE() {
        return this.S3_ENABLE_PATH_STYLE;
    }

    public Logger logger() {
        return this.logger;
    }

    private Text WEBHDFS_DELEGATION_TOKEN_TEXT() {
        return this.WEBHDFS_DELEGATION_TOKEN_TEXT;
    }

    private Text SWEBHDFS_DELEGATION_TOKEN_TEXT() {
        return this.SWEBHDFS_DELEGATION_TOKEN_TEXT;
    }

    private Text HDFS_DELEGATION_TOKEN_TEXT() {
        return this.HDFS_DELEGATION_TOKEN_TEXT;
    }

    private String LEGACY_PARQUET_REBASE_MODE_IN_WRITE() {
        return this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE;
    }

    private String LEGACY_PARQUET_REBASE_MODE_IN_READ() {
        return this.LEGACY_PARQUET_REBASE_MODE_IN_READ;
    }

    private String LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE() {
        return this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE;
    }

    private Option<ParquetWriter<InternalRow>> writer() {
        return this.writer;
    }

    private void writer_$eq(Option<ParquetWriter<InternalRow>> x$1) {
        this.writer = x$1;
    }

    private Option<HadoopFileStoreReader> reader() {
        return this.reader;
    }

    private void reader_$eq(Option<HadoopFileStoreReader> x$1) {
        this.reader = x$1;
    }

    public Configuration hdfsConfig() {
        return this.hdfsConfig;
    }

    private AWSOptions awsOptions() {
        return this.awsOptions;
    }

    private GCSOptions gcsOptions() {
        return this.gcsOptions;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> openWriteParquetFile(String filename) {
        Left left;
        Either writerOrError;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(23).append("Opening write to file: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        VerticaParquetBuilder builder = new VerticaParquetBuilder(new Path(String.valueOf(filename)));
        Either either = writerOrError = this.removeFile(filename).flatMap((Function1 & Serializable & scala.Serializable)_ -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> builder.withConf(this.hdfsConfig()).withWriteMode(ParquetFileWriter.Mode.OVERWRITE).withCompressionCodec(CompressionCodecName.SNAPPY).build()).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new OpenWriteError((Throwable)exception).context("Error opening write to HDFS.")).map((Function1 & Serializable & scala.Serializable)writer -> writer));
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            ParquetWriter writer = (ParquetWriter)right.value();
            this.writer_$eq((Option<ParquetWriter<InternalRow>>)new Some((Object)writer));
            left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> writeDataToParquetFile(DataBlock dataBlock) {
        Right right;
        Option<ParquetWriter<InternalRow>> option = this.writer();
        if (option instanceof Some) {
            Some some = (Some)option;
            ParquetWriter reader = (ParquetWriter)some.value();
            right = package$.MODULE$.Right().apply((Object)reader);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreWriterNotInitializedError().context("Error writing parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return right.flatMap((Function1 & Serializable & scala.Serializable)writer -> ((Either)implicits$.MODULE$.toTraverseOps(dataBlock.data(), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)record -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writer.write(record)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new IntermediaryStoreWriteError((Throwable)exception).context("Error writing parquet file to HDFS.")), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable & scala.Serializable)_ -> {
            HadoopFileStoreLayer.$anonfun$writeDataToParquetFile$5(_);
            return BoxedUnit.UNIT;
        }));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> closeWriteParquetFile() {
        Right right;
        Option<ParquetWriter<InternalRow>> option = this.writer();
        if (option instanceof Some) {
            Some some = (Some)option;
            ParquetWriter reader = (ParquetWriter)some.value();
            right = package$.MODULE$.Right().apply((Object)reader);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreWriterNotInitializedError().context("Error closing write of parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return right.flatMap((Function1 & Serializable & scala.Serializable)writer -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writer.close()).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new CloseWriteError((Throwable)exception).context("Error closing write of parquet file to HDFS.")).map((Function1 & Serializable & scala.Serializable)_ -> {
            HadoopFileStoreLayer.$anonfun$closeWriteParquetFile$4(_);
            return BoxedUnit.UNIT;
        }));
    }

    private <K, V> Map<K, Set<V>> toSetMultiMap(Map<K, V> map) {
        HashMap setMultiMap = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(map.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> setMultiMap.put(entry.getKey(), Collections.singleton(entry.getValue())));
        return Collections.unmodifiableMap(setMultiMap);
    }

    @Override
    public Either<ConnectorError, ParquetFileMetadata> getParquetFileMetadata(String filename) {
        Path path = new Path(String.valueOf(filename));
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)path, (Configuration)this.hdfsConfig());
            ParquetFileReader reader = ParquetFileReader.open((InputFile)inputFile);
            int rowGroupCount = reader.getRowGroups().size();
            reader.close();
            return new ParquetFileMetadata(filename, rowGroupCount);
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new FileListError((Throwable)exception).context(new StringBuilder(33).append("Error getting metadata for file ").append(filename).append(".").toString()));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> openReadParquetFile(ParquetFileRange file) {
        Left left;
        Either readerOrError;
        BoxedUnit boxedUnit;
        String filename = file.filename();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(24).append("Opening read from file: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ParquetReadSupport readSupport = new ParquetReadSupport((Option<ZoneId>)None$.MODULE$, false, SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED(), SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED());
        Either either = readerOrError = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Path path = new Path(String.valueOf(filename));
            HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)path, (Configuration)this.hdfsConfig());
            ParquetFileReader fileReader = ParquetFileReader.open((InputFile)inputFile);
            FileMetaData parquetFileMetadata = fileReader.getFooter().getFileMetaData();
            MessageType fileSchema = parquetFileMetadata.getSchema();
            Map fileMetadata = parquetFileMetadata.getKeyValueMetaData();
            ReadSupport.ReadContext readContext = readSupport.init(new InitContext(this.hdfsConfig(), this.toSetMultiMap(fileMetadata), fileSchema));
            RecordMaterializer<InternalRow> recordConverter = readSupport.prepareForRead(this.hdfsConfig(), fileMetadata, fileSchema, readContext);
            MessageType requestedSchema = readContext.getRequestedSchema();
            fileReader.setRequestedSchema(requestedSchema);
            ColumnIOFactory columnIOFactory = new ColumnIOFactory(parquetFileMetadata.getCreatedBy());
            boolean strictTypeChecking = false;
            MessageColumnIO columnIO = columnIOFactory.getColumnIO(requestedSchema, fileSchema, strictTypeChecking);
            return new HadoopFileStoreReader(fileReader, columnIO, recordConverter, file);
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new OpenReadError((Throwable)exception).context("Error creating Parquet Reader"));
        if (either instanceof Right) {
            Right right = (Right)either;
            HadoopFileStoreReader reader = (HadoopFileStoreReader)right.value();
            this.reader_$eq((Option<HadoopFileStoreReader>)new Some((Object)reader));
            left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, DataBlock> readDataFromParquetFile(int blockSize) {
        Right right;
        Option<HadoopFileStoreReader> option = this.reader();
        if (option instanceof Some) {
            Some some = (Some)option;
            HadoopFileStoreReader reader2 = (HadoopFileStoreReader)some.value();
            right = package$.MODULE$.Right().apply((Object)reader2);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreReaderNotInitializedError().context("Error reading parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        return right.flatMap((Function1 & Serializable & scala.Serializable)reader -> reader.read(blockSize).map((Function1 & Serializable & scala.Serializable)dataBlock -> dataBlock)).map((Function1 & Serializable & scala.Serializable)dataBlock -> dataBlock);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Either<ConnectorError, BoxedUnit> closeReadParquetFile() {
        void var2_5;
        Right right;
        Option<HadoopFileStoreReader> option = this.reader();
        if (option instanceof Some) {
            Some some = (Some)option;
            HadoopFileStoreReader reader2 = (HadoopFileStoreReader)some.value();
            right = package$.MODULE$.Right().apply((Object)reader2);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Left().apply((Object)new IntermediaryStoreReaderNotInitializedError().context("Error closing read of parquet file from HDFS"));
        } else {
            throw new MatchError(option);
        }
        Either r = right.flatMap((Function1 & Serializable & scala.Serializable)reader -> reader.close().map((Function1 & Serializable & scala.Serializable)_ -> {
            HadoopFileStoreLayer.$anonfun$closeReadParquetFile$2(_);
            return BoxedUnit.UNIT;
        }));
        this.reader_$eq((Option<HadoopFileStoreReader>)None$.MODULE$);
        return var2_5;
    }

    @Override
    public Either<ConnectorError, Seq<String>> getFileList(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> {
            Left left;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> fs.listStatus(path));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                FileStatus[] fileStatuses = (FileStatus[])success.value();
                left = package$.MODULE$.Right().apply((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatuses)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                left = package$.MODULE$.Left().apply((Object)new FileListError(exception).context("Error getting file list from HDFS."));
            } else {
                throw new MatchError((Object)try_);
            }
            return left;
        });
    }

    @Override
    public Either<ConnectorError, BoxedUnit> removeFile(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> fs.exists(path) ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.delete(path, true)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new RemoveFileError((Path)path, (Throwable)exception).context("Error removing HDFS file.")) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> removeDir(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> fs.exists(path) ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.delete(path, true)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new RemoveDirectoryError((Path)path, (Throwable)exception).context("Error removing HDFS directory.")) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createFile(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> !fs.exists(path) ? Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FSDataOutputStream stream = fs.create(path);
            stream.write(0);
            stream.close();
        }).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new CreateFileError((Path)path, (Throwable)exception).context("Error creating HDFS file.")) : package$.MODULE$.Left().apply((Object)new CreateFileAlreadyExistsError(filename)));
    }

    @Override
    public Either<ConnectorError, BoxedUnit> createDir(String filename, String permission) {
        FsPermission perms = new FsPermission(permission);
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> {
            Left left;
            if (!fs.exists(path)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(31).append("Making path ").append(path).append(" with permissions: ").append(perms.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                left = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fs.mkdirs(path, perms)).toEither().left().map((Function1 & Serializable & scala.Serializable)exception -> new CreateDirectoryError((Path)path, (Throwable)exception).context("Error creating HDFS directory."));
            } else {
                left = package$.MODULE$.Left().apply((Object)new CreateDirectoryAlreadyExistsError(filename));
            }
            return left;
        });
    }

    @Override
    public Either<ConnectorError, Object> fileExists(String filename) {
        return this.useFileSystem(filename, (Function2 & Serializable & scala.Serializable)(fs, path) -> package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)fs.exists(path))));
    }

    @Override
    public Either<ConnectorError, String> getImpersonationToken(String user) {
        Right right;
        ObjectRef hdfsToken = ObjectRef.create((Object)None$.MODULE$);
        Option ugiUser = Option$.MODULE$.apply((Object)UserGroupInformation.getLoginUser());
        Option option = ugiUser;
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            UserGroupInformation user2 = (UserGroupInformation)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Got UGI user.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Collection existingTokens = user2.getCredentials().getAllTokens();
            for (Token token : existingTokens) {
                BoxedUnit boxedUnit2;
                Text tokenKind = token.getKind();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(21).append("Existing token kind: ").append(tokenKind.toString()).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (!this.WEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.SWEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.HDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind)) continue;
                hdfsToken.elem = new Some((Object)token.encodeToUrlString());
            }
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        this.useFileSystem(this.fileStoreConfig.address(), (Function2 & Serializable & scala.Serializable)(fs, x$4) -> {
            Token[] tokens = fs.addDelegationTokens(user, null);
            for (Token token : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens))) {
                BoxedUnit boxedUnit;
                Text tokenKind = token.getKind();
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(31).append("Hadoop impersonation: IT kind: ").append(tokenKind.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                if (!this.WEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.SWEBHDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind) && !this.HDFS_DELEGATION_TOKEN_TEXT().equals((Object)tokenKind)) continue;
                hdfsToken$1.elem = new Some((Object)token.encodeToUrlString());
            }
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        });
        Option option2 = (Option)hdfsToken.elem;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String token = (String)some.value();
            right = package$.MODULE$.Right().apply((Object)token);
        } else if (None$.MODULE$.equals(option2)) {
            right = package$.MODULE$.Left().apply((Object)new MissingHDFSImpersonationTokenError(user, this.fileStoreConfig.address()));
        } else {
            throw new MatchError((Object)option2);
        }
        return right;
    }

    @Override
    public Either<ConnectorError, Seq<String>> getGlobStatus(String pattern) {
        return this.useFileSystem(pattern, (Function2 & Serializable & scala.Serializable)(fs, path) -> {
            Left left;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> fs.globStatus(path));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                FileStatus[] fileStatuses = (FileStatus[])success.value();
                left = package$.MODULE$.Right().apply((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatuses)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getPath().toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                left = package$.MODULE$.Left().apply((Object)new FileListError(exception).context("Error getting file list from HDFS."));
            } else {
                throw new MatchError((Object)try_);
            }
            return left;
        });
    }

    @Override
    public AWSOptions getAWSOptions() {
        return this.fileStoreConfig.awsOptions();
    }

    @Override
    public GCSOptions getGCSOptions() {
        return this.fileStoreConfig.gcsOptions();
    }

    private <T> Either<ConnectorError, T> useFileSystem(String filename, Function2<FileSystem, Path, Either<ConnectorError, T>> fsAction) {
        Either either;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(16).append("Filestore path: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Path path = new Path(String.valueOf(filename));
            FileSystem fs = path.getFileSystem(this.hdfsConfig());
            return (Either)fsAction.apply((Object)fs, (Object)path);
        });
        if (try_ instanceof Success) {
            Either value;
            Success success = (Success)try_;
            either = value = (Either)success.value();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            either = package$.MODULE$.Left().apply((Object)new FileStoreThrownError(exception));
        } else {
            throw new MatchError((Object)try_);
        }
        return either;
    }

    public static final /* synthetic */ void $anonfun$writeDataToParquetFile$5(List _) {
    }

    public static final /* synthetic */ void $anonfun$closeWriteParquetFile$4(BoxedUnit _) {
    }

    public static final /* synthetic */ void $anonfun$closeReadParquetFile$2(BoxedUnit _) {
    }

    public HadoopFileStoreLayer(FileStoreConfig fileStoreConfig, Option<StructType> schema) {
        this.fileStoreConfig = fileStoreConfig;
        this.S3_ACCESS_KEY = "fs.s3a.access.key";
        this.S3_SECRET_KEY = "fs.s3a.secret.key";
        this.S3_SESSION_TOKEN = "fs.s3a.session.token";
        this.AWS_CREDENTIALS_PROVIDER = "fs.s3a.aws.credentials.provider";
        this.S3_ENDPOINT = "fs.s3a.endpoint";
        this.S3_ENABLE_SSL = "fs.s3a.connection.ssl.enabled";
        this.S3_ENABLE_PATH_STYLE = "fs.s3a.path.style.access";
        this.logger = LogProvider$.MODULE$.getLogger(HadoopFileStoreLayer.class);
        this.WEBHDFS_DELEGATION_TOKEN_TEXT = new Text("WEBHDFS delegation");
        this.SWEBHDFS_DELEGATION_TOKEN_TEXT = new Text("SWEBHDFS delegation");
        this.HDFS_DELEGATION_TOKEN_TEXT = new Text("HDFS_DELEGATION_TOKEN");
        this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE = "spark.sql.legacy.parquet.datetimeRebaseModeInWrite";
        this.LEGACY_PARQUET_REBASE_MODE_IN_READ = "spark.sql.legacy.parquet.datetimeRebaseModeInRead";
        this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE = "spark.sql.legacy.parquet.int96RebaseModeInWrite";
        this.writer = None$.MODULE$;
        this.reader = None$.MODULE$;
        this.hdfsConfig = new Configuration();
        Option<StructType> option = schema;
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            StructType schema2 = (StructType)some.value();
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(31).append("Read and write support schema: ").append(schema2).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.hdfsConfig().set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), schema2.json());
            this.hdfsConfig().set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), schema2.json());
            ParquetWriteSupport$.MODULE$.setSchema(schema2, this.hdfsConfig());
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        this.awsOptions = fileStoreConfig.awsOptions();
        Option<SensitiveArg<String>> option2 = this.awsOptions().awsCredentialsProvider();
        if (option2 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option2;
            SensitiveArg provider = (SensitiveArg)some.value();
            this.hdfsConfig().set(this.AWS_CREDENTIALS_PROVIDER(), (String)provider.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Setting {}: {}", new Object[]{this.AWS_CREDENTIALS_PROVIDER(), provider});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (None$.MODULE$.equals(option2)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS credentials provider for Hadoop config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else {
            throw new MatchError(option2);
        }
        Option<AWSAuth> option3 = this.awsOptions().awsAuth();
        if (option3 instanceof Some) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit5;
            Some some = (Some)option3;
            AWSAuth auth = (AWSAuth)some.value();
            this.hdfsConfig().set(this.S3_ACCESS_KEY(), auth.accessKeyId().arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ACCESS_KEY(), auth.accessKeyId().origin()});
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            this.hdfsConfig().set(this.S3_SECRET_KEY(), auth.secretAccessKey().arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_SECRET_KEY(), auth.secretAccessKey().origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit6 = boxedUnit;
        } else if (None$.MODULE$.equals(option3)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS auth for Hadoop config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit7 = boxedUnit;
        } else {
            throw new MatchError(option3);
        }
        Option<SensitiveArg<String>> option4 = this.awsOptions().awsSessionToken();
        if (option4 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option4;
            SensitiveArg token = (SensitiveArg)some.value();
            this.hdfsConfig().set(this.S3_SESSION_TOKEN(), (String)token.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_SESSION_TOKEN(), token.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit8 = boxedUnit;
        } else if (None$.MODULE$.equals(option4)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not set AWS session token for Hadoop config");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit9 = boxedUnit;
        } else {
            throw new MatchError(option4);
        }
        Option<SensitiveArg<String>> option5 = this.awsOptions().awsEndpoint();
        if (option5 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option5;
            SensitiveArg endpoint = (SensitiveArg)some.value();
            this.hdfsConfig().set(this.S3_ENDPOINT(), (String)endpoint.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ENDPOINT(), endpoint.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit10 = boxedUnit;
        } else if (None$.MODULE$.equals(option5)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not set AWS endpoint, using default.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit11 = boxedUnit;
        } else {
            throw new MatchError(option5);
        }
        Option<SensitiveArg<String>> option6 = this.awsOptions().enableSSL();
        if (option6 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option6;
            SensitiveArg enable = (SensitiveArg)some.value();
            this.hdfsConfig().set(this.S3_ENABLE_SSL(), (String)enable.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ENABLE_SSL(), enable.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit12 = boxedUnit;
        } else if (None$.MODULE$.equals(option6)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not set AWS SSL enabled flag, using default of true.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit13 = boxedUnit;
        } else {
            throw new MatchError(option6);
        }
        Option<SensitiveArg<String>> option7 = this.awsOptions().enablePathStyle();
        if (option7 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option7;
            SensitiveArg enable = (SensitiveArg)some.value();
            this.hdfsConfig().set(this.S3_ENABLE_PATH_STYLE(), (String)enable.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{this.S3_ENABLE_PATH_STYLE(), enable.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit14 = boxedUnit;
        } else if (None$.MODULE$.equals(option7)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not set AWS path style enabled flag, using default of false.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit15 = boxedUnit;
        } else {
            throw new MatchError(option7);
        }
        this.gcsOptions = fileStoreConfig.gcsOptions();
        Option<SensitiveArg<String>> option8 = this.gcsOptions().gcsServiceKeyFile();
        if (option8 instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option8;
            SensitiveArg auth = (SensitiveArg)some.value();
            this.hdfsConfig().set(GCSSparkOptions$.MODULE$.SERVICE_JSON_KEYFILE(), (String)auth.arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded {} from {}", new Object[]{GCSSparkOptions$.MODULE$.SERVICE_JSON_KEYFILE(), auth.origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit16 = boxedUnit;
        } else if (None$.MODULE$.equals(option8)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Did not load GCS key file");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit17 = boxedUnit;
        } else {
            throw new MatchError(option8);
        }
        Option<GCSServiceAuth> option9 = this.gcsOptions().gcsServiceAuth();
        if (option9 instanceof Some) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit18;
            BoxedUnit boxedUnit19;
            Some some = (Some)option9;
            GCSServiceAuth auth = (GCSServiceAuth)some.value();
            this.hdfsConfig().set(GCSSparkOptions$.MODULE$.SERVICE_ACC_KEY_ID(), auth.serviceKeyId().arg());
            this.hdfsConfig().set(GCSSparkOptions$.MODULE$.SERVICE_ACC_KEY(), auth.serviceKeySecret().arg());
            this.hdfsConfig().set(GCSSparkOptions$.MODULE$.SERVICE_ACC_EMAIL(), auth.serviceEmail().arg());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded Google Cloud Storage service account key id from {}", new Object[]{auth.serviceKeyId().origin()});
                boxedUnit19 = BoxedUnit.UNIT;
            } else {
                boxedUnit19 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded Google Cloud Storage service account key secret from {}", new Object[]{auth.serviceKeySecret().origin()});
                boxedUnit18 = BoxedUnit.UNIT;
            } else {
                boxedUnit18 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Loaded Google Cloud Storage service account key email from {}", new Object[]{auth.serviceEmail().origin()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit20 = boxedUnit;
        } else if (None$.MODULE$.equals(option9)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Did not load Google Cloud Storage service account authentications");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit21 = boxedUnit;
        } else {
            throw new MatchError(option9);
        }
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), "false");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), "true");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), "false");
        this.hdfsConfig().set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), "INT96");
        this.hdfsConfig().set(this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE(), "CORRECTED");
        this.hdfsConfig().set(this.LEGACY_PARQUET_REBASE_MODE_IN_READ(), "CORRECTED");
        this.hdfsConfig().set(this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE(), "CORRECTED");
        this.hdfsConfig().setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        this.hdfsConfig().set("fs.permissions.umask-mode", "000");
    }

    public class VerticaParquetBuilder
    extends ParquetWriter.Builder<InternalRow, VerticaParquetBuilder> {
        public VerticaParquetBuilder self() {
            return this;
        }

        public ParquetWriteSupport getWriteSupport(Configuration conf) {
            return new ParquetWriteSupport();
        }

        public /* synthetic */ HadoopFileStoreLayer com$vertica$spark$datasource$fs$HadoopFileStoreLayer$VerticaParquetBuilder$$$outer() {
            return HadoopFileStoreLayer.this;
        }

        public VerticaParquetBuilder(Path file) {
            if (HadoopFileStoreLayer.this == null) {
                throw null;
            }
            super(file);
        }
    }
}

