/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.v2;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.DistributedFilesystemReadConfig;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.ReadConfig;
import com.vertica.spark.datasource.core.DSConfigSetupInterface;
import com.vertica.spark.datasource.json.JsonBatchFactory;
import com.vertica.spark.datasource.json.VerticaJsonScan;
import com.vertica.spark.datasource.v2.NonPushFilter;
import com.vertica.spark.datasource.v2.PushFilter;
import com.vertica.spark.datasource.v2.UnknownColumnName;
import com.vertica.spark.datasource.v2.VerticaScan;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.ErrorHandling$;
import com.vertica.spark.util.pushdown.PushdownUtils$;
import com.vertica.spark.util.schema.ComplexTypesSchemaTools;
import java.io.Serializable;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u000e\u001d\u0001\u001dB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\")!\u000b\u0001C\u0001'\"9\u0001\f\u0001a\u0001\n#I\u0006bB6\u0001\u0001\u0004%\t\u0002\u001c\u0005\u0007g\u0002\u0001\u000b\u0015\u0002.\t\u000fQ\u0004\u0001\u0019!C\tk\"9A\u0010\u0001a\u0001\n#i\bBB@\u0001A\u0003&a\u000fC\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0005\u0002\u0004!I\u00111\u0002\u0001A\u0002\u0013E\u0011Q\u0002\u0005\t\u0003#\u0001\u0001\u0015)\u0003\u0002\u0006!I\u00111\u0003\u0001A\u0002\u0013E\u0011Q\u0003\u0005\n\u0003G\u0001\u0001\u0019!C\t\u0003KA\u0001\"!\u000b\u0001A\u0003&\u0011q\u0003\u0005\n\u0003W\u0001!\u0019!C\t\u0003[A\u0001\"a\u0010\u0001A\u0003%\u0011q\u0006\u0005\n\u0003\u0003\u0002!\u0019!C\t\u0003\u0007B\u0001\"!\u0016\u0001A\u0003%\u0011Q\t\u0005\b\u0003/\u0002A\u0011IA-\u0011\u001d\t\t\u0007\u0001C\u0005\u0003GBa\u0001\u0017\u0001\u0005B\u0005%\u0004bBA?\u0001\u0011\u0005\u0013q\u0010\u0005\b\u0003\u0003\u0003A\u0011IAB\u0011\u001d\t9\t\u0001C\t\u0003\u0013Ca!!*\u0001\t#)(A\u0005,feRL7-Y*dC:\u0014U/\u001b7eKJT!!\b\u0010\u0002\u0005Y\u0014$BA\u0010!\u0003)!\u0017\r^1t_V\u00148-\u001a\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\u000fY,'\u000f^5dC*\tQ%A\u0002d_6\u001c\u0001aE\u0003\u0001QAz$\t\u0005\u0002*]5\t!F\u0003\u0002,Y\u0005!A.\u00198h\u0015\u0005i\u0013\u0001\u00026bm\u0006L!a\f\u0016\u0003\r=\u0013'.Z2u!\t\tT(D\u00013\u0015\t\u0019D'\u0001\u0003sK\u0006$'BA\u001b7\u0003%\u0019wN\u001c8fGR|'O\u0003\u00028q\u0005\u00191/\u001d7\u000b\u0005\u0005J$B\u0001\u001e<\u0003\u0019\t\u0007/Y2iK*\tA(A\u0002pe\u001eL!A\u0010\u001a\u0003\u0017M\u001b\u0017M\u001c\"vS2$WM\u001d\t\u0003c\u0001K!!\u0011\u001a\u0003/M+\b\u000f]8siN\u0004Vo\u001d5E_^tg)\u001b7uKJ\u001c\bCA\u0019D\u0013\t!%GA\u0010TkB\u0004xN\u001d;t!V\u001c\b\u000eR8x]J+\u0017/^5sK\u0012\u001cu\u000e\\;n]N\faaY8oM&<\u0007CA$J\u001b\u0005A%BA#!\u0013\tQ\u0005J\u0001\u0006SK\u0006$7i\u001c8gS\u001e\fqB]3bI\u000e{gNZ5h'\u0016$X\u000f\u001d\t\u0004\u001bB3U\"\u0001(\u000b\u0005=s\u0012\u0001B2pe\u0016L!!\u0015(\u0003-\u0011\u001b6i\u001c8gS\u001e\u001cV\r^;q\u0013:$XM\u001d4bG\u0016\fa\u0001P5oSRtDc\u0001+W/B\u0011Q\u000bA\u0007\u00029!)Qi\u0001a\u0001\r\")1j\u0001a\u0001\u0019\u0006Y\u0001/^:i\r&dG/\u001a:t+\u0005Q\u0006cA.fQ:\u0011AL\u0019\b\u0003;\u0002l\u0011A\u0018\u0006\u0003?\u001a\na\u0001\u0010:p_Rt\u0014\"A1\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r$\u0017a\u00029bG.\fw-\u001a\u0006\u0002C&\u0011am\u001a\u0002\u0005\u0019&\u001cHO\u0003\u0002dIB\u0011Q+[\u0005\u0003Ur\u0011!\u0002U;tQ\u001aKG\u000e^3s\u0003=\u0001Xo\u001d5GS2$XM]:`I\u0015\fHCA7r!\tqw.D\u0001e\u0013\t\u0001HM\u0001\u0003V]&$\bb\u0002:\u0006\u0003\u0003\u0005\rAW\u0001\u0004q\u0012\n\u0014\u0001\u00049vg\"4\u0015\u000e\u001c;feN\u0004\u0013A\u0004:fcVL'/\u001a3TG\",W.Y\u000b\u0002mB\u0011qO_\u0007\u0002q*\u0011\u0011PN\u0001\u0006if\u0004Xm]\u0005\u0003wb\u0014!b\u0015;sk\u000e$H+\u001f9f\u0003I\u0011X-];je\u0016$7k\u00195f[\u0006|F%Z9\u0015\u00055t\bb\u0002:\t\u0003\u0003\u0005\rA^\u0001\u0010e\u0016\fX/\u001b:fIN\u001b\u0007.Z7bA\u0005i\u0011mZ4QkNDW\r\u001a#po:,\"!!\u0002\u0011\u00079\f9!C\u0002\u0002\n\u0011\u0014qAQ8pY\u0016\fg.A\tbO\u001e\u0004Vo\u001d5fI\u0012{wO\\0%KF$2!\\A\b\u0011!\u00118\"!AA\u0002\u0005\u0015\u0011AD1hOB+8\u000f[3e\t><h\u000eI\u0001\bOJ|W\u000f\u001d\"z+\t\t9\u0002E\u0003o\u00033\ti\"C\u0002\u0002\u001c\u0011\u0014Q!\u0011:sCf\u00042a^A\u0010\u0013\r\t\t\u0003\u001f\u0002\f'R\u0014Xo\u0019;GS\u0016dG-A\u0006he>,\bOQ=`I\u0015\fHcA7\u0002(!A!ODA\u0001\u0002\u0004\t9\"\u0001\u0005he>,\bOQ=!\u0003\u0019awnZ4feV\u0011\u0011q\u0006\t\u0005\u0003c\tY$\u0004\u0002\u00024)!\u0011QGA\u001c\u00031\u00198-\u00197bY><w-\u001b8h\u0015\r\tI\u0004J\u0001\tif\u0004Xm]1gK&!\u0011QHA\u001a\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013aB2u)>|Gn]\u000b\u0003\u0003\u000b\u0002B!a\u0012\u0002R5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\ni%\u0001\u0004tG\",W.\u0019\u0006\u0004\u0003\u001f\u0002\u0013\u0001B;uS2LA!a\u0015\u0002J\t92i\\7qY\u0016DH+\u001f9fgN\u001b\u0007.Z7b)>|Gn]\u0001\tGR$vn\u001c7tA\u0005)!-^5mIR\u0011\u00111\f\t\u0004c\u0005u\u0013bAA0e\t!1kY1o\u0003\u001d)8/\u001a&t_:$B!!\u0002\u0002f!1\u0011qM\u000bA\u0002\u0019\u000b1a\u00194h)\u0011\tY'!\u001f\u0011\u000b9\fI\"!\u001c\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001d7\u0003\u001d\u0019x.\u001e:dKNLA!a\u001e\u0002r\t1a)\u001b7uKJDq!a\u001f\u0017\u0001\u0004\tY'A\u0004gS2$XM]:\u0002\u001bA,8\u000f[3e\r&dG/\u001a:t)\t\tY'\u0001\u0007qeVtWmQ8mk6t7\u000fF\u0002n\u0003\u000bCQ\u0001\u001e\rA\u0002Y\f!bZ3u\u0007>dG+\u001f9f)\u0011\tY)!%\u0011\u0007]\fi)C\u0002\u0002\u0010b\u0014\u0001\u0002R1uCRK\b/\u001a\u0005\b\u0003'K\u0002\u0019AAK\u0003\u001d\u0019w\u000e\u001c(b[\u0016\u0004B!a&\u0002 :!\u0011\u0011TAN!\tiF-C\u0002\u0002\u001e\u0012\fa\u0001\u0015:fI\u00164\u0017\u0002BAQ\u0003G\u0013aa\u0015;sS:<'bAAOI\u0006YA/\u00192mKN\u001b\u0007.Z7b\u0001")
public class VerticaScanBuilder
implements SupportsPushDownFilters,
SupportsPushDownRequiredColumns {
    private final ReadConfig config;
    private final DSConfigSetupInterface<ReadConfig> readConfigSetup;
    private List<PushFilter> pushFilters;
    private StructType requiredSchema;
    private boolean aggPushedDown;
    private StructField[] groupBy;
    private final Logger logger;
    private final ComplexTypesSchemaTools ctTools;

    public List<PushFilter> pushFilters() {
        return this.pushFilters;
    }

    public void pushFilters_$eq(List<PushFilter> x$1) {
        this.pushFilters = x$1;
    }

    public StructType requiredSchema() {
        return this.requiredSchema;
    }

    public void requiredSchema_$eq(StructType x$1) {
        this.requiredSchema = x$1;
    }

    public boolean aggPushedDown() {
        return this.aggPushedDown;
    }

    public void aggPushedDown_$eq(boolean x$1) {
        this.aggPushedDown = x$1;
    }

    public StructField[] groupBy() {
        return this.groupBy;
    }

    public void groupBy_$eq(StructField[] x$1) {
        this.groupBy = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public ComplexTypesSchemaTools ctTools() {
        return this.ctTools;
    }

    public Scan build() {
        ReadConfig cfg = this.config.copyConfig();
        cfg.setPushdownFilters(this.pushFilters());
        cfg.setRequiredSchema(this.requiredSchema());
        cfg.setPushdownAgg(this.aggPushedDown());
        cfg.setGroupBy(this.groupBy());
        return this.useJson(cfg) ? new VerticaJsonScan(cfg, this.readConfigSetup, new JsonBatchFactory()) : new VerticaScan(cfg, this.readConfigSetup);
    }

    private boolean useJson(ReadConfig cfg) {
        boolean bl;
        block7: {
            block4: {
                StructType requiredSchema;
                Either either;
                DistributedFilesystemReadConfig distributedFilesystemReadConfig;
                block6: {
                    Either either2;
                    Tuple2 tuple2;
                    block5: {
                        ReadConfig readConfig = cfg;
                        if (!(readConfig instanceof DistributedFilesystemReadConfig)) break block4;
                        distributedFilesystemReadConfig = (DistributedFilesystemReadConfig)readConfig;
                        tuple2 = new Tuple2(this.readConfigSetup.getTableSchema(distributedFilesystemReadConfig), (Object)distributedFilesystemReadConfig.getRequiredSchema());
                        if (tuple2 == null) break block5;
                        either = (Either)tuple2._1();
                        requiredSchema = (StructType)tuple2._2();
                        if (either instanceof Right) break block6;
                    }
                    if (tuple2 != null && (either2 = (Either)tuple2._1()) instanceof Left) {
                        Left left = (Left)either2;
                        ConnectorError err = (ConnectorError)left.value();
                        throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), err);
                    }
                    throw new MatchError((Object)tuple2);
                }
                Right right = (Right)either;
                StructType metadataSchema = (StructType)right.value();
                StructType schema = requiredSchema.nonEmpty() ? requiredSchema : metadataSchema;
                boolean bl2 = distributedFilesystemReadConfig.useJson() || this.ctTools().filterComplexTypeColumns(schema).nonEmpty();
                bl = bl2;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    public Filter[] pushFilters(Filter[] filters) {
        Tuple2 initialLists = new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$);
        Tuple2 tuple2 = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).map((Function1 & Serializable & scala.Serializable)filter -> PushdownUtils$.MODULE$.genFilter((Filter)filter), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Either.class))))).foldLeft((Object)initialLists, (Function2 & Serializable & scala.Serializable)(acc, filter) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = acc;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            List nonPushFilters = (List)tuple22._1();
            List pushFilters = (List)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)nonPushFilters, (Object)pushFilters);
            Tuple2 tuple24 = tuple23;
            List nonPushFilters2 = (List)tuple24._1();
            List pushFilters2 = (List)tuple24._2();
            Either either = filter;
            if (either instanceof Left) {
                Filter nonPushFilter;
                Left left = (Left)either;
                Filter filter2 = nonPushFilter = ((NonPushFilter)left.value()).filter();
                tuple2 = new Tuple2((Object)nonPushFilters2.$colon$colon((Object)new NonPushFilter(filter2)), (Object)pushFilters2);
            } else if (either instanceof Right) {
                PushFilter pushFilter;
                Right right = (Right)either;
                PushFilter pushFilter2 = pushFilter = (PushFilter)right.value();
                tuple2 = new Tuple2((Object)nonPushFilters2, (Object)pushFilters2.$colon$colon((Object)pushFilter2));
            } else {
                throw new MatchError((Object)either);
            }
            return tuple2;
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List nonPushFilters = (List)tuple2._1();
        List pushFilters = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nonPushFilters, (Object)pushFilters);
        Tuple2 tuple23 = tuple22;
        List nonPushFilters2 = (List)tuple23._1();
        List pushFilters2 = (List)tuple23._2();
        this.pushFilters_$eq((List<PushFilter>)pushFilters2);
        return (Filter[])((TraversableOnce)nonPushFilters2.map((Function1 & Serializable & scala.Serializable)x$5 -> ((NonPushFilter)x$5).filter(), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Filter.class));
    }

    public Filter[] pushedFilters() {
        return (Filter[])((TraversableOnce)this.pushFilters().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.filter(), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Filter.class));
    }

    public void pruneColumns(StructType requiredSchema) {
        this.requiredSchema_$eq(requiredSchema);
        this.aggPushedDown_$eq(false);
        this.groupBy_$eq((StructField[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(StructField.class)));
    }

    public DataType getColType(String colName) {
        Option option = this.tableSchema().find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)VerticaScanBuilder.$anonfun$getColType$1(colName, x$7)));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), new UnknownColumnName(colName));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        StructField col = (StructField)some.value();
        DataType dataType = col.dataType();
        return dataType;
    }

    public StructType tableSchema() {
        StructType schema;
        Either<ConnectorError, StructType> either = this.readConfigSetup.getTableSchema(this.config);
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                Left left = (Left)either;
                ConnectorError err = (ConnectorError)left.value();
                throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), err.context("Scan builder failed to get table schema"));
            }
            throw new MatchError(either);
        }
        Right right = (Right)either;
        StructType structType = schema = (StructType)right.value();
        return structType;
    }

    public static final /* synthetic */ boolean $anonfun$getColType$1(String colName$1, StructField x$7) {
        return x$7.name().equalsIgnoreCase(colName$1);
    }

    public VerticaScanBuilder(ReadConfig config, DSConfigSetupInterface<ReadConfig> readConfigSetup) {
        this.config = config;
        this.readConfigSetup = readConfigSetup;
        this.pushFilters = Nil$.MODULE$;
        this.requiredSchema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.aggPushedDown = false;
        this.groupBy = (StructField[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(StructField.class));
        this.logger = LogProvider$.MODULE$.getLogger(VerticaScanBuilder.class);
        this.ctTools = new ComplexTypesSchemaTools();
    }
}

