/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.cleanup;

import cats.Applicative;
import cats.implicits$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.util.cleanup.CleanupUtilsInterface;
import com.vertica.spark.util.cleanup.FileCleanupInfo;
import com.vertica.spark.util.error.CleanupError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.ParentDirMissingError;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;

@ScalaSignature(bytes="\u0006\u0001\u0005}a\u0001\u0002\u0006\f\u0001YAQ!\t\u0001\u0005\u0002\tBq\u0001\n\u0001C\u0002\u0013%Q\u0005\u0003\u0004/\u0001\u0001\u0006IA\n\u0005\u0006_\u0001!I\u0001\r\u0005\u0006\u0015\u0002!\ta\u0013\u0005\u0006]\u0002!Ia\u001c\u0005\u0007\u007f\u0002!I!!\u0001\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\n!9\u0011q\u0003\u0001\u0005B\u0005e!\u0001D\"mK\u0006tW\u000f]+uS2\u001c(B\u0001\u0007\u000e\u0003\u001d\u0019G.Z1okBT!AD\b\u0002\tU$\u0018\u000e\u001c\u0006\u0003!E\tQa\u001d9be.T!AE\n\u0002\u000fY,'\u000f^5dC*\tA#A\u0002d_6\u001c\u0001aE\u0002\u0001/u\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0007C\u0001\u0010 \u001b\u0005Y\u0011B\u0001\u0011\f\u0005U\u0019E.Z1okB,F/\u001b7t\u0013:$XM\u001d4bG\u0016\fa\u0001P5oSRtD#A\u0012\u0011\u0005y\u0001\u0011A\u00027pO\u001e,'/F\u0001'!\t9C&D\u0001)\u0015\tI#&\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002,'\u0005AA/\u001f9fg\u00064W-\u0003\u0002.Q\t1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%\u0001\bsK\u000e|'\u000f\u001a$jY\u0016t\u0015-\\3\u0015\u0007EJT\t\u0005\u00023o5\t1G\u0003\u00025k\u0005!A.\u00198h\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u001a\u0003\rM#(/\u001b8h\u0011\u0015QD\u00011\u0001<\u0003!1\u0017\u000e\\3oC6,\u0007C\u0001\u001fD\u001d\ti\u0014\t\u0005\u0002?35\tqH\u0003\u0002A+\u00051AH]8pizJ!AQ\r\u0002\rA\u0013X\rZ3g\u0013\tADI\u0003\u0002C3!)a\t\u0002a\u0001\u000f\u0006\u0019\u0011\u000e\u001a=\u0011\u0005aA\u0015BA%\u001a\u0005\rIe\u000e^\u0001\u000bG2,\u0017M\\;q\u00032dGc\u0001'cYB\u0019Q\nX0\u000f\u00059KfBA(X\u001d\t\u0001fK\u0004\u0002R+:\u0011!\u000b\u0016\b\u0003}MK\u0011\u0001F\u0005\u0003%MI!\u0001E\t\n\u00059y\u0011B\u0001-\u000e\u0003\u0015)'O]8s\u0013\tQ6,A\u0007FeJ|'\u000fS1oI2Lgn\u001a\u0006\u000316I!!\u00180\u0003\u001f\r{gN\\3di>\u0014(+Z:vYRT!AW.\u0011\u0005a\u0001\u0017BA1\u001a\u0005\u0011)f.\u001b;\t\u000b\r,\u0001\u0019\u00013\u0002\u001d\u0019LG.Z*u_J,G*Y=feB\u0011QM[\u0007\u0002M*\u0011q\r[\u0001\u0003MNT!![\b\u0002\u0015\u0011\fG/Y:pkJ\u001cW-\u0003\u0002lM\n9b)\u001b7f'R|'/\u001a'bs\u0016\u0014\u0018J\u001c;fe\u001a\f7-\u001a\u0005\u0006[\u0016\u0001\raO\u0001\u0005a\u0006$\b.A\fdY\u0016\fg.\u001e9QCJ,g\u000e\u001e#je&3W)\u001c9usR\u0019\u0001/ @\u0011\tE4\u0018p\u0018\b\u0003eRt!AP:\n\u0003iI!!^\r\u0002\u000fA\f7m[1hK&\u0011q\u000f\u001f\u0002\u0007\u000b&$\b.\u001a:\u000b\u0005UL\u0002C\u0001>|\u001b\u0005Y\u0016B\u0001?\\\u00059\u0019uN\u001c8fGR|'/\u0012:s_JDQa\u0019\u0004A\u0002\u0011DQ!\u001c\u0004A\u0002m\n1cZ3u!\u0006\u0014XM\u001c;IC\u0012|w\u000e\u001d)bi\"$B!a\u0001\u0002\u0006A\u0019Q\nX\u001e\t\u000b5<\u0001\u0019A\u001e\u0002\u001dA,'OZ8s[\u000ecW-\u00198vaR)A*a\u0003\u0002\u000e!)1\r\u0003a\u0001I\"9\u0011q\u0002\u0005A\u0002\u0005E\u0011a\u00044jY\u0016\u001cE.Z1okBLeNZ8\u0011\u0007y\t\u0019\"C\u0002\u0002\u0016-\u0011qBR5mK\u000ecW-\u00198va&sgm\\\u0001\u0010G\",7m[!oI\u000ecW-\u00198vaR)A*a\u0007\u0002\u001e!)1-\u0003a\u0001I\"9\u0011qB\u0005A\u0002\u0005E\u0001")
public class CleanupUtils
implements CleanupUtilsInterface {
    private final Logger logger = LogProvider$.MODULE$.getLogger(CleanupUtils.class);

    private Logger logger() {
        return this.logger;
    }

    private String recordFileName(String filename, int idx) {
        return new StringBuilder(8).append(filename).append(".cleanup").append(idx).toString();
    }

    @Override
    public Either<ConnectorError, BoxedUnit> cleanupAll(FileStoreLayerInterface fileStoreLayer, String path) {
        Left left;
        Path p = new Path(String.valueOf(path));
        Path parent = p.getParent();
        if (parent != null) {
            fileStoreLayer.removeDir(parent.toString());
            left = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        } else {
            left = package$.MODULE$.Left().apply((Object)new CleanupError(path));
        }
        return left;
    }

    private Either<ConnectorError, BoxedUnit> cleanupParentDirIfEmpty(FileStoreLayerInterface fileStoreLayer, String path) {
        return this.getParentHadoopPath(path).flatMap((Function1 & Serializable & scala.Serializable)parentPath -> fileStoreLayer.getFileList((String)parentPath).flatMap((Function1 & Serializable & scala.Serializable)allFiles -> this.getParentHadoopPath((String)parentPath).flatMap((Function1 & Serializable & scala.Serializable)parentPath2 -> (allFiles.isEmpty() ? fileStoreLayer.removeDir((String)parentPath2) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)).map((Function1 & Serializable & scala.Serializable)_ -> {
            CleanupUtils.$anonfun$cleanupParentDirIfEmpty$4(_);
            return BoxedUnit.UNIT;
        }))));
    }

    private Either<ConnectorError, String> getParentHadoopPath(String path) {
        Path p = new Path(String.valueOf(path));
        Path parent = p.getParent();
        return parent != null ? package$.MODULE$.Right().apply((Object)parent.toString()) : package$.MODULE$.Left().apply((Object)new ParentDirMissingError(path));
    }

    private Either<ConnectorError, BoxedUnit> performCleanup(FileStoreLayerInterface fileStoreLayer, FileCleanupInfo fileCleanupInfo) {
        String filename = fileCleanupInfo.filename();
        return ((Either)implicits$.MODULE$.toTraverseOps((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), fileCleanupInfo.fileRangeCount()).map((Function1 & Serializable & scala.Serializable)idx -> CleanupUtils.$anonfun$performCleanup$1(this, filename, fileStoreLayer, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).toList(), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(18).append("Removing parquet: ").append(filename).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$2 = boxedUnit;
            return new Tuple2(x$1, (Object)x$2);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Either either = fileStoreLayer.removeFile(filename).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.cleanupParentDirIfEmpty(fileStoreLayer, filename).map((Function1 & Serializable & scala.Serializable)_ -> {
                CleanupUtils.$anonfun$performCleanup$5(_);
                return BoxedUnit.UNIT;
            }));
            return either;
        });
    }

    @Override
    public Either<ConnectorError, BoxedUnit> checkAndCleanup(FileStoreLayerInterface fileStoreLayer, FileCleanupInfo fileCleanupInfo) {
        BoxedUnit boxedUnit;
        String filename = fileCleanupInfo.filename();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(33).append("Doing partition cleanup of file: ").append(filename).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return fileStoreLayer.createFile(this.recordFileName(filename, fileCleanupInfo.fileIdx())).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            BoxedUnit boxedUnit;
            BoxedUnit x$6;
            BoxedUnit boxedUnit2;
            BoxedUnit x$5;
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(31).append("File: ").append(filename).append(", Checking file existance").toString());
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = x$5 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(18).append("File: ").append(filename).append(", File idx: ").append(fileCleanupInfo.fileIdx()).toString());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = x$6 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(26).append("File: ").append(filename).append(", File range count: ").append(fileCleanupInfo.fileRangeCount()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit x$7 = boxedUnit;
            return new Tuple4(x$4, (Object)x$5, (Object)x$6, (Object)x$7);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$11 -> {
            Tuple4 tuple4 = x$11;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            Either either = ((Either)implicits$.MODULE$.toTraverseOps((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), fileCleanupInfo.fileRangeCount()).map((Function1 & Serializable & scala.Serializable)idx -> CleanupUtils.$anonfun$checkAndCleanup$3(this, filename, fileStoreLayer, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).toList(), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).flatMap((Function1 & Serializable & scala.Serializable)filesExist -> package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)filesExist.forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)x))))).map((Function1 & Serializable & scala.Serializable)allExist -> CleanupUtils.$anonfun$checkAndCleanup$6(this, filename, filesExist, BoxesRunTime.unboxToBoolean((Object)allExist))).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> {
                Either<ConnectorError, BoxedUnit> either;
                Tuple3 tuple3 = x$10;
                if (tuple3 != null) {
                    boolean allExist = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
                    if (allExist) {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isDebugEnabled()) {
                            this.logger().underlying().debug(new StringBuilder(26).append("File: ").append(filename).append(", Performing cleanup").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        either = this.performCleanup(fileStoreLayer, fileCleanupInfo);
                    } else {
                        either = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
                    }
                } else {
                    throw new MatchError((Object)tuple3);
                }
                Either either2 = either.map((Function1 & Serializable & scala.Serializable)_ -> {
                    CleanupUtils.$anonfun$checkAndCleanup$8(_);
                    return BoxedUnit.UNIT;
                });
                return either2;
            }));
            return either;
        });
    }

    public static final /* synthetic */ void $anonfun$cleanupParentDirIfEmpty$4(BoxedUnit _) {
    }

    public static final /* synthetic */ Either $anonfun$performCleanup$1(CleanupUtils $this, String filename$1, FileStoreLayerInterface fileStoreLayer$2, int idx) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(10).append("Removing: ").append($this.recordFileName(filename$1, idx)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return fileStoreLayer$2.removeFile($this.recordFileName(filename$1, idx));
    }

    public static final /* synthetic */ void $anonfun$performCleanup$5(BoxedUnit _) {
    }

    public static final /* synthetic */ Either $anonfun$checkAndCleanup$3(CleanupUtils $this, String filename$2, FileStoreLayerInterface fileStoreLayer$3, int idx) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(20).append("Checking existence: ").append($this.recordFileName(filename$2, idx)).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return fileStoreLayer$3.fileExists($this.recordFileName(filename$2, idx));
    }

    public static final /* synthetic */ Tuple3 $anonfun$checkAndCleanup$6(CleanupUtils $this, String filename$2, List filesExist$1, boolean allExist) {
        BoxedUnit boxedUnit;
        BoxedUnit x$8;
        BoxedUnit boxedUnit2;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(20).append("File: ").append(filename$2).append(", filesExist: ").append(filesExist$1.toString()).toString());
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = x$8 = BoxedUnit.UNIT;
        }
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(19).append("File: ").append(filename$2).append(", All exist: ").append(allExist).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit x$9 = boxedUnit;
        return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)allExist), (Object)x$8, (Object)x$9);
    }

    public static final /* synthetic */ void $anonfun$checkAndCleanup$8(BoxedUnit _) {
    }
}

