/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.schema;

import cats.Applicative;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.config.TableQuery;
import com.vertica.spark.config.TableSource;
import com.vertica.spark.config.ValidColumnList;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.util.complex.ComplexTypeUtils;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.DatabaseReadError;
import com.vertica.spark.util.error.EmptySchemaError;
import com.vertica.spark.util.error.ErrorHandling$;
import com.vertica.spark.util.error.ErrorList;
import com.vertica.spark.util.error.InvalidMapSchemaError;
import com.vertica.spark.util.error.InvalidTableSchemaComplexType;
import com.vertica.spark.util.error.JdbcSchemaError;
import com.vertica.spark.util.error.MapDataTypeConversionError;
import com.vertica.spark.util.error.MissingElementTypeError;
import com.vertica.spark.util.error.MissingSparkPrimitivesConversionError;
import com.vertica.spark.util.error.MissingSqlConversionError;
import com.vertica.spark.util.error.QueryReturnsComplexTypes;
import com.vertica.spark.util.error.SchemaConversionError;
import com.vertica.spark.util.error.SchemaError;
import com.vertica.spark.util.error.StructFieldsError;
import com.vertica.spark.util.error.TableNotEnoughRowsError;
import com.vertica.spark.util.error.UnknownColumnTypesError;
import com.vertica.spark.util.schema.ColumnDef;
import com.vertica.spark.util.schema.ColumnDef$;
import com.vertica.spark.util.schema.ComplexTypesSchemaTools;
import com.vertica.spark.util.schema.MetadataKey$;
import com.vertica.spark.util.schema.SchemaTools$;
import com.vertica.spark.util.schema.SchemaToolsInterface;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\rEa\u0001B\u0014)\u0001MB\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\u0006\u0005\u0002!\ta\u0011\u0005\b\r\u0002\u0011\r\u0011\"\u0003H\u0011\u0019\u0001\u0006\u0001)A\u0005\u0011\"9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0006BB.\u0001A\u0003%1\u000bC\u0004]\u0001\t\u0007I\u0011\u0002*\t\ru\u0003\u0001\u0015!\u0003T\u0011\u001dq\u0006A1A\u0005\n}Caa\u0019\u0001!\u0002\u0013\u0001\u0007b\u00023\u0001\u0005\u0004%I!\u001a\u0005\u0007Y\u0002\u0001\u000b\u0011\u00024\t\u000b5\u0004A\u0011\u00028\t\u000bm\u0004A\u0011\u0002?\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d!9\u0011\u0011\u000e\u0001\u0005\n\u0005-\u0004bBA=\u0001\u0011E\u00111\u0010\u0005\b\u0003\u001f\u0003A\u0011AAI\u0011\u001d\ty\u000e\u0001C\u0001\u0003CDq!a<\u0001\t\u0003\n\t\u0010C\u0004\u0003\u0016\u0001!IAa\u0006\t\u000f\t\r\u0002\u0001\"\u0003\u0003&!9!\u0011\b\u0001\u0005\n\tm\u0002b\u0002B$\u0001\u0011%!\u0011\n\u0005\b\u0005\u001f\u0002A\u0011\u0001B)\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0005KBqAa\u001c\u0001\t\u0003\u0011\t\bC\u0004\u0003z\u0001!\tAa\u001f\t\u000f\tE\u0005\u0001\"\u0001\u0003\u0014\"9!q\u0014\u0001\u0005\n\t\u0005\u0006b\u0002BY\u0001\u0011%!1\u0017\u0005\b\u0005\u0007\u0004A\u0011\u0001Bc\u0011\u001d\u0011\t\u000e\u0001C\u0001\u0005'DqA!9\u0001\t\u0003\u0011\u0019oB\u0005\u0003r\"\n\t\u0011#\u0001\u0003t\u001aAq\u0005KA\u0001\u0012\u0003\u0011)\u0010\u0003\u0004CI\u0011\u0005!q\u001f\u0005\n\u0005s$\u0013\u0013!C\u0001\u0005w\u00141bU2iK6\fGk\\8mg*\u0011\u0011FK\u0001\u0007g\u000eDW-\\1\u000b\u0005-b\u0013\u0001B;uS2T!!\f\u0018\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0002\u0014a\u0002<feRL7-\u0019\u0006\u0002c\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u000e\u001e\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\r\u0005s\u0017PU3g!\tYD(D\u0001)\u0013\ti\u0004F\u0001\u000bTG\",W.\u0019+p_2\u001c\u0018J\u001c;fe\u001a\f7-Z\u0001\bGR$vn\u001c7t!\tY\u0004)\u0003\u0002BQ\t92i\\7qY\u0016DH+\u001f9fgN\u001b\u0007.Z7b)>|Gn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0011+\u0005CA\u001e\u0001\u0011\u001dq$\u0001%AA\u0002}\na\u0001\\8hO\u0016\u0014X#\u0001%\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015\u0001D:dC2\fGn\\4hS:<'BA'1\u0003!!\u0018\u0010]3tC\u001a,\u0017BA(K\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013aB;oW:|wO\\\u000b\u0002'B\u0011A+W\u0007\u0002+*\u0011akV\u0001\u0005Y\u0006twMC\u0001Y\u0003\u0011Q\u0017M^1\n\u0005i+&AB*ue&tw-\u0001\u0005v].twn\u001e8!\u0003%i\u0017\r\u001f7f]\u001e$\b.\u0001\u0006nCbdWM\\4uQ\u0002\n!\u0002\\8oO2,gn\u001a;i+\u0005\u0001\u0007CA\u001bb\u0013\t\u0011gGA\u0002J]R\f1\u0002\\8oO2,gn\u001a;iA\u0005\u00012m\\7qY\u0016DH+\u001f9f+RLGn]\u000b\u0002MB\u0011qM[\u0007\u0002Q*\u0011\u0011NK\u0001\bG>l\u0007\u000f\\3y\u0013\tY\u0007N\u0001\tD_6\u0004H.\u001a=UsB,W\u000b^5mg\u0006\t2m\\7qY\u0016DH+\u001f9f+RLGn\u001d\u0011\u0002\u001f\u0005$G\rR8vE2,\u0017+^8uKN$\"a\\=\u0011\u0005A<hBA9v!\t\u0011h'D\u0001t\u0015\t!('\u0001\u0004=e>|GOP\u0005\u0003mZ\na\u0001\u0015:fI\u00164\u0017B\u0001.y\u0015\t1h\u0007C\u0003{\u001b\u0001\u0007q.A\u0002tiJ\fqbZ3u\u0007\u0006$\u0018\r\\=tiRK\b/\u001a\u000b\u000e{\u0006-\u0012qFA\u001a\u0003o\t\t%!\u0012\u0011\u000fy\f\t!!\u0002\u0002\u00125\tqP\u0003\u0002,m%\u0019\u00111A@\u0003\r\u0015KG\u000f[3s!\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u0006U\u0005)QM\u001d:pe&!\u0011qBA\u0005\u0005-\u00196\r[3nC\u0016\u0013(o\u001c:\u0011\t\u0005M\u0011qE\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005)A/\u001f9fg*!\u00111DA\u000f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0004[\u0005}!\u0002BA\u0011\u0003G\ta!\u00199bG\",'BAA\u0013\u0003\ry'oZ\u0005\u0005\u0003S\t)B\u0001\u0005ECR\fG+\u001f9f\u0011\u0019\tiC\u0004a\u0001A\u000691/\u001d7UsB,\u0007BBA\u0019\u001d\u0001\u0007\u0001-A\u0005qe\u0016\u001c\u0017n]5p]\"1\u0011Q\u0007\bA\u0002\u0001\fQa]2bY\u0016Dq!!\u000f\u000f\u0001\u0004\tY$\u0001\u0004tS\u001etW\r\u001a\t\u0004k\u0005u\u0012bAA m\t9!i\\8mK\u0006t\u0007BBA\"\u001d\u0001\u0007q.\u0001\u0005usB,g.Y7f\u0011\u001d\t9E\u0004a\u0001\u0003\u0013\n\u0011b\u00195jY\u0012$UMZ:\u0011\r\u0005-\u0013QKA.\u001d\u0011\ti%!\u0015\u000f\u0007I\fy%C\u00018\u0013\r\t\u0019FN\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9&!\u0017\u0003\t1K7\u000f\u001e\u0006\u0004\u0003'2\u0004cA\u001e\u0002^%\u0019\u0011q\f\u0015\u0003\u0013\r{G.^7o\t\u00164\u0017!D4fiN#(/^2u)f\u0004X\rF\u0002~\u0003KBq!a\u001a\u0010\u0001\u0004\tI%\u0001\u0004gS\u0016dGm]\u0001\rO\u0016$\u0018I\u001d:bsRK\b/\u001a\u000b\u0005\u0003[\n)\bE\u0004\u007f\u0003\u0003\t)!a\u001c\u0011\t\u0005M\u0011\u0011O\u0005\u0005\u0003g\n)BA\u0005BeJ\f\u0017\u0010V=qK\"9\u0011q\u000f\tA\u0002\u0005%\u0013AC3mK6,g\u000e\u001e#fM\u0006Yr-\u001a;DCR\fG._:u)f\u0004XM\u0012:p[*#'m\u0019+za\u0016$B\"! \u0002\u0006\u0006\u001d\u0015\u0011RAF\u0003\u001b\u0003rA`A\u0001\u0003\u007f\n\t\u0002\u0005\u0003\u0002\b\u0005\u0005\u0015\u0002BAB\u0003\u0013\u0011\u0011$T5tg&twmU9m\u0007>tg/\u001a:tS>tWI\u001d:pe\"1\u0011QF\tA\u0002\u0001Da!!\r\u0012\u0001\u0004\u0001\u0007BBA\u001b#\u0001\u0007\u0001\rC\u0004\u0002:E\u0001\r!a\u000f\t\r\u0005\r\u0013\u00031\u0001p\u0003)\u0011X-\u00193TG\",W.\u0019\u000b\u0007\u0003'\u000bY,a4\u0011\r\u0005U\u0015qVA[\u001d\u0011\t9*a+\u000f\t\u0005e\u0015\u0011\u0016\b\u0005\u00037\u000b9K\u0004\u0003\u0002\u001e\u0006\u0015f\u0002BAP\u0003Gs1A]AQ\u0013\u0005\t\u0014BA\u00181\u0013\tic&\u0003\u0002,Y%\u0019\u00111\u0002\u0016\n\t\u00055\u0016\u0011B\u0001\u000e\u000bJ\u0014xN\u001d%b]\u0012d\u0017N\\4\n\t\u0005E\u00161\u0017\u0002\u0010\u0007>tg.Z2u_J\u0014Vm];mi*!\u0011QVA\u0005!\u0011\t\u0019\"a.\n\t\u0005e\u0016Q\u0003\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA_%\u0001\u0007\u0011qX\u0001\nU\u0012\u00147\rT1zKJ\u0004B!!1\u0002L6\u0011\u00111\u0019\u0006\u0005\u0003\u000b\f9-\u0001\u0003kI\n\u001c'bAAeY\u0005QA-\u0019;bg>,(oY3\n\t\u00055\u00171\u0019\u0002\u0013\u0015\u0012\u00147\rT1zKJLe\u000e^3sM\u0006\u001cW\rC\u0004\u0002RJ\u0001\r!a5\u0002\u0017Q\f'\r\\3T_V\u00148-\u001a\t\u0005\u0003+\fY.\u0004\u0002\u0002X*\u0019\u0011\u0011\u001c\u0017\u0002\r\r|gNZ5h\u0013\u0011\ti.a6\u0003\u0017Q\u000b'\r\\3T_V\u00148-Z\u0001\u000eO\u0016$8i\u001c7v[:LeNZ8\u0015\r\u0005\r\u00181^Aw!\u0019\t)*a,\u0002fB1\u00111JAt\u00037JA!!;\u0002Z\t\u00191+Z9\t\u000f\u0005u6\u00031\u0001\u0002@\"9\u0011\u0011[\nA\u0002\u0005M\u0017aG4fiZ+'\u000f^5dCRK\b/\u001a$s_6\u001c\u0006/\u0019:l)f\u0004X\r\u0006\u0006\u0002t\u0006e\u0018Q B\u0004\u0005\u0017\u0001R!!&\u0002v>LA!a>\u00024\na1k\u00195f[\u0006\u0014Vm];mi\"9\u00111 \u000bA\u0002\u0005E\u0011!C:qCJ\\G+\u001f9f\u0011\u001d\ty\u0010\u0006a\u0001\u0005\u0003\taa\u001d;sY\u0016t\u0007cA\u001b\u0003\u0004%\u0019!Q\u0001\u001c\u0003\t1{gn\u001a\u0005\b\u0005\u0013!\u0002\u0019\u0001B\u0001\u0003-\t'O]1z\u0019\u0016tw\r\u001e5\t\u000f\t5A\u00031\u0001\u0003\u0010\u0005AQ.\u001a;bI\u0006$\u0018\r\u0005\u0003\u0002\u0014\tE\u0011\u0002\u0002B\n\u0003+\u0011\u0001\"T3uC\u0012\fG/Y\u0001\u0015gB\f'o['baR{g+\u001a:uS\u000e\fW*\u00199\u0015\u0011\u0005M(\u0011\u0004B\u000f\u0005CAqAa\u0007\u0016\u0001\u0004\t\t\"A\u0004lKf$\u0016\u0010]3\t\u000f\t}Q\u00031\u0001\u0002\u0012\u0005Ia/\u00197vKRK\b/\u001a\u0005\b\u0003\u007f,\u0002\u0019\u0001B\u0001\u0003]\u0019\b/\u0019:l'R\u0014Xo\u0019;U_Z+'\u000f^5dCJ{w\u000f\u0006\u0005\u0002t\n\u001d\"Q\u0007B\u001c\u0011\u001d\t9G\u0006a\u0001\u0005S\u0001R!\u000eB\u0016\u0005_I1A!\f7\u0005\u0015\t%O]1z!\u0011\t\u0019B!\r\n\t\tM\u0012Q\u0003\u0002\f'R\u0014Xo\u0019;GS\u0016dG\rC\u0004\u0002\u0000Z\u0001\rA!\u0001\t\u000f\t%a\u00031\u0001\u0003\u0002\u0005A2\u000f]1sW\u0006\u0013(/Y=U_Z+'\u000f^5dC\u0006\u0013(/Y=\u0015\u0015\u0005M(Q\bB!\u0005\u0007\u0012)\u0005C\u0004\u0003@]\u0001\r!!\u0005\u0002\u0011\u0011\fG/\u0019+za\u0016Dq!a@\u0018\u0001\u0004\u0011\t\u0001C\u0004\u0003\n]\u0001\rA!\u0001\t\u000f\t5q\u00031\u0001\u0003\u0010\u0005\u00013\u000f]1sWB\u0013\u0018.\\5uSZ,Gk\u001c,feRL7-\u0019)sS6LG/\u001b<f)\u0019\t\u0019Pa\u0013\u0003N!9\u00111 \rA\u0002\u0005E\u0001bBA\u00001\u0001\u0007!\u0011A\u0001\u0012O\u0016$8i\u001c9z\u0007>dW/\u001c8MSN$H\u0003\u0003B*\u0005+\u00129F!\u0019\u0011\u000b\u0005U\u0015qV8\t\u000f\u0005u\u0016\u00041\u0001\u0002@\"9!\u0011L\rA\u0002\tm\u0013!\u0003;bE2,g*Y7f!\u0011\t)N!\u0018\n\t\t}\u0013q\u001b\u0002\n)\u0006\u0014G.\u001a(b[\u0016Da!K\rA\u0002\u0005U\u0016!E7bW\u0016\u001cu\u000e\\;n]N\u001cFO]5oOR)qNa\u001a\u0003l!9!\u0011\u000e\u000eA\u0002\u0005\u0015\u0018AC2pYVlg\u000eR3gg\"9!Q\u000e\u000eA\u0002\u0005U\u0016A\u0004:fcVL'/\u001a3TG\",W.Y\u0001\u0014[\u0006\\W\rV1cY\u0016\u001cu\u000e\\;n]\u0012+gm\u001d\u000b\t\u0005'\u0012\u0019H!\u001e\u0003x!1\u0011f\u0007a\u0001\u0003kCq!a@\u001c\u0001\u0004\u0011\t\u0001C\u0004\u0003\nm\u0001\rA!\u0001\u0002)\u001d,G/T3sO\u0016Len]3siZ\u000bG.^3t)!\u0011\u0019F! \u0003\u0000\t\u0005\u0005bBA_9\u0001\u0007\u0011q\u0018\u0005\b\u00053b\u0002\u0019\u0001B.\u0011\u001d\u0011\u0019\t\ba\u0001\u0005\u000b\u000babY8qs\u000e{G.^7o\u0019&\u001cH\u000fE\u00036\u0005\u000f\u0013Y)C\u0002\u0003\nZ\u0012aa\u00149uS>t\u0007\u0003BAk\u0005\u001bKAAa$\u0002X\nya+\u00197jI\u000e{G.^7o\u0019&\u001cH/A\u000bdQ\u0016\u001c7NV1mS\u0012$\u0016M\u00197f'\u000eDW-\\1\u0015\t\tU%Q\u0014\t\u0007\u0003+\u000byKa&\u0011\u0007U\u0012I*C\u0002\u0003\u001cZ\u0012A!\u00168ji\"1\u0011&\ba\u0001\u0003k\u000bQc\u00195fG.l\u0015\r]\"pYVlgn]*dQ\u0016l\u0017\r\u0006\u0003\u0003$\n-\u0006c\u0002@\u0002\u0002\t\u0015&q\u0013\t\u0005\u0003\u000f\u00119+\u0003\u0003\u0003*\u0006%!!C#se>\u0014H*[:u\u0011\u001d\u0011iK\ba\u0001\u0005_\u000bqbY8na2,\u0007\u0010V=qK\u000e{Gn\u001d\t\u0007\u0003\u0017\n)Fa\f\u00025\rDWmY6NCB\u001cuN\u001c;bS:\u001c\bK]5nSRLg/Z:\u0015\r\tU%Q\u0017B]\u0011\u0019\u00119l\ba\u0001_\u000691m\u001c7OC6,\u0007b\u0002B^?\u0001\u0007!QX\u0001\u0004[\u0006\u0004\b\u0003BA\n\u0005\u007fKAA!1\u0002\u0016\t9Q*\u00199UsB,\u0017\u0001F4fi6+'oZ3Va\u0012\fG/\u001a,bYV,7\u000f\u0006\u0006\u0003T\t\u001d'\u0011\u001aBf\u0005\u001fDq!!0!\u0001\u0004\ty\fC\u0004\u0003Z\u0001\u0002\rAa\u0017\t\u000f\t5\u0007\u00051\u0001\u0003\\\u0005iA/Z7q)\u0006\u0014G.\u001a(b[\u0016DqAa!!\u0001\u0004\u0011))A\nva\u0012\fG/\u001a$jK2$G)\u0019;b)f\u0004X\rF\u0006p\u0005+\u0014INa7\u0003^\n}\u0007B\u0002BlC\u0001\u0007q.A\u0002d_2DaAa.\"\u0001\u0004y\u0007BB\u0015\"\u0001\u0004\t)\fC\u0004\u0002\u0000\u0006\u0002\rA!\u0001\t\u000f\t%\u0011\u00051\u0001\u0003\u0002\u0005A\u0012N\u001c4fe\u0016CH/\u001a:oC2$\u0016M\u00197f'\u000eDW-\\1\u0015\u0019\tM#Q\u001dBu\u0005W\u0014iOa<\t\r\t\u001d(\u00051\u0001p\u0003]\u0019'/Z1uK\u0016CH/\u001a:oC2$\u0016M\u00197f'RlG\u000f\u0003\u0004*E\u0001\u0007\u0011Q\u0017\u0005\u0007\u00053\u0012\u0003\u0019A8\t\u000f\u0005}(\u00051\u0001\u0003\u0002!9!\u0011\u0002\u0012A\u0002\t\u0005\u0011aC*dQ\u0016l\u0017\rV8pYN\u0004\"a\u000f\u0013\u0014\u0005\u0011\"DC\u0001Bz\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q \u0016\u0004\u007f\t}8FAB\u0001!\u0011\u0019\u0019a!\u0004\u000e\u0005\r\u0015!\u0002BB\u0004\u0007\u0013\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r-a'\u0001\u0006b]:|G/\u0019;j_:LAaa\u0004\u0004\u0006\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class SchemaTools
implements SchemaToolsInterface {
    private final ComplexTypesSchemaTools ctTools;
    private final Logger logger;
    private final String unknown;
    private final String com$vertica$spark$util$schema$SchemaTools$$maxlength;
    private final int com$vertica$spark$util$schema$SchemaTools$$longlength;
    private final ComplexTypeUtils complexTypeUtils;

    public static ComplexTypesSchemaTools $lessinit$greater$default$1() {
        return SchemaTools$.MODULE$.$lessinit$greater$default$1();
    }

    private Logger logger() {
        return this.logger;
    }

    private String unknown() {
        return this.unknown;
    }

    public String com$vertica$spark$util$schema$SchemaTools$$maxlength() {
        return this.com$vertica$spark$util$schema$SchemaTools$$maxlength;
    }

    public int com$vertica$spark$util$schema$SchemaTools$$longlength() {
        return this.com$vertica$spark$util$schema$SchemaTools$$longlength;
    }

    private ComplexTypeUtils complexTypeUtils() {
        return this.complexTypeUtils;
    }

    public String com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(String str) {
        return new StringBuilder(2).append("\"").append(str).append("\"").toString();
    }

    private Either<SchemaError, DataType> getCatalystType(int sqlType, int precision, int scale, boolean signed, String typename, List<ColumnDef> childDefs) {
        Either<SchemaError, ArrayType> either;
        int n = sqlType;
        switch (n) {
            case 2003: {
                either = this.getArrayType(childDefs);
                break;
            }
            case 2002: {
                either = this.getStructType(childDefs);
                break;
            }
            default: {
                either = this.getCatalystTypeFromJdbcType(sqlType, precision, scale, signed, typename);
                break;
            }
        }
        return either;
    }

    private Either<SchemaError, DataType> getStructType(List<ColumnDef> fields2) {
        List fieldDefs = (List)fields2.map((Function1 & Serializable & scala.Serializable)colDef -> this.getCatalystType(colDef.jdbcType(), colDef.size(), colDef.scale(), colDef.signed(), colDef.colTypeName(), colDef.children()).map((Function1 & Serializable & scala.Serializable)dataType -> new StructField(colDef.label(), dataType, colDef.nullable(), colDef.metadata())), List$.MODULE$.canBuildFrom());
        return ErrorHandling$.MODULE$.listToEitherSchema(fieldDefs).map((Function1 & Serializable & scala.Serializable)fields -> StructType$.MODULE$.apply(fields));
    }

    private Either<SchemaError, ArrayType> getArrayType(List<ColumnDef> elementDef) {
        Left left;
        Option option = elementDef.headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            ColumnDef element = (ColumnDef)some.value();
            left = this.getCatalystType(element.jdbcType(), element.size(), element.scale(), element.signed(), element.colTypeName(), element.children()).map((Function1 & Serializable & scala.Serializable)elementType -> this.makeNestedArrays$1(element.metadata().getLong(MetadataKey$.MODULE$.DEPTH()), (DataType)elementType));
        } else if (None$.MODULE$.equals(option)) {
            left = package$.MODULE$.Left().apply((Object)new MissingElementTypeError());
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    public Either<MissingSqlConversionError, DataType> getCatalystTypeFromJdbcType(int sqlType, int precision, int scale, boolean signed, String typename) {
        BinaryType$ binaryType$;
        int n = sqlType;
        switch (n) {
            case -5: {
                if (signed) {
                    binaryType$ = LongType$.MODULE$;
                    break;
                }
                binaryType$ = new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 0);
                break;
            }
            case -2: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case -7: {
                binaryType$ = BooleanType$.MODULE$;
                break;
            }
            case 2004: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case 16: {
                binaryType$ = BooleanType$.MODULE$;
                break;
            }
            case 1: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2005: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 70: {
                binaryType$ = null;
                break;
            }
            case 91: {
                binaryType$ = DateType$.MODULE$;
                break;
            }
            case 3: {
                binaryType$ = new DecimalType(precision, scale);
                break;
            }
            case 2001: {
                binaryType$ = null;
                break;
            }
            case 8: {
                binaryType$ = DoubleType$.MODULE$;
                break;
            }
            case 6: {
                binaryType$ = FloatType$.MODULE$;
                break;
            }
            case 4: {
                if (signed) {
                    binaryType$ = IntegerType$.MODULE$;
                    break;
                }
                binaryType$ = LongType$.MODULE$;
                break;
            }
            case 2000: {
                binaryType$ = null;
                break;
            }
            case -16: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -4: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case -1: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2011: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 0: {
                binaryType$ = null;
                break;
            }
            case 2: {
                if (precision != 0 || scale != 0) {
                    binaryType$ = new DecimalType(precision, scale);
                    break;
                }
                binaryType$ = new DecimalType(DecimalType$.MODULE$.USER_DEFAULT().precision(), DecimalType$.MODULE$.USER_DEFAULT().scale());
                break;
            }
            case -9: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 1111: {
                String typenameNormalized = typename.toLowerCase();
                if (typenameNormalized.startsWith("interval") || typenameNormalized.startsWith("uuid")) {
                    binaryType$ = StringType$.MODULE$;
                    break;
                }
                binaryType$ = null;
                break;
            }
            case 7: {
                binaryType$ = DoubleType$.MODULE$;
                break;
            }
            case 2006: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -8: {
                binaryType$ = LongType$.MODULE$;
                break;
            }
            case 5: {
                binaryType$ = IntegerType$.MODULE$;
                break;
            }
            case 2009: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 92: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 93: {
                binaryType$ = TimestampType$.MODULE$;
                break;
            }
            case -6: {
                binaryType$ = IntegerType$.MODULE$;
                break;
            }
            case -3: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case 12: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            default: {
                binaryType$ = null;
                break;
            }
        }
        BinaryType$ answer = binaryType$;
        return answer == null ? package$.MODULE$.Left().apply((Object)new MissingSqlConversionError(((Object)BoxesRunTime.boxToInteger((int)sqlType)).toString(), typename)) : package$.MODULE$.Right().apply((Object)answer);
    }

    @Override
    public Either<ConnectorError, StructType> readSchema(JdbcLayerInterface jdbcLayer, TableSource tableSource) {
        Left left;
        Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tableSource);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq colInfo = (Seq)right.value();
            List errorsOrFields = ((TraversableOnce)colInfo.map((Function1 & Serializable & scala.Serializable)info -> this.getCatalystType(info.jdbcType(), info.size(), info.scale(), info.signed(), info.colTypeName(), info.children()).map((Function1 & Serializable & scala.Serializable)columnType -> new StructField(info.label(), columnType, info.nullable(), info.metadata())), Seq$.MODULE$.canBuildFrom())).toList();
            left = ((Validated)implicits$.MODULE$.toTraverseOps((Object)errorsOrFields, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$1 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$1), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)field -> StructType$.MODULE$.apply((Seq)field)).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, Seq<ColumnDef>> getColumnInfo(JdbcLayerInterface jdbcLayer, TableSource tableSource) {
        Left left;
        String string;
        TableSource tableSource2 = tableSource;
        if (tableSource2 instanceof TableName) {
            TableName tableName = (TableName)tableSource2;
            string = new StringBuilder(24).append("SELECT * FROM ").append(tableName.getFullTableName()).append(" WHERE 1=0").toString();
        } else if (tableSource2 instanceof TableQuery) {
            TableQuery tableQuery = (TableQuery)tableSource2;
            String query = tableQuery.query();
            string = new StringBuilder(31).append("SELECT * FROM (").append(query).append(") AS x WHERE 1=0").toString();
        } else {
            throw new MatchError((Object)tableSource2);
        }
        String emptyQuery = string;
        Either<ConnectorError, ResultSet> either = jdbcLayer.query(emptyQuery, jdbcLayer.query$default$2());
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
        } else if (either instanceof Right) {
            Left left3;
            Right right = (Right)either;
            try (ResultSet rs = (ResultSet)right.value();){
                try {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    List colDefsOrErrors = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), rsmd.getColumnCount()).map((Function1 & Serializable & scala.Serializable)idx -> SchemaTools.$anonfun$getColumnInfo$1(this, rsmd, tableSource, jdbcLayer, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
                    left3 = ((Validated)implicits$.MODULE$.toTraverseOps((Object)colDefsOrErrors, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$2 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$2), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)columnDef -> columnDef).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
                }
                catch (Throwable e) {
                    left3 = package$.MODULE$.Left().apply((Object)new DatabaseReadError(e).context("Could not get column info from Vertica"));
                }
            }
            left = left3;
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    @Override
    public Either<SchemaError, String> getVerticaTypeFromSparkType(DataType sparkType, long strlen, long arrayLength, Metadata metadata) {
        Either<SchemaError, String> either;
        DataType dataType = sparkType;
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            either = this.sparkMapToVerticaMap(keyType, valueType, strlen);
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            either = this.sparkStructToVerticaRow(fields, strlen, arrayLength);
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType sparkType2 = arrayType.elementType();
            either = this.sparkArrayToVerticaArray(sparkType2, strlen, arrayLength, metadata);
        } else {
            either = this.sparkPrimitiveToVerticaPrimitive(sparkType, strlen);
        }
        return either;
    }

    private Either<SchemaError, String> sparkMapToVerticaMap(DataType keyType, DataType valueType, long strlen) {
        Right right;
        Either<SchemaError, String> keyVerticaType = this.sparkPrimitiveToVerticaPrimitive(keyType, strlen);
        Either<SchemaError, String> valueVerticaType = this.sparkPrimitiveToVerticaPrimitive(valueType, strlen);
        if (keyVerticaType.isRight() && valueVerticaType.isRight()) {
            right = package$.MODULE$.Right().apply((Object)new StringBuilder(7).append("MAP<").append(keyVerticaType.right().get()).append(", ").append(valueVerticaType.right().get()).append(">").toString());
        } else {
            String string;
            String string2;
            Either<SchemaError, String> either = keyVerticaType;
            if (either instanceof Left) {
                Left left = (Left)either;
                SchemaError error = (SchemaError)left.value();
                string2 = error.getFullContext();
            } else if (either instanceof Right) {
                string2 = "None";
            } else {
                throw new MatchError(either);
            }
            String keyErrorMsg = string2;
            Either<SchemaError, String> either2 = valueVerticaType;
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                SchemaError error = (SchemaError)left.value();
                string = error.getFullContext();
            } else if (either2 instanceof Right) {
                string = "None";
            } else {
                throw new MatchError(either2);
            }
            String valueErrorMsg = string;
            right = package$.MODULE$.Left().apply((Object)new MapDataTypeConversionError(keyErrorMsg, valueErrorMsg));
        }
        return right;
    }

    private Either<SchemaError, String> sparkStructToVerticaRow(StructField[] fields, long strlen, long arrayLength) {
        Left left;
        Either<ConnectorError, String> either = this.makeTableColumnDefs(new StructType(fields), strlen, arrayLength);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new StructFieldsError(err));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            String fieldDefs = (String)right.value();
            left = package$.MODULE$.Right().apply((Object)new StringBuilder(3).append("ROW").append(fieldDefs.replace(" NOT NULL", "").trim()).toString());
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    private Either<SchemaError, String> sparkArrayToVerticaArray(DataType dataType, long strlen, long arrayLength, Metadata metadata) {
        String length = arrayLength <= 0L ? "" : new StringBuilder(1).append(",").append(arrayLength).toString();
        boolean isSet = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> metadata.getBoolean(MetadataKey$.MODULE$.IS_VERTICA_SET())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        String keyword = isSet ? "SET" : "ARRAY";
        return this.recursion$1(dataType, new StringBuilder(1).append(keyword).append("[").toString(), new StringBuilder(1).append(length).append("]").toString(), 0, keyword, length, strlen, arrayLength, metadata);
    }

    private Either<SchemaError, String> sparkPrimitiveToVerticaPrimitive(DataType sparkType, long strlen) {
        Right right;
        DataType dataType = sparkType;
        if (BinaryType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)new StringBuilder(11).append("VARBINARY(").append(this.com$vertica$spark$util$schema$SchemaTools$$longlength()).append(")").toString());
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"BOOLEAN");
        } else if (ByteType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"TINYINT");
        } else if (DateType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"DATE");
        } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"INTERVAL");
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            right = decimalType.precision() == 0 ? package$.MODULE$.Right().apply((Object)"DECIMAL") : package$.MODULE$.Right().apply((Object)new StringBuilder(11).append("DECIMAL(").append(decimalType.precision()).append(", ").append(decimalType.scale()).append(")").toString());
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"DOUBLE PRECISION");
        } else if (FloatType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"FLOAT");
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"INTEGER");
        } else if (LongType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"BIGINT");
        } else if (NullType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"null");
        } else if (ShortType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"SMALLINT");
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"TIMESTAMP");
        } else if (StringType$.MODULE$.equals(dataType)) {
            String vtype = strlen > (long)this.com$vertica$spark$util$schema$SchemaTools$$longlength() ? "LONG VARCHAR" : "VARCHAR";
            right = package$.MODULE$.Right().apply((Object)new StringBuilder(2).append(vtype).append("(").append(((Object)BoxesRunTime.boxToLong((long)strlen)).toString()).append(")").toString());
        } else {
            right = package$.MODULE$.Left().apply((Object)new MissingSparkPrimitivesConversionError(sparkType));
        }
        return right;
    }

    @Override
    public Either<ConnectorError, String> getCopyColumnList(JdbcLayerInterface jdbcLayer, TableName tableName, StructType schema) {
        return this.getColumnInfo(jdbcLayer, tableName).flatMap((Function1 & Serializable & scala.Serializable)columns -> {
            Right right;
            int colCount = columns.length();
            IntRef colsFound = IntRef.create((int)0);
            columns.foreach((Function1 & Serializable & scala.Serializable)column -> {
                SchemaTools.$anonfun$getCopyColumnList$2(this, schema, colsFound, tableName, column);
                return BoxedUnit.UNIT;
            });
            if (schema.length() > colCount) {
                right = package$.MODULE$.Left().apply((Object)new TableNotEnoughRowsError().context(new StringBuilder(187).append("Error: Number of columns in the target table should be greater or equal to number of columns in the DataFrame.  Number of columns in DataFrame: ").append(schema.length()).append(". Number of columns in the target table: ").append(tableName.getFullTableName()).append(": ").append(colCount).toString()));
            } else if (colsFound.elem == schema.length()) {
                BoxedUnit boxedUnit;
                ObjectRef columnList2 = ObjectRef.create((Object)"");
                BooleanRef first = BooleanRef.create((boolean)true);
                schema.foreach((Function1 & Serializable & scala.Serializable)s -> {
                    SchemaTools.$anonfun$getCopyColumnList$5(first, columnList2, s);
                    return BoxedUnit.UNIT;
                });
                columnList2.elem = new StringBuilder(3).append("(").append((String)columnList2.elem).append("\")").toString();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder(27).append("Load by name. Column list: ").append((String)columnList2.elem).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                right = package$.MODULE$.Right().apply((Object)((String)columnList2.elem));
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Load by Position");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                right = package$.MODULE$.Right().apply((Object)"");
            }
            return right.map((Function1 & Serializable & scala.Serializable)columnList -> columnList);
        });
    }

    @Override
    public String makeColumnsString(Seq<ColumnDef> columnDefs, StructType requiredSchema) {
        Seq requiredColumnDefs = requiredSchema.nonEmpty() ? (Seq)columnDefs.filter((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)SchemaTools.$anonfun$makeColumnsString$1(requiredSchema, cd))) : columnDefs;
        return ((TraversableOnce)requiredColumnDefs.map((Function1 & Serializable & scala.Serializable)info -> {
            String string;
            String colLabel = this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(info.label());
            int n = info.jdbcType();
            switch (n) {
                case 1111: {
                    String typenameNormalized = info.colTypeName().toLowerCase();
                    if (typenameNormalized.startsWith("interval") || typenameNormalized.startsWith("uuid")) {
                        string = (String)this.castToVarchar$1().apply((Object)info.label());
                        break;
                    }
                    string = colLabel;
                    break;
                }
                case 92: {
                    string = (String)this.castToVarchar$1().apply((Object)info.label());
                    break;
                }
                case 2003: {
                    boolean isSet = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> info.metadata().getBoolean(MetadataKey$.MODULE$.IS_VERTICA_SET())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                    if (isSet) {
                        string = this.castToArray$1((ColumnDef)info);
                        break;
                    }
                    string = colLabel;
                    break;
                }
                default: {
                    string = colLabel;
                    break;
                }
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    @Override
    public Either<ConnectorError, String> makeTableColumnDefs(StructType schema, long strlen, long arrayLength) {
        Left left;
        List colDefsOrErrors = ((TraversableOnce)schema.map((Function1 & Serializable & scala.Serializable)col -> {
            Left left;
            String colName = new StringBuilder(2).append("\"").append(col.name()).append("\"").toString();
            String notNull = !col.nullable() ? "NOT NULL" : "";
            Either<SchemaError, String> either = this.getVerticaTypeFromSparkType(col.dataType(), strlen, arrayLength, col.metadata());
            if (either instanceof Left) {
                Left left2 = (Left)either;
                SchemaError err = (SchemaError)left2.value();
                left = package$.MODULE$.Left().apply((Object)new SchemaConversionError(err).context("Schema error when trying to create table"));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                String colType = (String)right.value();
                left = package$.MODULE$.Right().apply((Object)new StringBuilder(2).append(colName).append(" ").append(colType).append(" ").append(notNull).toString().trim());
            } else {
                throw new MatchError(either);
            }
            return left;
        }, Seq$.MODULE$.canBuildFrom())).toList();
        Either result = ((Validated)implicits$.MODULE$.toTraverseOps((Object)colDefsOrErrors, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$3 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$3), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)columnDef -> columnDef).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
        Either either = result;
        if (either instanceof Right) {
            Right right = (Right)either;
            List colDefList = (List)right.value();
            left = package$.MODULE$.Right().apply((Object)new StringBuilder(3).append(" (").append(colDefList.mkString(", ")).append(")").toString());
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ErrorList err = (ErrorList)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, String> getMergeInsertValues(JdbcLayerInterface jdbcLayer, TableName tableName, Option<ValidColumnList> copyColumnList) {
        Left left;
        Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tableName);
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq info = (Seq)right.value();
            left = package$.MODULE$.Right().apply((Object)((TraversableOnce)info.map((Function1 & Serializable & scala.Serializable)x -> new StringBuilder(5).append("temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).toString(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
        } else {
            throw new MatchError(either);
        }
        Left valueList = left;
        return valueList;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> checkValidTableSchema(StructType schema) {
        Tuple2<List<StructField>, List<StructField>> tuple2 = this.complexTypeUtils().getComplexTypeColumns(schema);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List nativeCols = (List)tuple2._1();
        List complexTypeCols = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nativeCols, (Object)complexTypeCols);
        Tuple2 tuple23 = tuple22;
        List nativeCols2 = (List)tuple23._1();
        List complexTypeCols2 = (List)tuple23._2();
        return nativeCols2.isEmpty() ? (complexTypeCols2.nonEmpty() ? package$.MODULE$.Left().apply((Object)new InvalidTableSchemaComplexType()) : package$.MODULE$.Left().apply((Object)new EmptySchemaError())) : this.checkMapColumnsSchema((List<StructField>)complexTypeCols2);
    }

    private Either<ErrorList, BoxedUnit> checkMapColumnsSchema(List<StructField> complexTypeCols) {
        return ((Validated)implicits$.MODULE$.toTraverseOps(((List)complexTypeCols.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SchemaTools.$anonfun$checkMapColumnsSchema$1(x$5)))).map((Function1 & Serializable & scala.Serializable)col -> this.checkMapContainsPrimitives(col.name(), (MapType)col.dataType()), List$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$6 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$6), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)x$7 -> {
            SchemaTools.$anonfun$checkMapColumnsSchema$5(x$7);
            return BoxedUnit.UNIT;
        }).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
    }

    private Either<ConnectorError, BoxedUnit> checkMapContainsPrimitives(String colName, MapType map) {
        Either<SchemaError, String> keyType = this.sparkPrimitiveToVerticaPrimitive(map.keyType(), 0L);
        Either<SchemaError, String> valueType = this.sparkPrimitiveToVerticaPrimitive(map.valueType(), 0L);
        return keyType.isRight() && valueType.isRight() ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)new InvalidMapSchemaError(colName));
    }

    @Override
    public Either<ConnectorError, String> getMergeUpdateValues(JdbcLayerInterface jdbcLayer, TableName tableName, TableName tempTableName, Option<ValidColumnList> copyColumnList) {
        Left left;
        Option<ValidColumnList> option = copyColumnList;
        if (option instanceof Some) {
            Left colList;
            Left left2;
            Some some = (Some)option;
            ValidColumnList list = (ValidColumnList)some.value();
            List customColList = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])list.toString().split(","))).toList().map((Function1 & Serializable & scala.Serializable)col -> col.trim(), List$.MODULE$.canBuildFrom());
            Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tempTableName);
            if (either instanceof Right) {
                Right right = (Right)either;
                Seq info = (Seq)right.value();
                List tupleList = (List)customColList.zip((GenIterable)info, List$.MODULE$.canBuildFrom());
                left2 = package$.MODULE$.Right().apply((Object)((TraversableOnce)tupleList.map((Function1 & Serializable & scala.Serializable)x -> new StringBuilder(6).append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes((String)x._1())).append("=temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(((ColumnDef)x._2()).label())).toString(), List$.MODULE$.canBuildFrom())).mkString(", "));
            } else if (either instanceof Left) {
                Left left3 = (Left)either;
                ConnectorError err = (ConnectorError)left3.value();
                left2 = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
            } else {
                throw new MatchError(either);
            }
            left = colList = left2;
        } else if (None$.MODULE$.equals(option)) {
            Left updateList;
            Left left4;
            Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tempTableName);
            if (either instanceof Right) {
                Right right = (Right)either;
                Seq info = (Seq)right.value();
                left4 = package$.MODULE$.Right().apply((Object)((TraversableOnce)info.map((Function1 & Serializable & scala.Serializable)x -> new StringBuilder(6).append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).append("=temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).toString(), Seq$.MODULE$.canBuildFrom())).mkString(", "));
            } else if (either instanceof Left) {
                Left left5 = (Left)either;
                ConnectorError err = (ConnectorError)left5.value();
                left4 = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
            } else {
                throw new MatchError(either);
            }
            left = updateList = left4;
        } else {
            throw new MatchError(option);
        }
        Left columnList = left;
        return columnList;
    }

    public String updateFieldDataType(String col, String colName, StructType schema, long strlen, long arrayLength) {
        Seq fieldType = (Seq)schema.collect((PartialFunction)new scala.Serializable(this, colName, strlen, arrayLength){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchemaTools $outer;
            private final String colName$1;
            private final long strlen$3;
            private final long arrayLength$3;

            /*
             * Unable to fully structure code
             */
            public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> default) {
                block9: {
                    block6: {
                        block8: {
                            block7: {
                                var5_3 = x1;
                                v0 = this.$outer.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(var5_3.name());
                                var6_4 = this.colName$1;
                                if (v0 != null ? v0.equals(var6_4) == false : var6_4 != null) break block6;
                                if (!var5_3.metadata().contains(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())) break block7;
                                v1 = var5_3.dataType().simpleString();
                                var7_5 = "string";
                                if (v1 != null ? v1.equals(var7_5) == false : var7_5 != null) break block7;
                                v2 = var5_3.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength()) > (long)this.$outer.com$vertica$spark$util$schema$SchemaTools$$longlength() ? new StringBuilder(14).append("long varchar(").append(BoxesRunTime.boxToLong((long)var5_3.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())).toString()).append(")").toString() : new StringBuilder(9).append("varchar(").append(BoxesRunTime.boxToLong((long)var5_3.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())).toString()).append(")").toString();
                                break block8;
                            }
                            if (!var5_3.metadata().contains(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())) ** GOTO lbl-1000
                            v3 = var5_3.dataType().simpleString();
                            var8_6 = "binary";
                            if (!(v3 != null ? v3.equals(var8_6) == false : var8_6 != null)) {
                                v2 = new StringBuilder(11).append("varbinary(").append(BoxesRunTime.boxToLong((long)var5_3.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())).toString()).append(")").toString();
                            } else lbl-1000:
                            // 2 sources

                            {
                                if ((var9_7 = this.$outer.getVerticaTypeFromSparkType(var5_3.dataType(), this.strlen$3, this.arrayLength$3, var5_3.metadata())) instanceof Right) {
                                    var10_8 = (Right)var9_7;
                                    var4_10 = dataType = (String)var10_8.value();
                                } else if (var9_7 instanceof Left) {
                                    var12_11 = (Left)var9_7;
                                    err = (SchemaError)var12_11.value();
                                    var4_10 = package$.MODULE$.Left().apply((Object)err);
                                } else {
                                    throw new MatchError(var9_7);
                                }
                                v2 = var4_10;
                            }
                        }
                        var3_13 = v2;
                        break block9;
                    }
                    var3_13 = default.apply(x1);
                }
                return (B1)var3_13;
            }

            public final boolean isDefinedAt(StructField x1) {
                StructField structField = x1;
                String string = this.$outer.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(structField.name());
                String string2 = this.colName$1;
                boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.colName$1 = colName$1;
                this.strlen$3 = strlen$3;
                this.arrayLength$3 = arrayLength$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return fieldType.nonEmpty() ? new StringBuilder(1).append(colName).append(" ").append(fieldType.head()).toString() : col;
    }

    @Override
    public Either<ConnectorError, String> inferExternalTableSchema(String createExternalTableStmt, StructType schema, String tableName, long strlen, long arrayLength) {
        Right right;
        int indexOfClosingParantheses;
        int indexOfOpeningParantheses;
        String stmt = createExternalTableStmt.replace(new StringBuilder(2).append("\"").append(tableName).append("\"").toString(), tableName);
        String schemaString = stmt.substring((indexOfOpeningParantheses = stmt.indexOf("(")) + 1, indexOfClosingParantheses = stmt.indexOf(")"));
        List schemaList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schemaString.split(","))).toList();
        String updatedSchema = ((TraversableOnce)schemaList.map((Function1 & Serializable & scala.Serializable)col -> {
            int indexOfFirstDoubleQuote = col.indexOf("\"");
            int indexOfSpace = col.indexOf(" ", indexOfFirstDoubleQuote);
            String colName = col.substring(indexOfFirstDoubleQuote, indexOfSpace);
            return schema.nonEmpty() ? this.updateFieldDataType((String)col, colName, schema, strlen, arrayLength) : (col.toLowerCase().contains("varchar") ? new StringBuilder(10).append(colName).append(" varchar(").append(strlen).append(")").toString() : (col.toLowerCase().contains("varbinary") ? new StringBuilder(12).append(colName).append(" varbinary(").append(this.com$vertica$spark$util$schema$SchemaTools$$longlength()).append(")").toString() : col));
        }, List$.MODULE$.canBuildFrom())).mkString(",");
        if (updatedSchema.contains(this.unknown())) {
            right = package$.MODULE$.Left().apply((Object)new UnknownColumnTypesError().context(new StringBuilder(30).append(this.unknown()).append(" partitioned column data type.").toString()));
        } else {
            BoxedUnit boxedUnit;
            String updatedCreateTableStmt = stmt.replace(schemaString, updatedSchema);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder(41).append("Updated create external table statement: ").append(updatedCreateTableStmt).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            right = package$.MODULE$.Right().apply((Object)updatedCreateTableStmt);
        }
        return right;
    }

    private final ArrayType makeNestedArrays$1(long arrayDepth, DataType arrayElement) {
        while (arrayDepth > 0L) {
            arrayElement = ArrayType$.MODULE$.apply(arrayElement);
            --arrayDepth;
        }
        return ArrayType$.MODULE$.apply(arrayElement);
    }

    public static final /* synthetic */ Either $anonfun$getColumnInfo$1(SchemaTools $this, ResultSetMetaData rsmd$1, TableSource tableSource$1, JdbcLayerInterface jdbcLayer$1, int idx) {
        Right right;
        String columnLabel = rsmd$1.getColumnLabel(idx);
        String typeName = rsmd$1.getColumnTypeName(idx);
        int fieldSize = DecimalType$.MODULE$.MAX_PRECISION();
        int fieldScale = rsmd$1.getScale(idx);
        boolean isSigned = rsmd$1.isSigned(idx);
        boolean nullable = rsmd$1.isNullable(idx) != 0;
        Metadata metadata = new MetadataBuilder().putString(MetadataKey$.MODULE$.NAME(), columnLabel).build();
        int colType = rsmd$1.getColumnType(idx);
        ColumnDef colDef = new ColumnDef(columnLabel, colType, typeName, fieldSize, fieldScale, isSigned, nullable, metadata, ColumnDef$.MODULE$.apply$default$9());
        TableSource tableSource = tableSource$1;
        if (tableSource instanceof TableName) {
            Either<ConnectorError, ColumnDef> either;
            TableName tableName = (TableName)tableSource;
            String unQuotedName = tableName.getTableName().replaceAll("\"", "");
            String unQuotedDbSchema = tableName.getDbSchema().replaceAll("\"", "");
            int n = colType;
            switch (n) {
                case 2002: 
                case 2003: {
                    either = $this.ctTools.startQueryingVerticaComplexTypes(colDef, unQuotedName, unQuotedDbSchema, jdbcLayer$1);
                    break;
                }
                default: {
                    either = package$.MODULE$.Right().apply((Object)colDef);
                    break;
                }
            }
            right = either;
        } else if (tableSource instanceof TableQuery) {
            Right right2;
            TableQuery tableQuery = (TableQuery)tableSource;
            int n = colType;
            switch (n) {
                case 2002: 
                case 2003: {
                    right2 = package$.MODULE$.Left().apply((Object)new QueryReturnsComplexTypes(columnLabel, typeName, tableQuery.query()));
                    break;
                }
                default: {
                    right2 = package$.MODULE$.Right().apply((Object)colDef);
                    break;
                }
            }
            right = right2;
        } else {
            throw new MatchError((Object)tableSource);
        }
        return right;
    }

    private final Either recursion$1(DataType dataType, String leftAccumulator, String rightAccumulator, int depth, String keyword$1, String length$1, long strlen$1, long arrayLength$1, Metadata metadata$1) {
        Left left;
        DataType dataType2;
        while ((dataType2 = dataType) instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            ++depth;
            rightAccumulator = new StringBuilder(1).append(length$1).append("]").append(rightAccumulator).toString();
            leftAccumulator = new StringBuilder(1).append(leftAccumulator).append(keyword$1).append("[").toString();
            dataType = elementType;
        }
        Either<SchemaError, String> either = this.getVerticaTypeFromSparkType(dataType, strlen$1, arrayLength$1, metadata$1);
        if (either instanceof Right) {
            Right right = (Right)either;
            String verticaType = (String)right.value();
            left = package$.MODULE$.Right().apply((Object)new StringBuilder(0).append(leftAccumulator).append(verticaType).append(rightAccumulator).toString());
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            SchemaError error = (SchemaError)left2.value();
            left = package$.MODULE$.Left().apply((Object)error);
        } else {
            throw new MatchError(either);
        }
        Left left3 = left;
        return left3;
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$4(SchemaTools $this, ColumnDef column$1, IntRef colsFound$1, TableName tableName$1, StructField s) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(48).append("Comparing target table column: ").append(column$1.label()).append(" with DF column: ").append(s.name()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (s.name().equalsIgnoreCase(column$1.label())) {
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            ++colsFound$1.elem;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug(new StringBuilder(37).append("Column: ").append(s.name()).append(" found in target table and DF").toString());
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            if (!column$1.nullable()) {
                if (s.nullable()) {
                    if ($this.logger().underlying().isWarnEnabled()) {
                        $this.logger().underlying().warn(new StringBuilder(128).append("S2V: Column ").append(s.name()).append(" is NOT NULL in target table ").append(tableName$1.getFullTableName()).append(" but it's nullable in the DataFrame. Rows with NULL values in column ").append(s.name()).append(" will be rejected.").toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw Breaks$.MODULE$.break();
        }
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$2(SchemaTools $this, StructType schema$1, IntRef colsFound$1, TableName tableName$1, ColumnDef column) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(43).append("Will check that target column: ").append(column.label()).append(" exist in DF").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> schema$1.foreach((Function1 & Serializable & scala.Serializable)s -> {
            SchemaTools.$anonfun$getCopyColumnList$4($this, column, colsFound$1, tableName$1, s);
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$5(BooleanRef first$1, ObjectRef columnList$1, StructField s) {
        if (first$1.elem) {
            columnList$1.elem = new StringBuilder(1).append("\"").append(s.name()).toString();
            first$1.elem = false;
        } else {
            columnList$1.elem = new StringBuilder(3).append((String)columnList$1.elem).append("\",\"").append(s.name()).toString();
        }
    }

    public static final /* synthetic */ boolean $anonfun$makeColumnsString$2(ColumnDef cd$1, StructField field) {
        String string = field.name();
        String string2 = cd$1.label();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$makeColumnsString$1(StructType requiredSchema$1, ColumnDef cd) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema$1.fields())).exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SchemaTools.$anonfun$makeColumnsString$2(cd, field)));
    }

    private final Function1 castToVarchar$1() {
        return (Function1 & Serializable & scala.Serializable)colName -> new StringBuilder(13).append((String)colName).append("::varchar AS ").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes((String)colName)).toString();
    }

    private final String castToArray$1(ColumnDef colInfo) {
        String string;
        String colName = this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(colInfo.label());
        Option option = colInfo.children().headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            ColumnDef element = (ColumnDef)some.value();
            string = new StringBuilder(15).append("(").append(colName).append("::ARRAY[").append(element.colTypeName()).append("]) as ").append(colName).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(22).append("(").append(colName).append("::ARRAY[UNKNOWN]) as ").append(colName).toString();
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$checkMapColumnsSchema$1(StructField x$5) {
        return x$5.dataType() instanceof MapType;
    }

    public static final /* synthetic */ void $anonfun$checkMapColumnsSchema$5(List x$7) {
    }

    public SchemaTools(ComplexTypesSchemaTools ctTools) {
        this.ctTools = ctTools;
        this.logger = LogProvider$.MODULE$.getLogger(SchemaTools.class);
        this.unknown = "UNKNOWN";
        this.com$vertica$spark$util$schema$SchemaTools$$maxlength = "maxlength";
        this.com$vertica$spark$util$schema$SchemaTools$$longlength = 65000;
        this.complexTypeUtils = new ComplexTypeUtils();
    }
}

