/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.json;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.DistributedFilesystemReadConfig;
import com.vertica.spark.config.FileStoreConfig;
import com.vertica.spark.config.JDBCConfig;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.ReadConfig;
import com.vertica.spark.config.TableSource;
import com.vertica.spark.config.ValidFilePermissions;
import com.vertica.spark.config.VerticaReadMetadata;
import com.vertica.spark.datasource.core.DSConfigSetupInterface;
import com.vertica.spark.datasource.core.PartitionInfo;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.json.JsonBatchFactory;
import com.vertica.spark.datasource.v2.VerticaScan;
import com.vertica.spark.util.cleanup.CleanupUtils;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.ErrorHandling$;
import com.vertica.spark.util.error.InitialSetupPartitioningError;
import java.io.Serializable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.streaming.ContinuousStream;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\b\u0011\u0001mA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u001d1\u0006A1A\u0005\n]Ca\u0001\u0019\u0001!\u0002\u0013A\u0006bB1\u0001\u0005\u0004%IA\u0019\u0005\u0007G\u0002\u0001\u000b\u0011B\u001c\t\u0011\u0011\u0004\u0001R1A\u0005\n\u0015DQA\u001a\u0001\u0005B\u001dDQA\u001c\u0001\u0005B=DQ!\u001f\u0001\u0005BiDQA \u0001\u0005B}\u0014qBV3si&\u001c\u0017MS:p]N\u001b\u0017M\u001c\u0006\u0003#I\tAA[:p]*\u00111\u0003F\u0001\u000bI\u0006$\u0018m]8ve\u000e,'BA\u000b\u0017\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0002$A\u0004wKJ$\u0018nY1\u000b\u0003e\t1aY8n\u0007\u0001\u0019B\u0001\u0001\u000f%gA\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0005Y\u0006twMC\u0001\"\u0003\u0011Q\u0017M^1\n\u0005\rr\"AB(cU\u0016\u001cG\u000f\u0005\u0002&c5\taE\u0003\u0002(Q\u0005!!/Z1e\u0015\tI#&A\u0005d_:tWm\u0019;pe*\u00111\u0006L\u0001\u0004gFd'BA\u000b.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005I2#\u0001B*dC:\u0004\"!\n\u001b\n\u0005U2#!\u0002\"bi\u000eD\u0017AB2p]\u001aLw\r\u0005\u00029u5\t\u0011H\u0003\u00027)%\u00111(\u000f\u0002\u000b%\u0016\fGmQ8oM&<\u0017a\u0004:fC\u0012\u001cuN\u001c4jON+G/\u001e9\u0011\u0007y\nu'D\u0001@\u0015\t\u0001%#\u0001\u0003d_J,\u0017B\u0001\"@\u0005Y!5kQ8oM&<7+\u001a;va&sG/\u001a:gC\u000e,\u0017\u0001\u00042bi\u000eDg)Y2u_JL\bCA#G\u001b\u0005\u0001\u0012BA$\u0011\u0005AQ5o\u001c8CCR\u001c\u0007NR1di>\u0014\u00180A\u0004gg2\u000b\u00170\u001a:\u0011\u0005)kU\"A&\u000b\u00051\u0013\u0012A\u00014t\u0013\tq5JA\fGS2,7\u000b^8sK2\u000b\u00170\u001a:J]R,'OZ1dK\u00061A(\u001b8jiz\"R!\u0015*T)V\u0003\"!\u0012\u0001\t\u000bY*\u0001\u0019A\u001c\t\u000bq*\u0001\u0019A\u001f\t\u000b\r+\u0001\u0019\u0001#\t\u000b!+\u0001\u0019A%\u0002\r1|wmZ3s+\u0005A\u0006CA-_\u001b\u0005Q&BA.]\u00031\u00198-\u00197bY><w-\u001b8h\u0015\ti\u0006$\u0001\u0005usB,7/\u00194f\u0013\ty&L\u0001\u0004M_\u001e<WM]\u0001\bY><w-\u001a:!\u00039Q7o\u001c8SK\u0006$7i\u001c8gS\u001e,\u0012aN\u0001\u0010UN|gNU3bI\u000e{gNZ5hA\u0005)!-\u0019;dQV\t1'\u0001\u0006sK\u0006$7k\u00195f[\u0006$\u0012\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0003W*\nQ\u0001^=qKNL!!\u001c6\u0003\u0015M#(/^2u)f\u0004X-A\nqY\u0006t\u0017J\u001c9viB\u000b'\u000f^5uS>t7\u000fF\u0001q!\r\tHO^\u0007\u0002e*\t1/A\u0003tG\u0006d\u0017-\u0003\u0002ve\n)\u0011I\u001d:bsB\u0011Qe^\u0005\u0003q\u001a\u0012a\"\u00138qkR\u0004\u0016M\u001d;ji&|g.A\nde\u0016\fG/\u001a*fC\u0012,'OR1di>\u0014\u0018\u0010F\u0001|!\t)C0\u0003\u0002~M\t1\u0002+\u0019:uSRLwN\u001c*fC\u0012,'OR1di>\u0014\u00180A\u0004u_\n\u000bGo\u00195\u0015\u0003M\u0002")
public class VerticaJsonScan
implements Scan,
Batch {
    private Batch batch;
    private final ReadConfig config;
    private final DSConfigSetupInterface<ReadConfig> readConfigSetup;
    private final JsonBatchFactory batchFactory;
    private final FileStoreLayerInterface fsLayer;
    private final Logger logger;
    private final ReadConfig jsonReadConfig;
    private volatile boolean bitmap$0;

    public String description() {
        return super.description();
    }

    public MicroBatchStream toMicroBatchStream(String x$1) {
        return super.toMicroBatchStream(x$1);
    }

    public ContinuousStream toContinuousStream(String x$1) {
        return super.toContinuousStream(x$1);
    }

    public CustomMetric[] supportedCustomMetrics() {
        return super.supportedCustomMetrics();
    }

    private Logger logger() {
        return this.logger;
    }

    private ReadConfig jsonReadConfig() {
        return this.jsonReadConfig;
    }

    private Batch batch$lzycompute() {
        VerticaJsonScan verticaJsonScan = this;
        synchronized (verticaJsonScan) {
            if (!this.bitmap$0) {
                Batch batch;
                Either<ConnectorError, Option<PartitionInfo>> either = this.readConfigSetup.performInitialSetup(this.jsonReadConfig());
                if (either instanceof Left) {
                    Left left = (Left)either;
                    ConnectorError err = (ConnectorError)left.value();
                    throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), err);
                }
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Option opt = (Option)right.value();
                    Option option = opt;
                    if (None$.MODULE$.equals(option)) {
                        throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), new InitialSetupPartitioningError());
                    }
                    if (!(option instanceof Some)) {
                        throw new MatchError((Object)option);
                    }
                    Some some = (Some)option;
                    PartitionInfo partitionInfo = (PartitionInfo)some.value();
                    SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> ErrorHandling$.MODULE$.logAndThrowError(this.logger(), new InitialSetupPartitioningError()));
                    Batch batch2 = this.batchFactory.build(partitionInfo.rootPath(), (Option<StructType>)new Some((Object)this.readSchema()), this.jsonReadConfig(), sparkSession);
                    Seq files = (Seq)this.fsLayer.getFileList(partitionInfo.rootPath()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ErrorHandling$.MODULE$.logAndThrowError(this.logger(), new InitialSetupPartitioningError()));
                    Either<ConnectorError, BoxedUnit> either2 = files.isEmpty() ? new CleanupUtils().cleanupAll(this.fsLayer, partitionInfo.rootPath()) : BoxedUnit.UNIT;
                    batch = batch2;
                } else {
                    throw new MatchError(either);
                }
                Batch batch3 = batch;
                this.batch = batch3;
                this.bitmap$0 = true;
            }
        }
        return this.batch;
    }

    private Batch batch() {
        return !this.bitmap$0 ? this.batch$lzycompute() : this.batch;
    }

    public StructType readSchema() {
        StructType requiredSchema;
        Either either;
        block5: {
            Either either2;
            Tuple2 tuple2;
            block4: {
                tuple2 = new Tuple2(this.readConfigSetup.getTableSchema(this.config), (Object)this.jsonReadConfig().getRequiredSchema());
                if (tuple2 == null) break block4;
                either = (Either)tuple2._1();
                requiredSchema = (StructType)tuple2._2();
                if (either instanceof Right) break block5;
            }
            if (tuple2 != null && (either2 = (Either)tuple2._1()) instanceof Left) {
                Left left = (Left)either2;
                ConnectorError err = (ConnectorError)left.value();
                throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), err);
            }
            throw new MatchError((Object)tuple2);
        }
        Right right = (Right)either;
        StructType schema = (StructType)right.value();
        StructType structType = requiredSchema.nonEmpty() ? requiredSchema : schema;
        return structType;
    }

    public InputPartition[] planInputPartitions() {
        return this.batch().planInputPartitions();
    }

    public PartitionReaderFactory createReaderFactory() {
        return this.batch().createReaderFactory();
    }

    public Batch toBatch() {
        return this;
    }

    public VerticaJsonScan(ReadConfig config, DSConfigSetupInterface<ReadConfig> readConfigSetup, JsonBatchFactory batchFactory, FileStoreLayerInterface fsLayer) {
        ReadConfig readConfig;
        this.config = config;
        this.readConfigSetup = readConfigSetup;
        this.batchFactory = batchFactory;
        this.fsLayer = fsLayer;
        this.logger = LogProvider$.MODULE$.getLogger(VerticaScan.class);
        ReadConfig readConfig2 = config;
        if (readConfig2 instanceof DistributedFilesystemReadConfig) {
            DistributedFilesystemReadConfig distributedFilesystemReadConfig = (DistributedFilesystemReadConfig)readConfig2;
            boolean x$1 = true;
            JDBCConfig x$2 = distributedFilesystemReadConfig.copy$default$1();
            FileStoreConfig x$3 = distributedFilesystemReadConfig.copy$default$2();
            TableSource x$4 = distributedFilesystemReadConfig.copy$default$3();
            Option<Object> x$5 = distributedFilesystemReadConfig.copy$default$4();
            Option<VerticaReadMetadata> x$6 = distributedFilesystemReadConfig.copy$default$5();
            ValidFilePermissions x$7 = distributedFilesystemReadConfig.copy$default$6();
            int x$8 = distributedFilesystemReadConfig.copy$default$7();
            int x$9 = distributedFilesystemReadConfig.copy$default$8();
            boolean x$10 = distributedFilesystemReadConfig.copy$default$9();
            DistributedFilesystemReadConfig copied = distributedFilesystemReadConfig.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$1);
            copied.setGroupBy(distributedFilesystemReadConfig.getGroupBy());
            copied.setPushdownAgg(distributedFilesystemReadConfig.isAggPushedDown());
            copied.setPushdownFilters(distributedFilesystemReadConfig.getPushdownFilters());
            copied.setRequiredSchema(distributedFilesystemReadConfig.getRequiredSchema());
            readConfig = copied;
        } else {
            readConfig = config;
        }
        this.jsonReadConfig = readConfig;
    }
}

