/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.query;

import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.query.ColumnInfo;
import com.vertica.spark.util.query.VerticaTable;
import java.sql.ResultSet;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u000154A\u0001C\u0005\u0001)!AA\u0004\u0001B\u0001B\u0003%Q\u0004C\u0003&\u0001\u0011\u0005a\u0005C\u0003*\u0001\u0011\u0005#\u0006C\u00039\u0001\u0011\u0005\u0013\bC\u0003D\u0001\u0011\u0005C\tC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0003T\u0001\u0011\u0005AK\u0001\u0007D_2,XN\\:UC\ndWM\u0003\u0002\u000b\u0017\u0005)\u0011/^3ss*\u0011A\"D\u0001\u0005kRLGN\u0003\u0002\u000f\u001f\u0005)1\u000f]1sW*\u0011\u0001#E\u0001\bm\u0016\u0014H/[2b\u0015\u0005\u0011\u0012aA2p[\u000e\u00011C\u0001\u0001\u0016!\r1r#G\u0007\u0002\u0013%\u0011\u0001$\u0003\u0002\r-\u0016\u0014H/[2b)\u0006\u0014G.\u001a\t\u0003-iI!aG\u0005\u0003\u0015\r{G.^7o\u0013:4w.A\u0005kI\n\u001cG*Y=feB\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0005U\u0012\u00147M\u0003\u0002#\u001b\u0005QA-\u0019;bg>,(oY3\n\u0005\u0011z\"A\u0005&eE\u000ed\u0015-_3s\u0013:$XM\u001d4bG\u0016\fa\u0001P5oSRtDCA\u0014)!\t1\u0002\u0001C\u0003\u001d\u0005\u0001\u0007Q$A\u0005uC\ndWMT1nKV\t1\u0006\u0005\u0002-k9\u0011Qf\r\t\u0003]Ej\u0011a\f\u0006\u0003aM\ta\u0001\u0010:p_Rt$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n\u0014A\u0002)sK\u0012,g-\u0003\u00027o\t11\u000b\u001e:j]\u001eT!\u0001N\u0019\u0002\u000f\r|G.^7ogV\t!\bE\u0002<\u0001.r!\u0001\u0010 \u000f\u00059j\u0014\"\u0001\u001a\n\u0005}\n\u0014a\u00029bG.\fw-Z\u0005\u0003\u0003\n\u00131aU3r\u0015\ty\u0014'\u0001\u0005ck&dGMU8x)\tIR\tC\u0003G\u000b\u0001\u0007q)A\u0005sKN,H\u000e^*fiB\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\u0004gFd'\"\u0001'\u0002\t)\fg/Y\u0005\u0003\u001d&\u0013\u0011BU3tk2$8+\u001a;\u0002\u0017\u001d,G\u000fV=qK:\u000bW.\u001a\u000b\u0003WECQA\u0015\u0004A\u0002-\n\u0001\u0002Z1uCRK\b/Z\u0001\u000eO\u0016$8i\u001c7v[:LeNZ8\u0015\tUC'n\u001b\t\u0004-\u0016LbBA,c\u001d\tA\u0006M\u0004\u0002Z?:\u0011!L\u0018\b\u00037vs!A\f/\n\u0003II!\u0001E\t\n\u00059y\u0011B\u0001\u0007\u000e\u0013\t\t7\"A\u0003feJ|'/\u0003\u0002dI\u0006iQI\u001d:pe\"\u000bg\u000e\u001a7j]\u001eT!!Y\u0006\n\u0005\u0019<'aD\"p]:,7\r^8s%\u0016\u001cX\u000f\u001c;\u000b\u0005\r$\u0007\"B5\b\u0001\u0004Y\u0013AC2pYVlgNT1nK\")\u0011f\u0002a\u0001W!)An\u0002a\u0001W\u000511o\u00195f[\u0006\u0004")
public class ColumnsTable
extends VerticaTable<ColumnInfo> {
    @Override
    public String tableName() {
        return "columns";
    }

    @Override
    public Seq<String> columns() {
        return new .colon.colon((Object)"data_type_id", (List)new .colon.colon((Object)"data_type", (List)new .colon.colon((Object)"numeric_precision", (List)new .colon.colon((Object)"numeric_scale", (List)Nil$.MODULE$))));
    }

    @Override
    public ColumnInfo buildRow(ResultSet resultSet) {
        return new ColumnInfo(resultSet.getLong("data_type_id"), this.getTypeName(resultSet.getString("data_type")), resultSet.getLong("numeric_precision"), resultSet.getLong("numeric_scale"));
    }

    public String getTypeName(String dataType) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(dataType.replaceFirst("\\[", ",").replaceFirst("\\(", ","))).split(','))).head();
    }

    public Either<ConnectorError, ColumnInfo> getColumnInfo(String columnName, String tableName, String schema) {
        String schemaCond = new StringOps(Predef$.MODULE$.augmentString(schema)).nonEmpty() ? new StringBuilder(20).append(" AND table_schema='").append(schema).append("'").toString() : "";
        String conditions = new StringBuilder(32).append("table_name='").append(tableName).append("'").append(schemaCond).append(" AND column_name='").append(columnName).append("'").toString();
        return super.selectWhereExpectOne(conditions);
    }

    public ColumnsTable(JdbcLayerInterface jdbcLayer) {
        super(jdbcLayer);
    }
}

