/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.query;

import cats.Applicative;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.ErrorList;
import com.vertica.spark.util.error.MultipleQueryResult;
import com.vertica.spark.util.error.QueryResultEmpty;
import com.vertica.spark.util.error.ResultSetError;
import java.io.Serializable;
import java.sql.ResultSet;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00055a!\u0002\u0006\f\u0003\u00031\u0002\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\t\u000b\u0019\u0002A\u0011A\u0014\t\u000bY\u0002a\u0011C\u001c\t\u000b\r\u0003a\u0011\u0003#\t\u000b9\u0003a\u0011C(\t\u000bi\u0003AQB.\t\u000bU\u0004AQ\u0003<\t\u000ba\u0004AQC=\t\u000f\u0005\u0015\u0001\u0001\"\u0003\u0002\b\taa+\u001a:uS\u000e\fG+\u00192mK*\u0011A\"D\u0001\u0006cV,'/\u001f\u0006\u0003\u001d=\tA!\u001e;jY*\u0011\u0001#E\u0001\u0006gB\f'o\u001b\u0006\u0003%M\tqA^3si&\u001c\u0017MC\u0001\u0015\u0003\r\u0019w.\\\u0002\u0001+\t9Bf\u0005\u0002\u00011A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\fAA\u001b3cGB\u0011\u0001\u0005J\u0007\u0002C)\u0011aD\t\u0006\u0003G=\t!\u0002Z1uCN|WO]2f\u0013\t)\u0013E\u0001\nKI\n\u001cG*Y=fe&sG/\u001a:gC\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0002)kA\u0019\u0011\u0006\u0001\u0016\u000e\u0003-\u0001\"a\u000b\u0017\r\u0001\u0011)Q\u0006\u0001b\u0001]\t\tA+\u0005\u00020eA\u0011\u0011\u0004M\u0005\u0003ci\u0011qAT8uQ&tw\r\u0005\u0002\u001ag%\u0011AG\u0007\u0002\u0004\u0003:L\b\"\u0002\u0010\u0003\u0001\u0004y\u0012!\u0003;bE2,g*Y7f+\u0005A\u0004CA\u001dA\u001d\tQd\b\u0005\u0002<55\tAH\u0003\u0002>+\u00051AH]8pizJ!a\u0010\u000e\u0002\rA\u0013X\rZ3g\u0013\t\t%I\u0001\u0004TiJLgn\u001a\u0006\u0003\u007fi\tqaY8mk6t7/F\u0001F!\r15\n\u000f\b\u0003\u000f&s!a\u000f%\n\u0003mI!A\u0013\u000e\u0002\u000fA\f7m[1hK&\u0011A*\u0014\u0002\u0004'\u0016\f(B\u0001&\u001b\u0003!\u0011W/\u001b7e%><HC\u0001\u0016Q\u0011\u0015\tV\u00011\u0001S\u0003\t\u00118\u000f\u0005\u0002T16\tAK\u0003\u0002V-\u0006\u00191/\u001d7\u000b\u0003]\u000bAA[1wC&\u0011\u0011\f\u0016\u0002\n%\u0016\u001cX\u000f\u001c;TKR\f\u0001#];fef\u001cV\r\\3di^CWM]3\u0015\u0005q\u001b\b\u0003B\r^?bJ!A\u0018\u000e\u0003\rQ+\b\u000f\\33!\r\u0001wN\u001d\b\u0003C2t!A\u00196\u000f\u0005\rLgB\u00013i\u001d\t)wM\u0004\u0002<M&\tA#\u0003\u0002\u0013'%\u0011\u0001#E\u0005\u0003\u001d=I!a[\u0007\u0002\u000b\u0015\u0014(o\u001c:\n\u00055t\u0017!D#se>\u0014\b*\u00198eY&twM\u0003\u0002l\u001b%\u0011\u0001/\u001d\u0002\u0010\u0007>tg.Z2u_J\u0014Vm];mi*\u0011QN\u001c\t\u0004\r.S\u0003\"\u0002;\u0007\u0001\u0004A\u0014AC2p]\u0012LG/[8og\u0006Y1/\u001a7fGR<\u0006.\u001a:f)\tyv\u000fC\u0003u\u000f\u0001\u0007\u0001(\u0001\u000btK2,7\r^,iKJ,W\t\u001f9fGR|e.\u001a\u000b\u0004u\u0006\r\u0001\u0003\u0002$|{*J!\u0001`'\u0003\r\u0015KG\u000f[3s!\tqx0D\u0001o\u0013\r\t\tA\u001c\u0002\u000f\u0007>tg.Z2u_J,%O]8s\u0011\u0015!\b\u00021\u00019\u000359(/\u00199Rk>$\u0018\r^5p]R\u0019\u0001(!\u0003\t\r\u0005-\u0011\u00021\u00019\u0003\r\u0019HO\u001d")
public abstract class VerticaTable<T> {
    private final JdbcLayerInterface jdbc;

    public abstract String tableName();

    public abstract Seq<String> columns();

    public abstract T buildRow(ResultSet var1);

    private final Tuple2<Either<ConnectorError, Seq<T>>, String> querySelectWhere(String conditions) {
        Left left;
        String cols = ((TraversableOnce)this.columns().map((Function1 & Serializable & scala.Serializable)str -> this.wrapQuotation((String)str), Seq$.MODULE$.canBuildFrom())).mkString(", ");
        String tableName = this.wrapQuotation(this.tableName());
        String where = conditions.isEmpty() ? "" : new StringBuilder(7).append(" WHERE ").append(conditions.trim()).toString();
        String query = new StringBuilder(13).append("SELECT ").append(cols).append(" FROM ").append(tableName).append(where).toString();
        Either<ConnectorError, ResultSet> either = this.jdbc.query(query, this.jdbc.query$default$2());
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            ResultSet rs = (ResultSet)right.value();
            Nil$ rowsOrErrors = Nil$.MODULE$;
            while (rs.next()) {
                rowsOrErrors = (List)rowsOrErrors.$colon$plus((Object)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.buildRow(rs)).toEither(), List$.MODULE$.canBuildFrom());
            }
            rs.close();
            left = ((Validated)implicits$.MODULE$.toTraverseOps((Object)rowsOrErrors, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$1 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$1), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one((Object)new ResultSetError((Throwable)err))))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)rows -> rows).left().map((Function1 & Serializable & scala.Serializable)error -> new ErrorList((NonEmptyList<ConnectorError>)error));
        } else {
            throw new MatchError(either);
        }
        Left result = left;
        return new Tuple2((Object)result, (Object)query);
    }

    public final Either<ConnectorError, Seq<T>> selectWhere(String conditions) {
        return (Either)this.querySelectWhere(conditions)._1();
    }

    public final Either<ConnectorError, T> selectWhereExpectOne(String conditions) {
        Left left;
        Tuple2<Either<ConnectorError, Seq<T>>, String> tuple2 = this.querySelectWhere(conditions);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Either result = (Either)tuple2._1();
        String query = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)result, (Object)query);
        Tuple2 tuple23 = tuple22;
        Either result2 = (Either)tuple23._1();
        String query2 = (String)tuple23._2();
        Either either = result2;
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError error = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)error);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq value = (Seq)right.value();
            left = value.isEmpty() ? package$.MODULE$.Left().apply((Object)new QueryResultEmpty(this.tableName(), query2)) : (value.length() > 1 ? package$.MODULE$.Left().apply((Object)new MultipleQueryResult(this.tableName(), query2)) : package$.MODULE$.Right().apply(value.head()));
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    private String wrapQuotation(String str) {
        return new StringBuilder(2).append("\"").append(str).append("\"").toString();
    }

    public VerticaTable(JdbcLayerInterface jdbc) {
        this.jdbc = jdbc;
    }
}

