/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.schema;

import cats.Applicative;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.config.TableQuery;
import com.vertica.spark.config.TableSource;
import com.vertica.spark.config.ValidColumnList;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.util.complex.ComplexTypeUtils;
import com.vertica.spark.util.error.BlankColumnNamesError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.DatabaseReadError;
import com.vertica.spark.util.error.EmptySchemaError;
import com.vertica.spark.util.error.ErrorHandling$;
import com.vertica.spark.util.error.ErrorList;
import com.vertica.spark.util.error.InvalidMapSchemaError;
import com.vertica.spark.util.error.InvalidTableSchemaComplexType;
import com.vertica.spark.util.error.JdbcSchemaError;
import com.vertica.spark.util.error.MapDataTypeConversionError;
import com.vertica.spark.util.error.MissingElementTypeError;
import com.vertica.spark.util.error.MissingSparkPrimitivesConversionError;
import com.vertica.spark.util.error.MissingSqlConversionError;
import com.vertica.spark.util.error.QueryReturnsComplexTypes;
import com.vertica.spark.util.error.SchemaConversionError;
import com.vertica.spark.util.error.SchemaError;
import com.vertica.spark.util.error.StructFieldsError;
import com.vertica.spark.util.error.TableNotEnoughRowsError;
import com.vertica.spark.util.error.UnknownColumnTypesError;
import com.vertica.spark.util.query.StringParsingUtils$;
import com.vertica.spark.util.schema.ColumnDef;
import com.vertica.spark.util.schema.ColumnDef$;
import com.vertica.spark.util.schema.ComplexTypesSchemaTools;
import com.vertica.spark.util.schema.MetadataKey$;
import com.vertica.spark.util.schema.SchemaTools$;
import com.vertica.spark.util.schema.SchemaToolsInterface;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import scala.util.control.Breaks$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\rEb\u0001\u0002\u0016,\u0001YB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\u0006\u000b\u0002!\tA\u0012\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0011\u0019\u0019\u0006\u0001)A\u0005\u0017\"9A\u000b\u0001b\u0001\n\u0013)\u0006B\u00020\u0001A\u0003%a\u000bC\u0004`\u0001\t\u0007I\u0011B+\t\r\u0001\u0004\u0001\u0015!\u0003W\u0011\u001d\t\u0007A1A\u0005\n\tDaA\u001a\u0001!\u0002\u0013\u0019\u0007bB4\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007_\u0002\u0001\u000b\u0011B5\t\u000bA\u0004A\u0011B9\t\u000by\u0004A\u0011B@\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004bBA@\u0001\u0011E\u0011\u0011\u0011\u0005\b\u0003+\u0003A\u0011AAL\u0011\u001d\t)\u000f\u0001C\u0001\u0003ODq!!>\u0001\t\u0003\n9\u0010C\u0004\u0003\u001c\u0001!IA!\b\t\u000f\t%\u0002\u0001\"\u0003\u0003,!9!q\b\u0001\u0005\n\t\u0005\u0003b\u0002B'\u0001\u0011%!q\n\u0005\b\u0005+\u0002A\u0011\u0001B,\u0011\u001d\u0011I\u0007\u0001C\u0001\u0005WBqA!\u001e\u0001\t\u0003\u00119\bC\u0004\u0003\u0000\u0001!\tA!!\t\u000f\t]\u0005\u0001\"\u0001\u0003\u001a\"9!Q\u0015\u0001\u0005\n\t\u001d\u0006b\u0002BV\u0001\u0011%!Q\u0016\u0005\b\u0005{\u0003A\u0011\u0002B`\u0011\u001d\u0011y\r\u0001C\u0001\u0005#DqA!8\u0001\t\u0003\u0011y\u000eC\u0004\u0003n\u0002!\tAa<\t\u000f\tu\b\u0001\"\u0001\u0003\u0000\"911\u0001\u0001\u0005\u0002\r\u0015q!CB\tW\u0005\u0005\t\u0012AB\n\r!Q3&!A\t\u0002\rU\u0001BB#(\t\u0003\u00199\u0002C\u0005\u0004\u001a\u001d\n\n\u0011\"\u0001\u0004\u001c\tY1k\u00195f[\u0006$vn\u001c7t\u0015\taS&\u0001\u0004tG\",W.\u0019\u0006\u0003]=\nA!\u001e;jY*\u0011\u0001'M\u0001\u0006gB\f'o\u001b\u0006\u0003eM\nqA^3si&\u001c\u0017MC\u00015\u0003\r\u0019w.\\\u0002\u0001'\r\u0001q'\u0010\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005yzT\"A\u0016\n\u0005\u0001[#\u0001F*dQ\u0016l\u0017\rV8pYNLe\u000e^3sM\u0006\u001cW-A\u0004diR{w\u000e\\:\u0011\u0005y\u001a\u0015B\u0001#,\u0005]\u0019u.\u001c9mKb$\u0016\u0010]3t'\u000eDW-\\1U_>d7/\u0001\u0004=S:LGO\u0010\u000b\u0003\u000f\"\u0003\"A\u0010\u0001\t\u000f\u0005\u0013\u0001\u0013!a\u0001\u0005\u00061An\\4hKJ,\u0012a\u0013\t\u0003\u0019Fk\u0011!\u0014\u0006\u0003\u001d>\u000bAb]2bY\u0006dwnZ4j]\u001eT!\u0001U\u001a\u0002\u0011QL\b/Z:bM\u0016L!AU'\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\nq!\u001e8l]><h.F\u0001W!\t9F,D\u0001Y\u0015\tI&,\u0001\u0003mC:<'\"A.\u0002\t)\fg/Y\u0005\u0003;b\u0013aa\u0015;sS:<\u0017\u0001C;oW:|wO\u001c\u0011\u0002\u00135\f\u0007\u0010\\3oORD\u0017AC7bq2,gn\u001a;iA\u0005QAn\u001c8hY\u0016tw\r\u001e5\u0016\u0003\r\u0004\"\u0001\u000f3\n\u0005\u0015L$aA%oi\u0006YAn\u001c8hY\u0016tw\r\u001e5!\u0003A\u0019w.\u001c9mKb$\u0016\u0010]3Vi&d7/F\u0001j!\tQW.D\u0001l\u0015\taW&A\u0004d_6\u0004H.\u001a=\n\u00059\\'\u0001E\"p[BdW\r\u001f+za\u0016,F/\u001b7t\u0003E\u0019w.\u001c9mKb$\u0016\u0010]3Vi&d7\u000fI\u0001\u0010C\u0012$Gi\\;cY\u0016\fVo\u001c;fgR\u0011!\u000f \t\u0003gjt!\u0001\u001e=\u0011\u0005ULT\"\u0001<\u000b\u0005],\u0014A\u0002\u001fs_>$h(\u0003\u0002zs\u00051\u0001K]3eK\u001aL!!X>\u000b\u0005eL\u0004\"B?\u000e\u0001\u0004\u0011\u0018aA:ue\u0006yq-\u001a;DCR\fG._:u)f\u0004X\r\u0006\b\u0002\u0002\u0005E\u0012QGA\u001d\u0003{\t9%a\u0013\u0011\u0011\u0005\r\u0011qAA\u0006\u0003/i!!!\u0002\u000b\u00059J\u0014\u0002BA\u0005\u0003\u000b\u0011a!R5uQ\u0016\u0014\b\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005EQ&A\u0003feJ|'/\u0003\u0003\u0002\u0016\u0005=!aC*dQ\u0016l\u0017-\u0012:s_J\u0004B!!\u0007\u0002.5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"A\u0003usB,7O\u0003\u0003\u0002\"\u0005\r\u0012aA:rY*\u0019\u0001'!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0007CB\f7\r[3\u000b\u0005\u0005-\u0012aA8sO&!\u0011qFA\u000e\u0005!!\u0015\r^1UsB,\u0007BBA\u001a\u001d\u0001\u00071-A\u0004tc2$\u0016\u0010]3\t\r\u0005]b\u00021\u0001d\u0003%\u0001(/Z2jg&|g\u000e\u0003\u0004\u0002<9\u0001\raY\u0001\u0006g\u000e\fG.\u001a\u0005\b\u0003\u007fq\u0001\u0019AA!\u0003\u0019\u0019\u0018n\u001a8fIB\u0019\u0001(a\u0011\n\u0007\u0005\u0015\u0013HA\u0004C_>dW-\u00198\t\r\u0005%c\u00021\u0001s\u0003!!\u0018\u0010]3oC6,\u0007bBA'\u001d\u0001\u0007\u0011qJ\u0001\nG\"LG\u000e\u001a#fMN\u0004b!!\u0015\u0002\\\u0005\u0005d\u0002BA*\u0003/r1!^A+\u0013\u0005Q\u0014bAA-s\u00059\u0001/Y2lC\u001e,\u0017\u0002BA/\u0003?\u0012A\u0001T5ti*\u0019\u0011\u0011L\u001d\u0011\u0007y\n\u0019'C\u0002\u0002f-\u0012\u0011bQ8mk6tG)\u001a4\u0002\u001b\u001d,Go\u0015;sk\u000e$H+\u001f9f)\u0011\t\t!a\u001b\t\u000f\u00055t\u00021\u0001\u0002P\u00051a-[3mIN\fAbZ3u\u0003J\u0014\u0018-\u001f+za\u0016$B!a\u001d\u0002|AA\u00111AA\u0004\u0003\u0017\t)\b\u0005\u0003\u0002\u001a\u0005]\u0014\u0002BA=\u00037\u0011\u0011\"\u0011:sCf$\u0016\u0010]3\t\u000f\u0005u\u0004\u00031\u0001\u0002P\u0005QQ\r\\3nK:$H)\u001a4\u00027\u001d,GoQ1uC2L8\u000f\u001e+za\u00164%o\\7KI\n\u001cG+\u001f9f)1\t\u0019)a#\u0002\u000e\u0006=\u0015\u0011SAJ!!\t\u0019!a\u0002\u0002\u0006\u0006]\u0001\u0003BA\u0007\u0003\u000fKA!!#\u0002\u0010\tIR*[:tS:<7+\u001d7D_:4XM]:j_:,%O]8s\u0011\u0019\t\u0019$\u0005a\u0001G\"1\u0011qG\tA\u0002\rDa!a\u000f\u0012\u0001\u0004\u0019\u0007bBA #\u0001\u0007\u0011\u0011\t\u0005\u0007\u0003\u0013\n\u0002\u0019\u0001:\u0002\u0015I,\u0017\rZ*dQ\u0016l\u0017\r\u0006\u0004\u0002\u001a\u0006\u0005\u0017Q\u001b\t\u0007\u00037\u000b),a/\u000f\t\u0005u\u0015\u0011\u0017\b\u0005\u0003?\u000byK\u0004\u0003\u0002\"\u00065f\u0002BAR\u0003WsA!!*\u0002*:\u0019Q/a*\n\u0003QJ!AM\u001a\n\u0005A\n\u0014B\u0001\u00180\u0013\r\t\t\"L\u0005\u0005\u0003g\u000by!A\u0007FeJ|'\u000fS1oI2LgnZ\u0005\u0005\u0003o\u000bILA\bD_:tWm\u0019;peJ+7/\u001e7u\u0015\u0011\t\u0019,a\u0004\u0011\t\u0005e\u0011QX\u0005\u0005\u0003\u007f\u000bYB\u0001\u0006TiJ,8\r\u001e+za\u0016Dq!a1\u0013\u0001\u0004\t)-A\u0005kI\n\u001cG*Y=feB!\u0011qYAi\u001b\t\tIM\u0003\u0003\u0002L\u00065\u0017\u0001\u00026eE\u000eT1!a40\u0003)!\u0017\r^1t_V\u00148-Z\u0005\u0005\u0003'\fIM\u0001\nKI\n\u001cG*Y=fe&sG/\u001a:gC\u000e,\u0007bBAl%\u0001\u0007\u0011\u0011\\\u0001\fi\u0006\u0014G.Z*pkJ\u001cW\r\u0005\u0003\u0002\\\u0006\u0005XBAAo\u0015\r\tynL\u0001\u0007G>tg-[4\n\t\u0005\r\u0018Q\u001c\u0002\f)\u0006\u0014G.Z*pkJ\u001cW-A\u0007hKR\u001cu\u000e\\;n]&sgm\u001c\u000b\u0007\u0003S\f\t0a=\u0011\r\u0005m\u0015QWAv!\u0019\t\t&!<\u0002b%!\u0011q^A0\u0005\r\u0019V-\u001d\u0005\b\u0003\u0007\u001c\u0002\u0019AAc\u0011\u001d\t9n\u0005a\u0001\u00033\f1dZ3u-\u0016\u0014H/[2b)f\u0004XM\u0012:p[N\u0003\u0018M]6UsB,GCCA}\u0003\u007f\u0014\u0019A!\u0004\u0003\u0012A)\u00111TA~e&!\u0011Q`A]\u00051\u00196\r[3nCJ+7/\u001e7u\u0011\u001d\u0011\t\u0001\u0006a\u0001\u0003/\t\u0011b\u001d9be.$\u0016\u0010]3\t\u000f\t\u0015A\u00031\u0001\u0003\b\u000511\u000f\u001e:mK:\u00042\u0001\u000fB\u0005\u0013\r\u0011Y!\u000f\u0002\u0005\u0019>tw\rC\u0004\u0003\u0010Q\u0001\rAa\u0002\u0002\u0017\u0005\u0014(/Y=MK:<G\u000f\u001b\u0005\b\u0005'!\u0002\u0019\u0001B\u000b\u0003!iW\r^1eCR\f\u0007\u0003BA\r\u0005/IAA!\u0007\u0002\u001c\tAQ*\u001a;bI\u0006$\u0018-\u0001\u000bta\u0006\u00148.T1q)>4VM\u001d;jG\u0006l\u0015\r\u001d\u000b\t\u0003s\u0014yBa\t\u0003(!9!\u0011E\u000bA\u0002\u0005]\u0011aB6fsRK\b/\u001a\u0005\b\u0005K)\u0002\u0019AA\f\u0003%1\u0018\r\\;f)f\u0004X\rC\u0004\u0003\u0006U\u0001\rAa\u0002\u0002/M\u0004\u0018M]6TiJ,8\r\u001e+p-\u0016\u0014H/[2b%><H\u0003CA}\u0005[\u0011YD!\u0010\t\u000f\u00055d\u00031\u0001\u00030A)\u0001H!\r\u00036%\u0019!1G\u001d\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005e!qG\u0005\u0005\u0005s\tYBA\u0006TiJ,8\r\u001e$jK2$\u0007b\u0002B\u0003-\u0001\u0007!q\u0001\u0005\b\u0005\u001f1\u0002\u0019\u0001B\u0004\u0003a\u0019\b/\u0019:l\u0003J\u0014\u0018-\u001f+p-\u0016\u0014H/[2b\u0003J\u0014\u0018-\u001f\u000b\u000b\u0003s\u0014\u0019Ea\u0012\u0003J\t-\u0003b\u0002B#/\u0001\u0007\u0011qC\u0001\tI\u0006$\u0018\rV=qK\"9!QA\fA\u0002\t\u001d\u0001b\u0002B\b/\u0001\u0007!q\u0001\u0005\b\u0005'9\u0002\u0019\u0001B\u000b\u0003\u0001\u001a\b/\u0019:l!JLW.\u001b;jm\u0016$vNV3si&\u001c\u0017\r\u0015:j[&$\u0018N^3\u0015\r\u0005e(\u0011\u000bB*\u0011\u001d\u0011\t\u0001\u0007a\u0001\u0003/AqA!\u0002\u0019\u0001\u0004\u00119!A\thKR\u001cu\u000e]=D_2,XN\u001c'jgR$\u0002B!\u0017\u0003\\\tu#q\r\t\u0006\u00037\u000b)L\u001d\u0005\b\u0003\u0007L\u0002\u0019AAc\u0011\u001d\u0011y&\u0007a\u0001\u0005C\n\u0011\u0002^1cY\u0016t\u0015-\\3\u0011\t\u0005m'1M\u0005\u0005\u0005K\niNA\u0005UC\ndWMT1nK\"1A&\u0007a\u0001\u0003w\u000b\u0011#\\1lK\u000e{G.^7ogN#(/\u001b8h)\u0015\u0011(Q\u000eB9\u0011\u001d\u0011yG\u0007a\u0001\u0003W\f!bY8mk6tG)\u001a4t\u0011\u001d\u0011\u0019H\u0007a\u0001\u0003w\u000baB]3rk&\u0014X\rZ*dQ\u0016l\u0017-A\nnC.,G+\u00192mK\u000e{G.^7o\t\u001647\u000f\u0006\u0005\u0003Z\te$1\u0010B?\u0011\u0019a3\u00041\u0001\u0002<\"9!QA\u000eA\u0002\t\u001d\u0001b\u0002B\b7\u0001\u0007!qA\u0001\u0015O\u0016$X*\u001a:hK&s7/\u001a:u-\u0006dW/Z:\u0015\u0011\te#1\u0011BC\u0005\u000fCq!a1\u001d\u0001\u0004\t)\rC\u0004\u0003`q\u0001\rA!\u0019\t\u000f\t%E\u00041\u0001\u0003\f\u0006q1m\u001c9z\u0007>dW/\u001c8MSN$\b#\u0002\u001d\u0003\u000e\nE\u0015b\u0001BHs\t1q\n\u001d;j_:\u0004B!a7\u0003\u0014&!!QSAo\u0005=1\u0016\r\\5e\u0007>dW/\u001c8MSN$\u0018!F2iK\u000e\\g+\u00197jIR\u000b'\r\\3TG\",W.\u0019\u000b\u0005\u00057\u0013\u0019\u000b\u0005\u0004\u0002\u001c\u0006U&Q\u0014\t\u0004q\t}\u0015b\u0001BQs\t!QK\\5u\u0011\u0019aS\u00041\u0001\u0002<\u000692\r[3dW\u000e{W\u000e\u001d7fqRK\b/Z:TG\",W.\u0019\u000b\u0005\u00057\u0013I\u000b\u0003\u0004-=\u0001\u0007\u00111X\u0001\u0016G\",7m['ba\u000e{G.^7ogN\u001b\u0007.Z7b)\u0011\u0011yKa.\u0011\u0011\u0005\r\u0011q\u0001BY\u0005;\u0003B!!\u0004\u00034&!!QWA\b\u0005%)%O]8s\u0019&\u001cH\u000fC\u0004\u0003:~\u0001\rAa/\u0002\u001f\r|W\u000e\u001d7fqRK\b/Z\"pYN\u0004b!!\u0015\u0002\\\tU\u0012AG2iK\u000e\\W*\u00199D_:$\u0018-\u001b8t!JLW.\u001b;jm\u0016\u001cHC\u0002BN\u0005\u0003\u0014)\r\u0003\u0004\u0003D\u0002\u0002\rA]\u0001\bG>dg*Y7f\u0011\u001d\u00119\r\ta\u0001\u0005\u0013\f1!\\1q!\u0011\tIBa3\n\t\t5\u00171\u0004\u0002\b\u001b\u0006\u0004H+\u001f9f\u0003Q9W\r^'fe\u001e,W\u000b\u001d3bi\u00164\u0016\r\\;fgRQ!\u0011\fBj\u0005+\u00149Na7\t\u000f\u0005\r\u0017\u00051\u0001\u0002F\"9!qL\u0011A\u0002\t\u0005\u0004b\u0002BmC\u0001\u0007!\u0011M\u0001\u000ei\u0016l\u0007\u000fV1cY\u0016t\u0015-\\3\t\u000f\t%\u0015\u00051\u0001\u0003\f\u0006\u0019R\u000f\u001d3bi\u00164\u0015.\u001a7e\t\u0006$\u0018\rV=qKRY!O!9\u0003f\n\u001d(\u0011\u001eBv\u0011\u0019\u0011\u0019O\ta\u0001e\u0006\u00191m\u001c7\t\r\t\r'\u00051\u0001s\u0011\u0019a#\u00051\u0001\u0002<\"9!Q\u0001\u0012A\u0002\t\u001d\u0001b\u0002B\bE\u0001\u0007!qA\u0001\u0019S:4WM]#yi\u0016\u0014h.\u00197UC\ndWmU2iK6\fG\u0003\u0004B-\u0005c\u0014)Pa>\u0003z\nm\bB\u0002BzG\u0001\u0007!/A\fde\u0016\fG/Z#yi\u0016\u0014h.\u00197UC\ndWm\u0015;ni\"1Af\ta\u0001\u0003wCaAa\u0018$\u0001\u0004\u0011\bb\u0002B\u0003G\u0001\u0007!q\u0001\u0005\b\u0005\u001f\u0019\u0003\u0019\u0001B\u0004\u0003U\u0019\u0007.Z2l\u00052\fgn[\"pYVlgNT1nKN$BAa'\u0004\u0002!1A\u0006\na\u0001\u0003w\u000b!#\u00193e\t\n\u001c6\r[3nCR{\u0017+^3ssR)!oa\u0002\u0004\f!11\u0011B\u0013A\u0002I\fQ!];fefDqa!\u0004&\u0001\u0004\u0019y!\u0001\u0005eEN\u001b\u0007.Z7b!\u0011A$Q\u0012:\u0002\u0017M\u001b\u0007.Z7b)>|Gn\u001d\t\u0003}\u001d\u001a\"aJ\u001c\u0015\u0005\rM\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\u001e)\u001a!ia\b,\u0005\r\u0005\u0002\u0003BB\u0012\u0007[i!a!\n\u000b\t\r\u001d2\u0011F\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\u000b:\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007_\u0019)CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class SchemaTools
implements SchemaToolsInterface {
    private final ComplexTypesSchemaTools ctTools;
    private final Logger logger;
    private final String unknown;
    private final String com$vertica$spark$util$schema$SchemaTools$$maxlength;
    private final int com$vertica$spark$util$schema$SchemaTools$$longlength;
    private final ComplexTypeUtils complexTypeUtils;

    public static ComplexTypesSchemaTools $lessinit$greater$default$1() {
        return SchemaTools$.MODULE$.$lessinit$greater$default$1();
    }

    private Logger logger() {
        return this.logger;
    }

    private String unknown() {
        return this.unknown;
    }

    public String com$vertica$spark$util$schema$SchemaTools$$maxlength() {
        return this.com$vertica$spark$util$schema$SchemaTools$$maxlength;
    }

    public int com$vertica$spark$util$schema$SchemaTools$$longlength() {
        return this.com$vertica$spark$util$schema$SchemaTools$$longlength;
    }

    private ComplexTypeUtils complexTypeUtils() {
        return this.complexTypeUtils;
    }

    public String com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(String str) {
        return new StringBuilder(2).append("\"").append(str).append("\"").toString();
    }

    private Either<SchemaError, DataType> getCatalystType(int sqlType, int precision, int scale, boolean signed, String typename, List<ColumnDef> childDefs) {
        Either<SchemaError, ArrayType> either;
        int n = sqlType;
        switch (n) {
            case 2003: {
                either = this.getArrayType(childDefs);
                break;
            }
            case 2002: {
                either = this.getStructType(childDefs);
                break;
            }
            default: {
                either = this.getCatalystTypeFromJdbcType(sqlType, precision, scale, signed, typename);
                break;
            }
        }
        return either;
    }

    private Either<SchemaError, DataType> getStructType(List<ColumnDef> fields2) {
        List fieldDefs = (List)fields2.map((Function1 & Serializable & scala.Serializable)colDef -> this.getCatalystType(colDef.jdbcType(), colDef.size(), colDef.scale(), colDef.signed(), colDef.colTypeName(), colDef.children()).map((Function1 & Serializable & scala.Serializable)dataType -> new StructField(colDef.label(), dataType, colDef.nullable(), colDef.metadata())), List$.MODULE$.canBuildFrom());
        return ErrorHandling$.MODULE$.listToEitherSchema(fieldDefs).map((Function1 & Serializable & scala.Serializable)fields -> StructType$.MODULE$.apply(fields));
    }

    private Either<SchemaError, ArrayType> getArrayType(List<ColumnDef> elementDef) {
        Left left;
        Option option = elementDef.headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            ColumnDef element = (ColumnDef)some.value();
            left = this.getCatalystType(element.jdbcType(), element.size(), element.scale(), element.signed(), element.colTypeName(), element.children()).map((Function1 & Serializable & scala.Serializable)elementType -> this.makeNestedArrays$1(element.metadata().getLong(MetadataKey$.MODULE$.DEPTH()), (DataType)elementType));
        } else if (None$.MODULE$.equals(option)) {
            left = package$.MODULE$.Left().apply((Object)new MissingElementTypeError());
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    public Either<MissingSqlConversionError, DataType> getCatalystTypeFromJdbcType(int sqlType, int precision, int scale, boolean signed, String typename) {
        BinaryType$ binaryType$;
        int n = sqlType;
        switch (n) {
            case -5: {
                if (signed) {
                    binaryType$ = LongType$.MODULE$;
                    break;
                }
                binaryType$ = new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 0);
                break;
            }
            case -2: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case -7: {
                binaryType$ = BooleanType$.MODULE$;
                break;
            }
            case 2004: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case 16: {
                binaryType$ = BooleanType$.MODULE$;
                break;
            }
            case 1: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2005: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 70: {
                binaryType$ = null;
                break;
            }
            case 91: {
                binaryType$ = DateType$.MODULE$;
                break;
            }
            case 3: {
                binaryType$ = new DecimalType(precision, scale);
                break;
            }
            case 2001: {
                binaryType$ = null;
                break;
            }
            case 8: {
                binaryType$ = DoubleType$.MODULE$;
                break;
            }
            case 6: {
                binaryType$ = FloatType$.MODULE$;
                break;
            }
            case 4: {
                if (signed) {
                    binaryType$ = IntegerType$.MODULE$;
                    break;
                }
                binaryType$ = LongType$.MODULE$;
                break;
            }
            case 2000: {
                binaryType$ = null;
                break;
            }
            case -16: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -4: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case -1: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 2011: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 0: {
                binaryType$ = null;
                break;
            }
            case 2: {
                if (precision != 0 || scale != 0) {
                    binaryType$ = new DecimalType(precision, scale);
                    break;
                }
                binaryType$ = new DecimalType(DecimalType$.MODULE$.USER_DEFAULT().precision(), DecimalType$.MODULE$.USER_DEFAULT().scale());
                break;
            }
            case -9: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 1111: {
                String typenameNormalized = typename.toLowerCase();
                if (typenameNormalized.startsWith("interval") || typenameNormalized.startsWith("uuid")) {
                    binaryType$ = StringType$.MODULE$;
                    break;
                }
                binaryType$ = null;
                break;
            }
            case 7: {
                binaryType$ = DoubleType$.MODULE$;
                break;
            }
            case 2006: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case -8: {
                binaryType$ = LongType$.MODULE$;
                break;
            }
            case 5: {
                binaryType$ = IntegerType$.MODULE$;
                break;
            }
            case 2009: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 92: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            case 93: {
                binaryType$ = TimestampType$.MODULE$;
                break;
            }
            case -6: {
                binaryType$ = IntegerType$.MODULE$;
                break;
            }
            case -3: {
                binaryType$ = BinaryType$.MODULE$;
                break;
            }
            case 12: {
                binaryType$ = StringType$.MODULE$;
                break;
            }
            default: {
                binaryType$ = null;
                break;
            }
        }
        BinaryType$ answer = binaryType$;
        return answer == null ? package$.MODULE$.Left().apply((Object)new MissingSqlConversionError(((Object)BoxesRunTime.boxToInteger((int)sqlType)).toString(), typename)) : package$.MODULE$.Right().apply((Object)answer);
    }

    @Override
    public Either<ConnectorError, StructType> readSchema(JdbcLayerInterface jdbcLayer, TableSource tableSource) {
        Left left;
        Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tableSource);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq colInfo = (Seq)right.value();
            List errorsOrFields = ((TraversableOnce)colInfo.map((Function1 & Serializable & scala.Serializable)info -> this.getCatalystType(info.jdbcType(), info.size(), info.scale(), info.signed(), info.colTypeName(), info.children()).map((Function1 & Serializable & scala.Serializable)columnType -> new StructField(info.label(), columnType, info.nullable(), info.metadata())), Seq$.MODULE$.canBuildFrom())).toList();
            left = ((Validated)implicits$.MODULE$.toTraverseOps((Object)errorsOrFields, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$1 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$1), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)field -> StructType$.MODULE$.apply((Seq)field)).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, Seq<ColumnDef>> getColumnInfo(JdbcLayerInterface jdbcLayer, TableSource tableSource) {
        Left left;
        String string;
        TableSource tableSource2 = tableSource;
        if (tableSource2 instanceof TableName) {
            TableName tableName = (TableName)tableSource2;
            string = new StringBuilder(24).append("SELECT * FROM ").append(tableName.getFullTableName()).append(" WHERE 1=0").toString();
        } else if (tableSource2 instanceof TableQuery) {
            TableQuery tableQuery = (TableQuery)tableSource2;
            String query = tableQuery.query();
            Option<String> schema = tableQuery.dbSchema();
            string = new StringBuilder(31).append("SELECT * FROM (").append(this.addDbSchemaToQuery(query, schema)).append(") AS x WHERE 1=0").toString();
        } else {
            throw new MatchError((Object)tableSource2);
        }
        String emptyQuery = string;
        Either<ConnectorError, ResultSet> either = jdbcLayer.query(emptyQuery, jdbcLayer.query$default$2());
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
        } else if (either instanceof Right) {
            Left left3;
            Right right = (Right)either;
            try (ResultSet rs = (ResultSet)right.value();){
                try {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    List colDefsOrErrors = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), rsmd.getColumnCount()).map((Function1 & Serializable & scala.Serializable)idx -> SchemaTools.$anonfun$getColumnInfo$1(this, rsmd, tableSource, jdbcLayer, BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).toList();
                    left3 = ((Validated)implicits$.MODULE$.toTraverseOps((Object)colDefsOrErrors, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$2 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$2), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)columnDef -> columnDef).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
                }
                catch (Throwable e) {
                    left3 = package$.MODULE$.Left().apply((Object)new DatabaseReadError(e).context("Could not get column info from Vertica"));
                }
            }
            left = left3;
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    @Override
    public Either<SchemaError, String> getVerticaTypeFromSparkType(DataType sparkType, long strlen, long arrayLength, Metadata metadata) {
        Either<SchemaError, String> either;
        DataType dataType = sparkType;
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            either = this.sparkMapToVerticaMap(keyType, valueType, strlen);
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            either = this.sparkStructToVerticaRow(fields, strlen, arrayLength);
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType sparkType2 = arrayType.elementType();
            either = this.sparkArrayToVerticaArray(sparkType2, strlen, arrayLength, metadata);
        } else {
            either = this.sparkPrimitiveToVerticaPrimitive(sparkType, strlen);
        }
        return either;
    }

    private Either<SchemaError, String> sparkMapToVerticaMap(DataType keyType, DataType valueType, long strlen) {
        Right right;
        Either<SchemaError, String> keyVerticaType = this.sparkPrimitiveToVerticaPrimitive(keyType, strlen);
        Either<SchemaError, String> valueVerticaType = this.sparkPrimitiveToVerticaPrimitive(valueType, strlen);
        if (keyVerticaType.isRight() && valueVerticaType.isRight()) {
            right = package$.MODULE$.Right().apply((Object)new StringBuilder(7).append("MAP<").append(keyVerticaType.right().get()).append(", ").append(valueVerticaType.right().get()).append(">").toString());
        } else {
            String string;
            String string2;
            Either<SchemaError, String> either = keyVerticaType;
            if (either instanceof Left) {
                Left left = (Left)either;
                SchemaError error = (SchemaError)left.value();
                string2 = error.getFullContext();
            } else if (either instanceof Right) {
                string2 = "None";
            } else {
                throw new MatchError(either);
            }
            String keyErrorMsg = string2;
            Either<SchemaError, String> either2 = valueVerticaType;
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                SchemaError error = (SchemaError)left.value();
                string = error.getFullContext();
            } else if (either2 instanceof Right) {
                string = "None";
            } else {
                throw new MatchError(either2);
            }
            String valueErrorMsg = string;
            right = package$.MODULE$.Left().apply((Object)new MapDataTypeConversionError(keyErrorMsg, valueErrorMsg));
        }
        return right;
    }

    private Either<SchemaError, String> sparkStructToVerticaRow(StructField[] fields, long strlen, long arrayLength) {
        Left left;
        Either<ConnectorError, String> either = this.makeTableColumnDefs(new StructType(fields), strlen, arrayLength);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new StructFieldsError(err));
        } else if (either instanceof Right) {
            Right right = (Right)either;
            String fieldDefs = (String)right.value();
            left = package$.MODULE$.Right().apply((Object)new StringBuilder(3).append("ROW").append(fieldDefs.replace(" NOT NULL", "").trim()).toString());
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    private Either<SchemaError, String> sparkArrayToVerticaArray(DataType dataType, long strlen, long arrayLength, Metadata metadata) {
        String length = arrayLength <= 0L ? "" : new StringBuilder(1).append(",").append(arrayLength).toString();
        boolean isSet = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> metadata.getBoolean(MetadataKey$.MODULE$.IS_VERTICA_SET())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        String keyword = isSet ? "SET" : "ARRAY";
        return this.recursion$1(dataType, new StringBuilder(1).append(keyword).append("[").toString(), new StringBuilder(1).append(length).append("]").toString(), 0, keyword, length, strlen, arrayLength, metadata);
    }

    private Either<SchemaError, String> sparkPrimitiveToVerticaPrimitive(DataType sparkType, long strlen) {
        Right right;
        DataType dataType = sparkType;
        if (BinaryType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)new StringBuilder(11).append("VARBINARY(").append(this.com$vertica$spark$util$schema$SchemaTools$$longlength()).append(")").toString());
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"BOOLEAN");
        } else if (ByteType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"TINYINT");
        } else if (DateType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"DATE");
        } else if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"INTERVAL");
        } else if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            right = decimalType.precision() == 0 ? package$.MODULE$.Right().apply((Object)"DECIMAL") : package$.MODULE$.Right().apply((Object)new StringBuilder(11).append("DECIMAL(").append(decimalType.precision()).append(", ").append(decimalType.scale()).append(")").toString());
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"DOUBLE PRECISION");
        } else if (FloatType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"FLOAT");
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"INTEGER");
        } else if (LongType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"BIGINT");
        } else if (NullType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"null");
        } else if (ShortType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"SMALLINT");
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            right = package$.MODULE$.Right().apply((Object)"TIMESTAMP");
        } else if (StringType$.MODULE$.equals(dataType)) {
            String vtype = strlen > (long)this.com$vertica$spark$util$schema$SchemaTools$$longlength() ? "LONG VARCHAR" : "VARCHAR";
            right = package$.MODULE$.Right().apply((Object)new StringBuilder(2).append(vtype).append("(").append(((Object)BoxesRunTime.boxToLong((long)strlen)).toString()).append(")").toString());
        } else {
            right = package$.MODULE$.Left().apply((Object)new MissingSparkPrimitivesConversionError(sparkType));
        }
        return right;
    }

    @Override
    public Either<ConnectorError, String> getCopyColumnList(JdbcLayerInterface jdbcLayer, TableName tableName, StructType schema) {
        return this.getColumnInfo(jdbcLayer, tableName).flatMap((Function1 & Serializable & scala.Serializable)columns -> {
            Right right;
            int colCount = columns.length();
            IntRef colsFound = IntRef.create((int)0);
            columns.foreach((Function1 & Serializable & scala.Serializable)column -> {
                SchemaTools.$anonfun$getCopyColumnList$2(this, schema, colsFound, tableName, column);
                return BoxedUnit.UNIT;
            });
            if (schema.length() > colCount) {
                right = package$.MODULE$.Left().apply((Object)new TableNotEnoughRowsError().context(new StringBuilder(187).append("Error: Number of columns in the target table should be greater or equal to number of columns in the DataFrame.  Number of columns in DataFrame: ").append(schema.length()).append(". Number of columns in the target table: ").append(tableName.getFullTableName()).append(": ").append(colCount).toString()));
            } else if (colsFound.elem == schema.length()) {
                BoxedUnit boxedUnit;
                ObjectRef columnList2 = ObjectRef.create((Object)"");
                BooleanRef first = BooleanRef.create((boolean)true);
                schema.foreach((Function1 & Serializable & scala.Serializable)s -> {
                    SchemaTools.$anonfun$getCopyColumnList$5(first, columnList2, s);
                    return BoxedUnit.UNIT;
                });
                columnList2.elem = new StringBuilder(3).append("(").append((String)columnList2.elem).append("\")").toString();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder(27).append("Load by name. Column list: ").append((String)columnList2.elem).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                right = package$.MODULE$.Right().apply((Object)((String)columnList2.elem));
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Load by Position");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                right = package$.MODULE$.Right().apply((Object)"");
            }
            return right.map((Function1 & Serializable & scala.Serializable)columnList -> columnList);
        });
    }

    @Override
    public String makeColumnsString(Seq<ColumnDef> columnDefs, StructType requiredSchema) {
        Seq requiredColumnDefs = requiredSchema.nonEmpty() ? (Seq)columnDefs.filter((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)SchemaTools.$anonfun$makeColumnsString$1(requiredSchema, cd))) : columnDefs;
        return ((TraversableOnce)requiredColumnDefs.map((Function1 & Serializable & scala.Serializable)info -> {
            String string;
            String colLabel = this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(info.label());
            int n = info.jdbcType();
            switch (n) {
                case 1111: {
                    String typenameNormalized = info.colTypeName().toLowerCase();
                    if (typenameNormalized.startsWith("interval") || typenameNormalized.startsWith("uuid")) {
                        string = (String)this.castToVarchar$1().apply((Object)info.label());
                        break;
                    }
                    string = colLabel;
                    break;
                }
                case 92: {
                    string = (String)this.castToVarchar$1().apply((Object)info.label());
                    break;
                }
                case 2003: {
                    boolean isSet = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> info.metadata().getBoolean(MetadataKey$.MODULE$.IS_VERTICA_SET())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
                    if (isSet) {
                        string = this.castToArray$1((ColumnDef)info);
                        break;
                    }
                    string = colLabel;
                    break;
                }
                default: {
                    string = colLabel;
                    break;
                }
            }
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    @Override
    public Either<ConnectorError, String> makeTableColumnDefs(StructType schema, long strlen, long arrayLength) {
        Left left;
        List colDefsOrErrors = ((TraversableOnce)schema.map((Function1 & Serializable & scala.Serializable)col -> {
            Left left;
            String colName = col.name().isEmpty() ? "" : new StringBuilder(2).append("\"").append(col.name()).append("\"").toString();
            String notNull = !col.nullable() ? "NOT NULL" : "";
            Either<SchemaError, String> either = this.getVerticaTypeFromSparkType(col.dataType(), strlen, arrayLength, col.metadata());
            if (either instanceof Left) {
                Left left2 = (Left)either;
                SchemaError err = (SchemaError)left2.value();
                left = package$.MODULE$.Left().apply((Object)new SchemaConversionError(err).context("Schema error when trying to create table"));
            } else if (either instanceof Right) {
                Right right = (Right)either;
                String colType = (String)right.value();
                left = package$.MODULE$.Right().apply((Object)new StringBuilder(2).append(colName).append(" ").append(colType).append(" ").append(notNull).toString().trim());
            } else {
                throw new MatchError(either);
            }
            return left;
        }, Seq$.MODULE$.canBuildFrom())).toList();
        Either result = ((Validated)implicits$.MODULE$.toTraverseOps((Object)colDefsOrErrors, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$3 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$3), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)columnDef -> columnDef).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
        Either either = result;
        if (either instanceof Right) {
            Right right = (Right)either;
            List colDefList = (List)right.value();
            left = package$.MODULE$.Right().apply((Object)new StringBuilder(3).append(" (").append(colDefList.mkString(", ")).append(")").toString());
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ErrorList err = (ErrorList)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    @Override
    public Either<ConnectorError, String> getMergeInsertValues(JdbcLayerInterface jdbcLayer, TableName tableName, Option<ValidColumnList> copyColumnList) {
        Left left;
        Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tableName);
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq info = (Seq)right.value();
            left = package$.MODULE$.Right().apply((Object)((TraversableOnce)info.map((Function1 & Serializable & scala.Serializable)x -> new StringBuilder(5).append("temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).toString(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
        } else {
            throw new MatchError(either);
        }
        Left valueList = left;
        return valueList;
    }

    @Override
    public Either<ConnectorError, BoxedUnit> checkValidTableSchema(StructType schema) {
        return this.checkBlankColumnNames(schema).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.checkComplexTypesSchema(schema).map((Function1 & Serializable & scala.Serializable)_ -> {
            SchemaTools.$anonfun$checkValidTableSchema$2(_);
            return BoxedUnit.UNIT;
        }));
    }

    private Either<ConnectorError, BoxedUnit> checkComplexTypesSchema(StructType schema) {
        Tuple2<List<StructField>, List<StructField>> tuple2 = this.complexTypeUtils().getComplexTypeColumns(schema);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List nativeCols = (List)tuple2._1();
        List complexTypeCols = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nativeCols, (Object)complexTypeCols);
        Tuple2 tuple23 = tuple22;
        List nativeCols2 = (List)tuple23._1();
        List complexTypeCols2 = (List)tuple23._2();
        return nativeCols2.isEmpty() ? (complexTypeCols2.nonEmpty() ? package$.MODULE$.Left().apply((Object)new InvalidTableSchemaComplexType()) : package$.MODULE$.Left().apply((Object)new EmptySchemaError())) : this.checkMapColumnsSchema((List<StructField>)complexTypeCols2);
    }

    private Either<ErrorList, BoxedUnit> checkMapColumnsSchema(List<StructField> complexTypeCols) {
        return ((Validated)implicits$.MODULE$.toTraverseOps(((List)complexTypeCols.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SchemaTools.$anonfun$checkMapColumnsSchema$1(x$5)))).map((Function1 & Serializable & scala.Serializable)col -> this.checkMapContainsPrimitives(col.name(), (MapType)col.dataType()), List$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$6 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$6), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)x$7 -> {
            SchemaTools.$anonfun$checkMapColumnsSchema$5(x$7);
            return BoxedUnit.UNIT;
        }).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
    }

    private Either<ConnectorError, BoxedUnit> checkMapContainsPrimitives(String colName, MapType map) {
        Either<SchemaError, String> keyType = this.sparkPrimitiveToVerticaPrimitive(map.keyType(), 0L);
        Either<SchemaError, String> valueType = this.sparkPrimitiveToVerticaPrimitive(map.valueType(), 0L);
        return keyType.isRight() && valueType.isRight() ? package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT) : package$.MODULE$.Left().apply((Object)new InvalidMapSchemaError(colName));
    }

    @Override
    public Either<ConnectorError, String> getMergeUpdateValues(JdbcLayerInterface jdbcLayer, TableName tableName, TableName tempTableName, Option<ValidColumnList> copyColumnList) {
        Left left;
        Option<ValidColumnList> option = copyColumnList;
        if (option instanceof Some) {
            Left colList;
            Left left2;
            Some some = (Some)option;
            ValidColumnList list = (ValidColumnList)some.value();
            List customColList = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])list.toString().split(","))).toList().map((Function1 & Serializable & scala.Serializable)col -> col.trim(), List$.MODULE$.canBuildFrom());
            Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tempTableName);
            if (either instanceof Right) {
                Right right = (Right)either;
                Seq info = (Seq)right.value();
                List tupleList = (List)customColList.zip((GenIterable)info, List$.MODULE$.canBuildFrom());
                left2 = package$.MODULE$.Right().apply((Object)((TraversableOnce)tupleList.map((Function1 & Serializable & scala.Serializable)x -> new StringBuilder(6).append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes((String)x._1())).append("=temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(((ColumnDef)x._2()).label())).toString(), List$.MODULE$.canBuildFrom())).mkString(", "));
            } else if (either instanceof Left) {
                Left left3 = (Left)either;
                ConnectorError err = (ConnectorError)left3.value();
                left2 = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
            } else {
                throw new MatchError(either);
            }
            left = colList = left2;
        } else if (None$.MODULE$.equals(option)) {
            Left updateList;
            Left left4;
            Either<ConnectorError, Seq<ColumnDef>> either = this.getColumnInfo(jdbcLayer, tempTableName);
            if (either instanceof Right) {
                Right right = (Right)either;
                Seq info = (Seq)right.value();
                left4 = package$.MODULE$.Right().apply((Object)((TraversableOnce)info.map((Function1 & Serializable & scala.Serializable)x -> new StringBuilder(6).append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).append("=temp.").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(x.label())).toString(), Seq$.MODULE$.canBuildFrom())).mkString(", "));
            } else if (either instanceof Left) {
                Left left5 = (Left)either;
                ConnectorError err = (ConnectorError)left5.value();
                left4 = package$.MODULE$.Left().apply((Object)new JdbcSchemaError(err));
            } else {
                throw new MatchError(either);
            }
            left = updateList = left4;
        } else {
            throw new MatchError(option);
        }
        Left columnList = left;
        return columnList;
    }

    public String updateFieldDataType(String col, String colName, StructType schema, long strlen, long arrayLength) {
        Seq fieldType = (Seq)schema.collect((PartialFunction)new scala.Serializable(this, colName, strlen, arrayLength){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SchemaTools $outer;
            private final String colName$1;
            private final long strlen$3;
            private final long arrayLength$3;

            /*
             * Unable to fully structure code
             */
            public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> default) {
                block9: {
                    block6: {
                        block8: {
                            block7: {
                                var5_3 = x1;
                                if (var5_3 == null) break block6;
                                var6_4 = var5_3;
                                v0 = this.$outer.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(var6_4.name());
                                var7_5 = this.colName$1;
                                if (v0 != null ? v0.equals(var7_5) == false : var7_5 != null) break block6;
                                if (!var6_4.metadata().contains(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())) break block7;
                                v1 = var6_4.dataType().simpleString();
                                var8_6 = "string";
                                if (v1 != null ? v1.equals(var8_6) == false : var8_6 != null) break block7;
                                v2 = var6_4.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength()) > (long)this.$outer.com$vertica$spark$util$schema$SchemaTools$$longlength() ? new StringBuilder(14).append("long varchar(").append(BoxesRunTime.boxToLong((long)var6_4.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())).toString()).append(")").toString() : new StringBuilder(9).append("varchar(").append(BoxesRunTime.boxToLong((long)var6_4.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())).toString()).append(")").toString();
                                break block8;
                            }
                            if (!var6_4.metadata().contains(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())) ** GOTO lbl-1000
                            v3 = var6_4.dataType().simpleString();
                            var9_7 = "binary";
                            if (!(v3 != null ? v3.equals(var9_7) == false : var9_7 != null)) {
                                v2 = new StringBuilder(11).append("varbinary(").append(BoxesRunTime.boxToLong((long)var6_4.metadata().getLong(this.$outer.com$vertica$spark$util$schema$SchemaTools$$maxlength())).toString()).append(")").toString();
                            } else lbl-1000:
                            // 2 sources

                            {
                                if ((var10_8 = this.$outer.getVerticaTypeFromSparkType(var6_4.dataType(), this.strlen$3, this.arrayLength$3, var6_4.metadata())) instanceof Right) {
                                    var11_9 = (Right)var10_8;
                                    var4_11 = dataType = (String)var11_9.value();
                                } else if (var10_8 instanceof Left) {
                                    var13_12 = (Left)var10_8;
                                    err = (SchemaError)var13_12.value();
                                    var4_11 = package$.MODULE$.Left().apply((Object)err);
                                } else {
                                    throw new MatchError(var10_8);
                                }
                                v2 = var4_11;
                            }
                        }
                        var3_14 = v2;
                        break block9;
                    }
                    var3_14 = default.apply(x1);
                }
                return (B1)var3_14;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(StructField x1) {
                StructField structField = x1;
                if (structField == null) return false;
                StructField structField2 = structField;
                String string = this.$outer.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(structField2.name());
                String string2 = this.colName$1;
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.colName$1 = colName$1;
                this.strlen$3 = strlen$3;
                this.arrayLength$3 = arrayLength$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return fieldType.nonEmpty() ? new StringBuilder(1).append(colName).append(" ").append(fieldType.head()).toString() : col;
    }

    @Override
    public Either<ConnectorError, String> inferExternalTableSchema(String createExternalTableStmt, StructType schema, String tableName, long strlen, long arrayLength) {
        Right right;
        String stmt = createExternalTableStmt.replace(new StringBuilder(2).append("\"").append(tableName).append("\"").toString(), tableName);
        Tuple2<Object, Object> tuple2 = StringParsingUtils$.MODULE$.findFirstParenGroupIndices(stmt);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int openParen = tuple2._1$mcI$sp();
        int closingParen = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(openParen, closingParen);
        Tuple2.mcII.sp sp3 = sp2;
        int openParen2 = sp3._1$mcI$sp();
        int closingParen2 = sp3._2$mcI$sp();
        String schemaString = stmt.substring(openParen2 + 1, closingParen2);
        Seq<String> schemaList = StringParsingUtils$.MODULE$.splitByComma(schemaString);
        String updatedSchema = ((TraversableOnce)schemaList.map((Function1 & Serializable & scala.Serializable)colDef -> {
            String colName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])colDef.trim().split(" "))).head();
            return schema.nonEmpty() ? this.updateFieldDataType((String)colDef, colName, schema, strlen, arrayLength) : (colDef.toLowerCase().contains("varchar") ? new StringBuilder(10).append(colName).append(" varchar(").append(strlen).append(")").toString() : (colDef.toLowerCase().contains("varbinary") ? new StringBuilder(12).append(colName).append(" varbinary(").append(this.com$vertica$spark$util$schema$SchemaTools$$longlength()).append(")").toString() : colDef));
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
        if (updatedSchema.contains(this.unknown())) {
            right = package$.MODULE$.Left().apply((Object)new UnknownColumnTypesError().context(new StringBuilder(30).append(this.unknown()).append(" partitioned column data type.").toString()));
        } else {
            BoxedUnit boxedUnit;
            String updatedCreateTableStmt = stmt.replace(schemaString, updatedSchema);
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder(41).append("Updated create external table statement: ").append(updatedCreateTableStmt).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            right = package$.MODULE$.Right().apply((Object)updatedCreateTableStmt);
        }
        return right;
    }

    public Either<ConnectorError, BoxedUnit> checkBlankColumnNames(StructType schema) {
        return this.findEmptyColumnName$1(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).toList());
    }

    @Override
    public String addDbSchemaToQuery(String query, Option<String> dbSchema) {
        String string;
        Regex literalSourceWithSchema = new StringOps(Predef$.MODULE$.augmentString("\\.\".*\"")).r();
        List queryParts = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])query.split(" "))).toList();
        Option<String> option = dbSchema;
        if (option instanceof Some) {
            Some some = (Some)option;
            String schema = (String)some.value();
            string = this.addDbSchemaToQueryRecursion$1(queryParts, schema, "", false, literalSourceWithSchema).trim();
        } else if (None$.MODULE$.equals(option)) {
            string = query;
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private final ArrayType makeNestedArrays$1(long arrayDepth, DataType arrayElement) {
        while (arrayDepth > 0L) {
            arrayElement = ArrayType$.MODULE$.apply(arrayElement);
            --arrayDepth;
        }
        return ArrayType$.MODULE$.apply(arrayElement);
    }

    public static final /* synthetic */ Either $anonfun$getColumnInfo$1(SchemaTools $this, ResultSetMetaData rsmd$1, TableSource tableSource$1, JdbcLayerInterface jdbcLayer$1, int idx) {
        Right right;
        String columnLabel = rsmd$1.getColumnLabel(idx);
        String typeName = rsmd$1.getColumnTypeName(idx);
        int fieldSize = DecimalType$.MODULE$.MAX_PRECISION();
        int fieldScale = rsmd$1.getScale(idx);
        boolean isSigned = rsmd$1.isSigned(idx);
        boolean nullable = rsmd$1.isNullable(idx) != 0;
        Metadata metadata = new MetadataBuilder().putString(MetadataKey$.MODULE$.NAME(), columnLabel).build();
        int colType = rsmd$1.getColumnType(idx);
        ColumnDef colDef = new ColumnDef(columnLabel, colType, typeName, fieldSize, fieldScale, isSigned, nullable, metadata, ColumnDef$.MODULE$.apply$default$9());
        TableSource tableSource = tableSource$1;
        if (tableSource instanceof TableName) {
            Either<ConnectorError, ColumnDef> either;
            TableName tableName = (TableName)tableSource;
            String unQuotedName = tableName.getTableName().replaceAll("\"", "");
            String unQuotedDbSchema = tableName.getDbSchema().replaceAll("\"", "");
            int n = colType;
            switch (n) {
                case 2002: 
                case 2003: {
                    either = $this.ctTools.startQueryingVerticaComplexTypes(colDef, unQuotedName, unQuotedDbSchema, jdbcLayer$1);
                    break;
                }
                default: {
                    either = package$.MODULE$.Right().apply((Object)colDef);
                    break;
                }
            }
            right = either;
        } else if (tableSource instanceof TableQuery) {
            Right right2;
            TableQuery tableQuery = (TableQuery)tableSource;
            int n = colType;
            switch (n) {
                case 2002: 
                case 2003: {
                    right2 = package$.MODULE$.Left().apply((Object)new QueryReturnsComplexTypes(columnLabel, typeName, tableQuery.query()));
                    break;
                }
                default: {
                    right2 = package$.MODULE$.Right().apply((Object)colDef);
                    break;
                }
            }
            right = right2;
        } else {
            throw new MatchError((Object)tableSource);
        }
        return right;
    }

    private final Either recursion$1(DataType dataType, String leftAccumulator, String rightAccumulator, int depth, String keyword$1, String length$1, long strlen$1, long arrayLength$1, Metadata metadata$1) {
        Left left;
        DataType dataType2;
        while ((dataType2 = dataType) instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            ++depth;
            rightAccumulator = new StringBuilder(1).append(length$1).append("]").append(rightAccumulator).toString();
            leftAccumulator = new StringBuilder(1).append(leftAccumulator).append(keyword$1).append("[").toString();
            dataType = elementType;
        }
        Either<SchemaError, String> either = this.getVerticaTypeFromSparkType(dataType, strlen$1, arrayLength$1, metadata$1);
        if (either instanceof Right) {
            Right right = (Right)either;
            String verticaType = (String)right.value();
            left = package$.MODULE$.Right().apply((Object)new StringBuilder(0).append(leftAccumulator).append(verticaType).append(rightAccumulator).toString());
        } else if (either instanceof Left) {
            Left left2 = (Left)either;
            SchemaError error = (SchemaError)left2.value();
            left = package$.MODULE$.Left().apply((Object)error);
        } else {
            throw new MatchError(either);
        }
        Left left3 = left;
        return left3;
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$4(SchemaTools $this, ColumnDef column$1, IntRef colsFound$1, TableName tableName$1, StructField s) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(48).append("Comparing target table column: ").append(column$1.label()).append(" with DF column: ").append(s.name()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (s.name().equalsIgnoreCase(column$1.label())) {
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            ++colsFound$1.elem;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug(new StringBuilder(37).append("Column: ").append(s.name()).append(" found in target table and DF").toString());
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            if (!column$1.nullable()) {
                if (s.nullable()) {
                    if ($this.logger().underlying().isWarnEnabled()) {
                        $this.logger().underlying().warn(new StringBuilder(128).append("S2V: Column ").append(s.name()).append(" is NOT NULL in target table ").append(tableName$1.getFullTableName()).append(" but it's nullable in the DataFrame. Rows with NULL values in column ").append(s.name()).append(" will be rejected.").toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            throw Breaks$.MODULE$.break();
        }
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$2(SchemaTools $this, StructType schema$1, IntRef colsFound$1, TableName tableName$1, ColumnDef column) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug(new StringBuilder(43).append("Will check that target column: ").append(column.label()).append(" exist in DF").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> schema$1.foreach((Function1 & Serializable & scala.Serializable)s -> {
            SchemaTools.$anonfun$getCopyColumnList$4($this, column, colsFound$1, tableName$1, s);
            return BoxedUnit.UNIT;
        }));
    }

    public static final /* synthetic */ void $anonfun$getCopyColumnList$5(BooleanRef first$1, ObjectRef columnList$1, StructField s) {
        if (first$1.elem) {
            columnList$1.elem = new StringBuilder(1).append("\"").append(s.name()).toString();
            first$1.elem = false;
        } else {
            columnList$1.elem = new StringBuilder(3).append((String)columnList$1.elem).append("\",\"").append(s.name()).toString();
        }
    }

    public static final /* synthetic */ boolean $anonfun$makeColumnsString$2(ColumnDef cd$1, StructField field) {
        String string = field.name();
        String string2 = cd$1.label();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$makeColumnsString$1(StructType requiredSchema$1, ColumnDef cd) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema$1.fields())).exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)SchemaTools.$anonfun$makeColumnsString$2(cd, field)));
    }

    private final Function1 castToVarchar$1() {
        return (Function1 & Serializable & scala.Serializable)colName -> new StringBuilder(13).append((String)colName).append("::varchar AS ").append(this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes((String)colName)).toString();
    }

    private final String castToArray$1(ColumnDef colInfo) {
        String string;
        String colName = this.com$vertica$spark$util$schema$SchemaTools$$addDoubleQuotes(colInfo.label());
        Option option = colInfo.children().headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            ColumnDef element = (ColumnDef)some.value();
            string = new StringBuilder(15).append("(").append(colName).append("::ARRAY[").append(element.colTypeName()).append("]) as ").append(colName).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(22).append("(").append(colName).append("::ARRAY[UNKNOWN]) as ").append(colName).toString();
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$checkValidTableSchema$2(BoxedUnit _) {
    }

    public static final /* synthetic */ boolean $anonfun$checkMapColumnsSchema$1(StructField x$5) {
        return x$5.dataType() instanceof MapType;
    }

    public static final /* synthetic */ void $anonfun$checkMapColumnsSchema$5(List x$7) {
    }

    private final Either findEmptyColumnName$1(List fields) {
        Right right;
        block4: {
            Option option;
            while ((option = fields.headOption()) instanceof Some) {
                Some some = (Some)option;
                StructField column = (StructField)some.value();
                if (!column.name().isBlank()) {
                    fields = (List)fields.tail();
                    continue;
                }
                right = package$.MODULE$.Left().apply((Object)new BlankColumnNamesError());
                break block4;
            }
            if (None$.MODULE$.equals(option)) {
                right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else {
                throw new MatchError((Object)option);
            }
        }
        return right;
    }

    private static final boolean noSchemaFound$1(String source, Regex literalSourceWithSchema$1) {
        return source.contains("\"") ? literalSourceWithSchema$1.findFirstIn((CharSequence)source).isEmpty() : source.split("\\.").length < 2;
    }

    private static final String appendSchema$1(String dbSchema, String source, Regex literalSourceWithSchema$1) {
        return source.startsWith("(") ? source : (SchemaTools.noSchemaFound$1(source, literalSourceWithSchema$1) ? new StringBuilder(1).append(dbSchema).append(".").append(source).toString() : source);
    }

    private final String addDbSchemaToQueryRecursion$1(List parts, String dbSchema, String query, boolean foundFROMClause, Regex literalSourceWithSchema$1) {
        String string;
        block5: {
            Option option;
            while ((option = parts.headOption()) instanceof Some) {
                Some some = (Some)option;
                String head = (String)some.value();
                String string2 = head.toLowerCase();
                String string3 = "from";
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    foundFROMClause = true;
                    query = new StringBuilder(1).append(query).append(" ").append(head).toString();
                    parts = (List)parts.tail();
                    continue;
                }
                if (!foundFROMClause) {
                    query = new StringBuilder(1).append(query).append(" ").append(head).toString();
                    parts = (List)parts.tail();
                    continue;
                }
                String dataSource = SchemaTools.appendSchema$1(dbSchema, head, literalSourceWithSchema$1);
                string = new StringBuilder(2).append(query).append(" ").append(dataSource).append(" ").append(((TraversableOnce)parts.tail()).mkString(" ")).toString();
                break block5;
            }
            if (None$.MODULE$.equals(option)) {
                string = query;
            } else {
                throw new MatchError((Object)option);
            }
        }
        return string;
    }

    public SchemaTools(ComplexTypesSchemaTools ctTools) {
        this.ctTools = ctTools;
        this.logger = LogProvider$.MODULE$.getLogger(SchemaTools.class);
        this.unknown = "UNKNOWN";
        this.com$vertica$spark$util$schema$SchemaTools$$maxlength = "maxlength";
        this.com$vertica$spark$util$schema$SchemaTools$$longlength = 65000;
        this.complexTypeUtils = new ComplexTypeUtils();
    }
}

