/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.schema;

import cats.Applicative;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.config.TableQuery;
import com.vertica.spark.config.TableSource;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.ErrorList;
import com.vertica.spark.util.error.MissingSqlConversionError;
import com.vertica.spark.util.query.ColumnInfo;
import com.vertica.spark.util.query.ColumnsTable;
import com.vertica.spark.util.query.ComplexTypeInfo;
import com.vertica.spark.util.query.ComplexTypesTable;
import com.vertica.spark.util.schema.ColumnDef;
import com.vertica.spark.util.schema.ColumnDef$;
import com.vertica.spark.util.schema.ComplexTypesSchemaTools$;
import com.vertica.spark.util.schema.MetadataKey$;
import com.vertica.spark.util.schema.SchemaTools;
import com.vertica.spark.util.schema.SchemaTools$;
import java.io.Serializable;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0002\u0004\u0001#!)a\u0003\u0001C\u0001/!)\u0011\u0004\u0001C!5!)\u0011\u000b\u0001C\u0005%\")1\r\u0001C\u0005I\nq1k\u00195f[\u0006$vn\u001c7t-F\u0002$BA\u0004\t\u0003\u0019\u00198\r[3nC*\u0011\u0011BC\u0001\u0005kRLGN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\bm\u0016\u0014H/[2b\u0015\u0005y\u0011aA2p[\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u0007\u0013\t)bAA\u0006TG\",W.\u0019+p_2\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u0019!\t\u0019\u0002!A\u0007hKR\u001cu\u000e\\;n]&sgm\u001c\u000b\u00047}J\u0005c\u0001\u000f/c9\u0011Qd\u000b\b\u0003=%r!a\b\u0015\u000f\u0005\u0001:cBA\u0011'\u001d\t\u0011S%D\u0001$\u0015\t!\u0003#\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0011QBD\u0005\u0003\u00171I!!\u0003\u0006\n\u0005)B\u0011!B3se>\u0014\u0018B\u0001\u0017.\u00035)%O]8s\u0011\u0006tG\r\\5oO*\u0011!\u0006C\u0005\u0003_A\u0012qbQ8o]\u0016\u001cGo\u001c:SKN,H\u000e\u001e\u0006\u0003Y5\u00022AM\u001d=\u001d\t\u0019dG\u0004\u0002#i%\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028q\u00059\u0001/Y2lC\u001e,'\"A\u001b\n\u0005iZ$aA*fc*\u0011q\u0007\u000f\t\u0003'uJ!A\u0010\u0004\u0003\u0013\r{G.^7o\t\u00164\u0007\"\u0002!\u0003\u0001\u0004\t\u0015!\u00036eE\u000ed\u0015-_3s!\t\u0011u)D\u0001D\u0015\t!U)\u0001\u0003kI\n\u001c'B\u0001$\u000b\u0003)!\u0017\r^1t_V\u00148-Z\u0005\u0003\u0011\u000e\u0013!C\u00133cG2\u000b\u00170\u001a:J]R,'OZ1dK\")!J\u0001a\u0001\u0017\u0006YA/\u00192mKN{WO]2f!\tau*D\u0001N\u0015\tq%\"\u0001\u0004d_:4\u0017nZ\u0005\u0003!6\u00131\u0002V1cY\u0016\u001cv.\u001e:dK\u0006\u00192\r[3dW\u001a{'oQ8na2,\u0007\u0010V=qKR)1\u000b\u0016,aEB\u0019AD\f\u001f\t\u000bU\u001b\u0001\u0019\u0001\u001f\u0002\u0007\r|G\u000eC\u0003X\u0007\u0001\u0007\u0001,A\u0005uC\ndWMT1nKB\u0011\u0011,\u0018\b\u00035n\u0003\"A\t\u001d\n\u0005qC\u0014A\u0002)sK\u0012,g-\u0003\u0002_?\n11\u000b\u001e:j]\u001eT!\u0001\u0018\u001d\t\u000b\u0005\u001c\u0001\u0019\u0001-\u0002\u0011\u0011\u00147k\u00195f[\u0006DQ\u0001Q\u0002A\u0002\u0005\u000b1c\u00195fG.4\u0016\u0007M\"p[BdW\r\u001f+za\u0016$RaU3hQ&DQA\u001a\u0003A\u0002q\naaY8m\t\u00164\u0007\"B,\u0005\u0001\u0004A\u0006\"B1\u0005\u0001\u0004A\u0006\"\u0002!\u0005\u0001\u0004\t\u0005")
public class SchemaToolsV10
extends SchemaTools {
    @Override
    public Either<ConnectorError, Seq<ColumnDef>> getColumnInfo(JdbcLayerInterface jdbcLayer, TableSource tableSource) {
        Left left;
        Either<ConnectorError, Seq<ColumnDef>> either = super.getColumnInfo(jdbcLayer, tableSource);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError err = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)err);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq colList = (Seq)right.value();
            left = ((Validated)implicits$.MODULE$.toTraverseOps((Object)((TraversableOnce)colList.map((Function1 & Serializable & scala.Serializable)col -> {
                Either<ConnectorError, ColumnDef> either;
                TableSource tableSource = tableSource;
                if (tableSource instanceof TableName) {
                    TableName tableName = (TableName)tableSource;
                    String unQuotedName = tableName.getTableName().replaceAll("\"", "");
                    String unQuotedDbSchema = tableName.getDbSchema().replaceAll("\"", "");
                    either = this.checkForComplexType((ColumnDef)col, unQuotedName, unQuotedDbSchema, jdbcLayer);
                } else if (tableSource instanceof TableQuery) {
                    either = package$.MODULE$.Right().apply(col);
                } else {
                    throw new MatchError((Object)tableSource);
                }
                return either;
            }, Seq$.MODULE$.canBuildFrom())).toList(), implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$9 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$9), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)list -> list).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    private Either<ConnectorError, ColumnDef> checkForComplexType(ColumnDef col, String tableName, String dbSchema, JdbcLayerInterface jdbcLayer) {
        Either<ConnectorError, ColumnDef> either;
        Either<MissingSqlConversionError, DataType> either2 = super.getCatalystTypeFromJdbcType(col.jdbcType(), 0, 0, false, "");
        if (either2 instanceof Right) {
            Right right = (Right)either2;
            DataType dataType = (DataType)right.value();
            DataType dataType2 = dataType;
            Either<ConnectorError, ColumnDef> either3 = StringType$.MODULE$.equals(dataType2) ? this.checkV10ComplexType(col, tableName, dbSchema, jdbcLayer) : package$.MODULE$.Right().apply((Object)col);
            either = either3;
        } else if (either2 instanceof Left) {
            either = package$.MODULE$.Right().apply((Object)col);
        } else {
            throw new MatchError(either2);
        }
        return either;
    }

    private Either<ConnectorError, ColumnDef> checkV10ComplexType(ColumnDef colDef, String tableName, String dbSchema, JdbcLayerInterface jdbcLayer) {
        Right right;
        ColumnInfo columnInfo;
        Left left;
        ComplexTypesTable complexTypesTable = new ComplexTypesTable(jdbcLayer);
        Either<ConnectorError, ColumnInfo> either = new ColumnsTable(jdbcLayer).getColumnInfo(colDef.label(), tableName, dbSchema);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            ConnectorError value = (ConnectorError)left2.value();
            left = package$.MODULE$.Left().apply((Object)value);
        } else if (either instanceof Right && (columnInfo = (ColumnInfo)(right = (Right)either).value()) != null) {
            Right right2;
            ColumnInfo columnInfo2 = columnInfo;
            long verticaType = columnInfo2.verticaType();
            Metadata metadata = new MetadataBuilder().putLong(MetadataKey$.MODULE$.DEPTH(), 0L).build();
            if (verticaType > ComplexTypesSchemaTools$.MODULE$.VERTICA_NATIVE_ARRAY_BASE_ID() && verticaType < ComplexTypesSchemaTools$.MODULE$.VERTICA_SET_MAX_ID()) {
                ColumnDef dummyChild = new ColumnDef("", 12, "STRING", 0, 0, false, false, metadata, ColumnDef$.MODULE$.apply$default$9());
                int x$1 = 2003;
                .colon.colon x$2 = new .colon.colon((Object)dummyChild, (List)Nil$.MODULE$);
                String x$3 = colDef.copy$default$1();
                String x$4 = colDef.copy$default$3();
                int x$5 = colDef.copy$default$4();
                int x$6 = colDef.copy$default$5();
                boolean x$7 = colDef.copy$default$6();
                boolean x$8 = colDef.copy$default$7();
                Metadata x$9 = colDef.copy$default$8();
                right2 = package$.MODULE$.Right().apply((Object)colDef.copy(x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$9, (List<ColumnDef>)x$2));
            } else {
                Right right3;
                Either<ConnectorError, ComplexTypeInfo> either2 = complexTypesTable.findComplexTypeInfo(verticaType);
                if (either2 instanceof Right) {
                    int x$10 = 2002;
                    Metadata x$11 = metadata;
                    String x$12 = colDef.copy$default$1();
                    String x$13 = colDef.copy$default$3();
                    int x$14 = colDef.copy$default$4();
                    int x$15 = colDef.copy$default$5();
                    boolean x$16 = colDef.copy$default$6();
                    boolean x$17 = colDef.copy$default$7();
                    List<ColumnDef> x$18 = colDef.copy$default$9();
                    right3 = package$.MODULE$.Right().apply((Object)colDef.copy(x$12, x$10, x$13, x$14, x$15, x$16, x$17, x$11, x$18));
                } else if (either2 instanceof Left) {
                    right3 = package$.MODULE$.Right().apply((Object)colDef);
                } else {
                    throw new MatchError(either2);
                }
                right2 = right3;
            }
            left = right2;
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    public SchemaToolsV10() {
        super(SchemaTools$.MODULE$.$lessinit$greater$default$1());
    }
}

