/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.v2;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.DistributedFilesystemReadConfig;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.ReadConfig;
import com.vertica.spark.datasource.core.DSConfigSetupInterface;
import com.vertica.spark.datasource.fs.HadoopFileStoreLayer$;
import com.vertica.spark.datasource.json.JsonBatchFactory;
import com.vertica.spark.datasource.json.VerticaJsonScan;
import com.vertica.spark.datasource.v2.NonPushFilter;
import com.vertica.spark.datasource.v2.PushFilter;
import com.vertica.spark.datasource.v2.UnknownColumnName;
import com.vertica.spark.datasource.v2.VerticaScan;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.ErrorHandling$;
import com.vertica.spark.util.pushdown.PushdownUtils$;
import com.vertica.spark.util.schema.ComplexTypesSchemaTools;
import com.vertica.spark.util.version.SparkVersionTools;
import com.vertica.spark.util.version.SparkVersionTools$;
import java.io.Serializable;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u000f\u001f\u0001%B\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\")A\u000b\u0001C\u0001+\"9!\f\u0001a\u0001\n#Y\u0006bB7\u0001\u0001\u0004%\tB\u001c\u0005\u0007k\u0002\u0001\u000b\u0015\u0002/\t\u000fY\u0004\u0001\u0019!C\to\"9a\u0010\u0001a\u0001\n#y\bbBA\u0002\u0001\u0001\u0006K\u0001\u001f\u0005\n\u0003\u000b\u0001\u0001\u0019!C\t\u0003\u000fA\u0011\"a\u0004\u0001\u0001\u0004%\t\"!\u0005\t\u0011\u0005U\u0001\u0001)Q\u0005\u0003\u0013A\u0011\"a\u0006\u0001\u0001\u0004%\t\"!\u0007\t\u0013\u0005\u001d\u0002\u00011A\u0005\u0012\u0005%\u0002\u0002CA\u0017\u0001\u0001\u0006K!a\u0007\t\u0013\u0005=\u0002A1A\u0005\u0012\u0005E\u0002\u0002CA\"\u0001\u0001\u0006I!a\r\t\u0013\u0005\u0015\u0003A1A\u0005\u0012\u0005\u001d\u0003\u0002CA-\u0001\u0001\u0006I!!\u0013\t\u0013\u0005m\u0003A1A\u0005\u0012\u0005u\u0003\u0002CA6\u0001\u0001\u0006I!a\u0018\t\u000f\u00055\u0004\u0001\"\u0011\u0002p!9\u0011q\u000f\u0001\u0005\n\u0005e\u0004B\u0002.\u0001\t\u0003\ny\bC\u0004\u0002\u0014\u0002!\t%!&\t\u000f\u0005]\u0005\u0001\"\u0011\u0002\u001a\"9\u0011Q\u0014\u0001\u0005\u0012\u0005}\u0005BBA^\u0001\u0011EqO\u0001\nWKJ$\u0018nY1TG\u0006t')^5mI\u0016\u0014(BA\u0010!\u0003\t1(G\u0003\u0002\"E\u0005QA-\u0019;bg>,(oY3\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u001d1XM\u001d;jG\u0006T\u0011aJ\u0001\u0004G>l7\u0001A\n\u0006\u0001)\u0012\u0014\t\u0012\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\nA\u0001\\1oO*\tq&\u0001\u0003kCZ\f\u0017BA\u0019-\u0005\u0019y%M[3diB\u00111gP\u0007\u0002i)\u0011QGN\u0001\u0005e\u0016\fGM\u0003\u00028q\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003si\n1a]9m\u0015\t\u00193H\u0003\u0002={\u00051\u0011\r]1dQ\u0016T\u0011AP\u0001\u0004_J<\u0017B\u0001!5\u0005-\u00196-\u00198Ck&dG-\u001a:\u0011\u0005M\u0012\u0015BA\"5\u0005]\u0019V\u000f\u001d9peR\u001c\b+^:i\t><hNR5mi\u0016\u00148\u000f\u0005\u00024\u000b&\u0011a\t\u000e\u0002 'V\u0004\bo\u001c:ugB+8\u000f\u001b#po:\u0014V-];je\u0016$7i\u001c7v[:\u001c\u0018AB2p]\u001aLw\r\u0005\u0002J\u00176\t!J\u0003\u0002HE%\u0011AJ\u0013\u0002\u000b%\u0016\fGmQ8oM&<\u0017a\u0004:fC\u0012\u001cuN\u001c4jON+G/\u001e9\u0011\u0007=\u0013\u0006*D\u0001Q\u0015\t\t\u0006%\u0001\u0003d_J,\u0017BA*Q\u0005Y!5kQ8oM&<7+\u001a;va&sG/\u001a:gC\u000e,\u0017A\u0002\u001fj]&$h\bF\u0002W1f\u0003\"a\u0016\u0001\u000e\u0003yAQaR\u0002A\u0002!CQ!T\u0002A\u00029\u000b1\u0002];tQ\u001aKG\u000e^3sgV\tA\fE\u0002^O*t!A\u00183\u000f\u0005}\u0013W\"\u00011\u000b\u0005\u0005D\u0013A\u0002\u001fs_>$h(C\u0001d\u0003\u0015\u00198-\u00197b\u0013\t)g-A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\rL!\u0001[5\u0003\t1K7\u000f\u001e\u0006\u0003K\u001a\u0004\"aV6\n\u00051t\"A\u0003)vg\"4\u0015\u000e\u001c;fe\u0006y\u0001/^:i\r&dG/\u001a:t?\u0012*\u0017\u000f\u0006\u0002pgB\u0011\u0001/]\u0007\u0002M&\u0011!O\u001a\u0002\u0005+:LG\u000fC\u0004u\u000b\u0005\u0005\t\u0019\u0001/\u0002\u0007a$\u0013'\u0001\u0007qkNDg)\u001b7uKJ\u001c\b%\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\u0016\u0003a\u0004\"!\u001f?\u000e\u0003iT!a\u001f\u001d\u0002\u000bQL\b/Z:\n\u0005uT(AC*ueV\u001cG\u000fV=qK\u0006\u0011\"/Z9vSJ,GmU2iK6\fw\fJ3r)\ry\u0017\u0011\u0001\u0005\bi\"\t\t\u00111\u0001y\u0003=\u0011X-];je\u0016$7k\u00195f[\u0006\u0004\u0013!D1hOB+8\u000f[3e\t><h.\u0006\u0002\u0002\nA\u0019\u0001/a\u0003\n\u0007\u00055aMA\u0004C_>dW-\u00198\u0002#\u0005<w\rU;tQ\u0016$Gi\\<o?\u0012*\u0017\u000fF\u0002p\u0003'A\u0001\u0002^\u0006\u0002\u0002\u0003\u0007\u0011\u0011B\u0001\u000fC\u001e<\u0007+^:iK\u0012$un\u001e8!\u0003\u001d9'o\\;q\u0005f,\"!a\u0007\u0011\u000bA\fi\"!\t\n\u0007\u0005}aMA\u0003BeJ\f\u0017\u0010E\u0002z\u0003GI1!!\n{\u0005-\u0019FO];di\u001aKW\r\u001c3\u0002\u0017\u001d\u0014x.\u001e9Cs~#S-\u001d\u000b\u0004_\u0006-\u0002\u0002\u0003;\u000f\u0003\u0003\u0005\r!a\u0007\u0002\u0011\u001d\u0014x.\u001e9Cs\u0002\na\u0001\\8hO\u0016\u0014XCAA\u001a!\u0011\t)$a\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\tAb]2bY\u0006dwnZ4j]\u001eT1!!\u0010'\u0003!!\u0018\u0010]3tC\u001a,\u0017\u0002BA!\u0003o\u0011a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\bGR$vn\u001c7t+\t\tI\u0005\u0005\u0003\u0002L\u0005USBAA'\u0015\u0011\ty%!\u0015\u0002\rM\u001c\u0007.Z7b\u0015\r\t\u0019FI\u0001\u0005kRLG.\u0003\u0003\u0002X\u00055#aF\"p[BdW\r\u001f+za\u0016\u001c8k\u00195f[\u0006$vn\u001c7t\u0003!\u0019G\u000fV8pYN\u0004\u0013!E:qCJ\\g+\u001a:tS>tGk\\8mgV\u0011\u0011q\f\t\u0005\u0003C\n9'\u0004\u0002\u0002d)!\u0011QMA)\u0003\u001d1XM]:j_:LA!!\u001b\u0002d\t\t2\u000b]1sWZ+'o]5p]R{w\u000e\\:\u0002%M\u0004\u0018M]6WKJ\u001c\u0018n\u001c8U_>d7\u000fI\u0001\u0006EVLG\u000e\u001a\u000b\u0003\u0003c\u00022aMA:\u0013\r\t)\b\u000e\u0002\u0005'\u000e\fg.A\u0004vg\u0016T5o\u001c8\u0015\t\u0005%\u00111\u0010\u0005\u0007\u0003{:\u0002\u0019\u0001%\u0002\u0007\r4w\r\u0006\u0003\u0002\u0002\u0006=\u0005#\u00029\u0002\u001e\u0005\r\u0005\u0003BAC\u0003\u0017k!!a\"\u000b\u0007\u0005%\u0005(A\u0004t_V\u00148-Z:\n\t\u00055\u0015q\u0011\u0002\u0007\r&dG/\u001a:\t\u000f\u0005E\u0005\u00041\u0001\u0002\u0002\u00069a-\u001b7uKJ\u001c\u0018!\u00049vg\",GMR5mi\u0016\u00148\u000f\u0006\u0002\u0002\u0002\u0006a\u0001O];oK\u000e{G.^7ogR\u0019q.a'\t\u000bYT\u0002\u0019\u0001=\u0002\u0015\u001d,GoQ8m)f\u0004X\r\u0006\u0003\u0002\"\u0006\u001d\u0006cA=\u0002$&\u0019\u0011Q\u0015>\u0003\u0011\u0011\u000bG/\u0019+za\u0016Dq!!+\u001c\u0001\u0004\tY+A\u0004d_2t\u0015-\\3\u0011\t\u00055\u0016Q\u0017\b\u0005\u0003_\u000b\t\f\u0005\u0002`M&\u0019\u00111\u00174\u0002\rA\u0013X\rZ3g\u0013\u0011\t9,!/\u0003\rM#(/\u001b8h\u0015\r\t\u0019LZ\u0001\fi\u0006\u0014G.Z*dQ\u0016l\u0017\r")
public class VerticaScanBuilder
implements SupportsPushDownFilters,
SupportsPushDownRequiredColumns {
    private final ReadConfig config;
    private final DSConfigSetupInterface<ReadConfig> readConfigSetup;
    private List<PushFilter> pushFilters;
    private StructType requiredSchema;
    private boolean aggPushedDown;
    private StructField[] groupBy;
    private final Logger logger;
    private final ComplexTypesSchemaTools ctTools;
    private final SparkVersionTools sparkVersionTools;

    public List<PushFilter> pushFilters() {
        return this.pushFilters;
    }

    public void pushFilters_$eq(List<PushFilter> x$1) {
        this.pushFilters = x$1;
    }

    public StructType requiredSchema() {
        return this.requiredSchema;
    }

    public void requiredSchema_$eq(StructType x$1) {
        this.requiredSchema = x$1;
    }

    public boolean aggPushedDown() {
        return this.aggPushedDown;
    }

    public void aggPushedDown_$eq(boolean x$1) {
        this.aggPushedDown = x$1;
    }

    public StructField[] groupBy() {
        return this.groupBy;
    }

    public void groupBy_$eq(StructField[] x$1) {
        this.groupBy = x$1;
    }

    public Logger logger() {
        return this.logger;
    }

    public ComplexTypesSchemaTools ctTools() {
        return this.ctTools;
    }

    public SparkVersionTools sparkVersionTools() {
        return this.sparkVersionTools;
    }

    public Scan build() {
        ReadConfig cfg = this.config.copyConfig();
        cfg.setPushdownFilters(this.pushFilters());
        cfg.setRequiredSchema(this.requiredSchema());
        cfg.setPushdownAgg(this.aggPushedDown());
        cfg.setGroupBy(this.groupBy());
        return this.useJson(cfg) ? new VerticaJsonScan(cfg, this.readConfigSetup, new JsonBatchFactory(), HadoopFileStoreLayer$.MODULE$.make(this.config)) : new VerticaScan(cfg, this.readConfigSetup);
    }

    private boolean useJson(ReadConfig cfg) {
        boolean bl;
        block7: {
            block4: {
                StructType requiredSchema;
                Either either;
                DistributedFilesystemReadConfig distributedFilesystemReadConfig;
                block6: {
                    Either either2;
                    Tuple2 tuple2;
                    block5: {
                        ReadConfig readConfig = cfg;
                        if (!(readConfig instanceof DistributedFilesystemReadConfig)) break block4;
                        distributedFilesystemReadConfig = (DistributedFilesystemReadConfig)readConfig;
                        tuple2 = new Tuple2(this.readConfigSetup.getTableSchema(distributedFilesystemReadConfig), (Object)distributedFilesystemReadConfig.getRequiredSchema());
                        if (tuple2 == null) break block5;
                        either = (Either)tuple2._1();
                        requiredSchema = (StructType)tuple2._2();
                        if (either instanceof Right) break block6;
                    }
                    if (tuple2 != null && (either2 = (Either)tuple2._1()) instanceof Left) {
                        Left left = (Left)either2;
                        ConnectorError err = (ConnectorError)left.value();
                        throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), err);
                    }
                    throw new MatchError((Object)tuple2);
                }
                Right right = (Right)either;
                StructType metadataSchema = (StructType)right.value();
                StructType schema = requiredSchema.nonEmpty() ? requiredSchema : metadataSchema;
                boolean bl2 = distributedFilesystemReadConfig.useJson() || this.ctTools().filterComplexTypeColumns(schema).nonEmpty();
                bl = bl2;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    public Filter[] pushFilters(Filter[] filters) {
        Tuple2 initialLists = new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$);
        Tuple2 tuple2 = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).map((Function1 & Serializable & scala.Serializable)filter -> PushdownUtils$.MODULE$.genFilter((Filter)filter), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Either.class))))).foldLeft((Object)initialLists, (Function2 & Serializable & scala.Serializable)(acc, filter) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = acc;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            List nonPushFilters = (List)tuple22._1();
            List pushFilters = (List)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)nonPushFilters, (Object)pushFilters);
            Tuple2 tuple24 = tuple23;
            List nonPushFilters2 = (List)tuple24._1();
            List pushFilters2 = (List)tuple24._2();
            Either either = filter;
            if (either instanceof Left) {
                Filter nonPushFilter;
                Left left = (Left)either;
                Filter filter2 = nonPushFilter = ((NonPushFilter)left.value()).filter();
                tuple2 = new Tuple2((Object)nonPushFilters2.$colon$colon((Object)new NonPushFilter(filter2)), (Object)pushFilters2);
            } else if (either instanceof Right) {
                PushFilter pushFilter;
                Right right = (Right)either;
                PushFilter pushFilter2 = pushFilter = (PushFilter)right.value();
                tuple2 = new Tuple2((Object)nonPushFilters2, (Object)pushFilters2.$colon$colon((Object)pushFilter2));
            } else {
                throw new MatchError((Object)either);
            }
            return tuple2;
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List nonPushFilters = (List)tuple2._1();
        List pushFilters = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nonPushFilters, (Object)pushFilters);
        Tuple2 tuple23 = tuple22;
        List nonPushFilters2 = (List)tuple23._1();
        List pushFilters2 = (List)tuple23._2();
        this.pushFilters_$eq((List<PushFilter>)pushFilters2);
        return (Filter[])((TraversableOnce)nonPushFilters2.map((Function1 & Serializable & scala.Serializable)x$5 -> ((NonPushFilter)x$5).filter(), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Filter.class));
    }

    public Filter[] pushedFilters() {
        return (Filter[])((TraversableOnce)this.pushFilters().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.filter(), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Filter.class));
    }

    public void pruneColumns(StructType requiredSchema) {
        this.requiredSchema_$eq(requiredSchema);
        this.aggPushedDown_$eq(false);
        this.groupBy_$eq((StructField[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(StructField.class)));
    }

    public DataType getColType(String colName) {
        Option option = this.tableSchema().find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)VerticaScanBuilder.$anonfun$getColType$1(colName, x$7)));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), new UnknownColumnName(colName));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        StructField col = (StructField)some.value();
        DataType dataType = col.dataType();
        return dataType;
    }

    public StructType tableSchema() {
        StructType schema;
        Either<ConnectorError, StructType> either = this.readConfigSetup.getTableSchema(this.config);
        if (!(either instanceof Right)) {
            if (either instanceof Left) {
                Left left = (Left)either;
                ConnectorError err = (ConnectorError)left.value();
                throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), err.context("Scan builder failed to get table schema"));
            }
            throw new MatchError(either);
        }
        Right right = (Right)either;
        StructType structType = schema = (StructType)right.value();
        return structType;
    }

    public static final /* synthetic */ boolean $anonfun$getColType$1(String colName$1, StructField x$7) {
        return x$7.name().equalsIgnoreCase(colName$1);
    }

    public VerticaScanBuilder(ReadConfig config, DSConfigSetupInterface<ReadConfig> readConfigSetup) {
        this.config = config;
        this.readConfigSetup = readConfigSetup;
        this.pushFilters = Nil$.MODULE$;
        this.requiredSchema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.aggPushedDown = false;
        this.groupBy = (StructField[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(StructField.class));
        this.logger = LogProvider$.MODULE$.getLogger(VerticaScanBuilder.class);
        this.ctTools = new ComplexTypesSchemaTools();
        this.sparkVersionTools = new SparkVersionTools(SparkVersionTools$.MODULE$.$lessinit$greater$default$1());
    }
}

