/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.version;

import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcUtils$;
import com.vertica.spark.util.error.ComplexTypeReadNotSupported;
import com.vertica.spark.util.error.ComplexTypeWriteNotSupported;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.ExportToJsonNotSupported;
import com.vertica.spark.util.error.InternalMapNotSupported;
import com.vertica.spark.util.error.NativeArrayReadNotSupported;
import com.vertica.spark.util.error.NativeArrayWriteNotSupported;
import com.vertica.spark.util.error.UnrecognizedVerticaVersionString;
import com.vertica.spark.util.schema.ComplexTypesSchemaTools;
import com.vertica.spark.util.version.Version;
import com.vertica.spark.util.version.Version$;
import java.io.Serializable;
import java.sql.ResultSet;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class VerticaVersionUtils$ {
    public static VerticaVersionUtils$ MODULE$;
    private final Version VERTICA_11;
    private final Version VERTICA_11_1;
    private final Version VERTICA_11_1_1;
    private final Version VERTICA_DEFAULT;
    private final ComplexTypesSchemaTools complexTypeUtils;

    static {
        new VerticaVersionUtils$();
    }

    public Version VERTICA_11() {
        return this.VERTICA_11;
    }

    public Version VERTICA_11_1() {
        return this.VERTICA_11_1;
    }

    public Version VERTICA_11_1_1() {
        return this.VERTICA_11_1_1;
    }

    public Version VERTICA_DEFAULT() {
        return this.VERTICA_DEFAULT;
    }

    public ComplexTypesSchemaTools complexTypeUtils() {
        return this.complexTypeUtils;
    }

    public Version getVersionOrDefault(JdbcLayerInterface jdbcLayer) {
        return (Version)this.getVersion(jdbcLayer).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.VERTICA_DEFAULT());
    }

    public Either<ConnectorError, Version> getVersion(JdbcLayerInterface jdbcLayer) {
        return JdbcUtils$.MODULE$.queryAndNext("SELECT version();", jdbcLayer, (Function1 & Serializable & scala.Serializable)rs -> MODULE$.extractVersion((ResultSet)rs), JdbcUtils$.MODULE$.queryAndNext$default$4());
    }

    private Either<ConnectorError, Version> extractVersion(ResultSet rs) {
        return this.parseVerticaVersionString(rs.getString(1));
    }

    public Either<ConnectorError, Version> parseVerticaVersionString(String versionString) {
        Left left;
        Regex pattern = new StringOps(Predef$.MODULE$.augmentString(".*v([0-9]+)\\.([0-9]+)\\.([0-9])+-([0-9]+).*")).r();
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String string = versionString;
            Option option = pattern.unapplySeq((CharSequence)string);
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(4) != 0) {
                throw new MatchError((Object)string);
            }
            String major = (String)((LinearSeqOptimized)option.get()).apply(0);
            String minor = (String)((LinearSeqOptimized)option.get()).apply(1);
            String service = (String)((LinearSeqOptimized)option.get()).apply(2);
            String hotfix = (String)((LinearSeqOptimized)option.get()).apply(3);
            Tuple4 tuple4 = new Tuple4((Object)major, (Object)minor, (Object)service, (Object)hotfix);
            Tuple4 tuple42 = tuple4;
            String major2 = (String)tuple42._1();
            String minor2 = (String)tuple42._2();
            String service2 = (String)tuple42._3();
            String hotfix2 = (String)tuple42._4();
            return new Version(new StringOps(Predef$.MODULE$.augmentString(major2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(minor2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(service2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(hotfix2)).toInt());
        });
        if (try_ instanceof Failure) {
            left = package$.MODULE$.Left().apply((Object)new UnrecognizedVerticaVersionString(versionString));
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            Version version = (Version)success.value();
            left = package$.MODULE$.Right().apply((Object)version);
        } else {
            throw new MatchError((Object)try_);
        }
        return left;
    }

    public Either<ConnectorError, BoxedUnit> checkSchemaTypesWriteSupport(StructType schema, Version version, boolean toInternalTable) {
        Tuple2<List<StructField>, List<StructField>> tuple2 = this.complexTypeUtils().filterColumnTypes(schema);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List nativeCols = (List)tuple2._1();
        List complexTypeCols = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nativeCols, (Object)complexTypeCols);
        Tuple2 tuple23 = tuple22;
        List nativeCols2 = (List)tuple23._1();
        List complexTypeCols2 = (List)tuple23._2();
        boolean complexTypeFound = complexTypeCols2.nonEmpty();
        List nativeArrayCols = (List)nativeCols2.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)VerticaVersionUtils$.$anonfun$checkSchemaTypesWriteSupport$1(x$3)));
        return version.major() <= 9 ? (complexTypeFound ? package$.MODULE$.Left().apply((Object)new ComplexTypeWriteNotSupported((List<StructField>)complexTypeCols2, version.toString())) : (nativeArrayCols.nonEmpty() ? package$.MODULE$.Left().apply((Object)new NativeArrayWriteNotSupported((List<StructField>)nativeArrayCols, version.toString())) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT))) : (version.major() == 10 ? (complexTypeFound ? package$.MODULE$.Left().apply((Object)new ComplexTypeWriteNotSupported((List<StructField>)complexTypeCols2, version.toString())) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)) : (toInternalTable && complexTypeCols2.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)VerticaVersionUtils$.$anonfun$checkSchemaTypesWriteSupport$2(x$4))) ? package$.MODULE$.Left().apply((Object)new InternalMapNotSupported()) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)));
    }

    public Either<ConnectorError, BoxedUnit> checkSchemaTypesReadSupport(StructType schema, Version version) {
        Tuple2<List<StructField>, List<StructField>> tuple2 = this.complexTypeUtils().filterColumnTypes(schema);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List nativeCols = (List)tuple2._1();
        List complexTypeCols = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)nativeCols, (Object)complexTypeCols);
        Tuple2 tuple23 = tuple22;
        List nativeCols2 = (List)tuple23._1();
        List complexTypeCols2 = (List)tuple23._2();
        List nativeArrayCols = (List)nativeCols2.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)VerticaVersionUtils$.$anonfun$checkSchemaTypesReadSupport$1(x$6)));
        return version.major() <= 10 ? (complexTypeCols2.nonEmpty() ? package$.MODULE$.Left().apply((Object)new ComplexTypeReadNotSupported((List<StructField>)complexTypeCols2, version.toString())) : (nativeArrayCols.nonEmpty() ? package$.MODULE$.Left().apply((Object)new NativeArrayReadNotSupported((List<StructField>)nativeArrayCols, version.toString())) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT))) : (version.lesserOrEqual(this.VERTICA_11_1()) ? (complexTypeCols2.nonEmpty() ? package$.MODULE$.Left().apply((Object)new ComplexTypeReadNotSupported((List<StructField>)complexTypeCols2, version.toString())) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT)) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    public Either<ConnectorError, BoxedUnit> checkJsonSupport(Version version) {
        return version.lessThan(this.VERTICA_11_1_1()) ? package$.MODULE$.Left().apply((Object)new ExportToJsonNotSupported(version.toString())) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    public static final /* synthetic */ boolean $anonfun$checkSchemaTypesWriteSupport$1(StructField x$3) {
        return x$3.dataType() instanceof ArrayType;
    }

    public static final /* synthetic */ boolean $anonfun$checkSchemaTypesWriteSupport$2(StructField x$4) {
        return x$4.dataType() instanceof MapType;
    }

    public static final /* synthetic */ boolean $anonfun$checkSchemaTypesReadSupport$1(StructField x$6) {
        return x$6.dataType() instanceof ArrayType;
    }

    private VerticaVersionUtils$() {
        MODULE$ = this;
        this.VERTICA_11 = new Version(11, Version$.MODULE$.apply$default$2(), Version$.MODULE$.apply$default$3(), Version$.MODULE$.apply$default$4());
        this.VERTICA_11_1 = new Version(11, 1, Version$.MODULE$.apply$default$3(), Version$.MODULE$.apply$default$4());
        this.VERTICA_11_1_1 = new Version(11, 1, 1, Version$.MODULE$.apply$default$4());
        this.VERTICA_DEFAULT = new Version(12, Version$.MODULE$.apply$default$2(), Version$.MODULE$.apply$default$3(), Version$.MODULE$.apply$default$4());
        this.complexTypeUtils = new ComplexTypesSchemaTools();
    }
}

