/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.json;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.DistributedFilesystemReadConfig;
import com.vertica.spark.config.FileStoreConfig;
import com.vertica.spark.config.JDBCConfig;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.ReadConfig;
import com.vertica.spark.config.TableSource;
import com.vertica.spark.config.ValidFilePermissions;
import com.vertica.spark.config.VerticaReadMetadata;
import com.vertica.spark.datasource.core.DSConfigSetupInterface;
import com.vertica.spark.datasource.core.PartitionInfo;
import com.vertica.spark.datasource.core.TableMetaInterface;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.json.JsonBatchFactory;
import com.vertica.spark.datasource.v2.VerticaScan;
import com.vertica.spark.util.cleanup.CleanupUtils;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.ErrorHandling$;
import com.vertica.spark.util.error.InitialSetupPartitioningError;
import java.io.Serializable;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.streaming.ContinuousStream;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\b\u0011\u0001mA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A\u0011\n\u0001B\u0001B\u0003%!\n\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u001dq\u0006A1A\u0005\n}Ca\u0001\u001b\u0001!\u0002\u0013\u0001\u0007bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007W\u0002\u0001\u000b\u0011B\u001c\t\u00111\u0004\u0001R1A\u0005\n5DQA\u001c\u0001\u0005B=DQA\u001e\u0001\u0005B]Dq!a\u0001\u0001\t\u0003\n)\u0001C\u0004\u0002\u000e\u0001!\t%a\u0004\u0003\u001fY+'\u000f^5dC*\u001bxN\\*dC:T!!\u0005\n\u0002\t)\u001cxN\u001c\u0006\u0003'Q\t!\u0002Z1uCN|WO]2f\u0015\t)b#A\u0003ta\u0006\u00148N\u0003\u0002\u00181\u00059a/\u001a:uS\u000e\f'\"A\r\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001aBe\r\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nA\u0001\\1oO*\t\u0011%\u0001\u0003kCZ\f\u0017BA\u0012\u001f\u0005\u0019y%M[3diB\u0011Q%M\u0007\u0002M)\u0011q\u0005K\u0001\u0005e\u0016\fGM\u0003\u0002*U\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003W1\n1a]9m\u0015\t)RF\u0003\u0002/_\u00051\u0011\r]1dQ\u0016T\u0011\u0001M\u0001\u0004_J<\u0017B\u0001\u001a'\u0005\u0011\u00196-\u00198\u0011\u0005\u0015\"\u0014BA\u001b'\u0005\u0015\u0011\u0015\r^2i\u0003\u0019\u0019wN\u001c4jOB\u0011\u0001HO\u0007\u0002s)\u0011a\u0007F\u0005\u0003we\u0012!BU3bI\u000e{gNZ5h\u0003=\u0011X-\u00193D_:4\u0017nZ*fiV\u0004(c\u0001 A\r\u001a!q\b\u0001\u0001>\u00051a$/\u001a4j]\u0016lWM\u001c;?!\r\tEiN\u0007\u0002\u0005*\u00111IE\u0001\u0005G>\u0014X-\u0003\u0002F\u0005\n1BiU\"p]\u001aLwmU3ukBLe\u000e^3sM\u0006\u001cW\rE\u0002B\u000f^J!\u0001\u0013\"\u0003%Q\u000b'\r\\3NKR\f\u0017J\u001c;fe\u001a\f7-Z\u0001\rE\u0006$8\r\u001b$bGR|'/\u001f\t\u0003\u00172k\u0011\u0001E\u0005\u0003\u001bB\u0011\u0001CS:p]\n\u000bGo\u00195GC\u000e$xN]=\u0002\u000f\u0019\u001cH*Y=feB\u0011\u0001kU\u0007\u0002#*\u0011!KE\u0001\u0003MNL!\u0001V)\u0003/\u0019KG.Z*u_J,G*Y=fe&sG/\u001a:gC\u000e,\u0017A\u0002\u001fj]&$h\bF\u0003X1fcV\f\u0005\u0002L\u0001!)a'\u0002a\u0001o!)A(\u0002a\u00015J\u00191\f\u0011$\u0007\t}\u0002\u0001A\u0017\u0005\u0006\u0013\u0016\u0001\rA\u0013\u0005\u0006\u001d\u0016\u0001\raT\u0001\u0007Y><w-\u001a:\u0016\u0003\u0001\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0015D\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\n\u0005\u001d\u0014'A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0002\u001d)\u001cxN\u001c*fC\u0012\u001cuN\u001c4jOV\tq'A\bkg>t'+Z1e\u0007>tg-[4!\u0003\u0015\u0011\u0017\r^2i+\u0005\u0019\u0014A\u0003:fC\u0012\u001c6\r[3nCR\t\u0001\u000f\u0005\u0002ri6\t!O\u0003\u0002tU\u0005)A/\u001f9fg&\u0011QO\u001d\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017a\u00059mC:Le\u000e];u!\u0006\u0014H/\u001b;j_:\u001cH#\u0001=\u0011\u0007edh0D\u0001{\u0015\u0005Y\u0018!B:dC2\f\u0017BA?{\u0005\u0015\t%O]1z!\t)s0C\u0002\u0002\u0002\u0019\u0012a\"\u00138qkR\u0004\u0016M\u001d;ji&|g.A\nde\u0016\fG/\u001a*fC\u0012,'OR1di>\u0014\u0018\u0010\u0006\u0002\u0002\bA\u0019Q%!\u0003\n\u0007\u0005-aE\u0001\fQCJ$\u0018\u000e^5p]J+\u0017\rZ3s\r\u0006\u001cGo\u001c:z\u0003\u001d!xNQ1uG\"$\u0012a\r")
public class VerticaJsonScan
implements Scan,
Batch {
    private Batch batch;
    private final ReadConfig config;
    private final DSConfigSetupInterface<ReadConfig> readConfigSetup;
    private final JsonBatchFactory batchFactory;
    private final FileStoreLayerInterface fsLayer;
    private final Logger logger;
    private final ReadConfig jsonReadConfig;
    private volatile boolean bitmap$0;

    public String description() {
        return super.description();
    }

    public MicroBatchStream toMicroBatchStream(String x$1) {
        return super.toMicroBatchStream(x$1);
    }

    public ContinuousStream toContinuousStream(String x$1) {
        return super.toContinuousStream(x$1);
    }

    public CustomMetric[] supportedCustomMetrics() {
        return super.supportedCustomMetrics();
    }

    private Logger logger() {
        return this.logger;
    }

    private ReadConfig jsonReadConfig() {
        return this.jsonReadConfig;
    }

    private Batch batch$lzycompute() {
        VerticaJsonScan verticaJsonScan = this;
        synchronized (verticaJsonScan) {
            if (!this.bitmap$0) {
                Batch batch;
                Either<ConnectorError, Option<PartitionInfo>> either = this.readConfigSetup.performInitialSetup(this.jsonReadConfig());
                if (either instanceof Left) {
                    Left left = (Left)either;
                    ConnectorError err = (ConnectorError)left.value();
                    throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), err);
                }
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Option opt = (Option)right.value();
                    Option option = opt;
                    if (None$.MODULE$.equals(option)) {
                        throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), new InitialSetupPartitioningError());
                    }
                    if (!(option instanceof Some)) {
                        throw new MatchError((Object)option);
                    }
                    Some some = (Some)option;
                    PartitionInfo partitionInfo = (PartitionInfo)some.value();
                    SparkSession sparkSession = (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> ErrorHandling$.MODULE$.logAndThrowError(this.logger(), new InitialSetupPartitioningError()));
                    Batch batch2 = this.batchFactory.build(partitionInfo.rootPath(), (Option<StructType>)new Some((Object)this.readSchema()), this.jsonReadConfig(), sparkSession);
                    Seq files = (Seq)this.fsLayer.getFileList(partitionInfo.rootPath()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ErrorHandling$.MODULE$.logAndThrowError(this.logger(), new InitialSetupPartitioningError()));
                    Either<ConnectorError, BoxedUnit> either2 = files.isEmpty() ? new CleanupUtils().cleanupAll(this.fsLayer, partitionInfo.rootPath()) : BoxedUnit.UNIT;
                    batch = batch2;
                } else {
                    throw new MatchError(either);
                }
                Batch batch3 = batch;
                this.batch = batch3;
                this.bitmap$0 = true;
            }
        }
        return this.batch;
    }

    private Batch batch() {
        return !this.bitmap$0 ? this.batch$lzycompute() : this.batch;
    }

    public StructType readSchema() {
        StructType requiredSchema;
        Either either;
        block5: {
            Either either2;
            Tuple2 tuple2;
            block4: {
                tuple2 = new Tuple2(((TableMetaInterface)((Object)this.readConfigSetup)).getTableMetadata(this.config), (Object)this.jsonReadConfig().getRequiredSchema());
                if (tuple2 == null) break block4;
                either = (Either)tuple2._1();
                requiredSchema = (StructType)tuple2._2();
                if (either instanceof Right) break block5;
            }
            if (tuple2 != null && (either2 = (Either)tuple2._1()) instanceof Left) {
                Left left = (Left)either2;
                ConnectorError err = (ConnectorError)left.value();
                throw ErrorHandling$.MODULE$.logAndThrowError(this.logger(), err);
            }
            throw new MatchError((Object)tuple2);
        }
        Right right = (Right)either;
        VerticaReadMetadata metadata = (VerticaReadMetadata)right.value();
        StructType structType = requiredSchema.nonEmpty() ? requiredSchema : metadata.schema();
        return structType;
    }

    public InputPartition[] planInputPartitions() {
        return this.batch().planInputPartitions();
    }

    public PartitionReaderFactory createReaderFactory() {
        return this.batch().createReaderFactory();
    }

    public Batch toBatch() {
        return this;
    }

    public VerticaJsonScan(ReadConfig config, DSConfigSetupInterface<ReadConfig> readConfigSetup, JsonBatchFactory batchFactory, FileStoreLayerInterface fsLayer) {
        ReadConfig readConfig;
        this.config = config;
        this.readConfigSetup = readConfigSetup;
        this.batchFactory = batchFactory;
        this.fsLayer = fsLayer;
        this.logger = LogProvider$.MODULE$.getLogger(VerticaScan.class);
        ReadConfig readConfig2 = config;
        if (readConfig2 instanceof DistributedFilesystemReadConfig) {
            DistributedFilesystemReadConfig distributedFilesystemReadConfig = (DistributedFilesystemReadConfig)readConfig2;
            boolean x$1 = true;
            JDBCConfig x$2 = distributedFilesystemReadConfig.copy$default$1();
            FileStoreConfig x$3 = distributedFilesystemReadConfig.copy$default$2();
            TableSource x$4 = distributedFilesystemReadConfig.copy$default$3();
            Option<Object> x$5 = distributedFilesystemReadConfig.copy$default$4();
            Option<VerticaReadMetadata> x$6 = distributedFilesystemReadConfig.copy$default$5();
            ValidFilePermissions x$7 = distributedFilesystemReadConfig.copy$default$6();
            int x$8 = distributedFilesystemReadConfig.copy$default$7();
            int x$9 = distributedFilesystemReadConfig.copy$default$8();
            boolean x$10 = distributedFilesystemReadConfig.copy$default$9();
            DistributedFilesystemReadConfig copied = distributedFilesystemReadConfig.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$1);
            copied.setGroupBy(distributedFilesystemReadConfig.getGroupBy());
            copied.setPushdownAgg(distributedFilesystemReadConfig.isAggPushedDown());
            copied.setPushdownFilters(distributedFilesystemReadConfig.getPushdownFilters());
            copied.setRequiredSchema(distributedFilesystemReadConfig.getRequiredSchema());
            readConfig = copied;
        } else {
            readConfig = config;
        }
        this.jsonReadConfig = readConfig;
    }
}

