/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.util.error;

import cats.Applicative;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.typesafe.scalalogging.Logger;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.ConnectorException;
import com.vertica.spark.util.error.ErrorList;
import com.vertica.spark.util.error.SchemaError;
import com.vertica.spark.util.error.SchemaErrorList;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Either;

public final class ErrorHandling$ {
    public static ErrorHandling$ MODULE$;
    private final String invariantViolation;

    static {
        new ErrorHandling$();
    }

    public String addCause(String errorText, Throwable throwable) {
        return new StringBuilder(27).append(errorText).append("\n\nCaused by:\n").append(throwable.toString()).append("\nStack trace:\n").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])throwable.getStackTrace())).mkString("\n")).toString();
    }

    public String addUserFriendlyCause(String errorText, Throwable throwable) {
        return new StringBuilder(12).append(errorText).append("\nCaused by: ").append(throwable.getMessage()).toString();
    }

    public String appendErrors(String errorText1, String errorText2) {
        return new StringBuilder(1).append(errorText1).append("\n").append(errorText2).toString();
    }

    public Nothing$ logAndThrowError(Logger logger, ConnectorError error) {
        BoxedUnit boxedUnit;
        if (logger.underlying().isErrorEnabled()) {
            logger.underlying().error(error.getFullContext());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        throw new ConnectorException(error);
    }

    public String invariantViolation() {
        return this.invariantViolation;
    }

    public <T> Either<ErrorList, Seq<T>> listToEither(List<Either<ConnectorError, T>> list) {
        return ((Validated)implicits$.MODULE$.toTraverseOps(list, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$1 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$1), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)field -> field).left().map((Function1 & Serializable & scala.Serializable)errors -> new ErrorList((NonEmptyList<ConnectorError>)errors));
    }

    public <T> Either<SchemaErrorList, Seq<T>> listToEitherSchema(List<Either<SchemaError, T>> list) {
        return ((Validated)implicits$.MODULE$.toTraverseOps(list, implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable & scala.Serializable)x$2 -> EitherOps$.MODULE$.toValidated$extension(implicits$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.leftMap$extension(implicits$.MODULE$.catsSyntaxEither(x$2), (Function1 & Serializable & scala.Serializable)err -> NonEmptyList$.MODULE$.one(err)))), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).toEither().map((Function1 & Serializable & scala.Serializable)field -> field).left().map((Function1 & Serializable & scala.Serializable)errors -> new SchemaErrorList((NonEmptyList<SchemaError>)errors));
    }

    private ErrorHandling$() {
        MODULE$ = this;
        this.invariantViolation = "This is likely a bug and should be reported to the developers here:\nhttps://github.com/vertica/spark-connector/issues";
    }
}

