/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.core;

import com.typesafe.scalalogging.Logger;
import com.vertica.spark.config.DistributedFilesystemWriteConfig;
import com.vertica.spark.config.EscapeUtils$;
import com.vertica.spark.config.LogProvider$;
import com.vertica.spark.config.TableName;
import com.vertica.spark.config.ValidColumnList;
import com.vertica.spark.config.ValidFilePermissions;
import com.vertica.spark.config.VerticaMetadata;
import com.vertica.spark.config.VerticaWriteMetadata;
import com.vertica.spark.datasource.core.CreateExternalTableOption;
import com.vertica.spark.datasource.core.DataBlock;
import com.vertica.spark.datasource.core.ExistingData$;
import com.vertica.spark.datasource.core.NewData$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipe$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$;
import com.vertica.spark.datasource.core.VerticaPipeInterface;
import com.vertica.spark.datasource.core.VerticaPipeWriteInterface;
import com.vertica.spark.datasource.fs.FileStoreLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.JdbcUtils$;
import com.vertica.spark.util.Timer;
import com.vertica.spark.util.error.CommitError;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.error.CreateExternalTableAlreadyExistsError;
import com.vertica.spark.util.error.CreateExternalTableMergeKey;
import com.vertica.spark.util.error.CreateTableError;
import com.vertica.spark.util.error.DropTableError;
import com.vertica.spark.util.error.DuplicateColumnsError;
import com.vertica.spark.util.error.FaultToleranceTestFail;
import com.vertica.spark.util.error.InferExternalSchemaError;
import com.vertica.spark.util.error.InferExternalTableSchemaError;
import com.vertica.spark.util.error.MergeColumnListError;
import com.vertica.spark.util.error.NonEmptyDataFrameError;
import com.vertica.spark.util.error.SchemaColumnListError;
import com.vertica.spark.util.error.TempTableExistsError;
import com.vertica.spark.util.error.ViewExistsError;
import com.vertica.spark.util.schema.SchemaToolsInterface;
import com.vertica.spark.util.table.TableUtilsInterface;
import com.vertica.spark.util.version.Version;
import com.vertica.spark.util.version.VerticaVersionUtils$;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\r\u0005e\u0001B%K\u0001UC\u0001b\u0019\u0001\u0003\u0006\u0004%\t\u0001\u001a\u0005\tU\u0002\u0011\t\u0011)A\u0005K\"A1\u000e\u0001BC\u0002\u0013\u0005A\u000e\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003n\u0011!!\bA!b\u0001\n\u0003)\b\u0002\u0003?\u0001\u0005\u0003\u0005\u000b\u0011\u0002<\t\u0011u\u0004!Q1A\u0005\u0002yD\u0011\"a\u0004\u0001\u0005\u0003\u0005\u000b\u0011B@\t\u0015\u0005E\u0001A!b\u0001\n\u0003\t\u0019\u0002\u0003\u0006\u0002\"\u0001\u0011\t\u0011)A\u0005\u0003+A!\"a\t\u0001\u0005\u000b\u0007I\u0011AA\u0013\u0011)\ti\u0003\u0001B\u0001B\u0003%\u0011q\u0005\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011%\t\t\u0005\u0001b\u0001\n\u0013\t\u0019\u0005\u0003\u0005\u0002V\u0001\u0001\u000b\u0011BA#\u0011%\t9\u0006\u0001b\u0001\n\u0013\tI\u0006\u0003\u0005\u0002b\u0001\u0001\u000b\u0011BA.\u0011%\t\u0019\u0007\u0001b\u0001\n\u0013\t)\u0007\u0003\u0005\u0002x\u0001\u0001\u000b\u0011BA4\u0011%\tI\b\u0001b\u0001\n\u0013\t)\u0007\u0003\u0005\u0002|\u0001\u0001\u000b\u0011BA4\u0011\u001d\ti\b\u0001C\u0001\u0003\u007fBq!a-\u0001\t\u0003\t)\fC\u0004\u0002@\u0002!\t!!1\t\u000f\u0005\u001d\b\u0001\"\u0003\u0002j\"9\u00111\u001e\u0001\u0005\n\u00055\bbBA\u007f\u0001\u0011\u0005\u0011q \u0005\b\u0005\u0003\u0001A\u0011\u0002B\u0002\u0011%\u00119\u0001\u0001b\u0001\n\u0003\u0011I\u0001\u0003\u0005\u0003\u0014\u0001\u0001\u000b\u0011\u0002B\u0006\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/AqA!\b\u0001\t\u0003\u0011y\u0002C\u0004\u0003,\u0001!\t!a@\t\u000f\t5\u0002\u0001\"\u0001\u00030!9!Q\t\u0001\u0005\u0002\t\u001d\u0003b\u0002B*\u0001\u0011\u0005!Q\u000b\u0005\b\u00057\u0002A\u0011\u0001B/\u0011\u001d\u0011\t\u0007\u0001C\t\u0005GBqAa\u001b\u0001\t\u0013\u0011iG\u0002\u0004\u0003p\u0001!%\u0011\u000f\u0005\u000b\u0005\u0017C#Q3A\u0005\u0002\t5\u0005B\u0003BKQ\tE\t\u0015!\u0003\u0003\u0010\"Q!q\u0013\u0015\u0003\u0016\u0004%\tA!'\t\u0015\t\u0005\u0006F!E!\u0002\u0013\u0011Y\nC\u0004\u00020!\"\tAa)\t\u0013\t5\u0006&!A\u0005\u0002\t=\u0006\"\u0003B[QE\u0005I\u0011\u0001B\\\u0011%\u0011i\rKI\u0001\n\u0003\u0011y\rC\u0005\u0003T\"\n\t\u0011\"\u0011\u0002f!I!Q\u001b\u0015\u0002\u0002\u0013\u0005\u0011Q\u0005\u0005\n\u0005/D\u0013\u0011!C\u0001\u00053D\u0011B!:)\u0003\u0003%\tEa:\t\u0013\tU\b&!A\u0005\u0002\t]\b\"\u0003B~Q\u0005\u0005I\u0011\tB\u007f\u0011%\u0019\t\u0001KA\u0001\n\u0003\u001a\u0019\u0001C\u0005\u0004\u0006!\n\t\u0011\"\u0011\u0004\b!I1\u0011\u0002\u0015\u0002\u0002\u0013\u000531B\u0004\n\u0007\u001f\u0001\u0011\u0011!E\u0005\u0007#1\u0011Ba\u001c\u0001\u0003\u0003EIaa\u0005\t\u000f\u0005=2\b\"\u0001\u0004,!I1QA\u001e\u0002\u0002\u0013\u00153q\u0001\u0005\n\u0007[Y\u0014\u0011!CA\u0007_A\u0011b!\u000e<\u0003\u0003%\tia\u000e\t\u000f\r%\u0003\u0001\"\u0003\u0004L!91q\u000b\u0001\u0005\u0002\re\u0003bBB3\u0001\u0011\u00051q\r\u0005\b\u0007W\u0002A\u0011AB7\u0011\u001d\u0019\t\b\u0001C\u0001\u0003\u007f<\u0011ba\u001dK\u0003\u0003E\ta!\u001e\u0007\u0011%S\u0015\u0011!E\u0001\u0007oBq!a\fG\t\u0003\u0019I\bC\u0005\u0004|\u0019\u000b\n\u0011\"\u0001\u0004~\t)c+\u001a:uS\u000e\fG)[:ue&\u0014W\u000f^3e\r&dWm]=ti\u0016lwK]5uKBK\u0007/\u001a\u0006\u0003\u00172\u000bAaY8sK*\u0011QJT\u0001\u000bI\u0006$\u0018m]8ve\u000e,'BA(Q\u0003\u0015\u0019\b/\u0019:l\u0015\t\t&+A\u0004wKJ$\u0018nY1\u000b\u0003M\u000b1aY8n\u0007\u0001\u0019B\u0001\u0001,]AB\u0011qKW\u0007\u00021*\t\u0011,A\u0003tG\u0006d\u0017-\u0003\u0002\\1\n1\u0011I\\=SK\u001a\u0004\"!\u00180\u000e\u0003)K!a\u0018&\u0003)Y+'\u000f^5dCBK\u0007/Z%oi\u0016\u0014h-Y2f!\ti\u0016-\u0003\u0002c\u0015\nIb+\u001a:uS\u000e\f\u0007+\u001b9f/JLG/Z%oi\u0016\u0014h-Y2f\u0003\u0019\u0019wN\u001c4jOV\tQ\r\u0005\u0002gQ6\tqM\u0003\u0002d\u001d&\u0011\u0011n\u001a\u0002!\t&\u001cHO]5ckR,GMR5mKNL8\u000f^3n/JLG/Z\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u001d\u0019LG.Z*u_J,G*Y=feV\tQ\u000e\u0005\u0002oc6\tqN\u0003\u0002q\u0019\u0006\u0011am]\u0005\u0003e>\u0014qCR5mKN#xN]3MCf,'/\u00138uKJ4\u0017mY3\u0002\u001f\u0019LG.Z*u_J,G*Y=fe\u0002\n\u0011B\u001b3cG2\u000b\u00170\u001a:\u0016\u0003Y\u0004\"a\u001e>\u000e\u0003aT!!\u001f'\u0002\t)$'mY\u0005\u0003wb\u0014!C\u00133cG2\u000b\u00170\u001a:J]R,'OZ1dK\u0006Q!\u000e\u001a2d\u0019\u0006LXM\u001d\u0011\u0002\u0017M\u001c\u0007.Z7b)>|Gn]\u000b\u0002\u007fB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011AB:dQ\u0016l\u0017MC\u0002\u0002\n9\u000bA!\u001e;jY&!\u0011QBA\u0002\u0005Q\u00196\r[3nCR{w\u000e\\:J]R,'OZ1dK\u0006a1o\u00195f[\u0006$vn\u001c7tA\u0005QA/\u00192mKV#\u0018\u000e\\:\u0016\u0005\u0005U\u0001\u0003BA\f\u0003;i!!!\u0007\u000b\t\u0005m\u0011qA\u0001\u0006i\u0006\u0014G.Z\u0005\u0005\u0003?\tIBA\nUC\ndW-\u0016;jYNLe\u000e^3sM\u0006\u001cW-A\u0006uC\ndW-\u0016;jYN\u0004\u0013\u0001\u00033bi\u0006\u001c\u0016N_3\u0016\u0005\u0005\u001d\u0002cA,\u0002*%\u0019\u00111\u0006-\u0003\u0007%sG/A\u0005eCR\f7+\u001b>fA\u00051A(\u001b8jiz\"b\"a\r\u00026\u0005]\u0012\u0011HA\u001e\u0003{\ty\u0004\u0005\u0002^\u0001!)1-\u0004a\u0001K\")1.\u0004a\u0001[\")A/\u0004a\u0001m\")Q0\u0004a\u0001\u007f\"9\u0011\u0011C\u0007A\u0002\u0005U\u0001\"CA\u0012\u001bA\u0005\t\u0019AA\u0014\u0003\u0019awnZ4feV\u0011\u0011Q\t\t\u0005\u0003\u000f\n\t&\u0004\u0002\u0002J)!\u00111JA'\u00031\u00198-\u00197bY><w-\u001b8h\u0015\r\tyEU\u0001\tif\u0004Xm]1gK&!\u00111KA%\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013!\u0004;f[B$\u0016M\u00197f\u001d\u0006lW-\u0006\u0002\u0002\\A\u0019a-!\u0018\n\u0007\u0005}sMA\u0005UC\ndWMT1nK\u0006qA/Z7q)\u0006\u0014G.\u001a(b[\u0016\u0004\u0013a\t'F\u000f\u0006\u001b\u0015l\u0018)B%F+V\tV0S\u000b\n\u000b5+R0N\u001f\u0012+u,\u0013(`/JKE+R\u000b\u0003\u0003O\u0002B!!\u001b\u0002t5\u0011\u00111\u000e\u0006\u0005\u0003[\ny'\u0001\u0003mC:<'BAA9\u0003\u0011Q\u0017M^1\n\t\u0005U\u00141\u000e\u0002\u0007'R\u0014\u0018N\\4\u0002I1+u)Q\"Z?B\u000b%+U+F)~\u0013VIQ!T\u000b~ku\nR#`\u0013:{vKU%U\u000b\u0002\n\u0011\u0006T#H\u0003\u000eKv\fU!S#V+EkX%O)f2tLU#C\u0003N+u,T(E\u000b~KejX,S\u0013R+\u0015A\u000b'F\u000f\u0006\u001b\u0015l\u0018)B%F+V\tV0J\u001dRKdg\u0018*F\u0005\u0006\u001bViX'P\t\u0016{\u0016JT0X%&#V\tI\u0001\fO\u0016$X*\u001a;bI\u0006$\u0018-\u0006\u0002\u0002\u0002B1\u00111QAT\u0003[sA!!\"\u0002\":!\u0011qQAO\u001d\u0011\tI)a'\u000f\t\u0005-\u0015\u0011\u0014\b\u0005\u0003\u001b\u000b9J\u0004\u0003\u0002\u0010\u0006UUBAAI\u0015\r\t\u0019\nV\u0001\u0007yI|w\u000e\u001e \n\u0003MK!!\u0015*\n\u0005=\u0003\u0016bAA\u0005\u001d&!\u0011qTA\u0004\u0003\u0015)'O]8s\u0013\u0011\t\u0019+!*\u0002\u001b\u0015\u0013(o\u001c:IC:$G.\u001b8h\u0015\u0011\ty*a\u0002\n\t\u0005%\u00161\u0016\u0002\u0010\u0007>tg.Z2u_J\u0014Vm];mi*!\u00111UAS!\r1\u0017qV\u0005\u0004\u0003c;'a\u0004,feRL7-Y'fi\u0006$\u0017\r^1\u0002!\u001d,G\u000fR1uC\ncwnY6TSj,WCAA\\!\u0019\t\u0019)a*\u0002:B\u0019q+a/\n\u0007\u0005u\u0006L\u0001\u0003M_:<\u0017\u0001G2iK\u000e\\7k\u00195f[\u00064uN\u001d#va2L7-\u0019;fgR!\u00111YAf!\u0019\t\u0019)a*\u0002FB\u0019q+a2\n\u0007\u0005%\u0007L\u0001\u0003V]&$\bbBA\u00031\u0001\u0007\u0011Q\u001a\t\u0005\u0003\u001f\f\u0019/\u0004\u0002\u0002R*!\u00111[Ak\u0003\u0015!\u0018\u0010]3t\u0015\u0011\t9.!7\u0002\u0007M\fHNC\u0002P\u00037TA!!8\u0002`\u00061\u0011\r]1dQ\u0016T!!!9\u0002\u0007=\u0014x-\u0003\u0003\u0002f\u0006E'AC*ueV\u001cG\u000fV=qK\u0006!2/\u001a;Ta\u0006\u00148nQ1mK:$\u0017M]\"p]\u001a$\"!!2\u0002\u0015\u001d,G/\u00113ee\u0016\u001c8\u000f\u0006\u0002\u0002pB!\u0011\u0011_A}\u001d\u0011\t\u00190!>\u0011\u0007\u0005=\u0005,C\u0002\u0002xb\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA;\u0003wT1!a>Y\u0003=!w\u000e\u0015:f/JLG/Z*uKB\u001cHCAAb\u0003]\u0019\u0007.Z2l'\u000eDW-\\1UsB,7oU;qa>\u0014H\u000f\u0006\u0003\u0002D\n\u0015\u0001\"B2\u001d\u0001\u0004)\u0017!\u0002;j[\u0016\u0014XC\u0001B\u0006!\u0011\u0011iAa\u0004\u000e\u0005\u0005\u001d\u0011\u0002\u0002B\t\u0003\u000f\u0011Q\u0001V5nKJ\fa\u0001^5nKJ\u0004\u0013aE:uCJ$\b+\u0019:uSRLwN\\,sSR,G\u0003BAb\u00053AqAa\u0007 \u0001\u0004\ty/\u0001\u0005v]&\fX/Z%e\u0003%9(/\u001b;f\t\u0006$\u0018\r\u0006\u0003\u0002D\n\u0005\u0002b\u0002B\u0012A\u0001\u0007!QE\u0001\u0005I\u0006$\u0018\rE\u0002^\u0005OI1A!\u000bK\u0005%!\u0015\r^1CY>\u001c7.A\tf]\u0012\u0004\u0016M\u001d;ji&|gn\u0016:ji\u0016\f!CY;jY\u0012\u001cu\u000e]=Ti\u0006$X-\\3oiRa\u0011q\u001eB\u0019\u0005k\u0011ID!\u0010\u0003B!9!1\u0007\u0012A\u0002\u0005=\u0018a\u0003;be\u001e,G\u000fV1cY\u0016DqAa\u000e#\u0001\u0004\ty/\u0001\u0006d_2,XN\u001c'jgRDqAa\u000f#\u0001\u0004\ty/A\u0002ve2DqAa\u0010#\u0001\u0004\ty/\u0001\tsK*,7\r^:UC\ndWMT1nK\"9!1\t\u0012A\u0002\u0005=\u0018A\u00034jY\u00164uN]7bi\u0006\u0019\"-^5mI6+'oZ3Ti\u0006$X-\\3oiRA\u0011q\u001eB%\u0005\u001b\u0012y\u0005C\u0004\u0003L\r\u0002\r!a\u0017\u0002\u001fQ\f'oZ3u)\u0006\u0014G.\u001a(b[\u0016DqAa\u000e$\u0001\u0004\ty\u000fC\u0004\u0003R\r\u0002\r!a<\u0002\u0013Q,W\u000e\u001d+bE2,\u0017\u0001\u00049fe\u001a|'/\\'fe\u001e,G\u0003BAb\u0005/BqA!\u0017%\u0001\u0004\ty/\u0001\bnKJ<Wm\u0015;bi\u0016lWM\u001c;\u00021%tg-\u001a:FqR,'O\\1m)\u0006\u0014G.Z*dQ\u0016l\u0017\r\u0006\u0002\u0003`A1\u00111QAT\u0003_\f1CY;jY\u0012LeNZ3s'R\fG/Z7f]R$b!a<\u0003f\t\u001d\u0004b\u0002B\u001eM\u0001\u0007\u0011q\u001e\u0005\b\u0005S2\u0003\u0019AAx\u0003%!\u0018M\u00197f\u001d\u0006lW-A\u0007hKR\u001cu\u000e\\;n]2K7\u000f^\u000b\u0003\u0005?\u0012\u0001DR1vYR$v\u000e\\3sC:\u001cW\rV3tiJ+7/\u001e7u'\u0019AcKa\u001d\u0003zA\u0019qK!\u001e\n\u0007\t]\u0004LA\u0004Qe>$Wo\u0019;\u0011\t\tm$Q\u0011\b\u0005\u0005{\u0012\tI\u0004\u0003\u0002\u0010\n}\u0014\"A-\n\u0007\t\r\u0005,A\u0004qC\u000e\\\u0017mZ3\n\t\t\u001d%\u0011\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0005\u0007C\u0016aB:vG\u000e,7o]\u000b\u0003\u0005\u001f\u00032a\u0016BI\u0013\r\u0011\u0019\n\u0017\u0002\b\u0005>|G.Z1o\u0003!\u0019XoY2fgN\u0004\u0013!\u00054bS2,GMU8xgB+'oY3oiV\u0011!1\u0014\t\u0004/\nu\u0015b\u0001BP1\n1Ai\\;cY\u0016\f!CZ1jY\u0016$'k\\<t!\u0016\u00148-\u001a8uAQ1!Q\u0015BU\u0005W\u00032Aa*)\u001b\u0005\u0001\u0001b\u0002BF[\u0001\u0007!q\u0012\u0005\b\u0005/k\u0003\u0019\u0001BN\u0003\u0011\u0019w\u000e]=\u0015\r\t\u0015&\u0011\u0017BZ\u0011%\u0011YI\fI\u0001\u0002\u0004\u0011y\tC\u0005\u0003\u0018:\u0002\n\u00111\u0001\u0003\u001c\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B]U\u0011\u0011yIa/,\u0005\tu\u0006\u0003\u0002B`\u0005\u0013l!A!1\u000b\t\t\r'QY\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa2Y\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0017\u0014\tMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003R*\"!1\u0014B^\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002Bn\u0005C\u00042a\u0016Bo\u0013\r\u0011y\u000e\u0017\u0002\u0004\u0003:L\b\"\u0003Brg\u0005\u0005\t\u0019AA\u0014\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u001e\t\u0007\u0005W\u0014\tPa7\u000e\u0005\t5(b\u0001Bx1\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tM(Q\u001e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0010\ne\b\"\u0003Brk\u0005\u0005\t\u0019\u0001Bn\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\u001d$q \u0005\n\u0005G4\u0014\u0011!a\u0001\u0003O\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003O\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003O\na!Z9vC2\u001cH\u0003\u0002BH\u0007\u001bA\u0011Ba9:\u0003\u0003\u0005\rAa7\u00021\u0019\u000bW\u000f\u001c;U_2,'/\u00198dKR+7\u000f\u001e*fgVdG\u000fE\u0002\u0003(n\u001aRaOB\u000b\u0007C\u0001\"ba\u0006\u0004\u001e\t=%1\u0014BS\u001b\t\u0019IBC\u0002\u0004\u001ca\u000bqA];oi&lW-\u0003\u0003\u0004 \re!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!11EB\u0015\u001b\t\u0019)C\u0003\u0003\u0004(\u0005=\u0014AA5p\u0013\u0011\u00119i!\n\u0015\u0005\rE\u0011!B1qa2LHC\u0002BS\u0007c\u0019\u0019\u0004C\u0004\u0003\fz\u0002\rAa$\t\u000f\t]e\b1\u0001\u0003\u001c\u00069QO\\1qa2LH\u0003BB\u001d\u0007\u000b\u0002RaVB\u001e\u0007\u007fI1a!\u0010Y\u0005\u0019y\u0005\u000f^5p]B9qk!\u0011\u0003\u0010\nm\u0015bAB\"1\n1A+\u001e9mKJB\u0011ba\u0012@\u0003\u0003\u0005\rA!*\u0002\u0007a$\u0003'\u0001\nuKN$h)Y;miR{G.\u001a:b]\u000e,GCBB'\u0007\u001f\u001a\u0019\u0006\u0005\u0004\u0002\u0004\u0006\u001d&Q\u0015\u0005\b\u0007#\u0002\u0005\u0019AA\u0014\u0003)\u0011xn^:D_BLW\r\u001a\u0005\b\u0007+\u0002\u0005\u0019AAx\u00031\u0011XM[3diN$\u0016M\u00197f\u0003-\u0001XM\u001d4pe6\u001cu\u000e]=\u0015\r\rm3QLB1!\u0019\t\u0019)a*\u0002(!91qL!A\u0002\u0005=\u0018!D2paf\u001cF/\u0019;f[\u0016tG\u000fC\u0004\u0004d\u0005\u0003\r!a\u0017\u0002\u0013Q\f'\r\\3oC6,\u0017!F2p[6LG\u000fR1uC&sGo\u001c,feRL7-\u0019\u000b\u0005\u0003\u0007\u001cI\u0007C\u0004\u0003<\t\u0003\r!a<\u00023\r|W.\\5u\t\u0006$\u0018-Q:FqR,'O\\1m)\u0006\u0014G.\u001a\u000b\u0005\u0003\u0007\u001cy\u0007C\u0004\u0003<\r\u0003\r!a<\u0002\r\r|W.\\5u\u0003\u00152VM\u001d;jG\u0006$\u0015n\u001d;sS\n,H/\u001a3GS2,7/_:uK6<&/\u001b;f!&\u0004X\r\u0005\u0002^\rN\u0011aI\u0016\u000b\u0003\u0007k\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122TCAB@U\u0011\t9Ca/")
public class VerticaDistributedFilesystemWritePipe
implements VerticaPipeInterface,
VerticaPipeWriteInterface {
    private volatile VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$ FaultToleranceTestResult$module;
    private final DistributedFilesystemWriteConfig config;
    private final FileStoreLayerInterface fileStoreLayer;
    private final JdbcLayerInterface jdbcLayer;
    private final SchemaToolsInterface schemaTools;
    private final TableUtilsInterface tableUtils;
    private final int dataSize;
    private final Logger logger;
    private final TableName tempTableName;
    private final String LEGACY_PARQUET_REBASE_MODE_IN_WRITE;
    private final String LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE;
    private final Timer timer;

    public static int $lessinit$greater$default$6() {
        return VerticaDistributedFilesystemWritePipe$.MODULE$.$lessinit$greater$default$6();
    }

    private VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$ FaultToleranceTestResult() {
        if (this.FaultToleranceTestResult$module == null) {
            this.FaultToleranceTestResult$lzycompute$1();
        }
        return this.FaultToleranceTestResult$module;
    }

    public DistributedFilesystemWriteConfig config() {
        return this.config;
    }

    public FileStoreLayerInterface fileStoreLayer() {
        return this.fileStoreLayer;
    }

    public JdbcLayerInterface jdbcLayer() {
        return this.jdbcLayer;
    }

    public SchemaToolsInterface schemaTools() {
        return this.schemaTools;
    }

    public TableUtilsInterface tableUtils() {
        return this.tableUtils;
    }

    public int dataSize() {
        return this.dataSize;
    }

    private Logger logger() {
        return this.logger;
    }

    private TableName tempTableName() {
        return this.tempTableName;
    }

    private String LEGACY_PARQUET_REBASE_MODE_IN_WRITE() {
        return this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE;
    }

    private String LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE() {
        return this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE;
    }

    @Override
    public Either<ConnectorError, VerticaMetadata> getMetadata() {
        return new Right((Object)new VerticaWriteMetadata());
    }

    @Override
    public Either<ConnectorError, Object> getDataBlockSize() {
        return new Right((Object)BoxesRunTime.boxToLong((long)this.dataSize()));
    }

    public Either<ConnectorError, BoxedUnit> checkSchemaForDuplicates(StructType schema) {
        String[] names = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)f -> f.name(), ClassTag$.MODULE$.apply(String.class));
        if (((String[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])names))).length != names.length) {
            return new Left((Object)new DuplicateColumnsError());
        }
        return new Right((Object)BoxedUnit.UNIT);
    }

    private void setSparkCalendarConf() {
        Option option = SparkSession$.MODULE$.getActiveSession();
        if (option instanceof Some) {
            Some some = (Some)option;
            SparkSession session = (SparkSession)some.value();
            session.sparkContext().setLocalProperty(this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE(), "CORRECTED");
            session.sparkContext().setLocalProperty(this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE(), "CORRECTED");
            return;
        }
        if (None$.MODULE$.equals(option)) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("No spark session found to set config");
                return;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    private String getAddress() {
        if (this.config().createExternalTable().isDefined()) {
            return this.config().fileStoreConfig().externalTableAddress();
        }
        return this.config().fileStoreConfig().address();
    }

    @Override
    public Either<ConnectorError, BoxedUnit> doPreWriteSteps() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.config().mergeKey().isDefined() && this.config().isOverwrite()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Save mode is specified as Overwrite during a merge.");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Writing data to Parquet file.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.checkSchemaForDuplicates(this.config().schema()).flatMap((Function1 & Serializable)x$16 -> {
            BoxedUnit boxedUnit = x$16;
            return this.checkSchemaTypesSupport(this.config()).map((Function1 & Serializable)x$1 -> {
                this.setSparkCalendarConf();
                BoxedUnit x$2 = BoxedUnit.UNIT;
                return new Tuple2(x$1, (Object)x$2);
            }).flatMap((Function1 & Serializable)x$15 -> {
                Tuple2 tuple2 = x$15;
                if (tuple2 != null) {
                    return (this.config().isOverwrite() && this.config().mergeKey().isEmpty() && !this.config().truncate() ? this.tableUtils().dropTable(this.config().tablename()) : new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable)x$14 -> {
                        BoxedUnit boxedUnit = x$14;
                        return (this.config().isOverwrite() && this.config().mergeKey().isEmpty() && this.config().truncate() ? this.tableUtils().truncateTable(this.config().tablename()) : new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable)x$13 -> {
                            BoxedUnit boxedUnit = x$13;
                            return (this.config().createExternalTable().isDefined() && this.config().mergeKey().isDefined() ? new Left((Object)new CreateExternalTableMergeKey()) : new Right((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable)x$12 -> {
                                BoxedUnit boxedUnit = x$12;
                                return this.tableUtils().tableExists(this.config().tablename()).flatMap((Function1 & Serializable)tableExistsPre -> VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$7(this, BoxesRunTime.unboxToBoolean((Object)tableExistsPre)));
                            });
                        });
                    });
                }
                throw new MatchError((Object)tuple2);
            });
        });
    }

    private Either<ConnectorError, BoxedUnit> checkSchemaTypesSupport(DistributedFilesystemWriteConfig config) {
        Version verticaVersion = VerticaVersionUtils$.MODULE$.getVersionOrDefault(this.jdbcLayer());
        boolean toInternalTable = config.createExternalTable().isEmpty();
        return VerticaVersionUtils$.MODULE$.checkSchemaTypesWriteSupport(config.schema(), verticaVersion, toInternalTable);
    }

    public Timer timer() {
        return this.timer;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Either<ConnectorError, BoxedUnit> startPartitionWrite(String uniqueId) {
        address = this.getAddress();
        v0 = StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(address), 1);
        var5_3 = "/";
        if (!(v0 == null ? var5_3 != null : v0.equals(var5_3) == false)) ** GOTO lbl-1000
        v1 = StringOps$.MODULE$.takeRight$extension(Predef$.MODULE$.augmentString(address), 1);
        var6_4 = "\\";
        if (!(v1 != null ? v1.equals(var6_4) == false : var6_4 != null)) lbl-1000:
        // 2 sources

        {
            v2 = "";
        } else {
            v2 = "/";
        }
        delimiter = v2;
        filename = new StringBuilder(15).append(address).append(delimiter).append(uniqueId).append(".snappy.parquet").toString();
        this.timer().startTime();
        var8_7 = this.fileStoreLayer().openWriteParquetFile(filename);
        if (var8_7 instanceof Left) {
            var9_8 = (Left)var8_7;
            err = (ConnectorError)var9_8.value();
            if (!this.config().fileStoreConfig().preventCleanup()) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder(31).append("Cleaning up all files in path: ").append(address).toString());
                    v3 = BoxedUnit.UNIT;
                } else {
                    v3 = BoxedUnit.UNIT;
                }
                v4 = this.fileStoreLayer().removeDir(address);
            } else {
                v4 = BoxedUnit.UNIT;
            }
            return new Left((Object)err);
        }
        if (var8_7 instanceof Right) {
            var11_10 = (Right)var8_7;
            var12_11 = (BoxedUnit)var11_10.value();
            v5 = BoxedUnit.UNIT;
            var13_12 = var12_11;
            if (!(v5 != null ? v5.equals(var13_12) == false : var13_12 != null)) {
                return new Right((Object)BoxedUnit.UNIT);
            }
        }
        throw new MatchError(var8_7);
    }

    @Override
    public Either<ConnectorError, BoxedUnit> writeData(DataBlock data) {
        Option<CreateExternalTableOption> option = this.config().createExternalTable();
        if (option instanceof Some) {
            Some some = (Some)option;
            CreateExternalTableOption value = (CreateExternalTableOption)some.value();
            CreateExternalTableOption createExternalTableOption = value;
            if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                return new Left((Object)new NonEmptyDataFrameError());
            }
            if (NewData$.MODULE$.equals(createExternalTableOption)) {
                return this.fileStoreLayer().writeDataToParquetFile(data);
            }
            throw new MatchError((Object)createExternalTableOption);
        }
        if (None$.MODULE$.equals(option)) {
            return this.fileStoreLayer().writeDataToParquetFile(data);
        }
        throw new MatchError(option);
    }

    @Override
    public Either<ConnectorError, BoxedUnit> endPartitionWrite() {
        this.timer().endTime();
        Option<CreateExternalTableOption> option = this.config().createExternalTable();
        if (option instanceof Some) {
            Some some = (Some)option;
            CreateExternalTableOption value = (CreateExternalTableOption)some.value();
            CreateExternalTableOption createExternalTableOption = value;
            if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                return new Right((Object)BoxedUnit.UNIT);
            }
            if (NewData$.MODULE$.equals(createExternalTableOption)) {
                return this.fileStoreLayer().closeWriteParquetFile();
            }
            throw new MatchError((Object)createExternalTableOption);
        }
        if (None$.MODULE$.equals(option)) {
            return this.fileStoreLayer().closeWriteParquetFile();
        }
        throw new MatchError(option);
    }

    public String buildCopyStatement(String targetTable, String columnList, String url, String rejectsTableName, String fileFormat) {
        if (this.config().mergeKey().isDefined()) {
            return new StringBuilder(60).append("COPY ").append(targetTable).append(" FROM '").append(url).append("' ON ANY NODE ").append(fileFormat).append(" REJECTED DATA AS TABLE ").append(rejectsTableName).append(" NO COMMIT").toString();
        }
        return new StringBuilder(61).append("COPY ").append(targetTable).append(" ").append(columnList).append(" FROM '").append(url).append("' ON ANY NODE ").append(fileFormat).append(" REJECTED DATA AS TABLE ").append(rejectsTableName).append(" NO COMMIT").toString();
    }

    public String buildMergeStatement(TableName targetTableName, String columnList, String tempTable) {
        Object object;
        String string;
        String string2;
        String targetTable = targetTableName.getFullTableName();
        Either<ConnectorError, String> either = this.schemaTools().getMergeUpdateValues(this.jdbcLayer(), targetTableName, this.tempTableName(), this.config().copyColumnList());
        if (either instanceof Right) {
            String values;
            Right right = (Right)either;
            string2 = values = (String)right.value();
        } else if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            string2 = new Left((Object)new MergeColumnListError(err));
        } else {
            throw new MatchError(either);
        }
        String updateColValues = string2;
        Either<ConnectorError, String> either2 = this.schemaTools().getMergeInsertValues(this.jdbcLayer(), this.tempTableName(), this.config().copyColumnList());
        if (either2 instanceof Right) {
            String values;
            Right right = (Right)either2;
            string = values = (String)right.value();
        } else if (either2 instanceof Left) {
            Left left = (Left)either2;
            ConnectorError err = (ConnectorError)left.value();
            string = new Left((Object)new MergeColumnListError(err));
        } else {
            throw new MatchError(either2);
        }
        String insertColValues = string;
        Option<ValidColumnList> option = this.config().mergeKey();
        if (option instanceof Some) {
            Some some = (Some)option;
            ValidColumnList key = (ValidColumnList)some.value();
            List trimmedCols = Predef$.MODULE$.wrapRefArray((Object[])key.toString().split(",")).toList().map((Function1 & Serializable)col -> col.trim());
            object = trimmedCols.map((Function1 & Serializable)trimmedCol -> new StringBuilder(13).append("target.").append((String)trimmedCol).append("=temp.").append((String)trimmedCol).toString()).mkString(" AND ");
        } else if (None$.MODULE$.equals(option)) {
            object = Nil$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        Nil$ mergeList = object;
        return new StringBuilder(112).append("MERGE INTO ").append(targetTable).append(" as target using ").append(tempTable).append(" as temp ON (").append(mergeList).append(") WHEN MATCHED THEN UPDATE SET ").append((Object)updateColValues).append(" WHEN NOT MATCHED THEN INSERT ").append(columnList).append(" VALUES (").append((Object)insertColValues).append(")").toString();
    }

    public Either<ConnectorError, BoxedUnit> performMerge(String mergeStatement) {
        BoxedUnit boxedUnit;
        Either ret = this.jdbcLayer().query(new StringBuilder(8).append("EXPLAIN ").append(mergeStatement).toString(), this.jdbcLayer().query$default$2()).map((Function1 & Serializable)rs -> {
            rs.close();
            BoxedUnit x$17 = BoxedUnit.UNIT;
            return new Tuple2(rs, (Object)x$17);
        }).flatMap((Function1 & Serializable)x$19 -> {
            Tuple2 tuple2 = x$19;
            if (tuple2 != null) {
                return this.jdbcLayer().execute(mergeStatement, this.jdbcLayer().execute$default$2()).map((Function1 & Serializable)x$18 -> {
                    boxedUnit = x$18;
                    return BoxedUnit.UNIT;
                });
            }
            throw new MatchError((Object)tuple2);
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Executing merge");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ret.left().map((Function1 & Serializable)err -> new CommitError((ConnectorError)err).context("performMerge: JDBC error when trying to merge"));
    }

    public Either<ConnectorError, String> inferExternalTableSchema() {
        BoxedUnit boxedUnit;
        String string;
        String tableName = this.config().tablename().getFullTableName().replaceAll("\"", "");
        Either<ConnectorError, Seq<String>> either = this.fileStoreLayer().getGlobStatus(EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(10).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress()), "/")).append("/*.parquet").toString(), EscapeUtils$.MODULE$.sqlEscape$default$2()));
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq list = (Seq)right.value();
            String url = list.nonEmpty() ? EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(10).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress()), "/")).append("/*.parquet").toString(), EscapeUtils$.MODULE$.sqlEscape$default$2()) : EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(13).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress()), "/")).append("/**/*.parquet").toString(), EscapeUtils$.MODULE$.sqlEscape$default$2());
            string = this.buildInferStatement(url, tableName);
        } else if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            string = err.getFullContext();
        } else {
            throw new MatchError(either);
        }
        String inferStatement = string;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(24).append("The infer statement is: ").append(inferStatement).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Either<ConnectorError, ResultSet> either2 = this.jdbcLayer().query(inferStatement, this.jdbcLayer().query$default$2());
        if (either2 instanceof Left) {
            Left left = (Left)either2;
            ConnectorError err = (ConnectorError)left.value();
            return new Left((Object)new InferExternalTableSchemaError(err));
        }
        if (either2 instanceof Right) {
            Right right;
            block20: {
                Right right2 = (Right)either2;
                try (ResultSet resultSet = (ResultSet)right2.value();){
                    try {
                        BoxedUnit boxedUnit2;
                        resultSet.next();
                        String createExternalTableStatement = resultSet.getString(1);
                        boolean isPartitioned = inferStatement.contains(EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(13).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.config().fileStoreConfig().externalTableAddress()), "/")).append("/**/*.parquet").toString(), EscapeUtils$.MODULE$.sqlEscape$default$2()));
                        if (!(isPartitioned || createExternalTableStatement.contains("varchar") || createExternalTableStatement.contains("varbinary"))) {
                            BoxedUnit boxedUnit3;
                            BoxedUnit boxedUnit4;
                            if (this.logger().underlying().isInfoEnabled()) {
                                this.logger().underlying().info("Inferring schema from parquet data");
                                boxedUnit4 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit4 = BoxedUnit.UNIT;
                            }
                            String updatedStatement = createExternalTableStatement.replace(new StringBuilder(2).append("\"").append(tableName).append("\"").toString(), tableName);
                            if (this.logger().underlying().isDebugEnabled()) {
                                this.logger().underlying().debug(new StringBuilder(40).append("The create external table statement is: ").append(updatedStatement).toString());
                                boxedUnit3 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit3 = BoxedUnit.UNIT;
                            }
                            right = new Right((Object)updatedStatement);
                            break block20;
                        }
                        if (this.logger().underlying().isInfoEnabled()) {
                            this.logger().underlying().info("Inferring partial schema from dataframe");
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        right = this.schemaTools().inferExternalTableSchema(createExternalTableStatement, this.config().schema(), tableName, this.config().strlen(), this.config().arrayLength());
                    }
                    catch (Throwable e) {
                        right = new Left((Object)new InferExternalSchemaError(e));
                    }
                }
            }
            return right;
        }
        throw new MatchError(either2);
    }

    public String buildInferStatement(String url, String tableName) {
        return new StringBuilder(105).append("SELECT INFER_TABLE_DDL('").append(url).append("' USING PARAMETERS format = 'parquet', table_name = '").append(tableName).append("', table_type = 'external');").toString();
    }

    private Either<ConnectorError, String> getColumnList() {
        Option<ValidColumnList> option = this.config().copyColumnList();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            ValidColumnList list = (ValidColumnList)some.value();
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder(66).append("Using custom COPY column list. Target table: ").append(this.config().tablename().getFullTableName()).append(", ").append("copy_column_list: ").append(list).append(".").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new Right((Object)new StringBuilder(2).append("(").append(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])list.toString().split(",")), (Function1 & Serializable)col -> col.trim(), ClassTag$.MODULE$.apply(String.class))).mkString(",")).append(")").toString());
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Building default copy column list");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return this.schemaTools().getCopyColumnList(this.jdbcLayer(), this.config().tablename(), this.config().schema()).left().map((Function1 & Serializable)err -> new SchemaColumnListError((ConnectorError)err).context("getColumnList: Error building default copy column list"));
        }
        throw new MatchError(option);
    }

    private Either<ConnectorError, FaultToleranceTestResult> testFaultTolerance(int rowsCopied, String rejectsTable) {
        BoxedUnit boxedUnit;
        String rejectsQuery = new StringBuilder(30).append("SELECT COUNT(*) as count FROM ").append(rejectsTable).toString();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder(48).append("Checking number of rejected rows via statement: ").append(rejectsQuery).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.jdbcLayer().query(rejectsQuery, this.jdbcLayer().query$default$2()).map((Function1 & Serializable)rs -> {
            Try res = Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> {
                BoxedUnit boxedUnit;
                if (rs.next()) {
                    return rs.getInt("count");
                }
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Could not retrieve rejected row count.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return 0;
            });
            rs.close();
            BoxedUnit x$23 = BoxedUnit.UNIT;
            return new Tuple3(rs, (Object)res, (Object)x$23);
        }).flatMap((Function1 & Serializable)x$29 -> {
            Tuple3 tuple3 = x$29;
            if (tuple3 != null) {
                Try res = (Try)tuple3._2();
                return JdbcUtils$.MODULE$.tryJdbcToResult(this.jdbcLayer(), res).map((Function1 & Serializable)rejectedCount -> VerticaDistributedFilesystemWritePipe.$anonfun$testFaultTolerance$4(this, rowsCopied, BoxesRunTime.unboxToInt((Object)rejectedCount))).flatMap((Function1 & Serializable)x$28 -> {
                    Tuple6 tuple6 = x$28;
                    if (tuple6 != null) {
                        Right right;
                        int rejectedCount = BoxesRunTime.unboxToInt((Object)tuple6._1());
                        double failedRowsPercent = BoxesRunTime.unboxToDouble((Object)tuple6._2());
                        boolean passedFaultToleranceTest = BoxesRunTime.unboxToBoolean((Object)tuple6._3());
                        if (rejectedCount == 0) {
                            BoxedUnit boxedUnit;
                            String dropRejectsTableStatement = new StringBuilder(29).append("DROP TABLE IF EXISTS ").append(rejectsTable).append(" CASCADE").toString();
                            if (this.logger().underlying().isInfoEnabled()) {
                                this.logger().underlying().info(new StringBuilder(36).append("Dropping Vertica rejects table now: ").append(dropRejectsTableStatement).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            right = this.jdbcLayer().execute(dropRejectsTableStatement, this.jdbcLayer().execute$default$2());
                        } else {
                            BoxedUnit boxedUnit;
                            String rejectsDataQuery = new StringBuilder(131).append("SELECT COUNT(*) count, MIN(rejected_data) example_data, rejected_reason FROM ").append(rejectsTable).append(" GROUP BY rejected_reason ORDER BY count DESC LIMIT 10").toString();
                            if (this.logger().underlying().isInfoEnabled()) {
                                this.logger().underlying().info(new StringBuilder(48).append("Getting summary of rejected rows via statement: ").append(rejectsDataQuery).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            this.jdbcLayer().query(rejectsDataQuery, this.jdbcLayer().query$default$2()).map((Function1 & Serializable)rs -> {
                                Try x$20 = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                                    BoxedUnit boxedUnit;
                                    BoxedUnit boxedUnit2;
                                    ResultSetMetaData rsmd = rs.getMetaData();
                                    if (this.logger().underlying().isErrorEnabled()) {
                                        this.logger().underlying().error("Found {} rejected rows, displaying up to 10 of the most common reasons:", (Object)BoxesRunTime.boxToInteger((int)rejectedCount));
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    }
                                    if (this.logger().underlying().isErrorEnabled()) {
                                        this.logger().underlying().error(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), rsmd.getColumnCount()).map((Function1 & Serializable)idx -> rsmd.getColumnName(BoxesRunTime.unboxToInt((Object)idx))).toList().mkString(" | "));
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    while (rs.next()) {
                                        BoxedUnit boxedUnit3;
                                        if (this.logger().underlying().isErrorEnabled()) {
                                            this.logger().underlying().error(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), rsmd.getColumnCount()).map((Function1 & Serializable)idx -> rs.getString(BoxesRunTime.unboxToInt((Object)idx))).toList().mkString(" | "));
                                            boxedUnit3 = BoxedUnit.UNIT;
                                            continue;
                                        }
                                        boxedUnit3 = BoxedUnit.UNIT;
                                    }
                                });
                                rs.close();
                                BoxedUnit x$21 = BoxedUnit.UNIT;
                                return new Tuple3(rs, (Object)x$20, (Object)x$21);
                            }).map((Function1 & Serializable)x$22 -> {
                                VerticaDistributedFilesystemWritePipe.$anonfun$testFaultTolerance$10(x$22);
                                return BoxedUnit.UNIT;
                            });
                            right = new Right((Object)BoxedUnit.UNIT);
                        }
                        return right.map((Function1 & Serializable)x$26 -> {
                            FaultToleranceTestResult testResult = new FaultToleranceTestResult(this, passedFaultToleranceTest, failedRowsPercent);
                            return new Tuple2(x$26, (Object)testResult);
                        }).map((Function1 & Serializable)x$27 -> {
                            Tuple2 tuple2 = x$27;
                            if (tuple2 != null) {
                                FaultToleranceTestResult testResult = (FaultToleranceTestResult)tuple2._2();
                                return testResult;
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }
                    throw new MatchError((Object)tuple6);
                });
            }
            throw new MatchError((Object)tuple3);
        });
    }

    public Either<ConnectorError, Object> performCopy(String copyStatement, TableName tablename) {
        BoxedUnit boxedUnit;
        String emptyCopy = new StringBuilder(14).append("COPY ").append(tablename.getFullTableName()).append(" FROM '';").toString();
        this.jdbcLayer().executeUpdate(emptyCopy, this.jdbcLayer().executeUpdate$default$2());
        Either ret = this.jdbcLayer().query(new StringBuilder(8).append("EXPLAIN ").append(copyStatement).toString(), this.jdbcLayer().query$default$2()).map((Function1 & Serializable)rs -> {
            rs.close();
            BoxedUnit x$30 = BoxedUnit.UNIT;
            return new Tuple2(rs, (Object)x$30);
        }).flatMap((Function1 & Serializable)x$31 -> {
            Tuple2 tuple2 = x$31;
            if (tuple2 != null) {
                return this.jdbcLayer().executeUpdate(copyStatement, this.jdbcLayer().executeUpdate$default$2()).map((Function1)(JFunction1.mcII.sp & Serializable)rowsCopied -> rowsCopied);
            }
            throw new MatchError((Object)tuple2);
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Performing copy from file store to Vertica");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ret.left().map((Function1 & Serializable)err -> new CommitError((ConnectorError)err).context("performCopy: JDBC error when trying to copy"));
    }

    public Either<ConnectorError, BoxedUnit> commitDataIntoVertica(String url) {
        BoxedUnit boxedUnit;
        int tableNameMaxLength = 30;
        Timer timer = new Timer(this.config().timeOperations(), this.logger(), "Copy and commit data into Vertica");
        timer.startTime();
        Either ret = this.jdbcLayer().configureSession(this.fileStoreLayer()).flatMap((Function1 & Serializable)x$46 -> {
            BoxedUnit boxedUnit = x$46;
            return this.getColumnList().left().map((Function1 & Serializable)x$32 -> x$32.context("commit: Failed to get column list")).map((Function1 & Serializable)columnList -> {
                String tableName = this.config().tablename().name();
                String sessionId = this.config().sessionId();
                return new Tuple3(columnList, (Object)tableName, (Object)sessionId);
            }).flatMap((Function1 & Serializable)x$45 -> {
                Tuple3 tuple3 = x$45;
                if (tuple3 != null) {
                    String columnList = (String)tuple3._1();
                    String tableName = (String)tuple3._2();
                    String sessionId = (String)tuple3._3();
                    return (this.config().mergeKey().isDefined() ? this.tableUtils().createTempTable(this.tempTableName(), this.config().schema(), this.config().strlen(), this.config().arrayLength()) : new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable)x$44 -> {
                        BoxedUnit boxedUnit = x$44;
                        return this.tableUtils().tempTableExists(this.tempTableName()).flatMap((Function1 & Serializable)tempTableExists -> VerticaDistributedFilesystemWritePipe.$anonfun$commitDataIntoVertica$6(this, tableName, tableNameMaxLength, sessionId, columnList, url, BoxesRunTime.unboxToBoolean((Object)tempTableExists)));
                    });
                }
                throw new MatchError((Object)tuple3);
            });
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Committing data into Vertica.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Either<ConnectorError, BoxedUnit> either = !this.config().fileStoreConfig().preventCleanup() ? this.fileStoreLayer().removeDir(this.config().fileStoreConfig().address()) : BoxedUnit.UNIT;
        timer.endTime();
        return ret;
    }

    public Either<ConnectorError, BoxedUnit> commitDataAsExternalTable(String url) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Timer timer = new Timer(this.config().timeOperations(), this.logger(), "Commit data as external table");
        timer.startTime();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Committing data as external table.");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.config().copyColumnList().isDefined()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Custom copy column list was specified, but will be ignored when creating new external table.");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Either ret = this.jdbcLayer().configureSession(this.fileStoreLayer()).map((Function1 & Serializable)x$47 -> {
            boolean bl;
            Option<CreateExternalTableOption> option = this.config().createExternalTable();
            if (option instanceof Some) {
                Some some = (Some)option;
                CreateExternalTableOption value = (CreateExternalTableOption)some.value();
                CreateExternalTableOption createExternalTableOption = value;
                if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                    bl = true;
                } else {
                    if (!NewData$.MODULE$.equals(createExternalTableOption)) throw new MatchError((Object)createExternalTableOption);
                    bl = false;
                }
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                bl = false;
            }
            boolean existingData = bl;
            return new Tuple2(x$47, (Object)BoxesRunTime.boxToBoolean((boolean)existingData));
        }).flatMap((Function1 & Serializable)x$51 -> {
            Tuple2 tuple2 = x$51;
            if (tuple2 != null) {
                boolean existingData = tuple2._2$mcZ$sp();
                return (existingData ? this.inferExternalTableSchema() : new Right((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable)createExternalTableStmt -> this.tableUtils().createExternalTable(this.config().tablename(), (Option<String>)(existingData ? new Some((Object)createExternalTableStmt.toString()) : this.config().targetTableSql()), this.config().schema(), this.config().strlen(), url, this.config().arrayLength()).flatMap((Function1 & Serializable)x$50 -> {
                    BoxedUnit boxedUnit = x$50;
                    return this.tableUtils().validateExternalTable(this.config().tablename(), this.config().schema()).flatMap((Function1 & Serializable)x$49 -> {
                        BoxedUnit boxedUnit = x$49;
                        return (this.config().saveJobStatusTable() ? this.tableUtils().updateJobStatusTable(this.config().tablename(), this.config().jdbcConfig().auth().user(), 0.0, this.config().sessionId(), true) : new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT)).map((Function1 & Serializable)x$48 -> {
                            boxedUnit = x$48;
                            return BoxedUnit.UNIT;
                        });
                    });
                }));
            }
            throw new MatchError((Object)tuple2);
        });
        timer.endTime();
        Either either = ret;
        if (either instanceof Left) {
            Left left = (Left)either;
            ConnectorError err = (ConnectorError)left.value();
            this.tableUtils().dropTable(this.config().tablename());
            return new Left((Object)err);
        }
        if (either instanceof Right) {
            return new Right((Object)BoxedUnit.UNIT);
        }
        throw new MatchError((Object)either);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Either<ConnectorError, BoxedUnit> commit() {
        Either either;
        String globPattern = "*.parquet";
        String url = EscapeUtils$.MODULE$.sqlEscape(new StringBuilder(1).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.getAddress()), "/")).append("/").append(globPattern).toString(), EscapeUtils$.MODULE$.sqlEscape$default$2());
        Either<ConnectorError, BoxedUnit> ret = this.config().createExternalTable().isDefined() ? this.commitDataAsExternalTable(url) : this.commitDataIntoVertica(url);
        Either<ConnectorError, BoxedUnit> either2 = ret;
        if (either2 instanceof Right) {
            either = this.jdbcLayer().commit().left().map((Function1 & Serializable)err -> new CommitError((ConnectorError)err).context("JDBC Error when trying to commit"));
        } else {
            if (!(either2 instanceof Left)) throw new MatchError(either2);
            Left left = (Left)either2;
            ConnectorError retError = (ConnectorError)left.value();
            Either<ConnectorError, BoxedUnit> either3 = this.jdbcLayer().rollback();
            if (either3 instanceof Right) {
                either = new Left((Object)retError);
            } else {
                if (!(either3 instanceof Left)) throw new MatchError(either3);
                Left left2 = (Left)either3;
                ConnectorError err2 = (ConnectorError)left2.value();
                either = new Left((Object)retError.context(new StringBuilder(36).append("JDBC Error when trying to rollback: ").append(err2.getFullContext()).toString()));
            }
        }
        Either result = either;
        this.jdbcLayer().close();
        return result;
    }

    private final void FaultToleranceTestResult$lzycompute$1() {
        VerticaDistributedFilesystemWritePipe verticaDistributedFilesystemWritePipe = this;
        synchronized (verticaDistributedFilesystemWritePipe) {
            if (this.FaultToleranceTestResult$module == null) {
                this.FaultToleranceTestResult$module = new VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$(this);
            }
        }
    }

    public static final /* synthetic */ Either $anonfun$doPreWriteSteps$15(VerticaDistributedFilesystemWritePipe $this, boolean tableExistsPost) {
        return (tableExistsPost || $this.config().createExternalTable().isDefined() ? new Right((Object)BoxedUnit.UNIT) : new Left((Object)new CreateTableError((Option<ConnectorError>)None$.MODULE$))).map((Function1 & Serializable)x$3 -> {
            boolean bl;
            ValidFilePermissions perm = $this.config().filePermissions();
            Option<CreateExternalTableOption> option = $this.config().createExternalTable();
            if (option instanceof Some) {
                Some some = (Some)option;
                CreateExternalTableOption value = (CreateExternalTableOption)some.value();
                CreateExternalTableOption createExternalTableOption = value;
                if (ExistingData$.MODULE$.equals(createExternalTableOption)) {
                    bl = true;
                } else {
                    if (!NewData$.MODULE$.equals(createExternalTableOption)) throw new MatchError((Object)createExternalTableOption);
                    bl = false;
                }
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                bl = false;
            }
            boolean existingData = bl;
            return new Tuple3(x$3, (Object)perm, (Object)BoxesRunTime.boxToBoolean((boolean)existingData));
        }).flatMap((Function1 & Serializable)x$6 -> {
            Tuple3 tuple3 = x$6;
            if (tuple3 != null) {
                ValidFilePermissions perm = (ValidFilePermissions)tuple3._2();
                boolean existingData = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
                return (existingData ? new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT) : $this.fileStoreLayer().createDir($this.getAddress(), perm.toString())).flatMap((Function1 & Serializable)x$5 -> {
                    BoxedUnit boxedUnit = x$5;
                    return ($this.config().saveJobStatusTable() ? $this.tableUtils().createAndInitJobStatusTable($this.config().tablename(), $this.config().jdbcConfig().auth().user(), $this.config().sessionId(), $this.config().isOverwrite() ? "OVERWRITE" : "APPEND") : new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT)).map((Function1 & Serializable)x$4 -> {
                        boxedUnit = x$4;
                        return BoxedUnit.UNIT;
                    });
                });
            }
            throw new MatchError((Object)tuple3);
        });
    }

    public static final /* synthetic */ Either $anonfun$doPreWriteSteps$12(VerticaDistributedFilesystemWritePipe $this, boolean tableExistsPre$1, boolean tempTableExists) {
        return (tempTableExists ? new Left((Object)new TempTableExistsError()) : new Right((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable)x$8 -> {
            BoxedUnit boxedUnit = x$8;
            return (!tableExistsPre$1 && $this.config().createExternalTable().isEmpty() ? $this.tableUtils().createTable($this.config().tablename(), $this.config().targetTableSql(), $this.config().schema(), $this.config().strlen(), $this.config().arrayLength()) : new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable)x$7 -> {
                BoxedUnit boxedUnit = x$7;
                return $this.tableUtils().tableExists($this.config().tablename()).flatMap((Function1 & Serializable)tableExistsPost -> VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$15($this, BoxesRunTime.unboxToBoolean((Object)tableExistsPost)));
            });
        });
    }

    public static final /* synthetic */ Either $anonfun$doPreWriteSteps$10(VerticaDistributedFilesystemWritePipe $this, boolean tableExistsPre$1, boolean viewExists) {
        return (viewExists ? new Left((Object)new ViewExistsError()) : new Right((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable)x$9 -> {
            BoxedUnit boxedUnit = x$9;
            return $this.tableUtils().tempTableExists($this.config().tablename()).flatMap((Function1 & Serializable)tempTableExists -> VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$12($this, tableExistsPre$1, BoxesRunTime.unboxToBoolean((Object)tempTableExists)));
        });
    }

    public static final /* synthetic */ Either $anonfun$doPreWriteSteps$7(VerticaDistributedFilesystemWritePipe $this, boolean tableExistsPre) {
        return ($this.config().isOverwrite() && $this.config().mergeKey().isEmpty() && tableExistsPre && !$this.config().truncate() ? new Left((Object)new DropTableError()) : new Right((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable)x$11 -> {
            BoxedUnit boxedUnit = x$11;
            return ($this.config().createExternalTable().isDefined() && tableExistsPre ? new Left((Object)new CreateExternalTableAlreadyExistsError()) : new Right((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable)x$10 -> {
                BoxedUnit boxedUnit = x$10;
                return $this.tableUtils().viewExists($this.config().tablename()).flatMap((Function1 & Serializable)viewExists -> VerticaDistributedFilesystemWritePipe.$anonfun$doPreWriteSteps$10($this, tableExistsPre, BoxesRunTime.unboxToBoolean((Object)viewExists)));
            });
        });
    }

    public static final /* synthetic */ Tuple6 $anonfun$testFaultTolerance$4(VerticaDistributedFilesystemWritePipe $this, int rowsCopied$1, int rejectedCount) {
        BoxedUnit boxedUnit;
        BoxedUnit x$24;
        BoxedUnit boxedUnit2;
        double failedRowsPercent = rowsCopied$1 > 0 ? (double)rejectedCount / ((double)rowsCopied$1 + (double)rejectedCount) : 1.0;
        boolean passedFaultToleranceTest = failedRowsPercent <= (double)$this.config().failedRowPercentTolerance();
        String tolerance_message = new StringBuilder(124).append("Number of rows_rejected=").append(rejectedCount).append(". rows_copied=").append(rowsCopied$1).append(". failedRowsPercent=").append(failedRowsPercent).append(". user's failed_rows_percent_tolerance=").append($this.config().failedRowPercentTolerance()).append(". passedFaultToleranceTest=").append(Boolean.toString(passedFaultToleranceTest)).toString();
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info("Verifying rows saved to Vertica is within user tolerance...");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = x$24 = BoxedUnit.UNIT;
        }
        if ($this.logger().underlying().isInfoEnabled()) {
            $this.logger().underlying().info(new StringBuilder(0).append(tolerance_message).append((Object)(passedFaultToleranceTest ? "...PASSED.  OK to commit to database." : "...FAILED.  NOT OK to commit to database")).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit x$25 = boxedUnit;
        return new Tuple6((Object)BoxesRunTime.boxToInteger((int)rejectedCount), (Object)BoxesRunTime.boxToDouble((double)failedRowsPercent), (Object)BoxesRunTime.boxToBoolean((boolean)passedFaultToleranceTest), (Object)tolerance_message, (Object)x$24, (Object)x$25);
    }

    public static final /* synthetic */ void $anonfun$testFaultTolerance$10(Tuple3 x$22) {
        Tuple3 tuple3 = x$22;
        if (tuple3 != null) {
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ Either $anonfun$commitDataIntoVertica$13(VerticaDistributedFilesystemWritePipe $this, String rejectsTableName$1, String columnList$1, int rowsCopied) {
        return $this.testFaultTolerance(rowsCopied, rejectsTableName$1).left().map((Function1 & Serializable)err -> new CommitError((ConnectorError)err).context("commit: JDBC Error when trying to determine fault tolerance")).flatMap((Function1 & Serializable)faultToleranceResults -> ($this.config().saveJobStatusTable() ? $this.tableUtils().updateJobStatusTable($this.config().tablename(), $this.config().jdbcConfig().auth().user(), faultToleranceResults.failedRowsPercent(), $this.config().sessionId(), faultToleranceResults.success()) : new Either<ConnectorError, BoxedUnit>((Object)BoxedUnit.UNIT)).flatMap((Function1 & Serializable)x$41 -> {
            BoxedUnit boxedUnit = x$41;
            return (faultToleranceResults.success() ? new Right((Object)BoxedUnit.UNIT) : new Left((Object)new FaultToleranceTestFail())).flatMap((Function1 & Serializable)x$40 -> {
                BoxedUnit boxedUnit = x$40;
                return ($this.config().mergeKey().isDefined() ? new Right((Object)$this.buildMergeStatement($this.config().tablename(), columnList$1, $this.tempTableName().getFullTableName())) : new Right((Object)"")).map((Function1 & Serializable)mergeStatement -> {
                    BoxedUnit boxedUnit;
                    if ($this.config().mergeKey().isDefined()) {
                        if ($this.logger().underlying().isInfoEnabled()) {
                            $this.logger().underlying().info(new StringBuilder(25).append("The merge statement is: \n").append((String)mergeStatement).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit x$37 = boxedUnit;
                    return new Tuple2(mergeStatement, (Object)x$37);
                }).flatMap((Function1 & Serializable)x$39 -> {
                    Tuple2 tuple2 = x$39;
                    if (tuple2 != null) {
                        String mergeStatement = (String)tuple2._1();
                        return ($this.config().mergeKey().isDefined() ? $this.performMerge(mergeStatement) : new Right((Object)BoxedUnit.UNIT)).map((Function1 & Serializable)x$38 -> {
                            boxedUnit = x$38;
                            return BoxedUnit.UNIT;
                        });
                    }
                    throw new MatchError((Object)tuple2);
                });
            });
        }));
    }

    public static final /* synthetic */ Either $anonfun$commitDataIntoVertica$6(VerticaDistributedFilesystemWritePipe $this, String tableName$1, int tableNameMaxLength$1, String sessionId$1, String columnList$1, String url$1, boolean tempTableExists) {
        return ($this.config().mergeKey().isDefined() && !tempTableExists ? new Left((Object)new CreateTableError((Option<ConnectorError>)None$.MODULE$)) : new Right((Object)BoxedUnit.UNIT)).map((Function1 & Serializable)x$35 -> {
            String rejectsTableName = new StringBuilder(11).append("\"").append(EscapeUtils$.MODULE$.sqlEscape(tableName$1.substring(0, Math.min(tableNameMaxLength$1, tableName$1.length())), EscapeUtils$.MODULE$.sqlEscape$default$2())).append("_").append(sessionId$1).append("_COMMITS").append("\"").toString();
            return new Tuple2(x$35, (Object)rejectsTableName);
        }).flatMap((Function1 & Serializable)x$43 -> {
            Tuple2 tuple2 = x$43;
            if (tuple2 != null) {
                String rejectsTableName = (String)tuple2._2();
                return ($this.config().mergeKey().isDefined() ? new Right((Object)$this.tempTableName().getFullTableName()) : new Right((Object)$this.config().tablename().getFullTableName())).map((Function1 & Serializable)fullTableName -> {
                    BoxedUnit boxedUnit;
                    String copyStatement = $this.buildCopyStatement((String)fullTableName, columnList$1, url$1, rejectsTableName, "parquet");
                    if ($this.logger().underlying().isInfoEnabled()) {
                        $this.logger().underlying().info(new StringBuilder(24).append("The copy statement is: \n").append(copyStatement).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit x$36 = boxedUnit;
                    return new Tuple3(fullTableName, (Object)copyStatement, (Object)x$36);
                }).flatMap((Function1 & Serializable)x$42 -> {
                    Tuple3 tuple3 = x$42;
                    if (tuple3 != null) {
                        String copyStatement = (String)tuple3._2();
                        return ($this.config().mergeKey().isDefined() ? $this.performCopy(copyStatement, $this.tempTableName()).left().map((Function1 & Serializable)x$33 -> x$33.context("commit: Failed to copy rows into temp table")) : $this.performCopy(copyStatement, $this.config().tablename()).left().map((Function1 & Serializable)x$34 -> x$34.context("commit: Failed to copy rows into target table"))).flatMap((Function1 & Serializable)rowsCopied -> VerticaDistributedFilesystemWritePipe.$anonfun$commitDataIntoVertica$13($this, rejectsTableName, columnList$1, BoxesRunTime.unboxToInt((Object)rowsCopied)));
                    }
                    throw new MatchError((Object)tuple3);
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public VerticaDistributedFilesystemWritePipe(DistributedFilesystemWriteConfig config, FileStoreLayerInterface fileStoreLayer, JdbcLayerInterface jdbcLayer, SchemaToolsInterface schemaTools, TableUtilsInterface tableUtils, int dataSize) {
        this.config = config;
        this.fileStoreLayer = fileStoreLayer;
        this.jdbcLayer = jdbcLayer;
        this.schemaTools = schemaTools;
        this.tableUtils = tableUtils;
        this.dataSize = dataSize;
        this.logger = LogProvider$.MODULE$.getLogger(VerticaDistributedFilesystemWritePipe.class);
        this.tempTableName = new TableName(new StringBuilder(1).append(config.tablename().name()).append("_").append(config.sessionId()).toString(), (Option<String>)None$.MODULE$);
        this.LEGACY_PARQUET_REBASE_MODE_IN_WRITE = "spark.sql.legacy.parquet.datetimeRebaseModeInWrite";
        this.LEGACY_PARQUET_INT96_REBASE_MODE_IN_WRITE = "spark.sql.legacy.parquet.int96RebaseModeInWrite";
        this.timer = new Timer(config.timeOperations(), this.logger(), "Writing Partition.");
    }

    private class FaultToleranceTestResult
    implements Product,
    Serializable {
        private final boolean success;
        private final double failedRowsPercent;
        public final /* synthetic */ VerticaDistributedFilesystemWritePipe $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public boolean success() {
            return this.success;
        }

        public double failedRowsPercent() {
            return this.failedRowsPercent;
        }

        public FaultToleranceTestResult copy(boolean success, double failedRowsPercent) {
            return new FaultToleranceTestResult(this.com$vertica$spark$datasource$core$VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$$$outer(), success, failedRowsPercent);
        }

        public boolean copy$default$1() {
            return this.success();
        }

        public double copy$default$2() {
            return this.failedRowsPercent();
        }

        public String productPrefix() {
            return "FaultToleranceTestResult";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return BoxesRunTime.boxToBoolean((boolean)this.success());
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this.failedRowsPercent());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FaultToleranceTestResult;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "success";
                }
                case 1: {
                    return "failedRowsPercent";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.success() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.failedRowsPercent()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FaultToleranceTestResult)) return false;
            if (((FaultToleranceTestResult)object).com$vertica$spark$datasource$core$VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$$$outer() != this.com$vertica$spark$datasource$core$VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FaultToleranceTestResult faultToleranceTestResult = (FaultToleranceTestResult)x$1;
            if (this.success() != faultToleranceTestResult.success()) return false;
            if (this.failedRowsPercent() != faultToleranceTestResult.failedRowsPercent()) return false;
            if (!faultToleranceTestResult.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ VerticaDistributedFilesystemWritePipe com$vertica$spark$datasource$core$VerticaDistributedFilesystemWritePipe$FaultToleranceTestResult$$$outer() {
            return this.$outer;
        }

        public FaultToleranceTestResult(VerticaDistributedFilesystemWritePipe $outer, boolean success, double failedRowsPercent) {
            this.success = success;
            this.failedRowsPercent = failedRowsPercent;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

