/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.spark.datasource.core.factory;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.Logger$;
import com.vertica.spark.config.DistributedFilesystemReadConfig;
import com.vertica.spark.config.DistributedFilesystemWriteConfig;
import com.vertica.spark.config.JDBCConfig;
import com.vertica.spark.config.ReadConfig;
import com.vertica.spark.config.WriteConfig;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemReadPipe$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipe;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipe$;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipeLegacy;
import com.vertica.spark.datasource.core.VerticaDistributedFilesystemWritePipeLegacy$;
import com.vertica.spark.datasource.core.VerticaPipeInterface;
import com.vertica.spark.datasource.core.factory.VerticaPipeFactoryInterface;
import com.vertica.spark.datasource.fs.HadoopFileStoreLayer;
import com.vertica.spark.datasource.fs.HadoopFileStoreLayer$;
import com.vertica.spark.datasource.jdbc.JdbcLayerInterface;
import com.vertica.spark.datasource.jdbc.VerticaJdbcLayer;
import com.vertica.spark.util.cleanup.CleanupUtils;
import com.vertica.spark.util.error.ConnectorError;
import com.vertica.spark.util.listeners.SparkContextWrapper;
import com.vertica.spark.util.schema.SchemaTools;
import com.vertica.spark.util.schema.SchemaTools$;
import com.vertica.spark.util.schema.SchemaToolsV10;
import com.vertica.spark.util.table.TableUtils;
import com.vertica.spark.util.version.Version;
import com.vertica.spark.util.version.VerticaVersionUtils$;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.StructType;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.util.Either;

public final class VerticaPipeFactory$
implements VerticaPipeFactoryInterface {
    public static final VerticaPipeFactory$ MODULE$ = new VerticaPipeFactory$();
    private static final Logger logger = Logger$.MODULE$.apply(MODULE$.getClass().getName());
    private static Option<VerticaJdbcLayer> readLayerJdbc = None$.MODULE$;
    private static Option<VerticaJdbcLayer> writeLayerJdbc = None$.MODULE$;

    private Logger logger() {
        return logger;
    }

    private Option<VerticaJdbcLayer> readLayerJdbc() {
        return readLayerJdbc;
    }

    private void readLayerJdbc_$eq(Option<VerticaJdbcLayer> x$1) {
        readLayerJdbc = x$1;
    }

    private Option<VerticaJdbcLayer> writeLayerJdbc() {
        return writeLayerJdbc;
    }

    private void writeLayerJdbc_$eq(Option<VerticaJdbcLayer> x$1) {
        writeLayerJdbc = x$1;
    }

    private Option<VerticaJdbcLayer> checkJdbcLayer(Option<VerticaJdbcLayer> jdbcLayer, JDBCConfig jdbcConfig) {
        Option<VerticaJdbcLayer> option = jdbcLayer;
        if (option instanceof Some) {
            Some some = (Some)option;
            VerticaJdbcLayer layer = (VerticaJdbcLayer)some.value();
            if (layer.isClosed()) {
                return new Some((Object)new VerticaJdbcLayer(jdbcConfig));
            }
            return jdbcLayer;
        }
        if (None$.MODULE$.equals(option)) {
            return new Some((Object)new VerticaJdbcLayer(jdbcConfig));
        }
        throw new MatchError(option);
    }

    private void closeJdbcLayer(Option<VerticaJdbcLayer> jdbcLayer) {
        Option<VerticaJdbcLayer> option = jdbcLayer;
        if (option instanceof Some) {
            Some some = (Some)option;
            VerticaJdbcLayer layer = (VerticaJdbcLayer)some.value();
            Either<ConnectorError, BoxedUnit> either = layer.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public VerticaPipeInterface getReadPipe(ReadConfig config, boolean getVersion) {
        BoxedUnit boxedUnit;
        String thread = new StringBuilder(2).append(Thread.currentThread().getName()).append(": ").toString();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(17).append(thread).append("Getting read pipe").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ReadConfig readConfig = config;
        if (readConfig instanceof DistributedFilesystemReadConfig) {
            None$ none$;
            DistributedFilesystemReadConfig distributedFilesystemReadConfig = (DistributedFilesystemReadConfig)readConfig;
            HadoopFileStoreLayer hadoopFileStoreLayer = HadoopFileStoreLayer$.MODULE$.make(distributedFilesystemReadConfig);
            this.readLayerJdbc_$eq(this.checkJdbcLayer(this.readLayerJdbc(), distributedFilesystemReadConfig.jdbcConfig()));
            Option option = SparkSession$.MODULE$.getActiveSession();
            if (None$.MODULE$.equals(option)) {
                none$ = None$.MODULE$;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                SparkSession session = (SparkSession)some.value();
                none$ = new Some((Object)session.sparkContext());
            } else {
                throw new MatchError((Object)option);
            }
            None$ sparkContext = none$;
            Version verticaVersion = getVersion ? VerticaVersionUtils$.MODULE$.getVersionOrDefault((JdbcLayerInterface)this.readLayerJdbc().get()) : VerticaVersionUtils$.MODULE$.VERTICA_DEFAULT();
            SchemaTools schemaTools = verticaVersion.$less(VerticaVersionUtils$.MODULE$.VERTICA_11()) ? new SchemaToolsV10() : new SchemaTools(SchemaTools$.MODULE$.$lessinit$greater$default$1());
            return new VerticaDistributedFilesystemReadPipe(distributedFilesystemReadConfig, hadoopFileStoreLayer, (JdbcLayerInterface)this.readLayerJdbc().get(), schemaTools, new CleanupUtils(), new SparkContextWrapper((Option<SparkContext>)sparkContext), VerticaDistributedFilesystemReadPipe$.MODULE$.$lessinit$greater$default$7());
        }
        throw new MatchError((Object)readConfig);
    }

    @Override
    public VerticaPipeInterface getWritePipe(WriteConfig config, boolean getVersion) {
        BoxedUnit boxedUnit;
        String thread = new StringBuilder(2).append(Thread.currentThread().getName()).append(": ").toString();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder(18).append(thread).append("Getting write pipe").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        WriteConfig writeConfig = config;
        if (writeConfig instanceof DistributedFilesystemWriteConfig) {
            SchemaTools schemaTools;
            DistributedFilesystemWriteConfig distributedFilesystemWriteConfig = (DistributedFilesystemWriteConfig)writeConfig;
            this.writeLayerJdbc_$eq(this.checkJdbcLayer(this.writeLayerJdbc(), distributedFilesystemWriteConfig.jdbcConfig()));
            VerticaJdbcLayer jdbcLayer = (VerticaJdbcLayer)this.writeLayerJdbc().get();
            Version verticaVersion = getVersion ? VerticaVersionUtils$.MODULE$.getVersionOrDefault(jdbcLayer) : VerticaVersionUtils$.MODULE$.VERTICA_DEFAULT();
            SchemaTools schemaTools2 = schemaTools = verticaVersion.$less(VerticaVersionUtils$.MODULE$.VERTICA_11()) ? new SchemaToolsV10() : new SchemaTools(SchemaTools$.MODULE$.$lessinit$greater$default$1());
            if (verticaVersion.$greater$eq(VerticaVersionUtils$.MODULE$.VERTICA_11_1_1())) {
                return new VerticaDistributedFilesystemWritePipe(distributedFilesystemWriteConfig, new HadoopFileStoreLayer(distributedFilesystemWriteConfig.fileStoreConfig(), (Option<StructType>)new Some((Object)distributedFilesystemWriteConfig.schema())), jdbcLayer, schemaTools, new TableUtils(schemaTools, jdbcLayer), VerticaDistributedFilesystemWritePipe$.MODULE$.$lessinit$greater$default$6());
            }
            return new VerticaDistributedFilesystemWritePipeLegacy(distributedFilesystemWriteConfig, new HadoopFileStoreLayer(distributedFilesystemWriteConfig.fileStoreConfig(), (Option<StructType>)new Some((Object)distributedFilesystemWriteConfig.schema())), jdbcLayer, schemaTools, new TableUtils(schemaTools, jdbcLayer), VerticaDistributedFilesystemWritePipeLegacy$.MODULE$.$lessinit$greater$default$6());
        }
        throw new MatchError((Object)writeConfig);
    }

    @Override
    public void closeJdbcLayers() {
        this.closeJdbcLayer(this.readLayerJdbc());
        this.closeJdbcLayer(this.writeLayerJdbc());
    }

    private VerticaPipeFactory$() {
    }
}

